
/*

  OpenSSL interface description file for SWIG. requires a SWIG
  release later than v1.1 build 737 (19990408) (aspa@hip.fi).

  $Id: OpenSSL.i,v 1.8 1999/07/22 15:59:01 aspa Exp $.

  $VERSION = '0.21';


  this interface has been succesfully compiled with OpenSSL
  v0.9.1c and SNAP-19990711.

*/

%module OpenSSL


/*

  NOTES:
  ======
  * default 'char *' argument typemaps in perl5
    - SWIG interprets input 'char *' arguments as strings. this
      interpretation can result in segmentation faults when passing
      buffer pointers of 'char *' type. use 'void *' type instead.
    - output 'char *' arguments are converted to perl strings (PV)
      using sv_setpv() (which uses strlen()). this conversion can
      lead to segmentation faults or data loss when the buffer
      isn't NULL terminated or contains NULL values, respectively.

  TODO:
  =====
  * verify callback function calls

*/


%{

  /*
    OpenSSL interface wrapper file (aspa@hip.fi).
  */

#include <errno.h>
#include <ssl.h>

// SSIZE_MAX
#define OSSL_BUF_SIZE 32768
#define OSSL_STR_SIZE 256


/* make swig handle the function pointers. */
typedef int (*callback_ptr_t)();


/* language (perl, tcl, python) specific stuff */
#ifdef SWIGPERL5
   ; 
#elif SWIGTCL8
   ;
#elif SWIGPYTHON
   ;
#else
   ; 
#endif

%}

/*
  %%%%%%%%%% type & typemap definitions %%%%%%%%%%
*/

/* make swig handle the function pointers. */
typedef int (*callback_ptr_t)();


/* the next two typemaps are for SSL_read(). they are necessary
   for handling read data that contains 0 values. */

%typemap(perl5, ignore) char **SSL_read_buf_p(char *bufp) {
  bufp = NULL;
  $target = &bufp;
}

%typemap(perl5, argout) char **SSL_read_buf_p {
  $target = sv_newmortal();
  if( _result >= 0)
    sv_setpvn((SV *) $target, *_arg0, _result);
  argvi++;
}

/*
  %%%%%%%%%% inline function definitions %%%%%%%%%%
*/


%inline %{

  /* SSL_CTX_set_options_W() and SSL_set_options_W() are defined as
     functions because SWIG can't handle function macros. */

  // ssl/ssl.h
  void SSL_CTX_set_options_W(SSL_CTX *ctx, unsigned long int op) {
    ctx->options |= op;
  }
  
  // ssl/ssl.h
  void SSL_set_options_W(SSL *ssl, unsigned long int op) {
    ssl->options |= op;
  }

  /* the X509_NAME_oneline_W() and SSL_read_W() functions need
     wrappers for buffer management. */

  // crypto/x509/x509_obj.c.
  char *X509_NAME_oneline_W(X509_NAME *a) {
    static char str_buf[OSSL_STR_SIZE];
    
    return X509_NAME_oneline(a, str_buf, OSSL_STR_SIZE);
  }

  // ssl/bio_ssl.c: ssl_read.
  int SSL_read_W(char **SSL_read_buf_p, SSL *ssl, int max_bytes) {
    static char buffer[OSSL_BUF_SIZE];
    int n;
    
    n = SSL_read(ssl, buffer, max_bytes);
    *SSL_read_buf_p = buffer;

    return n;
  }


%}



/*

  %%%%%%%%%% declarations from the OpenSSL header files %%%%%%%%%%
  (the declarations are copied almost unmodified.)

  modified declarations: SSL_CTX_set_verify, SSL_set_verify.
  
*/


// from include/err.h
unsigned long ERR_get_error(void );
char *ERR_error_string(unsigned long e, char *buf);

/* from x509.h */
#define X509_FILETYPE_PEM       1
#define X509_FILETYPE_ASN1      2
#define X509_FILETYPE_DEFAULT   3

void X509_NAME_free(X509_NAME *a);
void X509_free(X509 *a);
char *X509_NAME_oneline(X509_NAME *a,char *buf,int size);
X509_NAME *X509_get_issuer_name(X509 *a);
X509_NAME *X509_get_subject_name(X509 *a);


/* from ssl.h */
#define SSL_FILETYPE_ASN1       X509_FILETYPE_ASN1
#define SSL_FILETYPE_PEM        X509_FILETYPE_PEM

#define SSL_OP_ALL                                      0x000FFFFFL


/* swig doesn't understand function macros */
// void SSL_CTX_set_options(SSL_CTX ctx, unsigned long int op);
// void SSL_set_options(SSL ssl, unsigned long int op);

#define SSL_VERIFY_NONE                 0x00
#define SSL_VERIFY_PEER                 0x01
#define SSL_VERIFY_FAIL_IF_NO_PEER_CERT 0x02
#define SSL_VERIFY_CLIENT_ONCE          0x04

SSL_CTX *SSL_CTX_new(SSL_METHOD *meth);
void     SSL_CTX_free(SSL_CTX *);

SSL_CIPHER * SSL_get_current_cipher(SSL *s);
char *       SSL_CIPHER_get_name(SSL_CIPHER *c);

int SSL_set_fd(SSL *s, int fd);

int     SSL_set_cipher_list(SSL *s, char *str);

int     SSL_CTX_use_RSAPrivateKey_file(SSL_CTX *ctx, char *file, int type);
int     SSL_CTX_use_certificate_file(SSL_CTX *ctx, char *file, int type);

void    SSL_load_error_strings(void );

X509 *  SSL_get_peer_certificate(SSL *s);

int SSL_CTX_get_verify_mode(SSL_CTX *ctx);
void SSL_CTX_set_verify(SSL_CTX *ctx,int mode, callback_ptr_t cp);

void    SSL_set_verify(SSL *s, int mode, callback_ptr_t cp);

SSL *   SSL_new(SSL_CTX *ctx);
void    SSL_free(SSL *ssl);
int     SSL_accept(SSL *ssl);
int     SSL_connect(SSL *ssl);
int     SSL_read(SSL *ssl,char *buf,int num);
int     SSL_write(SSL *ssl,char *buf,int num);

int     SSL_get_error(SSL *s,int ret_code);

SSL_METHOD *SSLv2_method(void);
SSL_METHOD *SSLv3_method(void);
SSL_METHOD *SSLv23_method(void);
SSL_METHOD *TLSv1_method(void);

void SSLeay_add_ssl_algorithms(void );

int SSL_CTX_load_verify_locations(SSL_CTX *ctx,char *CAfile,char *CApath);
