package YAPC;

use strict;
$YAPC::VERSION = '1.01';
1;
__END__

=head1 NAME

YAPC - Yet Another Perl Conference information and documentation

=head1 SYNOPSIS

Organize an open source conference.

=head1 DESCRIPTION

This module contains documentation and some support code for proposing,
planning, and executing a technical conference.  While the specifics
are relevant to a series of conferences supported by the Yet Another
Society, the content may be informative for any group with an interest
in promoting collaborative efforts and discussion on a focused 
technical topic.  

The intended audience is a small but dedicated crew that would intend
to take on such an event as the Yet Another Perl Conference, a
grass-roots conference and symposium series on the Perl programming
language.  These conferences have been carried out in a stronghold of
interest by small local core groups, with the aid of the local users
groups and members of the community.

=head1 SPONSORSHIP

Corporate sponsorship is used to lower the cost of participation and
raise the quality of the services offered, in return for good will,
recognition, and the ability to help create the atmosphere where
conversations can flourish, and keep the endeavor vital.

=head1 HISTORY

The first Yet Another Perl Conference was held in Pittsburgh, PA at
Carnegie Mellon University in 1999, and had about 275 participants.
The event was attended by a small but mighty group of interested and
interesting Perl people, including Larry Wall, who delivered to
opening keynote on the first day of the two-day event.

The event was such a success that it was repeated, again at Carnegie
Mellon University, in 2000 -- and dubbed YAPC North America 19100, in
honor of all the "year 2000" concerns of the time.  Attendance was
some three hundred and fifty people.

Leon Brocard and Greg McCarroll took it on themselves to carry out the
first European YAPC in 2000 also, at the Institute for Contemporary
Arts (ICA) in London, with the theme "The Art of Perl."  Some two
hundred people attended, and volunteers from London and surrounding
areas helped in force.

In 2001, YAPC North America left Pittsburgh for Montreal, where 
Richard Lafferty and Luc St-Louis chaired the conference at the 
University of Montreal. About four hundred and twenty people attended.
Once again, local groups turned out in numbers to volunteer for
any and all tasks. 

The European YAPC went into another strong year with YAPC::Europe 2001
at Hogeschool Holland, Amsterdam, with a Security theme.  Ann Barcomb,
Jouke Visser, and a large and dedicated crew from the Netherlands,
created an excellent atmosphere for both talks and discussion, raising
the overall standard once again.

=head1 AUTHOR

Kevin A. Lenzo <lenzo@yetanother.org>. 

Copyright (C) 2000, 2001 Yet Another Society.  Free use and
redistribution of this document is encouraged under the same terms as
Perl itself.

=head1 SEE ALSO

YAPC::Venue, perl(1).

=cut
