# Generated by default/object.tt
package Paws::LakeFormation::TaggedTable;
  use Moose;
  has LFTagOnDatabase => (is => 'ro', isa => 'ArrayRef[Paws::LakeFormation::LFTagPair]');
  has LFTagsOnColumns => (is => 'ro', isa => 'ArrayRef[Paws::LakeFormation::ColumnLFTag]');
  has LFTagsOnTable => (is => 'ro', isa => 'ArrayRef[Paws::LakeFormation::LFTagPair]');
  has Table => (is => 'ro', isa => 'Paws::LakeFormation::TableResource');

1;

### main pod documentation begin ###

=head1 NAME

Paws::LakeFormation::TaggedTable

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::LakeFormation::TaggedTable object:

  $service_obj->Method(Att1 => { LFTagOnDatabase => $value, ..., Table => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::LakeFormation::TaggedTable object:

  $result = $service_obj->Method(...);
  $result->Att1->LFTagOnDatabase

=head1 DESCRIPTION

A structure describing a table resource with tags.

=head1 ATTRIBUTES


=head2 LFTagOnDatabase => ArrayRef[L<Paws::LakeFormation::LFTagPair>]

A list of tags attached to the database where the table resides.


=head2 LFTagsOnColumns => ArrayRef[L<Paws::LakeFormation::ColumnLFTag>]

A list of tags attached to columns in the table.


=head2 LFTagsOnTable => ArrayRef[L<Paws::LakeFormation::LFTagPair>]

A list of tags attached to the table.


=head2 Table => L<Paws::LakeFormation::TableResource>

A table that has tags attached to it.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::LakeFormation>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

