# Generated by default/object.tt
package Paws::Connect::UseCase;
  use Moose;
  has UseCaseArn => (is => 'ro', isa => 'Str');
  has UseCaseId => (is => 'ro', isa => 'Str');
  has UseCaseType => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::Connect::UseCase

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::Connect::UseCase object:

  $service_obj->Method(Att1 => { UseCaseArn => $value, ..., UseCaseType => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::Connect::UseCase object:

  $result = $service_obj->Method(...);
  $result->Att1->UseCaseArn

=head1 DESCRIPTION

Contains the use case.

=head1 ATTRIBUTES


=head2 UseCaseArn => Str

The Amazon Resource Name (ARN) for the use case.


=head2 UseCaseId => Str

The identifier for the use case.


=head2 UseCaseType => Str

The type of use case to associate to the AppIntegration association.
Each AppIntegration association can have only one of each use case
type.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::Connect>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

