/*
 * Decompiled with CFR 0.152.
 */
package de.l3s.boilerpipe.sax;

import de.l3s.boilerpipe.sax.HTMLDocument;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import java.util.zip.GZIPInputStream;

public class HTMLFetcher {
    private HTMLFetcher() {
    }

    public static HTMLDocument fetch(URL url) throws IOException {
        int r;
        URLConnection conn = url.openConnection();
        String charset = conn.getContentEncoding();
        Charset cs = Charset.forName("Cp1252");
        if (charset != null) {
            try {
                cs = Charset.forName(charset);
            }
            catch (UnsupportedCharsetException e) {
                // empty catch block
            }
        }
        InputStream in = conn.getInputStream();
        String encoding = conn.getContentEncoding();
        if (encoding != null) {
            if ("gzip".equalsIgnoreCase(encoding)) {
                in = new GZIPInputStream(in);
            } else {
                System.err.println("WARN: unsupported Content-Encoding: " + encoding);
            }
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        byte[] buf = new byte[4096];
        while ((r = in.read(buf)) != -1) {
            bos.write(buf, 0, r);
        }
        in.close();
        byte[] data = bos.toByteArray();
        return new HTMLDocument(data, cs);
    }
}

