/*
 * Decompiled with CFR 0.152.
 */
package javax.media.jai.operator;

import java.awt.RenderingHints;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import java.awt.image.renderable.RenderableImage;
import javax.media.jai.JAI;
import javax.media.jai.OperationDescriptorImpl;
import javax.media.jai.ParameterBlockJAI;
import javax.media.jai.PropertyGenerator;
import javax.media.jai.RenderableOp;
import javax.media.jai.RenderedOp;
import javax.media.jai.operator.ComplexPropertyGenerator;
import javax.media.jai.operator.JaiI18N;

public class ConjugateDescriptor
extends OperationDescriptorImpl {
    private static final String[][] resources = new String[][]{{"GlobalName", "Conjugate"}, {"LocalName", "Conjugate"}, {"Vendor", "com.sun.media.jai"}, {"Description", JaiI18N.getString("ConjugateDescriptor0")}, {"DocURL", "http://java.sun.com/products/java-media/jai/forDevelopers/jai-apidocs/javax/media/jai/operator/ConjugateDescriptor.html"}, {"Version", JaiI18N.getString("DescriptorVersion")}};
    private static final String[] supportedModes = new String[]{"rendered", "renderable"};

    public ConjugateDescriptor() {
        super(resources, supportedModes, 1, null, null, null, null);
    }

    public PropertyGenerator[] getPropertyGenerators(String string) {
        PropertyGenerator[] propertyGeneratorArray = new PropertyGenerator[]{new ComplexPropertyGenerator()};
        return propertyGeneratorArray;
    }

    protected boolean validateSources(String string, ParameterBlock parameterBlock, StringBuffer stringBuffer) {
        if (!super.validateSources(string, parameterBlock, stringBuffer)) {
            return false;
        }
        if (!string.equalsIgnoreCase("rendered")) {
            return true;
        }
        RenderedImage renderedImage = parameterBlock.getRenderedSource(0);
        if (renderedImage.getSampleModel().getNumBands() % 2 != 0) {
            stringBuffer.append(this.getName() + " " + JaiI18N.getString("ConjugateDescriptor1"));
            return false;
        }
        return true;
    }

    public static RenderedOp create(RenderedImage renderedImage, RenderingHints renderingHints) {
        ParameterBlockJAI parameterBlockJAI = new ParameterBlockJAI("Conjugate", "rendered");
        parameterBlockJAI.setSource("source0", renderedImage);
        return JAI.create("Conjugate", parameterBlockJAI, renderingHints);
    }

    public static RenderableOp createRenderable(RenderableImage renderableImage, RenderingHints renderingHints) {
        ParameterBlockJAI parameterBlockJAI = new ParameterBlockJAI("Conjugate", "renderable");
        parameterBlockJAI.setSource("source0", renderableImage);
        return JAI.createRenderable("Conjugate", parameterBlockJAI, renderingHints);
    }
}

