/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.util.operator.pagedrawer;

import java.awt.BasicStroke;
import java.awt.Graphics2D;
import java.io.IOException;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.pdfviewer.PageDrawer;
import org.apache.pdfbox.util.Matrix;
import org.apache.pdfbox.util.PDFOperator;
import org.apache.pdfbox.util.operator.OperatorProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StrokePath
extends OperatorProcessor {
    private static final Log log = LogFactory.getLog(StrokePath.class);

    @Override
    public void process(PDFOperator operator, List<COSBase> arguments) throws IOException {
        try {
            Graphics2D graphics;
            BasicStroke stroke;
            PageDrawer drawer = (PageDrawer)this.context;
            float lineWidth = (float)this.context.getGraphicsState().getLineWidth();
            Matrix ctm = this.context.getGraphicsState().getCurrentTransformationMatrix();
            if (ctm != null && ctm.getXScale() > 0.0f) {
                lineWidth *= ctm.getXScale();
            }
            if ((stroke = (BasicStroke)(graphics = ((PageDrawer)this.context).getGraphics()).getStroke()) == null) {
                graphics.setStroke(new BasicStroke(lineWidth));
            } else {
                graphics.setStroke(new BasicStroke(lineWidth, stroke.getEndCap(), stroke.getLineJoin(), stroke.getMiterLimit(), stroke.getDashArray(), stroke.getDashPhase()));
            }
            drawer.strokePath();
        }
        catch (Exception exception) {
            log.warn((Object)exception, (Throwable)exception);
        }
    }
}

