/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.pdf;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSString;
import org.apache.pdfbox.io.RandomAccessFile;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDDocumentCatalog;
import org.apache.pdfbox.pdmodel.PDDocumentInformation;
import org.apache.pdfbox.pdmodel.PDDocumentNameDictionary;
import org.apache.pdfbox.pdmodel.PDEmbeddedFilesNameTreeNode;
import org.apache.pdfbox.pdmodel.common.filespecification.PDComplexFileSpecification;
import org.apache.pdfbox.pdmodel.common.filespecification.PDEmbeddedFile;
import org.apache.tika.exception.TikaException;
import org.apache.tika.extractor.EmbeddedDocumentExtractor;
import org.apache.tika.extractor.ParsingEmbeddedDocumentExtractor;
import org.apache.tika.io.CloseShieldInputStream;
import org.apache.tika.io.TemporaryResources;
import org.apache.tika.io.TikaInputStream;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.metadata.PagedText;
import org.apache.tika.metadata.Property;
import org.apache.tika.metadata.TikaCoreProperties;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.AbstractParser;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.PasswordProvider;
import org.apache.tika.parser.pdf.PDF2XHTML;
import org.apache.tika.sax.EmbeddedContentHandler;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PDFParser
extends AbstractParser {
    private static final long serialVersionUID = -752276948656079347L;
    private boolean enableAutoSpace = true;
    private boolean suppressDuplicateOverlappingText;
    private boolean extractAnnotationText = true;
    private boolean sortByPosition = false;
    public static final String PASSWORD = "org.apache.tika.parser.pdf.password";
    private static final Set<MediaType> SUPPORTED_TYPES = Collections.singleton(MediaType.application("pdf"));

    @Override
    public Set<MediaType> getSupportedTypes(ParseContext context) {
        return SUPPORTED_TYPES;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void parse(InputStream stream, ContentHandler handler, Metadata metadata, ParseContext context) throws IOException, SAXException, TikaException {
        PDDocument pdfDocument = null;
        TemporaryResources tmp = new TemporaryResources();
        try {
            TikaInputStream tstream = TikaInputStream.cast(stream);
            if (tstream != null && tstream.hasFile()) {
                RandomAccessFile scratchFile = new RandomAccessFile(tmp.createTemporaryFile(), "rw");
                pdfDocument = PDDocument.load(new CloseShieldInputStream(stream), scratchFile, true);
            } else {
                pdfDocument = PDDocument.load((InputStream)new CloseShieldInputStream(stream), true);
            }
            if (pdfDocument.isEncrypted()) {
                String password = null;
                PasswordProvider passwordProvider = context.get(PasswordProvider.class);
                if (passwordProvider != null) {
                    password = passwordProvider.getPassword(metadata);
                }
                if (password == null && metadata.get(PASSWORD) != null) {
                    password = metadata.get(PASSWORD);
                }
                if (password == null) {
                    password = "";
                }
                try {
                    pdfDocument.decrypt(password);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            metadata.set("Content-Type", "application/pdf");
            this.extractMetadata(pdfDocument, metadata);
            PDF2XHTML.process(pdfDocument, handler, metadata, this.extractAnnotationText, this.enableAutoSpace, this.suppressDuplicateOverlappingText, this.sortByPosition);
            this.extractEmbeddedDocuments(context, pdfDocument, handler);
        }
        finally {
            if (pdfDocument != null) {
                pdfDocument.close();
            }
            tmp.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void extractEmbeddedDocuments(ParseContext context, PDDocument document, ContentHandler handler) throws IOException, SAXException, TikaException {
        PDEmbeddedFilesNameTreeNode embeddedFiles;
        PDDocumentCatalog catalog = document.getDocumentCatalog();
        PDDocumentNameDictionary names = catalog.getNames();
        if (names != null && (embeddedFiles = names.getEmbeddedFiles()) != null) {
            Map<String, Object> embeddedFileNames;
            EmbeddedDocumentExtractor embeddedExtractor = context.get(EmbeddedDocumentExtractor.class);
            if (embeddedExtractor == null) {
                embeddedExtractor = new ParsingEmbeddedDocumentExtractor(context);
            }
            if ((embeddedFileNames = embeddedFiles.getNames()) != null) {
                for (Map.Entry<String, Object> ent : embeddedFileNames.entrySet()) {
                    PDComplexFileSpecification spec = (PDComplexFileSpecification)ent.getValue();
                    PDEmbeddedFile file = spec.getEmbeddedFile();
                    Metadata metadata = new Metadata();
                    metadata.set("resourceName", ent.getKey());
                    metadata.set("Content-Type", file.getSubtype());
                    metadata.set("Content-Length", Long.toString(file.getSize()));
                    if (!embeddedExtractor.shouldParseEmbedded(metadata)) continue;
                    TikaInputStream stream = TikaInputStream.get(file.createInputStream());
                    try {
                        embeddedExtractor.parseEmbedded(stream, new EmbeddedContentHandler(handler), metadata, false);
                    }
                    finally {
                        stream.close();
                    }
                }
            }
        }
    }

    private void extractMetadata(PDDocument document, Metadata metadata) throws TikaException {
        PDDocumentInformation info = document.getDocumentInformation();
        metadata.set(PagedText.N_PAGES, document.getNumberOfPages());
        this.addMetadata(metadata, TikaCoreProperties.TITLE, info.getTitle());
        this.addMetadata(metadata, TikaCoreProperties.CREATOR, info.getAuthor());
        this.addMetadata(metadata, TikaCoreProperties.CREATOR_TOOL, info.getCreator());
        this.addMetadata(metadata, TikaCoreProperties.KEYWORDS, info.getKeywords());
        this.addMetadata(metadata, "producer", info.getProducer());
        this.addMetadata(metadata, TikaCoreProperties.TRANSITION_SUBJECT_TO_OO_SUBJECT, info.getSubject());
        this.addMetadata(metadata, "trapped", info.getTrapped());
        try {
            this.addMetadata(metadata, "created", info.getCreationDate());
            this.addMetadata(metadata, TikaCoreProperties.CREATED, info.getCreationDate());
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            Calendar modified = info.getModificationDate();
            this.addMetadata(metadata, Metadata.LAST_MODIFIED, modified);
            this.addMetadata(metadata, TikaCoreProperties.MODIFIED, modified);
        }
        catch (IOException e) {
            // empty catch block
        }
        List<String> handledMetadata = Arrays.asList("Author", "Creator", "CreationDate", "ModDate", "Keywords", "Producer", "Subject", "Title", "Trapped");
        for (COSName key : info.getDictionary().keySet()) {
            String name = key.getName();
            if (handledMetadata.contains(name)) continue;
            this.addMetadata(metadata, name, info.getDictionary().getDictionaryObject(key));
        }
    }

    private void addMetadata(Metadata metadata, Property property, String value) {
        if (value != null) {
            metadata.add(property, value);
        }
    }

    private void addMetadata(Metadata metadata, String name, String value) {
        if (value != null) {
            metadata.add(name, value);
        }
    }

    private void addMetadata(Metadata metadata, String name, Calendar value) {
        if (value != null) {
            metadata.set(name, value.getTime().toString());
        }
    }

    private void addMetadata(Metadata metadata, Property property, Calendar value) {
        if (value != null) {
            metadata.set(property, value.getTime());
        }
    }

    private void addMetadata(Metadata metadata, String name, COSBase value) {
        if (value instanceof COSArray) {
            for (COSBase v : ((COSArray)value).toList()) {
                this.addMetadata(metadata, name, v);
            }
        } else if (value instanceof COSString) {
            this.addMetadata(metadata, name, ((COSString)value).getString());
        } else {
            this.addMetadata(metadata, name, value.toString());
        }
    }

    public void setEnableAutoSpace(boolean v) {
        this.enableAutoSpace = v;
    }

    public boolean getEnableAutoSpace() {
        return this.enableAutoSpace;
    }

    public void setExtractAnnotationText(boolean v) {
        this.extractAnnotationText = v;
    }

    public boolean getExtractAnnotationText() {
        return this.extractAnnotationText;
    }

    public void setSuppressDuplicateOverlappingText(boolean v) {
        this.suppressDuplicateOverlappingText = v;
    }

    public boolean getSuppressDuplicateOverlappingText() {
        return this.suppressDuplicateOverlappingText;
    }

    public void setSortByPosition(boolean v) {
        this.sortByPosition = v;
    }

    public boolean getSortByPosition() {
        return this.sortByPosition;
    }
}

