/*
 * Decompiled with CFR 0.152.
 */
package org.couchbase.mock.memcached.protocol;

import java.net.ProtocolException;
import java.nio.ByteBuffer;
import org.couchbase.mock.memcached.protocol.ComCode;

public class BinaryCommand {
    protected final ComCode cc;
    protected final short keylen;
    protected final byte extlen;
    protected final short vbucket;
    protected final int bodylen;
    protected final int opaque;
    protected final long cas;
    protected final ByteBuffer bodyBuffer;

    protected BinaryCommand(ByteBuffer header) throws ProtocolException {
        header.rewind();
        header.get();
        this.cc = ComCode.valueOf(header.get());
        this.keylen = header.getShort();
        this.extlen = header.get();
        if (header.get() != 0) {
            throw new ProtocolException("Illegal datatype");
        }
        this.vbucket = header.getShort();
        this.bodylen = header.getInt();
        this.opaque = header.getInt();
        this.cas = header.getLong();
        this.bodyBuffer = this.bodylen > 0 ? ByteBuffer.allocate(this.bodylen) : null;
    }

    public ByteBuffer getInputBuffer() {
        return this.bodyBuffer;
    }

    public ComCode getComCode() {
        return this.cc;
    }

    public int getOpaque() {
        return this.opaque;
    }

    public short getVBucketId() {
        return this.vbucket;
    }

    public long getCas() {
        return this.cas;
    }

    public String getKey() {
        if (this.keylen == 0) {
            return null;
        }
        return new String(this.bodyBuffer.array(), (int)this.extlen, (int)this.keylen);
    }

    public byte[] getValue() {
        byte[] ret = new byte[this.bodylen - this.extlen - this.keylen];
        System.arraycopy(this.bodyBuffer.array(), this.extlen + this.keylen, ret, 0, ret.length);
        return ret;
    }

    public boolean complete() {
        return this.bodylen == 0 || !this.bodyBuffer.hasRemaining();
    }
}

