[= AutoGen5 template -*- Mode: texinfo -*-

texi

#  Documentation template
#
#  This file is part of AutoOpts, a companion to AutoGen.
#  AutoOpts is free software.
#  AutoOpts is Copyright (C) 1992-2013 by Bruce Korb - all rights reserved
#
#  AutoOpts is available under any one of two licenses.  The license
#  in use must be one of these two and the choice is under the control
#  of the user of the license.
#
#   The GNU Lesser General Public License, version 3 or later
#      See the files "COPYING.lgplv3" and "COPYING.gplv3"
#
#   The Modified Berkeley Software Distribution License
#      See the file "COPYING.mbsd"
#
#  These files have the following sha256 sums:
#
#  8584710e9b04216a394078dc156b781d0b47e1729104d666658aecef8ee32e95  COPYING.gplv3
#  4379e7444a0e2ce2b12dd6f5a52a27a4d02d39d247901d3285c88cf0d37f477b  COPYING.lgplv3
#  13aa749a5b0a454917a944ed8fffc530b784f5ead522b1aacaf4ec8aa55a6239  COPYING.mbsd

=][=

INVOKE initialization                   =][=

(out-push-new (string-substitute (out-name) ".texi" ".menu"))

(ag-fprintf 0 "* %-32s Notes about %s\n"
    (string-append program-name " Notes::")
    program-name )

(out-pop)
(if (exist? "explain")
    (emit (string-append "\n" (get "explain") "\n")) )
(set! tmp-str (get "option-doc-format" "texi"))
(divert-convert tmp-str)

=][=

IF (match-value? == "doc-section.ds-type" "DESCRIPTION") =][=

  FOR doc-section   =][=
    IF (== (get "ds-type") "DESCRIPTION") =][=
       (define cvt-fn (get "ds-format" "texi"))
       (if (not (== cvt-fn "texi"))
           (divert-convert cvt-fn) ) =][=
       (emit (string-append "\n" (get "ds-text") "\n"))
       =][=
       BREAK        =][=

    ENDIF           =][=
  ENDFOR            =][=

ELSE                =][=

(join "\n\n"
    (if (exist? "prog-info-descrip")
        (stack  "prog-info-descrip")
        (if (exist? "prog-man-descrip")
            (stack  "prog-man-descrip")
            (if (exist? "prog-descrip")
                (stack  "prog-descrip")
                (stack  "detail")
)   )   )   )       =][=

ENDIF               =][=

(convert-divert)    =]

This [=(string-downcase doc-level)=] was generated by @strong{AutoGen},
using the @code{agtexi-cmd} template and the option descriptions for the [=(.
coded-prog-name)=] program.[= (name-copyright) =]

@menu
[=
  (out-push-new) (out-suspend "menu")
  (out-push-new)
  (define label-str (string-append
          program-name " help/usage Something"))
                    =][=#

@c = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = =][=

FOR flag                        =][=

  (set! opt-name (string-tr! (get "name") optname-from optname-to))
  (if (exist? "documentation")
      (begin
          (set! label-str (string-append opt-name " options"))
          (ag-fprintf "menu" menu-entry-fmt
              (string-append opt-name ":: ") label-str)
          (print-node opt-name label-str)
          (ag-fprintf 0 "\n%s." (get "descrip"))
          (set! tmp-str (get "documentation"))
          (if (> (string-length tmp-str) 1)
              (ag-fprintf 0 "\n%s" tmp-str))
      )
      (begin
        (set! tmp-str (get "doc" invalid-doc))
        (if (< 0 (string-length tmp-str)) (begin
          (set! label-str (string-append opt-name " option"
                (if (exist? "value")
                    (string-append " (-" (get "value") ")")
                    "" )  ))
          (if have-doc-options
            (ag-fprintf 0 opt-node-fmt opt-name label-str)
            (begin
              (ag-fprintf "menu" menu-entry-fmt
                  (string-append opt-name ":: ") label-str)
              (print-node opt-name label-str)
            )
          )
          (ag-fprintf 0 "\n@cindex %s-%s" down-prog-name opt-name)
        ) )
      )
  )                             =][=

  IF (and (not (exist? "documentation"))
          (< 0 (string-length tmp-str)) )
    =][=
  ENDIF                         =][=

ENDFOR flag                     =][=

INVOKE emit-doc-sections        =][=

(out-suspend "opt-desc")
(out-resume "menu")
(emit (out-pop #t))
(emit "@end menu\n")
(out-resume "opt-desc")
(out-pop #t)                    =][=#

@c = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = =][=

DEFINE emit-doc-sections        =][=

FOR doc-section                 =][=

  IF  (define opt-name (string-capitalize! (get "ds-type")))
      (or (== opt-name "Exit Status")
          (== opt-name "Description")
          (exist? "omit-texi")) =][=
    CONTINUE                    =][=
  ENDIF                         =][=

  (ag-fprintf "menu" menu-entry-fmt (string-append opt-name "::") opt-name)
                                =][=
  (set! label-str (string-append
        down-prog-name " " (string-capitalize opt-name)))
                                =][=
  (print-node opt-name label-str)
                                =][=
  (define cvt-fn (get "ds-format" "texi"))
                                =][=
  (if (not (== cvt-fn "texi"))
      (divert-convert cvt-fn) ) =][=
  (emit (string-append "\n" (get "ds-text") "\n"))
  (convert-divert)              =][=

ENDFOR  doc-section             =][=

ENDDEF emit-doc-sections

@c = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = =][=

DEFINE header                          \=]
\input texinfo
@c -*-texinfo-*-
@c %**start of header
@setfilename [= (string-append down-prog-name ".info") =]
@settitle [= (sprintf (if (exist? "package") "%2$s - %1$s" "%s")
             (get "package")  (get "prog-title")) =]
@c %**end of header
@setchapternewpage off
@titlepage
@sp 10
@comment The title is printed in a large font.
@center @titlefont{Sample Title}

@c The following two commands start the copyright page.
@page
@vskip 0pt plus 1filll
[= (name-copyright) =][=
IF (exist? "copyright.type") =]
[= (license-full (get "copyright.type") program-name ""
    (get "copyright.owner" (get "copyright.author" ""))
    (get "copyright.date") ) =][=
ENDIF =]
@end titlepage
@node Top, [= prog-name =] usage, , (dir)
@top [= prog-title =]
[=

ENDDEF header

@c = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = =][=

DEFINE initialization                   =][=


  (shell "CLexe=${AGexe%/autogen}/columns")


  ;; divert-convert  divert text for conversion to .texi format
  ;; convert-divert  convert the diversion done with divert-convert
  ;;
  (define divert-convert (lambda (diversion-type) (begin
     (set! was-diverted
           (not (or (== diversion-type "texi") (== diversion-type ""))))
     (if was-diverted   (begin
         (set! cvt-script
               (find-file (string-append diversion-type "2texi")))
         (if (not (defined? 'cvt-script))
             (error (sprintf "unknown source format type: %s" diversion-type)) )
         (out-push-new) ))  )))

  (define heredoc-marker "_Unlikely_Here_Doc_Marker_\n")
  (define convert-divert (lambda ()
     (if was-diverted (shell (string-append
         cvt-script "<<\\" heredoc-marker (out-pop #t) "\n" heredoc-marker
  )) )))

  (define was-diverted   #f)
  (define diversion-type "")
  (define cvt-script     "")
  (define tmp-str        "")

  (define name-copyright (lambda ()
      (if (exist? "copyright")
          (string-append "\nThis software is released under "
             (license-name (get "copyright.type" "an unknown copyright"))
             "." ) ) ))

  (make-tmp-dir)
  (define program-name      (get "prog-name"))
  (define down-prog-name    (string-downcase program-name))
  (define UP-PROG-NAME      (string-upcase   program-name))
  (shellf "export AG_DEF_PROG_NAME=%s" program-name)
  (define doc-level         (getenv "LEVEL"))
  (if (not (string? doc-level))
      (set! doc-level "section"))
  (define file-name         (string-append down-prog-name ".texi"))
  (define coded-prog-name   (string-append "@code{" down-prog-name "}"))

  (define replace-prog-name (lambda (nm)
     (string-substitute (get nm) down-prog-name coded-prog-name )  ))

  (define have-doc-options  (exist? "flag.documentation"))
  (define print-menu        #t)
  (define do-doc-nodes      #f)
  (define menu-entry-fmt    (string-append
                            "* " down-prog-name " %-24s %s\n"))
  (define emit-menu-entry   (lambda (is-doc) (not is-doc)))
  (if have-doc-options
      (set! emit-menu-entry (lambda (is-doc) is-doc))  )
  (define chk-flag-val      (exist? "flag.value"))
  (define flag-string       (lambda (v-nm v-df) (if (not chk-flag-val) ""
     (string-append " (-"
        (if (exist? v-nm) (get v-nm) v-df)
        ")")  )))

  =][=

  CASE (. doc-level)    =][=
    == document         =][= INVOKE header =][=
       (define sub-level  "chapter")
       (define head-level "heading")       =][=
    == chapter          =][=
       (define sub-level  "section")
       (define head-level "subheading")    =][=
    == section          =][=
       (define sub-level "subsection")
       (define head-level "subsubheading") =][=
    == subsection       =][=
       (define sub-level "subsubsection")
       (define head-level "subsubheading") =][=

    * =][=(error (sprintf "invalid doc level: %s\n" doc-level)) =][=

  ESAC doc level        =][=

  (define node-fmt (string-append
     "\n@node " down-prog-name " %s\n@" sub-level " %s"))
  (define print-node        (lambda (a b) (ag-fprintf 0 node-fmt a b) ))

  (define opt-node-fmt (if have-doc-options
     (string-append "\n@" head-level
        " %2$s.\n@anchor{" down-prog-name " %1$s}")
     node-fmt
  ))

  (define exit-sts-fmt "\n\n@node %1$s %2$s\n@%3$s %1$s %2$s\n")
  =][=

  IF (not (== doc-level "document"))    =][=
     (set! file-name (string-append "invoke-" file-name))
       \=]
@node [= prog-name      =] Notes
@[=(. doc-level)        =] Notes about [= prog-name =]
@pindex [= prog-name    =]
@cindex [= prog-title   =][=

FOR concept =]
@cindex [= concept      =][=
ENDFOR                  =][=

  ENDIF document component

=]
@ignore
[=

(out-move file-name)
(dne "# " "# ")

=]
@end ignore
[=

ENDDEF initialization

@c agtexi-cmd.tpl ends here =]
