package gnu.xml.validation.datatype;

/**
 * The <code>length</code> facet.
 *
 * @author <a href='mailto:dog@gnu.org'>Chris Burdess</a>
 */
public final class LengthFacet
  extends Facet
{
  
  public final int value;

  public final boolean fixed;

  public LengthFacet(int value, boolean fixed, Annotation annotation)
  {
    super(LENGTH, annotation);
    this.value = value;
    this.fixed = fixed;
  }
  
  public int hashCode()
  {
    return value;
  }

  public boolean equals(Object other)
  {
    return (other instanceof LengthFacet &&
            ((LengthFacet) other).value == value);
  }
  
}

