/*	$NetBSD: si70xxreg.h,v 1.2 2017/12/29 02:20:47 christos Exp $	*/

/*
 * Copyright (c) 2017 Brad Spencer <brad@anduin.eldar.org>
 *
 * Permission to use, copy, modify, and distribute this software for any
 * purpose with or without fee is hereby granted, provided that the above
 * copyright notice and this permission notice appear in all copies.
 *
 * THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
 * WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
 * ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
 * OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */

#ifndef _DEV_I2C_SI70XXREG_H_
#define _DEV_I2C_SI70XXREG_H_

#define SI70XX_TYPICAL_ADDR	0x40

#define SI70XX_MEASURE_RH_HOLD 0xE5
#define SI70XX_MEASURE_RH_NOHOLD 0xF5
#define SI70XX_MEASURE_TEMP_HOLD 0xE3
#define SI70XX_MEASURE_TEMP_NOHOLD 0xF3
#define SI70XX_READ_PREVIOUS_TEMP 0xE0
#define SI70XX_RESET 0xFE
#define SI70XX_WRITE_USER_REG_1 0xE6
#define SI70XX_READ_USER_REG_1 0xE7
#define SI70XX_WRITE_HEATER_REG 0x51
#define SI70XX_READ_HEATER_REG 0x11
#define SI70XX_READ_ID_PT1A 0xFA
#define SI70XX_READ_ID_PT1B 0x0F
#define SI70XX_READ_ID_PT2A 0xFC
#define SI70XX_READ_ID_PT2B 0xC9
#define SI70XX_READ_FW_VERA 0x84
#define SI70XX_READ_FW_VERB 0xB8

#define SI70XX_VDDS_MASK 0x40
#define SI70XX_HTRE_MASK 0x04
#define SI70XX_RESOLUTION_MASK 0x81
#define SI70XX_HEATER_MASK 0x0F

#endif
