/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.nlj.dtls;

import java.math.BigInteger;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.Security;
import java.time.Duration;
import java.util.Date;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.ArrayIteratorKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x500.X500NameBuilder;
import org.bouncycastle.asn1.x500.style.BCStyle;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.cert.jcajce.JcaX509v3CertificateBuilder;
import org.bouncycastle.crypto.ExtendedDigest;
import org.bouncycastle.jce.ECNamedCurveTable;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.jce.spec.ECNamedCurveParameterSpec;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.DefaultDigestAlgorithmIdentifierFinder;
import org.bouncycastle.operator.bc.BcDefaultDigestProvider;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.bouncycastle.tls.Certificate;
import org.bouncycastle.tls.SecurityParameters;
import org.bouncycastle.tls.TlsContext;
import org.bouncycastle.tls.TlsUtils;
import org.bouncycastle.tls.crypto.TlsCertificate;
import org.bouncycastle.tls.crypto.TlsSecret;
import org.bouncycastle.tls.crypto.impl.bc.BcTlsCertificate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jitsi.nlj.dtls.CertificateInfo;
import org.jitsi.nlj.dtls.DtlsConfig;
import org.jitsi.nlj.dtls.DtlsUtilsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0005\u0018\u0000 \u00042\u00020\u0001:\u0002\u0004\u0005B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0006"}, d2={"Lorg/jitsi/nlj/dtls/DtlsUtils;", "", "<init>", "()V", "Companion", "DtlsException", "jitsi-media-transform"})
public final class DtlsUtils {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final DtlsConfig config;
    @NotNull
    private static final char[] HEX_CHARS;

    static {
        Security.addProvider(new BouncyCastleProvider());
        config = new DtlsConfig();
        char[] cArray = "0123456789ABCDEF".toCharArray();
        Intrinsics.checkNotNullExpressionValue(cArray, "toCharArray(...)");
        HEX_CHARS = cArray;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u001c\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0005\n\u0002\u0010\u0019\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\b\u001a\u00020\tJ\"\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000b0\rJ\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\b\u0010\u0015\u001a\u00020\u0014H\u0002J\u0018\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0018H\u0002J\"\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0012\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00180\u001fJ$\u0010\u001a\u001a\u00020\u001b2\u0006\u0010 \u001a\u00020\u00102\u0012\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00180\u001fH\u0002J\f\u0010!\u001a\u00020\u0018*\u00020\u0010H\u0002J\u0014\u0010\"\u001a\u00020\u0018*\u00020\u00102\u0006\u0010#\u001a\u00020\u0018H\u0002J\f\u0010&\u001a\u00020\u0018*\u00020'H\u0002J0\u0010(\u001a\u00020'2\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020\u00182\b\u0010,\u001a\u0004\u0018\u00010'2\u0006\u0010-\u001a\u00020\u000b2\u0006\u0010.\u001a\u00020/R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010$\u001a\u00020%X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lorg/jitsi/nlj/dtls/DtlsUtils$Companion;", "", "<init>", "()V", "config", "Lorg/jitsi/nlj/dtls/DtlsConfig;", "getConfig", "()Lorg/jitsi/nlj/dtls/DtlsConfig;", "generateCertificateInfo", "Lorg/jitsi/nlj/dtls/CertificateInfo;", "chooseSrtpProtectionProfile", "", "ours", "", "theirs", "generateCertificate", "Lorg/bouncycastle/asn1/x509/Certificate;", "subject", "Lorg/bouncycastle/asn1/x500/X500Name;", "keyPair", "Ljava/security/KeyPair;", "generateEcKeyPair", "generateCN", "appName", "", "appVersion", "verifyAndValidateCertificate", "", "certificateInfo", "Lorg/bouncycastle/tls/Certificate;", "remoteFingerprints", "", "certificate", "getHashFunction", "getFingerprint", "hashFunction", "HEX_CHARS", "", "toFingerprint", "", "exportKeyingMaterial", "context", "Lorg/bouncycastle/tls/TlsContext;", "asciiLabel", "context_value", "length", "masterSecret", "Lorg/bouncycastle/tls/crypto/TlsSecret;", "jitsi-media-transform"})
    @SourceDebugExtension(value={"SMAP\nDtlsUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DtlsUtils.kt\norg/jitsi/nlj/dtls/DtlsUtils$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,359:1\n230#2,2:360\n*S KotlinDebug\n*F\n+ 1 DtlsUtils.kt\norg/jitsi/nlj/dtls/DtlsUtils$Companion\n*L\n89#1:360,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final DtlsConfig getConfig() {
            return config;
        }

        @NotNull
        public final CertificateInfo generateCertificateInfo() {
            X500Name cn = this.generateCN("TODO-APP-NAME", "TODO-APP-VERSION");
            KeyPair keyPair = this.generateEcKeyPair();
            org.bouncycastle.asn1.x509.Certificate x509certificate = this.generateCertificate(cn, keyPair);
            String localFingerprintHashFunction = this.getHashFunction(x509certificate);
            String localFingerprint = this.getFingerprint(x509certificate, localFingerprintHashFunction);
            BcTlsCertificate[] bcTlsCertificateArray = new BcTlsCertificate[]{new BcTlsCertificate(DtlsUtilsKt.getBC_TLS_CRYPTO(), x509certificate)};
            Certificate certificate = new Certificate(bcTlsCertificateArray);
            return new CertificateInfo(keyPair, certificate, localFingerprintHashFunction, localFingerprint, System.currentTimeMillis());
        }

        public final int chooseSrtpProtectionProfile(@NotNull Iterable<Integer> ours, @NotNull Iterable<Integer> theirs) {
            int n;
            Intrinsics.checkNotNullParameter(ours, "ours");
            Intrinsics.checkNotNullParameter(theirs, "theirs");
            try {
                Integer element$iv2;
                block3: {
                    Iterable<Integer> $this$first$iv = ours;
                    boolean $i$f$first = false;
                    for (Integer element$iv2 : $this$first$iv) {
                        int p0 = ((Number)element$iv2).intValue();
                        boolean bl = false;
                        if (!CollectionsKt.contains(theirs, p0)) continue;
                        break block3;
                    }
                    throw new NoSuchElementException("Collection contains no element matching the predicate.");
                }
                n = ((Number)element$iv2).intValue();
            }
            catch (NoSuchElementException e) {
                throw new DtlsException("No common SRTP protection profile found.  Ours: " + CollectionsKt.joinToString$default(ours, null, null, null, 0, null, null, 63, null) + " Theirs: " + CollectionsKt.joinToString$default(theirs, null, null, null, 0, null, null, 63, null));
            }
            return n;
        }

        private final org.bouncycastle.asn1.x509.Certificate generateCertificate(X500Name subject, KeyPair keyPair) {
            long now = System.currentTimeMillis();
            Date startDate = new Date(now - Duration.ofDays(1L).toMillis());
            Date expiryDate = new Date(now + Duration.ofDays(7L).toMillis());
            BigInteger serialNumber = BigInteger.valueOf(now);
            JcaX509v3CertificateBuilder certBuilder = new JcaX509v3CertificateBuilder(subject, serialNumber, startDate, expiryDate, subject, keyPair.getPublic());
            ContentSigner signer = new JcaContentSignerBuilder("SHA256withECDSA").build(keyPair.getPrivate());
            org.bouncycastle.asn1.x509.Certificate certificate = certBuilder.build(signer).toASN1Structure();
            Intrinsics.checkNotNullExpressionValue(certificate, "toASN1Structure(...)");
            return certificate;
        }

        private final KeyPair generateEcKeyPair() {
            KeyPairGenerator keyGen = KeyPairGenerator.getInstance("EC", "BC");
            ECNamedCurveParameterSpec ecCurveSpec = ECNamedCurveTable.getParameterSpec("secp256r1");
            keyGen.initialize(ecCurveSpec);
            KeyPair keyPair = keyGen.generateKeyPair();
            Intrinsics.checkNotNullExpressionValue(keyPair, "generateKeyPair(...)");
            return keyPair;
        }

        private final X500Name generateCN(String appName, String appVersion) {
            X500NameBuilder builder2 = new X500NameBuilder(BCStyle.INSTANCE);
            String rdn = appName + " " + appVersion;
            builder2.addRDN(BCStyle.CN, rdn);
            X500Name x500Name = builder2.build();
            Intrinsics.checkNotNullExpressionValue(x500Name, "build(...)");
            return x500Name;
        }

        public final void verifyAndValidateCertificate(@NotNull Certificate certificateInfo, @NotNull Map<String, String> remoteFingerprints) {
            Intrinsics.checkNotNullParameter(certificateInfo, "certificateInfo");
            Intrinsics.checkNotNullParameter(remoteFingerprints, "remoteFingerprints");
            TlsCertificate[] tlsCertificateArray = certificateInfo.getCertificateList();
            Intrinsics.checkNotNullExpressionValue(tlsCertificateArray, "getCertificateList(...)");
            if (((Object[])tlsCertificateArray).length == 0) {
                throw new DtlsException("No remote fingerprints.");
            }
            Iterator<TlsCertificate> iterator2 = ArrayIteratorKt.iterator(certificateInfo.getCertificateList());
            while (iterator2.hasNext()) {
                TlsCertificate currCertificate = iterator2.next();
                org.bouncycastle.asn1.x509.Certificate x509Cert = org.bouncycastle.asn1.x509.Certificate.getInstance(currCertificate.getEncoded());
                Intrinsics.checkNotNull(x509Cert);
                this.verifyAndValidateCertificate(x509Cert, remoteFingerprints);
            }
        }

        private final void verifyAndValidateCertificate(org.bouncycastle.asn1.x509.Certificate certificate, Map<String, String> remoteFingerprints) {
            String hashFunction = this.getHashFunction(certificate);
            String string = remoteFingerprints.get(hashFunction);
            if (string == null) {
                throw new DtlsException("No fingerprint declared over the signaling path with hash function: " + hashFunction);
            }
            String remoteFingerprint = string;
            String certificateFingerprint = this.getFingerprint(certificate, hashFunction);
            if (!Intrinsics.areEqual(remoteFingerprint, certificateFingerprint)) {
                throw new DtlsException("Fingerprint " + remoteFingerprint + " does not match the " + hashFunction + "-hashed certificate " + certificateFingerprint);
            }
        }

        private final String getHashFunction(org.bouncycastle.asn1.x509.Certificate $this$getHashFunction) {
            AlgorithmIdentifier digAlgId = new DefaultDigestAlgorithmIdentifierFinder().find($this$getHashFunction.getSignatureAlgorithm());
            String string = BcDefaultDigestProvider.INSTANCE.get(digAlgId).getAlgorithmName();
            Intrinsics.checkNotNullExpressionValue(string, "getAlgorithmName(...)");
            String string2 = string.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue(string2, "toLowerCase(...)");
            return string2;
        }

        private final String getFingerprint(org.bouncycastle.asn1.x509.Certificate $this$getFingerprint, String hashFunction) {
            DefaultDigestAlgorithmIdentifierFinder defaultDigestAlgorithmIdentifierFinder = new DefaultDigestAlgorithmIdentifierFinder();
            String string = hashFunction.toUpperCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue(string, "toUpperCase(...)");
            AlgorithmIdentifier digAlgId = defaultDigestAlgorithmIdentifierFinder.find(string);
            ExtendedDigest digest = BcDefaultDigestProvider.INSTANCE.get(digAlgId);
            byte[] byArray = $this$getFingerprint.getEncoded("DER");
            Intrinsics.checkNotNullExpressionValue(byArray, "getEncoded(...)");
            byte[] input = byArray;
            byte[] output = new byte[digest.getDigestSize()];
            digest.update(input, 0, input.length);
            digest.doFinal(output, 0);
            return this.toFingerprint(output);
        }

        private final String toFingerprint(byte[] $this$toFingerprint) {
            StringBuffer buf = new StringBuffer();
            int n = $this$toFingerprint.length;
            for (int i = 0; i < n; ++i) {
                byte octet = $this$toFingerprint[i];
                int firstIndex = (octet & 0xF0) >>> 4;
                int secondIndex = octet & 0xF;
                buf.append(HEX_CHARS[firstIndex]);
                buf.append(HEX_CHARS[secondIndex]);
                if (i >= $this$toFingerprint.length - 1) continue;
                buf.append(":");
            }
            String string = buf.toString();
            Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
            return string;
        }

        @NotNull
        public final byte[] exportKeyingMaterial(@NotNull TlsContext context, @NotNull String asciiLabel, @Nullable byte[] context_value, int length, @NotNull TlsSecret masterSecret) {
            Intrinsics.checkNotNullParameter(context, "context");
            Intrinsics.checkNotNullParameter(asciiLabel, "asciiLabel");
            Intrinsics.checkNotNullParameter(masterSecret, "masterSecret");
            if (context_value != null && !TlsUtils.isValidUint16(context_value.length)) {
                throw new IllegalArgumentException("'context_value' must have a length less than 2^16 (or be null)");
            }
            SecurityParameters sp = context.getSecurityParameters();
            byte[] cr = sp.getClientRandom();
            byte[] sr = sp.getServerRandom();
            int seedLength = cr.length + sr.length;
            if (context_value != null) {
                seedLength += 2 + context_value.length;
            }
            byte[] seed = new byte[seedLength];
            int seedPos = 0;
            System.arraycopy(cr, 0, seed, seedPos, cr.length);
            System.arraycopy(sr, 0, seed, seedPos += cr.length, sr.length);
            seedPos += sr.length;
            if (context_value != null) {
                TlsUtils.writeUint16(context_value.length, seed, seedPos);
                System.arraycopy(context_value, 0, seed, seedPos += 2, context_value.length);
                seedPos += context_value.length;
            }
            if (seedPos != seedLength) {
                throw new IllegalStateException("error in calculation of seed for export");
            }
            byte[] byArray = TlsUtils.PRF(sp, masterSecret, asciiLabel, seed, length).extract();
            Intrinsics.checkNotNullExpressionValue(byArray, "extract(...)");
            return byArray;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00060\u0002j\u0002`\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jitsi/nlj/dtls/DtlsUtils$DtlsException;", "Lkotlin/Exception;", "Ljava/lang/Exception;", "msg", "", "<init>", "(Ljava/lang/String;)V", "jitsi-media-transform"})
    public static final class DtlsException
    extends Exception {
        public DtlsException(@NotNull String msg) {
            Intrinsics.checkNotNullParameter(msg, "msg");
            super(msg);
        }
    }
}

