/*
 * Decompiled with CFR 0.152.
 */
package lucee.debug;

import java.io.File;
import org.apache.catalina.Context;
import org.apache.catalina.Server;
import org.apache.catalina.connector.Connector;
import org.apache.catalina.startup.Tomcat;

public class Main {
    public static final String ARG_HOST = "LUCEE_DEBUG_HOST";
    public static final String ARG_PORT = "LUCEE_DEBUG_PORT";
    public static final String ARG_BASE = "LUCEE_DEBUG_BASE";
    public static final String ARG_WEBXML = "LUCEE_DEBUG_WEBXML";
    public static final String DEF_HOST = "localhost";
    public static final String DEF_PORT = "48080";
    public static final String DEF_BASE = "/workspace/test/LuceeDebugWebapp";

    public static void main(String[] args) throws Exception {
        System.setProperty("lucee.controller.disabled", "true");
        String s = Main.getSystemPropOrEnvVar(ARG_BASE, DEF_BASE);
        String appBase = new File(s).getCanonicalPath().replace('\\', '/');
        String docBase = appBase + "/webroot";
        String webxml = Main.getSystemPropOrEnvVar(ARG_WEBXML, docBase + "/WEB-INF/web.xml");
        System.out.println("Setting appBase: " + appBase);
        System.out.println("Setting docBase: " + docBase);
        System.out.println("Setting web.xml: " + webxml);
        File f = new File(webxml);
        if (!f.exists()) {
            throw new IllegalArgumentException("web.xml not found at " + webxml);
        }
        Tomcat tomcat = new Tomcat();
        tomcat.setBaseDir(appBase);
        s = Main.getSystemPropOrEnvVar(ARG_HOST, DEF_HOST);
        tomcat.setHostname(s);
        s = Main.getSystemPropOrEnvVar(ARG_PORT, DEF_PORT);
        tomcat.setPort(Integer.parseInt(s));
        tomcat.setAddDefaultWebXmlToWebapp(false);
        Context context = tomcat.addWebapp("", docBase);
        context.setAltDDName(webxml);
        context.setLogEffectiveWebXml(true);
        context.setResourceOnlyServlets("CFMLServlet");
        Connector connector = tomcat.getConnector();
        System.out.println(connector);
        tomcat.start();
        Server server = tomcat.getServer();
        server.await();
    }

    private static String convertSystemPropToEnvVar(String name) {
        return name.replace('.', '_').toUpperCase();
    }

    private static String getSystemPropOrEnvVar(String name, String defaultValue) {
        String value = System.getenv(name);
        if (!Main.isEmpty(value)) {
            return value;
        }
        value = System.getProperty(name);
        if (!Main.isEmpty(value)) {
            return value;
        }
        value = System.getenv(name = Main.convertSystemPropToEnvVar(name));
        if (!Main.isEmpty(value)) {
            return value;
        }
        return defaultValue;
    }

    private static boolean isEmpty(String value) {
        return value == null || value.isEmpty();
    }
}

