/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.css.properties.css3;

import java.math.BigDecimal;
import org.w3c.css.util.ApplContext;
import org.w3c.css.util.InvalidParamException;
import org.w3c.css.values.CssExpression;
import org.w3c.css.values.CssIdent;
import org.w3c.css.values.CssNumber;
import org.w3c.css.values.CssPercentage;
import org.w3c.css.values.CssValue;

public class CssOpacity
extends org.w3c.css.properties.css.CssOpacity {
    public CssOpacity() {
        this.value = initial;
    }

    public CssOpacity(ApplContext ac, CssExpression expression, boolean check2) throws InvalidParamException {
        this.setByUser();
        CssValue val = expression.getValue();
        switch (val.getType()) {
            case 5: {
                if (val.getRawType() == 5) {
                    if (!val.getCheckableValue().isPositive()) {
                        ac.getFrame().addWarning("out-of-range", val.toString());
                        CssNumber nb = new CssNumber();
                        nb.setIntValue(0);
                        this.value = nb;
                        break;
                    }
                    BigDecimal pp = val.getNumber().getBigDecimalValue();
                    if (pp.compareTo(BigDecimal.ONE) > 0) {
                        ac.getFrame().addWarning("out-of-range", val.toString());
                        CssNumber nb = new CssNumber();
                        nb.setIntValue(1);
                        this.value = nb;
                        break;
                    }
                } else {
                    val.getCheckableValue().warnPositiveness(ac, this);
                }
                this.value = val;
                break;
            }
            case 4: {
                float p;
                if (!val.getCheckableValue().isPositive()) {
                    ac.getFrame().addWarning("out-of-range", val.toString());
                    CssNumber nb = new CssNumber();
                    nb.setIntValue(0);
                    this.value = nb;
                    break;
                }
                if (val.getRawType() == 4 && (double)(p = ((CssPercentage)val).floatValue()) > 100.0) {
                    ac.getFrame().addWarning("out-of-range", val.toString());
                    this.value = new CssPercentage(100);
                    break;
                }
                this.value = val;
                break;
            }
            case 0: {
                if (CssIdent.isCssWide(val.getIdent())) {
                    this.value = val;
                    break;
                }
            }
            default: {
                throw new InvalidParamException("value", val.toString(), this.getPropertyName(), ac);
            }
        }
        expression.next();
    }

    public CssOpacity(ApplContext ac, CssExpression expression) throws InvalidParamException {
        this(ac, expression, false);
    }

    @Override
    public boolean isDefault() {
        if (this.value.getRawType() == 5) {
            try {
                return this.value.getNumber().getValue() == 1.0f;
            }
            catch (Exception ex) {
                return false;
            }
        }
        return this.value == initial;
    }
}

