/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.xsite.irac;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import org.infinispan.commons.util.IntSet;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.infinispan.xsite.irac.IracBatchSendResult;
import org.infinispan.xsite.irac.IracManagerKeyState;
import org.infinispan.xsite.irac.IracXSiteBackup;
import org.infinispan.xsite.status.DefaultTakeOfflineManager;

public class IracResponseCollector
extends CompletableFuture<Void>
implements BiConsumer<IntSet, Throwable> {
    private static final Log log = LogFactory.getLog(IracResponseCollector.class);
    private final IracXSiteBackup backup;
    private final String cacheName;
    private final Collection<IracManagerKeyState> batch;
    private final IracResponseCompleted listener;

    IracResponseCollector(String cacheName, IracXSiteBackup backup, Collection<IracManagerKeyState> batch, IracResponseCompleted listener) {
        this.cacheName = cacheName;
        this.backup = backup;
        this.batch = batch;
        this.listener = listener;
    }

    @Override
    public void accept(IntSet rspIntSet, Throwable throwable) {
        boolean trace = log.isTraceEnabled();
        if (throwable != null) {
            IracBatchSendResult result;
            if (DefaultTakeOfflineManager.isCommunicationError(throwable)) {
                this.backup.enableBackOff();
                result = IracBatchSendResult.BACK_OFF_AND_RETRY;
            } else {
                this.backup.resetBackOff();
                result = IracBatchSendResult.RETRY;
            }
            if (this.backup.logExceptions()) {
                log.warnXsiteBackupFailed(this.cacheName, this.backup.getSiteName(), throwable);
            } else if (trace) {
                log.tracef(throwable, "[IRAC] Encountered issues while backing up data for cache %s to site %s", this.cacheName, this.backup.getSiteName());
            }
            this.batch.forEach(IracManagerKeyState::retry);
            this.notifyAndComplete(result, Collections.emptyList());
            return;
        }
        if (trace) {
            log.tracef("[IRAC] Received response from site %s for cache %s: %s", this.backup.getSiteName(), this.cacheName, rspIntSet);
        }
        this.backup.resetBackOff();
        if (rspIntSet == null || rspIntSet.isEmpty()) {
            for (IracManagerKeyState state : this.batch) {
                state.successFor(this.backup);
            }
            this.notifyAndComplete(IracBatchSendResult.OK, this.batch);
            return;
        }
        int index = 0;
        ArrayList<IracManagerKeyState> successfulSent = new ArrayList<IracManagerKeyState>(this.batch.size());
        for (IracManagerKeyState state : this.batch) {
            if (rspIntSet.contains(index++)) {
                state.retry();
                continue;
            }
            state.successFor(this.backup);
            successfulSent.add(state);
        }
        this.notifyAndComplete(IracBatchSendResult.RETRY, successfulSent);
    }

    void onSiteOffline() {
        if (log.isTraceEnabled()) {
            log.tracef("[IRAC] Site %s is offline for cache %s", this.backup.getSiteName(), this.cacheName);
        }
        this.backup.resetBackOff();
        for (IracManagerKeyState state : this.batch) {
            state.successFor(this.backup);
        }
        this.notifyAndComplete(IracBatchSendResult.OK, this.batch);
    }

    private void notifyAndComplete(IracBatchSendResult result, Collection<IracManagerKeyState> successfulSent) {
        this.listener.onResponseCompleted(result, successfulSent);
        this.complete(null);
    }

    @FunctionalInterface
    static interface IracResponseCompleted {
        public void onResponseCompleted(IracBatchSendResult var1, Collection<IracManagerKeyState> var2);
    }
}

