/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.oid4vc;

import java.util.HashMap;
import java.util.Map;
import org.jboss.logging.Logger;
import org.keycloak.Config;
import org.keycloak.events.EventBuilder;
import org.keycloak.models.ClientModel;
import org.keycloak.models.ClientScopeModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.ProtocolMapperModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.protocol.LoginProtocol;
import org.keycloak.protocol.LoginProtocolFactory;
import org.keycloak.protocol.oid4vc.OID4VCEnvironmentProviderFactory;
import org.keycloak.protocol.oid4vc.issuance.OID4VCIssuerEndpoint;
import org.keycloak.protocol.oid4vc.issuance.mappers.OID4VCSubjectIdMapper;
import org.keycloak.protocol.oid4vc.issuance.mappers.OID4VCTargetRoleMapper;
import org.keycloak.protocol.oid4vc.issuance.mappers.OID4VCUserAttributeMapper;
import org.keycloak.representations.idm.ClientRepresentation;

public class OID4VCLoginProtocolFactory
implements LoginProtocolFactory,
OID4VCEnvironmentProviderFactory {
    private static final Logger LOGGER = Logger.getLogger(OID4VCLoginProtocolFactory.class);
    public static final String PROTOCOL_ID = "oid4vc";
    private static final String CLIENT_ROLES_MAPPER = "client-roles";
    private static final String USERNAME_MAPPER = "username";
    private static final String SUBJECT_ID_MAPPER = "subject-id";
    private static final String EMAIL_MAPPER = "email";
    private static final String LAST_NAME_MAPPER = "last-name";
    private static final String FIRST_NAME_MAPPER = "first-name";
    private Map<String, ProtocolMapperModel> builtins = new HashMap<String, ProtocolMapperModel>();

    public void init(Config.Scope config) {
        this.builtins.put(CLIENT_ROLES_MAPPER, OID4VCTargetRoleMapper.create("id", "client roles"));
        this.builtins.put(SUBJECT_ID_MAPPER, OID4VCSubjectIdMapper.create("subject id", "id"));
        this.builtins.put(USERNAME_MAPPER, OID4VCUserAttributeMapper.create(USERNAME_MAPPER, USERNAME_MAPPER, USERNAME_MAPPER, false));
        this.builtins.put(EMAIL_MAPPER, OID4VCUserAttributeMapper.create(EMAIL_MAPPER, EMAIL_MAPPER, EMAIL_MAPPER, false));
        this.builtins.put(FIRST_NAME_MAPPER, OID4VCUserAttributeMapper.create(FIRST_NAME_MAPPER, "firstName", "firstName", false));
        this.builtins.put(LAST_NAME_MAPPER, OID4VCUserAttributeMapper.create(LAST_NAME_MAPPER, "lastName", "familyName", false));
    }

    public void postInit(KeycloakSessionFactory factory) {
    }

    public void close() {
    }

    public Map<String, ProtocolMapperModel> getBuiltinMappers() {
        return this.builtins;
    }

    public Object createProtocolEndpoint(KeycloakSession keycloakSession, EventBuilder event) {
        return new OID4VCIssuerEndpoint(keycloakSession);
    }

    public void createDefaultClientScopes(RealmModel newRealm, boolean addScopesToExistingClients) {
        LOGGER.debugf("Create default scopes for realm %s", (Object)newRealm.getName());
        ClientScopeModel naturalPersonScope = KeycloakModelUtils.getClientScopeByName((RealmModel)newRealm, (String)"natural_person");
        if (naturalPersonScope == null) {
            LOGGER.debug((Object)"Add natural person scope");
            naturalPersonScope = newRealm.addClientScope(String.format("%s_%s", PROTOCOL_ID, "natural_person"));
            naturalPersonScope.setDescription("OIDC$VP Scope, that adds all properties required for a natural person.");
            naturalPersonScope.setProtocol(PROTOCOL_ID);
            naturalPersonScope.addProtocolMapper(this.builtins.get(SUBJECT_ID_MAPPER));
            naturalPersonScope.addProtocolMapper(this.builtins.get(CLIENT_ROLES_MAPPER));
            naturalPersonScope.addProtocolMapper(this.builtins.get(EMAIL_MAPPER));
            naturalPersonScope.addProtocolMapper(this.builtins.get(FIRST_NAME_MAPPER));
            naturalPersonScope.addProtocolMapper(this.builtins.get(LAST_NAME_MAPPER));
            newRealm.addDefaultClientScope(naturalPersonScope, true);
        }
    }

    public void setupClientDefaults(ClientRepresentation rep, ClientModel newClient) {
    }

    public LoginProtocol create(KeycloakSession session) {
        return null;
    }

    public String getId() {
        return PROTOCOL_ID;
    }
}

