/*
 * Decompiled with CFR 0.152.
 */
package org.openide.execution;

import java.security.AllPermission;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.security.Permissions;
import org.openide.execution.ExecutorTask;
import org.openide.execution.NbClassPath;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;
import org.openide.windows.InputOutput;

public abstract class ExecutionEngine {
    public abstract ExecutorTask execute(String var1, Runnable var2, InputOutput var3);

    protected abstract PermissionCollection createPermissions(CodeSource var1, InputOutput var2);

    protected abstract NbClassPath createLibraryPath();

    public static ExecutionEngine getDefault() {
        ExecutionEngine executionEngine = (ExecutionEngine)Lookup.getDefault().lookup(ExecutionEngine.class);
        if (executionEngine == null) {
            executionEngine = new Trivial();
        }
        return executionEngine;
    }

    static final class Trivial
    extends ExecutionEngine {
        protected NbClassPath createLibraryPath() {
            return new NbClassPath(new String[0]);
        }

        protected PermissionCollection createPermissions(CodeSource codeSource, InputOutput inputOutput) {
            Permissions permissions = new Permissions();
            ((PermissionCollection)permissions).add(new AllPermission());
            permissions.setReadOnly();
            return permissions;
        }

        public ExecutorTask execute(String string, Runnable runnable, InputOutput inputOutput) {
            return new ET(runnable, string, inputOutput);
        }

        private static final class ET
        extends ExecutorTask {
            private RequestProcessor.Task task;
            private int resultValue;
            private final String name;
            private InputOutput io;

            public ET(Runnable runnable, String string, InputOutput inputOutput) {
                super(runnable);
                this.resultValue = this.resultValue;
                this.name = string;
                this.task = RequestProcessor.getDefault().post((Runnable)((Object)this));
            }

            public void stop() {
                this.task.cancel();
            }

            public int result() {
                this.waitFinished();
                return this.resultValue;
            }

            public InputOutput getInputOutput() {
                return this.io;
            }

            public void run() {
                try {
                    super.run();
                }
                catch (RuntimeException runtimeException) {
                    runtimeException.printStackTrace();
                    this.resultValue = 1;
                }
            }
        }
    }
}

