/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.preparator;

import de.rub.nds.modifiablevariable.bytearray.ModifiableByteArray;
import de.rub.nds.modifiablevariable.util.ArrayConverter;
import de.rub.nds.tlsattacker.core.constants.AlgorithmResolver;
import de.rub.nds.tlsattacker.core.constants.DigestAlgorithm;
import de.rub.nds.tlsattacker.core.crypto.ec.CurveFactory;
import de.rub.nds.tlsattacker.core.crypto.ec.EllipticCurve;
import de.rub.nds.tlsattacker.core.crypto.ec.Point;
import de.rub.nds.tlsattacker.core.crypto.ec.PointFormatter;
import de.rub.nds.tlsattacker.core.crypto.gost.GOST28147WrapEngine;
import de.rub.nds.tlsattacker.core.crypto.gost.TLSGostKeyTransportBlob;
import de.rub.nds.tlsattacker.core.exceptions.WorkflowExecutionException;
import de.rub.nds.tlsattacker.core.protocol.message.GOSTClientKeyExchangeMessage;
import de.rub.nds.tlsattacker.core.protocol.preparator.ClientKeyExchangePreparator;
import de.rub.nds.tlsattacker.core.util.GOSTUtils;
import de.rub.nds.tlsattacker.core.workflow.chooser.Chooser;
import java.io.IOException;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.cryptopro.CryptoProObjectIdentifiers;
import org.bouncycastle.asn1.cryptopro.Gost2814789EncryptedKey;
import org.bouncycastle.asn1.cryptopro.GostR3410KeyTransport;
import org.bouncycastle.asn1.cryptopro.GostR3410TransportParameters;
import org.bouncycastle.asn1.rosstandart.RosstandartObjectIdentifiers;
import org.bouncycastle.asn1.util.ASN1Dump;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.engines.GOST28147Engine;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithSBox;
import org.bouncycastle.crypto.params.ParametersWithUKM;

public abstract class GOSTClientKeyExchangePreparator
extends ClientKeyExchangePreparator<GOSTClientKeyExchangeMessage> {
    private static final Logger LOGGER = LogManager.getLogger();
    private static Map<ASN1ObjectIdentifier, String> oidMappings = new HashMap<ASN1ObjectIdentifier, String>();
    private final GOSTClientKeyExchangeMessage msg;

    public GOSTClientKeyExchangePreparator(Chooser chooser, GOSTClientKeyExchangeMessage msg) {
        super(chooser, msg);
        this.msg = msg;
    }

    @Override
    protected void prepareHandshakeMessageContents() {
        this.prepareAfterParse(true);
    }

    @Override
    public void prepareAfterParse(boolean clientMode) {
        try {
            LOGGER.debug("Preparing GOST EC VKO. Client mode: " + clientMode);
            this.msg.prepareComputations();
            this.prepareClientServerRandom();
            this.prepareUkm();
            if (clientMode) {
                this.preparePms();
                this.msg.getComputations().setPrivateKey(this.chooser.getClientEcPrivateKey());
                this.prepareEphemeralKey();
                this.prepareKek((BigInteger)this.msg.getComputations().getPrivateKey().getValue(), this.chooser.getServerEcPublicKey());
                this.prepareEncryptionParams();
                this.prepareCek();
                this.prepareKeyBlob();
            } else {
                TLSGostKeyTransportBlob transportBlob = TLSGostKeyTransportBlob.getInstance(this.msg.getKeyTransportBlob().getValue());
                LOGGER.debug("Received GOST key blob: " + ASN1Dump.dumpAsString((Object)((Object)transportBlob), (boolean)true));
                GostR3410KeyTransport keyBlob = transportBlob.getKeyBlob();
                if (!Arrays.equals(keyBlob.getTransportParameters().getUkm(), (byte[])this.msg.getComputations().getUkm().getValue())) {
                    LOGGER.warn("Client UKM != Server UKM");
                }
                SubjectPublicKeyInfo ephemeralKey = keyBlob.getTransportParameters().getEphemeralPublicKey();
                Point publicKey = this.chooser.getClientEcPublicKey();
                this.prepareKek(this.chooser.getServerEcPrivateKey(), publicKey);
                byte[] wrapped = ArrayConverter.concatenate((byte[][])new byte[][]{keyBlob.getSessionEncryptedKey().getEncryptedKey(), keyBlob.getSessionEncryptedKey().getMacKey()});
                String sBoxName = oidMappings.get(keyBlob.getTransportParameters().getEncryptionParamSet());
                byte[] pms = this.wrap(false, wrapped, sBoxName);
                this.msg.getComputations().setPremasterSecret(pms);
            }
        }
        catch (IOException | GeneralSecurityException e) {
            throw new WorkflowExecutionException("Could not prepare the key agreement!", e);
        }
    }

    private void prepareClientServerRandom() {
        byte[] random = ArrayConverter.concatenate((byte[][])new byte[][]{this.chooser.getClientRandom(), this.chooser.getServerRandom()});
        this.msg.getComputations().setClientServerRandom(random);
        LOGGER.debug("ClientServerRandom: " + ArrayConverter.bytesToHexString((byte[])((byte[])this.msg.getComputations().getClientServerRandom().getValue())));
    }

    private void prepareUkm() throws NoSuchAlgorithmException {
        DigestAlgorithm digestAlgorithm = AlgorithmResolver.getDigestAlgorithm(this.chooser.getSelectedProtocolVersion(), this.chooser.getSelectedCipherSuite());
        MessageDigest digest = MessageDigest.getInstance(digestAlgorithm.getJavaName());
        byte[] hash = digest.digest((byte[])this.msg.getComputations().getClientServerRandom().getValue());
        byte[] ukm = new byte[8];
        System.arraycopy(hash, 0, ukm, 0, ukm.length);
        this.msg.getComputations().setUkm(ukm);
        LOGGER.debug("UKM: " + ArrayConverter.bytesToHexString((ModifiableByteArray)this.msg.getComputations().getUkm()));
    }

    private void prepareKek(BigInteger privateKey, Point publicKey) throws GeneralSecurityException {
        EllipticCurve curve = CurveFactory.getCurve(this.chooser.getSelectedGostCurve());
        Point sharedPoint = curve.mult(privateKey, publicKey);
        byte[] pms = PointFormatter.toRawFormat(sharedPoint);
        Digest digest = this.getKeyAgreementDigestAlgorithm();
        digest.update(pms, 0, pms.length);
        byte[] kek = new byte[digest.getDigestSize()];
        digest.doFinal(kek, 0);
        this.msg.getComputations().setKeyEncryptionKey(kek);
        LOGGER.debug("KEK: " + ArrayConverter.bytesToHexString((ModifiableByteArray)this.msg.getComputations().getKeyEncryptionKey()));
    }

    private void preparePms() {
        byte[] pms = this.chooser.getContext().getPreMasterSecret();
        if (pms != null) {
            LOGGER.debug("Using preset PreMasterSecret from context.");
        } else {
            LOGGER.debug("Generating random PreMasterSecret.");
            pms = new byte[32];
            this.chooser.getContext().getRandom().nextBytes(pms);
        }
        this.msg.getComputations().setPremasterSecret(pms);
    }

    private void prepareEphemeralKey() {
        EllipticCurve curve = CurveFactory.getCurve(this.chooser.getSelectedGostCurve());
        LOGGER.debug("Using key from context.");
        this.msg.getComputations().setPrivateKey(this.chooser.getClientEcPrivateKey());
        Point publicKey = curve.mult((BigInteger)this.msg.getComputations().getPrivateKey().getValue(), curve.getBasePoint());
        this.msg.getComputations().setClientPublicKey(publicKey);
    }

    private byte[] wrap(boolean wrap, byte[] bytes, String sBoxName) {
        byte[] result;
        byte[] sBox = GOST28147Engine.getSBox((String)sBoxName);
        KeyParameter keySpec = new KeyParameter((byte[])this.msg.getComputations().getKeyEncryptionKey().getValue());
        ParametersWithSBox withSBox = new ParametersWithSBox((CipherParameters)keySpec, sBox);
        ParametersWithUKM withIV = new ParametersWithUKM((CipherParameters)withSBox, (byte[])this.msg.getComputations().getUkm().getValue());
        GOST28147WrapEngine cipher = new GOST28147WrapEngine();
        cipher.init(wrap, (CipherParameters)withIV);
        if (wrap) {
            LOGGER.debug("Wrapping GOST PMS: " + ArrayConverter.bytesToHexString((byte[])bytes));
            result = cipher.wrap(bytes, 0, bytes.length);
        } else {
            LOGGER.debug("Unwrapping GOST PMS: " + ArrayConverter.bytesToHexString((byte[])bytes));
            result = cipher.unwrap(bytes, 0, bytes.length);
        }
        LOGGER.debug("Wrap result: " + ArrayConverter.bytesToHexString((byte[])result));
        return result;
    }

    private void prepareCek() {
        ASN1ObjectIdentifier param = new ASN1ObjectIdentifier((String)this.msg.getComputations().getEncryptionParamSet().getValue());
        String sBoxName = oidMappings.get(param);
        byte[] wrapped = this.wrap(true, (byte[])this.msg.getComputations().getPremasterSecret().getValue(), sBoxName);
        byte[] cek = new byte[32];
        try {
            if (wrapped.length <= cek.length) {
                System.arraycopy(wrapped, 0, cek, 0, cek.length);
            } else {
                System.arraycopy(wrapped, 0, cek, 0, wrapped.length - 1);
            }
        }
        catch (ArrayIndexOutOfBoundsException E) {
            LOGGER.warn("Something going wrong here...");
        }
        this.msg.getComputations().setEncryptedKey(cek);
        byte[] mac = new byte[wrapped.length - cek.length];
        System.arraycopy(wrapped, cek.length, mac, 0, mac.length);
        this.msg.getComputations().setMacKey(mac);
    }

    private void prepareEncryptionParams() {
        this.msg.getComputations().setEncryptionParamSet(this.getEncryptionParameters());
    }

    private void prepareKeyBlob() throws IOException {
        try {
            Point ecPoint = Point.createPoint((BigInteger)this.msg.getComputations().getClientPublicKeyX().getValue(), (BigInteger)this.msg.getComputations().getClientPublicKeyY().getValue(), this.chooser.getSelectedGostCurve());
            SubjectPublicKeyInfo ephemeralKey = SubjectPublicKeyInfo.getInstance((Object)GOSTUtils.generatePublicKey(this.chooser.getSelectedGostCurve(), ecPoint).getEncoded());
            Gost2814789EncryptedKey encryptedKey = new Gost2814789EncryptedKey((byte[])this.msg.getComputations().getEncryptedKey().getValue(), this.getMaskKey(), (byte[])this.msg.getComputations().getMacKey().getValue());
            ASN1ObjectIdentifier paramSet = new ASN1ObjectIdentifier((String)this.msg.getComputations().getEncryptionParamSet().getValue());
            GostR3410TransportParameters params = new GostR3410TransportParameters(paramSet, ephemeralKey, (byte[])this.msg.getComputations().getUkm().getValue());
            GostR3410KeyTransport transport = new GostR3410KeyTransport(encryptedKey, params);
            DERSequence proxyKeyBlobs = (DERSequence)DERSequence.getInstance((Object)this.getProxyKeyBlobs());
            TLSGostKeyTransportBlob blob = new TLSGostKeyTransportBlob(transport, proxyKeyBlobs);
            this.msg.setKeyTransportBlob(blob.getEncoded());
            LOGGER.debug("GOST key blob: " + ASN1Dump.dumpAsString((Object)((Object)blob), (boolean)true));
        }
        catch (Exception E) {
            this.msg.setKeyTransportBlob(new byte[0]);
            LOGGER.warn("Could not compute correct GOST key blob: using byte[0]");
        }
    }

    private byte[] getProxyKeyBlobs() {
        if (this.msg.getComputations().getProxyKeyBlobs() != null) {
            return (byte[])this.msg.getComputations().getProxyKeyBlobs().getValue();
        }
        return null;
    }

    private byte[] getMaskKey() {
        if (this.msg.getComputations().getMaskKey() != null) {
            return (byte[])this.msg.getComputations().getMaskKey().getValue();
        }
        return null;
    }

    protected abstract ASN1ObjectIdentifier getEncryptionParameters();

    protected abstract Digest getKeyAgreementDigestAlgorithm();

    protected abstract String getKeyPairGeneratorAlgorithm();

    static {
        oidMappings.put(CryptoProObjectIdentifiers.id_Gost28147_89_CryptoPro_TestParamSet, "E-TEST");
        oidMappings.put(CryptoProObjectIdentifiers.id_Gost28147_89_CryptoPro_A_ParamSet, "E-A");
        oidMappings.put(CryptoProObjectIdentifiers.id_Gost28147_89_CryptoPro_B_ParamSet, "E-B");
        oidMappings.put(CryptoProObjectIdentifiers.id_Gost28147_89_CryptoPro_C_ParamSet, "E-C");
        oidMappings.put(CryptoProObjectIdentifiers.id_Gost28147_89_CryptoPro_D_ParamSet, "E-D");
        oidMappings.put(RosstandartObjectIdentifiers.id_tc26_gost_28147_param_Z, "Param-Z");
    }
}

