"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || (function () {
    var ownKeys = function(o) {
        ownKeys = Object.getOwnPropertyNames || function (o) {
            var ar = [];
            for (var k in o) if (Object.prototype.hasOwnProperty.call(o, k)) ar[ar.length] = k;
            return ar;
        };
        return ownKeys(o);
    };
    return function (mod) {
        if (mod && mod.__esModule) return mod;
        var result = {};
        if (mod != null) for (var k = ownKeys(mod), i = 0; i < k.length; i++) if (k[i] !== "default") __createBinding(result, mod, k[i]);
        __setModuleDefault(result, mod);
        return result;
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
exports.definitions = void 0;
const m = __importStar(require("../lib/modernExtend"));
const tuya = __importStar(require("../lib/tuya"));
const { tuyaMagicPacket, tuyaOnOffActionLegacy } = tuya.modernExtend;
exports.definitions = [
    {
        fingerprint: tuya.fingerprint("SM0202", ["_TYZB01_2jzbhomb"]),
        model: "SBDV-00029",
        vendor: "Sber",
        description: "Smart motion sensor",
        extend: [
            m.iasZoneAlarm({ zoneType: "occupancy", zoneAttributes: ["alarm_1", "tamper", "battery_low"], alarmTimeout: true }),
            m.battery({ voltage: true, voltageReporting: true }),
        ],
    },
    {
        fingerprint: tuya.fingerprint("TS0203", ["_TYZB01_epni2jgy"]),
        model: "SBDV-00030",
        vendor: "Sber",
        description: "Smart opening sensor",
        extend: [
            m.ignoreClusterReport({ cluster: "genBasic" }),
            m.iasZoneAlarm({ zoneType: "contact", zoneAttributes: ["alarm_1", "tamper", "battery_low"] }),
            m.battery({ voltage: true, voltageReporting: true }),
        ],
    },
    {
        fingerprint: tuya.fingerprint("TS0041A", ["_TYZB01_ub7urdza"]),
        model: "SBDV-00032",
        vendor: "Sber",
        description: "Smart button",
        extend: [
            tuyaMagicPacket(),
            tuyaOnOffActionLegacy({ actions: ["single", "double", "hold"] }),
            m.battery({ percentageReporting: false }),
            /*
             * reporting.batteryPercentageRemaining removed as it was causing devices to fall of the network
             * every 1 hour, with light flashing when it happened, extremely short battery life, 2 presses for
             * action to register: https://github.com/Koenkk/zigbee2mqtt/issues/8072
             * Initially wrapped in a try catch: https://github.com/Koenkk/zigbee2mqtt/issues/6313
             */
        ],
    },
    {
        fingerprint: tuya.fingerprint("TS0201", ["_TZ3000_zfirri2d"]),
        model: "SBDV-00079",
        vendor: "Sber",
        description: "Smart temperature and humidity sensor",
        extend: [m.temperature(), m.humidity(), m.battery({ voltage: true, voltageReporting: true })],
    },
    {
        fingerprint: tuya.fingerprint("TS0207", ["_TZ3000_c8bqthpo"]),
        model: "SBDV-00154",
        vendor: "Sber",
        description: "Smart water leak sensor",
        extend: [
            m.ignoreClusterReport({ cluster: "genBasic" }),
            m.iasZoneAlarm({ zoneType: "water_leak", zoneAttributes: ["alarm_1", "battery_low"] }),
            m.battery(),
        ],
    },
];
//# sourceMappingURL=sber.js.map