/*
 * Decompiled with CFR 0.152.
 */
package de.escape.quincunx.dxf.reader;

import de.escape.quincunx.dxf.reader.DxfConverter;
import de.escape.quincunx.dxf.reader.DxfEntity;
import de.escape.quincunx.dxf.reader.DxfFile;
import de.escape.quincunx.trafo.Point3D;

public class DxfTEXT
extends DxfEntity {
    public static final short MIRROR_X = 2;
    public static final short MIRROR_Y = 4;
    public static final short H_LEFT = 0;
    public static final short H_CENTER = 1;
    public static final short H_RIGHT = 2;
    public static final short H_ADJUST = 3;
    public static final short H_MID = 4;
    public static final short H_FITTED = 5;
    public static final short V_BASE = 0;
    public static final short V_BOTTOM = 1;
    public static final short V_CENTER = 2;
    public static final short V_TOP = 3;
    protected Point3D position = new Point3D();
    protected float textHeight;
    protected String text;
    protected float angle;
    protected float aspect = 1.0f;
    protected float slant;
    protected String styleName;
    protected short mirror;
    protected short hAdjust;
    protected short vAdjust;
    protected Point3D adjust;

    public boolean setGroup(short grpNr, float fval) {
        switch (grpNr) {
            case 10: 
            case 20: 
            case 30: {
                this.setCoord(this.position, grpNr / 10, fval);
                return true;
            }
            case 11: 
            case 21: 
            case 31: {
                if (this.adjust == null) {
                    this.adjust = new Point3D();
                }
                this.setCoord(this.adjust, grpNr / 10, fval);
                return true;
            }
            case 40: {
                this.textHeight = fval;
                return true;
            }
            case 41: {
                this.aspect = fval;
                return true;
            }
            case 50: {
                this.angle = (float)((double)fval / 180.0 * Math.PI);
                return true;
            }
            case 51: {
                this.slant = (float)((double)fval / 180.0 * Math.PI);
                return true;
            }
        }
        return super.setGroup(grpNr, fval);
    }

    public boolean setGroup(short grpNr, int ival) {
        switch (grpNr) {
            case 71: {
                this.mirror = (short)ival;
                return true;
            }
            case 72: {
                this.hAdjust = (short)ival;
                return true;
            }
            case 73: {
                this.vAdjust = (short)ival;
                return true;
            }
        }
        return super.setGroup(grpNr, ival);
    }

    public boolean setGroup(short grpNr, String str) {
        switch (grpNr) {
            case 1: {
                this.text = str;
                return true;
            }
            case 7: {
                this.styleName = str;
                return true;
            }
        }
        return super.setGroup(grpNr, str);
    }

    public void convert(DxfConverter converter, DxfFile dxf, Object collector) {
        converter.convert(this, dxf, collector);
    }

    public final Point3D getPosition() {
        return this.position;
    }

    public final float getTextHeight() {
        return this.textHeight;
    }

    public final String getText() {
        return this.text;
    }

    public final float getRotation() {
        return this.angle;
    }

    public final float getAspectRatio() {
        return this.aspect;
    }

    public final float getSlant() {
        return this.slant;
    }

    public final String getStyleName() {
        return this.styleName;
    }

    public final short getMirror() {
        return this.mirror;
    }

    public final short getHAdjust() {
        return this.hAdjust;
    }

    public final short getVAdjust() {
        return this.vAdjust;
    }

    public final Point3D getAdjust() {
        return this.adjust;
    }
}

