/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect;

import ca.sqlpower.architect.UserSettings;
import java.lang.constant.Constable;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public abstract class AbstractUserSetting
implements UserSettings {
    private static Logger logger = Logger.getLogger(AbstractUserSetting.class);
    protected Map settings = new HashMap();

    @Override
    public int getInt(String propName, int defaultValue) {
        Object result = this.settings.get(propName);
        if (result == null) {
            return defaultValue;
        }
        if (result instanceof Number) {
            return ((Number)result).intValue();
        }
        if (result instanceof String) {
            try {
                return Integer.parseInt((String)result);
            }
            catch (NumberFormatException e) {
                logger.warn((Object)("Couldn't parse value '" + result + "' as integer for property '" + propName + "'"));
            }
        }
        logger.warn((Object)("Using default value for integer property '" + propName + "' because of unknown data type for existing value"));
        return defaultValue;
    }

    @Override
    public void setInt(String propName, int value) {
        this.settings.put(propName, new Integer(value));
    }

    @Override
    public boolean getBoolean(String propName, boolean defaultValue) {
        Object result = this.settings.get(propName);
        if (result == null) {
            return defaultValue;
        }
        if (result instanceof Boolean) {
            return (Boolean)result;
        }
        if (result instanceof String) {
            return Boolean.valueOf((String)result);
        }
        logger.warn((Object)("Using default value for boolean property '" + propName + "' because of unknown data type for existing value"));
        return defaultValue;
    }

    @Override
    public void setBoolean(String propName, boolean value) {
        this.settings.put(propName, value);
    }

    @Override
    public void setObject(String propName, Object value) {
        this.settings.put(propName, value);
    }

    @Override
    public void putSetting(String propName, String propClassName, String propValue) {
        Constable prop = null;
        if (propClassName.equals("java.lang.Integer")) {
            try {
                prop = Integer.valueOf(propValue);
            }
            catch (NumberFormatException e) {
                logger.warn((Object)("Invalid integer setting " + propName + "=" + propValue));
                return;
            }
        } else if (propClassName.equals("java.lang.Boolean")) {
            prop = Boolean.valueOf(propValue);
        } else {
            logger.warn((Object)("Unknown property class " + propClassName));
            return;
        }
        this.settings.put(propName, prop);
    }

    @Override
    public String getString(String propName, String defaultValue) {
        Object result = this.settings.get(propName);
        if (result == null) {
            return defaultValue;
        }
        return result.toString();
    }

    @Override
    public void setString(String propName, String value) {
        this.settings.put(propName, value);
    }

    @Override
    public Object getObject(String propName, Object defaultValue) {
        Object result = this.settings.get(propName);
        if (result == null) {
            return defaultValue;
        }
        return result;
    }

    @Override
    public Set getSettingNames() {
        return this.settings.keySet();
    }
}

