/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.swingui.olap.action;

import ca.sqlpower.architect.olap.MondrianModel;
import ca.sqlpower.architect.olap.OLAPUtil;
import ca.sqlpower.architect.swingui.AbstractPlacer;
import ca.sqlpower.architect.swingui.ArchitectSwingSession;
import ca.sqlpower.architect.swingui.PlayPen;
import ca.sqlpower.architect.swingui.PlayPenContentPane;
import ca.sqlpower.architect.swingui.action.AbstractArchitectAction;
import ca.sqlpower.architect.swingui.olap.CubeEditPanel;
import ca.sqlpower.architect.swingui.olap.CubePane;
import ca.sqlpower.architect.swingui.olap.OSUtils;
import ca.sqlpower.sqlobject.SQLObjectException;
import ca.sqlpower.swingui.DataEntryPanel;
import java.awt.Point;
import java.awt.event.ActionEvent;
import javax.swing.Icon;
import javax.swing.KeyStroke;

public class CreateCubeAction
extends AbstractArchitectAction {
    private final MondrianModel.Schema schema;

    public CreateCubeAction(ArchitectSwingSession session, MondrianModel.Schema schema, PlayPen pp) {
        super(session, pp, "New Cube...", "Create a new cube in this schema (c)", (Icon)OSUtils.CUBE_ADD_ICON);
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke('c'));
        this.schema = schema;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        PlayPenContentPane pane = this.getPlaypen().getContentPane();
        pane.begin("Creating a Cube and its CubePane");
        try {
            MondrianModel.Cube cube = new MondrianModel.Cube();
            int count = 1;
            while (!OLAPUtil.isNameUnique(this.schema, MondrianModel.Cube.class, "New Cube " + count)) {
                ++count;
            }
            cube.setName("New Cube " + count);
            CubePane cp = new CubePane(cube, pane);
            CubePlacer cubePlacer = new CubePlacer(cp);
            cubePlacer.dirtyup();
            pane.commit();
        }
        catch (Throwable ex) {
            pane.rollback("Error creating Cube: " + ex.toString());
            throw new RuntimeException(ex);
        }
    }

    private class CubePlacer
    extends AbstractPlacer {
        private final CubePane cp;

        CubePlacer(CubePane cp) {
            super(CreateCubeAction.this.getPlaypen());
            this.cp = cp;
        }

        @Override
        protected String getEditDialogTitle() {
            return "Cube Properties";
        }

        @Override
        public DataEntryPanel place(Point p) throws SQLObjectException {
            try {
                CreateCubeAction.this.getSession().getWorkspace().begin("Create Cube");
                CreateCubeAction.this.schema.addCube((MondrianModel.Cube)((Object)this.cp.getModel()));
                this.playpen.selectNone();
                this.playpen.addPlayPenComponent(this.cp, p);
                this.cp.setSelected(true, 4);
                CreateCubeAction.this.getSession().getWorkspace().commit();
            }
            catch (Throwable e) {
                CreateCubeAction.this.getSession().getWorkspace().rollback("Exception occured: " + e.toString());
                throw new RuntimeException(e);
            }
            CubeEditPanel editPanel = new CubeEditPanel((MondrianModel.Cube)((Object)this.cp.getModel()), this.cp.getPlayPen(), this.cp.getPlayPen().getSession()){

                @Override
                public void discardChanges() {
                    CreateCubeAction.this.schema.removeCube((MondrianModel.Cube)((Object)CubePlacer.this.cp.getModel()));
                }

                @Override
                public boolean applyChanges() {
                    return super.applyChanges();
                }
            };
            return editPanel;
        }
    }
}

