/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mime4j.message;

import java.io.IOException;
import java.io.InputStream;
import java.util.Stack;
import org.apache.james.mime4j.MimeException;
import org.apache.james.mime4j.codec.Base64InputStream;
import org.apache.james.mime4j.codec.QuotedPrintableInputStream;
import org.apache.james.mime4j.descriptor.BodyDescriptor;
import org.apache.james.mime4j.field.AbstractField;
import org.apache.james.mime4j.field.ParsedField;
import org.apache.james.mime4j.message.BodyFactory;
import org.apache.james.mime4j.message.BodyPart;
import org.apache.james.mime4j.message.Entity;
import org.apache.james.mime4j.message.Header;
import org.apache.james.mime4j.message.Message;
import org.apache.james.mime4j.message.Multipart;
import org.apache.james.mime4j.message.SingleBody;
import org.apache.james.mime4j.parser.ContentHandler;
import org.apache.james.mime4j.parser.Field;
import org.apache.james.mime4j.storage.StorageProvider;
import org.apache.james.mime4j.util.ByteArrayBuffer;
import org.apache.james.mime4j.util.ByteSequence;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessageBuilder
implements ContentHandler {
    private final Entity entity;
    private final BodyFactory bodyFactory;
    private Stack<Object> stack = new Stack();

    public MessageBuilder(Entity entity) {
        this.entity = entity;
        this.bodyFactory = new BodyFactory();
    }

    public MessageBuilder(Entity entity, StorageProvider storageProvider) {
        this.entity = entity;
        this.bodyFactory = new BodyFactory(storageProvider);
    }

    private void expect(Class<?> c) {
        if (!c.isInstance(this.stack.peek())) {
            throw new IllegalStateException("Internal stack error: Expected '" + c.getName() + "' found '" + this.stack.peek().getClass().getName() + "'");
        }
    }

    @Override
    public void startMessage() throws MimeException {
        if (this.stack.isEmpty()) {
            this.stack.push(this.entity);
        } else {
            this.expect(Entity.class);
            Message m = new Message();
            ((Entity)this.stack.peek()).setBody(m);
            this.stack.push(m);
        }
    }

    @Override
    public void endMessage() throws MimeException {
        this.expect(Message.class);
        this.stack.pop();
    }

    @Override
    public void startHeader() throws MimeException {
        this.stack.push(new Header());
    }

    @Override
    public void field(Field field) throws MimeException {
        this.expect(Header.class);
        ParsedField parsedField = AbstractField.parse(field.getRaw());
        ((Header)this.stack.peek()).addField(parsedField);
    }

    @Override
    public void endHeader() throws MimeException {
        this.expect(Header.class);
        Header h = (Header)this.stack.pop();
        this.expect(Entity.class);
        ((Entity)this.stack.peek()).setHeader(h);
    }

    @Override
    public void startMultipart(BodyDescriptor bd) throws MimeException {
        this.expect(Entity.class);
        Entity e = (Entity)this.stack.peek();
        String subType = bd.getSubType();
        Multipart multiPart = new Multipart(subType);
        e.setBody(multiPart);
        this.stack.push(multiPart);
    }

    @Override
    public void body(BodyDescriptor bd, InputStream is) throws MimeException, IOException {
        this.expect(Entity.class);
        String enc = bd.getTransferEncoding();
        InputStream decodedStream = "base64".equals(enc) ? new Base64InputStream(is) : ("quoted-printable".equals(enc) ? new QuotedPrintableInputStream(is) : is);
        SingleBody body = bd.getMimeType().startsWith("text/") ? this.bodyFactory.textBody(decodedStream, bd.getCharset()) : this.bodyFactory.binaryBody(decodedStream);
        Entity entity = (Entity)this.stack.peek();
        entity.setBody(body);
    }

    @Override
    public void endMultipart() throws MimeException {
        this.stack.pop();
    }

    @Override
    public void startBodyPart() throws MimeException {
        this.expect(Multipart.class);
        BodyPart bodyPart = new BodyPart();
        ((Multipart)this.stack.peek()).addBodyPart(bodyPart);
        this.stack.push(bodyPart);
    }

    @Override
    public void endBodyPart() throws MimeException {
        this.expect(BodyPart.class);
        this.stack.pop();
    }

    @Override
    public void epilogue(InputStream is) throws MimeException, IOException {
        this.expect(Multipart.class);
        ByteSequence bytes = MessageBuilder.loadStream(is);
        ((Multipart)this.stack.peek()).setEpilogueRaw(bytes);
    }

    @Override
    public void preamble(InputStream is) throws MimeException, IOException {
        this.expect(Multipart.class);
        ByteSequence bytes = MessageBuilder.loadStream(is);
        ((Multipart)this.stack.peek()).setPreambleRaw(bytes);
    }

    @Override
    public void raw(InputStream is) throws MimeException, IOException {
        throw new UnsupportedOperationException("Not supported");
    }

    private static ByteSequence loadStream(InputStream in) throws IOException {
        int b;
        ByteArrayBuffer bab = new ByteArrayBuffer(64);
        while ((b = in.read()) != -1) {
            bab.append(b);
        }
        return bab;
    }
}

