/*
 * Decompiled with CFR 0.152.
 */
package org.openide.explorer.view;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.geom.Line2D;
import java.util.HashMap;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.UIManager;

final class DropGlassPane
extends JPanel {
    private static HashMap<Integer, DropGlassPane> map = new HashMap();
    private static final int MIN_X = 5;
    private static final int MIN_Y = 3;
    private static final int MIN_WIDTH = 10;
    private static final int MIN_HEIGTH = 3;
    private static transient Component oldPane;
    private static transient JComponent originalSource;
    private static transient boolean wasVisible;
    Line2D line = null;

    private DropGlassPane() {
    }

    public static synchronized DropGlassPane getDefault(JComponent jComponent) {
        Integer n = new Integer(System.identityHashCode(jComponent));
        if (map.get(n) == null) {
            DropGlassPane dropGlassPane = new DropGlassPane();
            dropGlassPane.setOpaque(false);
            map.put(n, dropGlassPane);
        }
        return map.get(n);
    }

    static void setOriginalPane(JComponent jComponent, Component component, boolean bl) {
        oldPane = component;
        originalSource = jComponent;
        wasVisible = bl;
    }

    static boolean isOriginalPaneStored() {
        return oldPane != null;
    }

    static void putBackOriginal() {
        if (oldPane == null) {
            return;
        }
        originalSource.getRootPane().setGlassPane(oldPane);
        oldPane.setVisible(wasVisible);
        oldPane = null;
    }

    public void setVisible(boolean bl) {
        super.setVisible(bl);
        if (!bl) {
            this.setDropLine(null);
        }
    }

    public void setDropLine(Line2D line2D) {
        this.line = line2D;
    }

    private Line2D checkLineBounds(Line2D line2D) {
        Rectangle rectangle = this.getBounds();
        double d = Math.max(line2D.getX1(), (double)(rectangle.x + 5));
        double d2 = Math.max(line2D.getY1(), (double)(rectangle.y + 3));
        double d3 = Math.min(line2D.getX2(), (double)(rectangle.x + rectangle.width - 10));
        double d4 = Math.min(line2D.getY2(), (double)(rectangle.y + rectangle.height - 3));
        line2D.setLine(d, d2, d3, d4);
        return line2D;
    }

    public void paint(Graphics graphics) {
        if (this.line != null) {
            Color color = UIManager.getColor("Tree.dropLine");
            if (color != null) {
                graphics.setColor(color);
            }
            this.line = this.checkLineBounds(this.line);
            int n = (int)this.line.getX1();
            int n2 = (int)this.line.getX2();
            int n3 = (int)this.line.getY1();
            graphics.setColor(UIManager.getColor("Tree.selectionBackground"));
            graphics.drawLine(n + 2, n3, n2 - 2, n3);
            graphics.drawLine(n + 2, n3 + 1, n2 - 2, n3 + 1);
            graphics.drawLine(n, n3 - 2, n, n3 + 3);
            graphics.drawLine(n + 1, n3 - 1, n + 1, n3 + 2);
            graphics.drawLine(n2, n3 - 2, n2, n3 + 3);
            graphics.drawLine(n2 - 1, n3 - 1, n2 - 1, n3 + 2);
        }
    }
}

