/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.internal.util;

import org.mariadb.jdbc.internal.com.send.parameters.ParameterHolder;
import org.mariadb.jdbc.internal.util.dao.PrepareResult;
import org.mariadb.jdbc.util.Options;

public class LogQueryTool {
    public static String queryWithParams(PrepareResult serverPrepareResult, ParameterHolder[] parameters, Options options) {
        if (options.dumpQueriesOnException && serverPrepareResult != null) {
            StringBuilder sql = new StringBuilder(serverPrepareResult.getSql());
            if (serverPrepareResult.getParamCount() > 0 && parameters != null) {
                sql.append(", parameters [");
                if (parameters.length > 0) {
                    for (int i = 0; i < Math.min(parameters.length, serverPrepareResult.getParamCount()); ++i) {
                        sql.append(parameters[i].toString()).append(",");
                    }
                    sql = new StringBuilder(sql.substring(0, sql.length() - 1));
                }
                sql.append("]");
            }
            if (options.maxQuerySizeToLog != 0 && sql.length() > options.maxQuerySizeToLog - 3) {
                return sql.substring(0, options.maxQuerySizeToLog - 3) + "...";
            }
            return sql.toString();
        }
        return null;
    }
}

