%% Generated by lilypond-book
%% Options: [exampleindent=10.16\mm,indent=0\mm,line-width=160\mm]
\include "lilypond-book-preamble.ly"


% ****************************************************************
% Start cut-&-pastable-section
% ****************************************************************

#(ly:set-option 'eps-box-padding 3.000000)



\paper {
  indent = 0\mm
  line-width = 160\mm
  % offset the left padding, also add 1mm as lilypond creates cropped
  % images with a little space on the right
  line-width = #(- line-width (* mm  3.000000) (* mm 1))
}

\layout {
  
}




% ****************************************************************
% ly snippet:
% ****************************************************************
\sourcefilename "snippets/customizing-the-chord-grid-style.ly"
\sourcefileline 0
%% DO NOT EDIT this file manually; it was automatically
%% generated from `Documentation/snippets/new/`.
%%
%% Make any changes in `Documentation/snippets/new/`,
%% then run `scripts/auxiliar/makelsr.pl --new`.
%%
%% This file is in the public domain.
%%
%% Note: this file works from version 2.23.10.

\version "2.23.13"

\header {
%%  Translation of GIT committish: a3fd5364fc4f247579da0ed2bfea887ab37285c6
  texidocfr = "
Il est possible de personnaliser la division des cases à l'aide des
propiétés de @code{ChordSquare} @code{measure-division-lines-alist} et
@code{measure-division-chord-placement-alist}, qui sont toutes deux des
listes associatives. Leurs clés sont des divisions de la mesure,
autrement dit des listes de fractions de la mesure que chaque accord,
silence ou saut représente. Plus précisément, cette liste de divisions
de la mesure est constituée de nombres positifs exacts dont l'addition
fait 1, comme par exemple @code{'(1/2 1/4 1/4)}. L'exigence d'exactitude
signifie que @code{1/2} est valide, contrairement à @code{0.5}.

Les valeurs de @code{measure-division-lines-alist} sont des listes de
lignes, représentes sous la forme
@code{(@var{x1} @var{y1} @var{x2} @var{y2})}. La ligne débute au point
@code{(@var{x1} . @var{y1})} et se temine en
@code{(@var{x2} . @var{y2})}. Les coordonnées sont comprises dans
l'intervalle [@minus{}1,@tie{}1] relativement à l'étendue de la case.

Les valeurs de @code{measure-division-chord-placement-alist} sont des
listes de paires @code{(@var{x} . @var{y})} indiquant le positionnement
des accords respectifs.

L'exemple ci-dessous illustre le cas particulier d'une grille dont le
style spécifie le découpage des mesures en trois parts égales.
"

  doctitlefr = "Personnalisation du style de grille harmonique"

  lsrtags = "chords"

  texidoc = "
Custom divisions of chord squares can be defined through the
@code{measure-division-lines-alist} and @code{measure-division-chord-placement-alist}
properties of @code{ChordSquare}.  These are both alists.  Their keys are
measure divisions, namely lists which give the fraction of the measure
that each chord (or rest, or skip) represents.  More precisely, a measure
division alist is made of positive, exact numbers adding up to 1, for
example: @code{'(1/2 1/4 1/4)}.  The exactness requirement means that,
e.g., @code{1/2} is valid but not @code{0.5}.

The values in @code{measure-division-lines-alist} are lists of lines,
which are represented as @code{(@var{x1} @var{y1} @var{x2} @var{y2})}.
The line starts at the point @code{(@var{x1} . @var{y1})} and ends at
@code{(@var{x2} . @var{y2})}.  Coordinates are expressed in the
[-1,@tie{}1] scale relative to the extent of the square.

The values in @code{measure-division-chord-placement-alist} are
lists of @code{(@var{x} . @var{y})} pairs giving the placement of
the respective chords.

This example defines a peculiar chord grid style that has a rule
for measures divided in three equal parts.
"

  doctitle = "Customizing the chord grid style"
} % begin verbatim


\paper {
  line-width = 10\cm
  ragged-right = ##f
}

\new ChordGrid \with {
  \override ChordSquare.measure-division-lines-alist =
    #'(((1) . ())
       ((1/3 1/3 1/3) . ((-1 -0.4 0 1) (0 -1 1 0.4))))
  \override ChordSquare.measure-division-chord-placement-alist =
    #'(((1) . ((0 . 0)))
       ((1/3 1/3 1/3) . ((-0.7 . 0.5) (0 . 0) (0.7 . -0.5))))
}
\chordmode {
  \time 3/4
  c2.
  c4 c4 c4
}



% ****************************************************************
% end ly snippet
% ****************************************************************
