/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.jdbc;

import com.microsoft.sqlserver.jdbc.CancelableRequest;
import com.microsoft.sqlserver.jdbc.DBComms;
import com.microsoft.sqlserver.jdbc.DDC;
import com.microsoft.sqlserver.jdbc.DataTypes;
import com.microsoft.sqlserver.jdbc.InputStreamArgs;
import com.microsoft.sqlserver.jdbc.SQLServerConnection;
import com.microsoft.sqlserver.jdbc.SQLServerException;
import com.microsoft.sqlserver.jdbc.Util;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.text.Format;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Calendar;

final class TDSWriter {
    private final SQLServerConnection con;
    private final DBComms dbCom;
    private boolean isLogging = false;
    private boolean dataIsLoggable = true;
    private byte tdsMessageType = 0;
    private static final byte TDS_MESSAGE_STATUS_NORMAL = 0;
    private static final byte TDS_MESSAGE_STATUS_EOM = 1;
    private static final byte TDS_MESSAGE_STATUS_ATTENTION = 2;
    private static final byte TDS_MESSAGE_STATUS_RESET_CONN = 8;
    private byte tdsMessageStatus;
    private int tdsPacketSize = 0;
    CancelableRequest request = null;
    private static final int TDS_PACKET_HEADER_SIZE = 8;
    private static final byte[] placeholderHeader = new byte[8];
    private int secsTimeout;
    private byte[] valueBytes = new byte[256];
    private int packetNo;
    private ByteBuffer stagingBuffer;
    private ByteBuffer socketBuffer;
    private ByteBuffer logBuffer;

    void setDataLoggable(boolean bl) {
        this.dataIsLoggable = bl;
    }

    private boolean endOfMessage() {
        return 0 != (this.tdsMessageStatus & 1);
    }

    final void sendCancel() throws SQLServerException {
        this.startRequest((byte)6, 0, this.request);
        this.endRequest();
    }

    final void setTimeout(int n) {
        this.secsTimeout = n;
    }

    TDSWriter(SQLServerConnection sQLServerConnection, DBComms dBComms) {
        this.con = sQLServerConnection;
        this.dbCom = dBComms;
    }

    void preparePacket() throws SQLServerException {
        if (this.endOfMessage()) {
            return;
        }
        ++this.packetNo;
        if (this.isLogging) {
            Arrays.fill(this.logBuffer.array(), (byte)-2);
            this.logBuffer.clear();
        }
        this.writeBytes(placeholderHeader);
    }

    void writeMessageHeader() throws SQLServerException {
        if (this.dbCom.getTDSVersion().isYukonOrLater() && (1 == this.tdsMessageType || 14 == this.tdsMessageType || 3 == this.tdsMessageType)) {
            this.writeInt(22);
            this.writeInt(18);
            this.writeShort((short)2);
            this.writeBytes(this.con.getTransactionDescriptor());
            this.writeInt(1);
        }
    }

    void startRequest(byte by) throws SQLServerException {
        this.startRequest(by, 0, null);
    }

    void startRequest(byte by, int n, CancelableRequest cancelableRequest) throws SQLServerException {
        this.tdsMessageType = by;
        this.tdsMessageStatus = 0;
        this.packetNo = 0;
        this.isLogging = this.dbCom.isLoggingTDSPackets();
        this.dataIsLoggable = true;
        this.request = cancelableRequest;
        if (this.tdsPacketSize != this.con.getTDSPacketSize()) {
            int n2 = this.con.getTDSPacketSize();
            this.dbCom.setSendBufferSize(n2);
            this.socketBuffer = ByteBuffer.allocate(n2).order(ByteOrder.LITTLE_ENDIAN);
            this.stagingBuffer = ByteBuffer.allocate(n2).order(ByteOrder.LITTLE_ENDIAN);
            this.logBuffer = ByteBuffer.allocate(n2).order(ByteOrder.LITTLE_ENDIAN);
            this.tdsPacketSize = n2;
        }
        this.socketBuffer.position(this.socketBuffer.limit());
        this.stagingBuffer.clear();
        this.setTimeout(n);
        this.preparePacket();
        this.writeMessageHeader();
    }

    void endRequest() throws SQLServerException {
        this.tdsMessageStatus = (byte)(this.tdsMessageStatus | 1);
        this.writePacketHeader();
        this.flush();
        this.flush();
        if (null != this.request && 6 != this.tdsMessageType) {
            this.request.flip();
        }
    }

    void writeByte(byte by) throws SQLServerException {
        if (this.stagingBuffer.remaining() >= 1) {
            this.stagingBuffer.put(by);
            if (this.isLogging) {
                if (this.dataIsLoggable) {
                    this.logBuffer.put(by);
                } else {
                    this.logBuffer.position(this.logBuffer.position() + 1);
                }
            }
        } else {
            this.valueBytes[0] = by;
            this.writeWrappedBytes(this.valueBytes, 1);
        }
    }

    void writeTinyInt(short s) throws SQLServerException {
        if (this.stagingBuffer.remaining() >= 1) {
            this.stagingBuffer.put((byte)(s & 0xFF));
            if (this.isLogging) {
                if (this.dataIsLoggable) {
                    this.logBuffer.put((byte)(s & 0xFF));
                } else {
                    this.logBuffer.position(this.logBuffer.position() + 1);
                }
            }
        } else {
            this.valueBytes[0] = (byte)(s & 0xFF);
            this.writeWrappedBytes(this.valueBytes, 1);
        }
    }

    void writeChar(char c) throws SQLServerException {
        if (this.stagingBuffer.remaining() >= 2) {
            this.stagingBuffer.putChar(c);
            if (this.isLogging) {
                if (this.dataIsLoggable) {
                    this.logBuffer.putChar(c);
                } else {
                    this.logBuffer.position(this.logBuffer.position() + 2);
                }
            }
        } else {
            this.valueBytes[0] = (byte)(c >> 0 & 0xFF);
            this.valueBytes[1] = (byte)(c >> 8 & 0xFF);
            this.writeWrappedBytes(this.valueBytes, 2);
        }
    }

    void writeShort(short s) throws SQLServerException {
        if (this.stagingBuffer.remaining() >= 2) {
            this.stagingBuffer.putShort(s);
            if (this.isLogging) {
                if (this.dataIsLoggable) {
                    this.logBuffer.putShort(s);
                } else {
                    this.logBuffer.position(this.logBuffer.position() + 2);
                }
            }
        } else {
            this.valueBytes[0] = (byte)(s >> 0 & 0xFF);
            this.valueBytes[1] = (byte)(s >> 8 & 0xFF);
            this.writeWrappedBytes(this.valueBytes, 2);
        }
    }

    void writeInt(int n) throws SQLServerException {
        if (this.stagingBuffer.remaining() >= 4) {
            this.stagingBuffer.putInt(n);
            if (this.isLogging) {
                if (this.dataIsLoggable) {
                    this.logBuffer.putInt(n);
                } else {
                    this.logBuffer.position(this.logBuffer.position() + 4);
                }
            }
        } else {
            this.valueBytes[0] = (byte)(n >> 0 & 0xFF);
            this.valueBytes[1] = (byte)(n >> 8 & 0xFF);
            this.valueBytes[2] = (byte)(n >> 16 & 0xFF);
            this.valueBytes[3] = (byte)(n >> 24 & 0xFF);
            this.writeWrappedBytes(this.valueBytes, 4);
        }
    }

    void writeLong(long l) throws SQLServerException {
        if (this.stagingBuffer.remaining() >= 8) {
            this.stagingBuffer.putLong(l);
            if (this.isLogging) {
                if (this.dataIsLoggable) {
                    this.logBuffer.putLong(l);
                } else {
                    this.logBuffer.position(this.logBuffer.position() + 8);
                }
            }
        } else {
            this.valueBytes[0] = (byte)(l >> 0 & 0xFFL);
            this.valueBytes[1] = (byte)(l >> 8 & 0xFFL);
            this.valueBytes[2] = (byte)(l >> 16 & 0xFFL);
            this.valueBytes[3] = (byte)(l >> 24 & 0xFFL);
            this.valueBytes[4] = (byte)(l >> 32 & 0xFFL);
            this.valueBytes[5] = (byte)(l >> 40 & 0xFFL);
            this.valueBytes[6] = (byte)(l >> 48 & 0xFFL);
            this.valueBytes[7] = (byte)(l >> 56 & 0xFFL);
            this.writeWrappedBytes(this.valueBytes, 8);
        }
    }

    void writeBytes(byte[] byArray) throws SQLServerException {
        this.writeBytes(byArray, byArray.length);
    }

    void writeBytes(byte[] byArray, int n) throws SQLServerException {
        int n2;
        int n3 = 0;
        while ((n2 = n - n3) > 0) {
            if (0 == this.stagingBuffer.remaining()) {
                this.writePacketHeader();
                this.flush();
            }
            if (n2 > this.stagingBuffer.remaining()) {
                n2 = this.stagingBuffer.remaining();
            }
            this.stagingBuffer.put(byArray, n3, n2);
            if (this.isLogging) {
                if (this.dataIsLoggable) {
                    this.logBuffer.put(byArray, n3, n2);
                } else {
                    this.logBuffer.position(this.logBuffer.position() + n2);
                }
            }
            n3 += n2;
        }
    }

    void writeChars(char[] cArray, int n) throws SQLServerException {
        byte[] byArray = new byte[8000];
        int n2 = 0;
        do {
            int n3 = 0;
            while (n2 < n && n3 < byArray.length) {
                byArray[n3++] = (byte)(cArray[n2] >> 0 & 0xFF);
                byArray[n3++] = (byte)(cArray[n2] >> 8 & 0xFF);
                ++n2;
            }
            this.writeBytes(byArray, n3);
        } while (n2 < n);
    }

    void writeWrappedBytes(byte[] byArray, int n) throws SQLServerException {
        int n2 = this.stagingBuffer.remaining();
        if (n2 > 0) {
            this.stagingBuffer.put(byArray, 0, n2);
            if (this.isLogging) {
                if (this.dataIsLoggable) {
                    this.logBuffer.put(byArray, 0, n2);
                } else {
                    this.logBuffer.position(this.logBuffer.position() + n2);
                }
            }
        }
        this.writePacketHeader();
        this.flush();
        this.stagingBuffer.put(byArray, n2, n - n2);
        if (this.isLogging) {
            if (this.dataIsLoggable) {
                this.logBuffer.put(byArray, n2, n - n2);
            } else {
                this.logBuffer.position(this.logBuffer.position() + n2);
            }
        }
    }

    void writeString(String string) throws SQLServerException {
        int n = 0;
        int n2 = string.length();
        while (n < n2) {
            int n3 = 2 * (n2 - n);
            if (n3 > this.valueBytes.length) {
                n3 = this.valueBytes.length;
            }
            int n4 = 0;
            while (n4 < n3) {
                char c = string.charAt(n++);
                this.valueBytes[n4++] = (byte)(c >> 0 & 0xFF);
                this.valueBytes[n4++] = (byte)(c >> 8 & 0xFF);
            }
            this.writeBytes(this.valueBytes, n4);
        }
    }

    void writeStream(InputStream inputStream, long l, boolean bl) throws SQLServerException {
        Object object;
        long l2 = 0L;
        try {
            object = new byte[8000];
            int n = 0;
            do {
                int n2 = 0;
                for (int i = ((byte[])object).length; i > 0 && (n = inputStream.read((byte[])object, n2, i)) > 0; i -= n) {
                    l2 += (long)n;
                    n2 += n;
                }
                if (n2 <= 0) continue;
                if (bl) {
                    this.writeInt(n2);
                }
                this.writeBytes((byte[])object, n2);
            } while (-1 != n);
        }
        catch (IOException iOException) {
            SQLServerException.makeFromDriverError(this.con, null, iOException.getMessage(), "08006", true);
        }
        if (-1L != l && l2 != l) {
            this.tdsMessageStatus = (byte)(this.tdsMessageStatus | 2);
            this.endRequest();
            this.dbCom.receive(this.con);
            object = new MessageFormat(SQLServerException.getErrString("R_mismatchedStreamLength"));
            Object[] objectArray = new Object[]{new Long(l), new Long(l2)};
            SQLServerException.makeFromDriverError(this.con, null, ((Format)object).format(objectArray), null, true);
        }
    }

    void writeReader(Reader reader, int n, boolean bl) throws SQLServerException {
        int n2 = 0;
        char[] cArray = new char[4000];
        try {
            int n3 = 0;
            do {
                int n4 = 0;
                for (int i = cArray.length; i > 0 && (n3 = reader.read(cArray, n4, i)) > 0; i -= n3) {
                    n2 += n3;
                    n4 += n3;
                }
                if (n4 <= 0) continue;
                if (bl) {
                    this.writeInt(2 * n4);
                }
                this.writeChars(cArray, n4);
            } while (-1 != n3);
        }
        catch (IOException iOException) {
            SQLServerException.makeFromDriverError(this.con, null, iOException.getMessage(), "08006", true);
        }
        if (-1 != n && n2 != n) {
            this.tdsMessageStatus = (byte)(this.tdsMessageStatus | 2);
            this.endRequest();
            this.dbCom.receive(this.con);
            MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_mismatchedStreamLength"));
            Object[] objectArray = new Object[]{new Integer(n), new Integer(n2)};
            SQLServerException.makeFromDriverError(this.con, null, messageFormat.format(objectArray), null, true);
        }
    }

    void writePacketHeader() {
        int n = this.stagingBuffer.position();
        this.stagingBuffer.put(0, this.tdsMessageType);
        this.stagingBuffer.put(1, this.tdsMessageStatus);
        this.stagingBuffer.put(2, (byte)(n >> 8 & 0xFF));
        this.stagingBuffer.put(3, (byte)(n >> 0 & 0xFF));
        this.stagingBuffer.putShort(4, (short)0);
        this.stagingBuffer.put(6, (byte)(this.packetNo % 256));
        this.stagingBuffer.put(7, (byte)0);
        if (this.isLogging) {
            this.logBuffer.put(0, this.tdsMessageType);
            this.logBuffer.put(1, this.tdsMessageStatus);
            this.logBuffer.put(2, (byte)(n >> 8 & 0xFF));
            this.logBuffer.put(3, (byte)(n >> 0 & 0xFF));
            this.logBuffer.putShort(4, (short)0);
            this.logBuffer.put(6, (byte)(this.packetNo % 256));
            this.logBuffer.put(7, (byte)0);
        }
    }

    void flush() throws SQLServerException {
        try {
            this.dbCom.getTDSOutputStream().write(this.socketBuffer.array(), this.socketBuffer.position(), this.socketBuffer.remaining());
            this.socketBuffer.position(this.socketBuffer.limit());
        }
        catch (IOException iOException) {
            SQLServerException.makeFromDriverError(this.con, null, iOException.getMessage(), "08006", true);
        }
        if (this.stagingBuffer.position() >= 8) {
            ByteBuffer byteBuffer = this.stagingBuffer;
            this.stagingBuffer = this.socketBuffer;
            this.socketBuffer = byteBuffer;
            this.socketBuffer.flip();
            this.stagingBuffer.clear();
            if (this.isLogging) {
                this.dbCom.logTDSPacket(this.logBuffer.array(), 0, this.socketBuffer.limit(), "Sending TDS packet: " + this.socketBuffer.limit() + " bytes");
            }
            this.preparePacket();
            try {
                this.dbCom.getTDSOutputStream().write(this.socketBuffer.array(), this.socketBuffer.position(), this.socketBuffer.remaining());
                this.socketBuffer.position(this.socketBuffer.limit());
            }
            catch (IOException iOException) {
                SQLServerException.makeFromDriverError(this.con, null, iOException.getMessage(), "08006", true);
            }
        }
    }

    private void writeRPCNameValType(String string, boolean bl, int n) throws SQLServerException {
        int n2 = 0;
        if (null != string) {
            n2 = string.length() + 1;
        }
        this.writeByte((byte)n2);
        if (n2 > 0) {
            this.writeChar('@');
            this.writeString(string);
        }
        this.writeByte((byte)(bl ? 1 : 0));
        this.writeByte((byte)n);
    }

    void writeRPCBit(String string, Boolean bl, boolean bl2) throws SQLServerException {
        this.writeRPCNameValType(string, bl2, 104);
        this.writeByte((byte)1);
        if (null == bl) {
            this.writeByte((byte)0);
        } else {
            this.writeByte((byte)1);
            this.writeByte((byte)(bl != false ? 1 : 0));
        }
    }

    void writeRPCByte(String string, Byte by, boolean bl) throws SQLServerException {
        this.writeRPCNameValType(string, bl, 38);
        this.writeByte((byte)1);
        if (null == by) {
            this.writeByte((byte)0);
        } else {
            this.writeByte((byte)1);
            this.writeTinyInt(by.byteValue());
        }
    }

    void writeRPCShort(String string, Short s, boolean bl) throws SQLServerException {
        this.writeRPCNameValType(string, bl, 38);
        this.writeByte((byte)2);
        if (null == s) {
            this.writeByte((byte)0);
        } else {
            this.writeByte((byte)2);
            this.writeShort(s);
        }
    }

    void writeRPCInt(String string, Integer n, boolean bl) throws SQLServerException {
        this.writeRPCNameValType(string, bl, 38);
        this.writeByte((byte)4);
        if (null == n) {
            this.writeByte((byte)0);
        } else {
            this.writeByte((byte)4);
            this.writeInt(n);
        }
    }

    void writeRPCLong(String string, Long l, boolean bl) throws SQLServerException {
        this.writeRPCNameValType(string, bl, 38);
        this.writeByte((byte)8);
        if (null == l) {
            this.writeByte((byte)0);
        } else {
            this.writeByte((byte)8);
            this.writeLong(l);
        }
    }

    void writeRPCReal(String string, Float f, boolean bl) throws SQLServerException {
        this.writeRPCNameValType(string, bl, 109);
        int n = 4;
        this.writeByte((byte)n);
        if (null == f) {
            this.writeByte((byte)0);
        } else {
            this.writeByte((byte)n);
            int n2 = Float.floatToIntBits(f.floatValue());
            int n3 = 255;
            int n4 = 0;
            for (int i = 0; i < 4; ++i) {
                this.writeByte((byte)((n2 & n3) >> n4));
                n4 += 8;
                n3 <<= 8;
            }
        }
    }

    void writeRPCDouble(String string, Double d, boolean bl) throws SQLServerException {
        this.writeRPCNameValType(string, bl, 109);
        int n = 8;
        this.writeByte((byte)n);
        if (null == d) {
            this.writeByte((byte)0);
        } else {
            this.writeByte((byte)n);
            long l = Double.doubleToLongBits(d);
            long l2 = 255L;
            int n2 = 0;
            for (int i = 0; i < 8; ++i) {
                this.writeByte((byte)((l & l2) >> n2));
                n2 += 8;
                l2 <<= 8;
            }
        }
    }

    void writeRPCBigDecimal(String string, BigDecimal bigDecimal, int n, boolean bl) throws SQLServerException {
        boolean bl2;
        int n2;
        byte[] byArray = null;
        if (bigDecimal == null) {
            n2 = 0;
            bl2 = false;
        } else {
            BigInteger bigInteger;
            bl2 = bigDecimal.signum() < 0;
            BigInteger bigInteger2 = bigInteger = bigDecimal.scale() < 0 ? bigDecimal.setScale(0).unscaledValue() : bigDecimal.unscaledValue();
            if (bl2) {
                bigInteger = bigInteger.negate();
            }
            byArray = bigInteger.toByteArray();
            n2 = byArray.length;
        }
        this.writeRPCNameValType(string, bl, 106);
        this.writeByte((byte)17);
        this.writeByte((byte)38);
        if (bigDecimal == null) {
            this.writeByte((byte)n);
            this.writeByte((byte)0);
        } else {
            byte by = (byte)(bigDecimal.scale() < 0 ? 0 : bigDecimal.scale());
            this.writeByte(by);
            this.writeByte((byte)(n2 + 1));
            this.writeByte((byte)(!bl2 ? 1 : 0));
            for (int i = n2 - 1; i >= 0; --i) {
                this.writeByte(byArray[i]);
            }
        }
    }

    void writeRPCStringUnicode(String string, String string2, boolean bl) throws SQLServerException {
        this.writeRPCStringUnicode(string, string2, bl, 12);
    }

    void writeVMaxHeader(long l, boolean bl, boolean bl2) throws SQLServerException {
        this.writeShort((short)-1);
        if (bl2) {
            this.dbCom.getDatabaseCollation().writeCollation(this);
        }
        if (bl) {
            this.writeLong(-1L);
        } else if (-1L == l) {
            this.writeLong(-2L);
        } else {
            this.writeLong(l);
        }
    }

    void writeRPCStringUnicode(String string, String string2, boolean bl, int n) throws SQLServerException {
        boolean bl2;
        boolean bl3 = string2 == null;
        int n2 = 0;
        boolean bl4 = bl2 = this.dbCom.getTDSVersion().isYukonOrLater() && 1 != n && bl;
        if (!bl3) {
            n2 = string2.length() * 2;
        }
        this.writeRPCNameValType(string, bl, 231);
        if (bl2) {
            this.writeVMaxHeader(n2, bl3, true);
            if (!bl3) {
                if (n2 > 0) {
                    this.writeInt(n2);
                    this.writeString(string2);
                }
                this.writeInt(0);
            }
        } else {
            this.writeShort((short)8000);
            this.dbCom.getDatabaseCollation().writeCollation(this);
            if (bl3) {
                this.writeShort((short)-1);
            } else {
                this.writeShort((short)n2);
                if (0 != n2) {
                    this.writeString(string2);
                }
            }
        }
    }

    void writeRPCStringNonUnicode(String string, String string2, boolean bl, int n) throws SQLServerException {
        boolean bl2 = string2 == null;
        int n2 = 0;
        boolean bl3 = this.dbCom.getTDSVersion().isYukonOrLater() && 1 != n && bl;
        byte[] byArray = null;
        if (!bl2) {
            try {
                byArray = string2.getBytes(this.dbCom.getDatabaseCharset());
                n2 = byArray.length;
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_encodingErrorWritingTDS"));
                Object[] objectArray = new Object[]{new String(unsupportedEncodingException.getMessage())};
                SQLServerException.makeFromDriverError(this.con, null, messageFormat.format(objectArray), null, true);
            }
        }
        this.writeRPCNameValType(string, bl, 167);
        if (bl3) {
            this.writeVMaxHeader(n2, bl2, true);
            if (!bl2) {
                if (n2 > 0) {
                    this.writeInt(n2);
                    this.writeBytes(byArray);
                }
                this.writeInt(0);
            }
        } else {
            this.writeShort((short)8000);
            this.dbCom.getDatabaseCollation().writeCollation(this);
            if (bl2) {
                this.writeShort((short)-1);
            } else {
                this.writeShort((short)n2);
                if (0 != n2) {
                    this.writeBytes(byArray);
                }
            }
        }
    }

    void writeRPCLongStringUnicode(String string, String string2, boolean bl) throws SQLServerException {
        boolean bl2 = string2 == null;
        int n = 0;
        boolean bl3 = this.dbCom.getTDSVersion().isYukonOrLater();
        if (!bl2) {
            n = string2.length() * 2;
        }
        if (bl3) {
            this.writeRPCNameValType(string, bl, 231);
            this.writeVMaxHeader(n, bl2, true);
            if (!bl2) {
                if (n > 0) {
                    this.writeInt(n);
                    this.writeString(string2);
                }
                this.writeInt(0);
            }
        } else {
            this.writeRPCNameValType(string, bl, 99);
            this.writeInt(Integer.MAX_VALUE);
            this.dbCom.getDatabaseCollation().writeCollation(this);
            if (bl2) {
                this.writeInt(-1);
            } else {
                this.writeInt(n);
                if (0 != n) {
                    this.writeString(string2);
                }
            }
        }
    }

    void writeRPCByteArray(String string, byte[] byArray, boolean bl, int n) throws SQLServerException {
        boolean bl2;
        boolean bl3 = byArray == null;
        boolean bl4 = !bl3 && byArray.length > 8000;
        int n2 = 0;
        boolean bl5 = bl2 = this.dbCom.getTDSVersion().isYukonOrLater() && -2 != n && (bl4 || bl);
        if (!bl3) {
            n2 = byArray.length;
        }
        if (bl2) {
            this.writeRPCNameValType(string, bl, 165);
            this.writeVMaxHeader(n2, bl3, false);
            if (!bl3) {
                if (n2 > 0) {
                    this.writeInt(n2);
                    this.writeBytes(byArray);
                }
                this.writeInt(0);
            }
        } else {
            if (bl4) {
                this.writeRPCNameValType(string, bl, 34);
                this.writeInt(Integer.MAX_VALUE);
            } else {
                this.writeRPCNameValType(string, bl, 165);
                this.writeShort((short)8000);
            }
            if (bl3) {
                this.writeShort((short)-1);
            } else {
                if (bl4) {
                    this.writeInt(n2);
                } else {
                    this.writeShort((short)n2);
                }
                if (0 != n2) {
                    this.writeBytes(byArray);
                }
            }
        }
    }

    void writeRPCTimestamp(String string, Calendar calendar, boolean bl) throws SQLServerException {
        this.writeRPCNameValType(string, bl, 111);
        this.writeByte((byte)8);
        if (null == calendar) {
            this.writeByte((byte)0);
        } else {
            this.writeByte((byte)8);
            Util.writeTimestamp(calendar, this);
        }
    }

    void writeRPCInputStream(String string, InputStream inputStream, InputStreamArgs inputStreamArgs, boolean bl) throws SQLServerException {
        long l;
        boolean bl2 = inputStream == null;
        long l2 = l = null == inputStream ? 0L : inputStreamArgs.length;
        boolean bl3 = 0 == inputStreamArgs.nativeType ? 3 != inputStreamArgs.streamType : DataTypes.isBinary(inputStreamArgs.nativeType);
        boolean bl4 = this.dbCom.getTDSVersion().isYukonOrLater();
        if (-1L == l && !bl2) {
            if (bl4) {
                this.writeRPCNameValType(string, bl, bl3 ? 165 : 167);
                this.writeVMaxHeader(-1L, false, !bl3);
                this.writeStream(inputStream, -1L, true);
                this.writeInt(0);
                return;
            }
            try {
                int n;
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(8000);
                byte[] byArray = new byte[8000];
                l = 0L;
                while ((n = inputStream.read(byArray, 0, byArray.length)) > 0) {
                    l += (long)n;
                    byteArrayOutputStream.write(byArray);
                }
                inputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray(), 0, (int)l);
            }
            catch (IOException iOException) {
                SQLServerException.makeFromDriverError(this.con, null, iOException.getMessage(), "08006", true);
            }
        }
        if (bl4) {
            this.writeRPCNameValType(string, bl, bl3 ? 165 : 167);
            this.writeVMaxHeader(l, bl2, !bl3);
            if (!bl2) {
                if (l > 0L) {
                    this.writeStream(inputStream, l, true);
                }
                this.writeInt(0);
            }
        } else {
            boolean bl5;
            boolean bl6 = bl5 = bl2 || -1L != l && l <= 8000L;
            this.writeRPCNameValType(string, bl, bl3 ? (bl5 ? 165 : 34) : (bl5 ? 167 : 35));
            if (bl5) {
                this.writeShort((short)8000);
            } else {
                this.writeInt(Integer.MAX_VALUE);
            }
            if (!bl3) {
                this.dbCom.getDatabaseCollation().writeCollation(this);
            }
            if (bl2) {
                this.writeShort((short)-1);
            } else {
                if (bl5) {
                    this.writeShort((short)l);
                } else {
                    this.writeInt((int)l);
                }
                if (l > 0L) {
                    this.writeStream(inputStream, l, false);
                }
            }
        }
    }

    void writeRPCReader(String string, Reader reader, int n, boolean bl, boolean bl2) throws SQLServerException {
        boolean bl3 = reader == null;
        this.writeRPCNameValType(string, bl2, bl ? 231 : 99);
        if (-1 == n && !bl3) {
            if (bl) {
                this.writeVMaxHeader(-1L, false, true);
                this.writeReader(reader, -1, true);
                this.writeInt(0);
                return;
            }
            try {
                String string2 = DDC.convertReaderToString(reader, n);
                n = string2.length();
                reader = new StringReader(string2);
            }
            catch (SQLServerException sQLServerException) {
                SQLServerException.makeFromDriverError(this.con, null, SQLServerException.getErrString("R_unexpectedIOExceptionProcessingReader"), "08006", true);
            }
        }
        if (bl) {
            this.writeVMaxHeader(2 * n, bl3, true);
            if (!bl3) {
                if (n > 0) {
                    this.writeInt(2 * n);
                    this.writeReader(reader, n, false);
                }
                this.writeInt(0);
            }
        } else {
            this.writeInt(Integer.MAX_VALUE);
            this.dbCom.getDatabaseCollation().writeCollation(this);
            if (bl3) {
                this.writeInt(-1);
                return;
            }
            this.writeInt(2 * n);
            if (n > 0) {
                this.writeReader(reader, n, false);
            }
        }
    }
}

