/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.record.cipher;

import de.rub.nds.modifiablevariable.util.ArrayConverter;
import de.rub.nds.tlsattacker.core.constants.AlgorithmResolver;
import de.rub.nds.tlsattacker.core.crypto.cipher.CipherWrapper;
import de.rub.nds.tlsattacker.core.crypto.mac.MacWrapper;
import de.rub.nds.tlsattacker.core.crypto.mac.WrappedMac;
import de.rub.nds.tlsattacker.core.exceptions.CryptoException;
import de.rub.nds.tlsattacker.core.protocol.parser.Parser;
import de.rub.nds.tlsattacker.core.record.BlobRecord;
import de.rub.nds.tlsattacker.core.record.Record;
import de.rub.nds.tlsattacker.core.record.RecordCryptoComputations;
import de.rub.nds.tlsattacker.core.record.cipher.RecordCipher;
import de.rub.nds.tlsattacker.core.record.cipher.cryptohelper.KeySet;
import de.rub.nds.tlsattacker.core.state.TlsContext;
import de.rub.nds.tlsattacker.transport.ConnectionEndType;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RecordStreamCipher
extends RecordCipher {
    private static final Logger LOGGER = LogManager.getLogger();
    private WrappedMac readMac;
    private WrappedMac writeMac;

    public RecordStreamCipher(TlsContext context, KeySet keySet) {
        super(context, keySet);
        this.initCipherAndMac();
    }

    private void initCipherAndMac() throws UnsupportedOperationException {
        try {
            ConnectionEndType localConEndType = this.context.getConnection().getLocalConnectionEndType();
            this.encryptCipher = CipherWrapper.getEncryptionCipher(this.cipherSuite, localConEndType, this.getKeySet());
            this.decryptCipher = CipherWrapper.getDecryptionCipher(this.cipherSuite, localConEndType, this.getKeySet());
            this.readMac = MacWrapper.getMac(this.version, this.cipherSuite, this.getKeySet().getReadMacSecret(localConEndType));
            this.writeMac = MacWrapper.getMac(this.version, this.cipherSuite, this.getKeySet().getWriteMacSecret(localConEndType));
        }
        catch (NoSuchAlgorithmException ex) {
            throw new UnsupportedOperationException("Cipher not supported: " + this.cipherSuite.name(), ex);
        }
    }

    public byte[] calculateMac(byte[] data, ConnectionEndType connectionEndType) {
        LOGGER.debug("The MAC was calculated over the following data: {}", (Object)ArrayConverter.bytesToHexString((byte[])data));
        byte[] result = connectionEndType == this.context.getChooser().getConnectionEndType() ? this.writeMac.calculateMac(data) : this.readMac.calculateMac(data);
        LOGGER.debug("MAC: {}", (Object)ArrayConverter.bytesToHexString((byte[])result));
        return result;
    }

    @Override
    public void encrypt(Record record) throws CryptoException {
        if (record.getComputations() == null) {
            LOGGER.warn("Record computations are not prepared.");
            record.prepareComputations();
        }
        LOGGER.debug("Encrypting Record:");
        RecordCryptoComputations computations = record.getComputations();
        computations.setMacKey(this.getKeySet().getWriteMacSecret(this.context.getChooser().getConnectionEndType()));
        computations.setCipherKey(this.getKeySet().getWriteKey(this.context.getChooser().getConnectionEndType()));
        byte[] cleanBytes = (byte[])record.getCleanProtocolMessageBytes().getValue();
        computations.setAuthenticatedNonMetaData(cleanBytes);
        record.setLength(cleanBytes.length + AlgorithmResolver.getMacAlgorithm(this.version, this.cipherSuite).getSize());
        computations.setAuthenticatedMetaData(this.collectAdditionalAuthenticatedData(record, this.version));
        computations.setMac(this.calculateMac(ArrayConverter.concatenate((byte[][])new byte[][]{(byte[])computations.getAuthenticatedMetaData().getValue(), (byte[])computations.getAuthenticatedNonMetaData().getValue()}), this.context.getConnection().getLocalConnectionEndType()));
        computations.setPlainRecordBytes(ArrayConverter.concatenate((byte[][])new byte[][]{(byte[])record.getCleanProtocolMessageBytes().getValue(), (byte[])computations.getMac().getValue()}));
        computations.setCiphertext(this.encryptCipher.encrypt((byte[])record.getComputations().getPlainRecordBytes().getValue()));
        record.setProtocolMessageBytes((byte[])computations.getCiphertext().getValue());
        computations.setMacValid(true);
    }

    @Override
    public void decrypt(Record record) throws CryptoException {
        if (record.getComputations() == null) {
            LOGGER.warn("Record computations are not preapred.");
            record.prepareComputations();
        }
        LOGGER.debug("Decrypting Record");
        RecordCryptoComputations computations = record.getComputations();
        computations.setMacKey(this.getKeySet().getReadMacSecret(this.context.getChooser().getConnectionEndType()));
        computations.setCipherKey(this.getKeySet().getReadKey(this.context.getChooser().getConnectionEndType()));
        byte[] cipherText = (byte[])record.getProtocolMessageBytes().getValue();
        computations.setCiphertext(cipherText);
        byte[] plainData = this.decryptCipher.decrypt(cipherText);
        computations.setPlainRecordBytes(plainData);
        plainData = (byte[])computations.getPlainRecordBytes().getValue();
        DecryptionParser parser = new DecryptionParser(0, plainData);
        byte[] cleanBytes = parser.parseByteArrayField(plainData.length - this.readMac.getMacLength());
        record.setCleanProtocolMessageBytes(cleanBytes);
        record.getComputations().setAuthenticatedNonMetaData(cleanBytes);
        record.getComputations().setAuthenticatedMetaData(this.collectAdditionalAuthenticatedData(record, this.version));
        byte[] hmac = parser.parseByteArrayField(this.readMac.getMacLength());
        record.getComputations().setMac(hmac);
        byte[] calculatedHmac = this.calculateMac(ArrayConverter.concatenate((byte[][])new byte[][]{(byte[])record.getComputations().getAuthenticatedMetaData().getValue(), (byte[])record.getComputations().getAuthenticatedNonMetaData().getValue()}), this.context.getTalkingConnectionEndType());
        record.getComputations().setMacValid(Arrays.equals(hmac, calculatedHmac));
    }

    @Override
    public void encrypt(BlobRecord br) throws CryptoException {
        LOGGER.debug("Encrypting BlobRecord");
        br.setProtocolMessageBytes(this.encryptCipher.encrypt((byte[])br.getCleanProtocolMessageBytes().getValue()));
    }

    @Override
    public void decrypt(BlobRecord br) throws CryptoException {
        LOGGER.debug("Derypting BlobRecord");
        br.setProtocolMessageBytes(this.decryptCipher.decrypt((byte[])br.getCleanProtocolMessageBytes().getValue()));
    }

    class DecryptionParser
    extends Parser<Object> {
        public DecryptionParser(int startposition, byte[] array) {
            super(startposition, array);
        }

        @Override
        public Object parse() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public byte[] parseByteArrayField(int length) {
            return super.parseByteArrayField(length);
        }

        @Override
        public int getBytesLeft() {
            return super.getBytesLeft();
        }

        @Override
        public int getPointer() {
            return super.getPointer();
        }
    }
}

