untrusted comment: signature from openbsd 5.5 base secret key
RWRGy8gxk9N9321DQnPP+9IApvSKgX2JT78ZuEZ9HWNUESOfE91CMPQIevj7Yrafs1Zc/KNELplMHCwmFTL8CBjPjuXfEG9y+gU=

OpenBSD 5.5 errata 5, May 1, 2014:  An attacker can trigger generation
of an SSL alert which could cause a null pointer dereference.

Apply patch using:

    signify -Vep /etc/signify/openbsd-55-base.pub -x 005_openssl.patch.sig \
        -m - | (cd /usr/src && patch -p0)

Then build and install libssl

    cd /usr/src/lib/libssl/ssl
    make obj
    make
    make install

Then restart services which depend on SSL.

Index: lib/libssl/src/ssl/s3_pkt.c
===================================================================
RCS file: /cvs/src/lib/libssl/src/ssl/s3_pkt.c,v
retrieving revision 1.20.4.1
retrieving revision 1.20.4.2
diff -u -p -r1.20.4.1 -r1.20.4.2
--- lib/libssl/src/ssl/s3_pkt.c	12 Apr 2014 17:01:14 -0000	1.20.4.1
+++ lib/libssl/src/ssl/s3_pkt.c	1 May 2014 14:16:35 -0000	1.20.4.2
@@ -657,6 +657,10 @@ static int do_ssl3_write(SSL *s, int typ
 		if (i <= 0)
 			return(i);
 		/* if it went, fall through and send more stuff */
+		/* we may have released our buffer, so get it again */
+		if (wb->buf == NULL)
+			if (!ssl3_setup_write_buffer(s))
+				return -1;
 		}
 
 	if (len == 0 && !create_empty_fragment)
