untrusted comment: signature from openbsd 6.0 base secret key
RWSho3oKSqgLQ7Fd3pidPCqHCaDW23pbANPcfI/fSOmPFnO2pqrTE7FFdudkyvBYqxf23hroaopNJ07mizlp+xb7sXakqPkeyg0=

OpenBSD 6.0 errata 14, Oct 13, 2016:

A logic issue in smtpd's header parsing can cause SMTP sessions to hang.

Apply by doing:
    signify -Vep /etc/signify/openbsd-60-base.pub -x 014_smtpd.patch.sig \
        -m - | (cd /usr/src && patch -p0)

And then rebuild and install smtpd:
    cd /usr/src/usr.sbin/smtpd
    make obj
    make depend
    make
    make install

Index: usr.sbin/smtpd/rfc2822.c
===================================================================
RCS file: /cvs/src/usr.sbin/smtpd/rfc2822.c,v
retrieving revision 1.7.6.1
diff -u -p -r1.7.6.1 rfc2822.c
--- usr.sbin/smtpd/rfc2822.c	23 Aug 2016 11:15:17 -0000	1.7.6.1
+++ usr.sbin/smtpd/rfc2822.c	12 Oct 2016 16:18:07 -0000
@@ -50,6 +50,9 @@ header_callback(struct rfc2822_parser *r
 	struct rfc2822_hdr_cb		*hdr_cb;
 	struct rfc2822_hdr_miss_cb	*hdr_miss_cb;
 
+	if (!rp->in_hdr)
+		goto end;
+
 	TAILQ_FOREACH(hdr_cb, &rp->hdr_cb, next)
 	    if (strcasecmp(hdr_cb->name, rp->header.name) == 0) {
 		    hdr_cb->func(&rp->header, hdr_cb->arg);
@@ -148,6 +151,8 @@ rfc2822_parser_flush(struct rfc2822_pars
 		return;
 
 	header_callback(rp);
+
+	missing_headers_callback(rp);
 }
 
 void
Index: usr.sbin/smtpd/smtp_session.c
===================================================================
RCS file: /cvs/src/usr.sbin/smtpd/smtp_session.c,v
retrieving revision 1.284.4.1
diff -u -p -r1.284.4.1 smtp_session.c
--- usr.sbin/smtpd/smtp_session.c	4 Oct 2016 00:12:27 -0000	1.284.4.1
+++ usr.sbin/smtpd/smtp_session.c	12 Oct 2016 16:18:07 -0000
@@ -1343,6 +1343,8 @@ smtp_io(struct io *io, int evt)
 			s->tx->dataeom = 1;
 			if (iobuf_queued(&s->tx->obuf) == 0)
 				smtp_data_io_done(s);
+			else
+				io_reload(&s->tx->oev);
 			return;
 		}
 
