untrusted comment: verify with openbsd-67-base.pub
RWRmkIA877Io3uSnT5yHRVZUIh/krPkEiv8zSsBnhxK4Yof9CYwFd3NaCEcRjD7C4uCerv4tVqU5R6NHVBXmm8X6f9ml53kwgAw=

OpenBSD 6.7 errata 023, September 5, 2020:

Buffer overflow in amdgpu ioctl.

Apply by doing:
    signify -Vep /etc/signify/openbsd-67-base.pub -x 023_amdgpu.patch.sig \
        -m - | (cd /usr/src && patch -p0)

And then rebuild and install a new kernel:
    KK=`sysctl -n kern.osversion | cut -d# -f1`
    cd /usr/src/sys/arch/`machine`/compile/$KK
    make obj
    make config
    make
    make install

Index: sys/dev/pci/drm/amd/amdgpu/amdgpu_kms.c
===================================================================
RCS file: /cvs/src/sys/dev/pci/drm/amd/amdgpu/amdgpu_kms.c,v
retrieving revision 1.8
diff -u -p -r1.8 amdgpu_kms.c
--- sys/dev/pci/drm/amd/amdgpu/amdgpu_kms.c	25 Dec 2019 11:42:05 -0000	1.8
+++ sys/dev/pci/drm/amd/amdgpu/amdgpu_kms.c	3 Sep 2020 13:32:21 -0000
@@ -574,8 +574,12 @@ static int amdgpu_info_ioctl(struct drm_
 		 * in the bitfields */
 		if (se_num == AMDGPU_INFO_MMR_SE_INDEX_MASK)
 			se_num = 0xffffffff;
+		else if (se_num >= AMDGPU_GFX_MAX_SE)
+			return -EINVAL;
 		if (sh_num == AMDGPU_INFO_MMR_SH_INDEX_MASK)
 			sh_num = 0xffffffff;
+		else if (sh_num >= AMDGPU_GFX_MAX_SH_PER_SE)
+			return -EINVAL;
 
 		if (info->read_mmr_reg.count > 128)
 			return -EINVAL;
