untrusted comment: verify with openbsd-65-base.pub
RWSZaRmt1LEQT8t+y3msM4QQN7TbZwviBHbVcYesxFGjx3PBBuTyxojb50Nop1MDSL4o0ypq6qbs8sRlGBS3xXI1vf7T7pTRRwk=

OpenBSD 6.5 errata 027, December 20, 2019:

ripd(8) fails to validate authentication lengths.

Apply by doing:
    signify -Vep /etc/signify/openbsd-65-base.pub -x 027_ripd.patch.sig \
        -m - | (cd /usr/src && patch -p0)

And then rebuild and install ripd:
    cd /usr/src/usr.sbin/ripd
    make obj
    make
    make install

Index: usr.sbin/ripd/auth.c
===================================================================
RCS file: /cvs/src/usr.sbin/ripd/auth.c,v
diff -u -p -u -r1.11 auth.c
--- usr.sbin/ripd/auth.c	26 May 2010 13:56:08 -0000	1.11
+++ usr.sbin/ripd/auth.c	19 Dec 2019 01:25:58 -0000
@@ -144,6 +144,14 @@ auth_validate(u_int8_t **buf, u_int16_t 
 			return (-1);
 		}
 
+		if (ntohs(a->auth_offset) != *len + RIP_HDR_LEN -
+		    AUTH_TRLR_HDR_LEN - MD5_DIGEST_LENGTH) {
+			log_debug("auth_validate: invalid authentication data "
+			    "offset %hu, interface %s", ntohs(a->auth_offset),
+			    iface->name);
+			return (-1);
+		}
+
 		auth_data = *buf;
 		auth_data += ntohs(a->auth_offset);
 
