untrusted comment: verify with openbsd-66-base.pub
RWSvK/c+cFe24CkGCy2uXhn05sWs93pStdxAPmjQcj9I/FwBWcfsjFkvjpwct1bqoYiLfbpxg5SwmSVQmF5dkAeqjYfXNsTNewE=

OpenBSD 6.6 errata 017, January 17, 2020:

Execution Unit state was not cleared on context switch with Intel Gen9
graphics hardware.

Apply by doing:
    signify -Vep /etc/signify/openbsd-66-base.pub -x 017_inteldrmctx.patch.sig \
        -m - | (cd /usr/src && patch -p0)

And then rebuild and install a new kernel:
    KK=`sysctl -n kern.osversion | cut -d# -f1`
    cd /usr/src/sys/arch/`machine`/compile/$KK
    make obj
    make config
    make
    make install

Index: sys/dev/pci/drm/i915/intel_lrc.c
===================================================================
RCS file: /cvs/src/sys/dev/pci/drm/i915/intel_lrc.c,v
retrieving revision 1.3
diff -u -p -r1.3 intel_lrc.c
--- sys/dev/pci/drm/i915/intel_lrc.c	14 Apr 2019 10:14:52 -0000	1.3
+++ sys/dev/pci/drm/i915/intel_lrc.c	15 Jan 2020 02:03:03 -0000
@@ -1582,6 +1582,15 @@ static u32 *gen9_init_indirectctx_bb(str
 	/* WaFlushCoherentL3CacheLinesAtContextSwitch:skl,bxt,glk */
 	batch = gen8_emit_flush_coherentl3_wa(engine, batch);
 
+	/* WaClearSlmSpaceAtContextSwitch:skl,bxt,kbl,glk,cfl */
+	batch = gen8_emit_pipe_control(batch,
+				       PIPE_CONTROL_FLUSH_L3 |
+				       PIPE_CONTROL_GLOBAL_GTT_IVB |
+				       PIPE_CONTROL_CS_STALL |
+				       PIPE_CONTROL_QW_WRITE,
+				       i915_ggtt_offset(engine->scratch) +
+				       2 * CACHELINE_BYTES);
+
 	batch = emit_lri(batch, lri, ARRAY_SIZE(lri));
 
 	/* WaClearSlmSpaceAtContextSwitch:kbl */
