untrusted comment: verify with openbsd-66-base.pub
RWSvK/c+cFe24F0i32Yi+ZLmlqEvPpPnTd1yiIV4BpzGj16hyS0FGcH5zeecn9gThCQyPjHLw4eGTWechNVakRYmg9tM2eygUAo=

OpenBSD 6.6 errata 030, June 5, 2020:

Malicious HID descriptors could be misparsed.

Apply by doing:
    signify -Vep /etc/signify/openbsd-66-base.pub -x 030_hid.patch.sig \
        -m - | (cd /usr/src && patch -p0)

And then rebuild and install a new kernel:
    KK=`sysctl -n kern.osversion | cut -d# -f1`
    cd /usr/src/sys/arch/`machine`/compile/$KK
    make obj
    make config
    make
    make install

Index: sys/dev/hid/hid.c
===================================================================
RCS file: /cvs/src/sys/dev/hid/hid.c,v
diff -u -p -u -r1.2 hid.c
--- sys/dev/hid/hid.c	20 Jan 2016 01:11:50 -0000	1.2
+++ sys/dev/hid/hid.c	3 Jun 2020 18:12:10 -0000
@@ -199,6 +199,9 @@ hid_get_item(struct hid_data *s, struct 
 	if (s == NULL)
 		return (0);
 
+	if (s->pushlevel >= MAXPUSH)
+		return (0);
+
 	c = &s->cur[s->pushlevel];
 
  top:
@@ -385,8 +388,8 @@ hid_get_item(struct hid_data *s, struct 
 				s->loc_count = dval & mask;
 				break;
 			case 10:	/* Push */
-				s->pushlevel ++;
-				if (s->pushlevel < MAXPUSH) {
+				if (s->pushlevel < MAXPUSH - 1) {
+					s->pushlevel++;
 					s->cur[s->pushlevel] = *c;
 					/* store size and count */
 					c->loc.size = s->loc_size;
@@ -399,8 +402,8 @@ hid_get_item(struct hid_data *s, struct 
 				}
 				break;
 			case 11:	/* Pop */
-				s->pushlevel --;
-				if (s->pushlevel < MAXPUSH) {
+				if (s->pushlevel > 0) {
+					s->pushlevel--;
 					/* preserve position */
 					oldpos = c->loc.pos;
 					c = &s->cur[s->pushlevel];
