untrusted comment: verify with openbsd-66-base.pub
RWSvK/c+cFe24AQQEIPe6nRTwK3vxPXt8ZdJUd06AfhQPIYmN41apejUz55cA/0uxWPjbQ/OuMhQ6yHI6zPtyQBFCQHIBfIjVAI=

OpenBSD 6.6 errata 033, July 9, 2020:

shmget IPC_STAT leaked some kernel data.

Apply by doing:
    signify -Vep /etc/signify/openbsd-66-base.pub -x 033_shmget.patch.sig \
        -m - | (cd /usr/src && patch -p0)

And then rebuild and install a new kernel:
    KK=`sysctl -n kern.osversion | cut -d# -f1`
    cd /usr/src/sys/arch/`machine`/compile/$KK
    make obj
    make config
    make
    make install

Index: sys/kern/sysv_sem.c
===================================================================
RCS file: /cvs/src/sys/kern/sysv_sem.c,v
diff -u -p -u -r1.56 sysv_sem.c
--- sys/kern/sysv_sem.c	4 Feb 2019 07:04:28 -0000	1.56
+++ sys/kern/sysv_sem.c	8 Jul 2020 21:07:47 -0000
@@ -299,7 +299,9 @@ semctl1(struct proc *p, int semid, int s
 	case IPC_STAT:
 		if ((error = ipcperm(cred, &semaptr->sem_perm, IPC_R)))
 			return (error);
-		error = ds_copyout(semaptr, arg->buf, sizeof(struct semid_ds));
+		memcpy(&sbuf, semaptr, sizeof sbuf);
+		sbuf.sem_base = NULL;
+		error = ds_copyout(&sbuf, arg->buf, sizeof(struct semid_ds));
 		break;
 
 	case GETNCNT:
@@ -423,7 +425,7 @@ sys_semget(struct proc *p, void *v, regi
 			    nsems, seminfo.semmns - semtot));
 			return (ENOSPC);
 		}
-		semaptr_new = pool_get(&sema_pool, PR_WAITOK);
+		semaptr_new = pool_get(&sema_pool, PR_WAITOK | PR_ZERO);
 		semaptr_new->sem_base = mallocarray(nsems, sizeof(struct sem),
 		    M_SEM, M_WAITOK|M_ZERO);
 	}
