untrusted comment: verify with openbsd-69-base.pub
RWQQsAemppS46PQ5zCFAXYg7ANctmbMvfnZyxUoI5lZJEAM2459WTfzzeNw8cSep+KbGYHCKCIbGTr7xw6v/6XIf2I4UHEcNwwk=

OpenBSD 6.9 errata 025, December 16, 2021:

If multicast routing is used, kernel memory is leaked to userland.

Apply by doing:
    signify -Vep /etc/signify/openbsd-69-base.pub -x 025_mrt.patch.sig \
        -m - | (cd /usr/src && patch -p0)

And then rebuild and install a new kernel:
    KK=`sysctl -n kern.osversion | cut -d# -f1`
    cd /usr/src/sys/arch/`machine`/compile/$KK
    make obj
    make config
    make
    make install

Index: sys/netinet/ip_mroute.c
===================================================================
RCS file: /cvs/src/sys/netinet/ip_mroute.c,v
diff -u -p -r1.130 ip_mroute.c
--- sys/netinet/ip_mroute.c	27 May 2020 11:19:29 -0000	1.130
+++ sys/netinet/ip_mroute.c	15 Dec 2021 17:46:03 -0000
@@ -353,6 +353,7 @@ mrt_sysctl_vif(void *oldp, size_t *oldle
 
 	given = *oldlenp;
 	needed = 0;
+	memset(&vinfo, 0, sizeof vinfo);
 	TAILQ_FOREACH(ifp, &ifnet, if_list) {
 		if ((vifp = (struct vif *)ifp->if_mcast) == NULL)
 			continue;
Index: sys/netinet6/ip6_mroute.c
===================================================================
RCS file: /cvs/src/sys/netinet6/ip6_mroute.c,v
diff -u -p -r1.126 ip6_mroute.c
--- sys/netinet6/ip6_mroute.c	10 Mar 2021 10:21:49 -0000	1.126
+++ sys/netinet6/ip6_mroute.c	15 Dec 2021 17:46:03 -0000
@@ -330,6 +330,7 @@ mrt6_sysctl_mif(void *oldp, size_t *oldl
 
 	given = *oldlenp;
 	needed = 0;
+	memset(&minfo, 0, sizeof minfo);
 	TAILQ_FOREACH(ifp, &ifnet, if_list) {
 		if ((mifp = (struct mif6 *)ifp->if_mcast6) == NULL)
 			continue;
