/* cheese-effects-manager.c generated by valac 0.10.0, the Vala compiler
 * generated from cheese-effects-manager.vala, do not modify */

/*
 * Copyright © 2010 Yuvaraj Pandian T <yuvipanda@yuvi.in>
 * Copyright © 2010 daniel g. siegel <dgsiegel@gnome.org>
 * Copyright © 2008 Filippo Argiolas <filippo.argiolas@gmail.com>
 *
 * Licensed under the GNU General Public License Version 2
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <cheese-effect.h>
#include <locale.h>
#include <glib/gstdio.h>
#include <glib/gi18n-lib.h>


#define CHEESE_TYPE_EFFECTS_MANAGER (cheese_effects_manager_get_type ())
#define CHEESE_EFFECTS_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CHEESE_TYPE_EFFECTS_MANAGER, CheeseEffectsManager))
#define CHEESE_EFFECTS_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CHEESE_TYPE_EFFECTS_MANAGER, CheeseEffectsManagerClass))
#define CHEESE_IS_EFFECTS_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CHEESE_TYPE_EFFECTS_MANAGER))
#define CHEESE_IS_EFFECTS_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CHEESE_TYPE_EFFECTS_MANAGER))
#define CHEESE_EFFECTS_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CHEESE_TYPE_EFFECTS_MANAGER, CheeseEffectsManagerClass))

typedef struct _CheeseEffectsManager CheeseEffectsManager;
typedef struct _CheeseEffectsManagerClass CheeseEffectsManagerClass;
typedef struct _CheeseEffectsManagerPrivate CheeseEffectsManagerPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_key_file_free0(var) ((var == NULL) ? NULL : (var = (g_key_file_free (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_dir_close0(var) ((var == NULL) ? NULL : (var = (g_dir_close (var), NULL)))

struct _CheeseEffectsManager {
	GObject parent_instance;
	CheeseEffectsManagerPrivate * priv;
	GeeArrayList* effects;
};

struct _CheeseEffectsManagerClass {
	GObjectClass parent_class;
};


static gpointer cheese_effects_manager_parent_class = NULL;

#define GROUP_NAME "Effect"
GType cheese_effects_manager_get_type (void) G_GNUC_CONST;
enum  {
	CHEESE_EFFECTS_MANAGER_DUMMY_PROPERTY
};
CheeseEffect* cheese_effects_manager_parse_effect_file (const char* filename);
static GeeArrayList* cheese_effects_manager_load_effects_from_directory (CheeseEffectsManager* self, const char* directory);
CheeseEffectsManager* cheese_effects_manager_new (void);
CheeseEffectsManager* cheese_effects_manager_construct (GType object_type);
static gboolean cheese_effects_manager_cmp_value (CheeseEffect* a, CheeseEffect* b);
void cheese_effects_manager_load_effects (CheeseEffectsManager* self);
static gint cheese_effects_manager_sort_value (CheeseEffect* a, CheeseEffect* b);
CheeseEffect* cheese_effects_manager_get_effect (CheeseEffectsManager* self, const char* name);
static void cheese_effects_manager_finalize (GObject* obj);
static gint _vala_array_length (gpointer array);
static int _vala_strcmp0 (const char * str1, const char * str2);



CheeseEffect* cheese_effects_manager_parse_effect_file (const char* filename) {
	CheeseEffect* result = NULL;
	GKeyFile* kf;
	CheeseEffect* eff;
	char* locale;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (filename != NULL, NULL);
	kf = g_key_file_new ();
	eff = cheese_effect_new ();
	locale = g_strdup (setlocale (LC_ALL, ""));
	{
		char* _tmp0_;
		char* _tmp1_;
		char* _tmp2_;
		char* _tmp3_;
		g_key_file_load_from_file (kf, filename, G_KEY_FILE_NONE, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_KEY_FILE_ERROR) {
				goto __catch9_g_key_file_error;
			}
			if (_inner_error_->domain == G_FILE_ERROR) {
				goto __catch9_g_file_error;
			}
			_g_free0 (locale);
			_g_object_unref0 (eff);
			_g_key_file_free0 (kf);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp0_ = g_key_file_get_locale_string (kf, GROUP_NAME, "Name", locale, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_KEY_FILE_ERROR) {
				goto __catch9_g_key_file_error;
			}
			if (_inner_error_->domain == G_FILE_ERROR) {
				goto __catch9_g_file_error;
			}
			_g_free0 (locale);
			_g_object_unref0 (eff);
			_g_key_file_free0 (kf);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		g_object_set (eff, "name", _tmp1_ = _tmp0_, NULL);
		_g_free0 (_tmp1_);
		_tmp2_ = g_key_file_get_string (kf, GROUP_NAME, "PipelineDescription", &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_KEY_FILE_ERROR) {
				goto __catch9_g_key_file_error;
			}
			if (_inner_error_->domain == G_FILE_ERROR) {
				goto __catch9_g_file_error;
			}
			_g_free0 (locale);
			_g_object_unref0 (eff);
			_g_key_file_free0 (kf);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		g_object_set (eff, "pipeline-desc", _tmp3_ = _tmp2_, NULL);
		_g_free0 (_tmp3_);
	}
	goto __finally9;
	__catch9_g_key_file_error:
	{
		GError * err;
		err = _inner_error_;
		_inner_error_ = NULL;
		{
			g_warning ("cheese-effects-manager.vala:43: Error: %s\n", err->message);
			result = NULL;
			_g_error_free0 (err);
			_g_free0 (locale);
			_g_object_unref0 (eff);
			_g_key_file_free0 (kf);
			return result;
		}
	}
	goto __finally9;
	__catch9_g_file_error:
	{
		GError * err;
		err = _inner_error_;
		_inner_error_ = NULL;
		{
			g_warning ("cheese-effects-manager.vala:48: Error: %s\n", err->message);
			result = NULL;
			_g_error_free0 (err);
			_g_free0 (locale);
			_g_object_unref0 (eff);
			_g_key_file_free0 (kf);
			return result;
		}
	}
	__finally9:
	if (_inner_error_ != NULL) {
		_g_free0 (locale);
		_g_object_unref0 (eff);
		_g_key_file_free0 (kf);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	result = eff;
	_g_free0 (locale);
	_g_key_file_free0 (kf);
	return result;
}


static GeeArrayList* cheese_effects_manager_load_effects_from_directory (CheeseEffectsManager* self, const char* directory) {
	GeeArrayList* result = NULL;
	GeeArrayList* list;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (directory != NULL, NULL);
	list = gee_array_list_new (CHEESE_TYPE_EFFECT, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL);
	if (g_file_test (directory, G_FILE_TEST_EXISTS | G_FILE_TEST_IS_DIR)) {
		GDir* dir;
		char* cur_file;
		char* _tmp2_;
		dir = NULL;
		cur_file = NULL;
		{
			GDir* _tmp0_;
			GDir* _tmp1_;
			_tmp0_ = g_dir_open (directory, 0, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == G_FILE_ERROR) {
					goto __catch10_g_file_error;
				}
				_g_free0 (cur_file);
				_g_dir_close0 (dir);
				_g_object_unref0 (list);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
			dir = (_tmp1_ = _tmp0_, _g_dir_close0 (dir), _tmp1_);
		}
		goto __finally10;
		__catch10_g_file_error:
		{
			GError * err;
			err = _inner_error_;
			_inner_error_ = NULL;
			{
				g_warning ("cheese-effects-manager.vala:71: Error: %s\n", err->message);
				result = NULL;
				_g_error_free0 (err);
				_g_free0 (cur_file);
				_g_dir_close0 (dir);
				_g_object_unref0 (list);
				return result;
			}
		}
		__finally10:
		if (_inner_error_ != NULL) {
			_g_free0 (cur_file);
			_g_dir_close0 (dir);
			_g_object_unref0 (list);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		cur_file = (_tmp2_ = g_strdup (g_dir_read_name (dir)), _g_free0 (cur_file), _tmp2_);
		while (TRUE) {
			char* _tmp9_;
			if (!(cur_file != NULL)) {
				break;
			}
			if (g_str_has_suffix (cur_file, ".effect")) {
				char* _tmp3_;
				CheeseEffect* _tmp4_;
				CheeseEffect* effect;
				effect = (_tmp4_ = cheese_effects_manager_parse_effect_file (_tmp3_ = g_build_filename (directory, cur_file, NULL)), _g_free0 (_tmp3_), _tmp4_);
				if (!gee_abstract_collection_contains ((GeeAbstractCollection*) self->effects, effect)) {
					char* _tmp5_ = NULL;
					char* _tmp6_;
					char* _tmp7_ = NULL;
					char* _tmp8_;
					g_message ("cheese-effects-manager.vala:84: Found %s (%s)", _tmp6_ = (g_object_get (effect, "name", &_tmp5_, NULL), _tmp5_), _tmp8_ = (g_object_get (effect, "pipeline-desc", &_tmp7_, NULL), _tmp7_));
					_g_free0 (_tmp8_);
					_g_free0 (_tmp6_);
					gee_abstract_collection_add ((GeeAbstractCollection*) list, effect);
				}
				_g_object_unref0 (effect);
			}
			cur_file = (_tmp9_ = g_strdup (g_dir_read_name (dir)), _g_free0 (cur_file), _tmp9_);
		}
		_g_free0 (cur_file);
		_g_dir_close0 (dir);
	}
	result = list;
	return result;
}


CheeseEffectsManager* cheese_effects_manager_construct (GType object_type) {
	CheeseEffectsManager * self;
	GeeArrayList* _tmp0_;
	self = (CheeseEffectsManager*) g_object_new (object_type, NULL);
	self->effects = (_tmp0_ = gee_array_list_new (CHEESE_TYPE_EFFECT, (GBoxedCopyFunc) g_object_ref, g_object_unref, (GEqualFunc) cheese_effects_manager_cmp_value), _g_object_unref0 (self->effects), _tmp0_);
	return self;
}


CheeseEffectsManager* cheese_effects_manager_new (void) {
	return cheese_effects_manager_construct (CHEESE_TYPE_EFFECTS_MANAGER);
}


void cheese_effects_manager_load_effects (CheeseEffectsManager* self) {
	char* system_effects;
	char* user_effects;
	GeeArrayList* _tmp3_;
	g_return_if_fail (self != NULL);
	system_effects = NULL;
	{
		char** _tmp0_;
		char** dir_collection;
		int dir_collection_length1;
		int dir_it;
		dir_collection = _tmp0_ = g_get_system_data_dirs ();
		dir_collection_length1 = _vala_array_length (_tmp0_);
		for (dir_it = 0; dir_it < _vala_array_length (_tmp0_); dir_it = dir_it + 1) {
			char* dir;
			dir = g_strdup (dir_collection[dir_it]);
			{
				char* _tmp1_;
				GeeArrayList* _tmp2_;
				system_effects = (_tmp1_ = g_build_filename (dir, "gnome-video-effects", NULL), _g_free0 (system_effects), _tmp1_);
				gee_abstract_collection_add_all ((GeeAbstractCollection*) self->effects, (GeeCollection*) (_tmp2_ = cheese_effects_manager_load_effects_from_directory (self, system_effects)));
				_g_object_unref0 (_tmp2_);
				_g_free0 (dir);
			}
		}
	}
	user_effects = g_build_filename (g_get_user_data_dir (), "gnome-video-effects", NULL);
	gee_abstract_collection_add_all ((GeeAbstractCollection*) self->effects, (GeeCollection*) (_tmp3_ = cheese_effects_manager_load_effects_from_directory (self, user_effects)));
	_g_object_unref0 (_tmp3_);
	gee_list_sort ((GeeList*) self->effects, (GCompareFunc) cheese_effects_manager_sort_value);
	if (gee_collection_get_size ((GeeCollection*) self->effects) > 0) {
		CheeseEffect* e;
		e = cheese_effect_new ();
		g_object_set (e, "name", _ ("No Effect"), NULL);
		g_object_set (e, "pipeline-desc", "identity", NULL);
		gee_abstract_list_insert ((GeeAbstractList*) self->effects, 0, e);
		_g_object_unref0 (e);
	}
	_g_free0 (user_effects);
	_g_free0 (system_effects);
}


CheeseEffect* cheese_effects_manager_get_effect (CheeseEffectsManager* self, const char* name) {
	CheeseEffect* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	{
		GeeIterator* _eff_it;
		_eff_it = gee_abstract_collection_iterator ((GeeAbstractCollection*) self->effects);
		while (TRUE) {
			CheeseEffect* eff;
			char* _tmp0_ = NULL;
			char* _tmp1_;
			gboolean _tmp2_;
			if (!gee_iterator_next (_eff_it)) {
				break;
			}
			eff = (CheeseEffect*) gee_iterator_get (_eff_it);
			if ((_tmp2_ = _vala_strcmp0 (_tmp1_ = (g_object_get (eff, "name", &_tmp0_, NULL), _tmp0_), name) == 0, _g_free0 (_tmp1_), _tmp2_)) {
				result = eff;
				_g_object_unref0 (_eff_it);
				return result;
			}
			_g_object_unref0 (eff);
		}
		_g_object_unref0 (_eff_it);
	}
	result = NULL;
	return result;
}


static gboolean cheese_effects_manager_cmp_value (CheeseEffect* a, CheeseEffect* b) {
	gboolean result = FALSE;
	char* _tmp0_ = NULL;
	char* _tmp1_;
	char* _tmp2_ = NULL;
	char* _tmp3_;
	gboolean _tmp4_;
	g_return_val_if_fail (a != NULL, FALSE);
	g_return_val_if_fail (b != NULL, FALSE);
	result = (_tmp4_ = _vala_strcmp0 (_tmp1_ = (g_object_get (a, "pipeline-desc", &_tmp0_, NULL), _tmp0_), _tmp3_ = (g_object_get (b, "pipeline-desc", &_tmp2_, NULL), _tmp2_)) == 0, _g_free0 (_tmp3_), _g_free0 (_tmp1_), _tmp4_);
	return result;
}


static gint cheese_effects_manager_sort_value (CheeseEffect* a, CheeseEffect* b) {
	gint result = 0;
	char* _tmp0_ = NULL;
	char* _tmp1_;
	char* _tmp2_;
	char* _tmp3_ = NULL;
	char* _tmp4_;
	char* _tmp5_;
	gboolean _tmp6_;
	g_return_val_if_fail (a != NULL, 0);
	g_return_val_if_fail (b != NULL, 0);
	if ((_tmp6_ = _vala_strcmp0 (_tmp2_ = g_utf8_strdown (_tmp1_ = (g_object_get (a, "name", &_tmp0_, NULL), _tmp0_), -1), _tmp5_ = g_utf8_strdown (_tmp4_ = (g_object_get (b, "name", &_tmp3_, NULL), _tmp3_), -1)) < 0, _g_free0 (_tmp5_), _g_free0 (_tmp4_), _g_free0 (_tmp2_), _g_free0 (_tmp1_), _tmp6_)) {
		result = -1;
		return result;
	} else {
		char* _tmp7_ = NULL;
		char* _tmp8_;
		char* _tmp9_;
		char* _tmp10_ = NULL;
		char* _tmp11_;
		char* _tmp12_;
		gboolean _tmp13_;
		if ((_tmp13_ = _vala_strcmp0 (_tmp9_ = g_utf8_strdown (_tmp8_ = (g_object_get (a, "name", &_tmp7_, NULL), _tmp7_), -1), _tmp12_ = g_utf8_strdown (_tmp11_ = (g_object_get (b, "name", &_tmp10_, NULL), _tmp10_), -1)) > 0, _g_free0 (_tmp12_), _g_free0 (_tmp11_), _g_free0 (_tmp9_), _g_free0 (_tmp8_), _tmp13_)) {
			result = 1;
			return result;
		} else {
			result = 0;
			return result;
		}
	}
}


static void cheese_effects_manager_class_init (CheeseEffectsManagerClass * klass) {
	cheese_effects_manager_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = cheese_effects_manager_finalize;
}


static void cheese_effects_manager_instance_init (CheeseEffectsManager * self) {
}


static void cheese_effects_manager_finalize (GObject* obj) {
	CheeseEffectsManager * self;
	self = CHEESE_EFFECTS_MANAGER (obj);
	_g_object_unref0 (self->effects);
	G_OBJECT_CLASS (cheese_effects_manager_parent_class)->finalize (obj);
}


GType cheese_effects_manager_get_type (void) {
	static volatile gsize cheese_effects_manager_type_id__volatile = 0;
	if (g_once_init_enter (&cheese_effects_manager_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (CheeseEffectsManagerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) cheese_effects_manager_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (CheeseEffectsManager), 0, (GInstanceInitFunc) cheese_effects_manager_instance_init, NULL };
		GType cheese_effects_manager_type_id;
		cheese_effects_manager_type_id = g_type_register_static (G_TYPE_OBJECT, "CheeseEffectsManager", &g_define_type_info, 0);
		g_once_init_leave (&cheese_effects_manager_type_id__volatile, cheese_effects_manager_type_id);
	}
	return cheese_effects_manager_type_id__volatile;
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




