/* cheese-preferences.c generated by valac 0.11.7, the Vala compiler
 * generated from cheese-preferences.vala, do not modify */

/*
 * Copyright © 2010 Yuvaraj Pandian T <yuvipanda@yuvi.in>
 * Copyright © 2010 daniel g. siegel <dgsiegel@gnome.org>
 * Copyright © 2008 Filippo Argiolas <filippo.argiolas@gmail.com>
 *
 * Licensed under the GNU General Public License Version 2
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <cheese-camera.h>
#include <gio/gio.h>
#include <gtk/gtk.h>
#include <cheese-fileutil.h>
#include <cheese-config.h>
#include <float.h>
#include <math.h>
#include <cheese-camera-device.h>
#include <stdlib.h>
#include <string.h>


#define CHEESE_TYPE_PREFERENCES_DIALOG (cheese_preferences_dialog_get_type ())
#define CHEESE_PREFERENCES_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CHEESE_TYPE_PREFERENCES_DIALOG, CheesePreferencesDialog))
#define CHEESE_PREFERENCES_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CHEESE_TYPE_PREFERENCES_DIALOG, CheesePreferencesDialogClass))
#define CHEESE_IS_PREFERENCES_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CHEESE_TYPE_PREFERENCES_DIALOG))
#define CHEESE_IS_PREFERENCES_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CHEESE_TYPE_PREFERENCES_DIALOG))
#define CHEESE_PREFERENCES_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CHEESE_TYPE_PREFERENCES_DIALOG, CheesePreferencesDialogClass))

typedef struct _CheesePreferencesDialog CheesePreferencesDialog;
typedef struct _CheesePreferencesDialogClass CheesePreferencesDialogClass;
typedef struct _CheesePreferencesDialogPrivate CheesePreferencesDialogPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _CheesePreferencesDialog {
	GObject parent_instance;
	CheesePreferencesDialogPrivate * priv;
};

struct _CheesePreferencesDialogClass {
	GObjectClass parent_class;
};

struct _CheesePreferencesDialogPrivate {
	CheeseCamera* camera;
	GSettings* settings;
	GtkDialog* dialog;
	GtkComboBox* photo_resolution_combo;
	GtkComboBox* video_resolution_combo;
	GtkComboBox* source_combo;
	GtkAdjustment* brightness_adjustment;
	GtkAdjustment* contrast_adjustment;
	GtkAdjustment* hue_adjustment;
	GtkAdjustment* saturation_adjustment;
	GtkScale* brightness_scale;
	GtkScale* contrast_scale;
	GtkScale* hue_scale;
	GtkScale* saturation_scale;
	GtkSpinButton* burst_repeat_spin;
	GtkSpinButton* burst_delay_spin;
	GtkCheckButton* countdown_check;
	GtkCheckButton* flash_check;
	CheeseMediaMode current_mode;
};


static gpointer cheese_preferences_dialog_parent_class = NULL;

GType cheese_preferences_dialog_get_type (void) G_GNUC_CONST;
#define CHEESE_PREFERENCES_DIALOG_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), CHEESE_TYPE_PREFERENCES_DIALOG, CheesePreferencesDialogPrivate))
enum  {
	CHEESE_PREFERENCES_DIALOG_DUMMY_PROPERTY
};
CheesePreferencesDialog* cheese_preferences_dialog_new (CheeseCamera* camera, GSettings* settings);
CheesePreferencesDialog* cheese_preferences_dialog_construct (GType object_type, CheeseCamera* camera, GSettings* settings);
static void cheese_preferences_dialog_setup_combo_box_models (CheesePreferencesDialog* self);
static void cheese_preferences_dialog_initialize_camera_devices (CheesePreferencesDialog* self);
static void cheese_preferences_dialog_initialize_values_from_settings (CheesePreferencesDialog* self);
static void cheese_preferences_dialog_setup_resolutions_for_device (CheesePreferencesDialog* self, CheeseCameraDevice* device);
void cheese_preferences_dialog_on_source_change (GtkComboBox* combo, CheesePreferencesDialog* self);
void cheese_preferences_dialog_on_photo_resolution_change (GtkComboBox* combo, CheesePreferencesDialog* self);
void cheese_preferences_dialog_on_video_resolution_change (GtkComboBox* combo, CheesePreferencesDialog* self);
void cheese_preferences_dialog_on_dialog_close (GtkButton* button, CheesePreferencesDialog* self);
void cheese_preferences_dialog_on_countdown_toggle (GtkCheckButton* checkbutton, CheesePreferencesDialog* self);
void cheese_preferences_dialog_on_flash_toggle (GtkCheckButton* checkbutton, CheesePreferencesDialog* self);
void cheese_preferences_dialog_on_burst_repeat_change (GtkSpinButton* spinbutton, CheesePreferencesDialog* self);
void cheese_preferences_dialog_on_burst_delay_change (GtkSpinButton* spinbutton, CheesePreferencesDialog* self);
void cheese_preferences_dialog_on_brightness_change (GtkAdjustment* adjustment, CheesePreferencesDialog* self);
void cheese_preferences_dialog_on_contrast_change (GtkAdjustment* adjustment, CheesePreferencesDialog* self);
void cheese_preferences_dialog_on_hue_change (GtkAdjustment* adjustment, CheesePreferencesDialog* self);
void cheese_preferences_dialog_on_saturation_change (GtkAdjustment* adjustment, CheesePreferencesDialog* self);
void cheese_preferences_dialog_show (CheesePreferencesDialog* self);
void cheese_preferences_dialog_set_current_mode (CheesePreferencesDialog* self, CheeseMediaMode mode);
static void cheese_preferences_dialog_finalize (GObject* obj);


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


CheesePreferencesDialog* cheese_preferences_dialog_construct (GType object_type, CheeseCamera* camera, GSettings* settings) {
	CheesePreferencesDialog * self = NULL;
	CheeseCamera* _tmp0_;
	GSettings* _tmp1_;
	GtkBuilder* _tmp2_ = NULL;
	GtkBuilder* builder;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_;
	GObject* _tmp5_ = NULL;
	GtkDialog* _tmp6_;
	GObject* _tmp7_ = NULL;
	GtkAdjustment* _tmp8_;
	GObject* _tmp9_ = NULL;
	GtkAdjustment* _tmp10_;
	GObject* _tmp11_ = NULL;
	GtkAdjustment* _tmp12_;
	GObject* _tmp13_ = NULL;
	GtkAdjustment* _tmp14_;
	GObject* _tmp15_ = NULL;
	GtkScale* _tmp16_;
	GObject* _tmp17_ = NULL;
	GtkScale* _tmp18_;
	GObject* _tmp19_ = NULL;
	GtkScale* _tmp20_;
	GObject* _tmp21_ = NULL;
	GtkScale* _tmp22_;
	GObject* _tmp23_ = NULL;
	GtkComboBox* _tmp24_;
	GObject* _tmp25_ = NULL;
	GtkComboBox* _tmp26_;
	GObject* _tmp27_ = NULL;
	GtkComboBox* _tmp28_;
	GObject* _tmp29_ = NULL;
	GtkSpinButton* _tmp30_;
	GObject* _tmp31_ = NULL;
	GtkSpinButton* _tmp32_;
	GObject* _tmp33_ = NULL;
	GtkCheckButton* _tmp34_;
	GObject* _tmp35_ = NULL;
	GtkCheckButton* _tmp36_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (camera != NULL, NULL);
	g_return_val_if_fail (settings != NULL, NULL);
	self = (CheesePreferencesDialog*) g_object_new (object_type, NULL);
	_tmp0_ = _g_object_ref0 (camera);
	_g_object_unref0 (self->priv->camera);
	self->priv->camera = _tmp0_;
	_tmp1_ = _g_object_ref0 (settings);
	_g_object_unref0 (self->priv->settings);
	self->priv->settings = _tmp1_;
	_tmp2_ = gtk_builder_new ();
	builder = _tmp2_;
	_tmp3_ = g_build_filename (PACKAGE_DATADIR, "cheese-prefs.ui", NULL);
	_tmp4_ = _tmp3_;
	gtk_builder_add_from_file (builder, _tmp4_, &_inner_error_);
	_g_free0 (_tmp4_);
	if (_inner_error_ != NULL) {
		goto __catch13_g_error;
	}
	goto __finally13;
	__catch13_g_error:
	{
		GError * err;
		err = _inner_error_;
		_inner_error_ = NULL;
		g_error ("cheese-preferences.vala:66: Error: %s", err->message);
		_g_error_free0 (err);
	}
	__finally13:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (builder);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_tmp5_ = gtk_builder_get_object (builder, "cheese_prefs_dialog");
	_tmp6_ = _g_object_ref0 (GTK_DIALOG (_tmp5_));
	_g_object_unref0 (self->priv->dialog);
	self->priv->dialog = _tmp6_;
	_tmp7_ = gtk_builder_get_object (builder, "brightness_adjustment");
	_tmp8_ = _g_object_ref0 (GTK_ADJUSTMENT (_tmp7_));
	_g_object_unref0 (self->priv->brightness_adjustment);
	self->priv->brightness_adjustment = _tmp8_;
	_tmp9_ = gtk_builder_get_object (builder, "contrast_adjustment");
	_tmp10_ = _g_object_ref0 (GTK_ADJUSTMENT (_tmp9_));
	_g_object_unref0 (self->priv->contrast_adjustment);
	self->priv->contrast_adjustment = _tmp10_;
	_tmp11_ = gtk_builder_get_object (builder, "hue_adjustment");
	_tmp12_ = _g_object_ref0 (GTK_ADJUSTMENT (_tmp11_));
	_g_object_unref0 (self->priv->hue_adjustment);
	self->priv->hue_adjustment = _tmp12_;
	_tmp13_ = gtk_builder_get_object (builder, "saturation_adjustment");
	_tmp14_ = _g_object_ref0 (GTK_ADJUSTMENT (_tmp13_));
	_g_object_unref0 (self->priv->saturation_adjustment);
	self->priv->saturation_adjustment = _tmp14_;
	_tmp15_ = gtk_builder_get_object (builder, "brightness_scale");
	_tmp16_ = _g_object_ref0 (GTK_SCALE (_tmp15_));
	_g_object_unref0 (self->priv->brightness_scale);
	self->priv->brightness_scale = _tmp16_;
	_tmp17_ = gtk_builder_get_object (builder, "contrast_scale");
	_tmp18_ = _g_object_ref0 (GTK_SCALE (_tmp17_));
	_g_object_unref0 (self->priv->contrast_scale);
	self->priv->contrast_scale = _tmp18_;
	_tmp19_ = gtk_builder_get_object (builder, "hue_scale");
	_tmp20_ = _g_object_ref0 (GTK_SCALE (_tmp19_));
	_g_object_unref0 (self->priv->hue_scale);
	self->priv->hue_scale = _tmp20_;
	_tmp21_ = gtk_builder_get_object (builder, "saturation_scale");
	_tmp22_ = _g_object_ref0 (GTK_SCALE (_tmp21_));
	_g_object_unref0 (self->priv->saturation_scale);
	self->priv->saturation_scale = _tmp22_;
	gtk_scale_add_mark (self->priv->brightness_scale, (gdouble) 0, GTK_POS_BOTTOM, NULL);
	gtk_scale_add_mark (self->priv->contrast_scale, (gdouble) 1, GTK_POS_BOTTOM, NULL);
	gtk_scale_add_mark (self->priv->hue_scale, (gdouble) 0, GTK_POS_BOTTOM, NULL);
	gtk_scale_add_mark (self->priv->saturation_scale, (gdouble) 1, GTK_POS_BOTTOM, NULL);
	_tmp23_ = gtk_builder_get_object (builder, "photo_resolution_combo_box");
	_tmp24_ = _g_object_ref0 (GTK_COMBO_BOX (_tmp23_));
	_g_object_unref0 (self->priv->photo_resolution_combo);
	self->priv->photo_resolution_combo = _tmp24_;
	_tmp25_ = gtk_builder_get_object (builder, "video_resolution_combo_box");
	_tmp26_ = _g_object_ref0 (GTK_COMBO_BOX (_tmp25_));
	_g_object_unref0 (self->priv->video_resolution_combo);
	self->priv->video_resolution_combo = _tmp26_;
	_tmp27_ = gtk_builder_get_object (builder, "camera_combo_box");
	_tmp28_ = _g_object_ref0 (GTK_COMBO_BOX (_tmp27_));
	_g_object_unref0 (self->priv->source_combo);
	self->priv->source_combo = _tmp28_;
	_tmp29_ = gtk_builder_get_object (builder, "burst_repeat");
	_tmp30_ = _g_object_ref0 (GTK_SPIN_BUTTON (_tmp29_));
	_g_object_unref0 (self->priv->burst_repeat_spin);
	self->priv->burst_repeat_spin = _tmp30_;
	_tmp31_ = gtk_builder_get_object (builder, "burst_delay");
	_tmp32_ = _g_object_ref0 (GTK_SPIN_BUTTON (_tmp31_));
	_g_object_unref0 (self->priv->burst_delay_spin);
	self->priv->burst_delay_spin = _tmp32_;
	_tmp33_ = gtk_builder_get_object (builder, "countdown");
	_tmp34_ = _g_object_ref0 (GTK_CHECK_BUTTON (_tmp33_));
	_g_object_unref0 (self->priv->countdown_check);
	self->priv->countdown_check = _tmp34_;
	_tmp35_ = gtk_builder_get_object (builder, "flash");
	_tmp36_ = _g_object_ref0 (GTK_CHECK_BUTTON (_tmp35_));
	_g_object_unref0 (self->priv->flash_check);
	self->priv->flash_check = _tmp36_;
	cheese_preferences_dialog_setup_combo_box_models (self);
	cheese_preferences_dialog_initialize_camera_devices (self);
	cheese_preferences_dialog_initialize_values_from_settings (self);
	gtk_builder_connect_signals (builder, self);
	_g_object_unref0 (builder);
	return self;
}


CheesePreferencesDialog* cheese_preferences_dialog_new (CheeseCamera* camera, GSettings* settings) {
	return cheese_preferences_dialog_construct (CHEESE_TYPE_PREFERENCES_DIALOG, camera, settings);
}


static void cheese_preferences_dialog_setup_combo_box_models (CheesePreferencesDialog* self) {
	GtkCellRendererText* _tmp0_ = NULL;
	GtkCellRendererText* cell;
	g_return_if_fail (self != NULL);
	_tmp0_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
	cell = g_object_ref_sink (_tmp0_);
	gtk_cell_layout_pack_start ((GtkCellLayout*) self->priv->photo_resolution_combo, (GtkCellRenderer*) cell, FALSE);
	gtk_cell_layout_set_attributes ((GtkCellLayout*) self->priv->photo_resolution_combo, (GtkCellRenderer*) cell, "text", 0, NULL);
	gtk_cell_layout_pack_start ((GtkCellLayout*) self->priv->video_resolution_combo, (GtkCellRenderer*) cell, FALSE);
	gtk_cell_layout_set_attributes ((GtkCellLayout*) self->priv->video_resolution_combo, (GtkCellRenderer*) cell, "text", 0, NULL);
	gtk_cell_layout_pack_start ((GtkCellLayout*) self->priv->source_combo, (GtkCellRenderer*) cell, FALSE);
	gtk_cell_layout_set_attributes ((GtkCellLayout*) self->priv->source_combo, (GtkCellRenderer*) cell, "text", 0, NULL);
	_g_object_unref0 (cell);
}


static void cheese_preferences_dialog_initialize_camera_devices (CheesePreferencesDialog* self) {
	CheeseCameraDevice* dev = NULL;
	GPtrArray* _tmp0_ = NULL;
	GPtrArray* devices;
	GtkListStore* _tmp1_ = NULL;
	GtkListStore* camera_model;
	CheeseCameraDevice* _tmp17_ = NULL;
	const gchar* _tmp18_ = NULL;
	CheeseCameraDevice* _tmp19_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = cheese_camera_get_camera_devices (self->priv->camera);
	devices = _tmp0_;
	_tmp1_ = gtk_list_store_new (2, G_TYPE_STRING, CHEESE_TYPE_CAMERA_DEVICE);
	camera_model = _tmp1_;
	gtk_combo_box_set_model (self->priv->source_combo, (GtkTreeModel*) camera_model);
	if (devices->len <= 1) {
		gtk_widget_set_sensitive ((GtkWidget*) self->priv->source_combo, FALSE);
	}
	{
		gint i;
		i = 0;
		{
			gboolean _tmp2_;
			_tmp2_ = TRUE;
			while (TRUE) {
				GtkTreeIter iter = {0};
				void* _tmp3_ = NULL;
				CheeseCameraDevice* _tmp4_;
				GtkTreeIter _tmp5_ = {0};
				const gchar* _tmp6_ = NULL;
				gchar* _tmp7_;
				gchar* _tmp8_;
				const gchar* _tmp9_ = NULL;
				gchar* _tmp10_;
				gchar* _tmp11_;
				gchar* _tmp12_;
				gchar* _tmp13_;
				CheeseCameraDevice* _tmp14_ = NULL;
				const gchar* _tmp15_ = NULL;
				const gchar* _tmp16_ = NULL;
				if (!_tmp2_) {
					i++;
				}
				_tmp2_ = FALSE;
				if (!(i < devices->len)) {
					break;
				}
				_tmp3_ = g_ptr_array_index (devices, (guint) i);
				_tmp4_ = _g_object_ref0 (CHEESE_CAMERA_DEVICE (_tmp3_));
				_g_object_unref0 (dev);
				dev = _tmp4_;
				gtk_list_store_append (camera_model, &_tmp5_);
				iter = _tmp5_;
				_tmp6_ = cheese_camera_device_get_name (dev);
				_tmp7_ = g_strconcat (_tmp6_, " (", NULL);
				_tmp8_ = _tmp7_;
				_tmp9_ = cheese_camera_device_get_device_file (dev);
				_tmp10_ = g_strconcat (_tmp8_, _tmp9_, NULL);
				_tmp11_ = _tmp10_;
				_tmp12_ = g_strconcat (_tmp11_, " )", NULL);
				_tmp13_ = _tmp12_;
				gtk_list_store_set (camera_model, &iter, 0, _tmp13_, 1, dev, -1);
				_g_free0 (_tmp13_);
				_g_free0 (_tmp11_);
				_g_free0 (_tmp8_);
				_tmp14_ = cheese_camera_get_selected_device (self->priv->camera);
				_tmp15_ = cheese_camera_device_get_device_file (_tmp14_);
				_tmp16_ = cheese_camera_device_get_device_file (dev);
				if (g_strcmp0 (_tmp15_, _tmp16_) == 0) {
					gtk_combo_box_set_active_iter (self->priv->source_combo, &iter);
				}
			}
		}
	}
	_tmp17_ = cheese_camera_get_selected_device (self->priv->camera);
	_tmp18_ = cheese_camera_device_get_device_file (_tmp17_);
	g_settings_set_string (self->priv->settings, "camera", _tmp18_);
	_tmp19_ = cheese_camera_get_selected_device (self->priv->camera);
	cheese_preferences_dialog_setup_resolutions_for_device (self, _tmp19_);
	_g_object_unref0 (camera_model);
	_g_object_unref0 (dev);
}


static void cheese_preferences_dialog_setup_resolutions_for_device (CheesePreferencesDialog* self, CheeseCameraDevice* device) {
	GList* _tmp0_ = NULL;
	GList* formats;
	CheeseVideoFormat* format = NULL;
	GtkListStore* _tmp1_ = NULL;
	GtkListStore* resolution_model;
	gint _tmp20_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (device != NULL);
	_tmp0_ = cheese_camera_device_get_format_list (device);
	formats = _tmp0_;
	_tmp1_ = gtk_list_store_new (2, G_TYPE_STRING, CHEESE_TYPE_VIDEO_FORMAT);
	resolution_model = _tmp1_;
	gtk_combo_box_set_model (self->priv->photo_resolution_combo, (GtkTreeModel*) resolution_model);
	gtk_combo_box_set_model (self->priv->video_resolution_combo, (GtkTreeModel*) resolution_model);
	{
		gint i;
		i = 0;
		{
			gboolean _tmp2_;
			_tmp2_ = TRUE;
			while (TRUE) {
				guint _tmp3_;
				GtkTreeIter iter = {0};
				GList* _tmp4_ = NULL;
				GtkTreeIter _tmp5_ = {0};
				gchar* _tmp6_ = NULL;
				gchar* _tmp7_;
				gchar* _tmp8_;
				gchar* _tmp9_;
				gchar* _tmp10_ = NULL;
				gchar* _tmp11_;
				gchar* _tmp12_;
				gchar* _tmp13_;
				gboolean _tmp14_ = FALSE;
				CheeseVideoFormat* _tmp15_ = NULL;
				gboolean _tmp17_ = FALSE;
				gint _tmp18_;
				if (!_tmp2_) {
					i++;
				}
				_tmp2_ = FALSE;
				_tmp3_ = g_list_length (formats);
				if (!(i < _tmp3_)) {
					break;
				}
				_tmp4_ = g_list_nth (formats, (guint) i);
				format = (CheeseVideoFormat*) _tmp4_->data;
				gtk_list_store_append (resolution_model, &_tmp5_);
				iter = _tmp5_;
				_tmp6_ = g_strdup_printf ("%i", format->width);
				_tmp7_ = _tmp6_;
				_tmp8_ = g_strconcat (_tmp7_, " x ", NULL);
				_tmp9_ = _tmp8_;
				_tmp10_ = g_strdup_printf ("%i", format->height);
				_tmp11_ = _tmp10_;
				_tmp12_ = g_strconcat (_tmp9_, _tmp11_, NULL);
				_tmp13_ = _tmp12_;
				gtk_list_store_set (resolution_model, &iter, 0, _tmp13_, 1, format, -1);
				_g_free0 (_tmp13_);
				_g_free0 (_tmp11_);
				_g_free0 (_tmp9_);
				_g_free0 (_tmp7_);
				_tmp15_ = cheese_camera_get_current_video_format (self->priv->camera);
				if (_tmp15_->width == format->width) {
					CheeseVideoFormat* _tmp16_ = NULL;
					_tmp16_ = cheese_camera_get_current_video_format (self->priv->camera);
					_tmp14_ = _tmp16_->height == format->height;
				} else {
					_tmp14_ = FALSE;
				}
				if (_tmp14_) {
					gtk_combo_box_set_active_iter (self->priv->photo_resolution_combo, &iter);
					g_settings_set_int (self->priv->settings, "photo-x-resolution", format->width);
					g_settings_set_int (self->priv->settings, "photo-y-resolution", format->height);
				}
				_tmp18_ = g_settings_get_int (self->priv->settings, "video-x-resolution");
				if (_tmp18_ == format->width) {
					gint _tmp19_;
					_tmp19_ = g_settings_get_int (self->priv->settings, "video-y-resolution");
					_tmp17_ = _tmp19_ == format->height;
				} else {
					_tmp17_ = FALSE;
				}
				if (_tmp17_) {
					gtk_combo_box_set_active_iter (self->priv->video_resolution_combo, &iter);
				}
			}
		}
	}
	_tmp20_ = gtk_combo_box_get_active (self->priv->video_resolution_combo);
	if (_tmp20_ == (-1)) {
		gint _tmp21_;
		gint _tmp22_;
		gint _tmp23_;
		_tmp21_ = gtk_combo_box_get_active (self->priv->photo_resolution_combo);
		gtk_combo_box_set_active (self->priv->video_resolution_combo, _tmp21_);
		_tmp22_ = g_settings_get_int (self->priv->settings, "photo-x-resolution");
		g_settings_set_int (self->priv->settings, "video-x-resolution", _tmp22_);
		_tmp23_ = g_settings_get_int (self->priv->settings, "photo-y-resolution");
		g_settings_set_int (self->priv->settings, "video-y-resolution", _tmp23_);
	}
	_g_object_unref0 (resolution_model);
}


static void cheese_preferences_dialog_initialize_values_from_settings (CheesePreferencesDialog* self) {
	gdouble _tmp0_;
	gdouble _tmp1_;
	gdouble _tmp2_;
	gdouble _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	gboolean _tmp6_;
	gboolean _tmp7_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_settings_get_double (self->priv->settings, "brightness");
	gtk_adjustment_set_value (self->priv->brightness_adjustment, _tmp0_);
	_tmp1_ = g_settings_get_double (self->priv->settings, "contrast");
	gtk_adjustment_set_value (self->priv->contrast_adjustment, _tmp1_);
	_tmp2_ = g_settings_get_double (self->priv->settings, "hue");
	gtk_adjustment_set_value (self->priv->hue_adjustment, _tmp2_);
	_tmp3_ = g_settings_get_double (self->priv->settings, "saturation");
	gtk_adjustment_set_value (self->priv->saturation_adjustment, _tmp3_);
	_tmp4_ = g_settings_get_int (self->priv->settings, "burst-repeat");
	gtk_spin_button_set_value (self->priv->burst_repeat_spin, (gdouble) _tmp4_);
	_tmp5_ = g_settings_get_int (self->priv->settings, "burst-delay");
	gtk_spin_button_set_value (self->priv->burst_delay_spin, (gdouble) (_tmp5_ / 1000));
	_tmp6_ = g_settings_get_boolean (self->priv->settings, "countdown");
	gtk_toggle_button_set_active ((GtkToggleButton*) self->priv->countdown_check, _tmp6_);
	_tmp7_ = g_settings_get_boolean (self->priv->settings, "flash");
	gtk_toggle_button_set_active ((GtkToggleButton*) self->priv->flash_check, _tmp7_);
}


void cheese_preferences_dialog_on_source_change (GtkComboBox* combo, CheesePreferencesDialog* self) {
	GtkTreeIter iter = {0};
	CheeseCameraDevice* dev = NULL;
	GtkTreeIter _tmp0_ = {0};
	GtkTreeModel* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	CheeseCameraDevice* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (combo != NULL);
	gtk_combo_box_get_active_iter (combo, &_tmp0_);
	iter = _tmp0_;
	_tmp1_ = gtk_combo_box_get_model (combo);
	gtk_tree_model_get (_tmp1_, &iter, 1, &dev, -1);
	_tmp2_ = cheese_camera_device_get_device_file (dev);
	cheese_camera_set_device_by_dev_file (self->priv->camera, _tmp2_);
	cheese_camera_switch_camera_device (self->priv->camera);
	_tmp3_ = cheese_camera_get_selected_device (self->priv->camera);
	cheese_preferences_dialog_setup_resolutions_for_device (self, _tmp3_);
	_tmp4_ = cheese_camera_device_get_device_file (dev);
	g_settings_set_string (self->priv->settings, "camera", _tmp4_);
	_g_object_unref0 (dev);
}


void cheese_preferences_dialog_on_photo_resolution_change (GtkComboBox* combo, CheesePreferencesDialog* self) {
	GtkTreeIter iter = {0};
	CheeseVideoFormat* format = NULL;
	GtkTreeIter _tmp0_ = {0};
	GtkTreeModel* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (combo != NULL);
	gtk_combo_box_get_active_iter (combo, &_tmp0_);
	iter = _tmp0_;
	_tmp1_ = gtk_combo_box_get_model (combo);
	gtk_tree_model_get (_tmp1_, &iter, 1, &format, -1);
	if (self->priv->current_mode == CHEESE_MEDIA_MODE_PHOTO) {
		_tmp2_ = TRUE;
	} else {
		_tmp2_ = self->priv->current_mode == CHEESE_MEDIA_MODE_BURST;
	}
	if (_tmp2_) {
		cheese_camera_set_video_format (self->priv->camera, format);
	}
	g_settings_set_int (self->priv->settings, "photo-x-resolution", format->width);
	g_settings_set_int (self->priv->settings, "photo-y-resolution", format->height);
}


void cheese_preferences_dialog_on_video_resolution_change (GtkComboBox* combo, CheesePreferencesDialog* self) {
	GtkTreeIter iter = {0};
	CheeseVideoFormat* format = NULL;
	GtkTreeIter _tmp0_ = {0};
	GtkTreeModel* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (combo != NULL);
	gtk_combo_box_get_active_iter (combo, &_tmp0_);
	iter = _tmp0_;
	_tmp1_ = gtk_combo_box_get_model (combo);
	gtk_tree_model_get (_tmp1_, &iter, 1, &format, -1);
	if (self->priv->current_mode == CHEESE_MEDIA_MODE_VIDEO) {
		cheese_camera_set_video_format (self->priv->camera, format);
	}
	g_settings_set_int (self->priv->settings, "video-x-resolution", format->width);
	g_settings_set_int (self->priv->settings, "video-y-resolution", format->height);
}


void cheese_preferences_dialog_on_dialog_close (GtkButton* button, CheesePreferencesDialog* self) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (button != NULL);
	gtk_widget_hide ((GtkWidget*) self->priv->dialog);
}


void cheese_preferences_dialog_on_countdown_toggle (GtkCheckButton* checkbutton, CheesePreferencesDialog* self) {
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (checkbutton != NULL);
	_tmp0_ = gtk_toggle_button_get_active ((GtkToggleButton*) checkbutton);
	g_settings_set_boolean (self->priv->settings, "countdown", _tmp0_);
}


void cheese_preferences_dialog_on_flash_toggle (GtkCheckButton* checkbutton, CheesePreferencesDialog* self) {
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (checkbutton != NULL);
	_tmp0_ = gtk_toggle_button_get_active ((GtkToggleButton*) checkbutton);
	g_settings_set_boolean (self->priv->settings, "flash", _tmp0_);
}


void cheese_preferences_dialog_on_burst_repeat_change (GtkSpinButton* spinbutton, CheesePreferencesDialog* self) {
	gdouble _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (spinbutton != NULL);
	_tmp0_ = gtk_spin_button_get_value (spinbutton);
	g_settings_set_int (self->priv->settings, "burst-repeat", (gint) _tmp0_);
}


void cheese_preferences_dialog_on_burst_delay_change (GtkSpinButton* spinbutton, CheesePreferencesDialog* self) {
	gdouble _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (spinbutton != NULL);
	_tmp0_ = gtk_spin_button_get_value (spinbutton);
	g_settings_set_int (self->priv->settings, "burst-delay", ((gint) _tmp0_) * 1000);
}


void cheese_preferences_dialog_on_brightness_change (GtkAdjustment* adjustment, CheesePreferencesDialog* self) {
	gdouble _tmp0_;
	gdouble _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (adjustment != NULL);
	_tmp0_ = gtk_adjustment_get_value (adjustment);
	cheese_camera_set_balance_property (self->priv->camera, "brightness", _tmp0_);
	_tmp1_ = gtk_adjustment_get_value (adjustment);
	g_settings_set_double (self->priv->settings, "brightness", _tmp1_);
}


void cheese_preferences_dialog_on_contrast_change (GtkAdjustment* adjustment, CheesePreferencesDialog* self) {
	gdouble _tmp0_;
	gdouble _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (adjustment != NULL);
	_tmp0_ = gtk_adjustment_get_value (adjustment);
	cheese_camera_set_balance_property (self->priv->camera, "contrast", _tmp0_);
	_tmp1_ = gtk_adjustment_get_value (adjustment);
	g_settings_set_double (self->priv->settings, "contrast", _tmp1_);
}


void cheese_preferences_dialog_on_hue_change (GtkAdjustment* adjustment, CheesePreferencesDialog* self) {
	gdouble _tmp0_;
	gdouble _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (adjustment != NULL);
	_tmp0_ = gtk_adjustment_get_value (adjustment);
	cheese_camera_set_balance_property (self->priv->camera, "hue", _tmp0_);
	_tmp1_ = gtk_adjustment_get_value (adjustment);
	g_settings_set_double (self->priv->settings, "hue", _tmp1_);
}


void cheese_preferences_dialog_on_saturation_change (GtkAdjustment* adjustment, CheesePreferencesDialog* self) {
	gdouble _tmp0_;
	gdouble _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (adjustment != NULL);
	_tmp0_ = gtk_adjustment_get_value (adjustment);
	cheese_camera_set_balance_property (self->priv->camera, "saturation", _tmp0_);
	_tmp1_ = gtk_adjustment_get_value (adjustment);
	g_settings_set_double (self->priv->settings, "saturation", _tmp1_);
}


void cheese_preferences_dialog_show (CheesePreferencesDialog* self) {
	g_return_if_fail (self != NULL);
	gtk_widget_show_all ((GtkWidget*) self->priv->dialog);
}


void cheese_preferences_dialog_set_current_mode (CheesePreferencesDialog* self, CheeseMediaMode mode) {
	g_return_if_fail (self != NULL);
	self->priv->current_mode = mode;
}


static void cheese_preferences_dialog_class_init (CheesePreferencesDialogClass * klass) {
	cheese_preferences_dialog_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (CheesePreferencesDialogPrivate));
	G_OBJECT_CLASS (klass)->finalize = cheese_preferences_dialog_finalize;
}


static void cheese_preferences_dialog_instance_init (CheesePreferencesDialog * self) {
	self->priv = CHEESE_PREFERENCES_DIALOG_GET_PRIVATE (self);
}


static void cheese_preferences_dialog_finalize (GObject* obj) {
	CheesePreferencesDialog * self;
	self = CHEESE_PREFERENCES_DIALOG (obj);
	_g_object_unref0 (self->priv->camera);
	_g_object_unref0 (self->priv->settings);
	_g_object_unref0 (self->priv->dialog);
	_g_object_unref0 (self->priv->photo_resolution_combo);
	_g_object_unref0 (self->priv->video_resolution_combo);
	_g_object_unref0 (self->priv->source_combo);
	_g_object_unref0 (self->priv->brightness_adjustment);
	_g_object_unref0 (self->priv->contrast_adjustment);
	_g_object_unref0 (self->priv->hue_adjustment);
	_g_object_unref0 (self->priv->saturation_adjustment);
	_g_object_unref0 (self->priv->brightness_scale);
	_g_object_unref0 (self->priv->contrast_scale);
	_g_object_unref0 (self->priv->hue_scale);
	_g_object_unref0 (self->priv->saturation_scale);
	_g_object_unref0 (self->priv->burst_repeat_spin);
	_g_object_unref0 (self->priv->burst_delay_spin);
	_g_object_unref0 (self->priv->countdown_check);
	_g_object_unref0 (self->priv->flash_check);
	G_OBJECT_CLASS (cheese_preferences_dialog_parent_class)->finalize (obj);
}


GType cheese_preferences_dialog_get_type (void) {
	static volatile gsize cheese_preferences_dialog_type_id__volatile = 0;
	if (g_once_init_enter (&cheese_preferences_dialog_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (CheesePreferencesDialogClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) cheese_preferences_dialog_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (CheesePreferencesDialog), 0, (GInstanceInitFunc) cheese_preferences_dialog_instance_init, NULL };
		GType cheese_preferences_dialog_type_id;
		cheese_preferences_dialog_type_id = g_type_register_static (G_TYPE_OBJECT, "CheesePreferencesDialog", &g_define_type_info, 0);
		g_once_init_leave (&cheese_preferences_dialog_type_id__volatile, cheese_preferences_dialog_type_id);
	}
	return cheese_preferences_dialog_type_id__volatile;
}



