/* vinagre-dirs.c generated by valac 0.12.1, the Vala compiler
 * generated from vinagre-dirs.vala, do not modify */

/*  Vinagre - GNOME Remote Desktop viewer
 *
 *  Copyright (C) 2011  David King <amigadave@amigadave.com>
 *
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <config.h>
#include <glib/gstdio.h>

#define _g_free0(var) (var = (g_free (var), NULL))



gchar* vinagre_dirs_get_user_cache_dir (void);
gchar* vinagre_dirs_get_user_data_dir (void);
gchar* vinagre_dirs_get_package_data_file (const gchar* filename);
static gchar** _vala_array_dup1 (gchar** self, int length);
static void _vala_array_add1 (gchar*** array, int* length, int* size, gchar* value);
static void _vala_array_add2 (gchar*** array, int* length, int* size, gchar* value);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


gchar* vinagre_dirs_get_user_cache_dir (void) {
	gchar* result = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	_tmp0_ = g_get_user_cache_dir ();
	_tmp1_ = g_build_filename (_tmp0_, PACKAGE_TARNAME, NULL);
	result = _tmp1_;
	return result;
}


gchar* vinagre_dirs_get_user_data_dir (void) {
	gchar* result = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	_tmp0_ = g_get_user_data_dir ();
	_tmp1_ = g_build_filename (_tmp0_, PACKAGE_TARNAME, NULL);
	result = _tmp1_;
	return result;
}


static gchar** _vala_array_dup1 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		result[i] = g_strdup (self[i]);
	}
	return result;
}


static void _vala_array_add1 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _vala_array_add2 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


gchar* vinagre_dirs_get_package_data_file (const gchar* filename) {
	gchar* result = NULL;
	gchar** _tmp0_;
	gchar** _tmp1_ = NULL;
	gchar** _tmp2_;
	gchar** _tmp3_;
	gchar** system_data_dirs;
	gint system_data_dirs_length1;
	gint _system_data_dirs_size_;
	gchar** _tmp4_ = NULL;
	gchar** data_dirs;
	gint data_dirs_length1;
	gint _data_dirs_size_;
	gchar* _tmp5_;
	g_return_val_if_fail (filename != NULL, NULL);
	_tmp1_ = _tmp0_ = g_get_system_data_dirs ();
	_tmp2_ = (_tmp3_ = _tmp1_, (_tmp3_ == NULL) ? ((gpointer) _tmp3_) : _vala_array_dup1 (_tmp3_, _vala_array_length (_tmp0_)));
	system_data_dirs = _tmp2_;
	system_data_dirs_length1 = _vala_array_length (_tmp0_);
	_system_data_dirs_size_ = _vala_array_length (_tmp0_);
	_tmp4_ = g_new0 (gchar*, 0 + 1);
	data_dirs = _tmp4_;
	data_dirs_length1 = 0;
	_data_dirs_size_ = 0;
	_tmp5_ = g_strdup (DATADIR);
	_vala_array_add1 (&data_dirs, &data_dirs_length1, &_data_dirs_size_, _tmp5_);
	{
		gchar** dir_collection;
		int dir_collection_length1;
		int dir_it;
		dir_collection = system_data_dirs;
		dir_collection_length1 = system_data_dirs_length1;
		for (dir_it = 0; dir_it < system_data_dirs_length1; dir_it = dir_it + 1) {
			gchar* _tmp6_;
			gchar* dir;
			_tmp6_ = g_strdup (dir_collection[dir_it]);
			dir = _tmp6_;
			{
				gchar* _tmp7_;
				_tmp7_ = g_strdup (dir);
				_vala_array_add2 (&data_dirs, &data_dirs_length1, &_data_dirs_size_, _tmp7_);
				_g_free0 (dir);
			}
		}
	}
	{
		gchar** dir_collection;
		int dir_collection_length1;
		int dir_it;
		dir_collection = data_dirs;
		dir_collection_length1 = data_dirs_length1;
		for (dir_it = 0; dir_it < data_dirs_length1; dir_it = dir_it + 1) {
			gchar* _tmp8_;
			gchar* dir;
			_tmp8_ = g_strdup (dir_collection[dir_it]);
			dir = _tmp8_;
			{
				gchar* _tmp9_ = NULL;
				gchar* absolute_path;
				gboolean _tmp10_;
				_tmp9_ = g_build_filename (dir, PACKAGE_TARNAME, filename, NULL);
				absolute_path = _tmp9_;
				_tmp10_ = g_file_test (absolute_path, G_FILE_TEST_EXISTS);
				if (_tmp10_) {
					result = absolute_path;
					_g_free0 (dir);
					data_dirs = (_vala_array_free (data_dirs, data_dirs_length1, (GDestroyNotify) g_free), NULL);
					system_data_dirs = (_vala_array_free (system_data_dirs, system_data_dirs_length1, (GDestroyNotify) g_free), NULL);
					return result;
				}
				_g_free0 (absolute_path);
				_g_free0 (dir);
			}
		}
	}
	g_error ("vinagre-dirs.vala:47: Data file ‘%s’ could not be found in system data" \
" directories.", filename);
	data_dirs = (_vala_array_free (data_dirs, data_dirs_length1, (GDestroyNotify) g_free), NULL);
	system_data_dirs = (_vala_array_free (system_data_dirs, system_data_dirs_length1, (GDestroyNotify) g_free), NULL);
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



