/* rygel-av-transport.c generated by valac 0.13.3, the Vala compiler
 * generated from rygel-av-transport.vala, do not modify */

/*
 * Copyright (C) 2008 OpenedHand Ltd.
 * Copyright (C) 2009,2010 Nokia Corporation.
 *
 * Author: Jorn Baayen <jorn@openedhand.com>
 *         Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <libgupnp/gupnp.h>
#include <stdlib.h>
#include <string.h>
#include <gst/gst.h>
#include <float.h>
#include <math.h>
#include <glib/gi18n-lib.h>


#define RYGEL_TYPE_AV_TRANSPORT (rygel_av_transport_get_type ())
#define RYGEL_AV_TRANSPORT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_AV_TRANSPORT, RygelAVTransport))
#define RYGEL_AV_TRANSPORT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_AV_TRANSPORT, RygelAVTransportClass))
#define RYGEL_IS_AV_TRANSPORT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_AV_TRANSPORT))
#define RYGEL_IS_AV_TRANSPORT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_AV_TRANSPORT))
#define RYGEL_AV_TRANSPORT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_AV_TRANSPORT, RygelAVTransportClass))

typedef struct _RygelAVTransport RygelAVTransport;
typedef struct _RygelAVTransportClass RygelAVTransportClass;
typedef struct _RygelAVTransportPrivate RygelAVTransportPrivate;

#define RYGEL_TYPE_CHANGE_LOG (rygel_change_log_get_type ())
#define RYGEL_CHANGE_LOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_CHANGE_LOG, RygelChangeLog))
#define RYGEL_CHANGE_LOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_CHANGE_LOG, RygelChangeLogClass))
#define RYGEL_IS_CHANGE_LOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_CHANGE_LOG))
#define RYGEL_IS_CHANGE_LOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_CHANGE_LOG))
#define RYGEL_CHANGE_LOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_CHANGE_LOG, RygelChangeLogClass))

typedef struct _RygelChangeLog RygelChangeLog;
typedef struct _RygelChangeLogClass RygelChangeLogClass;

#define RYGEL_TYPE_MEDIA_PLAYER (rygel_media_player_get_type ())
#define RYGEL_MEDIA_PLAYER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_PLAYER, RygelMediaPlayer))
#define RYGEL_IS_MEDIA_PLAYER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_PLAYER))
#define RYGEL_MEDIA_PLAYER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_MEDIA_PLAYER, RygelMediaPlayerIface))

typedef struct _RygelMediaPlayer RygelMediaPlayer;
typedef struct _RygelMediaPlayerIface RygelMediaPlayerIface;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define RYGEL_TYPE_PLUGIN (rygel_plugin_get_type ())
#define RYGEL_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_PLUGIN, RygelPlugin))
#define RYGEL_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_PLUGIN, RygelPluginClass))
#define RYGEL_IS_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_PLUGIN))
#define RYGEL_IS_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_PLUGIN))
#define RYGEL_PLUGIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_PLUGIN, RygelPluginClass))

typedef struct _RygelPlugin RygelPlugin;
typedef struct _RygelPluginClass RygelPluginClass;

#define RYGEL_TYPE_MEDIA_RENDERER_PLUGIN (rygel_media_renderer_plugin_get_type ())
#define RYGEL_MEDIA_RENDERER_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_RENDERER_PLUGIN, RygelMediaRendererPlugin))
#define RYGEL_MEDIA_RENDERER_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_RENDERER_PLUGIN, RygelMediaRendererPluginClass))
#define RYGEL_IS_MEDIA_RENDERER_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_RENDERER_PLUGIN))
#define RYGEL_IS_MEDIA_RENDERER_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_RENDERER_PLUGIN))
#define RYGEL_MEDIA_RENDERER_PLUGIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_RENDERER_PLUGIN, RygelMediaRendererPluginClass))

typedef struct _RygelMediaRendererPlugin RygelMediaRendererPlugin;
typedef struct _RygelMediaRendererPluginClass RygelMediaRendererPluginClass;

struct _RygelAVTransport {
	GUPnPService parent_instance;
	RygelAVTransportPrivate * priv;
};

struct _RygelAVTransportClass {
	GUPnPServiceClass parent_class;
};

struct _RygelMediaPlayerIface {
	GTypeInterface parent_iface;
	gboolean (*seek) (RygelMediaPlayer* self, GstClockTime time);
	gchar** (*get_protocols) (RygelMediaPlayer* self, int* result_length1);
	gchar** (*get_mime_types) (RygelMediaPlayer* self, int* result_length1);
	gchar* (*get_playback_state) (RygelMediaPlayer* self);
	void (*set_playback_state) (RygelMediaPlayer* self, const gchar* value);
	gchar* (*get_uri) (RygelMediaPlayer* self);
	void (*set_uri) (RygelMediaPlayer* self, const gchar* value);
	gdouble (*get_volume) (RygelMediaPlayer* self);
	void (*set_volume) (RygelMediaPlayer* self, gdouble value);
	gint64 (*get_duration) (RygelMediaPlayer* self);
	gint64 (*get_position) (RygelMediaPlayer* self);
};

struct _RygelAVTransportPrivate {
	guint _n_tracks;
	guint _track;
	gchar* _metadata;
	gchar* _status;
	gchar* _speed;
	gchar* _mode;
	RygelChangeLog* changelog;
	RygelMediaPlayer* player;
};


static gpointer rygel_av_transport_parent_class = NULL;

GType rygel_av_transport_get_type (void) G_GNUC_CONST;
GType rygel_change_log_get_type (void) G_GNUC_CONST;
GType rygel_media_player_get_type (void) G_GNUC_CONST;
#define RYGEL_AV_TRANSPORT_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_AV_TRANSPORT, RygelAVTransportPrivate))
enum  {
	RYGEL_AV_TRANSPORT_DUMMY_PROPERTY,
	RYGEL_AV_TRANSPORT_N_TRACKS,
	RYGEL_AV_TRANSPORT_TRACK,
	RYGEL_AV_TRANSPORT_METADATA,
	RYGEL_AV_TRANSPORT_URI,
	RYGEL_AV_TRANSPORT_STATUS,
	RYGEL_AV_TRANSPORT_SPEED,
	RYGEL_AV_TRANSPORT_MODE
};
#define RYGEL_AV_TRANSPORT_UPNP_ID "urn:upnp-org:serviceId:AVTransport"
#define RYGEL_AV_TRANSPORT_UPNP_TYPE "urn:schemas-upnp-org:service:AVTransport:2"
#define RYGEL_AV_TRANSPORT_DESCRIPTION_PATH "xml/AVTransport2.xml"
#define RYGEL_AV_TRANSPORT_LAST_CHANGE_NS "urn:schemas-upnp-org:metadata-1-0/AVT/"
static void rygel_av_transport_real_constructed (GObject* base);
RygelChangeLog* rygel_change_log_new (GUPnPService* service, const gchar* service_ns);
RygelChangeLog* rygel_change_log_construct (GType object_type, GUPnPService* service, const gchar* service_ns);
static RygelMediaPlayer* rygel_av_transport_get_player (RygelAVTransport* self);
static void rygel_av_transport_query_last_change_cb (RygelAVTransport* self, GUPnPService* service, const gchar* variable, GValue* value);
static void _rygel_av_transport_query_last_change_cb_gupnp_service_query_variable (GUPnPService* _sender, const gchar* variable, GValue* value, gpointer self);
static void rygel_av_transport_set_av_transport_uri_cb (RygelAVTransport* self, GUPnPService* service, GUPnPServiceAction* action);
static void _rygel_av_transport_set_av_transport_uri_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self);
static void rygel_av_transport_get_media_info_cb (RygelAVTransport* self, GUPnPService* service, GUPnPServiceAction* action);
static void _rygel_av_transport_get_media_info_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self);
static void rygel_av_transport_get_transport_info_cb (RygelAVTransport* self, GUPnPService* service, GUPnPServiceAction* action);
static void _rygel_av_transport_get_transport_info_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self);
static void rygel_av_transport_get_position_info_cb (RygelAVTransport* self, GUPnPService* service, GUPnPServiceAction* action);
static void _rygel_av_transport_get_position_info_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self);
static void rygel_av_transport_get_device_capabilities_cb (RygelAVTransport* self, GUPnPService* service, GUPnPServiceAction* action);
static void _rygel_av_transport_get_device_capabilities_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self);
static void rygel_av_transport_get_transport_settings_cb (RygelAVTransport* self, GUPnPService* service, GUPnPServiceAction* action);
static void _rygel_av_transport_get_transport_settings_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self);
static void rygel_av_transport_stop_cb (RygelAVTransport* self, GUPnPService* service, GUPnPServiceAction* action);
static void _rygel_av_transport_stop_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self);
static void rygel_av_transport_play_cb (RygelAVTransport* self, GUPnPService* service, GUPnPServiceAction* action);
static void _rygel_av_transport_play_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self);
static void rygel_av_transport_pause_cb (RygelAVTransport* self, GUPnPService* service, GUPnPServiceAction* action);
static void _rygel_av_transport_pause_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self);
static void rygel_av_transport_seek_cb (RygelAVTransport* self, GUPnPService* service, GUPnPServiceAction* action);
static void _rygel_av_transport_seek_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self);
static void rygel_av_transport_next_cb (RygelAVTransport* self, GUPnPService* service, GUPnPServiceAction* action);
static void _rygel_av_transport_next_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self);
static void rygel_av_transport_previous_cb (RygelAVTransport* self, GUPnPService* service, GUPnPServiceAction* action);
static void _rygel_av_transport_previous_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self);
static void rygel_av_transport_notify_state_cb (RygelAVTransport* self, GObject* player, GParamSpec* p);
static void _rygel_av_transport_notify_state_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void rygel_av_transport_notify_duration_cb (RygelAVTransport* self, GObject* player, GParamSpec* p);
static void _rygel_av_transport_notify_duration_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
GType rygel_plugin_get_type (void) G_GNUC_CONST;
GType rygel_media_renderer_plugin_get_type (void) G_GNUC_CONST;
RygelMediaPlayer* rygel_media_renderer_plugin_get_player (RygelMediaRendererPlugin* self);
void rygel_change_log_log (RygelChangeLog* self, const gchar* variable, const gchar* value);
gchar* rygel_media_player_get_playback_state (RygelMediaPlayer* self);
const gchar* rygel_av_transport_get_status (RygelAVTransport* self);
const gchar* rygel_av_transport_get_mode (RygelAVTransport* self);
const gchar* rygel_av_transport_get_speed (RygelAVTransport* self);
guint rygel_av_transport_get_n_tracks (RygelAVTransport* self);
guint rygel_av_transport_get_track (RygelAVTransport* self);
gchar* rygel_media_player_get_duration_as_str (RygelMediaPlayer* self);
gchar* rygel_av_transport_get_metadata (RygelAVTransport* self);
gchar* rygel_av_transport_get_uri (RygelAVTransport* self);
gchar* rygel_change_log_finish (RygelChangeLog* self);
static gboolean rygel_av_transport_check_instance_id (RygelAVTransport* self, GUPnPServiceAction* action);
void rygel_av_transport_set_uri (RygelAVTransport* self, const gchar* value);
void rygel_av_transport_set_metadata (RygelAVTransport* self, const gchar* value);
gchar* rygel_media_player_get_position_as_str (RygelMediaPlayer* self);
void rygel_media_player_set_playback_state (RygelMediaPlayer* self, const gchar* value);
gboolean rygel_media_player_seek (RygelMediaPlayer* self, GstClockTime time);
GstClockTime rygel_gst_utils_time_from_string (const gchar* str);
RygelAVTransport* rygel_av_transport_new (void);
RygelAVTransport* rygel_av_transport_construct (GType object_type);
void rygel_av_transport_set_n_tracks (RygelAVTransport* self, guint value);
void rygel_av_transport_set_track (RygelAVTransport* self, guint value);
gchar* rygel_media_player_get_uri (RygelMediaPlayer* self);
void rygel_media_player_set_uri (RygelMediaPlayer* self, const gchar* value);
void rygel_av_transport_set_status (RygelAVTransport* self, const gchar* value);
void rygel_av_transport_set_speed (RygelAVTransport* self, const gchar* value);
void rygel_av_transport_set_mode (RygelAVTransport* self, const gchar* value);
static void rygel_av_transport_finalize (GObject* obj);
static void _vala_rygel_av_transport_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_rygel_av_transport_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


static void _rygel_av_transport_query_last_change_cb_gupnp_service_query_variable (GUPnPService* _sender, const gchar* variable, GValue* value, gpointer self) {
#line 141 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	rygel_av_transport_query_last_change_cb (self, _sender, variable, value);
#line 218 "rygel-av-transport.c"
}


static void _rygel_av_transport_set_av_transport_uri_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self) {
#line 143 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	rygel_av_transport_set_av_transport_uri_cb (self, _sender, action);
#line 225 "rygel-av-transport.c"
}


static void _rygel_av_transport_get_media_info_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self) {
#line 145 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	rygel_av_transport_get_media_info_cb (self, _sender, action);
#line 232 "rygel-av-transport.c"
}


static void _rygel_av_transport_get_transport_info_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self) {
#line 146 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	rygel_av_transport_get_transport_info_cb (self, _sender, action);
#line 239 "rygel-av-transport.c"
}


static void _rygel_av_transport_get_position_info_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self) {
#line 147 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	rygel_av_transport_get_position_info_cb (self, _sender, action);
#line 246 "rygel-av-transport.c"
}


static void _rygel_av_transport_get_device_capabilities_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self) {
#line 148 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	rygel_av_transport_get_device_capabilities_cb (self, _sender, action);
#line 253 "rygel-av-transport.c"
}


static void _rygel_av_transport_get_transport_settings_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self) {
#line 150 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	rygel_av_transport_get_transport_settings_cb (self, _sender, action);
#line 260 "rygel-av-transport.c"
}


static void _rygel_av_transport_stop_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self) {
#line 152 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	rygel_av_transport_stop_cb (self, _sender, action);
#line 267 "rygel-av-transport.c"
}


static void _rygel_av_transport_play_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self) {
#line 153 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	rygel_av_transport_play_cb (self, _sender, action);
#line 274 "rygel-av-transport.c"
}


static void _rygel_av_transport_pause_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self) {
#line 154 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	rygel_av_transport_pause_cb (self, _sender, action);
#line 281 "rygel-av-transport.c"
}


static void _rygel_av_transport_seek_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self) {
#line 155 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	rygel_av_transport_seek_cb (self, _sender, action);
#line 288 "rygel-av-transport.c"
}


static void _rygel_av_transport_next_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self) {
#line 156 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	rygel_av_transport_next_cb (self, _sender, action);
#line 295 "rygel-av-transport.c"
}


static void _rygel_av_transport_previous_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self) {
#line 157 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	rygel_av_transport_previous_cb (self, _sender, action);
#line 302 "rygel-av-transport.c"
}


static void _rygel_av_transport_notify_state_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
#line 159 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	rygel_av_transport_notify_state_cb (self, _sender, pspec);
#line 309 "rygel-av-transport.c"
}


static void _rygel_av_transport_notify_duration_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
#line 160 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	rygel_av_transport_notify_duration_cb (self, _sender, pspec);
#line 316 "rygel-av-transport.c"
}


static void rygel_av_transport_real_constructed (GObject* base) {
	RygelAVTransport * self;
	RygelChangeLog* _tmp0_;
	RygelMediaPlayer* _tmp1_ = NULL;
	RygelMediaPlayer* _tmp2_;
	RygelMediaPlayer* _tmp3_;
#line 137 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	self = (RygelAVTransport*) base;
#line 138 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	_tmp0_ = rygel_change_log_new ((GUPnPService*) self, RYGEL_AV_TRANSPORT_LAST_CHANGE_NS);
#line 138 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	_g_object_unref0 (self->priv->changelog);
#line 138 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	self->priv->changelog = _tmp0_;
#line 139 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	_tmp1_ = rygel_av_transport_get_player (self);
#line 139 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	_g_object_unref0 (self->priv->player);
#line 139 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	self->priv->player = _tmp1_;
#line 141 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	g_signal_connect_object ((GUPnPService*) self, "query-variable::LastChange", (GCallback) _rygel_av_transport_query_last_change_cb_gupnp_service_query_variable, self, 0);
#line 143 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::SetAVTransportURI", (GCallback) _rygel_av_transport_set_av_transport_uri_cb_gupnp_service_action_invoked, self, 0);
#line 145 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::GetMediaInfo", (GCallback) _rygel_av_transport_get_media_info_cb_gupnp_service_action_invoked, self, 0);
#line 146 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::GetTransportInfo", (GCallback) _rygel_av_transport_get_transport_info_cb_gupnp_service_action_invoked, self, 0);
#line 147 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::GetPositionInfo", (GCallback) _rygel_av_transport_get_position_info_cb_gupnp_service_action_invoked, self, 0);
#line 148 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::GetDeviceCapabilities", (GCallback) _rygel_av_transport_get_device_capabilities_cb_gupnp_service_action_invoked, self, 0);
#line 150 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::GetTransportSettings", (GCallback) _rygel_av_transport_get_transport_settings_cb_gupnp_service_action_invoked, self, 0);
#line 152 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::Stop", (GCallback) _rygel_av_transport_stop_cb_gupnp_service_action_invoked, self, 0);
#line 153 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::Play", (GCallback) _rygel_av_transport_play_cb_gupnp_service_action_invoked, self, 0);
#line 154 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::Pause", (GCallback) _rygel_av_transport_pause_cb_gupnp_service_action_invoked, self, 0);
#line 155 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::Seek", (GCallback) _rygel_av_transport_seek_cb_gupnp_service_action_invoked, self, 0);
#line 156 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::Next", (GCallback) _rygel_av_transport_next_cb_gupnp_service_action_invoked, self, 0);
#line 157 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::Previous", (GCallback) _rygel_av_transport_previous_cb_gupnp_service_action_invoked, self, 0);
#line 159 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	_tmp2_ = self->priv->player;
#line 159 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	g_signal_connect_object ((GObject*) _tmp2_, "notify::playback-state", (GCallback) _rygel_av_transport_notify_state_cb_g_object_notify, self, 0);
#line 160 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	_tmp3_ = self->priv->player;
#line 160 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	g_signal_connect_object ((GObject*) _tmp3_, "notify::duration", (GCallback) _rygel_av_transport_notify_duration_cb_g_object_notify, self, 0);
#line 374 "rygel-av-transport.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 164 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	return self ? g_object_ref (self) : NULL;
#line 381 "rygel-av-transport.c"
}


static RygelMediaPlayer* rygel_av_transport_get_player (RygelAVTransport* self) {
	RygelMediaPlayer* result = NULL;
	GUPnPRootDevice* _tmp0_ = NULL;
	GUPnPRootDevice* _tmp1_;
	GUPnPRootDevice* _tmp2_;
	GUPnPResourceFactory* _tmp3_;
	GUPnPResourceFactory* _tmp4_;
	RygelMediaRendererPlugin* _tmp5_;
	RygelMediaRendererPlugin* _tmp6_;
	RygelMediaRendererPlugin* plugin;
	RygelMediaPlayer* _tmp7_ = NULL;
#line 163 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 164 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	g_object_get ((GUPnPService*) self, "root-device", &_tmp0_, NULL);
#line 164 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	_tmp1_ = _tmp0_;
#line 164 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	_tmp2_ = _tmp1_;
#line 164 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	_tmp3_ = gupnp_device_info_get_resource_factory ((GUPnPDeviceInfo*) _tmp2_);
#line 164 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	_tmp4_ = _tmp3_;
#line 164 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	_tmp5_ = _g_object_ref0 (RYGEL_IS_MEDIA_RENDERER_PLUGIN (_tmp4_) ? ((RygelMediaRendererPlugin*) _tmp4_) : NULL);
#line 164 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	_tmp6_ = _tmp5_;
#line 164 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	_g_object_unref0 (_tmp2_);
#line 164 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	plugin = _tmp6_;
#line 166 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	_tmp7_ = rygel_media_renderer_plugin_get_player (plugin);
#line 166 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	result = _tmp7_;
#line 166 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	_g_object_unref0 (plugin);
#line 166 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	return result;
#line 424 "rygel-av-transport.c"
}


static void rygel_av_transport_query_last_change_cb (RygelAVTransport* self, GUPnPService* service, const gchar* variable, GValue* value) {
	RygelChangeLog* _tmp0_;
	RygelChangeLog* log;
	RygelMediaPlayer* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	const gchar* _tmp9_;
	const gchar* _tmp10_;
	guint _tmp11_;
	guint _tmp12_;
	gchar* _tmp13_ = NULL;
	gchar* _tmp14_;
	guint _tmp15_;
	guint _tmp16_;
	gchar* _tmp17_ = NULL;
	gchar* _tmp18_;
	RygelMediaPlayer* _tmp19_;
	gchar* _tmp20_;
	gchar* _tmp21_;
	gchar* _tmp22_;
	RygelMediaPlayer* _tmp23_;
	gchar* _tmp24_;
	gchar* _tmp25_;
	gchar* _tmp26_;
	gchar* _tmp27_;
	gchar* _tmp28_;
	gchar* _tmp29_;
	gchar* _tmp30_;
	gchar* _tmp31_;
	gchar* _tmp32_;
	gchar* _tmp33_;
	gchar* _tmp34_;
	gchar* _tmp35_;
	gchar* _tmp36_ = NULL;
	gchar* _tmp37_;
#line 169 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	g_return_if_fail (self != NULL);
#line 169 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	g_return_if_fail (service != NULL);
#line 169 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	g_return_if_fail (variable != NULL);
#line 169 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	g_return_if_fail (value != NULL);
#line 173 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	_tmp0_ = rygel_change_log_new (NULL, RYGEL_AV_TRANSPORT_LAST_CHANGE_NS);
#line 173 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	log = _tmp0_;
#line 175 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	_tmp1_ = self->priv->player;
#line 175 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	_tmp2_ = rygel_media_player_get_playback_state (_tmp1_);
#line 175 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	_tmp3_ = _tmp2_;
#line 175 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	_tmp4_ = _tmp3_;
#line 175 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	rygel_change_log_log (log, "TransportState", _tmp4_);
#line 175 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	_g_free0 (_tmp4_);
#line 176 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	_tmp5_ = rygel_av_transport_get_status (self);
#line 176 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	_tmp6_ = _tmp5_;
#line 176 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	rygel_change_log_log (log, "TransportStatus", _tmp6_);
#line 177 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	rygel_change_log_log (log, "PlaybackStorageMedium", "NOT_IMPLEMENTED");
#line 178 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	rygel_change_log_log (log, "RecordStorageMedium", "NOT_IMPLEMENTED");
#line 179 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	rygel_change_log_log (log, "PossiblePlaybackStorageMedia", "NOT_IMPLEMENTED");
#line 180 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	rygel_change_log_log (log, "PossibleRecordStorageMedia", "NOT_IMPLEMENTED");
#line 181 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	_tmp7_ = rygel_av_transport_get_mode (self);
#line 181 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	_tmp8_ = _tmp7_;
#line 181 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	rygel_change_log_log (log, "CurrentPlayMode", _tmp8_);
#line 182 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	_tmp9_ = rygel_av_transport_get_speed (self);
#line 182 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	_tmp10_ = _tmp9_;
#line 182 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	rygel_change_log_log (log, "TransportPlaySpeed", _tmp10_);
#line 183 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	rygel_change_log_log (log, "RecordMediumWriteStatus", "NOT_IMPLEMENTED");
#line 184 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	rygel_change_log_log (log, "CurrentRecordQualityMode", "NOT_IMPLEMENTED");
#line 185 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	rygel_change_log_log (log, "PossibleRecordQualityMode", "NOT_IMPLEMENTED");
#line 186 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	_tmp11_ = rygel_av_transport_get_n_tracks (self);
#line 186 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	_tmp12_ = _tmp11_;
#line 186 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	_tmp13_ = g_strdup_printf ("%u", _tmp12_);
#line 186 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	_tmp14_ = _tmp13_;
#line 186 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	rygel_change_log_log (log, "NumberOfTracks", _tmp14_);
#line 186 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	_g_free0 (_tmp14_);
#line 187 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	_tmp15_ = rygel_av_transport_get_track (self);
#line 187 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	_tmp16_ = _tmp15_;
#line 187 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	_tmp17_ = g_strdup_printf ("%u", _tmp16_);
#line 187 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	_tmp18_ = _tmp17_;
#line 187 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	rygel_change_log_log (log, "CurrentTrack", _tmp18_);
#line 187 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	_g_free0 (_tmp18_);
#line 188 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	_tmp19_ = self->priv->player;
#line 188 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	_tmp20_ = rygel_media_player_get_duration_as_str (_tmp19_);
#line 188 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	_tmp21_ = _tmp20_;
#line 188 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	_tmp22_ = _tmp21_;
#line 188 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	rygel_change_log_log (log, "CurrentTrackDuration", _tmp22_);
#line 188 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	_g_free0 (_tmp22_);
#line 189 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	_tmp23_ = self->priv->player;
#line 189 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	_tmp24_ = rygel_media_player_get_duration_as_str (_tmp23_);
#line 189 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	_tmp25_ = _tmp24_;
#line 189 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	_tmp26_ = _tmp25_;
#line 189 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	rygel_change_log_log (log, "CurrentMediaDuration", _tmp26_);
#line 189 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	_g_free0 (_tmp26_);
#line 190 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	_tmp27_ = rygel_av_transport_get_metadata (self);
#line 190 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	_tmp28_ = _tmp27_;
#line 190 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	_tmp29_ = _tmp28_;
#line 190 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	rygel_change_log_log (log, "CurrentTrackMetadata", _tmp29_);
#line 190 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	_g_free0 (_tmp29_);
#line 191 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	_tmp30_ = rygel_av_transport_get_uri (self);
#line 191 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	_tmp31_ = _tmp30_;
#line 191 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	_tmp32_ = _tmp31_;
#line 191 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	rygel_change_log_log (log, "CurrentTrackURI", _tmp32_);
#line 191 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	_g_free0 (_tmp32_);
#line 192 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	_tmp33_ = rygel_av_transport_get_uri (self);
#line 192 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	_tmp34_ = _tmp33_;
#line 192 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	_tmp35_ = _tmp34_;
#line 192 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	rygel_change_log_log (log, "AVTransportURI", _tmp35_);
#line 192 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	_g_free0 (_tmp35_);
#line 193 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	rygel_change_log_log (log, "NextAVTransportURI", "NOT_IMPLEMENTED");
#line 195 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	g_value_init (value, G_TYPE_STRING);
#line 196 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	_tmp36_ = rygel_change_log_finish (log);
#line 196 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	_tmp37_ = _tmp36_;
#line 196 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	g_value_set_string (value, _tmp37_);
#line 196 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	_g_free0 (_tmp37_);
#line 169 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	_g_object_unref0 (log);
#line 616 "rygel-av-transport.c"
}


static gboolean rygel_av_transport_check_instance_id (RygelAVTransport* self, GUPnPServiceAction* action) {
	gboolean result = FALSE;
	guint instance_id = 0U;
	GUPnPServiceAction* _tmp0_;
	guint _tmp1_;
#line 200 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 200 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	g_return_val_if_fail (action != NULL, FALSE);
#line 203 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	_tmp0_ = action;
#line 203 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	gupnp_service_action_get (_tmp0_, "InstanceID", G_TYPE_UINT, &instance_id, NULL);
#line 204 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	_tmp1_ = instance_id;
#line 204 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	if (_tmp1_ != ((guint) 0)) {
#line 637 "rygel-av-transport.c"
		GUPnPServiceAction* _tmp2_;
		const gchar* _tmp3_ = NULL;
#line 205 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
		_tmp2_ = action;
#line 205 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
		_tmp3_ = _ ("Invalid InstanceID");
#line 205 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
		gupnp_service_action_return_error (_tmp2_, (guint) 718, _tmp3_);
#line 207 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
		result = FALSE;
#line 207 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
		return result;
#line 650 "rygel-av-transport.c"
	}
#line 210 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	result = TRUE;
#line 210 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	return result;
#line 656 "rygel-av-transport.c"
}


static void rygel_av_transport_set_av_transport_uri_cb (RygelAVTransport* self, GUPnPService* service, GUPnPServiceAction* action) {
	GUPnPServiceAction* _tmp0_;
	gboolean _tmp1_ = FALSE;
	gchar* _uri = NULL;
	gchar* _metadata = NULL;
	GUPnPServiceAction* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	GUPnPServiceAction* _tmp5_;
#line 213 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	g_return_if_fail (self != NULL);
#line 213 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	g_return_if_fail (service != NULL);
#line 213 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	g_return_if_fail (action != NULL);
#line 215 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	_tmp0_ = action;
#line 215 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	_tmp1_ = rygel_av_transport_check_instance_id (self, _tmp0_);
#line 215 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	if (!_tmp1_) {
#line 216 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
		return;
#line 683 "rygel-av-transport.c"
	}
#line 221 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	_tmp2_ = action;
#line 221 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	gupnp_service_action_get (_tmp2_, "CurrentURI", G_TYPE_STRING, &_uri, "CurrentURIMetaData", G_TYPE_STRING, &_metadata, NULL);
#line 228 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	_tmp3_ = _uri;
#line 228 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	rygel_av_transport_set_uri (self, _tmp3_);
#line 229 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	_tmp4_ = _metadata;
#line 229 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	rygel_av_transport_set_metadata (self, _tmp4_);
#line 231 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	_tmp5_ = action;
#line 231 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	gupnp_service_action_return (_tmp5_);
#line 213 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	_g_free0 (_metadata);
#line 213 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	_g_free0 (_uri);
#line 705 "rygel-av-transport.c"
}


static void rygel_av_transport_get_media_info_cb (RygelAVTransport* self, GUPnPService* service, GUPnPServiceAction* action) {
	GUPnPServiceAction* _tmp0_;
	gboolean _tmp1_ = FALSE;
	GUPnPServiceAction* _tmp2_;
	guint _tmp3_;
	guint _tmp4_;
	RygelMediaPlayer* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	GUPnPServiceAction* _tmp15_;
#line 234 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	g_return_if_fail (self != NULL);
#line 234 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	g_return_if_fail (service != NULL);
#line 234 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	g_return_if_fail (action != NULL);
#line 236 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	_tmp0_ = action;
#line 236 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	_tmp1_ = rygel_av_transport_check_instance_id (self, _tmp0_);
#line 236 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	if (!_tmp1_) {
#line 237 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
		return;
#line 740 "rygel-av-transport.c"
	}
#line 240 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	_tmp2_ = action;
#line 240 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	_tmp3_ = rygel_av_transport_get_n_tracks (self);
#line 240 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	_tmp4_ = _tmp3_;
#line 240 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	_tmp5_ = self->priv->player;
#line 240 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	_tmp6_ = rygel_media_player_get_duration_as_str (_tmp5_);
#line 240 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	_tmp7_ = _tmp6_;
#line 240 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	_tmp8_ = _tmp7_;
#line 240 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	_tmp9_ = rygel_av_transport_get_uri (self);
#line 240 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	_tmp10_ = _tmp9_;
#line 240 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	_tmp11_ = _tmp10_;
#line 240 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	_tmp12_ = rygel_av_transport_get_metadata (self);
#line 240 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	_tmp13_ = _tmp12_;
#line 240 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	_tmp14_ = _tmp13_;
#line 240 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	gupnp_service_action_set (_tmp2_, "NrTracks", G_TYPE_UINT, _tmp4_, "MediaDuration", G_TYPE_STRING, _tmp8_, "CurrentURI", G_TYPE_STRING, _tmp11_, "CurrentURIMetaData", G_TYPE_STRING, _tmp14_, "NextURI", G_TYPE_STRING, "NOT_IMPLEMENTED", "NextURIMetaData", G_TYPE_STRING, "NOT_IMPLEMENTED", "PlayMedium", G_TYPE_STRING, "NOT_IMPLEMENTED", "RecordMedium", G_TYPE_STRING, "NOT_IMPLEMENTED", "WriteStatus", G_TYPE_STRING, "NOT_IMPLEMENTED", NULL);
#line 240 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	_g_free0 (_tmp14_);
#line 240 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	_g_free0 (_tmp11_);
#line 240 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	_g_free0 (_tmp8_);
#line 268 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	_tmp15_ = action;
#line 268 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	gupnp_service_action_return (_tmp15_);
#line 780 "rygel-av-transport.c"
}


static void rygel_av_transport_get_transport_info_cb (RygelAVTransport* self, GUPnPService* service, GUPnPServiceAction* action) {
	GUPnPServiceAction* _tmp0_;
	gboolean _tmp1_ = FALSE;
	GUPnPServiceAction* _tmp2_;
	RygelMediaPlayer* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	const gchar* _tmp9_;
	const gchar* _tmp10_;
	GUPnPServiceAction* _tmp11_;
#line 271 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	g_return_if_fail (self != NULL);
#line 271 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	g_return_if_fail (service != NULL);
#line 271 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	g_return_if_fail (action != NULL);
#line 273 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	_tmp0_ = action;
#line 273 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	_tmp1_ = rygel_av_transport_check_instance_id (self, _tmp0_);
#line 273 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	if (!_tmp1_) {
#line 274 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
		return;
#line 811 "rygel-av-transport.c"
	}
#line 277 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	_tmp2_ = action;
#line 277 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	_tmp3_ = self->priv->player;
#line 277 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	_tmp4_ = rygel_media_player_get_playback_state (_tmp3_);
#line 277 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	_tmp5_ = _tmp4_;
#line 277 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	_tmp6_ = _tmp5_;
#line 277 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	_tmp7_ = rygel_av_transport_get_status (self);
#line 277 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	_tmp8_ = _tmp7_;
#line 277 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	_tmp9_ = rygel_av_transport_get_speed (self);
#line 277 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	_tmp10_ = _tmp9_;
#line 277 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	gupnp_service_action_set (_tmp2_, "CurrentTransportState", G_TYPE_STRING, _tmp6_, "CurrentTransportStatus", G_TYPE_STRING, _tmp8_, "CurrentSpeed", G_TYPE_STRING, _tmp10_, NULL);
#line 277 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	_g_free0 (_tmp6_);
#line 287 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	_tmp11_ = action;
#line 287 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	gupnp_service_action_return (_tmp11_);
#line 839 "rygel-av-transport.c"
}


static void rygel_av_transport_get_position_info_cb (RygelAVTransport* self, GUPnPService* service, GUPnPServiceAction* action) {
	GUPnPServiceAction* _tmp0_;
	gboolean _tmp1_ = FALSE;
	GUPnPServiceAction* _tmp2_;
	guint _tmp3_;
	guint _tmp4_;
	RygelMediaPlayer* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	RygelMediaPlayer* _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
	RygelMediaPlayer* _tmp19_;
	gchar* _tmp20_;
	gchar* _tmp21_;
	gchar* _tmp22_;
	gint _tmp23_;
	gint _tmp24_;
	GUPnPServiceAction* _tmp25_;
#line 290 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	g_return_if_fail (self != NULL);
#line 290 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	g_return_if_fail (service != NULL);
#line 290 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	g_return_if_fail (action != NULL);
#line 292 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	_tmp0_ = action;
#line 292 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	_tmp1_ = rygel_av_transport_check_instance_id (self, _tmp0_);
#line 292 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	if (!_tmp1_) {
#line 293 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
		return;
#line 884 "rygel-av-transport.c"
	}
#line 296 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	_tmp2_ = action;
#line 296 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	_tmp3_ = rygel_av_transport_get_track (self);
#line 296 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	_tmp4_ = _tmp3_;
#line 296 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	_tmp5_ = self->priv->player;
#line 296 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	_tmp6_ = rygel_media_player_get_duration_as_str (_tmp5_);
#line 296 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	_tmp7_ = _tmp6_;
#line 296 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	_tmp8_ = _tmp7_;
#line 296 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	_tmp9_ = rygel_av_transport_get_metadata (self);
#line 296 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	_tmp10_ = _tmp9_;
#line 296 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	_tmp11_ = _tmp10_;
#line 296 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	_tmp12_ = rygel_av_transport_get_uri (self);
#line 296 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	_tmp13_ = _tmp12_;
#line 296 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	_tmp14_ = _tmp13_;
#line 296 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	_tmp15_ = self->priv->player;
#line 296 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	_tmp16_ = rygel_media_player_get_position_as_str (_tmp15_);
#line 296 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	_tmp17_ = _tmp16_;
#line 296 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	_tmp18_ = _tmp17_;
#line 296 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	_tmp19_ = self->priv->player;
#line 296 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	_tmp20_ = rygel_media_player_get_position_as_str (_tmp19_);
#line 296 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	_tmp21_ = _tmp20_;
#line 296 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	_tmp22_ = _tmp21_;
#line 296 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	_tmp23_ = G_MAXINT;
#line 296 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	_tmp24_ = G_MAXINT;
#line 296 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	gupnp_service_action_set (_tmp2_, "Track", G_TYPE_UINT, _tmp4_, "TrackDuration", G_TYPE_STRING, _tmp8_, "TrackMetaData", G_TYPE_STRING, _tmp11_, "TrackURI", G_TYPE_STRING, _tmp14_, "RelTime", G_TYPE_STRING, _tmp18_, "AbsTime", G_TYPE_STRING, _tmp22_, "RelCount", G_TYPE_INT, _tmp23_, "AbsCount", G_TYPE_INT, _tmp24_, NULL);
#line 296 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	_g_free0 (_tmp22_);
#line 296 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	_g_free0 (_tmp18_);
#line 296 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	_g_free0 (_tmp14_);
#line 296 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	_g_free0 (_tmp11_);
#line 296 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	_g_free0 (_tmp8_);
#line 321 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	_tmp25_ = action;
#line 321 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	gupnp_service_action_return (_tmp25_);
#line 948 "rygel-av-transport.c"
}


static void rygel_av_transport_get_device_capabilities_cb (RygelAVTransport* self, GUPnPService* service, GUPnPServiceAction* action) {
	GUPnPServiceAction* _tmp0_;
	gboolean _tmp1_ = FALSE;
	GUPnPServiceAction* _tmp2_;
	GUPnPServiceAction* _tmp3_;
#line 324 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	g_return_if_fail (self != NULL);
#line 324 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	g_return_if_fail (service != NULL);
#line 324 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	g_return_if_fail (action != NULL);
#line 326 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	_tmp0_ = action;
#line 326 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	_tmp1_ = rygel_av_transport_check_instance_id (self, _tmp0_);
#line 326 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	if (!_tmp1_) {
#line 327 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
		return;
#line 971 "rygel-av-transport.c"
	}
#line 330 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	_tmp2_ = action;
#line 330 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	gupnp_service_action_set (_tmp2_, "PlayMedia", G_TYPE_STRING, "NOT_IMPLEMENTED", "RecMedia", G_TYPE_STRING, "NOT_IMPLEMENTED", "RecQualityModes", G_TYPE_STRING, "NOT_IMPLEMENTED", NULL);
#line 340 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	_tmp3_ = action;
#line 340 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	gupnp_service_action_return (_tmp3_);
#line 981 "rygel-av-transport.c"
}


static void rygel_av_transport_get_transport_settings_cb (RygelAVTransport* self, GUPnPService* service, GUPnPServiceAction* action) {
	GUPnPServiceAction* _tmp0_;
	gboolean _tmp1_ = FALSE;
	GUPnPServiceAction* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	GUPnPServiceAction* _tmp5_;
#line 343 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	g_return_if_fail (self != NULL);
#line 343 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	g_return_if_fail (service != NULL);
#line 343 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	g_return_if_fail (action != NULL);
#line 345 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	_tmp0_ = action;
#line 345 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	_tmp1_ = rygel_av_transport_check_instance_id (self, _tmp0_);
#line 345 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	if (!_tmp1_) {
#line 346 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
		return;
#line 1006 "rygel-av-transport.c"
	}
#line 349 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	_tmp2_ = action;
#line 349 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	_tmp3_ = rygel_av_transport_get_mode (self);
#line 349 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	_tmp4_ = _tmp3_;
#line 349 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	gupnp_service_action_set (_tmp2_, "PlayMode", G_TYPE_STRING, _tmp4_, "RecQualityMode", G_TYPE_STRING, "NOT_IMPLEMENTED", NULL);
#line 356 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	_tmp5_ = action;
#line 356 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	gupnp_service_action_return (_tmp5_);
#line 1020 "rygel-av-transport.c"
}


static void rygel_av_transport_stop_cb (RygelAVTransport* self, GUPnPService* service, GUPnPServiceAction* action) {
	GUPnPServiceAction* _tmp0_;
	gboolean _tmp1_ = FALSE;
	RygelMediaPlayer* _tmp2_;
	GUPnPServiceAction* _tmp3_;
#line 359 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	g_return_if_fail (self != NULL);
#line 359 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	g_return_if_fail (service != NULL);
#line 359 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	g_return_if_fail (action != NULL);
#line 360 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	_tmp0_ = action;
#line 360 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	_tmp1_ = rygel_av_transport_check_instance_id (self, _tmp0_);
#line 360 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	if (!_tmp1_) {
#line 361 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
		return;
#line 1043 "rygel-av-transport.c"
	}
#line 364 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	_tmp2_ = self->priv->player;
#line 364 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	rygel_media_player_set_playback_state (_tmp2_, "STOPPED");
#line 366 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	_tmp3_ = action;
#line 366 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	gupnp_service_action_return (_tmp3_);
#line 1053 "rygel-av-transport.c"
}


static void rygel_av_transport_play_cb (RygelAVTransport* self, GUPnPService* service, GUPnPServiceAction* action) {
	GUPnPServiceAction* _tmp0_;
	gboolean _tmp1_ = FALSE;
	gchar* speed = NULL;
	GUPnPServiceAction* _tmp2_;
	const gchar* _tmp3_;
	RygelMediaPlayer* _tmp6_;
	GUPnPServiceAction* _tmp7_;
#line 369 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	g_return_if_fail (self != NULL);
#line 369 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	g_return_if_fail (service != NULL);
#line 369 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	g_return_if_fail (action != NULL);
#line 370 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	_tmp0_ = action;
#line 370 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	_tmp1_ = rygel_av_transport_check_instance_id (self, _tmp0_);
#line 370 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	if (!_tmp1_) {
#line 371 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
		return;
#line 1079 "rygel-av-transport.c"
	}
#line 376 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	_tmp2_ = action;
#line 376 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	gupnp_service_action_get (_tmp2_, "Speed", G_TYPE_STRING, &speed, NULL);
#line 377 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	_tmp3_ = speed;
#line 377 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	if (g_strcmp0 (_tmp3_, "1") != 0) {
#line 1089 "rygel-av-transport.c"
		GUPnPServiceAction* _tmp4_;
		const gchar* _tmp5_ = NULL;
#line 378 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
		_tmp4_ = action;
#line 378 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
		_tmp5_ = _ ("Play speed not supported");
#line 378 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
		gupnp_service_action_return_error (_tmp4_, (guint) 717, _tmp5_);
#line 380 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
		_g_free0 (speed);
#line 380 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
		return;
#line 1102 "rygel-av-transport.c"
	}
#line 383 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	_tmp6_ = self->priv->player;
#line 383 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	rygel_media_player_set_playback_state (_tmp6_, "PLAYING");
#line 385 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	_tmp7_ = action;
#line 385 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	gupnp_service_action_return (_tmp7_);
#line 369 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	_g_free0 (speed);
#line 1114 "rygel-av-transport.c"
}


static void rygel_av_transport_pause_cb (RygelAVTransport* self, GUPnPService* service, GUPnPServiceAction* action) {
	GUPnPServiceAction* _tmp0_;
	gboolean _tmp1_ = FALSE;
	RygelMediaPlayer* _tmp2_;
	GUPnPServiceAction* _tmp3_;
#line 388 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	g_return_if_fail (self != NULL);
#line 388 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	g_return_if_fail (service != NULL);
#line 388 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	g_return_if_fail (action != NULL);
#line 389 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	_tmp0_ = action;
#line 389 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	_tmp1_ = rygel_av_transport_check_instance_id (self, _tmp0_);
#line 389 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	if (!_tmp1_) {
#line 390 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
		return;
#line 1137 "rygel-av-transport.c"
	}
#line 393 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	_tmp2_ = self->priv->player;
#line 393 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	rygel_media_player_set_playback_state (_tmp2_, "PAUSED_PLAYBACK");
#line 395 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	_tmp3_ = action;
#line 395 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	gupnp_service_action_return (_tmp3_);
#line 1147 "rygel-av-transport.c"
}


static void rygel_av_transport_seek_cb (RygelAVTransport* self, GUPnPService* service, GUPnPServiceAction* action) {
	GUPnPServiceAction* _tmp0_;
	gboolean _tmp1_ = FALSE;
	gchar* unit = NULL;
	gchar* target = NULL;
	GUPnPServiceAction* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	GQuark _tmp6_ = 0U;
#line 411 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	static GQuark _tmp5_label0 = 0;
#line 411 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	static GQuark _tmp5_label1 = 0;
#line 398 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	g_return_if_fail (self != NULL);
#line 398 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	g_return_if_fail (service != NULL);
#line 398 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	g_return_if_fail (action != NULL);
#line 399 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	_tmp0_ = action;
#line 399 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	_tmp1_ = rygel_av_transport_check_instance_id (self, _tmp0_);
#line 399 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	if (!_tmp1_) {
#line 400 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
		return;
#line 1178 "rygel-av-transport.c"
	}
#line 405 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	_tmp2_ = action;
#line 405 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	gupnp_service_action_get (_tmp2_, "Unit", G_TYPE_STRING, &unit, "Target", G_TYPE_STRING, &target, NULL);
#line 411 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	_tmp3_ = unit;
#line 411 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	_tmp4_ = _tmp3_;
#line 411 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	_tmp6_ = (NULL == _tmp4_) ? 0 : g_quark_from_string (_tmp4_);
#line 411 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	if ((_tmp6_ == ((0 != _tmp5_label0) ? _tmp5_label0 : (_tmp5_label0 = g_quark_from_static_string ("ABS_TIME")))) || (_tmp6_ == ((0 != _tmp5_label1) ? _tmp5_label1 : (_tmp5_label1 = g_quark_from_static_string ("REL_TIME"))))) {
#line 411 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
		switch (0) {
#line 1194 "rygel-av-transport.c"
			default:
			{
				const gchar* _tmp7_;
				RygelMediaPlayer* _tmp8_;
				const gchar* _tmp9_;
				GstClockTime _tmp10_ = 0ULL;
				gboolean _tmp11_ = FALSE;
				GUPnPServiceAction* _tmp14_;
#line 414 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
				_tmp7_ = target;
#line 414 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
				g_debug ("rygel-av-transport.vala:414: Seeking to %s.", _tmp7_);
#line 416 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
				_tmp8_ = self->priv->player;
#line 416 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
				_tmp9_ = target;
#line 416 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
				_tmp10_ = rygel_gst_utils_time_from_string (_tmp9_);
#line 416 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
				_tmp11_ = rygel_media_player_seek (_tmp8_, _tmp10_);
#line 416 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
				if (!_tmp11_) {
#line 1217 "rygel-av-transport.c"
					GUPnPServiceAction* _tmp12_;
					const gchar* _tmp13_ = NULL;
#line 417 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
					_tmp12_ = action;
#line 417 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
					_tmp13_ = _ ("Seek failed");
#line 417 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
					gupnp_service_action_return_error (_tmp12_, (guint) 710, _tmp13_);
#line 419 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
					_g_free0 (target);
#line 419 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
					_g_free0 (unit);
#line 419 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
					return;
#line 1232 "rygel-av-transport.c"
				}
#line 422 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
				_tmp14_ = action;
#line 422 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
				gupnp_service_action_return (_tmp14_);
#line 424 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
				_g_free0 (target);
#line 424 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
				_g_free0 (unit);
#line 424 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
				return;
#line 1244 "rygel-av-transport.c"
			}
		}
	} else {
#line 411 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
		switch (0) {
#line 1250 "rygel-av-transport.c"
			default:
			{
				GUPnPServiceAction* _tmp15_;
				const gchar* _tmp16_ = NULL;
#line 426 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
				_tmp15_ = action;
#line 426 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
				_tmp16_ = _ ("Seek mode not supported");
#line 426 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
				gupnp_service_action_return_error (_tmp15_, (guint) 710, _tmp16_);
#line 428 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
				_g_free0 (target);
#line 428 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
				_g_free0 (unit);
#line 428 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
				return;
#line 1267 "rygel-av-transport.c"
			}
		}
	}
#line 398 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	_g_free0 (target);
#line 398 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	_g_free0 (unit);
#line 1275 "rygel-av-transport.c"
}


static void rygel_av_transport_next_cb (RygelAVTransport* self, GUPnPService* service, GUPnPServiceAction* action) {
	GUPnPServiceAction* _tmp0_;
	const gchar* _tmp1_ = NULL;
#line 432 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	g_return_if_fail (self != NULL);
#line 432 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	g_return_if_fail (service != NULL);
#line 432 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	g_return_if_fail (action != NULL);
#line 433 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	_tmp0_ = action;
#line 433 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	_tmp1_ = _ ("Transition not available");
#line 433 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	gupnp_service_action_return_error (_tmp0_, (guint) 701, _tmp1_);
#line 1294 "rygel-av-transport.c"
}


static void rygel_av_transport_previous_cb (RygelAVTransport* self, GUPnPService* service, GUPnPServiceAction* action) {
	GUPnPServiceAction* _tmp0_;
	const gchar* _tmp1_ = NULL;
#line 436 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	g_return_if_fail (self != NULL);
#line 436 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	g_return_if_fail (service != NULL);
#line 436 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	g_return_if_fail (action != NULL);
#line 437 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	_tmp0_ = action;
#line 437 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	_tmp1_ = _ ("Transition not available");
#line 437 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	gupnp_service_action_return_error (_tmp0_, (guint) 701, _tmp1_);
#line 1313 "rygel-av-transport.c"
}


static void rygel_av_transport_notify_state_cb (RygelAVTransport* self, GObject* player, GParamSpec* p) {
	RygelChangeLog* _tmp0_;
	RygelMediaPlayer* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
#line 440 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	g_return_if_fail (self != NULL);
#line 440 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	g_return_if_fail (player != NULL);
#line 440 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	g_return_if_fail (p != NULL);
#line 441 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	_tmp0_ = self->priv->changelog;
#line 441 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	_tmp1_ = self->priv->player;
#line 441 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	_tmp2_ = rygel_media_player_get_playback_state (_tmp1_);
#line 441 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	_tmp3_ = _tmp2_;
#line 441 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	_tmp4_ = _tmp3_;
#line 441 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	rygel_change_log_log (_tmp0_, "TransportState", _tmp4_);
#line 441 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	_g_free0 (_tmp4_);
#line 1343 "rygel-av-transport.c"
}


static void rygel_av_transport_notify_duration_cb (RygelAVTransport* self, GObject* player, GParamSpec* p) {
	RygelChangeLog* _tmp0_;
	RygelMediaPlayer* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	RygelChangeLog* _tmp5_;
	RygelMediaPlayer* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
#line 444 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	g_return_if_fail (self != NULL);
#line 444 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	g_return_if_fail (player != NULL);
#line 444 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	g_return_if_fail (p != NULL);
#line 445 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	_tmp0_ = self->priv->changelog;
#line 445 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	_tmp1_ = self->priv->player;
#line 445 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	_tmp2_ = rygel_media_player_get_duration_as_str (_tmp1_);
#line 445 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	_tmp3_ = _tmp2_;
#line 445 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	_tmp4_ = _tmp3_;
#line 445 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	rygel_change_log_log (_tmp0_, "CurrentTrackDuration", _tmp4_);
#line 445 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	_g_free0 (_tmp4_);
#line 447 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	_tmp5_ = self->priv->changelog;
#line 447 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	_tmp6_ = self->priv->player;
#line 447 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	_tmp7_ = rygel_media_player_get_duration_as_str (_tmp6_);
#line 447 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	_tmp8_ = _tmp7_;
#line 447 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	_tmp9_ = _tmp8_;
#line 447 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	rygel_change_log_log (_tmp5_, "CurrentMediaDuration", _tmp9_);
#line 447 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	_g_free0 (_tmp9_);
#line 1392 "rygel-av-transport.c"
}


RygelAVTransport* rygel_av_transport_construct (GType object_type) {
	RygelAVTransport * self = NULL;
#line 26 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	self = (RygelAVTransport*) g_object_new (object_type, NULL);
#line 26 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	return self;
#line 1402 "rygel-av-transport.c"
}


RygelAVTransport* rygel_av_transport_new (void) {
#line 26 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	return rygel_av_transport_construct (RYGEL_TYPE_AV_TRANSPORT);
#line 1409 "rygel-av-transport.c"
}


guint rygel_av_transport_get_n_tracks (RygelAVTransport* self) {
	guint result;
	guint _tmp0_;
#line 37 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	g_return_val_if_fail (self != NULL, 0U);
#line 38 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	_tmp0_ = self->priv->_n_tracks;
#line 38 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	result = _tmp0_;
#line 38 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	return result;
#line 1424 "rygel-av-transport.c"
}


void rygel_av_transport_set_n_tracks (RygelAVTransport* self, guint value) {
	guint _tmp0_;
	RygelChangeLog* _tmp1_;
	guint _tmp2_;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_;
#line 41 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	g_return_if_fail (self != NULL);
#line 42 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	_tmp0_ = value;
#line 42 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	self->priv->_n_tracks = _tmp0_;
#line 44 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	_tmp1_ = self->priv->changelog;
#line 44 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	_tmp2_ = self->priv->_n_tracks;
#line 44 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	_tmp3_ = g_strdup_printf ("%u", _tmp2_);
#line 44 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	_tmp4_ = _tmp3_;
#line 44 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	rygel_change_log_log (_tmp1_, "NumberOfTracks", _tmp4_);
#line 44 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	_g_free0 (_tmp4_);
#line 41 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	g_object_notify ((GObject *) self, "n-tracks");
#line 1454 "rygel-av-transport.c"
}


guint rygel_av_transport_get_track (RygelAVTransport* self) {
	guint result;
	guint _tmp0_;
#line 50 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	g_return_val_if_fail (self != NULL, 0U);
#line 51 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	_tmp0_ = self->priv->_track;
#line 51 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	result = _tmp0_;
#line 51 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	return result;
#line 1469 "rygel-av-transport.c"
}


void rygel_av_transport_set_track (RygelAVTransport* self, guint value) {
	guint _tmp0_;
	RygelChangeLog* _tmp1_;
	guint _tmp2_;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_;
#line 54 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	g_return_if_fail (self != NULL);
#line 55 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	_tmp0_ = value;
#line 55 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	self->priv->_track = _tmp0_;
#line 57 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	_tmp1_ = self->priv->changelog;
#line 57 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	_tmp2_ = self->priv->_track;
#line 57 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	_tmp3_ = g_strdup_printf ("%u", _tmp2_);
#line 57 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	_tmp4_ = _tmp3_;
#line 57 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	rygel_change_log_log (_tmp1_, "CurrentTrack", _tmp4_);
#line 57 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	_g_free0 (_tmp4_);
#line 54 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	g_object_notify ((GObject *) self, "track");
#line 1499 "rygel-av-transport.c"
}


gchar* rygel_av_transport_get_metadata (RygelAVTransport* self) {
	gchar* result;
	const gchar* _tmp0_;
#line 63 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 64 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	_tmp0_ = self->priv->_metadata;
#line 64 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	if (_tmp0_ != NULL) {
#line 1512 "rygel-av-transport.c"
		const gchar* _tmp1_;
		gchar* _tmp2_ = NULL;
#line 65 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
		_tmp1_ = self->priv->_metadata;
#line 65 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
		_tmp2_ = g_markup_escape_text (_tmp1_, (gssize) (-1));
#line 65 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
		result = _tmp2_;
#line 65 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
		return result;
#line 1523 "rygel-av-transport.c"
	} else {
		gchar* _tmp3_;
#line 67 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
		_tmp3_ = g_strdup ("");
#line 67 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
		result = _tmp3_;
#line 67 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
		return result;
#line 1532 "rygel-av-transport.c"
	}
}


void rygel_av_transport_set_metadata (RygelAVTransport* self, const gchar* value) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
	RygelChangeLog* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
#line 71 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	g_return_if_fail (self != NULL);
#line 72 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	_tmp0_ = value;
#line 72 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 72 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	_g_free0 (self->priv->_metadata);
#line 72 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	self->priv->_metadata = _tmp1_;
#line 74 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	_tmp2_ = self->priv->changelog;
#line 74 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	_tmp3_ = rygel_av_transport_get_metadata (self);
#line 74 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	_tmp4_ = _tmp3_;
#line 74 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	_tmp5_ = _tmp4_;
#line 74 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	rygel_change_log_log (_tmp2_, "CurrentTrackMetadata", _tmp5_);
#line 74 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	_g_free0 (_tmp5_);
#line 71 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	g_object_notify ((GObject *) self, "metadata");
#line 1568 "rygel-av-transport.c"
}


gchar* rygel_av_transport_get_uri (RygelAVTransport* self) {
	gchar* result;
	RygelMediaPlayer* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gboolean _tmp4_;
#line 79 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 80 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	_tmp0_ = self->priv->player;
#line 80 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	_tmp1_ = rygel_media_player_get_uri (_tmp0_);
#line 80 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	_tmp2_ = _tmp1_;
#line 80 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	_tmp3_ = _tmp2_;
#line 80 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	_tmp4_ = _tmp3_ != NULL;
#line 80 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	_g_free0 (_tmp3_);
#line 80 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	if (_tmp4_) {
#line 1595 "rygel-av-transport.c"
		RygelMediaPlayer* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_ = NULL;
		gchar* _tmp10_;
#line 81 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
		_tmp5_ = self->priv->player;
#line 81 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
		_tmp6_ = rygel_media_player_get_uri (_tmp5_);
#line 81 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
		_tmp7_ = _tmp6_;
#line 81 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
		_tmp8_ = _tmp7_;
#line 81 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
		_tmp9_ = g_markup_escape_text (_tmp8_, (gssize) (-1));
#line 81 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
		_tmp10_ = _tmp9_;
#line 81 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
		_g_free0 (_tmp8_);
#line 81 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
		result = _tmp10_;
#line 81 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
		return result;
#line 1620 "rygel-av-transport.c"
	} else {
		gchar* _tmp11_;
#line 83 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
		_tmp11_ = g_strdup ("");
#line 83 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
		result = _tmp11_;
#line 83 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
		return result;
#line 1629 "rygel-av-transport.c"
	}
}


void rygel_av_transport_set_uri (RygelAVTransport* self, const gchar* value) {
	RygelMediaPlayer* _tmp0_;
	const gchar* _tmp1_;
	RygelChangeLog* _tmp2_;
	const gchar* _tmp3_;
	RygelChangeLog* _tmp4_;
	const gchar* _tmp5_;
#line 87 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	g_return_if_fail (self != NULL);
#line 88 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	_tmp0_ = self->priv->player;
#line 88 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	_tmp1_ = value;
#line 88 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	rygel_media_player_set_uri (_tmp0_, _tmp1_);
#line 90 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	_tmp2_ = self->priv->changelog;
#line 90 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	_tmp3_ = value;
#line 90 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	rygel_change_log_log (_tmp2_, "CurrentTrackURI", _tmp3_);
#line 91 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	_tmp4_ = self->priv->changelog;
#line 91 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	_tmp5_ = value;
#line 91 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	rygel_change_log_log (_tmp4_, "AVTransportURI", _tmp5_);
#line 87 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	g_object_notify ((GObject *) self, "uri");
#line 1663 "rygel-av-transport.c"
}


const gchar* rygel_av_transport_get_status (RygelAVTransport* self) {
	const gchar* result;
	const gchar* _tmp0_;
#line 97 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 98 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	_tmp0_ = self->priv->_status;
#line 98 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	result = _tmp0_;
#line 98 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	return result;
#line 1678 "rygel-av-transport.c"
}


void rygel_av_transport_set_status (RygelAVTransport* self, const gchar* value) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
	RygelChangeLog* _tmp2_;
	const gchar* _tmp3_;
#line 101 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	g_return_if_fail (self != NULL);
#line 102 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	_tmp0_ = value;
#line 102 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 102 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	_g_free0 (self->priv->_status);
#line 102 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	self->priv->_status = _tmp1_;
#line 104 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	_tmp2_ = self->priv->changelog;
#line 104 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	_tmp3_ = self->priv->_status;
#line 104 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	rygel_change_log_log (_tmp2_, "TransportStatus", _tmp3_);
#line 101 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	g_object_notify ((GObject *) self, "status");
#line 1705 "rygel-av-transport.c"
}


const gchar* rygel_av_transport_get_speed (RygelAVTransport* self) {
	const gchar* result;
	const gchar* _tmp0_;
#line 110 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 111 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	_tmp0_ = self->priv->_speed;
#line 111 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	result = _tmp0_;
#line 111 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	return result;
#line 1720 "rygel-av-transport.c"
}


void rygel_av_transport_set_speed (RygelAVTransport* self, const gchar* value) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
	RygelChangeLog* _tmp2_;
	const gchar* _tmp3_;
#line 114 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	g_return_if_fail (self != NULL);
#line 115 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	_tmp0_ = value;
#line 115 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 115 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	_g_free0 (self->priv->_speed);
#line 115 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	self->priv->_speed = _tmp1_;
#line 117 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	_tmp2_ = self->priv->changelog;
#line 117 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	_tmp3_ = self->priv->_speed;
#line 117 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	rygel_change_log_log (_tmp2_, "TransportPlaySpeed", _tmp3_);
#line 114 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	g_object_notify ((GObject *) self, "speed");
#line 1747 "rygel-av-transport.c"
}


const gchar* rygel_av_transport_get_mode (RygelAVTransport* self) {
	const gchar* result;
	const gchar* _tmp0_;
#line 123 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 124 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	_tmp0_ = self->priv->_mode;
#line 124 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	result = _tmp0_;
#line 124 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	return result;
#line 1762 "rygel-av-transport.c"
}


void rygel_av_transport_set_mode (RygelAVTransport* self, const gchar* value) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
	RygelChangeLog* _tmp2_;
	const gchar* _tmp3_;
#line 127 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	g_return_if_fail (self != NULL);
#line 128 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	_tmp0_ = value;
#line 128 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 128 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	_g_free0 (self->priv->_mode);
#line 128 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	self->priv->_mode = _tmp1_;
#line 130 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	_tmp2_ = self->priv->changelog;
#line 130 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	_tmp3_ = self->priv->_mode;
#line 130 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	rygel_change_log_log (_tmp2_, "CurrentPlayMode", _tmp3_);
#line 127 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	g_object_notify ((GObject *) self, "mode");
#line 1789 "rygel-av-transport.c"
}


static void rygel_av_transport_class_init (RygelAVTransportClass * klass) {
#line 26 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	rygel_av_transport_parent_class = g_type_class_peek_parent (klass);
#line 26 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	g_type_class_add_private (klass, sizeof (RygelAVTransportPrivate));
#line 26 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	G_OBJECT_CLASS (klass)->constructed = rygel_av_transport_real_constructed;
#line 26 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_rygel_av_transport_get_property;
#line 26 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_rygel_av_transport_set_property;
#line 26 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	G_OBJECT_CLASS (klass)->finalize = rygel_av_transport_finalize;
#line 26 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_AV_TRANSPORT_N_TRACKS, g_param_spec_uint ("n-tracks", "n-tracks", "n-tracks", 0, G_MAXUINT, 0U, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 26 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_AV_TRANSPORT_TRACK, g_param_spec_uint ("track", "track", "track", 0, G_MAXUINT, 0U, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 26 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_AV_TRANSPORT_METADATA, g_param_spec_string ("metadata", "metadata", "metadata", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 26 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_AV_TRANSPORT_URI, g_param_spec_string ("uri", "uri", "uri", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 26 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_AV_TRANSPORT_STATUS, g_param_spec_string ("status", "status", "status", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 26 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_AV_TRANSPORT_SPEED, g_param_spec_string ("speed", "speed", "speed", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 26 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_AV_TRANSPORT_MODE, g_param_spec_string ("mode", "mode", "mode", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 1820 "rygel-av-transport.c"
}


static void rygel_av_transport_instance_init (RygelAVTransport * self) {
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
#line 26 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	self->priv = RYGEL_AV_TRANSPORT_GET_PRIVATE (self);
#line 35 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	self->priv->_n_tracks = (guint) 0;
#line 48 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	self->priv->_track = (guint) 0;
#line 61 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	_tmp0_ = g_strdup ("");
#line 61 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	self->priv->_metadata = _tmp0_;
#line 95 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	_tmp1_ = g_strdup ("OK");
#line 95 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	self->priv->_status = _tmp1_;
#line 108 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	_tmp2_ = g_strdup ("1");
#line 108 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	self->priv->_speed = _tmp2_;
#line 121 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	_tmp3_ = g_strdup ("NORMAL");
#line 121 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	self->priv->_mode = _tmp3_;
#line 1851 "rygel-av-transport.c"
}


static void rygel_av_transport_finalize (GObject* obj) {
	RygelAVTransport * self;
#line 26 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	self = RYGEL_AV_TRANSPORT (obj);
#line 61 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	_g_free0 (self->priv->_metadata);
#line 95 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	_g_free0 (self->priv->_status);
#line 108 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	_g_free0 (self->priv->_speed);
#line 121 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	_g_free0 (self->priv->_mode);
#line 134 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	_g_object_unref0 (self->priv->changelog);
#line 135 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	_g_object_unref0 (self->priv->player);
#line 26 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	G_OBJECT_CLASS (rygel_av_transport_parent_class)->finalize (obj);
#line 1873 "rygel-av-transport.c"
}


GType rygel_av_transport_get_type (void) {
	static volatile gsize rygel_av_transport_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_av_transport_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelAVTransportClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_av_transport_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelAVTransport), 0, (GInstanceInitFunc) rygel_av_transport_instance_init, NULL };
		GType rygel_av_transport_type_id;
		rygel_av_transport_type_id = g_type_register_static (GUPNP_TYPE_SERVICE, "RygelAVTransport", &g_define_type_info, 0);
		g_once_init_leave (&rygel_av_transport_type_id__volatile, rygel_av_transport_type_id);
	}
	return rygel_av_transport_type_id__volatile;
}


static void _vala_rygel_av_transport_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	RygelAVTransport * self;
	self = RYGEL_AV_TRANSPORT (object);
#line 26 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	switch (property_id) {
#line 26 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
		case RYGEL_AV_TRANSPORT_N_TRACKS:
#line 26 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
		g_value_set_uint (value, rygel_av_transport_get_n_tracks (self));
#line 26 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
		break;
#line 26 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
		case RYGEL_AV_TRANSPORT_TRACK:
#line 26 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
		g_value_set_uint (value, rygel_av_transport_get_track (self));
#line 26 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
		break;
#line 26 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
		case RYGEL_AV_TRANSPORT_METADATA:
#line 26 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
		g_value_take_string (value, rygel_av_transport_get_metadata (self));
#line 26 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
		break;
#line 26 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
		case RYGEL_AV_TRANSPORT_URI:
#line 26 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
		g_value_take_string (value, rygel_av_transport_get_uri (self));
#line 26 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
		break;
#line 26 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
		case RYGEL_AV_TRANSPORT_STATUS:
#line 26 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
		g_value_set_string (value, rygel_av_transport_get_status (self));
#line 26 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
		break;
#line 26 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
		case RYGEL_AV_TRANSPORT_SPEED:
#line 26 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
		g_value_set_string (value, rygel_av_transport_get_speed (self));
#line 26 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
		break;
#line 26 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
		case RYGEL_AV_TRANSPORT_MODE:
#line 26 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
		g_value_set_string (value, rygel_av_transport_get_mode (self));
#line 26 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
		break;
#line 1936 "rygel-av-transport.c"
		default:
#line 26 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 26 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
		break;
#line 1942 "rygel-av-transport.c"
	}
}


static void _vala_rygel_av_transport_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	RygelAVTransport * self;
	self = RYGEL_AV_TRANSPORT (object);
#line 26 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
	switch (property_id) {
#line 26 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
		case RYGEL_AV_TRANSPORT_N_TRACKS:
#line 26 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
		rygel_av_transport_set_n_tracks (self, g_value_get_uint (value));
#line 26 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
		break;
#line 26 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
		case RYGEL_AV_TRANSPORT_TRACK:
#line 26 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
		rygel_av_transport_set_track (self, g_value_get_uint (value));
#line 26 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
		break;
#line 26 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
		case RYGEL_AV_TRANSPORT_METADATA:
#line 26 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
		rygel_av_transport_set_metadata (self, g_value_get_string (value));
#line 26 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
		break;
#line 26 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
		case RYGEL_AV_TRANSPORT_URI:
#line 26 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
		rygel_av_transport_set_uri (self, g_value_get_string (value));
#line 26 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
		break;
#line 26 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
		case RYGEL_AV_TRANSPORT_STATUS:
#line 26 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
		rygel_av_transport_set_status (self, g_value_get_string (value));
#line 26 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
		break;
#line 26 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
		case RYGEL_AV_TRANSPORT_SPEED:
#line 26 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
		rygel_av_transport_set_speed (self, g_value_get_string (value));
#line 26 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
		break;
#line 26 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
		case RYGEL_AV_TRANSPORT_MODE:
#line 26 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
		rygel_av_transport_set_mode (self, g_value_get_string (value));
#line 26 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
		break;
#line 1994 "rygel-av-transport.c"
		default:
#line 26 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 26 "/home/jens/Source/rygel/src/rygel/rygel-av-transport.vala"
		break;
#line 2000 "rygel-av-transport.c"
	}
}



