/* rygel-media-export-root-container.c generated by valac 0.13.4, the Vala compiler
 * generated from rygel-media-export-root-container.vala, do not modify */

/*
 * Copyright (C) 2009,2010 Jens Georg <mail@jensge.org>.
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <rygel.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>
#include <gee.h>
#include <libgupnp-av/gupnp-av.h>


#define RYGEL_MEDIA_EXPORT_TYPE_FOLDER_DEFINITION (rygel_media_export_folder_definition_get_type ())
typedef struct _RygelMediaExportFolderDefinition RygelMediaExportFolderDefinition;
#define _g_free0(var) (var = (g_free (var), NULL))

#define RYGEL_MEDIA_EXPORT_TYPE_DB_CONTAINER (rygel_media_export_db_container_get_type ())
#define RYGEL_MEDIA_EXPORT_DB_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_DB_CONTAINER, RygelMediaExportDBContainer))
#define RYGEL_MEDIA_EXPORT_DB_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_DB_CONTAINER, RygelMediaExportDBContainerClass))
#define RYGEL_MEDIA_EXPORT_IS_DB_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_DB_CONTAINER))
#define RYGEL_MEDIA_EXPORT_IS_DB_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_DB_CONTAINER))
#define RYGEL_MEDIA_EXPORT_DB_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_DB_CONTAINER, RygelMediaExportDBContainerClass))

typedef struct _RygelMediaExportDBContainer RygelMediaExportDBContainer;
typedef struct _RygelMediaExportDBContainerClass RygelMediaExportDBContainerClass;
typedef struct _RygelMediaExportDBContainerPrivate RygelMediaExportDBContainerPrivate;

#define RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE (rygel_media_export_media_cache_get_type ())
#define RYGEL_MEDIA_EXPORT_MEDIA_CACHE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE, RygelMediaExportMediaCache))
#define RYGEL_MEDIA_EXPORT_MEDIA_CACHE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE, RygelMediaExportMediaCacheClass))
#define RYGEL_MEDIA_EXPORT_IS_MEDIA_CACHE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE))
#define RYGEL_MEDIA_EXPORT_IS_MEDIA_CACHE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE))
#define RYGEL_MEDIA_EXPORT_MEDIA_CACHE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE, RygelMediaExportMediaCacheClass))

typedef struct _RygelMediaExportMediaCache RygelMediaExportMediaCache;
typedef struct _RygelMediaExportMediaCacheClass RygelMediaExportMediaCacheClass;

#define RYGEL_MEDIA_EXPORT_TYPE_ROOT_CONTAINER (rygel_media_export_root_container_get_type ())
#define RYGEL_MEDIA_EXPORT_ROOT_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_ROOT_CONTAINER, RygelMediaExportRootContainer))
#define RYGEL_MEDIA_EXPORT_ROOT_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_ROOT_CONTAINER, RygelMediaExportRootContainerClass))
#define RYGEL_MEDIA_EXPORT_IS_ROOT_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_ROOT_CONTAINER))
#define RYGEL_MEDIA_EXPORT_IS_ROOT_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_ROOT_CONTAINER))
#define RYGEL_MEDIA_EXPORT_ROOT_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_ROOT_CONTAINER, RygelMediaExportRootContainerClass))

typedef struct _RygelMediaExportRootContainer RygelMediaExportRootContainer;
typedef struct _RygelMediaExportRootContainerClass RygelMediaExportRootContainerClass;
typedef struct _RygelMediaExportRootContainerPrivate RygelMediaExportRootContainerPrivate;

#define RYGEL_MEDIA_EXPORT_TYPE_DBUS_SERVICE (rygel_media_export_dbus_service_get_type ())
#define RYGEL_MEDIA_EXPORT_DBUS_SERVICE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_DBUS_SERVICE, RygelMediaExportDBusService))
#define RYGEL_MEDIA_EXPORT_DBUS_SERVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_DBUS_SERVICE, RygelMediaExportDBusServiceClass))
#define RYGEL_MEDIA_EXPORT_IS_DBUS_SERVICE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_DBUS_SERVICE))
#define RYGEL_MEDIA_EXPORT_IS_DBUS_SERVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_DBUS_SERVICE))
#define RYGEL_MEDIA_EXPORT_DBUS_SERVICE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_DBUS_SERVICE, RygelMediaExportDBusServiceClass))

typedef struct _RygelMediaExportDBusService RygelMediaExportDBusService;
typedef struct _RygelMediaExportDBusServiceClass RygelMediaExportDBusServiceClass;

#define RYGEL_MEDIA_EXPORT_TYPE_HARVESTER (rygel_media_export_harvester_get_type ())
#define RYGEL_MEDIA_EXPORT_HARVESTER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_HARVESTER, RygelMediaExportHarvester))
#define RYGEL_MEDIA_EXPORT_HARVESTER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_HARVESTER, RygelMediaExportHarvesterClass))
#define RYGEL_MEDIA_EXPORT_IS_HARVESTER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_HARVESTER))
#define RYGEL_MEDIA_EXPORT_IS_HARVESTER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_HARVESTER))
#define RYGEL_MEDIA_EXPORT_HARVESTER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_HARVESTER, RygelMediaExportHarvesterClass))

typedef struct _RygelMediaExportHarvester RygelMediaExportHarvester;
typedef struct _RygelMediaExportHarvesterClass RygelMediaExportHarvesterClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define RYGEL_TYPE_NULL_CONTAINER (rygel_null_container_get_type ())
#define RYGEL_NULL_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_NULL_CONTAINER, RygelNullContainer))
#define RYGEL_NULL_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_NULL_CONTAINER, RygelNullContainerClass))
#define RYGEL_IS_NULL_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_NULL_CONTAINER))
#define RYGEL_IS_NULL_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_NULL_CONTAINER))
#define RYGEL_NULL_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_NULL_CONTAINER, RygelNullContainerClass))

typedef struct _RygelNullContainer RygelNullContainer;
typedef struct _RygelNullContainerClass RygelNullContainerClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define RYGEL_MEDIA_EXPORT_TYPE_QUERY_CONTAINER (rygel_media_export_query_container_get_type ())
#define RYGEL_MEDIA_EXPORT_QUERY_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_QUERY_CONTAINER, RygelMediaExportQueryContainer))
#define RYGEL_MEDIA_EXPORT_QUERY_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_QUERY_CONTAINER, RygelMediaExportQueryContainerClass))
#define RYGEL_MEDIA_EXPORT_IS_QUERY_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_QUERY_CONTAINER))
#define RYGEL_MEDIA_EXPORT_IS_QUERY_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_QUERY_CONTAINER))
#define RYGEL_MEDIA_EXPORT_QUERY_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_QUERY_CONTAINER, RygelMediaExportQueryContainerClass))

typedef struct _RygelMediaExportQueryContainer RygelMediaExportQueryContainer;
typedef struct _RygelMediaExportQueryContainerClass RygelMediaExportQueryContainerClass;
typedef struct _RygelMediaExportRootContainerFindObjectData RygelMediaExportRootContainerFindObjectData;
#define _rygel_search_expression_unref0(var) ((var == NULL) ? NULL : (var = (rygel_search_expression_unref (var), NULL)))
typedef struct _RygelMediaExportRootContainerSearchData RygelMediaExportRootContainerSearchData;
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
typedef struct _RygelMediaExportQueryContainerPrivate RygelMediaExportQueryContainerPrivate;

struct _RygelMediaExportFolderDefinition {
	gchar* title;
	gchar* definition;
};

struct _RygelMediaExportDBContainer {
	RygelMediaContainer parent_instance;
	RygelMediaExportDBContainerPrivate * priv;
	RygelMediaExportMediaCache* media_db;
};

struct _RygelMediaExportDBContainerClass {
	RygelMediaContainerClass parent_class;
	void (*search) (RygelMediaExportDBContainer* self, RygelSearchExpression* expression, guint offset, guint max_count, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	RygelMediaObjects* (*search_finish) (RygelMediaExportDBContainer* self, GAsyncResult* _res_, guint* total_matches, GError** error);
};

struct _RygelMediaExportRootContainer {
	RygelMediaExportDBContainer parent_instance;
	RygelMediaExportRootContainerPrivate * priv;
};

struct _RygelMediaExportRootContainerClass {
	RygelMediaExportDBContainerClass parent_class;
};

struct _RygelMediaExportRootContainerPrivate {
	RygelMediaExportDBusService* service;
	RygelMediaExportHarvester* harvester;
	GCancellable* cancellable;
	RygelMediaContainer* filesystem_container;
	gulong harvester_signal_id;
};

typedef enum  {
	RYGEL_MEDIA_EXPORT_DATABASE_ERROR_IO_ERROR,
	RYGEL_MEDIA_EXPORT_DATABASE_ERROR_SQLITE_ERROR
} RygelMediaExportDatabaseError;
#define RYGEL_MEDIA_EXPORT_DATABASE_ERROR rygel_media_export_database_error_quark ()
struct _RygelMediaExportRootContainerFindObjectData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelMediaExportRootContainer* self;
	gchar* id;
	GCancellable* cancellable;
	RygelMediaObject* result;
	const gchar* _tmp0_;
	GCancellable* _tmp1_;
	RygelMediaObject* _tmp2_;
	RygelMediaObject* object;
	gboolean _tmp3_;
	const gchar* _tmp4_;
	gboolean _tmp5_;
	gboolean _tmp6_;
	RygelMediaExportMediaCache* _tmp7_;
	const gchar* _tmp8_;
	RygelMediaExportQueryContainer* _tmp9_;
	RygelMediaExportQueryContainer* container;
	RygelMediaExportQueryContainer* _tmp10_;
	GError * _inner_error_;
};

struct _RygelMediaExportRootContainerSearchData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelMediaExportRootContainer* self;
	RygelSearchExpression* expression;
	guint offset;
	guint max_count;
	guint total_matches;
	GCancellable* cancellable;
	RygelMediaObjects* result;
	RygelSearchExpression* _tmp0_;
	RygelSearchExpression* _tmp1_;
	guint _tmp2_;
	guint _tmp3_;
	GCancellable* _tmp4_;
	guint _tmp5_;
	RygelMediaObjects* _tmp6_;
	RygelMediaObjects* _tmp7_;
	RygelMediaObjects* list;
	RygelMediaContainer* query_container;
	gchar* upnp_class;
	RygelSearchExpression* _tmp8_;
	RygelSearchExpression* _tmp9_;
	RygelRelationalExpression* _tmp10_;
	RygelRelationalExpression* relational_expression;
	RygelRelationalExpression* _tmp11_;
	RygelMediaExportQueryContainer* _tmp12_;
	RygelRelationalExpression* _tmp13_;
	gconstpointer _tmp14_;
	gchar* _tmp15_;
	RygelSearchExpression* _tmp16_;
	RygelMediaContainer* _tmp17_;
	gboolean _tmp18_;
	RygelMediaContainer* _tmp19_;
	RygelMediaContainer* _tmp20_;
	guint _tmp21_;
	guint _tmp22_;
	GCancellable* _tmp23_;
	RygelMediaObjects* _tmp24_;
	RygelMediaObjects* _tmp25_;
	RygelMediaContainer* _tmp26_;
	gint _tmp27_;
	const gchar* _tmp28_;
	RygelMediaObjects* _tmp29_;
	RygelMediaObjects* _tmp30_;
	RygelMediaObjects* _object_list;
	RygelMediaObjects* _tmp31_;
	gint _tmp32_;
	gint _tmp33_;
	gint _object_size;
	gint _object_index;
	gint _tmp34_;
	gint _tmp35_;
	gint _tmp36_;
	RygelMediaObjects* _tmp37_;
	gint _tmp38_;
	gpointer _tmp39_;
	RygelMediaObject* object;
	RygelMediaObject* _tmp40_;
	const gchar* _tmp41_;
	gchar* _tmp42_;
	RygelSearchExpression* _tmp43_;
	guint _tmp44_;
	guint _tmp45_;
	GCancellable* _tmp46_;
	guint _tmp47_;
	RygelMediaObjects* _tmp48_;
	RygelMediaObjects* _tmp49_;
	GError * _inner_error_;
};

struct _RygelMediaExportQueryContainer {
	RygelMediaExportDBContainer parent_instance;
	RygelMediaExportQueryContainerPrivate * priv;
	gchar* plaintext_id;
};

struct _RygelMediaExportQueryContainerClass {
	RygelMediaExportDBContainerClass parent_class;
};


static gpointer rygel_media_export_root_container_parent_class = NULL;
static RygelMediaContainer* rygel_media_export_root_container_instance;
static RygelMediaContainer* rygel_media_export_root_container_instance = NULL;
static GError* rygel_media_export_root_container_creation_error;
static GError* rygel_media_export_root_container_creation_error = NULL;

GType rygel_media_export_folder_definition_get_type (void) G_GNUC_CONST;
RygelMediaExportFolderDefinition* rygel_media_export_folder_definition_dup (const RygelMediaExportFolderDefinition* self);
void rygel_media_export_folder_definition_free (RygelMediaExportFolderDefinition* self);
void rygel_media_export_folder_definition_copy (const RygelMediaExportFolderDefinition* self, RygelMediaExportFolderDefinition* dest);
void rygel_media_export_folder_definition_destroy (RygelMediaExportFolderDefinition* self);
GType rygel_media_export_db_container_get_type (void) G_GNUC_CONST;
GType rygel_media_export_media_cache_get_type (void) G_GNUC_CONST;
GType rygel_media_export_root_container_get_type (void) G_GNUC_CONST;
GType rygel_media_export_dbus_service_get_type (void) G_GNUC_CONST;
guint rygel_media_export_dbus_service_register_object (void* object, GDBusConnection* connection, const gchar* path, GError** error);
GType rygel_media_export_harvester_get_type (void) G_GNUC_CONST;
#define RYGEL_MEDIA_EXPORT_ROOT_CONTAINER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_MEDIA_EXPORT_TYPE_ROOT_CONTAINER, RygelMediaExportRootContainerPrivate))
enum  {
	RYGEL_MEDIA_EXPORT_ROOT_CONTAINER_DUMMY_PROPERTY
};
#define RYGEL_MEDIA_EXPORT_ROOT_CONTAINER_FILESYSTEM_FOLDER_NAME "Files & Folders"
#define RYGEL_MEDIA_EXPORT_ROOT_CONTAINER_FILESYSTEM_FOLDER_ID "Filesystem"
RygelMediaContainer* rygel_media_export_root_container_get_instance (GError** error);
static RygelMediaExportRootContainer* rygel_media_export_root_container_new (GError** error);
static RygelMediaExportRootContainer* rygel_media_export_root_container_construct (GType object_type, GError** error);
RygelNullContainer* rygel_null_container_new (void);
RygelNullContainer* rygel_null_container_construct (GType object_type);
GType rygel_null_container_get_type (void) G_GNUC_CONST;
RygelMediaContainer* rygel_media_export_root_container_get_filesystem_container (RygelMediaExportRootContainer* self);
void rygel_media_export_root_container_shutdown (RygelMediaExportRootContainer* self);
void rygel_media_export_root_container_add_uri (RygelMediaExportRootContainer* self, const gchar* uri);
void rygel_media_export_harvester_schedule (RygelMediaExportHarvester* self, GFile* file, RygelMediaContainer* parent, const gchar* flag);
void rygel_media_export_root_container_remove_uri (RygelMediaExportRootContainer* self, const gchar* uri);
gchar* rygel_media_export_media_cache_get_id (GFile* file);
void rygel_media_export_harvester_cancel (RygelMediaExportHarvester* self, GFile* file);
GQuark rygel_media_export_database_error_quark (void);
void rygel_media_export_media_cache_remove_by_id (RygelMediaExportMediaCache* self, const gchar* id, GError** error);
gchar** rygel_media_export_root_container_get_dynamic_uris (RygelMediaExportRootContainer* self, int* result_length1);
GeeList* rygel_media_export_media_cache_get_flagged_uris (RygelMediaExportMediaCache* self, const gchar* flag, GError** error);
static void rygel_media_export_root_container_real_find_object_data_free (gpointer _data);
static void rygel_media_export_root_container_real_find_object (RygelMediaContainer* base, const gchar* id, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean rygel_media_export_root_container_real_find_object_co (RygelMediaExportRootContainerFindObjectData* _data_);
static void rygel_media_export_root_container_find_object_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
#define RYGEL_MEDIA_EXPORT_QUERY_CONTAINER_PREFIX "virtual-container:"
RygelMediaExportQueryContainer* rygel_media_export_query_container_new (RygelMediaExportMediaCache* media_db, const gchar* id, const gchar* name);
RygelMediaExportQueryContainer* rygel_media_export_query_container_construct (GType object_type, RygelMediaExportMediaCache* media_db, const gchar* id, const gchar* name);
GType rygel_media_export_query_container_get_type (void) G_GNUC_CONST;
static void rygel_media_export_root_container_real_search_data_free (gpointer _data);
static void rygel_media_export_root_container_real_search (RygelMediaExportDBContainer* base, RygelSearchExpression* expression, guint offset, guint max_count, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean rygel_media_export_root_container_real_search_co (RygelMediaExportRootContainerSearchData* _data_);
void rygel_media_export_db_container_search (RygelMediaExportDBContainer* self, RygelSearchExpression* expression, guint offset, guint max_count, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
RygelMediaObjects* rygel_media_export_db_container_search_finish (RygelMediaExportDBContainer* self, GAsyncResult* _res_, guint* total_matches, GError** error);
static void rygel_media_export_root_container_search_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static RygelMediaExportQueryContainer* rygel_media_export_root_container_search_to_virtual_container (RygelMediaExportRootContainer* self, RygelRelationalExpression* expression);
static gboolean rygel_media_export_root_container_is_search_in_virtual_container (RygelMediaExportRootContainer* self, RygelSearchExpression* expression, RygelMediaContainer** container);
static GeeArrayList* rygel_media_export_root_container_get_shared_uris (RygelMediaExportRootContainer* self);
void rygel_media_export_query_container_register_id (gchar** id);
RygelMediaExportMediaCache* rygel_media_export_media_cache_get_default (GError** error);
RygelMediaExportDBContainer* rygel_media_export_db_container_new (RygelMediaExportMediaCache* media_db, const gchar* id, const gchar* title);
RygelMediaExportDBContainer* rygel_media_export_db_container_construct (GType object_type, RygelMediaExportMediaCache* media_db, const gchar* id, const gchar* title);
RygelMediaExportHarvester* rygel_media_export_harvester_new (GCancellable* cancellable);
RygelMediaExportHarvester* rygel_media_export_harvester_construct (GType object_type, GCancellable* cancellable);
RygelMediaExportDBusService* rygel_media_export_dbus_service_new (RygelMediaExportRootContainer* root_container, GError** error);
RygelMediaExportDBusService* rygel_media_export_dbus_service_construct (GType object_type, RygelMediaExportRootContainer* root_container, GError** error);
void rygel_media_export_media_cache_save_container (RygelMediaExportMediaCache* self, RygelMediaContainer* container, GError** error);
GeeArrayList* rygel_media_export_media_cache_get_child_ids (RygelMediaExportMediaCache* self, const gchar* container_id, GError** error);
static void rygel_media_export_root_container_on_initial_harvesting_done (RygelMediaExportRootContainer* self);
static void _rygel_media_export_root_container_on_initial_harvesting_done_rygel_media_export_harvester_done (RygelMediaExportHarvester* _sender, gpointer self);
static void rygel_media_export_root_container_add_default_virtual_folders (RygelMediaExportRootContainer* self);
void rygel_media_export_media_cache_debug_statistics (RygelMediaExportMediaCache* self);
static void __lambda3_ (RygelMediaExportRootContainer* self);
static void ___lambda3__rygel_media_container_container_updated (RygelMediaContainer* _sender, RygelMediaContainer* container, gpointer self);
static void rygel_media_export_root_container_add_virtual_containers_for_class (RygelMediaExportRootContainer* self, const gchar* parent, const gchar* item_class, RygelMediaExportFolderDefinition* definitions, int definitions_length1, GError** error);
static void rygel_media_export_root_container_add_folder_definition (RygelMediaExportRootContainer* self, RygelMediaContainer* container, const gchar* item_class, RygelMediaExportFolderDefinition* definition, GError** error);
gint rygel_media_export_media_cache_get_child_count (RygelMediaExportMediaCache* self, const gchar* container_id, GError** error);
static void rygel_media_export_root_container_finalize (GObject* obj);

const RygelMediaExportFolderDefinition virtual_folders_default[2] = {{"Year", "dc:date,?"}, {"All", ""}};
const RygelMediaExportFolderDefinition virtual_folders_music[3] = {{"Artist", "upnp:artist,?,upnp:album,?"}, {"Album", "upnp:album,?"}, {"Genre", "dc:genre,?"}};

void rygel_media_export_folder_definition_copy (const RygelMediaExportFolderDefinition* self, RygelMediaExportFolderDefinition* dest) {
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
#line 24 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	_tmp0_ = (*self).title;
#line 24 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 24 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	_g_free0 ((*dest).title);
#line 24 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	(*dest).title = _tmp1_;
#line 24 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	_tmp2_ = (*self).definition;
#line 24 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	_tmp3_ = g_strdup (_tmp2_);
#line 24 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	_g_free0 ((*dest).definition);
#line 24 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	(*dest).definition = _tmp3_;
#line 369 "rygel-media-export-root-container.c"
}


void rygel_media_export_folder_definition_destroy (RygelMediaExportFolderDefinition* self) {
#line 25 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	_g_free0 ((*self).title);
#line 26 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	_g_free0 ((*self).definition);
#line 378 "rygel-media-export-root-container.c"
}


RygelMediaExportFolderDefinition* rygel_media_export_folder_definition_dup (const RygelMediaExportFolderDefinition* self) {
	RygelMediaExportFolderDefinition* dup;
#line 24 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	dup = g_new0 (RygelMediaExportFolderDefinition, 1);
#line 24 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	rygel_media_export_folder_definition_copy (self, dup);
#line 24 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	return dup;
#line 390 "rygel-media-export-root-container.c"
}


void rygel_media_export_folder_definition_free (RygelMediaExportFolderDefinition* self) {
#line 24 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	rygel_media_export_folder_definition_destroy (self);
#line 24 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	g_free (self);
#line 399 "rygel-media-export-root-container.c"
}


GType rygel_media_export_folder_definition_get_type (void) {
	static volatile gsize rygel_media_export_folder_definition_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_media_export_folder_definition_type_id__volatile)) {
		GType rygel_media_export_folder_definition_type_id;
		rygel_media_export_folder_definition_type_id = g_boxed_type_register_static ("RygelMediaExportFolderDefinition", (GBoxedCopyFunc) rygel_media_export_folder_definition_dup, (GBoxedFreeFunc) rygel_media_export_folder_definition_free);
		g_once_init_leave (&rygel_media_export_folder_definition_type_id__volatile, rygel_media_export_folder_definition_type_id);
	}
	return rygel_media_export_folder_definition_type_id__volatile;
}


static gpointer _g_error_copy0 (gpointer self) {
#line 63 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	return self ? g_error_copy (self) : NULL;
#line 417 "rygel-media-export-root-container.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 71 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	return self ? g_object_ref (self) : NULL;
#line 424 "rygel-media-export-root-container.c"
}


RygelMediaContainer* rygel_media_export_root_container_get_instance (GError** error) {
	RygelMediaContainer* result = NULL;
	RygelMediaContainer* _tmp0_;
	RygelMediaContainer* _tmp9_;
	RygelMediaContainer* _tmp10_;
	GError * _inner_error_ = NULL;
#line 57 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	_tmp0_ = rygel_media_export_root_container_instance;
#line 57 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	if (_tmp0_ == NULL) {
#line 438 "rygel-media-export-root-container.c"
		{
			RygelMediaExportRootContainer* _tmp1_;
			RygelMediaExportRootContainer* _tmp2_;
#line 59 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
			_tmp1_ = rygel_media_export_root_container_new (&_inner_error_);
#line 59 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
			_tmp2_ = _tmp1_;
#line 59 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
			if (_inner_error_ != NULL) {
#line 448 "rygel-media-export-root-container.c"
				goto __catch24_g_error;
			}
#line 59 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
			_g_object_unref0 (rygel_media_export_root_container_instance);
#line 59 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
			rygel_media_export_root_container_instance = (RygelMediaContainer*) _tmp2_;
#line 455 "rygel-media-export-root-container.c"
		}
		goto __finally24;
		__catch24_g_error:
		{
			GError* _error_ = NULL;
			RygelNullContainer* _tmp3_;
			GError* _tmp4_;
			GError* _tmp5_;
#line 58 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
			_error_ = _inner_error_;
#line 58 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
			_inner_error_ = NULL;
#line 62 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
			_tmp3_ = rygel_null_container_new ();
#line 62 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
			_g_object_unref0 (rygel_media_export_root_container_instance);
#line 62 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
			rygel_media_export_root_container_instance = (RygelMediaContainer*) _tmp3_;
#line 63 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
			_tmp4_ = _error_;
#line 63 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
			_tmp5_ = _g_error_copy0 (_tmp4_);
#line 63 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
			_g_error_free0 (rygel_media_export_root_container_creation_error);
#line 63 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
			rygel_media_export_root_container_creation_error = _tmp5_;
#line 58 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
			_g_error_free0 (_error_);
#line 484 "rygel-media-export-root-container.c"
		}
		__finally24:
#line 58 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		if (_inner_error_ != NULL) {
#line 58 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
			g_propagate_error (error, _inner_error_);
#line 58 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
			return NULL;
#line 493 "rygel-media-export-root-container.c"
		}
	} else {
		GError* _tmp6_;
#line 66 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		_tmp6_ = rygel_media_export_root_container_creation_error;
#line 66 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		if (_tmp6_ != NULL) {
#line 501 "rygel-media-export-root-container.c"
			GError* _tmp7_;
			GError* _tmp8_;
#line 67 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
			_tmp7_ = rygel_media_export_root_container_creation_error;
#line 67 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
			_tmp8_ = _g_error_copy0 (_tmp7_);
#line 67 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
			_inner_error_ = _tmp8_;
#line 67 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
			g_propagate_error (error, _inner_error_);
#line 67 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
			return NULL;
#line 514 "rygel-media-export-root-container.c"
		}
	}
#line 71 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	_tmp9_ = rygel_media_export_root_container_instance;
#line 71 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	_tmp10_ = _g_object_ref0 (_tmp9_);
#line 71 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	result = _tmp10_;
#line 71 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	return result;
#line 525 "rygel-media-export-root-container.c"
}


RygelMediaContainer* rygel_media_export_root_container_get_filesystem_container (RygelMediaExportRootContainer* self) {
	RygelMediaContainer* result = NULL;
	RygelMediaContainer* _tmp0_;
	RygelMediaContainer* _tmp1_;
#line 74 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 75 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	_tmp0_ = self->priv->filesystem_container;
#line 75 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 75 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	result = _tmp1_;
#line 75 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	return result;
#line 543 "rygel-media-export-root-container.c"
}


void rygel_media_export_root_container_shutdown (RygelMediaExportRootContainer* self) {
	GCancellable* _tmp0_;
#line 78 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	g_return_if_fail (self != NULL);
#line 79 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	_tmp0_ = self->priv->cancellable;
#line 79 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	g_cancellable_cancel (_tmp0_);
#line 555 "rygel-media-export-root-container.c"
}


void rygel_media_export_root_container_add_uri (RygelMediaExportRootContainer* self, const gchar* uri) {
	const gchar* _tmp0_;
	GFile* _tmp1_ = NULL;
	GFile* file;
	RygelMediaExportHarvester* _tmp2_;
	RygelMediaContainer* _tmp3_;
#line 84 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	g_return_if_fail (self != NULL);
#line 84 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	g_return_if_fail (uri != NULL);
#line 85 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	_tmp0_ = uri;
#line 85 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	_tmp1_ = g_file_new_for_commandline_arg (_tmp0_);
#line 85 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	file = _tmp1_;
#line 86 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	_tmp2_ = self->priv->harvester;
#line 86 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	_tmp3_ = self->priv->filesystem_container;
#line 86 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	rygel_media_export_harvester_schedule (_tmp2_, file, _tmp3_, "DBUS");
#line 84 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	_g_object_unref0 (file);
#line 583 "rygel-media-export-root-container.c"
}


void rygel_media_export_root_container_remove_uri (RygelMediaExportRootContainer* self, const gchar* uri) {
	const gchar* _tmp0_;
	GFile* _tmp1_ = NULL;
	GFile* file;
	gchar* _tmp2_ = NULL;
	gchar* id;
	RygelMediaExportHarvester* _tmp3_;
	GError * _inner_error_ = NULL;
#line 91 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	g_return_if_fail (self != NULL);
#line 91 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	g_return_if_fail (uri != NULL);
#line 92 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	_tmp0_ = uri;
#line 92 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	_tmp1_ = g_file_new_for_commandline_arg (_tmp0_);
#line 92 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	file = _tmp1_;
#line 93 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	_tmp2_ = rygel_media_export_media_cache_get_id (file);
#line 93 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	id = _tmp2_;
#line 95 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	_tmp3_ = self->priv->harvester;
#line 95 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	rygel_media_export_harvester_cancel (_tmp3_, file);
#line 613 "rygel-media-export-root-container.c"
	{
		RygelMediaExportMediaCache* _tmp4_;
#line 97 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		_tmp4_ = ((RygelMediaExportDBContainer*) self)->media_db;
#line 97 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		rygel_media_export_media_cache_remove_by_id (_tmp4_, id, &_inner_error_);
#line 97 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		if (_inner_error_ != NULL) {
#line 622 "rygel-media-export-root-container.c"
			goto __catch25_g_error;
		}
	}
	goto __finally25;
	__catch25_g_error:
	{
		GError* _error_ = NULL;
		const gchar* _tmp5_ = NULL;
		GError* _tmp6_;
		const gchar* _tmp7_;
#line 96 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		_error_ = _inner_error_;
#line 96 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		_inner_error_ = NULL;
#line 99 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		_tmp5_ = _ ("Failed to remove URI: %s");
#line 99 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		_tmp6_ = _error_;
#line 99 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		_tmp7_ = _tmp6_->message;
#line 99 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		g_warning (_tmp5_, _tmp7_);
#line 96 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		_g_error_free0 (_error_);
#line 647 "rygel-media-export-root-container.c"
	}
	__finally25:
#line 96 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	if (_inner_error_ != NULL) {
#line 96 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		_g_free0 (id);
#line 96 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		_g_object_unref0 (file);
#line 96 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 96 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		g_clear_error (&_inner_error_);
#line 96 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		return;
#line 662 "rygel-media-export-root-container.c"
	}
#line 91 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	_g_free0 (id);
#line 91 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	_g_object_unref0 (file);
#line 668 "rygel-media-export-root-container.c"
}


gchar** rygel_media_export_root_container_get_dynamic_uris (RygelMediaExportRootContainer* self, int* result_length1) {
	gchar** result = NULL;
	gchar** _tmp5_ = NULL;
	gchar** _tmp6_;
	gint _tmp6__length1;
	GError * _inner_error_ = NULL;
#line 103 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 680 "rygel-media-export-root-container.c"
	{
		RygelMediaExportMediaCache* _tmp0_;
		GeeList* _tmp1_ = NULL;
		GeeList* uris;
		gint _tmp2_ = 0;
		gpointer* _tmp3_ = NULL;
		gchar** _tmp4_;
		gint _tmp4__length1;
#line 105 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		_tmp0_ = ((RygelMediaExportDBContainer*) self)->media_db;
#line 105 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		_tmp1_ = rygel_media_export_media_cache_get_flagged_uris (_tmp0_, "DBUS", &_inner_error_);
#line 105 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		uris = _tmp1_;
#line 105 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		if (_inner_error_ != NULL) {
#line 697 "rygel-media-export-root-container.c"
			goto __catch26_g_error;
		}
#line 107 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		_tmp3_ = gee_collection_to_array ((GeeCollection*) uris, &_tmp2_);
#line 107 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		_tmp4_ = _tmp3_;
#line 107 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		_tmp4__length1 = _tmp2_;
#line 107 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		if (result_length1) {
#line 107 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
			*result_length1 = _tmp4__length1;
#line 710 "rygel-media-export-root-container.c"
		}
#line 107 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		result = _tmp4_;
#line 107 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		_g_object_unref0 (uris);
#line 107 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		return result;
#line 718 "rygel-media-export-root-container.c"
	}
	goto __finally26;
	__catch26_g_error:
	{
		GError* _error_ = NULL;
#line 104 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		_error_ = _inner_error_;
#line 104 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		_inner_error_ = NULL;
#line 104 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		_g_error_free0 (_error_);
#line 730 "rygel-media-export-root-container.c"
	}
	__finally26:
#line 104 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	if (_inner_error_ != NULL) {
#line 104 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 104 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		g_clear_error (&_inner_error_);
#line 104 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		return NULL;
#line 741 "rygel-media-export-root-container.c"
	}
#line 110 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	_tmp5_ = g_new0 (gchar*, 0 + 1);
#line 110 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	_tmp6_ = _tmp5_;
#line 110 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	_tmp6__length1 = 0;
#line 110 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	if (result_length1) {
#line 110 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		*result_length1 = _tmp6__length1;
#line 753 "rygel-media-export-root-container.c"
	}
#line 110 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	result = _tmp6_;
#line 110 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	return result;
#line 759 "rygel-media-export-root-container.c"
}


static void rygel_media_export_root_container_real_find_object_data_free (gpointer _data) {
	RygelMediaExportRootContainerFindObjectData* _data_;
	_data_ = _data;
#line 43 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	_g_free0 (_data_->id);
#line 43 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	_g_object_unref0 (_data_->cancellable);
#line 43 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	_g_object_unref0 (_data_->result);
#line 43 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	_g_object_unref0 (_data_->self);
#line 43 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	g_slice_free (RygelMediaExportRootContainerFindObjectData, _data_);
#line 776 "rygel-media-export-root-container.c"
}


static void rygel_media_export_root_container_real_find_object (RygelMediaContainer* base, const gchar* id, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelMediaExportRootContainer * self;
	RygelMediaExportRootContainerFindObjectData* _data_;
	RygelMediaExportRootContainer* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	GCancellable* _tmp3_;
	GCancellable* _tmp4_;
#line 43 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	self = (RygelMediaExportRootContainer*) base;
#line 43 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	_data_ = g_slice_new0 (RygelMediaExportRootContainerFindObjectData);
#line 43 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_media_export_root_container_real_find_object);
#line 43 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_media_export_root_container_real_find_object_data_free);
#line 43 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 43 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	_data_->self = _tmp0_;
#line 43 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	_tmp1_ = id;
#line 43 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	_tmp2_ = g_strdup (_tmp1_);
#line 43 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	_data_->id = _tmp2_;
#line 43 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	_tmp3_ = cancellable;
#line 43 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	_tmp4_ = _g_object_ref0 (_tmp3_);
#line 43 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	_data_->cancellable = _tmp4_;
#line 43 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	rygel_media_export_root_container_real_find_object_co (_data_);
#line 814 "rygel-media-export-root-container.c"
}


static RygelMediaObject* rygel_media_export_root_container_real_find_object_finish (RygelMediaContainer* base, GAsyncResult* _res_, GError** error) {
	RygelMediaObject* result;
	RygelMediaExportRootContainerFindObjectData* _data_;
#line 43 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
#line 43 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		return NULL;
#line 825 "rygel-media-export-root-container.c"
	}
#line 43 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 43 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	result = _data_->result;
#line 43 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	_data_->result = NULL;
#line 43 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	return result;
#line 835 "rygel-media-export-root-container.c"
}


static void rygel_media_export_root_container_find_object_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelMediaExportRootContainerFindObjectData* _data_;
#line 118 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	_data_ = _user_data_;
#line 118 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	_data_->_source_object_ = source_object;
#line 118 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	_data_->_res_ = _res_;
#line 118 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	rygel_media_export_root_container_real_find_object_co (_data_);
#line 849 "rygel-media-export-root-container.c"
}


static gboolean rygel_media_export_root_container_real_find_object_co (RygelMediaExportRootContainerFindObjectData* _data_) {
#line 115 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	switch (_data_->_state_) {
#line 115 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		case 0:
#line 858 "rygel-media-export-root-container.c"
		goto _state_0;
#line 115 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		case 1:
#line 862 "rygel-media-export-root-container.c"
		goto _state_1;
		default:
#line 115 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		g_assert_not_reached ();
#line 867 "rygel-media-export-root-container.c"
	}
	_state_0:
#line 118 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	_data_->_tmp0_ = _data_->id;
#line 118 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	_data_->_tmp1_ = _data_->cancellable;
#line 118 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	_data_->_state_ = 1;
#line 118 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	RYGEL_MEDIA_CONTAINER_CLASS (rygel_media_export_root_container_parent_class)->find_object ((RygelMediaContainer*) RYGEL_MEDIA_EXPORT_DB_CONTAINER (_data_->self), _data_->_tmp0_, _data_->_tmp1_, rygel_media_export_root_container_find_object_ready, _data_);
#line 118 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	return FALSE;
#line 880 "rygel-media-export-root-container.c"
	_state_1:
#line 118 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	_data_->_tmp2_ = NULL;
#line 118 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	_data_->_tmp2_ = RYGEL_MEDIA_CONTAINER_CLASS (rygel_media_export_root_container_parent_class)->find_object_finish ((RygelMediaContainer*) RYGEL_MEDIA_EXPORT_DB_CONTAINER (_data_->self), _data_->_res_, &_data_->_inner_error_);
#line 118 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	_data_->object = _data_->_tmp2_;
#line 118 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	if (_data_->_inner_error_ != NULL) {
#line 118 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 118 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		g_error_free (_data_->_inner_error_);
#line 118 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		if (_data_->_state_ == 0) {
#line 118 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 898 "rygel-media-export-root-container.c"
		} else {
#line 118 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 902 "rygel-media-export-root-container.c"
		}
#line 118 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		g_object_unref (_data_->_async_result);
#line 118 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		return FALSE;
#line 908 "rygel-media-export-root-container.c"
	}
#line 120 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	if (_data_->object == NULL) {
#line 120 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		_data_->_tmp4_ = _data_->id;
#line 120 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		_data_->_tmp5_ = FALSE;
#line 120 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		_data_->_tmp5_ = g_str_has_prefix (_data_->_tmp4_, RYGEL_MEDIA_EXPORT_QUERY_CONTAINER_PREFIX);
#line 120 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		_data_->_tmp3_ = _data_->_tmp5_;
#line 920 "rygel-media-export-root-container.c"
	} else {
#line 120 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		_data_->_tmp3_ = FALSE;
#line 924 "rygel-media-export-root-container.c"
	}
#line 120 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	_data_->_tmp6_ = _data_->_tmp3_;
#line 120 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	if (_data_->_tmp6_) {
#line 121 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		_data_->_tmp7_ = ((RygelMediaExportDBContainer*) _data_->self)->media_db;
#line 121 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		_data_->_tmp8_ = _data_->id;
#line 121 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		_data_->_tmp9_ = rygel_media_export_query_container_new (_data_->_tmp7_, _data_->_tmp8_, "");
#line 121 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		_data_->container = _data_->_tmp9_;
#line 122 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		_data_->_tmp10_ = _data_->container;
#line 122 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		((RygelMediaObject*) _data_->_tmp10_)->parent = (RygelMediaContainer*) _data_->self;
#line 124 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		_data_->result = (RygelMediaObject*) _data_->container;
#line 124 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		_g_object_unref0 (_data_->object);
#line 124 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		if (_data_->_state_ == 0) {
#line 124 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 950 "rygel-media-export-root-container.c"
		} else {
#line 124 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 954 "rygel-media-export-root-container.c"
		}
#line 124 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		g_object_unref (_data_->_async_result);
#line 124 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		return FALSE;
#line 960 "rygel-media-export-root-container.c"
	}
#line 127 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	_data_->result = _data_->object;
#line 127 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	if (_data_->_state_ == 0) {
#line 127 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 968 "rygel-media-export-root-container.c"
	} else {
#line 127 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 972 "rygel-media-export-root-container.c"
	}
#line 127 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	g_object_unref (_data_->_async_result);
#line 127 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	return FALSE;
#line 115 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	_g_object_unref0 (_data_->object);
#line 115 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	if (_data_->_state_ == 0) {
#line 115 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 984 "rygel-media-export-root-container.c"
	} else {
#line 115 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 988 "rygel-media-export-root-container.c"
	}
#line 115 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	g_object_unref (_data_->_async_result);
#line 115 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	return FALSE;
#line 994 "rygel-media-export-root-container.c"
}


static void rygel_media_export_root_container_real_search_data_free (gpointer _data) {
	RygelMediaExportRootContainerSearchData* _data_;
	_data_ = _data;
#line 43 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	_rygel_search_expression_unref0 (_data_->expression);
#line 43 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	_g_object_unref0 (_data_->cancellable);
#line 43 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	_g_object_unref0 (_data_->result);
#line 43 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	_g_object_unref0 (_data_->self);
#line 43 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	g_slice_free (RygelMediaExportRootContainerSearchData, _data_);
#line 1011 "rygel-media-export-root-container.c"
}


static gpointer _rygel_search_expression_ref0 (gpointer self) {
#line 43 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	return self ? rygel_search_expression_ref (self) : NULL;
#line 1018 "rygel-media-export-root-container.c"
}


static void rygel_media_export_root_container_real_search (RygelMediaExportDBContainer* base, RygelSearchExpression* expression, guint offset, guint max_count, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelMediaExportRootContainer * self;
	RygelMediaExportRootContainerSearchData* _data_;
	RygelMediaExportRootContainer* _tmp0_;
	RygelSearchExpression* _tmp1_;
	RygelSearchExpression* _tmp2_;
	guint _tmp3_;
	guint _tmp4_;
	GCancellable* _tmp5_;
	GCancellable* _tmp6_;
#line 43 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	self = (RygelMediaExportRootContainer*) base;
#line 43 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	_data_ = g_slice_new0 (RygelMediaExportRootContainerSearchData);
#line 43 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_media_export_root_container_real_search);
#line 43 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_media_export_root_container_real_search_data_free);
#line 43 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 43 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	_data_->self = _tmp0_;
#line 43 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	_tmp1_ = expression;
#line 43 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	_tmp2_ = _rygel_search_expression_ref0 (_tmp1_);
#line 43 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	_data_->expression = _tmp2_;
#line 43 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	_tmp3_ = offset;
#line 43 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	_data_->offset = _tmp3_;
#line 43 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	_tmp4_ = max_count;
#line 43 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	_data_->max_count = _tmp4_;
#line 43 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	_tmp5_ = cancellable;
#line 43 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	_tmp6_ = _g_object_ref0 (_tmp5_);
#line 43 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	_data_->cancellable = _tmp6_;
#line 43 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	rygel_media_export_root_container_real_search_co (_data_);
#line 1066 "rygel-media-export-root-container.c"
}


static RygelMediaObjects* rygel_media_export_root_container_real_search_finish (RygelMediaExportDBContainer* base, GAsyncResult* _res_, guint* total_matches, GError** error) {
	RygelMediaObjects* result;
	RygelMediaExportRootContainerSearchData* _data_;
#line 43 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
#line 43 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		return NULL;
#line 1077 "rygel-media-export-root-container.c"
	}
#line 43 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 43 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	if (total_matches) {
#line 43 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		*total_matches = _data_->total_matches;
#line 1085 "rygel-media-export-root-container.c"
	}
#line 43 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	result = _data_->result;
#line 43 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	_data_->result = NULL;
#line 43 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	return result;
#line 1093 "rygel-media-export-root-container.c"
}


static void rygel_media_export_root_container_search_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelMediaExportRootContainerSearchData* _data_;
#line 137 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	_data_ = _user_data_;
#line 137 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	_data_->_source_object_ = source_object;
#line 137 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	_data_->_res_ = _res_;
#line 137 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	rygel_media_export_root_container_real_search_co (_data_);
#line 1107 "rygel-media-export-root-container.c"
}


static gboolean rygel_media_export_root_container_real_search_co (RygelMediaExportRootContainerSearchData* _data_) {
#line 130 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	switch (_data_->_state_) {
#line 130 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		case 0:
#line 1116 "rygel-media-export-root-container.c"
		goto _state_0;
#line 130 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		case 1:
#line 1120 "rygel-media-export-root-container.c"
		goto _state_1;
#line 130 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		case 2:
#line 1124 "rygel-media-export-root-container.c"
		goto _state_2;
#line 130 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		case 3:
#line 1128 "rygel-media-export-root-container.c"
		goto _state_3;
		default:
#line 130 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		g_assert_not_reached ();
#line 1133 "rygel-media-export-root-container.c"
	}
	_state_0:
#line 136 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	_data_->_tmp0_ = _data_->expression;
#line 136 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	if (_data_->_tmp0_ == NULL) {
#line 137 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		_data_->_tmp1_ = _data_->expression;
#line 137 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		_data_->_tmp2_ = _data_->offset;
#line 137 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		_data_->_tmp3_ = _data_->max_count;
#line 137 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		_data_->_tmp4_ = _data_->cancellable;
#line 137 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		_data_->_tmp5_ = 0U;
#line 137 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		_data_->_state_ = 1;
#line 137 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		RYGEL_MEDIA_EXPORT_DB_CONTAINER_CLASS (rygel_media_export_root_container_parent_class)->search (RYGEL_MEDIA_EXPORT_DB_CONTAINER (_data_->self), _data_->_tmp1_, _data_->_tmp2_, _data_->_tmp3_, _data_->_tmp4_, rygel_media_export_root_container_search_ready, _data_);
#line 137 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		return FALSE;
#line 1156 "rygel-media-export-root-container.c"
		_state_1:
#line 137 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		_data_->_tmp6_ = NULL;
#line 137 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		_data_->_tmp6_ = RYGEL_MEDIA_EXPORT_DB_CONTAINER_CLASS (rygel_media_export_root_container_parent_class)->search_finish (RYGEL_MEDIA_EXPORT_DB_CONTAINER (_data_->self), _data_->_res_, &_data_->_tmp5_, &_data_->_inner_error_);
#line 137 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		_data_->total_matches = _data_->_tmp5_;
#line 137 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		_data_->_tmp7_ = _data_->_tmp6_;
#line 137 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		if (_data_->_inner_error_ != NULL) {
#line 137 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 137 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
			g_error_free (_data_->_inner_error_);
#line 137 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
			if (_data_->_state_ == 0) {
#line 137 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
				g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1176 "rygel-media-export-root-container.c"
			} else {
#line 137 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
				g_simple_async_result_complete (_data_->_async_result);
#line 1180 "rygel-media-export-root-container.c"
			}
#line 137 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
			g_object_unref (_data_->_async_result);
#line 137 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
			return FALSE;
#line 1186 "rygel-media-export-root-container.c"
		}
#line 137 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		_data_->result = _data_->_tmp7_;
#line 137 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		if (_data_->_state_ == 0) {
#line 137 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1194 "rygel-media-export-root-container.c"
		} else {
#line 137 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 1198 "rygel-media-export-root-container.c"
		}
#line 137 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		g_object_unref (_data_->_async_result);
#line 137 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		return FALSE;
#line 1204 "rygel-media-export-root-container.c"
	}
#line 145 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	_data_->query_container = NULL;
#line 146 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	_data_->upnp_class = NULL;
#line 148 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	_data_->_tmp8_ = _data_->expression;
#line 148 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	if (RYGEL_IS_RELATIONAL_EXPRESSION (_data_->_tmp8_)) {
#line 149 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		_data_->_tmp9_ = _data_->expression;
#line 149 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		_data_->_tmp10_ = _rygel_search_expression_ref0 (RYGEL_IS_RELATIONAL_EXPRESSION (_data_->_tmp9_) ? ((RygelRelationalExpression*) _data_->_tmp9_) : NULL);
#line 149 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		_data_->relational_expression = _data_->_tmp10_;
#line 151 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		_data_->_tmp11_ = _data_->relational_expression;
#line 151 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		_data_->_tmp12_ = NULL;
#line 151 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		_data_->_tmp12_ = rygel_media_export_root_container_search_to_virtual_container (_data_->self, _data_->_tmp11_);
#line 151 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		_g_object_unref0 (_data_->query_container);
#line 151 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		_data_->query_container = (RygelMediaContainer*) _data_->_tmp12_;
#line 153 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		_data_->_tmp13_ = _data_->relational_expression;
#line 153 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		_data_->_tmp14_ = ((RygelSearchExpression*) _data_->_tmp13_)->operand2;
#line 153 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		_data_->_tmp15_ = g_strdup ((const gchar*) _data_->_tmp14_);
#line 153 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		_g_free0 (_data_->upnp_class);
#line 153 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		_data_->upnp_class = _data_->_tmp15_;
#line 148 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		_rygel_search_expression_unref0 (_data_->relational_expression);
#line 1242 "rygel-media-export-root-container.c"
	} else {
#line 154 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		_data_->_tmp16_ = _data_->expression;
#line 154 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		_data_->_tmp17_ = NULL;
#line 154 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		_data_->_tmp18_ = FALSE;
#line 154 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		_data_->_tmp18_ = rygel_media_export_root_container_is_search_in_virtual_container (_data_->self, _data_->_tmp16_, &_data_->_tmp17_);
#line 154 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		_g_object_unref0 (_data_->query_container);
#line 154 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		_data_->query_container = _data_->_tmp17_;
#line 154 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		if (_data_->_tmp18_) {
#line 1258 "rygel-media-export-root-container.c"
		}
	}
#line 159 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	_data_->_tmp19_ = _data_->query_container;
#line 159 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	if (_data_->_tmp19_ != NULL) {
#line 160 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		_data_->_tmp20_ = _data_->query_container;
#line 160 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		_data_->_tmp21_ = _data_->offset;
#line 160 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		_data_->_tmp22_ = _data_->max_count;
#line 160 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		_data_->_tmp23_ = _data_->cancellable;
#line 160 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		_data_->_state_ = 2;
#line 160 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		rygel_media_container_get_children (_data_->_tmp20_, _data_->_tmp21_, _data_->_tmp22_, _data_->_tmp23_, rygel_media_export_root_container_search_ready, _data_);
#line 160 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		return FALSE;
#line 1279 "rygel-media-export-root-container.c"
		_state_2:
#line 160 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		_data_->_tmp24_ = NULL;
#line 160 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		_data_->_tmp24_ = rygel_media_container_get_children_finish (_data_->_tmp20_, _data_->_res_, &_data_->_inner_error_);
#line 160 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		_data_->_tmp25_ = _data_->_tmp24_;
#line 160 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		if (_data_->_inner_error_ != NULL) {
#line 160 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 160 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
			g_error_free (_data_->_inner_error_);
#line 160 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
			_g_free0 (_data_->upnp_class);
#line 160 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
			_g_object_unref0 (_data_->query_container);
#line 160 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
			_g_object_unref0 (_data_->list);
#line 160 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
			if (_data_->_state_ == 0) {
#line 160 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
				g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1303 "rygel-media-export-root-container.c"
			} else {
#line 160 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
				g_simple_async_result_complete (_data_->_async_result);
#line 1307 "rygel-media-export-root-container.c"
			}
#line 160 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
			g_object_unref (_data_->_async_result);
#line 160 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
			return FALSE;
#line 1313 "rygel-media-export-root-container.c"
		}
#line 160 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		_g_object_unref0 (_data_->list);
#line 160 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		_data_->list = _data_->_tmp25_;
#line 163 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		_data_->_tmp26_ = _data_->query_container;
#line 163 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		_data_->_tmp27_ = _data_->_tmp26_->child_count;
#line 163 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		_data_->total_matches = (guint) _data_->_tmp27_;
#line 165 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		_data_->_tmp28_ = _data_->upnp_class;
#line 165 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		if (_data_->_tmp28_ != NULL) {
#line 1329 "rygel-media-export-root-container.c"
			{
#line 166 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
				_data_->_tmp29_ = _data_->list;
#line 166 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
				_data_->_tmp30_ = _g_object_ref0 (_data_->_tmp29_);
#line 166 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
				_data_->_object_list = _data_->_tmp30_;
#line 166 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
				_data_->_tmp31_ = _data_->_object_list;
#line 166 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
				_data_->_tmp32_ = gee_collection_get_size ((GeeCollection*) _data_->_tmp31_);
#line 166 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
				_data_->_tmp33_ = _data_->_tmp32_;
#line 166 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
				_data_->_object_size = _data_->_tmp33_;
#line 166 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
				_data_->_object_index = -1;
#line 166 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
				while (TRUE) {
#line 166 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
					_data_->_tmp34_ = _data_->_object_index;
#line 166 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
					_data_->_object_index = _data_->_tmp34_ + 1;
#line 166 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
					_data_->_tmp35_ = _data_->_object_index;
#line 166 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
					_data_->_tmp36_ = _data_->_object_size;
#line 166 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
					if (!(_data_->_tmp35_ < _data_->_tmp36_)) {
#line 166 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
						break;
#line 1361 "rygel-media-export-root-container.c"
					}
#line 166 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
					_data_->_tmp37_ = _data_->_object_list;
#line 166 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
					_data_->_tmp38_ = _data_->_object_index;
#line 166 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
					_data_->_tmp39_ = NULL;
#line 166 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
					_data_->_tmp39_ = gee_abstract_list_get ((GeeAbstractList*) _data_->_tmp37_, _data_->_tmp38_);
#line 166 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
					_data_->object = (RygelMediaObject*) _data_->_tmp39_;
#line 167 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
					_data_->_tmp40_ = _data_->object;
#line 167 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
					_data_->_tmp41_ = _data_->upnp_class;
#line 167 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
					_data_->_tmp42_ = g_strdup (_data_->_tmp41_);
#line 167 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
					_g_free0 (_data_->_tmp40_->upnp_class);
#line 167 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
					_data_->_tmp40_->upnp_class = _data_->_tmp42_;
#line 166 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
					_g_object_unref0 (_data_->object);
#line 1385 "rygel-media-export-root-container.c"
				}
#line 166 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
				_g_object_unref0 (_data_->_object_list);
#line 1389 "rygel-media-export-root-container.c"
			}
		}
#line 171 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		_data_->result = _data_->list;
#line 171 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		_g_free0 (_data_->upnp_class);
#line 171 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		_g_object_unref0 (_data_->query_container);
#line 171 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		if (_data_->_state_ == 0) {
#line 171 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1402 "rygel-media-export-root-container.c"
		} else {
#line 171 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 1406 "rygel-media-export-root-container.c"
		}
#line 171 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		g_object_unref (_data_->_async_result);
#line 171 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		return FALSE;
#line 1412 "rygel-media-export-root-container.c"
	} else {
#line 173 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		_data_->_tmp43_ = _data_->expression;
#line 173 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		_data_->_tmp44_ = _data_->offset;
#line 173 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		_data_->_tmp45_ = _data_->max_count;
#line 173 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		_data_->_tmp46_ = _data_->cancellable;
#line 173 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		_data_->_tmp47_ = 0U;
#line 173 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		_data_->_state_ = 3;
#line 173 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		RYGEL_MEDIA_EXPORT_DB_CONTAINER_CLASS (rygel_media_export_root_container_parent_class)->search (RYGEL_MEDIA_EXPORT_DB_CONTAINER (_data_->self), _data_->_tmp43_, _data_->_tmp44_, _data_->_tmp45_, _data_->_tmp46_, rygel_media_export_root_container_search_ready, _data_);
#line 173 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		return FALSE;
#line 1430 "rygel-media-export-root-container.c"
		_state_3:
#line 173 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		_data_->_tmp48_ = NULL;
#line 173 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		_data_->_tmp48_ = RYGEL_MEDIA_EXPORT_DB_CONTAINER_CLASS (rygel_media_export_root_container_parent_class)->search_finish (RYGEL_MEDIA_EXPORT_DB_CONTAINER (_data_->self), _data_->_res_, &_data_->_tmp47_, &_data_->_inner_error_);
#line 173 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		_data_->total_matches = _data_->_tmp47_;
#line 173 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		_data_->_tmp49_ = _data_->_tmp48_;
#line 173 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		if (_data_->_inner_error_ != NULL) {
#line 173 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 173 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
			g_error_free (_data_->_inner_error_);
#line 173 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
			_g_free0 (_data_->upnp_class);
#line 173 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
			_g_object_unref0 (_data_->query_container);
#line 173 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
			_g_object_unref0 (_data_->list);
#line 173 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
			if (_data_->_state_ == 0) {
#line 173 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
				g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1456 "rygel-media-export-root-container.c"
			} else {
#line 173 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
				g_simple_async_result_complete (_data_->_async_result);
#line 1460 "rygel-media-export-root-container.c"
			}
#line 173 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
			g_object_unref (_data_->_async_result);
#line 173 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
			return FALSE;
#line 1466 "rygel-media-export-root-container.c"
		}
#line 173 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		_data_->result = _data_->_tmp49_;
#line 173 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		_g_free0 (_data_->upnp_class);
#line 173 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		_g_object_unref0 (_data_->query_container);
#line 173 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		_g_object_unref0 (_data_->list);
#line 173 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		if (_data_->_state_ == 0) {
#line 173 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1480 "rygel-media-export-root-container.c"
		} else {
#line 173 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 1484 "rygel-media-export-root-container.c"
		}
#line 173 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		g_object_unref (_data_->_async_result);
#line 173 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		return FALSE;
#line 1490 "rygel-media-export-root-container.c"
	}
#line 130 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	_g_free0 (_data_->upnp_class);
#line 130 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	_g_object_unref0 (_data_->query_container);
#line 130 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	_g_object_unref0 (_data_->list);
#line 130 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	if (_data_->_state_ == 0) {
#line 130 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1502 "rygel-media-export-root-container.c"
	} else {
#line 130 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 1506 "rygel-media-export-root-container.c"
	}
#line 130 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	g_object_unref (_data_->_async_result);
#line 130 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	return FALSE;
#line 1512 "rygel-media-export-root-container.c"
}


static gchar* string_replace (const gchar* self, const gchar* old, const gchar* replacement) {
	gchar* result = NULL;
	GError * _inner_error_ = NULL;
#line 1382 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1382 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
	g_return_val_if_fail (old != NULL, NULL);
#line 1382 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
	g_return_val_if_fail (replacement != NULL, NULL);
#line 1525 "rygel-media-export-root-container.c"
	{
		const gchar* _tmp0_;
		gchar* _tmp1_ = NULL;
		gchar* _tmp2_;
		GRegex* _tmp3_;
		GRegex* _tmp4_;
		GRegex* regex;
		GRegex* _tmp5_;
		const gchar* _tmp6_;
		gchar* _tmp7_ = NULL;
		gchar* _tmp8_;
#line 1384 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
		_tmp0_ = old;
#line 1384 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
		_tmp1_ = g_regex_escape_string (_tmp0_, -1);
#line 1384 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
		_tmp2_ = _tmp1_;
#line 1384 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
		_tmp3_ = g_regex_new (_tmp2_, 0, 0, &_inner_error_);
#line 1384 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
		_tmp4_ = _tmp3_;
#line 1384 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
		_g_free0 (_tmp2_);
#line 1384 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
		regex = _tmp4_;
#line 1384 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
		if (_inner_error_ != NULL) {
#line 1384 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
			if (_inner_error_->domain == G_REGEX_ERROR) {
#line 1555 "rygel-media-export-root-container.c"
				goto __catch29_g_regex_error;
			}
#line 1384 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1384 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
			g_clear_error (&_inner_error_);
#line 1384 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
			return NULL;
#line 1564 "rygel-media-export-root-container.c"
		}
#line 1385 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
		_tmp5_ = regex;
#line 1385 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
		_tmp6_ = replacement;
#line 1385 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
		_tmp7_ = g_regex_replace_literal (_tmp5_, self, (gssize) (-1), 0, _tmp6_, 0, &_inner_error_);
#line 1385 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
		_tmp8_ = _tmp7_;
#line 1385 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
		if (_inner_error_ != NULL) {
#line 1385 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
			_g_regex_unref0 (regex);
#line 1385 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
			if (_inner_error_->domain == G_REGEX_ERROR) {
#line 1580 "rygel-media-export-root-container.c"
				goto __catch29_g_regex_error;
			}
#line 1385 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
			_g_regex_unref0 (regex);
#line 1385 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1385 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
			g_clear_error (&_inner_error_);
#line 1385 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
			return NULL;
#line 1591 "rygel-media-export-root-container.c"
		}
#line 1385 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
		result = _tmp8_;
#line 1385 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
		_g_regex_unref0 (regex);
#line 1385 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
		return result;
#line 1599 "rygel-media-export-root-container.c"
	}
	goto __finally29;
	__catch29_g_regex_error:
	{
		GError* e = NULL;
#line 1383 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
		e = _inner_error_;
#line 1383 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
		_inner_error_ = NULL;
#line 1387 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
		g_assert_not_reached ();
#line 1383 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
		_g_error_free0 (e);
#line 1613 "rygel-media-export-root-container.c"
	}
	__finally29:
#line 1383 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
	if (_inner_error_ != NULL) {
#line 1383 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1383 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
		g_clear_error (&_inner_error_);
#line 1383 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
		return NULL;
#line 1624 "rygel-media-export-root-container.c"
	}
}


static GeeArrayList* rygel_media_export_root_container_get_shared_uris (RygelMediaExportRootContainer* self) {
	GeeArrayList* result = NULL;
	GeeArrayList* uris = NULL;
	GeeArrayList* actual_uris = NULL;
	RygelMetaConfig* _tmp0_ = NULL;
	RygelMetaConfig* config;
	GeeArrayList* _tmp9_;
	const gchar* _tmp10_ = NULL;
	GFile* _tmp11_ = NULL;
	GFile* home_dir;
	const gchar* _tmp12_ = NULL;
	const gchar* pictures_dir;
	const gchar* _tmp13_ = NULL;
	const gchar* videos_dir;
	const gchar* _tmp14_ = NULL;
	const gchar* music_dir;
	GError * _inner_error_ = NULL;
#line 183 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 187 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	_tmp0_ = rygel_meta_config_get_default ();
#line 187 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	config = _tmp0_;
#line 1652 "rygel-media-export-root-container.c"
	{
		GeeArrayList* _tmp1_ = NULL;
		GeeArrayList* _tmp2_;
#line 190 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		_tmp1_ = rygel_configuration_get_string_list ((RygelConfiguration*) config, "MediaExport", "uris", &_inner_error_);
#line 190 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		_tmp2_ = _tmp1_;
#line 190 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		if (_inner_error_ != NULL) {
#line 1662 "rygel-media-export-root-container.c"
			goto __catch27_g_error;
		}
#line 190 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		_g_object_unref0 (uris);
#line 190 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		uris = _tmp2_;
#line 1669 "rygel-media-export-root-container.c"
	}
	goto __finally27;
	__catch27_g_error:
	{
		GError* _error_ = NULL;
		GeeArrayList* _tmp3_;
#line 189 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		_error_ = _inner_error_;
#line 189 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		_inner_error_ = NULL;
#line 192 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		_tmp3_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL);
#line 192 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		_g_object_unref0 (uris);
#line 192 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		uris = _tmp3_;
#line 189 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		_g_error_free0 (_error_);
#line 1688 "rygel-media-export-root-container.c"
	}
	__finally27:
#line 189 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	if (_inner_error_ != NULL) {
#line 189 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		_g_object_unref0 (config);
#line 189 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		_g_object_unref0 (actual_uris);
#line 189 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		_g_object_unref0 (uris);
#line 189 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 189 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		g_clear_error (&_inner_error_);
#line 189 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		return NULL;
#line 1705 "rygel-media-export-root-container.c"
	}
	{
		RygelMediaExportMediaCache* _tmp4_;
		GeeList* _tmp5_ = NULL;
		GeeList* _tmp6_;
		GeeArrayList* _tmp7_;
		GeeList* _tmp8_;
#line 196 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		_tmp4_ = ((RygelMediaExportDBContainer*) self)->media_db;
#line 196 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		_tmp5_ = rygel_media_export_media_cache_get_flagged_uris (_tmp4_, "DBUS", &_inner_error_);
#line 196 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		_tmp6_ = _tmp5_;
#line 196 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		if (_inner_error_ != NULL) {
#line 1721 "rygel-media-export-root-container.c"
			goto __catch28_g_error;
		}
#line 196 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		_tmp7_ = uris;
#line 196 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		_tmp8_ = _tmp6_;
#line 196 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		gee_abstract_collection_add_all ((GeeAbstractCollection*) _tmp7_, (GeeCollection*) _tmp8_);
#line 196 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		_g_object_unref0 (_tmp8_);
#line 1732 "rygel-media-export-root-container.c"
	}
	goto __finally28;
	__catch28_g_error:
	{
		GError* _error_ = NULL;
#line 195 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		_error_ = _inner_error_;
#line 195 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		_inner_error_ = NULL;
#line 195 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		_g_error_free0 (_error_);
#line 1744 "rygel-media-export-root-container.c"
	}
	__finally28:
#line 195 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	if (_inner_error_ != NULL) {
#line 195 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		_g_object_unref0 (config);
#line 195 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		_g_object_unref0 (actual_uris);
#line 195 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		_g_object_unref0 (uris);
#line 195 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 195 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		g_clear_error (&_inner_error_);
#line 195 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		return NULL;
#line 1761 "rygel-media-export-root-container.c"
	}
#line 199 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	_tmp9_ = gee_array_list_new (G_TYPE_FILE, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL);
#line 199 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	_g_object_unref0 (actual_uris);
#line 199 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	actual_uris = _tmp9_;
#line 201 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	_tmp10_ = g_get_home_dir ();
#line 201 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	_tmp11_ = g_file_new_for_path (_tmp10_);
#line 201 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	home_dir = _tmp11_;
#line 202 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	_tmp12_ = g_get_user_special_dir (G_USER_DIRECTORY_PICTURES);
#line 202 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	pictures_dir = _tmp12_;
#line 204 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	_tmp13_ = g_get_user_special_dir (G_USER_DIRECTORY_VIDEOS);
#line 204 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	videos_dir = _tmp13_;
#line 206 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	_tmp14_ = g_get_user_special_dir (G_USER_DIRECTORY_MUSIC);
#line 206 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	music_dir = _tmp14_;
#line 1787 "rygel-media-export-root-container.c"
	{
		GeeArrayList* _tmp15_;
		GeeArrayList* _tmp16_;
		GeeArrayList* _uri_list;
		GeeArrayList* _tmp17_;
		gint _tmp18_;
		gint _tmp19_;
		gint _uri_size;
		gint _uri_index;
#line 209 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		_tmp15_ = uris;
#line 209 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		_tmp16_ = _g_object_ref0 (_tmp15_);
#line 209 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		_uri_list = _tmp16_;
#line 209 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		_tmp17_ = _uri_list;
#line 209 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		_tmp18_ = gee_collection_get_size ((GeeCollection*) _tmp17_);
#line 209 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		_tmp19_ = _tmp18_;
#line 209 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		_uri_size = _tmp19_;
#line 209 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		_uri_index = -1;
#line 209 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		while (TRUE) {
#line 1815 "rygel-media-export-root-container.c"
			gint _tmp20_;
			gint _tmp21_;
			gint _tmp22_;
			GeeArrayList* _tmp23_;
			gint _tmp24_;
			gpointer _tmp25_ = NULL;
			gchar* uri;
			const gchar* _tmp26_;
			GFile* _tmp27_ = NULL;
			GFile* file;
			GFile* _tmp28_;
			GFile* _tmp29_;
			gboolean _tmp30_ = FALSE;
			GeeArrayList* _tmp52_;
			GFile* _tmp53_;
#line 209 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
			_tmp20_ = _uri_index;
#line 209 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
			_uri_index = _tmp20_ + 1;
#line 209 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
			_tmp21_ = _uri_index;
#line 209 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
			_tmp22_ = _uri_size;
#line 209 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
			if (!(_tmp21_ < _tmp22_)) {
#line 209 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
				break;
#line 1843 "rygel-media-export-root-container.c"
			}
#line 209 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
			_tmp23_ = _uri_list;
#line 209 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
			_tmp24_ = _uri_index;
#line 209 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
			_tmp25_ = gee_abstract_list_get ((GeeAbstractList*) _tmp23_, _tmp24_);
#line 209 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
			uri = (gchar*) _tmp25_;
#line 210 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
			_tmp26_ = uri;
#line 210 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
			_tmp27_ = g_file_new_for_commandline_arg (_tmp26_);
#line 210 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
			file = _tmp27_;
#line 211 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
			_tmp28_ = file;
#line 211 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
			_tmp29_ = home_dir;
#line 211 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
			_tmp30_ = G_LIKELY (_tmp28_ != _tmp29_);
#line 211 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
			if (_tmp30_) {
#line 1867 "rygel-media-export-root-container.c"
				const gchar* _tmp31_;
				gchar* _tmp32_;
				gchar* actual_uri;
				const gchar* _tmp33_;
				gboolean _tmp34_ = FALSE;
				const gchar* _tmp38_;
				gboolean _tmp39_ = FALSE;
				const gchar* _tmp43_;
				gboolean _tmp44_ = FALSE;
				const gchar* _tmp48_;
				GFile* _tmp49_ = NULL;
				GFile* _tmp50_;
				GFile* _tmp51_;
#line 212 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
				_tmp31_ = uri;
#line 212 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
				_tmp32_ = g_strdup (_tmp31_);
#line 212 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
				actual_uri = _tmp32_;
#line 214 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
				_tmp33_ = pictures_dir;
#line 214 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
				_tmp34_ = G_LIKELY (_tmp33_ != NULL);
#line 214 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
				if (_tmp34_) {
#line 1893 "rygel-media-export-root-container.c"
					const gchar* _tmp35_;
					const gchar* _tmp36_;
					gchar* _tmp37_ = NULL;
#line 215 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
					_tmp35_ = actual_uri;
#line 215 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
					_tmp36_ = pictures_dir;
#line 215 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
					_tmp37_ = string_replace (_tmp35_, "@PICTURES@", _tmp36_);
#line 215 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
					_g_free0 (actual_uri);
#line 215 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
					actual_uri = _tmp37_;
#line 1907 "rygel-media-export-root-container.c"
				}
#line 217 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
				_tmp38_ = videos_dir;
#line 217 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
				_tmp39_ = G_LIKELY (_tmp38_ != NULL);
#line 217 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
				if (_tmp39_) {
#line 1915 "rygel-media-export-root-container.c"
					const gchar* _tmp40_;
					const gchar* _tmp41_;
					gchar* _tmp42_ = NULL;
#line 218 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
					_tmp40_ = actual_uri;
#line 218 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
					_tmp41_ = videos_dir;
#line 218 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
					_tmp42_ = string_replace (_tmp40_, "@VIDEOS@", _tmp41_);
#line 218 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
					_g_free0 (actual_uri);
#line 218 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
					actual_uri = _tmp42_;
#line 1929 "rygel-media-export-root-container.c"
				}
#line 220 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
				_tmp43_ = music_dir;
#line 220 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
				_tmp44_ = G_LIKELY (_tmp43_ != NULL);
#line 220 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
				if (_tmp44_) {
#line 1937 "rygel-media-export-root-container.c"
					const gchar* _tmp45_;
					const gchar* _tmp46_;
					gchar* _tmp47_ = NULL;
#line 221 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
					_tmp45_ = actual_uri;
#line 221 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
					_tmp46_ = music_dir;
#line 221 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
					_tmp47_ = string_replace (_tmp45_, "@MUSIC@", _tmp46_);
#line 221 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
					_g_free0 (actual_uri);
#line 221 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
					actual_uri = _tmp47_;
#line 1951 "rygel-media-export-root-container.c"
				}
#line 225 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
				_tmp48_ = actual_uri;
#line 225 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
				_tmp49_ = g_file_new_for_commandline_arg (_tmp48_);
#line 225 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
				_g_object_unref0 (file);
#line 225 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
				file = _tmp49_;
#line 226 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
				_tmp50_ = file;
#line 226 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
				_tmp51_ = home_dir;
#line 226 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
				if (_tmp50_ == _tmp51_) {
#line 227 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
					_g_free0 (actual_uri);
#line 227 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
					_g_object_unref0 (file);
#line 227 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
					_g_free0 (uri);
#line 227 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
					continue;
#line 1975 "rygel-media-export-root-container.c"
				}
#line 211 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
				_g_free0 (actual_uri);
#line 1979 "rygel-media-export-root-container.c"
			}
#line 231 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
			_tmp52_ = actual_uris;
#line 231 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
			_tmp53_ = file;
#line 231 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp52_, _tmp53_);
#line 209 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
			_g_object_unref0 (file);
#line 209 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
			_g_free0 (uri);
#line 1991 "rygel-media-export-root-container.c"
		}
#line 209 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		_g_object_unref0 (_uri_list);
#line 1995 "rygel-media-export-root-container.c"
	}
#line 234 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	result = actual_uris;
#line 234 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	_g_object_unref0 (home_dir);
#line 234 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	_g_object_unref0 (config);
#line 234 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	_g_object_unref0 (uris);
#line 234 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	return result;
#line 2007 "rygel-media-export-root-container.c"
}


static RygelMediaExportQueryContainer* rygel_media_export_root_container_search_to_virtual_container (RygelMediaExportRootContainer* self, RygelRelationalExpression* expression) {
	RygelMediaExportQueryContainer* result = NULL;
	gboolean _tmp0_ = FALSE;
	RygelRelationalExpression* _tmp1_;
	gconstpointer _tmp2_;
	gboolean _tmp5_;
#line 237 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 237 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	g_return_val_if_fail (expression != NULL, NULL);
#line 239 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	_tmp1_ = expression;
#line 239 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	_tmp2_ = ((RygelSearchExpression*) _tmp1_)->operand1;
#line 239 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	if (g_strcmp0 ((const gchar*) _tmp2_, "upnp:class") == 0) {
#line 2027 "rygel-media-export-root-container.c"
		RygelRelationalExpression* _tmp3_;
		gconstpointer _tmp4_;
#line 240 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		_tmp3_ = expression;
#line 240 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		_tmp4_ = ((RygelSearchExpression*) _tmp3_)->op;
#line 240 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		_tmp0_ = GPOINTER_TO_INT (_tmp4_) == GUPNP_SEARCH_CRITERIA_OP_EQ;
#line 2036 "rygel-media-export-root-container.c"
	} else {
#line 239 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		_tmp0_ = FALSE;
#line 2040 "rygel-media-export-root-container.c"
	}
#line 239 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	_tmp5_ = _tmp0_;
#line 239 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	if (_tmp5_) {
#line 2046 "rygel-media-export-root-container.c"
		gchar* _tmp6_;
		gchar* id;
		RygelRelationalExpression* _tmp7_;
		gconstpointer _tmp8_;
		const gchar* _tmp9_;
		GQuark _tmp11_ = 0U;
#line 242 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		static GQuark _tmp10_label0 = 0;
#line 242 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		static GQuark _tmp10_label1 = 0;
#line 242 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		static GQuark _tmp10_label2 = 0;
#line 2059 "rygel-media-export-root-container.c"
		RygelMediaExportMediaCache* _tmp18_;
		const gchar* _tmp19_;
		RygelMediaExportQueryContainer* _tmp20_;
#line 241 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		_tmp6_ = g_strdup (RYGEL_MEDIA_EXPORT_QUERY_CONTAINER_PREFIX);
#line 241 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		id = _tmp6_;
#line 242 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		_tmp7_ = expression;
#line 242 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		_tmp8_ = ((RygelSearchExpression*) _tmp7_)->operand2;
#line 242 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		_tmp9_ = (const gchar*) _tmp8_;
#line 242 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		_tmp11_ = (NULL == _tmp9_) ? 0 : g_quark_from_string (_tmp9_);
#line 242 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		if (_tmp11_ == ((0 != _tmp10_label0) ? _tmp10_label0 : (_tmp10_label0 = g_quark_from_static_string ("object.container.album.musicAlbum")))) {
#line 242 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
			switch (0) {
#line 2079 "rygel-media-export-root-container.c"
				default:
				{
					const gchar* _tmp12_;
					gchar* _tmp13_;
#line 244 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
					_tmp12_ = id;
#line 244 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
					_tmp13_ = g_strconcat (_tmp12_, "upnp:album,?", NULL);
#line 244 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
					_g_free0 (id);
#line 244 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
					id = _tmp13_;
#line 246 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
					break;
#line 2094 "rygel-media-export-root-container.c"
				}
			}
		} else if (_tmp11_ == ((0 != _tmp10_label1) ? _tmp10_label1 : (_tmp10_label1 = g_quark_from_static_string ("object.container.person.musicArtist")))) {
#line 242 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
			switch (0) {
#line 2100 "rygel-media-export-root-container.c"
				default:
				{
					const gchar* _tmp14_;
					gchar* _tmp15_;
#line 248 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
					_tmp14_ = id;
#line 248 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
					_tmp15_ = g_strconcat (_tmp14_, "dc:creator,?,upnp:album,?", NULL);
#line 248 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
					_g_free0 (id);
#line 248 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
					id = _tmp15_;
#line 250 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
					break;
#line 2115 "rygel-media-export-root-container.c"
				}
			}
		} else if (_tmp11_ == ((0 != _tmp10_label2) ? _tmp10_label2 : (_tmp10_label2 = g_quark_from_static_string ("object.container.genre.musicGenre")))) {
#line 242 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
			switch (0) {
#line 2121 "rygel-media-export-root-container.c"
				default:
				{
					const gchar* _tmp16_;
					gchar* _tmp17_;
#line 252 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
					_tmp16_ = id;
#line 252 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
					_tmp17_ = g_strconcat (_tmp16_, "dc:genre,?", NULL);
#line 252 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
					_g_free0 (id);
#line 252 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
					id = _tmp17_;
#line 254 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
					break;
#line 2136 "rygel-media-export-root-container.c"
				}
			}
		} else {
#line 242 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
			switch (0) {
#line 2142 "rygel-media-export-root-container.c"
				default:
				{
#line 256 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
					result = NULL;
#line 256 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
					_g_free0 (id);
#line 256 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
					return result;
#line 2151 "rygel-media-export-root-container.c"
				}
			}
		}
#line 259 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		rygel_media_export_query_container_register_id (&id);
#line 261 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		_tmp18_ = ((RygelMediaExportDBContainer*) self)->media_db;
#line 261 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		_tmp19_ = id;
#line 261 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		_tmp20_ = rygel_media_export_query_container_new (_tmp18_, _tmp19_, "");
#line 261 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		result = _tmp20_;
#line 261 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		_g_free0 (id);
#line 261 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		return result;
#line 2169 "rygel-media-export-root-container.c"
	}
#line 264 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	result = NULL;
#line 264 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	return result;
#line 2175 "rygel-media-export-root-container.c"
}


/**
     * Check if a passed search expression is a simple search in a virtual
     * container.
     *
     * @param expression the expression to check
     * @param new_id contains the id of the virtual container constructed from
     *               the search
     * @param upnp_class contains the class of the container the search was
     *                   looking in
     * @return true if it was a search in virtual container, false otherwise.
     * @note This works single level only. Enough to satisfy Xbox music
     *       browsing, but may need refinement
     */
static gboolean rygel_media_export_root_container_is_search_in_virtual_container (RygelMediaExportRootContainer* self, RygelSearchExpression* expression, RygelMediaContainer** container) {
	RygelMediaContainer* _vala_container = NULL;
	gboolean result = FALSE;
	RygelRelationalExpression* virtual_expression;
	RygelMediaExportQueryContainer* query_container = NULL;
	RygelSearchExpression* _tmp0_;
	RygelSearchExpression* _tmp1_;
	RygelLogicalExpression* _tmp2_;
	RygelLogicalExpression* logical_expression;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	RygelLogicalExpression* _tmp5_;
	gconstpointer _tmp6_;
	gboolean _tmp9_;
	gboolean _tmp12_;
	RygelLogicalExpression* _tmp13_;
	gconstpointer _tmp14_;
	RygelRelationalExpression* _tmp15_;
	RygelRelationalExpression* left_expression;
	RygelLogicalExpression* _tmp16_;
	gconstpointer _tmp17_;
	RygelRelationalExpression* _tmp18_;
	RygelRelationalExpression* right_expression;
	RygelRelationalExpression* _tmp19_;
	RygelMediaExportQueryContainer* _tmp20_ = NULL;
	RygelMediaExportQueryContainer* _tmp21_;
	RygelMediaExportQueryContainer* _tmp29_;
	const gchar* _tmp30_;
	gchar* _tmp31_ = NULL;
	gchar* last_argument;
	RygelRelationalExpression* _tmp32_;
	gconstpointer _tmp33_;
	gchar* _tmp34_ = NULL;
	gchar* escaped_detail;
	RygelRelationalExpression* _tmp35_;
	gconstpointer _tmp36_;
	const gchar* _tmp37_;
	const gchar* _tmp38_;
	gchar* _tmp39_ = NULL;
	gchar* new_id;
	RygelMediaExportMediaCache* _tmp40_;
	const gchar* _tmp41_;
	RygelMediaExportQueryContainer* _tmp42_;
#line 280 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 280 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	g_return_val_if_fail (expression != NULL, FALSE);
#line 282 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	virtual_expression = NULL;
#line 285 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	_g_object_unref0 (_vala_container);
#line 285 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	_vala_container = NULL;
#line 287 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	_tmp0_ = expression;
#line 287 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	if (!RYGEL_IS_LOGICAL_EXPRESSION (_tmp0_)) {
#line 288 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		result = FALSE;
#line 288 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		_g_object_unref0 (query_container);
#line 288 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		_rygel_search_expression_unref0 (virtual_expression);
#line 288 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		if (container) {
#line 288 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
			*container = _vala_container;
#line 2259 "rygel-media-export-root-container.c"
		} else {
#line 288 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
			_g_object_unref0 (_vala_container);
#line 2263 "rygel-media-export-root-container.c"
		}
#line 288 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		return result;
#line 2267 "rygel-media-export-root-container.c"
	}
#line 291 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	_tmp1_ = expression;
#line 291 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	_tmp2_ = _rygel_search_expression_ref0 (RYGEL_IS_LOGICAL_EXPRESSION (_tmp1_) ? ((RygelLogicalExpression*) _tmp1_) : NULL);
#line 291 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	logical_expression = _tmp2_;
#line 293 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	_tmp5_ = logical_expression;
#line 293 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	_tmp6_ = ((RygelSearchExpression*) _tmp5_)->operand1;
#line 293 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	if (RYGEL_IS_RELATIONAL_EXPRESSION ((RygelSearchExpression*) _tmp6_)) {
#line 2281 "rygel-media-export-root-container.c"
		RygelLogicalExpression* _tmp7_;
		gconstpointer _tmp8_;
#line 294 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		_tmp7_ = logical_expression;
#line 294 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		_tmp8_ = ((RygelSearchExpression*) _tmp7_)->operand2;
#line 294 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		_tmp4_ = RYGEL_IS_RELATIONAL_EXPRESSION ((RygelSearchExpression*) _tmp8_);
#line 2290 "rygel-media-export-root-container.c"
	} else {
#line 293 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		_tmp4_ = FALSE;
#line 2294 "rygel-media-export-root-container.c"
	}
#line 293 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	_tmp9_ = _tmp4_;
#line 293 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	if (_tmp9_) {
#line 2300 "rygel-media-export-root-container.c"
		RygelLogicalExpression* _tmp10_;
		gconstpointer _tmp11_;
#line 295 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		_tmp10_ = logical_expression;
#line 295 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		_tmp11_ = ((RygelSearchExpression*) _tmp10_)->op;
#line 295 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		_tmp3_ = GPOINTER_TO_INT (_tmp11_) == RYGEL_LOGICAL_OPERATOR_AND;
#line 2309 "rygel-media-export-root-container.c"
	} else {
#line 293 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		_tmp3_ = FALSE;
#line 2313 "rygel-media-export-root-container.c"
	}
#line 293 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	_tmp12_ = _tmp3_;
#line 293 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	if (!_tmp12_) {
#line 297 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		result = FALSE;
#line 297 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		_rygel_search_expression_unref0 (logical_expression);
#line 297 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		_g_object_unref0 (query_container);
#line 297 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		_rygel_search_expression_unref0 (virtual_expression);
#line 297 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		if (container) {
#line 297 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
			*container = _vala_container;
#line 2331 "rygel-media-export-root-container.c"
		} else {
#line 297 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
			_g_object_unref0 (_vala_container);
#line 2335 "rygel-media-export-root-container.c"
		}
#line 297 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		return result;
#line 2339 "rygel-media-export-root-container.c"
	}
#line 300 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	_tmp13_ = logical_expression;
#line 300 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	_tmp14_ = ((RygelSearchExpression*) _tmp13_)->operand1;
#line 300 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	_tmp15_ = _rygel_search_expression_ref0 (RYGEL_IS_RELATIONAL_EXPRESSION ((RygelSearchExpression*) _tmp14_) ? ((RygelRelationalExpression*) ((RygelSearchExpression*) _tmp14_)) : NULL);
#line 300 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	left_expression = _tmp15_;
#line 301 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	_tmp16_ = logical_expression;
#line 301 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	_tmp17_ = ((RygelSearchExpression*) _tmp16_)->operand2;
#line 301 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	_tmp18_ = _rygel_search_expression_ref0 (RYGEL_IS_RELATIONAL_EXPRESSION ((RygelSearchExpression*) _tmp17_) ? ((RygelRelationalExpression*) ((RygelSearchExpression*) _tmp17_)) : NULL);
#line 301 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	right_expression = _tmp18_;
#line 303 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	_tmp19_ = left_expression;
#line 303 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	_tmp20_ = rygel_media_export_root_container_search_to_virtual_container (self, _tmp19_);
#line 303 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	_g_object_unref0 (query_container);
#line 303 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	query_container = _tmp20_;
#line 304 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	_tmp21_ = query_container;
#line 304 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	if (_tmp21_ == NULL) {
#line 2369 "rygel-media-export-root-container.c"
		RygelRelationalExpression* _tmp22_;
		RygelMediaExportQueryContainer* _tmp23_ = NULL;
		RygelMediaExportQueryContainer* _tmp24_;
#line 305 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		_tmp22_ = right_expression;
#line 305 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		_tmp23_ = rygel_media_export_root_container_search_to_virtual_container (self, _tmp22_);
#line 305 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		_g_object_unref0 (query_container);
#line 305 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		query_container = _tmp23_;
#line 306 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		_tmp24_ = query_container;
#line 306 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		if (_tmp24_ != NULL) {
#line 2385 "rygel-media-export-root-container.c"
			RygelRelationalExpression* _tmp25_;
			RygelRelationalExpression* _tmp26_;
#line 307 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
			_tmp25_ = left_expression;
#line 307 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
			_tmp26_ = _rygel_search_expression_ref0 (_tmp25_);
#line 307 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
			_rygel_search_expression_unref0 (virtual_expression);
#line 307 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
			virtual_expression = _tmp26_;
#line 2396 "rygel-media-export-root-container.c"
		} else {
#line 309 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
			result = FALSE;
#line 309 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
			_rygel_search_expression_unref0 (right_expression);
#line 309 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
			_rygel_search_expression_unref0 (left_expression);
#line 309 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
			_rygel_search_expression_unref0 (logical_expression);
#line 309 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
			_g_object_unref0 (query_container);
#line 309 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
			_rygel_search_expression_unref0 (virtual_expression);
#line 309 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
			if (container) {
#line 309 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
				*container = _vala_container;
#line 2414 "rygel-media-export-root-container.c"
			} else {
#line 309 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
				_g_object_unref0 (_vala_container);
#line 2418 "rygel-media-export-root-container.c"
			}
#line 309 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
			return result;
#line 2422 "rygel-media-export-root-container.c"
		}
	} else {
		RygelRelationalExpression* _tmp27_;
		RygelRelationalExpression* _tmp28_;
#line 312 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		_tmp27_ = right_expression;
#line 312 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		_tmp28_ = _rygel_search_expression_ref0 (_tmp27_);
#line 312 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		_rygel_search_expression_unref0 (virtual_expression);
#line 312 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		virtual_expression = _tmp28_;
#line 2435 "rygel-media-export-root-container.c"
	}
#line 315 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	_tmp29_ = query_container;
#line 315 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	_tmp30_ = _tmp29_->plaintext_id;
#line 315 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	_tmp31_ = string_replace (_tmp30_, RYGEL_MEDIA_EXPORT_QUERY_CONTAINER_PREFIX, "");
#line 315 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	last_argument = _tmp31_;
#line 318 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	_tmp32_ = virtual_expression;
#line 318 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	_tmp33_ = ((RygelSearchExpression*) _tmp32_)->operand2;
#line 318 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	_tmp34_ = g_uri_escape_string ((const gchar*) _tmp33_, "", TRUE);
#line 318 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	escaped_detail = _tmp34_;
#line 321 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	_tmp35_ = virtual_expression;
#line 321 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	_tmp36_ = ((RygelSearchExpression*) _tmp35_)->operand1;
#line 321 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	_tmp37_ = escaped_detail;
#line 321 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	_tmp38_ = last_argument;
#line 321 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	_tmp39_ = g_strdup_printf ("%s%s,%s,%s", RYGEL_MEDIA_EXPORT_QUERY_CONTAINER_PREFIX, (const gchar*) _tmp36_, _tmp37_, _tmp38_);
#line 321 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	new_id = _tmp39_;
#line 326 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	rygel_media_export_query_container_register_id (&new_id);
#line 327 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	_tmp40_ = ((RygelMediaExportDBContainer*) self)->media_db;
#line 327 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	_tmp41_ = new_id;
#line 327 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	_tmp42_ = rygel_media_export_query_container_new (_tmp40_, _tmp41_, "");
#line 327 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	_g_object_unref0 (_vala_container);
#line 327 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	_vala_container = (RygelMediaContainer*) _tmp42_;
#line 329 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	result = TRUE;
#line 329 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	_g_free0 (new_id);
#line 329 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	_g_free0 (escaped_detail);
#line 329 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	_g_free0 (last_argument);
#line 329 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	_rygel_search_expression_unref0 (right_expression);
#line 329 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	_rygel_search_expression_unref0 (left_expression);
#line 329 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	_rygel_search_expression_unref0 (logical_expression);
#line 329 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	_g_object_unref0 (query_container);
#line 329 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	_rygel_search_expression_unref0 (virtual_expression);
#line 329 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	if (container) {
#line 329 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		*container = _vala_container;
#line 2499 "rygel-media-export-root-container.c"
	} else {
#line 329 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		_g_object_unref0 (_vala_container);
#line 2503 "rygel-media-export-root-container.c"
	}
#line 329 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	return result;
#line 2507 "rygel-media-export-root-container.c"
}


/**
     * Create a new root container.
     */
static void _rygel_media_export_root_container_on_initial_harvesting_done_rygel_media_export_harvester_done (RygelMediaExportHarvester* _sender, gpointer self) {
#line 371 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	rygel_media_export_root_container_on_initial_harvesting_done (self);
#line 2517 "rygel-media-export-root-container.c"
}


static RygelMediaExportRootContainer* rygel_media_export_root_container_construct (GType object_type, GError** error) {
	RygelMediaExportRootContainer * self = NULL;
	RygelMediaExportMediaCache* _tmp0_ = NULL;
	RygelMediaExportMediaCache* db;
	const gchar* _tmp1_ = NULL;
	GCancellable* _tmp2_;
	GCancellable* _tmp3_;
	RygelMediaExportHarvester* _tmp4_;
	GeeArrayList* ids = NULL;
	RygelMediaExportHarvester* _tmp20_;
	gulong _tmp21_ = 0UL;
	GError * _inner_error_ = NULL;
#line 337 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	_tmp0_ = rygel_media_export_media_cache_get_default (&_inner_error_);
#line 337 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	db = _tmp0_;
#line 337 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	if (_inner_error_ != NULL) {
#line 337 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		g_propagate_error (error, _inner_error_);
#line 337 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		_g_object_unref0 (self);
#line 337 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		return NULL;
#line 2545 "rygel-media-export-root-container.c"
	}
#line 339 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	_tmp1_ = _ ("@REALNAME@'s media");
#line 339 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	self = (RygelMediaExportRootContainer*) rygel_media_export_db_container_construct (object_type, db, "0", _tmp1_);
#line 341 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	_tmp2_ = g_cancellable_new ();
#line 341 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	_g_object_unref0 (self->priv->cancellable);
#line 341 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	self->priv->cancellable = _tmp2_;
#line 342 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	_tmp3_ = self->priv->cancellable;
#line 342 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	_tmp4_ = rygel_media_export_harvester_new (_tmp3_);
#line 342 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	_g_object_unref0 (self->priv->harvester);
#line 342 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	self->priv->harvester = _tmp4_;
#line 2565 "rygel-media-export-root-container.c"
	{
		RygelMediaExportDBusService* _tmp5_;
		RygelMediaExportDBusService* _tmp6_;
#line 345 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		_tmp5_ = rygel_media_export_dbus_service_new (self, &_inner_error_);
#line 345 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		_tmp6_ = _tmp5_;
#line 345 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		if (_inner_error_ != NULL) {
#line 2575 "rygel-media-export-root-container.c"
			goto __catch30_g_error;
		}
#line 345 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		_g_object_unref0 (self->priv->service);
#line 345 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		self->priv->service = _tmp6_;
#line 2582 "rygel-media-export-root-container.c"
	}
	goto __finally30;
	__catch30_g_error:
	{
		GError* err = NULL;
		const gchar* _tmp7_ = NULL;
		GError* _tmp8_;
		const gchar* _tmp9_;
#line 344 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		err = _inner_error_;
#line 344 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		_inner_error_ = NULL;
#line 347 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		_tmp7_ = _ ("Failed to create MediaExport D-Bus service: %s");
#line 347 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		_tmp8_ = err;
#line 347 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		_tmp9_ = _tmp8_->message;
#line 347 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		g_warning (_tmp7_, _tmp9_);
#line 344 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		_g_error_free0 (err);
#line 2605 "rygel-media-export-root-container.c"
	}
	__finally30:
#line 344 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	if (_inner_error_ != NULL) {
#line 344 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		g_propagate_error (error, _inner_error_);
#line 344 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		_g_object_unref0 (db);
#line 344 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		_g_object_unref0 (self);
#line 344 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		return NULL;
#line 2618 "rygel-media-export-root-container.c"
	}
	{
		RygelMediaExportMediaCache* _tmp10_;
#line 352 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		_tmp10_ = ((RygelMediaExportDBContainer*) self)->media_db;
#line 352 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		rygel_media_export_media_cache_save_container (_tmp10_, (RygelMediaContainer*) self, &_inner_error_);
#line 352 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		if (_inner_error_ != NULL) {
#line 2628 "rygel-media-export-root-container.c"
			goto __catch31_g_error;
		}
	}
	goto __finally31;
	__catch31_g_error:
	{
		GError* _error_ = NULL;
#line 351 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		_error_ = _inner_error_;
#line 351 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		_inner_error_ = NULL;
#line 351 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		_g_error_free0 (_error_);
#line 2642 "rygel-media-export-root-container.c"
	}
	__finally31:
#line 351 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	if (_inner_error_ != NULL) {
#line 351 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		g_propagate_error (error, _inner_error_);
#line 351 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		_g_object_unref0 (db);
#line 351 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		_g_object_unref0 (self);
#line 351 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		return NULL;
#line 2655 "rygel-media-export-root-container.c"
	}
	{
		RygelMediaExportMediaCache* _tmp11_;
		RygelMediaExportDBContainer* _tmp12_;
		RygelMediaContainer* _tmp13_;
		RygelMediaExportMediaCache* _tmp14_;
		RygelMediaContainer* _tmp15_;
#line 356 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		_tmp11_ = ((RygelMediaExportDBContainer*) self)->media_db;
#line 356 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		_tmp12_ = rygel_media_export_db_container_new (_tmp11_, RYGEL_MEDIA_EXPORT_ROOT_CONTAINER_FILESYSTEM_FOLDER_ID, RYGEL_MEDIA_EXPORT_ROOT_CONTAINER_FILESYSTEM_FOLDER_NAME);
#line 356 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		_g_object_unref0 (self->priv->filesystem_container);
#line 356 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		self->priv->filesystem_container = (RygelMediaContainer*) _tmp12_;
#line 360 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		_tmp13_ = self->priv->filesystem_container;
#line 360 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		((RygelMediaObject*) _tmp13_)->parent = (RygelMediaContainer*) self;
#line 361 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		_tmp14_ = ((RygelMediaExportDBContainer*) self)->media_db;
#line 361 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		_tmp15_ = self->priv->filesystem_container;
#line 361 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		rygel_media_export_media_cache_save_container (_tmp14_, _tmp15_, &_inner_error_);
#line 361 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		if (_inner_error_ != NULL) {
#line 2683 "rygel-media-export-root-container.c"
			goto __catch32_g_error;
		}
	}
	goto __finally32;
	__catch32_g_error:
	{
		GError* _error_ = NULL;
#line 355 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		_error_ = _inner_error_;
#line 355 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		_inner_error_ = NULL;
#line 355 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		_g_error_free0 (_error_);
#line 2697 "rygel-media-export-root-container.c"
	}
	__finally32:
#line 355 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	if (_inner_error_ != NULL) {
#line 355 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		g_propagate_error (error, _inner_error_);
#line 355 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		_g_object_unref0 (db);
#line 355 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		_g_object_unref0 (self);
#line 355 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		return NULL;
#line 2710 "rygel-media-export-root-container.c"
	}
	{
		RygelMediaExportMediaCache* _tmp16_;
		GeeArrayList* _tmp17_ = NULL;
		GeeArrayList* _tmp18_;
#line 366 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		_tmp16_ = ((RygelMediaExportDBContainer*) self)->media_db;
#line 366 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		_tmp17_ = rygel_media_export_media_cache_get_child_ids (_tmp16_, RYGEL_MEDIA_EXPORT_ROOT_CONTAINER_FILESYSTEM_FOLDER_ID, &_inner_error_);
#line 366 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		_tmp18_ = _tmp17_;
#line 366 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		if (_inner_error_ != NULL) {
#line 366 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
			if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
#line 2726 "rygel-media-export-root-container.c"
				goto __catch33_rygel_media_export_database_error;
			}
#line 366 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
			_g_object_unref0 (ids);
#line 366 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
			_g_object_unref0 (db);
#line 366 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 366 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
			g_clear_error (&_inner_error_);
#line 366 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
			return NULL;
#line 2739 "rygel-media-export-root-container.c"
		}
#line 366 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		_g_object_unref0 (ids);
#line 366 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		ids = _tmp18_;
#line 2745 "rygel-media-export-root-container.c"
	}
	goto __finally33;
	__catch33_rygel_media_export_database_error:
	{
		GError* e = NULL;
		GeeArrayList* _tmp19_;
#line 365 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		e = _inner_error_;
#line 365 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		_inner_error_ = NULL;
#line 368 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		_tmp19_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL);
#line 368 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		_g_object_unref0 (ids);
#line 368 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		ids = _tmp19_;
#line 365 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		_g_error_free0 (e);
#line 2764 "rygel-media-export-root-container.c"
	}
	__finally33:
#line 365 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	if (_inner_error_ != NULL) {
#line 365 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		g_propagate_error (error, _inner_error_);
#line 365 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		_g_object_unref0 (ids);
#line 365 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		_g_object_unref0 (db);
#line 365 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		_g_object_unref0 (self);
#line 365 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		return NULL;
#line 2779 "rygel-media-export-root-container.c"
	}
#line 371 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	_tmp20_ = self->priv->harvester;
#line 371 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	_tmp21_ = g_signal_connect_object (_tmp20_, "done", (GCallback) _rygel_media_export_root_container_on_initial_harvesting_done_rygel_media_export_harvester_done, self, 0);
#line 371 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	self->priv->harvester_signal_id = _tmp21_;
#line 2787 "rygel-media-export-root-container.c"
	{
		GeeArrayList* _tmp22_ = NULL;
		GeeArrayList* _file_list;
		GeeArrayList* _tmp23_;
		gint _tmp24_;
		gint _tmp25_;
		gint _file_size;
		gint _file_index;
#line 374 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		_tmp22_ = rygel_media_export_root_container_get_shared_uris (self);
#line 374 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		_file_list = _tmp22_;
#line 374 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		_tmp23_ = _file_list;
#line 374 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		_tmp24_ = gee_collection_get_size ((GeeCollection*) _tmp23_);
#line 374 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		_tmp25_ = _tmp24_;
#line 374 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		_file_size = _tmp25_;
#line 374 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		_file_index = -1;
#line 374 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		while (TRUE) {
#line 2812 "rygel-media-export-root-container.c"
			gint _tmp26_;
			gint _tmp27_;
			gint _tmp28_;
			GeeArrayList* _tmp29_;
			gint _tmp30_;
			gpointer _tmp31_ = NULL;
			GFile* file;
			GFile* _tmp32_;
			gboolean _tmp33_ = FALSE;
#line 374 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
			_tmp26_ = _file_index;
#line 374 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
			_file_index = _tmp26_ + 1;
#line 374 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
			_tmp27_ = _file_index;
#line 374 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
			_tmp28_ = _file_size;
#line 374 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
			if (!(_tmp27_ < _tmp28_)) {
#line 374 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
				break;
#line 2834 "rygel-media-export-root-container.c"
			}
#line 374 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
			_tmp29_ = _file_list;
#line 374 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
			_tmp30_ = _file_index;
#line 374 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
			_tmp31_ = gee_abstract_list_get ((GeeAbstractList*) _tmp29_, _tmp30_);
#line 374 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
			file = (GFile*) _tmp31_;
#line 375 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
			_tmp32_ = file;
#line 375 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
			_tmp33_ = g_file_query_exists (_tmp32_, NULL);
#line 375 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
			if (_tmp33_) {
#line 2850 "rygel-media-export-root-container.c"
				GeeArrayList* _tmp34_;
				GFile* _tmp35_;
				gchar* _tmp36_ = NULL;
				gchar* _tmp37_;
				RygelMediaExportHarvester* _tmp38_;
				GFile* _tmp39_;
				RygelMediaContainer* _tmp40_;
#line 376 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
				_tmp34_ = ids;
#line 376 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
				_tmp35_ = file;
#line 376 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
				_tmp36_ = rygel_media_export_media_cache_get_id (_tmp35_);
#line 376 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
				_tmp37_ = _tmp36_;
#line 376 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
				gee_abstract_collection_remove ((GeeAbstractCollection*) _tmp34_, _tmp37_);
#line 376 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
				_g_free0 (_tmp37_);
#line 377 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
				_tmp38_ = self->priv->harvester;
#line 377 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
				_tmp39_ = file;
#line 377 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
				_tmp40_ = self->priv->filesystem_container;
#line 377 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
				rygel_media_export_harvester_schedule (_tmp38_, _tmp39_, _tmp40_, NULL);
#line 2878 "rygel-media-export-root-container.c"
			}
#line 374 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
			_g_object_unref0 (file);
#line 2882 "rygel-media-export-root-container.c"
		}
#line 374 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		_g_object_unref0 (_file_list);
#line 2886 "rygel-media-export-root-container.c"
	}
	{
		GeeArrayList* _tmp41_;
		GeeArrayList* _tmp42_;
		GeeArrayList* _id_list;
		GeeArrayList* _tmp43_;
		gint _tmp44_;
		gint _tmp45_;
		gint _id_size;
		gint _id_index;
#line 382 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		_tmp41_ = ids;
#line 382 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		_tmp42_ = _g_object_ref0 (_tmp41_);
#line 382 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		_id_list = _tmp42_;
#line 382 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		_tmp43_ = _id_list;
#line 382 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		_tmp44_ = gee_collection_get_size ((GeeCollection*) _tmp43_);
#line 382 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		_tmp45_ = _tmp44_;
#line 382 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		_id_size = _tmp45_;
#line 382 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		_id_index = -1;
#line 382 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		while (TRUE) {
#line 2915 "rygel-media-export-root-container.c"
			gint _tmp46_;
			gint _tmp47_;
			gint _tmp48_;
			GeeArrayList* _tmp49_;
			gint _tmp50_;
			gpointer _tmp51_ = NULL;
			gchar* id;
			const gchar* _tmp52_;
#line 382 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
			_tmp46_ = _id_index;
#line 382 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
			_id_index = _tmp46_ + 1;
#line 382 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
			_tmp47_ = _id_index;
#line 382 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
			_tmp48_ = _id_size;
#line 382 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
			if (!(_tmp47_ < _tmp48_)) {
#line 382 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
				break;
#line 2936 "rygel-media-export-root-container.c"
			}
#line 382 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
			_tmp49_ = _id_list;
#line 382 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
			_tmp50_ = _id_index;
#line 382 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
			_tmp51_ = gee_abstract_list_get ((GeeAbstractList*) _tmp49_, _tmp50_);
#line 382 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
			id = (gchar*) _tmp51_;
#line 383 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
			_tmp52_ = id;
#line 383 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
			g_debug ("rygel-media-export-root-container.vala:383: ID %s no longer in config;" \
" deleting...", _tmp52_);
#line 2950 "rygel-media-export-root-container.c"
			{
				RygelMediaExportMediaCache* _tmp53_;
				const gchar* _tmp54_;
#line 385 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
				_tmp53_ = ((RygelMediaExportDBContainer*) self)->media_db;
#line 385 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
				_tmp54_ = id;
#line 385 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
				rygel_media_export_media_cache_remove_by_id (_tmp53_, _tmp54_, &_inner_error_);
#line 385 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
				if (_inner_error_ != NULL) {
#line 385 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
					if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
#line 2964 "rygel-media-export-root-container.c"
						goto __catch34_rygel_media_export_database_error;
					}
#line 385 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
					_g_free0 (id);
#line 385 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
					_g_object_unref0 (_id_list);
#line 385 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
					_g_object_unref0 (ids);
#line 385 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
					_g_object_unref0 (db);
#line 385 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 385 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
					g_clear_error (&_inner_error_);
#line 385 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
					return NULL;
#line 2981 "rygel-media-export-root-container.c"
				}
			}
			goto __finally34;
			__catch34_rygel_media_export_database_error:
			{
				GError* _error_ = NULL;
				const gchar* _tmp55_ = NULL;
				GError* _tmp56_;
				const gchar* _tmp57_;
#line 384 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
				_error_ = _inner_error_;
#line 384 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
				_inner_error_ = NULL;
#line 387 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
				_tmp55_ = _ ("Failed to remove entry: %s");
#line 387 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
				_tmp56_ = _error_;
#line 387 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
				_tmp57_ = _tmp56_->message;
#line 387 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
				g_warning (_tmp55_, _tmp57_);
#line 384 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
				_g_error_free0 (_error_);
#line 3005 "rygel-media-export-root-container.c"
			}
			__finally34:
#line 384 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
			if (_inner_error_ != NULL) {
#line 384 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
				g_propagate_error (error, _inner_error_);
#line 384 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
				_g_free0 (id);
#line 384 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
				_g_object_unref0 (_id_list);
#line 384 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
				_g_object_unref0 (ids);
#line 384 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
				_g_object_unref0 (db);
#line 384 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
				_g_object_unref0 (self);
#line 384 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
				return NULL;
#line 3024 "rygel-media-export-root-container.c"
			}
#line 382 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
			_g_free0 (id);
#line 3028 "rygel-media-export-root-container.c"
		}
#line 382 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		_g_object_unref0 (_id_list);
#line 3032 "rygel-media-export-root-container.c"
	}
#line 391 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	rygel_media_export_root_container_add_default_virtual_folders (self);
#line 393 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	rygel_media_container_updated ((RygelMediaContainer*) self);
#line 336 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	_g_object_unref0 (ids);
#line 336 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	_g_object_unref0 (db);
#line 336 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	return self;
#line 3044 "rygel-media-export-root-container.c"
}


static RygelMediaExportRootContainer* rygel_media_export_root_container_new (GError** error) {
#line 336 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	return rygel_media_export_root_container_construct (RYGEL_MEDIA_EXPORT_TYPE_ROOT_CONTAINER, error);
#line 3051 "rygel-media-export-root-container.c"
}


static void __lambda3_ (RygelMediaExportRootContainer* self) {
#line 401 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	rygel_media_export_root_container_add_default_virtual_folders (self);
#line 402 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	rygel_media_container_updated ((RygelMediaContainer*) self);
#line 3060 "rygel-media-export-root-container.c"
}


static void ___lambda3__rygel_media_container_container_updated (RygelMediaContainer* _sender, RygelMediaContainer* container, gpointer self) {
#line 400 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	__lambda3_ (self);
#line 3067 "rygel-media-export-root-container.c"
}


static void rygel_media_export_root_container_on_initial_harvesting_done (RygelMediaExportRootContainer* self) {
	RygelMediaExportHarvester* _tmp0_;
	gulong _tmp1_;
	RygelMediaExportMediaCache* _tmp2_;
	RygelMediaContainer* _tmp3_;
#line 396 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	g_return_if_fail (self != NULL);
#line 397 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	_tmp0_ = self->priv->harvester;
#line 397 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	_tmp1_ = self->priv->harvester_signal_id;
#line 397 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	g_signal_handler_disconnect ((GObject*) _tmp0_, _tmp1_);
#line 398 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	_tmp2_ = ((RygelMediaExportDBContainer*) self)->media_db;
#line 398 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	rygel_media_export_media_cache_debug_statistics (_tmp2_);
#line 400 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	_tmp3_ = self->priv->filesystem_container;
#line 400 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	g_signal_connect_object (_tmp3_, "container-updated", (GCallback) ___lambda3__rygel_media_container_container_updated, self, 0);
#line 3092 "rygel-media-export-root-container.c"
}


static void rygel_media_export_root_container_add_default_virtual_folders (RygelMediaExportRootContainer* self) {
	GError * _inner_error_ = NULL;
#line 408 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	g_return_if_fail (self != NULL);
#line 3100 "rygel-media-export-root-container.c"
	{
		const gchar* _tmp0_ = NULL;
		const gchar* _tmp1_ = NULL;
		const gchar* _tmp2_ = NULL;
#line 410 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		_tmp0_ = _ ("Music");
#line 410 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		rygel_media_export_root_container_add_virtual_containers_for_class (self, _tmp0_, RYGEL_MUSIC_ITEM_UPNP_CLASS, virtual_folders_music, G_N_ELEMENTS (virtual_folders_music), &_inner_error_);
#line 410 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		if (_inner_error_ != NULL) {
#line 3111 "rygel-media-export-root-container.c"
			goto __catch35_g_error;
		}
#line 413 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		_tmp1_ = _ ("Pictures");
#line 413 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		rygel_media_export_root_container_add_virtual_containers_for_class (self, _tmp1_, RYGEL_PHOTO_ITEM_UPNP_CLASS, NULL, 0, &_inner_error_);
#line 413 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		if (_inner_error_ != NULL) {
#line 3120 "rygel-media-export-root-container.c"
			goto __catch35_g_error;
		}
#line 415 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		_tmp2_ = _ ("Videos");
#line 415 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		rygel_media_export_root_container_add_virtual_containers_for_class (self, _tmp2_, RYGEL_VIDEO_ITEM_UPNP_CLASS, NULL, 0, &_inner_error_);
#line 415 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		if (_inner_error_ != NULL) {
#line 3129 "rygel-media-export-root-container.c"
			goto __catch35_g_error;
		}
	}
	goto __finally35;
	__catch35_g_error:
	{
		GError* _error_ = NULL;
#line 409 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		_error_ = _inner_error_;
#line 409 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		_inner_error_ = NULL;
#line 409 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		_g_error_free0 (_error_);
#line 3143 "rygel-media-export-root-container.c"
	}
	__finally35:
#line 409 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	if (_inner_error_ != NULL) {
#line 409 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 409 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		g_clear_error (&_inner_error_);
#line 409 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		return;
#line 3154 "rygel-media-export-root-container.c"
	}
}


static gchar* string_slice (const gchar* self, glong start, glong end) {
	gchar* result = NULL;
	gint _tmp0_;
	gint _tmp1_;
	glong string_length;
	glong _tmp2_;
	glong _tmp5_;
	gboolean _tmp8_ = FALSE;
	glong _tmp9_;
	gboolean _tmp12_;
	gboolean _tmp13_ = FALSE;
	glong _tmp14_;
	gboolean _tmp17_;
	glong _tmp18_;
	glong _tmp19_;
	glong _tmp20_;
	glong _tmp21_;
	glong _tmp22_;
	gchar* _tmp23_ = NULL;
#line 1330 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1331 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
	_tmp0_ = strlen (self);
#line 1331 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
	_tmp1_ = _tmp0_;
#line 1331 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
	string_length = (glong) _tmp1_;
#line 1332 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
	_tmp2_ = start;
#line 1332 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
	if (_tmp2_ < ((glong) 0)) {
#line 3190 "rygel-media-export-root-container.c"
		glong _tmp3_;
		glong _tmp4_;
#line 1333 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
		_tmp3_ = string_length;
#line 1333 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
		_tmp4_ = start;
#line 1333 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
		start = _tmp3_ + _tmp4_;
#line 3199 "rygel-media-export-root-container.c"
	}
#line 1335 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
	_tmp5_ = end;
#line 1335 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
	if (_tmp5_ < ((glong) 0)) {
#line 3205 "rygel-media-export-root-container.c"
		glong _tmp6_;
		glong _tmp7_;
#line 1336 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
		_tmp6_ = string_length;
#line 1336 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
		_tmp7_ = end;
#line 1336 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
		end = _tmp6_ + _tmp7_;
#line 3214 "rygel-media-export-root-container.c"
	}
#line 1338 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
	_tmp9_ = start;
#line 1338 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
	if (_tmp9_ >= ((glong) 0)) {
#line 3220 "rygel-media-export-root-container.c"
		glong _tmp10_;
		glong _tmp11_;
#line 1338 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
		_tmp10_ = start;
#line 1338 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
		_tmp11_ = string_length;
#line 1338 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
		_tmp8_ = _tmp10_ <= _tmp11_;
#line 3229 "rygel-media-export-root-container.c"
	} else {
#line 1338 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
		_tmp8_ = FALSE;
#line 3233 "rygel-media-export-root-container.c"
	}
#line 1338 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
	_tmp12_ = _tmp8_;
#line 1338 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
	g_return_val_if_fail (_tmp12_, NULL);
#line 1339 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
	_tmp14_ = end;
#line 1339 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
	if (_tmp14_ >= ((glong) 0)) {
#line 3243 "rygel-media-export-root-container.c"
		glong _tmp15_;
		glong _tmp16_;
#line 1339 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
		_tmp15_ = end;
#line 1339 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
		_tmp16_ = string_length;
#line 1339 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
		_tmp13_ = _tmp15_ <= _tmp16_;
#line 3252 "rygel-media-export-root-container.c"
	} else {
#line 1339 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
		_tmp13_ = FALSE;
#line 3256 "rygel-media-export-root-container.c"
	}
#line 1339 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
	_tmp17_ = _tmp13_;
#line 1339 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
	g_return_val_if_fail (_tmp17_, NULL);
#line 1340 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
	_tmp18_ = start;
#line 1340 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
	_tmp19_ = end;
#line 1340 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
	g_return_val_if_fail (_tmp18_ <= _tmp19_, NULL);
#line 1341 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
	_tmp20_ = start;
#line 1341 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
	_tmp21_ = end;
#line 1341 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
	_tmp22_ = start;
#line 1341 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
	_tmp23_ = g_strndup (((gchar*) self) + _tmp20_, (gsize) (_tmp21_ - _tmp22_));
#line 1341 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
	result = _tmp23_;
#line 1341 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
	return result;
#line 3280 "rygel-media-export-root-container.c"
}


static void rygel_media_export_root_container_add_folder_definition (RygelMediaExportRootContainer* self, RygelMediaContainer* container, const gchar* item_class, RygelMediaExportFolderDefinition* definition, GError** error) {
	const gchar* _tmp0_;
	RygelMediaExportFolderDefinition _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_ = NULL;
	gchar* id;
	const gchar* _tmp4_;
	gboolean _tmp5_ = FALSE;
	RygelMediaExportMediaCache* _tmp8_;
	const gchar* _tmp9_;
	RygelMediaExportFolderDefinition _tmp10_;
	const gchar* _tmp11_;
	RygelMediaExportQueryContainer* _tmp12_;
	RygelMediaExportQueryContainer* query_container;
	RygelMediaExportQueryContainer* _tmp13_;
	gint _tmp14_;
	GError * _inner_error_ = NULL;
#line 420 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	g_return_if_fail (self != NULL);
#line 420 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	g_return_if_fail (container != NULL);
#line 420 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	g_return_if_fail (item_class != NULL);
#line 420 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	g_return_if_fail (definition != NULL);
#line 424 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	_tmp0_ = item_class;
#line 424 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	_tmp1_ = *definition;
#line 424 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	_tmp2_ = _tmp1_.definition;
#line 424 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	_tmp3_ = g_strdup_printf ("%supnp:class,%s,%s", RYGEL_MEDIA_EXPORT_QUERY_CONTAINER_PREFIX, _tmp0_, _tmp2_);
#line 424 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	id = _tmp3_;
#line 427 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	_tmp4_ = id;
#line 427 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	_tmp5_ = g_str_has_suffix (_tmp4_, ",");
#line 427 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	if (_tmp5_) {
#line 3325 "rygel-media-export-root-container.c"
		const gchar* _tmp6_;
		gchar* _tmp7_ = NULL;
#line 428 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		_tmp6_ = id;
#line 428 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		_tmp7_ = string_slice (_tmp6_, (glong) 0, (glong) (-1));
#line 428 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		_g_free0 (id);
#line 428 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		id = _tmp7_;
#line 3336 "rygel-media-export-root-container.c"
	}
#line 431 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	rygel_media_export_query_container_register_id (&id);
#line 432 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	_tmp8_ = ((RygelMediaExportDBContainer*) self)->media_db;
#line 432 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	_tmp9_ = id;
#line 432 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	_tmp10_ = *definition;
#line 432 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	_tmp11_ = _tmp10_.title;
#line 432 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	_tmp12_ = rygel_media_export_query_container_new (_tmp8_, _tmp9_, _tmp11_);
#line 432 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	query_container = _tmp12_;
#line 435 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	_tmp13_ = query_container;
#line 435 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	_tmp14_ = ((RygelMediaContainer*) _tmp13_)->child_count;
#line 435 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	if (_tmp14_ > 0) {
#line 3358 "rygel-media-export-root-container.c"
		RygelMediaExportQueryContainer* _tmp15_;
		RygelMediaContainer* _tmp16_;
		RygelMediaExportMediaCache* _tmp17_;
		RygelMediaExportQueryContainer* _tmp18_;
#line 436 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		_tmp15_ = query_container;
#line 436 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		_tmp16_ = container;
#line 436 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		((RygelMediaObject*) _tmp15_)->parent = _tmp16_;
#line 437 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		_tmp17_ = ((RygelMediaExportDBContainer*) self)->media_db;
#line 437 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		_tmp18_ = query_container;
#line 437 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		rygel_media_export_media_cache_save_container (_tmp17_, (RygelMediaContainer*) _tmp18_, &_inner_error_);
#line 437 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		if (_inner_error_ != NULL) {
#line 437 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
			g_propagate_error (error, _inner_error_);
#line 437 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
			_g_object_unref0 (query_container);
#line 437 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
			_g_free0 (id);
#line 437 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
			return;
#line 3385 "rygel-media-export-root-container.c"
		}
	} else {
		RygelMediaExportMediaCache* _tmp19_;
		const gchar* _tmp20_;
#line 439 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		_tmp19_ = ((RygelMediaExportDBContainer*) self)->media_db;
#line 439 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		_tmp20_ = id;
#line 439 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		rygel_media_export_media_cache_remove_by_id (_tmp19_, _tmp20_, &_inner_error_);
#line 439 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		if (_inner_error_ != NULL) {
#line 439 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
			g_propagate_error (error, _inner_error_);
#line 439 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
			_g_object_unref0 (query_container);
#line 439 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
			_g_free0 (id);
#line 439 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
			return;
#line 3406 "rygel-media-export-root-container.c"
		}
	}
#line 420 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	_g_object_unref0 (query_container);
#line 420 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	_g_free0 (id);
#line 3413 "rygel-media-export-root-container.c"
}


static void rygel_media_export_root_container_add_virtual_containers_for_class (RygelMediaExportRootContainer* self, const gchar* parent, const gchar* item_class, RygelMediaExportFolderDefinition* definitions, int definitions_length1, GError** error) {
	RygelNullContainer* _tmp0_;
	RygelNullContainer* container;
	RygelNullContainer* _tmp1_;
	RygelNullContainer* _tmp2_;
	const gchar* _tmp3_;
	RygelNullContainer* _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	RygelMediaExportMediaCache* _tmp7_;
	RygelNullContainer* _tmp8_;
	RygelMediaExportFolderDefinition* _tmp12_;
	gint _tmp12__length1;
	RygelMediaExportMediaCache* _tmp18_;
	RygelNullContainer* _tmp19_;
	const gchar* _tmp20_;
	gint _tmp21_ = 0;
	gint _tmp22_;
	GError * _inner_error_ = NULL;
#line 443 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	g_return_if_fail (self != NULL);
#line 443 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	g_return_if_fail (parent != NULL);
#line 443 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	g_return_if_fail (item_class != NULL);
#line 448 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	_tmp0_ = rygel_null_container_new ();
#line 448 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	container = _tmp0_;
#line 449 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	_tmp1_ = container;
#line 449 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	((RygelMediaObject*) _tmp1_)->parent = (RygelMediaContainer*) self;
#line 450 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	_tmp2_ = container;
#line 450 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	_tmp3_ = parent;
#line 450 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	rygel_media_object_set_title ((RygelMediaObject*) _tmp2_, _tmp3_);
#line 451 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	_tmp4_ = container;
#line 451 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	_tmp5_ = item_class;
#line 451 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	_tmp6_ = g_strconcat ("virtual-parent:", _tmp5_, NULL);
#line 451 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	_g_free0 (((RygelMediaObject*) _tmp4_)->id);
#line 451 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	((RygelMediaObject*) _tmp4_)->id = _tmp6_;
#line 452 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	_tmp7_ = ((RygelMediaExportDBContainer*) self)->media_db;
#line 452 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	_tmp8_ = container;
#line 452 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	rygel_media_export_media_cache_save_container (_tmp7_, (RygelMediaContainer*) _tmp8_, &_inner_error_);
#line 452 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	if (_inner_error_ != NULL) {
#line 452 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		g_propagate_error (error, _inner_error_);
#line 452 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		_g_object_unref0 (container);
#line 452 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		return;
#line 3480 "rygel-media-export-root-container.c"
	}
	{
		RygelMediaExportFolderDefinition* definition_collection = NULL;
		gint definition_collection_length1 = 0;
		gint _definition_collection_size_ = 0;
		gint definition_it = 0;
#line 454 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		definition_collection = virtual_folders_default;
#line 454 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		definition_collection_length1 = G_N_ELEMENTS (virtual_folders_default);
#line 454 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		for (definition_it = 0; definition_it < G_N_ELEMENTS (virtual_folders_default); definition_it = definition_it + 1) {
#line 3493 "rygel-media-export-root-container.c"
			RygelMediaExportFolderDefinition definition = {0};
#line 454 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
			definition = definition_collection[definition_it];
#line 3497 "rygel-media-export-root-container.c"
			{
				RygelNullContainer* _tmp9_;
				const gchar* _tmp10_;
				RygelMediaExportFolderDefinition _tmp11_;
#line 455 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
				_tmp9_ = container;
#line 455 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
				_tmp10_ = item_class;
#line 455 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
				_tmp11_ = definition;
#line 455 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
				rygel_media_export_root_container_add_folder_definition (self, (RygelMediaContainer*) _tmp9_, _tmp10_, &_tmp11_, &_inner_error_);
#line 455 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
				if (_inner_error_ != NULL) {
#line 455 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
					g_propagate_error (error, _inner_error_);
#line 455 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
					_g_object_unref0 (container);
#line 455 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
					return;
#line 3518 "rygel-media-export-root-container.c"
				}
			}
		}
	}
#line 458 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	_tmp12_ = definitions;
#line 458 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	_tmp12__length1 = definitions_length1;
#line 458 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	if (_tmp12_ != NULL) {
#line 3529 "rygel-media-export-root-container.c"
		RygelMediaExportFolderDefinition* _tmp13_;
		gint _tmp13__length1;
#line 459 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		_tmp13_ = definitions;
#line 459 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		_tmp13__length1 = definitions_length1;
#line 3536 "rygel-media-export-root-container.c"
		{
			RygelMediaExportFolderDefinition* definition_collection = NULL;
			gint definition_collection_length1 = 0;
			gint _definition_collection_size_ = 0;
			gint definition_it = 0;
#line 459 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
			definition_collection = _tmp13_;
#line 459 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
			definition_collection_length1 = _tmp13__length1;
#line 459 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
			for (definition_it = 0; definition_it < _tmp13__length1; definition_it = definition_it + 1) {
#line 3548 "rygel-media-export-root-container.c"
				RygelMediaExportFolderDefinition _tmp14_ = {0};
				RygelMediaExportFolderDefinition definition = {0};
#line 459 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
				rygel_media_export_folder_definition_copy (&definition_collection[definition_it], &_tmp14_);
#line 459 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
				definition = _tmp14_;
#line 3555 "rygel-media-export-root-container.c"
				{
					RygelNullContainer* _tmp15_;
					const gchar* _tmp16_;
					RygelMediaExportFolderDefinition _tmp17_;
#line 460 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
					_tmp15_ = container;
#line 460 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
					_tmp16_ = item_class;
#line 460 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
					_tmp17_ = definition;
#line 460 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
					rygel_media_export_root_container_add_folder_definition (self, (RygelMediaContainer*) _tmp15_, _tmp16_, &_tmp17_, &_inner_error_);
#line 460 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
					if (_inner_error_ != NULL) {
#line 460 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
						g_propagate_error (error, _inner_error_);
#line 460 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
						rygel_media_export_folder_definition_destroy (&definition);
#line 460 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
						_g_object_unref0 (container);
#line 460 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
						return;
#line 3578 "rygel-media-export-root-container.c"
					}
#line 459 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
					rygel_media_export_folder_definition_destroy (&definition);
#line 3582 "rygel-media-export-root-container.c"
				}
			}
		}
	}
#line 464 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	_tmp18_ = ((RygelMediaExportDBContainer*) self)->media_db;
#line 464 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	_tmp19_ = container;
#line 464 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	_tmp20_ = ((RygelMediaObject*) _tmp19_)->id;
#line 464 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	_tmp21_ = rygel_media_export_media_cache_get_child_count (_tmp18_, _tmp20_, &_inner_error_);
#line 464 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	_tmp22_ = _tmp21_;
#line 464 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	if (_inner_error_ != NULL) {
#line 464 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		g_propagate_error (error, _inner_error_);
#line 464 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		_g_object_unref0 (container);
#line 464 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		return;
#line 3605 "rygel-media-export-root-container.c"
	}
#line 464 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	if (_tmp22_ == 0) {
#line 3609 "rygel-media-export-root-container.c"
		RygelMediaExportMediaCache* _tmp23_;
		RygelNullContainer* _tmp24_;
		const gchar* _tmp25_;
#line 465 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		_tmp23_ = ((RygelMediaExportDBContainer*) self)->media_db;
#line 465 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		_tmp24_ = container;
#line 465 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		_tmp25_ = ((RygelMediaObject*) _tmp24_)->id;
#line 465 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		rygel_media_export_media_cache_remove_by_id (_tmp23_, _tmp25_, &_inner_error_);
#line 465 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		if (_inner_error_ != NULL) {
#line 465 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
			g_propagate_error (error, _inner_error_);
#line 465 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
			_g_object_unref0 (container);
#line 465 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
			return;
#line 3629 "rygel-media-export-root-container.c"
		}
	} else {
		RygelNullContainer* _tmp26_;
#line 467 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		_tmp26_ = container;
#line 467 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
		rygel_media_container_updated ((RygelMediaContainer*) _tmp26_);
#line 3637 "rygel-media-export-root-container.c"
	}
#line 443 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	_g_object_unref0 (container);
#line 3641 "rygel-media-export-root-container.c"
}


static void rygel_media_export_root_container_class_init (RygelMediaExportRootContainerClass * klass) {
#line 43 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	rygel_media_export_root_container_parent_class = g_type_class_peek_parent (klass);
#line 43 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	g_type_class_add_private (klass, sizeof (RygelMediaExportRootContainerPrivate));
#line 43 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	RYGEL_MEDIA_CONTAINER_CLASS (klass)->find_object = rygel_media_export_root_container_real_find_object;
#line 43 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	RYGEL_MEDIA_CONTAINER_CLASS (klass)->find_object_finish = rygel_media_export_root_container_real_find_object_finish;
#line 43 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	RYGEL_MEDIA_EXPORT_DB_CONTAINER_CLASS (klass)->search = rygel_media_export_root_container_real_search;
#line 43 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	RYGEL_MEDIA_EXPORT_DB_CONTAINER_CLASS (klass)->search_finish = rygel_media_export_root_container_real_search_finish;
#line 43 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	G_OBJECT_CLASS (klass)->finalize = rygel_media_export_root_container_finalize;
#line 3660 "rygel-media-export-root-container.c"
}


static void rygel_media_export_root_container_instance_init (RygelMediaExportRootContainer * self) {
#line 43 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	self->priv = RYGEL_MEDIA_EXPORT_ROOT_CONTAINER_GET_PRIVATE (self);
#line 3667 "rygel-media-export-root-container.c"
}


static void rygel_media_export_root_container_finalize (GObject* obj) {
	RygelMediaExportRootContainer * self;
#line 43 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	self = RYGEL_MEDIA_EXPORT_ROOT_CONTAINER (obj);
#line 44 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	_g_object_unref0 (self->priv->service);
#line 45 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	_g_object_unref0 (self->priv->harvester);
#line 46 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	_g_object_unref0 (self->priv->cancellable);
#line 47 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	_g_object_unref0 (self->priv->filesystem_container);
#line 43 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-root-container.vala"
	G_OBJECT_CLASS (rygel_media_export_root_container_parent_class)->finalize (obj);
#line 3685 "rygel-media-export-root-container.c"
}


/**
 * Represents the root container.
 */
GType rygel_media_export_root_container_get_type (void) {
	static volatile gsize rygel_media_export_root_container_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_media_export_root_container_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelMediaExportRootContainerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_media_export_root_container_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelMediaExportRootContainer), 0, (GInstanceInitFunc) rygel_media_export_root_container_instance_init, NULL };
		GType rygel_media_export_root_container_type_id;
		rygel_media_export_root_container_type_id = g_type_register_static (RYGEL_MEDIA_EXPORT_TYPE_DB_CONTAINER, "RygelMediaExportRootContainer", &g_define_type_info, 0);
		g_once_init_leave (&rygel_media_export_root_container_type_id__volatile, rygel_media_export_root_container_type_id);
	}
	return rygel_media_export_root_container_type_id__volatile;
}



