/* rygel-plugin.c generated by valac 0.20.1, the Vala compiler
 * generated from rygel-plugin.vala, do not modify */

/*
 * Copyright (C) 2008 Nokia Corporation.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <libgupnp/gupnp.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <config.h>


#define RYGEL_TYPE_PLUGIN_CAPABILITIES (rygel_plugin_capabilities_get_type ())

#define RYGEL_TYPE_PLUGIN (rygel_plugin_get_type ())
#define RYGEL_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_PLUGIN, RygelPlugin))
#define RYGEL_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_PLUGIN, RygelPluginClass))
#define RYGEL_IS_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_PLUGIN))
#define RYGEL_IS_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_PLUGIN))
#define RYGEL_PLUGIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_PLUGIN, RygelPluginClass))

typedef struct _RygelPlugin RygelPlugin;
typedef struct _RygelPluginClass RygelPluginClass;
typedef struct _RygelPluginPrivate RygelPluginPrivate;

#define RYGEL_TYPE_ROOT_DEVICE (rygel_root_device_get_type ())
#define RYGEL_ROOT_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_ROOT_DEVICE, RygelRootDevice))
#define RYGEL_ROOT_DEVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_ROOT_DEVICE, RygelRootDeviceClass))
#define RYGEL_IS_ROOT_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_ROOT_DEVICE))
#define RYGEL_IS_ROOT_DEVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_ROOT_DEVICE))
#define RYGEL_ROOT_DEVICE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_ROOT_DEVICE, RygelRootDeviceClass))

typedef struct _RygelRootDevice RygelRootDevice;
typedef struct _RygelRootDeviceClass RygelRootDeviceClass;

#define RYGEL_TYPE_RESOURCE_INFO (rygel_resource_info_get_type ())
#define RYGEL_RESOURCE_INFO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_RESOURCE_INFO, RygelResourceInfo))
#define RYGEL_RESOURCE_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_RESOURCE_INFO, RygelResourceInfoClass))
#define RYGEL_IS_RESOURCE_INFO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_RESOURCE_INFO))
#define RYGEL_IS_RESOURCE_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_RESOURCE_INFO))
#define RYGEL_RESOURCE_INFO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_RESOURCE_INFO, RygelResourceInfoClass))

typedef struct _RygelResourceInfo RygelResourceInfo;
typedef struct _RygelResourceInfoClass RygelResourceInfoClass;

#define RYGEL_TYPE_ICON_INFO (rygel_icon_info_get_type ())
#define RYGEL_ICON_INFO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_ICON_INFO, RygelIconInfo))
#define RYGEL_ICON_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_ICON_INFO, RygelIconInfoClass))
#define RYGEL_IS_ICON_INFO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_ICON_INFO))
#define RYGEL_IS_ICON_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_ICON_INFO))
#define RYGEL_ICON_INFO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_ICON_INFO, RygelIconInfoClass))

typedef struct _RygelIconInfo RygelIconInfo;
typedef struct _RygelIconInfoClass RygelIconInfoClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _RygelResourceInfoPrivate RygelResourceInfoPrivate;
typedef struct _RygelIconInfoPrivate RygelIconInfoPrivate;
#define _rygel_icon_info_unref0(var) ((var == NULL) ? NULL : (var = (rygel_icon_info_unref (var), NULL)))

typedef enum  {
	RYGEL_PLUGIN_CAPABILITIES_NONE = 0,
	RYGEL_PLUGIN_CAPABILITIES_IMAGE_UPLOAD = 1 << 0,
	RYGEL_PLUGIN_CAPABILITIES_VIDEO_UPLOAD = 1 << 1,
	RYGEL_PLUGIN_CAPABILITIES_AUDIO_UPLOAD = 1 << 2,
	RYGEL_PLUGIN_CAPABILITIES_UPLOAD = (RYGEL_PLUGIN_CAPABILITIES_IMAGE_UPLOAD | RYGEL_PLUGIN_CAPABILITIES_VIDEO_UPLOAD) | RYGEL_PLUGIN_CAPABILITIES_AUDIO_UPLOAD,
	RYGEL_PLUGIN_CAPABILITIES_TRACK_CHANGES = 1 << 3,
	RYGEL_PLUGIN_CAPABILITIES_CREATE_CONTAINERS = 1 << 4
} RygelPluginCapabilities;

struct _RygelPlugin {
	GUPnPResourceFactory parent_instance;
	RygelPluginPrivate * priv;
};

struct _RygelPluginClass {
	GUPnPResourceFactoryClass parent_class;
	void (*apply_hacks) (RygelPlugin* self, RygelRootDevice* device, const gchar* description_path, GError** error);
};

struct _RygelPluginPrivate {
	RygelPluginCapabilities _capabilities;
	gchar* _name;
	gchar* _title;
	gchar* _description;
	gchar* _desc_path;
	gboolean _active;
	GeeArrayList* _resource_infos;
	GeeArrayList* _icon_infos;
	GeeArrayList* _default_icons;
};

struct _RygelResourceInfo {
	GTypeInstance parent_instance;
	volatile int ref_count;
	RygelResourceInfoPrivate * priv;
	gchar* upnp_type;
	gchar* upnp_id;
	gchar* description_path;
	GType type;
};

struct _RygelResourceInfoClass {
	GTypeClass parent_class;
	void (*finalize) (RygelResourceInfo *self);
};

struct _RygelIconInfo {
	GTypeInstance parent_instance;
	volatile int ref_count;
	RygelIconInfoPrivate * priv;
	gchar* mime_type;
	gchar* uri;
	gchar* file_extension;
	gint64 size;
	gint width;
	gint height;
	gint depth;
};

struct _RygelIconInfoClass {
	GTypeClass parent_class;
	void (*finalize) (RygelIconInfo *self);
};


static gpointer rygel_plugin_parent_class = NULL;

GType rygel_plugin_capabilities_get_type (void) G_GNUC_CONST;
GType rygel_plugin_get_type (void) G_GNUC_CONST;
GType rygel_root_device_get_type (void) G_GNUC_CONST;
gpointer rygel_resource_info_ref (gpointer instance);
void rygel_resource_info_unref (gpointer instance);
GParamSpec* rygel_param_spec_resource_info (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_value_set_resource_info (GValue* value, gpointer v_object);
void rygel_value_take_resource_info (GValue* value, gpointer v_object);
gpointer rygel_value_get_resource_info (const GValue* value);
GType rygel_resource_info_get_type (void) G_GNUC_CONST;
gpointer rygel_icon_info_ref (gpointer instance);
void rygel_icon_info_unref (gpointer instance);
GParamSpec* rygel_param_spec_icon_info (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_value_set_icon_info (GValue* value, gpointer v_object);
void rygel_value_take_icon_info (GValue* value, gpointer v_object);
gpointer rygel_value_get_icon_info (const GValue* value);
GType rygel_icon_info_get_type (void) G_GNUC_CONST;
#define RYGEL_PLUGIN_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_PLUGIN, RygelPluginPrivate))
enum  {
	RYGEL_PLUGIN_DUMMY_PROPERTY,
	RYGEL_PLUGIN_CAPABILITIES,
	RYGEL_PLUGIN_NAME,
	RYGEL_PLUGIN_TITLE,
	RYGEL_PLUGIN_DESCRIPTION,
	RYGEL_PLUGIN_DESC_PATH,
	RYGEL_PLUGIN_ACTIVE,
	RYGEL_PLUGIN_RESOURCE_INFOS,
	RYGEL_PLUGIN_ICON_INFOS,
	RYGEL_PLUGIN_DEFAULT_ICONS
};
#define RYGEL_PLUGIN_PNG_EXT "png"
#define RYGEL_PLUGIN_JPG_EXT "jpg"
#define RYGEL_PLUGIN_ICON_BIG "file://" BIG_ICON_DIR "/rygel"
#define RYGEL_PLUGIN_ICON_PNG_BIG RYGEL_PLUGIN_ICON_BIG "." RYGEL_PLUGIN_PNG_EXT
#define RYGEL_PLUGIN_ICON_JPG_BIG RYGEL_PLUGIN_ICON_BIG "." RYGEL_PLUGIN_JPG_EXT
#define RYGEL_PLUGIN_ICON_SMALL "file://" SMALL_ICON_DIR "/rygel"
#define RYGEL_PLUGIN_ICON_PNG_SMALL RYGEL_PLUGIN_ICON_SMALL "." RYGEL_PLUGIN_PNG_EXT
#define RYGEL_PLUGIN_ICON_JPG_SMALL RYGEL_PLUGIN_ICON_SMALL "." RYGEL_PLUGIN_JPG_EXT
#define RYGEL_PLUGIN_ICON_PNG_MIME "image/png"
#define RYGEL_PLUGIN_ICON_JPG_MIME "image/jpeg"
#define RYGEL_PLUGIN_ICON_PNG_DEPTH 24
#define RYGEL_PLUGIN_ICON_JPG_DEPTH 24
#define RYGEL_PLUGIN_ICON_BIG_WIDTH 120
#define RYGEL_PLUGIN_ICON_BIG_HEIGHT 120
#define RYGEL_PLUGIN_ICON_SMALL_WIDTH 48
#define RYGEL_PLUGIN_ICON_SMALL_HEIGHT 48
RygelPlugin* rygel_plugin_new (const gchar* desc_path, const gchar* name, const gchar* title, const gchar* description, RygelPluginCapabilities capabilities);
RygelPlugin* rygel_plugin_construct (GType object_type, const gchar* desc_path, const gchar* name, const gchar* title, const gchar* description, RygelPluginCapabilities capabilities);
static void rygel_plugin_real_constructed (GObject* base);
void rygel_plugin_set_active (RygelPlugin* self, gboolean value);
const gchar* rygel_plugin_get_title (RygelPlugin* self);
const gchar* rygel_plugin_get_name (RygelPlugin* self);
void rygel_plugin_set_title (RygelPlugin* self, const gchar* value);
static void rygel_plugin_set_resource_infos (RygelPlugin* self, GeeArrayList* value);
static void rygel_plugin_set_icon_infos (RygelPlugin* self, GeeArrayList* value);
static void rygel_plugin_set_default_icons (RygelPlugin* self, GeeArrayList* value);
static void rygel_plugin_add_default_icon (RygelPlugin* self, const gchar* mime_type, const gchar* file_extension, const gchar* uri, gint width, gint height, gint depth);
void rygel_plugin_add_resource (RygelPlugin* self, RygelResourceInfo* resource_info);
GeeArrayList* rygel_plugin_get_resource_infos (RygelPlugin* self);
void rygel_plugin_add_icon (RygelPlugin* self, RygelIconInfo* icon_info);
GeeArrayList* rygel_plugin_get_icon_infos (RygelPlugin* self);
void rygel_plugin_apply_hacks (RygelPlugin* self, RygelRootDevice* device, const gchar* description_path, GError** error);
static void rygel_plugin_real_apply_hacks (RygelPlugin* self, RygelRootDevice* device, const gchar* description_path, GError** error);
RygelIconInfo* rygel_icon_info_new (const gchar* mime_type, const gchar* file_extension);
RygelIconInfo* rygel_icon_info_construct (GType object_type, const gchar* mime_type, const gchar* file_extension);
GeeArrayList* rygel_plugin_get_default_icons (RygelPlugin* self);
RygelPluginCapabilities rygel_plugin_get_capabilities (RygelPlugin* self);
void rygel_plugin_set_capabilities (RygelPlugin* self, RygelPluginCapabilities value);
static void rygel_plugin_set_name (RygelPlugin* self, const gchar* value);
const gchar* rygel_plugin_get_description (RygelPlugin* self);
static void rygel_plugin_set_description (RygelPlugin* self, const gchar* value);
const gchar* rygel_plugin_get_desc_path (RygelPlugin* self);
static void rygel_plugin_set_desc_path (RygelPlugin* self, const gchar* value);
gboolean rygel_plugin_get_active (RygelPlugin* self);
static void rygel_plugin_finalize (GObject* obj);
static void _vala_rygel_plugin_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_rygel_plugin_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


/**
 * RygelPluginCapabilities is a set of flags that represent various
 * capabilities of plugins.
 */
GType rygel_plugin_capabilities_get_type (void) {
	static volatile gsize rygel_plugin_capabilities_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_plugin_capabilities_type_id__volatile)) {
		static const GFlagsValue values[] = {{RYGEL_PLUGIN_CAPABILITIES_NONE, "RYGEL_PLUGIN_CAPABILITIES_NONE", "none"}, {RYGEL_PLUGIN_CAPABILITIES_IMAGE_UPLOAD, "RYGEL_PLUGIN_CAPABILITIES_IMAGE_UPLOAD", "image-upload"}, {RYGEL_PLUGIN_CAPABILITIES_VIDEO_UPLOAD, "RYGEL_PLUGIN_CAPABILITIES_VIDEO_UPLOAD", "video-upload"}, {RYGEL_PLUGIN_CAPABILITIES_AUDIO_UPLOAD, "RYGEL_PLUGIN_CAPABILITIES_AUDIO_UPLOAD", "audio-upload"}, {RYGEL_PLUGIN_CAPABILITIES_UPLOAD, "RYGEL_PLUGIN_CAPABILITIES_UPLOAD", "upload"}, {RYGEL_PLUGIN_CAPABILITIES_TRACK_CHANGES, "RYGEL_PLUGIN_CAPABILITIES_TRACK_CHANGES", "track-changes"}, {RYGEL_PLUGIN_CAPABILITIES_CREATE_CONTAINERS, "RYGEL_PLUGIN_CAPABILITIES_CREATE_CONTAINERS", "create-containers"}, {0, NULL, NULL}};
		GType rygel_plugin_capabilities_type_id;
		rygel_plugin_capabilities_type_id = g_flags_register_static ("RygelPluginCapabilities", values);
		g_once_init_leave (&rygel_plugin_capabilities_type_id__volatile, rygel_plugin_capabilities_type_id);
	}
	return rygel_plugin_capabilities_type_id__volatile;
}


/** 
     * Create an instance of the plugin.
     *
     * @param desc_path The path of a template file for an XML description of the UPnP service.
     * @param name The non-human-readable name for the plugin and its service, used in UPnP messages and in the Rygel configuration file.
     * @param title An optional human-readable name (friendlyName) of the UPnP service provided by the plugin. If the title is empty then the name will be used.
     * @param description An optional human-readable description (modelDescription) of the UPnP service provided by the plugin.
     */
RygelPlugin* rygel_plugin_construct (GType object_type, const gchar* desc_path, const gchar* name, const gchar* title, const gchar* description, RygelPluginCapabilities capabilities) {
	RygelPlugin * self = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	RygelPluginCapabilities _tmp4_;
#line 127 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin.vala"
	g_return_val_if_fail (desc_path != NULL, NULL);
#line 127 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin.vala"
	g_return_val_if_fail (name != NULL, NULL);
#line 132 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin.vala"
	_tmp0_ = desc_path;
#line 132 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin.vala"
	_tmp1_ = name;
#line 132 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin.vala"
	_tmp2_ = title;
#line 132 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin.vala"
	_tmp3_ = description;
#line 132 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin.vala"
	_tmp4_ = capabilities;
#line 132 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin.vala"
	self = (RygelPlugin*) g_object_new (object_type, "desc-path", _tmp0_, "name", _tmp1_, "title", _tmp2_, "description", _tmp3_, "capabilities", _tmp4_, NULL);
#line 127 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin.vala"
	return self;
#line 281 "rygel-plugin.c"
}


RygelPlugin* rygel_plugin_new (const gchar* desc_path, const gchar* name, const gchar* title, const gchar* description, RygelPluginCapabilities capabilities) {
#line 127 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin.vala"
	return rygel_plugin_construct (RYGEL_TYPE_PLUGIN, desc_path, name, title, description, capabilities);
#line 288 "rygel-plugin.c"
}


static void rygel_plugin_real_constructed (GObject* base) {
	RygelPlugin * self;
	const gchar* _tmp0_;
	GeeArrayList* _tmp2_;
	GeeArrayList* _tmp3_;
	GeeArrayList* _tmp4_;
	GeeArrayList* _tmp5_;
	GeeArrayList* _tmp6_;
	GeeArrayList* _tmp7_;
#line 139 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin.vala"
	self = (RygelPlugin*) base;
#line 140 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin.vala"
	G_OBJECT_CLASS (rygel_plugin_parent_class)->constructed ((GObject*) G_TYPE_CHECK_INSTANCE_CAST (self, gupnp_resource_factory_get_type (), GUPnPResourceFactory));
#line 142 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin.vala"
	rygel_plugin_set_active (self, TRUE);
#line 144 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin.vala"
	_tmp0_ = self->priv->_title;
#line 144 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin.vala"
	if (_tmp0_ == NULL) {
#line 311 "rygel-plugin.c"
		const gchar* _tmp1_;
#line 145 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin.vala"
		_tmp1_ = self->priv->_name;
#line 145 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin.vala"
		rygel_plugin_set_title (self, _tmp1_);
#line 317 "rygel-plugin.c"
	}
#line 148 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin.vala"
	_tmp2_ = gee_array_list_new (RYGEL_TYPE_RESOURCE_INFO, (GBoxedCopyFunc) rygel_resource_info_ref, rygel_resource_info_unref, NULL, NULL, NULL);
#line 148 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin.vala"
	_tmp3_ = _tmp2_;
#line 148 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin.vala"
	rygel_plugin_set_resource_infos (self, _tmp3_);
#line 148 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin.vala"
	_g_object_unref0 (_tmp3_);
#line 149 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin.vala"
	_tmp4_ = gee_array_list_new (RYGEL_TYPE_ICON_INFO, (GBoxedCopyFunc) rygel_icon_info_ref, rygel_icon_info_unref, NULL, NULL, NULL);
#line 149 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin.vala"
	_tmp5_ = _tmp4_;
#line 149 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin.vala"
	rygel_plugin_set_icon_infos (self, _tmp5_);
#line 149 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin.vala"
	_g_object_unref0 (_tmp5_);
#line 150 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin.vala"
	_tmp6_ = gee_array_list_new (RYGEL_TYPE_ICON_INFO, (GBoxedCopyFunc) rygel_icon_info_ref, rygel_icon_info_unref, NULL, NULL, NULL);
#line 150 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin.vala"
	_tmp7_ = _tmp6_;
#line 150 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin.vala"
	rygel_plugin_set_default_icons (self, _tmp7_);
#line 150 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin.vala"
	_g_object_unref0 (_tmp7_);
#line 153 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin.vala"
	rygel_plugin_add_default_icon (self, RYGEL_PLUGIN_ICON_PNG_MIME, RYGEL_PLUGIN_PNG_EXT, RYGEL_PLUGIN_ICON_PNG_BIG, RYGEL_PLUGIN_ICON_BIG_WIDTH, RYGEL_PLUGIN_ICON_BIG_HEIGHT, RYGEL_PLUGIN_ICON_PNG_DEPTH);
#line 159 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin.vala"
	rygel_plugin_add_default_icon (self, RYGEL_PLUGIN_ICON_PNG_MIME, RYGEL_PLUGIN_PNG_EXT, RYGEL_PLUGIN_ICON_PNG_SMALL, RYGEL_PLUGIN_ICON_SMALL_WIDTH, RYGEL_PLUGIN_ICON_SMALL_HEIGHT, RYGEL_PLUGIN_ICON_PNG_DEPTH);
#line 167 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin.vala"
	rygel_plugin_add_default_icon (self, RYGEL_PLUGIN_ICON_JPG_MIME, RYGEL_PLUGIN_JPG_EXT, RYGEL_PLUGIN_ICON_JPG_BIG, RYGEL_PLUGIN_ICON_BIG_WIDTH, RYGEL_PLUGIN_ICON_BIG_HEIGHT, RYGEL_PLUGIN_ICON_JPG_DEPTH);
#line 173 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin.vala"
	rygel_plugin_add_default_icon (self, RYGEL_PLUGIN_ICON_JPG_MIME, RYGEL_PLUGIN_JPG_EXT, RYGEL_PLUGIN_ICON_JPG_SMALL, RYGEL_PLUGIN_ICON_SMALL_WIDTH, RYGEL_PLUGIN_ICON_SMALL_HEIGHT, RYGEL_PLUGIN_ICON_JPG_DEPTH);
#line 351 "rygel-plugin.c"
}


void rygel_plugin_add_resource (RygelPlugin* self, RygelResourceInfo* resource_info) {
	GeeArrayList* _tmp0_;
	RygelResourceInfo* _tmp1_;
	RygelResourceInfo* _tmp2_;
	const gchar* _tmp3_;
	RygelResourceInfo* _tmp4_;
	GType _tmp5_;
#line 181 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin.vala"
	g_return_if_fail (self != NULL);
#line 181 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin.vala"
	g_return_if_fail (resource_info != NULL);
#line 182 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin.vala"
	_tmp0_ = self->priv->_resource_infos;
#line 182 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin.vala"
	_tmp1_ = resource_info;
#line 182 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin.vala"
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp0_, _tmp1_);
#line 183 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin.vala"
	_tmp2_ = resource_info;
#line 183 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin.vala"
	_tmp3_ = _tmp2_->upnp_type;
#line 183 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin.vala"
	_tmp4_ = resource_info;
#line 183 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin.vala"
	_tmp5_ = _tmp4_->type;
#line 183 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin.vala"
	gupnp_resource_factory_register_resource_type ((GUPnPResourceFactory*) self, _tmp3_, _tmp5_);
#line 382 "rygel-plugin.c"
}


void rygel_plugin_add_icon (RygelPlugin* self, RygelIconInfo* icon_info) {
	GeeArrayList* _tmp0_;
	RygelIconInfo* _tmp1_;
#line 187 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin.vala"
	g_return_if_fail (self != NULL);
#line 187 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin.vala"
	g_return_if_fail (icon_info != NULL);
#line 188 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin.vala"
	_tmp0_ = self->priv->_icon_infos;
#line 188 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin.vala"
	_tmp1_ = icon_info;
#line 188 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin.vala"
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp0_, _tmp1_);
#line 399 "rygel-plugin.c"
}


static void rygel_plugin_real_apply_hacks (RygelPlugin* self, RygelRootDevice* device, const gchar* description_path, GError** error) {
#line 191 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin.vala"
	g_return_if_fail (device != NULL);
#line 191 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin.vala"
	g_return_if_fail (description_path != NULL);
#line 408 "rygel-plugin.c"
}


void rygel_plugin_apply_hacks (RygelPlugin* self, RygelRootDevice* device, const gchar* description_path, GError** error) {
#line 191 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin.vala"
	g_return_if_fail (self != NULL);
#line 191 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin.vala"
	RYGEL_PLUGIN_GET_CLASS (self)->apply_hacks (self, device, description_path, error);
#line 417 "rygel-plugin.c"
}


static void rygel_plugin_add_default_icon (RygelPlugin* self, const gchar* mime_type, const gchar* file_extension, const gchar* uri, gint width, gint height, gint depth) {
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	RygelIconInfo* _tmp2_;
	RygelIconInfo* icon;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	gint _tmp5_;
	gint _tmp6_;
	gint _tmp7_;
	GeeArrayList* _tmp8_;
#line 196 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin.vala"
	g_return_if_fail (self != NULL);
#line 196 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin.vala"
	g_return_if_fail (mime_type != NULL);
#line 196 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin.vala"
	g_return_if_fail (file_extension != NULL);
#line 196 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin.vala"
	g_return_if_fail (uri != NULL);
#line 202 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin.vala"
	_tmp0_ = mime_type;
#line 202 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin.vala"
	_tmp1_ = file_extension;
#line 202 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin.vala"
	_tmp2_ = rygel_icon_info_new (_tmp0_, _tmp1_);
#line 202 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin.vala"
	icon = _tmp2_;
#line 203 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin.vala"
	_tmp3_ = uri;
#line 203 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin.vala"
	_tmp4_ = g_strdup (_tmp3_);
#line 203 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin.vala"
	_g_free0 (icon->uri);
#line 203 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin.vala"
	icon->uri = _tmp4_;
#line 204 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin.vala"
	_tmp5_ = width;
#line 204 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin.vala"
	icon->width = _tmp5_;
#line 205 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin.vala"
	_tmp6_ = height;
#line 205 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin.vala"
	icon->height = _tmp6_;
#line 206 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin.vala"
	_tmp7_ = depth;
#line 206 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin.vala"
	icon->depth = _tmp7_;
#line 208 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin.vala"
	_tmp8_ = self->priv->_default_icons;
#line 208 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin.vala"
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp8_, icon);
#line 196 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin.vala"
	_rygel_icon_info_unref0 (icon);
#line 474 "rygel-plugin.c"
}


RygelPluginCapabilities rygel_plugin_get_capabilities (RygelPlugin* self) {
	RygelPluginCapabilities result;
	RygelPluginCapabilities _tmp0_;
#line 97 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 97 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin.vala"
	_tmp0_ = self->priv->_capabilities;
#line 97 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin.vala"
	result = _tmp0_;
#line 97 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin.vala"
	return result;
#line 489 "rygel-plugin.c"
}


void rygel_plugin_set_capabilities (RygelPlugin* self, RygelPluginCapabilities value) {
	RygelPluginCapabilities _tmp0_;
#line 97 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin.vala"
	g_return_if_fail (self != NULL);
#line 97 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin.vala"
	_tmp0_ = value;
#line 97 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin.vala"
	self->priv->_capabilities = _tmp0_;
#line 97 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin.vala"
	g_object_notify ((GObject *) self, "capabilities");
#line 503 "rygel-plugin.c"
}


const gchar* rygel_plugin_get_name (RygelPlugin* self) {
	const gchar* result;
	const gchar* _tmp0_;
#line 99 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 99 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin.vala"
	_tmp0_ = self->priv->_name;
#line 99 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin.vala"
	result = _tmp0_;
#line 99 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin.vala"
	return result;
#line 518 "rygel-plugin.c"
}


static void rygel_plugin_set_name (RygelPlugin* self, const gchar* value) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
#line 99 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin.vala"
	g_return_if_fail (self != NULL);
#line 99 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin.vala"
	_tmp0_ = value;
#line 99 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 99 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin.vala"
	_g_free0 (self->priv->_name);
#line 99 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin.vala"
	self->priv->_name = _tmp1_;
#line 99 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin.vala"
	g_object_notify ((GObject *) self, "name");
#line 537 "rygel-plugin.c"
}


const gchar* rygel_plugin_get_title (RygelPlugin* self) {
	const gchar* result;
	const gchar* _tmp0_;
#line 100 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 100 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin.vala"
	_tmp0_ = self->priv->_title;
#line 100 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin.vala"
	result = _tmp0_;
#line 100 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin.vala"
	return result;
#line 552 "rygel-plugin.c"
}


void rygel_plugin_set_title (RygelPlugin* self, const gchar* value) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
#line 100 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin.vala"
	g_return_if_fail (self != NULL);
#line 100 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin.vala"
	_tmp0_ = value;
#line 100 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 100 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin.vala"
	_g_free0 (self->priv->_title);
#line 100 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin.vala"
	self->priv->_title = _tmp1_;
#line 100 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin.vala"
	g_object_notify ((GObject *) self, "title");
#line 571 "rygel-plugin.c"
}


const gchar* rygel_plugin_get_description (RygelPlugin* self) {
	const gchar* result;
	const gchar* _tmp0_;
#line 101 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 101 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin.vala"
	_tmp0_ = self->priv->_description;
#line 101 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin.vala"
	result = _tmp0_;
#line 101 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin.vala"
	return result;
#line 586 "rygel-plugin.c"
}


static void rygel_plugin_set_description (RygelPlugin* self, const gchar* value) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
#line 101 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin.vala"
	g_return_if_fail (self != NULL);
#line 101 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin.vala"
	_tmp0_ = value;
#line 101 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 101 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin.vala"
	_g_free0 (self->priv->_description);
#line 101 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin.vala"
	self->priv->_description = _tmp1_;
#line 101 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin.vala"
	g_object_notify ((GObject *) self, "description");
#line 605 "rygel-plugin.c"
}


const gchar* rygel_plugin_get_desc_path (RygelPlugin* self) {
	const gchar* result;
	const gchar* _tmp0_;
#line 104 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 104 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin.vala"
	_tmp0_ = self->priv->_desc_path;
#line 104 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin.vala"
	result = _tmp0_;
#line 104 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin.vala"
	return result;
#line 620 "rygel-plugin.c"
}


static void rygel_plugin_set_desc_path (RygelPlugin* self, const gchar* value) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
#line 104 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin.vala"
	g_return_if_fail (self != NULL);
#line 104 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin.vala"
	_tmp0_ = value;
#line 104 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 104 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin.vala"
	_g_free0 (self->priv->_desc_path);
#line 104 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin.vala"
	self->priv->_desc_path = _tmp1_;
#line 104 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin.vala"
	g_object_notify ((GObject *) self, "desc-path");
#line 639 "rygel-plugin.c"
}


gboolean rygel_plugin_get_active (RygelPlugin* self) {
	gboolean result;
	gboolean _tmp0_;
#line 106 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 106 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin.vala"
	_tmp0_ = self->priv->_active;
#line 106 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin.vala"
	result = _tmp0_;
#line 106 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin.vala"
	return result;
#line 654 "rygel-plugin.c"
}


void rygel_plugin_set_active (RygelPlugin* self, gboolean value) {
	gboolean _tmp0_;
#line 106 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin.vala"
	g_return_if_fail (self != NULL);
#line 106 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin.vala"
	_tmp0_ = value;
#line 106 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin.vala"
	self->priv->_active = _tmp0_;
#line 106 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin.vala"
	g_object_notify ((GObject *) self, "active");
#line 668 "rygel-plugin.c"
}


GeeArrayList* rygel_plugin_get_resource_infos (RygelPlugin* self) {
	GeeArrayList* result;
	GeeArrayList* _tmp0_;
#line 108 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 108 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin.vala"
	_tmp0_ = self->priv->_resource_infos;
#line 108 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin.vala"
	result = _tmp0_;
#line 108 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin.vala"
	return result;
#line 683 "rygel-plugin.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 108 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin.vala"
	return self ? g_object_ref (self) : NULL;
#line 690 "rygel-plugin.c"
}


static void rygel_plugin_set_resource_infos (RygelPlugin* self, GeeArrayList* value) {
	GeeArrayList* _tmp0_;
	GeeArrayList* _tmp1_;
#line 108 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin.vala"
	g_return_if_fail (self != NULL);
#line 108 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin.vala"
	_tmp0_ = value;
#line 108 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 108 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin.vala"
	_g_object_unref0 (self->priv->_resource_infos);
#line 108 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin.vala"
	self->priv->_resource_infos = _tmp1_;
#line 108 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin.vala"
	g_object_notify ((GObject *) self, "resource-infos");
#line 709 "rygel-plugin.c"
}


GeeArrayList* rygel_plugin_get_icon_infos (RygelPlugin* self) {
	GeeArrayList* result;
	GeeArrayList* _tmp0_;
#line 109 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 109 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin.vala"
	_tmp0_ = self->priv->_icon_infos;
#line 109 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin.vala"
	result = _tmp0_;
#line 109 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin.vala"
	return result;
#line 724 "rygel-plugin.c"
}


static void rygel_plugin_set_icon_infos (RygelPlugin* self, GeeArrayList* value) {
	GeeArrayList* _tmp0_;
	GeeArrayList* _tmp1_;
#line 109 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin.vala"
	g_return_if_fail (self != NULL);
#line 109 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin.vala"
	_tmp0_ = value;
#line 109 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 109 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin.vala"
	_g_object_unref0 (self->priv->_icon_infos);
#line 109 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin.vala"
	self->priv->_icon_infos = _tmp1_;
#line 109 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin.vala"
	g_object_notify ((GObject *) self, "icon-infos");
#line 743 "rygel-plugin.c"
}


GeeArrayList* rygel_plugin_get_default_icons (RygelPlugin* self) {
	GeeArrayList* result;
	GeeArrayList* _tmp0_;
#line 111 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 111 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin.vala"
	_tmp0_ = self->priv->_default_icons;
#line 111 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin.vala"
	result = _tmp0_;
#line 111 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin.vala"
	return result;
#line 758 "rygel-plugin.c"
}


static void rygel_plugin_set_default_icons (RygelPlugin* self, GeeArrayList* value) {
	GeeArrayList* _tmp0_;
	GeeArrayList* _tmp1_;
#line 111 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin.vala"
	g_return_if_fail (self != NULL);
#line 111 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin.vala"
	_tmp0_ = value;
#line 111 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 111 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin.vala"
	_g_object_unref0 (self->priv->_default_icons);
#line 111 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin.vala"
	self->priv->_default_icons = _tmp1_;
#line 111 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin.vala"
	g_object_notify ((GObject *) self, "default-icons");
#line 777 "rygel-plugin.c"
}


static void rygel_plugin_class_init (RygelPluginClass * klass) {
#line 70 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin.vala"
	rygel_plugin_parent_class = g_type_class_peek_parent (klass);
#line 70 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin.vala"
	g_type_class_add_private (klass, sizeof (RygelPluginPrivate));
#line 70 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin.vala"
	G_OBJECT_CLASS (klass)->constructed = rygel_plugin_real_constructed;
#line 70 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin.vala"
	RYGEL_PLUGIN_CLASS (klass)->apply_hacks = rygel_plugin_real_apply_hacks;
#line 70 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_rygel_plugin_get_property;
#line 70 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_rygel_plugin_set_property;
#line 70 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin.vala"
	G_OBJECT_CLASS (klass)->finalize = rygel_plugin_finalize;
#line 70 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_PLUGIN_CAPABILITIES, g_param_spec_flags ("capabilities", "capabilities", "capabilities", RYGEL_TYPE_PLUGIN_CAPABILITIES, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
#line 70 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_PLUGIN_NAME, g_param_spec_string ("name", "name", "name", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
#line 70 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_PLUGIN_TITLE, g_param_spec_string ("title", "title", "title", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
#line 70 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_PLUGIN_DESCRIPTION, g_param_spec_string ("description", "description", "description", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
#line 70 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_PLUGIN_DESC_PATH, g_param_spec_string ("desc-path", "desc-path", "desc-path", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
#line 70 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_PLUGIN_ACTIVE, g_param_spec_boolean ("active", "active", "active", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 70 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_PLUGIN_RESOURCE_INFOS, g_param_spec_object ("resource-infos", "resource-infos", "resource-infos", GEE_TYPE_ARRAY_LIST, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 70 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_PLUGIN_ICON_INFOS, g_param_spec_object ("icon-infos", "icon-infos", "icon-infos", GEE_TYPE_ARRAY_LIST, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 70 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_PLUGIN_DEFAULT_ICONS, g_param_spec_object ("default-icons", "default-icons", "default-icons", GEE_TYPE_ARRAY_LIST, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 814 "rygel-plugin.c"
}


static void rygel_plugin_instance_init (RygelPlugin * self) {
#line 70 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin.vala"
	self->priv = RYGEL_PLUGIN_GET_PRIVATE (self);
#line 821 "rygel-plugin.c"
}


static void rygel_plugin_finalize (GObject* obj) {
	RygelPlugin * self;
#line 70 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_PLUGIN, RygelPlugin);
#line 99 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin.vala"
	_g_free0 (self->priv->_name);
#line 100 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin.vala"
	_g_free0 (self->priv->_title);
#line 101 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin.vala"
	_g_free0 (self->priv->_description);
#line 104 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin.vala"
	_g_free0 (self->priv->_desc_path);
#line 108 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin.vala"
	_g_object_unref0 (self->priv->_resource_infos);
#line 109 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin.vala"
	_g_object_unref0 (self->priv->_icon_infos);
#line 111 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin.vala"
	_g_object_unref0 (self->priv->_default_icons);
#line 70 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin.vala"
	G_OBJECT_CLASS (rygel_plugin_parent_class)->finalize (obj);
#line 845 "rygel-plugin.c"
}


/**
 * This represents a Rygel plugin.
 *
 * Plugin libraries should provide an object of this
 * class or a subclass in their module_init() function.
 *
 * It is generally convenient to derive from 
 * #RygelMediaRendererPlugin from librygel-renderer,
 * or from #RygelMediaServerPlugin from librygel-server.
 *
 * Plugins may change their behaviour based on their
 * configuration. See rygel_meta_config_get_default().
 */
GType rygel_plugin_get_type (void) {
	static volatile gsize rygel_plugin_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_plugin_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelPluginClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_plugin_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelPlugin), 0, (GInstanceInitFunc) rygel_plugin_instance_init, NULL };
		GType rygel_plugin_type_id;
		rygel_plugin_type_id = g_type_register_static (gupnp_resource_factory_get_type (), "RygelPlugin", &g_define_type_info, 0);
		g_once_init_leave (&rygel_plugin_type_id__volatile, rygel_plugin_type_id);
	}
	return rygel_plugin_type_id__volatile;
}


static void _vala_rygel_plugin_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	RygelPlugin * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_PLUGIN, RygelPlugin);
#line 70 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin.vala"
	switch (property_id) {
#line 70 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin.vala"
		case RYGEL_PLUGIN_CAPABILITIES:
#line 70 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin.vala"
		g_value_set_flags (value, rygel_plugin_get_capabilities (self));
#line 70 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin.vala"
		break;
#line 70 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin.vala"
		case RYGEL_PLUGIN_NAME:
#line 70 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin.vala"
		g_value_set_string (value, rygel_plugin_get_name (self));
#line 70 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin.vala"
		break;
#line 70 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin.vala"
		case RYGEL_PLUGIN_TITLE:
#line 70 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin.vala"
		g_value_set_string (value, rygel_plugin_get_title (self));
#line 70 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin.vala"
		break;
#line 70 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin.vala"
		case RYGEL_PLUGIN_DESCRIPTION:
#line 70 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin.vala"
		g_value_set_string (value, rygel_plugin_get_description (self));
#line 70 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin.vala"
		break;
#line 70 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin.vala"
		case RYGEL_PLUGIN_DESC_PATH:
#line 70 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin.vala"
		g_value_set_string (value, rygel_plugin_get_desc_path (self));
#line 70 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin.vala"
		break;
#line 70 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin.vala"
		case RYGEL_PLUGIN_ACTIVE:
#line 70 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin.vala"
		g_value_set_boolean (value, rygel_plugin_get_active (self));
#line 70 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin.vala"
		break;
#line 70 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin.vala"
		case RYGEL_PLUGIN_RESOURCE_INFOS:
#line 70 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin.vala"
		g_value_set_object (value, rygel_plugin_get_resource_infos (self));
#line 70 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin.vala"
		break;
#line 70 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin.vala"
		case RYGEL_PLUGIN_ICON_INFOS:
#line 70 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin.vala"
		g_value_set_object (value, rygel_plugin_get_icon_infos (self));
#line 70 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin.vala"
		break;
#line 70 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin.vala"
		case RYGEL_PLUGIN_DEFAULT_ICONS:
#line 70 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin.vala"
		g_value_set_object (value, rygel_plugin_get_default_icons (self));
#line 70 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin.vala"
		break;
#line 933 "rygel-plugin.c"
		default:
#line 70 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 70 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin.vala"
		break;
#line 939 "rygel-plugin.c"
	}
}


static void _vala_rygel_plugin_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	RygelPlugin * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_PLUGIN, RygelPlugin);
#line 70 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin.vala"
	switch (property_id) {
#line 70 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin.vala"
		case RYGEL_PLUGIN_CAPABILITIES:
#line 70 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin.vala"
		rygel_plugin_set_capabilities (self, g_value_get_flags (value));
#line 70 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin.vala"
		break;
#line 70 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin.vala"
		case RYGEL_PLUGIN_NAME:
#line 70 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin.vala"
		rygel_plugin_set_name (self, g_value_get_string (value));
#line 70 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin.vala"
		break;
#line 70 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin.vala"
		case RYGEL_PLUGIN_TITLE:
#line 70 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin.vala"
		rygel_plugin_set_title (self, g_value_get_string (value));
#line 70 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin.vala"
		break;
#line 70 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin.vala"
		case RYGEL_PLUGIN_DESCRIPTION:
#line 70 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin.vala"
		rygel_plugin_set_description (self, g_value_get_string (value));
#line 70 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin.vala"
		break;
#line 70 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin.vala"
		case RYGEL_PLUGIN_DESC_PATH:
#line 70 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin.vala"
		rygel_plugin_set_desc_path (self, g_value_get_string (value));
#line 70 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin.vala"
		break;
#line 70 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin.vala"
		case RYGEL_PLUGIN_ACTIVE:
#line 70 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin.vala"
		rygel_plugin_set_active (self, g_value_get_boolean (value));
#line 70 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin.vala"
		break;
#line 70 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin.vala"
		case RYGEL_PLUGIN_RESOURCE_INFOS:
#line 70 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin.vala"
		rygel_plugin_set_resource_infos (self, g_value_get_object (value));
#line 70 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin.vala"
		break;
#line 70 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin.vala"
		case RYGEL_PLUGIN_ICON_INFOS:
#line 70 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin.vala"
		rygel_plugin_set_icon_infos (self, g_value_get_object (value));
#line 70 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin.vala"
		break;
#line 70 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin.vala"
		case RYGEL_PLUGIN_DEFAULT_ICONS:
#line 70 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin.vala"
		rygel_plugin_set_default_icons (self, g_value_get_object (value));
#line 70 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin.vala"
		break;
#line 1003 "rygel-plugin.c"
		default:
#line 70 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 70 "/home/jens/Source/rygel/src/librygel-core/rygel-plugin.vala"
		break;
#line 1009 "rygel-plugin.c"
	}
}



