/* rygel-av-transport.c generated by valac 0.20.1, the Vala compiler
 * generated from rygel-av-transport.vala, do not modify */

/*
 * Copyright (C) 2008 OpenedHand Ltd.
 * Copyright (C) 2009,2010 Nokia Corporation.
 * Copyright (C) 2012 Openismus GmbH.
 *
 * Author: Jorn Baayen <jorn@openedhand.com>
 *         Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *         Jens Georg <jensg@openismus.com>
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <libgupnp/gupnp.h>
#include <libsoup/soup.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>
#include <rygel-core.h>
#include <glib/gi18n-lib.h>
#include <libgupnp-av/gupnp-av.h>
#include <gio/gio.h>


#define RYGEL_TYPE_AV_TRANSPORT (rygel_av_transport_get_type ())
#define RYGEL_AV_TRANSPORT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_AV_TRANSPORT, RygelAVTransport))
#define RYGEL_AV_TRANSPORT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_AV_TRANSPORT, RygelAVTransportClass))
#define RYGEL_IS_AV_TRANSPORT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_AV_TRANSPORT))
#define RYGEL_IS_AV_TRANSPORT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_AV_TRANSPORT))
#define RYGEL_AV_TRANSPORT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_AV_TRANSPORT, RygelAVTransportClass))

typedef struct _RygelAVTransport RygelAVTransport;
typedef struct _RygelAVTransportClass RygelAVTransportClass;
typedef struct _RygelAVTransportPrivate RygelAVTransportPrivate;

#define RYGEL_TYPE_CHANGE_LOG (rygel_change_log_get_type ())
#define RYGEL_CHANGE_LOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_CHANGE_LOG, RygelChangeLog))
#define RYGEL_CHANGE_LOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_CHANGE_LOG, RygelChangeLogClass))
#define RYGEL_IS_CHANGE_LOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_CHANGE_LOG))
#define RYGEL_IS_CHANGE_LOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_CHANGE_LOG))
#define RYGEL_CHANGE_LOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_CHANGE_LOG, RygelChangeLogClass))

typedef struct _RygelChangeLog RygelChangeLog;
typedef struct _RygelChangeLogClass RygelChangeLogClass;

#define RYGEL_TYPE_MEDIA_PLAYER (rygel_media_player_get_type ())
#define RYGEL_MEDIA_PLAYER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_PLAYER, RygelMediaPlayer))
#define RYGEL_IS_MEDIA_PLAYER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_PLAYER))
#define RYGEL_MEDIA_PLAYER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_MEDIA_PLAYER, RygelMediaPlayerIface))

typedef struct _RygelMediaPlayer RygelMediaPlayer;
typedef struct _RygelMediaPlayerIface RygelMediaPlayerIface;

#define RYGEL_TYPE_PLAYER_CONTROLLER (rygel_player_controller_get_type ())
#define RYGEL_PLAYER_CONTROLLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_PLAYER_CONTROLLER, RygelPlayerController))
#define RYGEL_PLAYER_CONTROLLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_PLAYER_CONTROLLER, RygelPlayerControllerClass))
#define RYGEL_IS_PLAYER_CONTROLLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_PLAYER_CONTROLLER))
#define RYGEL_IS_PLAYER_CONTROLLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_PLAYER_CONTROLLER))
#define RYGEL_PLAYER_CONTROLLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_PLAYER_CONTROLLER, RygelPlayerControllerClass))

typedef struct _RygelPlayerController RygelPlayerController;
typedef struct _RygelPlayerControllerClass RygelPlayerControllerClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define RYGEL_TYPE_MEDIA_RENDERER_PLUGIN (rygel_media_renderer_plugin_get_type ())
#define RYGEL_MEDIA_RENDERER_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_RENDERER_PLUGIN, RygelMediaRendererPlugin))
#define RYGEL_MEDIA_RENDERER_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_RENDERER_PLUGIN, RygelMediaRendererPluginClass))
#define RYGEL_IS_MEDIA_RENDERER_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_RENDERER_PLUGIN))
#define RYGEL_IS_MEDIA_RENDERER_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_RENDERER_PLUGIN))
#define RYGEL_MEDIA_RENDERER_PLUGIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_RENDERER_PLUGIN, RygelMediaRendererPluginClass))

typedef struct _RygelMediaRendererPlugin RygelMediaRendererPlugin;
typedef struct _RygelMediaRendererPluginClass RygelMediaRendererPluginClass;
#define __vala_SoupURI_free0(var) ((var == NULL) ? NULL : (var = (_vala_SoupURI_free (var), NULL)))
#define __vala_GUPnPServiceAction_free0(var) ((var == NULL) ? NULL : (var = (_vala_GUPnPServiceAction_free (var), NULL)))
typedef struct _Block1Data Block1Data;
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _Block2Data Block2Data;
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))
typedef struct _RygelAvTransportHandlePlaylistData RygelAvTransportHandlePlaylistData;

struct _RygelAVTransport {
	GUPnPService parent_instance;
	RygelAVTransportPrivate * priv;
};

struct _RygelAVTransportClass {
	GUPnPServiceClass parent_class;
};

struct _RygelMediaPlayerIface {
	GTypeInterface parent_iface;
	gboolean (*seek) (RygelMediaPlayer* self, gint64 time);
	gchar** (*get_protocols) (RygelMediaPlayer* self, int* result_length1);
	gchar** (*get_mime_types) (RygelMediaPlayer* self, int* result_length1);
	gchar* (*get_playback_state) (RygelMediaPlayer* self);
	void (*set_playback_state) (RygelMediaPlayer* self, const gchar* value);
	gchar** (*get_allowed_playback_speeds) (RygelMediaPlayer* self, int* result_length1);
	gchar* (*get_playback_speed) (RygelMediaPlayer* self);
	void (*set_playback_speed) (RygelMediaPlayer* self, const gchar* value);
	gchar* (*get_uri) (RygelMediaPlayer* self);
	void (*set_uri) (RygelMediaPlayer* self, const gchar* value);
	gdouble (*get_volume) (RygelMediaPlayer* self);
	void (*set_volume) (RygelMediaPlayer* self, gdouble value);
	gint64 (*get_duration) (RygelMediaPlayer* self);
	gchar* (*get_metadata) (RygelMediaPlayer* self);
	void (*set_metadata) (RygelMediaPlayer* self, const gchar* value);
	gchar* (*get_mime_type) (RygelMediaPlayer* self);
	void (*set_mime_type) (RygelMediaPlayer* self, const gchar* value);
	gboolean (*get_can_seek) (RygelMediaPlayer* self);
	gchar* (*get_content_features) (RygelMediaPlayer* self);
	void (*set_content_features) (RygelMediaPlayer* self, const gchar* value);
	gint64 (*get_position) (RygelMediaPlayer* self);
};

struct _RygelAVTransportPrivate {
	SoupSession* session;
	gchar* protocol_info;
	gchar* _status;
	gchar* _mode;
	RygelChangeLog* changelog;
	RygelMediaPlayer* player;
	RygelPlayerController* controller;
};

struct _Block1Data {
	int _ref_count_;
	RygelAVTransport * self;
	gchar* _uri;
	gchar* _metadata;
	GUPnPServiceAction* action;
};

struct _Block2Data {
	int _ref_count_;
	RygelAVTransport * self;
	gpointer _async_data_;
};

struct _RygelAvTransportHandlePlaylistData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelAVTransport* self;
	GUPnPServiceAction* action;
	Block2Data* _data2_;
	RygelPlayerController* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	SoupMessage* _tmp3_;
	SoupMessage* message;
	SoupSession* _tmp4_;
	SoupMessage* _tmp5_;
	SoupMessage* _tmp6_;
	SoupMessage* _tmp7_;
	guint _tmp8_;
	guint _tmp9_;
	GUPnPServiceAction* _tmp10_;
	const gchar* _tmp11_;
	SoupMessage* _tmp12_;
	SoupMessageBody* _tmp13_;
	guint8* _tmp14_;
	gint _tmp14__length1;
	const gchar* xml_string;
	const gchar* _tmp15_;
	GUPnPMediaCollection* _tmp16_;
	GUPnPMediaCollection* collection;
	GUPnPMediaCollection* _tmp17_;
	GList* _tmp18_;
	GList* _tmp19_;
	guint _tmp20_;
	gboolean _tmp21_;
	GUPnPServiceAction* _tmp22_;
	const gchar* _tmp23_;
	RygelPlayerController* _tmp24_;
	GUPnPMediaCollection* _tmp25_;
	GUPnPServiceAction* _tmp26_;
};


static gpointer rygel_av_transport_parent_class = NULL;

GType rygel_av_transport_get_type (void) G_GNUC_CONST;
GType rygel_change_log_get_type (void) G_GNUC_CONST;
GType rygel_media_player_get_type (void) G_GNUC_CONST;
GType rygel_player_controller_get_type (void) G_GNUC_CONST;
#define RYGEL_AV_TRANSPORT_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_AV_TRANSPORT, RygelAVTransportPrivate))
enum  {
	RYGEL_AV_TRANSPORT_DUMMY_PROPERTY,
	RYGEL_AV_TRANSPORT_TRACK_METADATA,
	RYGEL_AV_TRANSPORT_TRACK_URI,
	RYGEL_AV_TRANSPORT_STATUS,
	RYGEL_AV_TRANSPORT_SPEED,
	RYGEL_AV_TRANSPORT_MODE
};
#define RYGEL_AV_TRANSPORT_UPNP_ID "urn:upnp-org:serviceId:AVTransport"
#define RYGEL_AV_TRANSPORT_UPNP_TYPE "urn:schemas-upnp-org:service:AVTransport:2"
#define RYGEL_AV_TRANSPORT_UPNP_TYPE_V1 "urn:schemas-upnp-org:service:AVTransport:1"
#define RYGEL_AV_TRANSPORT_DESCRIPTION_PATH "xml/AVTransport2.xml"
#define RYGEL_AV_TRANSPORT_LAST_CHANGE_NS "urn:schemas-upnp-org:metadata-1-0/AVT/"
static void rygel_av_transport_real_constructed (GObject* base);
GType rygel_media_renderer_plugin_get_type (void) G_GNUC_CONST;
RygelChangeLog* rygel_change_log_new (GUPnPService* service, const gchar* service_ns);
RygelChangeLog* rygel_change_log_construct (GType object_type, GUPnPService* service, const gchar* service_ns);
static RygelMediaPlayer* rygel_av_transport_get_player (RygelAVTransport* self);
RygelPlayerController* rygel_media_renderer_plugin_get_controller (RygelMediaRendererPlugin* self);
static void rygel_av_transport_query_last_change_cb (RygelAVTransport* self, GUPnPService* service, const gchar* variable, GValue* value);
static void _rygel_av_transport_query_last_change_cb_gupnp_service_query_variable (GUPnPService* _sender, const gchar* variable, GValue* value, gpointer self);
static void rygel_av_transport_set_av_transport_uri_cb (RygelAVTransport* self, GUPnPService* service, GUPnPServiceAction* action);
static void _rygel_av_transport_set_av_transport_uri_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self);
static void rygel_av_transport_get_media_info_cb (RygelAVTransport* self, GUPnPService* service, GUPnPServiceAction* action);
static void _rygel_av_transport_get_media_info_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self);
static void rygel_av_transport_get_media_info_ex_cb (RygelAVTransport* self, GUPnPService* service, GUPnPServiceAction* action);
static void _rygel_av_transport_get_media_info_ex_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self);
static void rygel_av_transport_get_transport_info_cb (RygelAVTransport* self, GUPnPService* service, GUPnPServiceAction* action);
static void _rygel_av_transport_get_transport_info_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self);
static void rygel_av_transport_get_position_info_cb (RygelAVTransport* self, GUPnPService* service, GUPnPServiceAction* action);
static void _rygel_av_transport_get_position_info_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self);
static void rygel_av_transport_get_device_capabilities_cb (RygelAVTransport* self, GUPnPService* service, GUPnPServiceAction* action);
static void _rygel_av_transport_get_device_capabilities_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self);
static void rygel_av_transport_get_transport_settings_cb (RygelAVTransport* self, GUPnPService* service, GUPnPServiceAction* action);
static void _rygel_av_transport_get_transport_settings_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self);
static void rygel_av_transport_get_transport_actions_cb (RygelAVTransport* self, GUPnPService* service, GUPnPServiceAction* action);
static void _rygel_av_transport_get_transport_actions_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self);
static void rygel_av_transport_stop_cb (RygelAVTransport* self, GUPnPService* service, GUPnPServiceAction* action);
static void _rygel_av_transport_stop_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self);
static void rygel_av_transport_play_cb (RygelAVTransport* self, GUPnPService* service, GUPnPServiceAction* action);
static void _rygel_av_transport_play_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self);
static void rygel_av_transport_pause_cb (RygelAVTransport* self, GUPnPService* service, GUPnPServiceAction* action);
static void _rygel_av_transport_pause_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self);
static void rygel_av_transport_seek_cb (RygelAVTransport* self, GUPnPService* service, GUPnPServiceAction* action);
static void _rygel_av_transport_seek_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self);
static void rygel_av_transport_next_cb (RygelAVTransport* self, GUPnPService* service, GUPnPServiceAction* action);
static void _rygel_av_transport_next_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self);
static void rygel_av_transport_previous_cb (RygelAVTransport* self, GUPnPService* service, GUPnPServiceAction* action);
static void _rygel_av_transport_previous_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self);
static void rygel_av_transport_notify_state_cb (RygelAVTransport* self, GObject* player, GParamSpec* p);
static void _rygel_av_transport_notify_state_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void rygel_av_transport_notify_n_tracks_cb (RygelAVTransport* self, GObject* player, GParamSpec* p);
static void _rygel_av_transport_notify_n_tracks_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void rygel_av_transport_notify_track_cb (RygelAVTransport* self, GObject* player, GParamSpec* p);
static void _rygel_av_transport_notify_track_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void rygel_av_transport_notify_uri_cb (RygelAVTransport* self, GObject* player, GParamSpec* p);
static void _rygel_av_transport_notify_uri_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void rygel_av_transport_notify_meta_data_cb (RygelAVTransport* self, GObject* player, GParamSpec* p);
static void _rygel_av_transport_notify_meta_data_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void rygel_av_transport_notify_duration_cb (RygelAVTransport* self, GObject* player, GParamSpec* p);
static void _rygel_av_transport_notify_duration_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void rygel_av_transport_notify_track_uri_cb (RygelAVTransport* self, GObject* player, GParamSpec* p);
static void _rygel_av_transport_notify_track_uri_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void rygel_av_transport_notify_track_meta_data_cb (RygelAVTransport* self, GObject* player, GParamSpec* p);
static void _rygel_av_transport_notify_track_meta_data_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void _vala_SoupURI_free (SoupURI* self);
gchar* rygel_media_renderer_plugin_get_protocol_info (RygelMediaRendererPlugin* self);
RygelMediaPlayer* rygel_media_renderer_plugin_get_player (RygelMediaRendererPlugin* self);
void rygel_change_log_log (RygelChangeLog* self, const gchar* variable, const gchar* value);
gchar* rygel_media_player_get_playback_state (RygelMediaPlayer* self);
gchar* rygel_player_controller_get_current_transport_actions (RygelPlayerController* self);
const gchar* rygel_av_transport_get_status (RygelAVTransport* self);
const gchar* rygel_av_transport_get_mode (RygelAVTransport* self);
gchar* rygel_media_player_get_playback_speed (RygelMediaPlayer* self);
guint rygel_player_controller_get_n_tracks (RygelPlayerController* self);
guint rygel_player_controller_get_track (RygelPlayerController* self);
gchar* rygel_media_player_get_duration_as_str (RygelMediaPlayer* self);
gchar* rygel_av_transport_get_track_metadata (RygelAVTransport* self);
gchar* rygel_player_controller_get_metadata (RygelPlayerController* self);
gchar* rygel_av_transport_get_track_uri (RygelAVTransport* self);
const gchar* rygel_player_controller_get_uri (RygelPlayerController* self);
gchar* rygel_change_log_finish (RygelChangeLog* self);
static gboolean rygel_av_transport_check_instance_id (RygelAVTransport* self, GUPnPServiceAction* action);
static GUPnPServiceAction* _vala_GUPnPServiceAction_copy (GUPnPServiceAction* self);
static void _vala_GUPnPServiceAction_free (GUPnPServiceAction* self);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
void rygel_player_controller_set_playlist (RygelPlayerController* self, GUPnPMediaCollection* collection);
static void ___lambda4_ (Block1Data* _data1_, SoupMessage* msg);
static void ___lambda5_ (RygelAVTransport* self, SoupMessage* msg);
static void ____lambda5__soup_message_got_headers (SoupMessage* _sender, gpointer self);
static gboolean rygel_av_transport_is_valid_mime_type (RygelAVTransport* self, const gchar* mime);
static gboolean rygel_av_transport_is_playlist (RygelAVTransport* self, const gchar* mime, const gchar* features);
void rygel_player_controller_set_metadata (RygelPlayerController* self, const gchar* value);
void rygel_player_controller_set_uri (RygelPlayerController* self, const gchar* value);
static void rygel_av_transport_handle_playlist (RygelAVTransport* self, GUPnPServiceAction* action, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void rygel_av_transport_handle_playlist_finish (RygelAVTransport* self, GAsyncResult* _res_);
void rygel_media_player_set_mime_type (RygelMediaPlayer* self, const gchar* value);
void rygel_media_player_set_content_features (RygelMediaPlayer* self, const gchar* value);
void rygel_av_transport_set_track_metadata (RygelAVTransport* self, const gchar* value);
void rygel_av_transport_set_track_uri (RygelAVTransport* self, const gchar* value);
void rygel_player_controller_set_n_tracks (RygelPlayerController* self, guint value);
void rygel_player_controller_set_track (RygelPlayerController* self, guint value);
static void ____lambda4__soup_message_finished (SoupMessage* _sender, gpointer self);
gchar** rygel_media_player_get_mime_types (RygelMediaPlayer* self, int* result_length1);
static gboolean _vala_string_array_contains (gchar** stack, int stack_length, gchar* needle);
gchar* rygel_media_player_get_position_as_str (RygelMediaPlayer* self);
void rygel_media_player_set_playback_state (RygelMediaPlayer* self, const gchar* value);
gchar** rygel_media_player_get_allowed_playback_speeds (RygelMediaPlayer* self, int* result_length1);
void rygel_media_player_set_playback_speed (RygelMediaPlayer* self, const gchar* value);
gboolean rygel_media_player_seek (RygelMediaPlayer* self, gint64 time);
gint64 rygel_time_utils_time_from_string (const gchar* str);
gboolean rygel_player_controller_next (RygelPlayerController* self);
gboolean rygel_player_controller_previous (RygelPlayerController* self);
static void rygel_av_transport_handle_playlist_data_free (gpointer _data);
static gboolean rygel_av_transport_handle_playlist_co (RygelAvTransportHandlePlaylistData* _data_);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
static void __lambda6_ (Block2Data* _data2_);
static void ___lambda6__soup_session_callback (SoupSession* session, SoupMessage* msg, gpointer self);
static void _g_object_unref0_ (gpointer var);
static void _g_list_free__g_object_unref0_ (GList* self);
static gchar* rygel_av_transport_unescape (RygelAVTransport* self, const gchar* input);
RygelAVTransport* rygel_av_transport_new (void);
RygelAVTransport* rygel_av_transport_construct (GType object_type);
gchar* rygel_media_player_get_metadata (RygelMediaPlayer* self);
void rygel_media_player_set_metadata (RygelMediaPlayer* self, const gchar* value);
gchar* rygel_media_player_get_uri (RygelMediaPlayer* self);
void rygel_media_player_set_uri (RygelMediaPlayer* self, const gchar* value);
void rygel_av_transport_set_status (RygelAVTransport* self, const gchar* value);
gchar* rygel_av_transport_get_speed (RygelAVTransport* self);
void rygel_av_transport_set_speed (RygelAVTransport* self, const gchar* value);
void rygel_av_transport_set_mode (RygelAVTransport* self, const gchar* value);
static void rygel_av_transport_finalize (GObject* obj);
static void _vala_rygel_av_transport_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_rygel_av_transport_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


static gpointer _g_object_ref0 (gpointer self) {
#line 112 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	return self ? g_object_ref (self) : NULL;
#line 353 "rygel-av-transport.c"
}


static void _rygel_av_transport_query_last_change_cb_gupnp_service_query_variable (GUPnPService* _sender, const gchar* variable, GValue* value, gpointer self) {
#line 118 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	rygel_av_transport_query_last_change_cb (self, _sender, variable, value);
#line 360 "rygel-av-transport.c"
}


static void _rygel_av_transport_set_av_transport_uri_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self) {
#line 120 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	rygel_av_transport_set_av_transport_uri_cb (self, _sender, action);
#line 367 "rygel-av-transport.c"
}


static void _rygel_av_transport_get_media_info_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self) {
#line 122 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	rygel_av_transport_get_media_info_cb (self, _sender, action);
#line 374 "rygel-av-transport.c"
}


static void _rygel_av_transport_get_media_info_ex_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self) {
#line 123 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	rygel_av_transport_get_media_info_ex_cb (self, _sender, action);
#line 381 "rygel-av-transport.c"
}


static void _rygel_av_transport_get_transport_info_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self) {
#line 124 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	rygel_av_transport_get_transport_info_cb (self, _sender, action);
#line 388 "rygel-av-transport.c"
}


static void _rygel_av_transport_get_position_info_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self) {
#line 125 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	rygel_av_transport_get_position_info_cb (self, _sender, action);
#line 395 "rygel-av-transport.c"
}


static void _rygel_av_transport_get_device_capabilities_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self) {
#line 126 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	rygel_av_transport_get_device_capabilities_cb (self, _sender, action);
#line 402 "rygel-av-transport.c"
}


static void _rygel_av_transport_get_transport_settings_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self) {
#line 128 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	rygel_av_transport_get_transport_settings_cb (self, _sender, action);
#line 409 "rygel-av-transport.c"
}


static void _rygel_av_transport_get_transport_actions_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self) {
#line 130 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	rygel_av_transport_get_transport_actions_cb (self, _sender, action);
#line 416 "rygel-av-transport.c"
}


static void _rygel_av_transport_stop_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self) {
#line 132 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	rygel_av_transport_stop_cb (self, _sender, action);
#line 423 "rygel-av-transport.c"
}


static void _rygel_av_transport_play_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self) {
#line 133 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	rygel_av_transport_play_cb (self, _sender, action);
#line 430 "rygel-av-transport.c"
}


static void _rygel_av_transport_pause_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self) {
#line 134 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	rygel_av_transport_pause_cb (self, _sender, action);
#line 437 "rygel-av-transport.c"
}


static void _rygel_av_transport_seek_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self) {
#line 135 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	rygel_av_transport_seek_cb (self, _sender, action);
#line 444 "rygel-av-transport.c"
}


static void _rygel_av_transport_next_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self) {
#line 136 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	rygel_av_transport_next_cb (self, _sender, action);
#line 451 "rygel-av-transport.c"
}


static void _rygel_av_transport_previous_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self) {
#line 137 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	rygel_av_transport_previous_cb (self, _sender, action);
#line 458 "rygel-av-transport.c"
}


static void _rygel_av_transport_notify_state_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
#line 139 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	rygel_av_transport_notify_state_cb (self, _sender, pspec);
#line 465 "rygel-av-transport.c"
}


static void _rygel_av_transport_notify_n_tracks_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
#line 140 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	rygel_av_transport_notify_n_tracks_cb (self, _sender, pspec);
#line 472 "rygel-av-transport.c"
}


static void _rygel_av_transport_notify_track_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
#line 141 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	rygel_av_transport_notify_track_cb (self, _sender, pspec);
#line 479 "rygel-av-transport.c"
}


static void _rygel_av_transport_notify_uri_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
#line 142 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	rygel_av_transport_notify_uri_cb (self, _sender, pspec);
#line 486 "rygel-av-transport.c"
}


static void _rygel_av_transport_notify_meta_data_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
#line 143 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	rygel_av_transport_notify_meta_data_cb (self, _sender, pspec);
#line 493 "rygel-av-transport.c"
}


static void _rygel_av_transport_notify_duration_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
#line 145 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	rygel_av_transport_notify_duration_cb (self, _sender, pspec);
#line 500 "rygel-av-transport.c"
}


static void _rygel_av_transport_notify_track_uri_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
#line 146 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	rygel_av_transport_notify_track_uri_cb (self, _sender, pspec);
#line 507 "rygel-av-transport.c"
}


static void _rygel_av_transport_notify_track_meta_data_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
#line 147 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	rygel_av_transport_notify_track_meta_data_cb (self, _sender, pspec);
#line 514 "rygel-av-transport.c"
}


static void _vala_SoupURI_free (SoupURI* self) {
#line 155 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_boxed_free (soup_uri_get_type (), self);
#line 521 "rygel-av-transport.c"
}


static void rygel_av_transport_real_constructed (GObject* base) {
	RygelAVTransport * self;
	GUPnPRootDevice* _tmp0_ = NULL;
	GUPnPRootDevice* _tmp1_;
	GUPnPRootDevice* _tmp2_;
	GUPnPResourceFactory* _tmp3_;
	GUPnPResourceFactory* _tmp4_;
	RygelMediaRendererPlugin* _tmp5_;
	RygelMediaRendererPlugin* _tmp6_;
	RygelMediaRendererPlugin* plugin;
	RygelChangeLog* _tmp7_;
	RygelMediaPlayer* _tmp8_ = NULL;
	RygelMediaRendererPlugin* _tmp9_;
	RygelPlayerController* _tmp10_ = NULL;
	RygelPlayerController* _tmp11_;
	RygelPlayerController* _tmp12_;
	RygelPlayerController* _tmp13_;
	RygelPlayerController* _tmp14_;
	RygelPlayerController* _tmp15_;
	RygelMediaPlayer* _tmp16_;
	RygelMediaPlayer* _tmp17_;
	RygelMediaPlayer* _tmp18_;
	const gchar* _tmp19_ = NULL;
	gchar* _tmp20_;
	gchar* proxy;
	const gchar* _tmp21_;
	SoupSession* _tmp35_;
	RygelMediaRendererPlugin* _tmp36_;
	gchar* _tmp37_ = NULL;
#line 110 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	self = (RygelAVTransport*) base;
#line 111 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	G_OBJECT_CLASS (rygel_av_transport_parent_class)->constructed ((GObject*) G_TYPE_CHECK_INSTANCE_CAST (self, gupnp_service_get_type (), GUPnPService));
#line 112 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_object_get ((GUPnPService*) self, "root-device", &_tmp0_, NULL);
#line 112 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp1_ = _tmp0_;
#line 112 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp2_ = _tmp1_;
#line 112 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp3_ = gupnp_device_info_get_resource_factory ((GUPnPDeviceInfo*) _tmp2_);
#line 112 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp4_ = _tmp3_;
#line 112 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp5_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp4_, RYGEL_TYPE_MEDIA_RENDERER_PLUGIN) ? ((RygelMediaRendererPlugin*) _tmp4_) : NULL);
#line 112 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp6_ = _tmp5_;
#line 112 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_g_object_unref0 (_tmp2_);
#line 112 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	plugin = _tmp6_;
#line 114 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp7_ = rygel_change_log_new ((GUPnPService*) self, RYGEL_AV_TRANSPORT_LAST_CHANGE_NS);
#line 114 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_g_object_unref0 (self->priv->changelog);
#line 114 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	self->priv->changelog = _tmp7_;
#line 115 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp8_ = rygel_av_transport_get_player (self);
#line 115 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_g_object_unref0 (self->priv->player);
#line 115 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	self->priv->player = _tmp8_;
#line 116 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp9_ = plugin;
#line 116 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp10_ = rygel_media_renderer_plugin_get_controller (_tmp9_);
#line 116 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_g_object_unref0 (self->priv->controller);
#line 116 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	self->priv->controller = _tmp10_;
#line 118 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_signal_connect_object ((GUPnPService*) self, "query-variable::LastChange", (GCallback) _rygel_av_transport_query_last_change_cb_gupnp_service_query_variable, self, 0);
#line 120 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::SetAVTransportURI", (GCallback) _rygel_av_transport_set_av_transport_uri_cb_gupnp_service_action_invoked, self, 0);
#line 122 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::GetMediaInfo", (GCallback) _rygel_av_transport_get_media_info_cb_gupnp_service_action_invoked, self, 0);
#line 123 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::GetMediaInfo_Ext", (GCallback) _rygel_av_transport_get_media_info_ex_cb_gupnp_service_action_invoked, self, 0);
#line 124 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::GetTransportInfo", (GCallback) _rygel_av_transport_get_transport_info_cb_gupnp_service_action_invoked, self, 0);
#line 125 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::GetPositionInfo", (GCallback) _rygel_av_transport_get_position_info_cb_gupnp_service_action_invoked, self, 0);
#line 126 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::GetDeviceCapabilities", (GCallback) _rygel_av_transport_get_device_capabilities_cb_gupnp_service_action_invoked, self, 0);
#line 128 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::GetTransportSettings", (GCallback) _rygel_av_transport_get_transport_settings_cb_gupnp_service_action_invoked, self, 0);
#line 130 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::GetCurrentTransportActions", (GCallback) _rygel_av_transport_get_transport_actions_cb_gupnp_service_action_invoked, self, 0);
#line 132 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::Stop", (GCallback) _rygel_av_transport_stop_cb_gupnp_service_action_invoked, self, 0);
#line 133 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::Play", (GCallback) _rygel_av_transport_play_cb_gupnp_service_action_invoked, self, 0);
#line 134 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::Pause", (GCallback) _rygel_av_transport_pause_cb_gupnp_service_action_invoked, self, 0);
#line 135 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::Seek", (GCallback) _rygel_av_transport_seek_cb_gupnp_service_action_invoked, self, 0);
#line 136 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::Next", (GCallback) _rygel_av_transport_next_cb_gupnp_service_action_invoked, self, 0);
#line 137 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::Previous", (GCallback) _rygel_av_transport_previous_cb_gupnp_service_action_invoked, self, 0);
#line 139 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp11_ = self->priv->controller;
#line 139 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_signal_connect_object ((GObject*) _tmp11_, "notify::playback-state", (GCallback) _rygel_av_transport_notify_state_cb_g_object_notify, self, 0);
#line 140 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp12_ = self->priv->controller;
#line 140 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_signal_connect_object ((GObject*) _tmp12_, "notify::n-tracks", (GCallback) _rygel_av_transport_notify_n_tracks_cb_g_object_notify, self, 0);
#line 141 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp13_ = self->priv->controller;
#line 141 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_signal_connect_object ((GObject*) _tmp13_, "notify::track", (GCallback) _rygel_av_transport_notify_track_cb_g_object_notify, self, 0);
#line 142 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp14_ = self->priv->controller;
#line 142 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_signal_connect_object ((GObject*) _tmp14_, "notify::uri", (GCallback) _rygel_av_transport_notify_uri_cb_g_object_notify, self, 0);
#line 143 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp15_ = self->priv->controller;
#line 143 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_signal_connect_object ((GObject*) _tmp15_, "notify::metadata", (GCallback) _rygel_av_transport_notify_meta_data_cb_g_object_notify, self, 0);
#line 145 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp16_ = self->priv->player;
#line 145 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_signal_connect_object ((GObject*) _tmp16_, "notify::duration", (GCallback) _rygel_av_transport_notify_duration_cb_g_object_notify, self, 0);
#line 146 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp17_ = self->priv->player;
#line 146 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_signal_connect_object ((GObject*) _tmp17_, "notify::uri", (GCallback) _rygel_av_transport_notify_track_uri_cb_g_object_notify, self, 0);
#line 147 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp18_ = self->priv->player;
#line 147 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_signal_connect_object ((GObject*) _tmp18_, "notify::metadata", (GCallback) _rygel_av_transport_notify_track_meta_data_cb_g_object_notify, self, 0);
#line 149 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp19_ = g_getenv ("http_proxy");
#line 149 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp20_ = g_strdup (_tmp19_);
#line 149 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	proxy = _tmp20_;
#line 150 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp21_ = proxy;
#line 150 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	if (_tmp21_ != NULL) {
#line 668 "rygel-av-transport.c"
		gboolean _tmp22_ = FALSE;
		const gchar* _tmp23_;
		gboolean _tmp24_ = FALSE;
		gboolean _tmp27_;
		const gchar* _tmp30_;
		SoupURI* _tmp31_;
		SoupURI* _tmp32_;
		SoupSessionAsync* _tmp33_;
#line 151 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_tmp23_ = proxy;
#line 151 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_tmp24_ = g_str_has_prefix (_tmp23_, "http://");
#line 151 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		if (!_tmp24_) {
#line 683 "rygel-av-transport.c"
			const gchar* _tmp25_;
			gboolean _tmp26_ = FALSE;
#line 152 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
			_tmp25_ = proxy;
#line 152 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
			_tmp26_ = g_str_has_prefix (_tmp25_, "https://");
#line 152 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
			_tmp22_ = !_tmp26_;
#line 692 "rygel-av-transport.c"
		} else {
#line 151 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
			_tmp22_ = FALSE;
#line 696 "rygel-av-transport.c"
		}
#line 151 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_tmp27_ = _tmp22_;
#line 151 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		if (_tmp27_) {
#line 702 "rygel-av-transport.c"
			const gchar* _tmp28_;
			gchar* _tmp29_;
#line 153 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
			_tmp28_ = proxy;
#line 153 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
			_tmp29_ = g_strconcat ("http://", _tmp28_, NULL);
#line 153 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
			_g_free0 (proxy);
#line 153 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
			proxy = _tmp29_;
#line 713 "rygel-av-transport.c"
		}
#line 155 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_tmp30_ = proxy;
#line 155 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_tmp31_ = soup_uri_new (_tmp30_);
#line 155 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_tmp32_ = _tmp31_;
#line 155 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_tmp33_ = (SoupSessionAsync*) soup_session_async_new_with_options (SOUP_SESSION_PROXY_URI, _tmp32_, NULL);
#line 155 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_g_object_unref0 (self->priv->session);
#line 155 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		self->priv->session = (SoupSession*) _tmp33_;
#line 155 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		__vala_SoupURI_free0 (_tmp32_);
#line 729 "rygel-av-transport.c"
	} else {
		SoupSessionAsync* _tmp34_;
#line 158 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_tmp34_ = (SoupSessionAsync*) soup_session_async_new ();
#line 158 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_g_object_unref0 (self->priv->session);
#line 158 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		self->priv->session = (SoupSession*) _tmp34_;
#line 738 "rygel-av-transport.c"
	}
#line 160 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp35_ = self->priv->session;
#line 160 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	soup_session_add_feature_by_type (_tmp35_, soup_proxy_resolver_default_get_type ());
#line 161 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp36_ = plugin;
#line 161 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp37_ = rygel_media_renderer_plugin_get_protocol_info (_tmp36_);
#line 161 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_g_free0 (self->priv->protocol_info);
#line 161 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	self->priv->protocol_info = _tmp37_;
#line 110 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_g_free0 (proxy);
#line 110 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_g_object_unref0 (plugin);
#line 756 "rygel-av-transport.c"
}


static RygelMediaPlayer* rygel_av_transport_get_player (RygelAVTransport* self) {
	RygelMediaPlayer* result = NULL;
	GUPnPRootDevice* _tmp0_ = NULL;
	GUPnPRootDevice* _tmp1_;
	GUPnPRootDevice* _tmp2_;
	GUPnPResourceFactory* _tmp3_;
	GUPnPResourceFactory* _tmp4_;
	RygelMediaRendererPlugin* _tmp5_;
	RygelMediaRendererPlugin* _tmp6_;
	RygelMediaRendererPlugin* plugin;
	RygelMediaPlayer* _tmp7_ = NULL;
#line 164 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 165 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_object_get ((GUPnPService*) self, "root-device", &_tmp0_, NULL);
#line 165 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp1_ = _tmp0_;
#line 165 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp2_ = _tmp1_;
#line 165 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp3_ = gupnp_device_info_get_resource_factory ((GUPnPDeviceInfo*) _tmp2_);
#line 165 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp4_ = _tmp3_;
#line 165 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp5_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp4_, RYGEL_TYPE_MEDIA_RENDERER_PLUGIN) ? ((RygelMediaRendererPlugin*) _tmp4_) : NULL);
#line 165 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp6_ = _tmp5_;
#line 165 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_g_object_unref0 (_tmp2_);
#line 165 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	plugin = _tmp6_;
#line 167 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp7_ = rygel_media_renderer_plugin_get_player (plugin);
#line 167 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	result = _tmp7_;
#line 167 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_g_object_unref0 (plugin);
#line 167 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	return result;
#line 799 "rygel-av-transport.c"
}


static void rygel_av_transport_query_last_change_cb (RygelAVTransport* self, GUPnPService* service, const gchar* variable, GValue* value) {
	RygelChangeLog* _tmp0_;
	RygelChangeLog* log;
	RygelMediaPlayer* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	RygelPlayerController* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	const gchar* _tmp9_;
	const gchar* _tmp10_;
	const gchar* _tmp11_;
	const gchar* _tmp12_;
	RygelMediaPlayer* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	RygelPlayerController* _tmp17_;
	guint _tmp18_;
	guint _tmp19_;
	gchar* _tmp20_ = NULL;
	gchar* _tmp21_;
	RygelPlayerController* _tmp22_;
	guint _tmp23_;
	guint _tmp24_;
	gchar* _tmp25_ = NULL;
	gchar* _tmp26_;
	RygelMediaPlayer* _tmp27_;
	gchar* _tmp28_;
	gchar* _tmp29_;
	gchar* _tmp30_;
	RygelMediaPlayer* _tmp31_;
	gchar* _tmp32_;
	gchar* _tmp33_;
	gchar* _tmp34_;
	gchar* _tmp35_;
	gchar* _tmp36_;
	gchar* _tmp37_;
	gchar* _tmp38_ = NULL;
	gchar* _tmp39_;
	RygelPlayerController* _tmp40_;
	gchar* _tmp41_;
	gchar* _tmp42_;
	gchar* _tmp43_;
	gchar* _tmp44_ = NULL;
	gchar* _tmp45_;
	gchar* _tmp46_;
	gchar* _tmp47_;
	gchar* _tmp48_;
	RygelPlayerController* _tmp49_;
	const gchar* _tmp50_;
	const gchar* _tmp51_;
	gchar* _tmp52_ = NULL;
	gchar* _tmp53_;
#line 170 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_return_if_fail (self != NULL);
#line 170 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_return_if_fail (service != NULL);
#line 170 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_return_if_fail (variable != NULL);
#line 170 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_return_if_fail (value != NULL);
#line 174 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp0_ = rygel_change_log_new (NULL, RYGEL_AV_TRANSPORT_LAST_CHANGE_NS);
#line 174 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	log = _tmp0_;
#line 176 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp1_ = self->priv->player;
#line 176 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp2_ = rygel_media_player_get_playback_state (_tmp1_);
#line 176 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp3_ = _tmp2_;
#line 176 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp4_ = _tmp3_;
#line 176 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	rygel_change_log_log (log, "TransportState", _tmp4_);
#line 176 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_g_free0 (_tmp4_);
#line 177 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp5_ = self->priv->controller;
#line 177 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp6_ = rygel_player_controller_get_current_transport_actions (_tmp5_);
#line 177 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp7_ = _tmp6_;
#line 177 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp8_ = _tmp7_;
#line 177 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	rygel_change_log_log (log, "CurrentTransportActions", _tmp8_);
#line 177 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_g_free0 (_tmp8_);
#line 179 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp9_ = rygel_av_transport_get_status (self);
#line 179 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp10_ = _tmp9_;
#line 179 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	rygel_change_log_log (log, "TransportStatus", _tmp10_);
#line 180 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	rygel_change_log_log (log, "PlaybackStorageMedium", "NOT_IMPLEMENTED");
#line 181 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	rygel_change_log_log (log, "RecordStorageMedium", "NOT_IMPLEMENTED");
#line 182 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	rygel_change_log_log (log, "PossiblePlaybackStorageMedia", "NOT_IMPLEMENTED");
#line 183 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	rygel_change_log_log (log, "PossibleRecordStorageMedia", "NOT_IMPLEMENTED");
#line 184 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp11_ = rygel_av_transport_get_mode (self);
#line 184 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp12_ = _tmp11_;
#line 184 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	rygel_change_log_log (log, "CurrentPlayMode", _tmp12_);
#line 185 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp13_ = self->priv->player;
#line 185 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp14_ = rygel_media_player_get_playback_speed (_tmp13_);
#line 185 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp15_ = _tmp14_;
#line 185 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp16_ = _tmp15_;
#line 185 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	rygel_change_log_log (log, "TransportPlaySpeed", _tmp16_);
#line 185 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_g_free0 (_tmp16_);
#line 186 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	rygel_change_log_log (log, "RecordMediumWriteStatus", "NOT_IMPLEMENTED");
#line 187 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	rygel_change_log_log (log, "CurrentRecordQualityMode", "NOT_IMPLEMENTED");
#line 188 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	rygel_change_log_log (log, "PossibleRecordQualityModes", "NOT_IMPLEMENTED");
#line 189 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp17_ = self->priv->controller;
#line 189 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp18_ = rygel_player_controller_get_n_tracks (_tmp17_);
#line 189 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp19_ = _tmp18_;
#line 189 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp20_ = g_strdup_printf ("%u", _tmp19_);
#line 189 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp21_ = _tmp20_;
#line 189 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	rygel_change_log_log (log, "NumberOfTracks", _tmp21_);
#line 189 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_g_free0 (_tmp21_);
#line 190 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp22_ = self->priv->controller;
#line 190 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp23_ = rygel_player_controller_get_track (_tmp22_);
#line 190 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp24_ = _tmp23_;
#line 190 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp25_ = g_strdup_printf ("%u", _tmp24_);
#line 190 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp26_ = _tmp25_;
#line 190 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	rygel_change_log_log (log, "CurrentTrack", _tmp26_);
#line 190 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_g_free0 (_tmp26_);
#line 191 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp27_ = self->priv->player;
#line 191 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp28_ = rygel_media_player_get_duration_as_str (_tmp27_);
#line 191 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp29_ = _tmp28_;
#line 191 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp30_ = _tmp29_;
#line 191 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	rygel_change_log_log (log, "CurrentTrackDuration", _tmp30_);
#line 191 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_g_free0 (_tmp30_);
#line 192 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp31_ = self->priv->player;
#line 192 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp32_ = rygel_media_player_get_duration_as_str (_tmp31_);
#line 192 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp33_ = _tmp32_;
#line 192 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp34_ = _tmp33_;
#line 192 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	rygel_change_log_log (log, "CurrentMediaDuration", _tmp34_);
#line 192 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_g_free0 (_tmp34_);
#line 193 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp35_ = rygel_av_transport_get_track_metadata (self);
#line 193 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp36_ = _tmp35_;
#line 193 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp37_ = _tmp36_;
#line 193 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp38_ = g_markup_escape_text (_tmp37_, (gssize) (-1));
#line 193 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp39_ = _tmp38_;
#line 193 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	rygel_change_log_log (log, "CurrentTrackMetaData", _tmp39_);
#line 193 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_g_free0 (_tmp39_);
#line 193 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_g_free0 (_tmp37_);
#line 195 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp40_ = self->priv->controller;
#line 195 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp41_ = rygel_player_controller_get_metadata (_tmp40_);
#line 195 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp42_ = _tmp41_;
#line 195 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp43_ = _tmp42_;
#line 195 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp44_ = g_markup_escape_text (_tmp43_, (gssize) (-1));
#line 195 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp45_ = _tmp44_;
#line 195 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	rygel_change_log_log (log, "AVTransportURIMetaData", _tmp45_);
#line 195 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_g_free0 (_tmp45_);
#line 195 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_g_free0 (_tmp43_);
#line 197 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp46_ = rygel_av_transport_get_track_uri (self);
#line 197 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp47_ = _tmp46_;
#line 197 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp48_ = _tmp47_;
#line 197 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	rygel_change_log_log (log, "CurrentTrackURI", _tmp48_);
#line 197 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_g_free0 (_tmp48_);
#line 198 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp49_ = self->priv->controller;
#line 198 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp50_ = rygel_player_controller_get_uri (_tmp49_);
#line 198 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp51_ = _tmp50_;
#line 198 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	rygel_change_log_log (log, "AVTransportURI", _tmp51_);
#line 199 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	rygel_change_log_log (log, "NextAVTransportURI", "NOT_IMPLEMENTED");
#line 200 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	rygel_change_log_log (log, "NextAVTransportURIMetaData", "NOT_IMPLEMENTED");
#line 202 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_value_init (value, G_TYPE_STRING);
#line 203 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp52_ = rygel_change_log_finish (log);
#line 203 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp53_ = _tmp52_;
#line 203 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_value_set_string (value, _tmp53_);
#line 203 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_g_free0 (_tmp53_);
#line 170 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_g_object_unref0 (log);
#line 1053 "rygel-av-transport.c"
}


static gboolean int64_try_parse (const gchar* str, gint64* _result_) {
	gint64 _vala_result = 0LL;
	gboolean result = FALSE;
	gchar* endptr = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_ = NULL;
	gint64 _tmp2_ = 0LL;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	gint _tmp6_;
	gint _tmp7_;
#line 606 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	g_return_val_if_fail (str != NULL, FALSE);
#line 608 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp0_ = str;
#line 608 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp2_ = g_ascii_strtoll (_tmp0_, &_tmp1_, (guint) 0);
#line 608 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	endptr = _tmp1_;
#line 608 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	_vala_result = _tmp2_;
#line 609 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp3_ = endptr;
#line 609 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp4_ = str;
#line 609 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp5_ = str;
#line 609 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp6_ = strlen (_tmp5_);
#line 609 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp7_ = _tmp6_;
#line 609 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	if (_tmp3_ == (((gchar*) _tmp4_) + _tmp7_)) {
#line 610 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		result = TRUE;
#line 610 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		if (_result_) {
#line 610 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
			*_result_ = _vala_result;
#line 1097 "rygel-av-transport.c"
		}
#line 610 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		return result;
#line 1101 "rygel-av-transport.c"
	} else {
#line 612 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		result = FALSE;
#line 612 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		if (_result_) {
#line 612 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
			*_result_ = _vala_result;
#line 1109 "rygel-av-transport.c"
		}
#line 612 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		return result;
#line 1113 "rygel-av-transport.c"
	}
#line 606 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	if (_result_) {
#line 606 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		*_result_ = _vala_result;
#line 1119 "rygel-av-transport.c"
	}
}


static gboolean rygel_av_transport_check_instance_id (RygelAVTransport* self, GUPnPServiceAction* action) {
	gboolean result = FALSE;
	gchar* instance_id_string = NULL;
	gint64 instance_id;
	GUPnPServiceAction* _tmp0_;
	gboolean _tmp1_ = FALSE;
	const gchar* _tmp2_;
	gboolean _tmp6_;
	gint64 _tmp9_;
#line 207 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 207 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_return_val_if_fail (action != NULL, FALSE);
#line 209 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	instance_id = (gint64) (-1);
#line 211 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp0_ = action;
#line 211 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	gupnp_service_action_get (_tmp0_, "InstanceID", G_TYPE_STRING, &instance_id_string, NULL);
#line 212 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp2_ = instance_id_string;
#line 212 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	if (_tmp2_ == NULL) {
#line 212 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_tmp1_ = TRUE;
#line 1149 "rygel-av-transport.c"
	} else {
		const gchar* _tmp3_;
		gint64 _tmp4_ = 0LL;
		gboolean _tmp5_ = FALSE;
#line 213 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_tmp3_ = instance_id_string;
#line 213 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_tmp5_ = int64_try_parse (_tmp3_, &_tmp4_);
#line 213 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		instance_id = _tmp4_;
#line 213 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_tmp1_ = !_tmp5_;
#line 1162 "rygel-av-transport.c"
	}
#line 212 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp6_ = _tmp1_;
#line 212 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	if (_tmp6_) {
#line 1168 "rygel-av-transport.c"
		GUPnPServiceAction* _tmp7_;
		const gchar* _tmp8_ = NULL;
#line 214 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_tmp7_ = action;
#line 214 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_tmp8_ = _ ("Invalid argument");
#line 214 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		gupnp_service_action_return_error (_tmp7_, (guint) 402, _tmp8_);
#line 216 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		result = FALSE;
#line 216 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_g_free0 (instance_id_string);
#line 216 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		return result;
#line 1183 "rygel-av-transport.c"
	}
#line 219 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp9_ = instance_id;
#line 219 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	if (_tmp9_ != ((gint64) 0)) {
#line 1189 "rygel-av-transport.c"
		GUPnPServiceAction* _tmp10_;
		const gchar* _tmp11_ = NULL;
#line 220 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_tmp10_ = action;
#line 220 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_tmp11_ = _ ("Invalid InstanceID");
#line 220 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		gupnp_service_action_return_error (_tmp10_, (guint) 718, _tmp11_);
#line 222 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		result = FALSE;
#line 222 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_g_free0 (instance_id_string);
#line 222 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		return result;
#line 1204 "rygel-av-transport.c"
	}
#line 225 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	result = TRUE;
#line 225 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_g_free0 (instance_id_string);
#line 225 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	return result;
#line 1212 "rygel-av-transport.c"
}


static GUPnPServiceAction* _vala_GUPnPServiceAction_copy (GUPnPServiceAction* self) {
#line 228 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	return g_boxed_copy (gupnp_service_action_get_type (), self);
#line 1219 "rygel-av-transport.c"
}


static gpointer __vala_GUPnPServiceAction_copy0 (gpointer self) {
#line 228 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	return self ? _vala_GUPnPServiceAction_copy (self) : NULL;
#line 1226 "rygel-av-transport.c"
}


static void _vala_GUPnPServiceAction_free (GUPnPServiceAction* self) {
#line 228 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_boxed_free (gupnp_service_action_get_type (), self);
#line 1233 "rygel-av-transport.c"
}


static Block1Data* block1_data_ref (Block1Data* _data1_) {
#line 228 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_atomic_int_inc (&_data1_->_ref_count_);
#line 228 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	return _data1_;
#line 1242 "rygel-av-transport.c"
}


static void block1_data_unref (void * _userdata_) {
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
#line 228 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
#line 1251 "rygel-av-transport.c"
		RygelAVTransport * self;
#line 228 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		self = _data1_->self;
#line 228 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_g_free0 (_data1_->_metadata);
#line 228 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_g_free0 (_data1_->_uri);
#line 228 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		__vala_GUPnPServiceAction_free0 (_data1_->action);
#line 228 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_g_object_unref0 (self);
#line 228 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		g_slice_free (Block1Data, _data1_);
#line 1265 "rygel-av-transport.c"
	}
}


static void ___lambda5_ (RygelAVTransport* self, SoupMessage* msg) {
	SoupSession* _tmp0_;
	SoupMessage* _tmp1_;
	SoupMessage* _tmp2_;
	guint _tmp3_ = 0U;
	guint _tmp4_;
#line 257 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_return_if_fail (msg != NULL);
#line 258 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp0_ = self->priv->session;
#line 258 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp1_ = msg;
#line 258 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp2_ = msg;
#line 258 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_object_get (_tmp2_, "status-code", &_tmp3_, NULL);
#line 258 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp4_ = _tmp3_;
#line 258 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	soup_session_cancel_message (_tmp0_, _tmp1_, _tmp4_);
#line 1290 "rygel-av-transport.c"
}


static void ____lambda5__soup_message_got_headers (SoupMessage* _sender, gpointer self) {
#line 257 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	___lambda5_ (self, _sender);
#line 1297 "rygel-av-transport.c"
}


static void ___lambda4_ (Block1Data* _data1_, SoupMessage* msg) {
	RygelAVTransport * self;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	SoupMessage* _tmp4_;
	guint _tmp5_ = 0U;
	guint _tmp6_;
	gboolean _tmp10_;
	gboolean _tmp14_;
	gboolean _tmp18_;
	gboolean _tmp23_;
	SoupMessage* _tmp29_;
	guint _tmp30_ = 0U;
	guint _tmp31_;
#line 249 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	self = _data1_->self;
#line 249 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_return_if_fail (msg != NULL);
#line 250 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp4_ = msg;
#line 250 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_object_get (_tmp4_, "status-code", &_tmp5_, NULL);
#line 250 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp6_ = _tmp5_;
#line 250 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	if (_tmp6_ == ((guint) SOUP_STATUS_MALFORMED)) {
#line 250 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_tmp3_ = TRUE;
#line 1331 "rygel-av-transport.c"
	} else {
		SoupMessage* _tmp7_;
		guint _tmp8_ = 0U;
		guint _tmp9_;
#line 251 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_tmp7_ = msg;
#line 251 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		g_object_get (_tmp7_, "status-code", &_tmp8_, NULL);
#line 251 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_tmp9_ = _tmp8_;
#line 251 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_tmp3_ = _tmp9_ == ((guint) SOUP_STATUS_BAD_REQUEST);
#line 1344 "rygel-av-transport.c"
	}
#line 250 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp10_ = _tmp3_;
#line 250 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	if (_tmp10_) {
#line 250 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_tmp2_ = TRUE;
#line 1352 "rygel-av-transport.c"
	} else {
		SoupMessage* _tmp11_;
		guint _tmp12_ = 0U;
		guint _tmp13_;
#line 252 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_tmp11_ = msg;
#line 252 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		g_object_get (_tmp11_, "status-code", &_tmp12_, NULL);
#line 252 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_tmp13_ = _tmp12_;
#line 252 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_tmp2_ = _tmp13_ == ((guint) SOUP_STATUS_METHOD_NOT_ALLOWED);
#line 1365 "rygel-av-transport.c"
	}
#line 250 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp14_ = _tmp2_;
#line 250 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	if (_tmp14_) {
#line 250 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_tmp1_ = TRUE;
#line 1373 "rygel-av-transport.c"
	} else {
		SoupMessage* _tmp15_;
		guint _tmp16_ = 0U;
		guint _tmp17_;
#line 253 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_tmp15_ = msg;
#line 253 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		g_object_get (_tmp15_, "status-code", &_tmp16_, NULL);
#line 253 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_tmp17_ = _tmp16_;
#line 253 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_tmp1_ = _tmp17_ == ((guint) SOUP_STATUS_NOT_IMPLEMENTED);
#line 1386 "rygel-av-transport.c"
	}
#line 250 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp18_ = _tmp1_;
#line 250 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	if (_tmp18_) {
#line 1392 "rygel-av-transport.c"
		SoupMessage* _tmp19_;
		gchar* _tmp20_ = NULL;
		gchar* _tmp21_;
		gchar* _tmp22_;
#line 254 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_tmp19_ = msg;
#line 254 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		g_object_get (_tmp19_, "method", &_tmp20_, NULL);
#line 254 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_tmp21_ = _tmp20_;
#line 254 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_tmp22_ = _tmp21_;
#line 254 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_tmp0_ = g_strcmp0 (_tmp22_, "HEAD") == 0;
#line 254 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_g_free0 (_tmp22_);
#line 1409 "rygel-av-transport.c"
	} else {
#line 250 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_tmp0_ = FALSE;
#line 1413 "rygel-av-transport.c"
	}
#line 250 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp23_ = _tmp0_;
#line 250 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	if (_tmp23_) {
#line 1419 "rygel-av-transport.c"
		SoupMessage* _tmp24_;
		SoupMessage* _tmp25_;
		SoupSession* _tmp26_;
		SoupMessage* _tmp27_;
		SoupMessage* _tmp28_;
#line 255 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		g_debug ("rygel-av-transport.vala:255: Peer does not support HEAD, trying GET");
#line 256 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_tmp24_ = msg;
#line 256 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		g_object_set (_tmp24_, "method", "GET", NULL);
#line 257 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_tmp25_ = msg;
#line 257 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		g_signal_connect_object (_tmp25_, "got-headers", (GCallback) ____lambda5__soup_message_got_headers, self, 0);
#line 261 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_tmp26_ = self->priv->session;
#line 261 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_tmp27_ = msg;
#line 261 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_tmp28_ = _g_object_ref0 (_tmp27_);
#line 261 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		soup_session_queue_message (_tmp26_, _tmp28_, NULL, NULL);
#line 263 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		return;
#line 1445 "rygel-av-transport.c"
	}
#line 266 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp29_ = msg;
#line 266 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_object_get (_tmp29_, "status-code", &_tmp30_, NULL);
#line 266 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp31_ = _tmp30_;
#line 266 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	if (_tmp31_ != ((guint) SOUP_STATUS_OK)) {
#line 1455 "rygel-av-transport.c"
		const gchar* _tmp32_;
		SoupMessage* _tmp33_;
		gchar* _tmp34_ = NULL;
		gchar* _tmp35_;
		gchar* _tmp36_;
		GUPnPServiceAction* _tmp37_;
		const gchar* _tmp38_ = NULL;
#line 267 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_tmp32_ = _data1_->_uri;
#line 267 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_tmp33_ = msg;
#line 267 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		g_object_get (_tmp33_, "reason-phrase", &_tmp34_, NULL);
#line 267 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_tmp35_ = _tmp34_;
#line 267 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_tmp36_ = _tmp35_;
#line 267 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		g_warning ("rygel-av-transport.vala:267: Failed to access %s: %s", _tmp32_, _tmp36_);
#line 267 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_g_free0 (_tmp36_);
#line 271 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_tmp37_ = _data1_->action;
#line 271 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_tmp38_ = _ ("Resource not found");
#line 271 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		gupnp_service_action_return_error (_tmp37_, (guint) 716, _tmp38_);
#line 273 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		return;
#line 1485 "rygel-av-transport.c"
	} else {
		SoupMessage* _tmp39_;
		SoupMessageHeaders* _tmp40_;
		const gchar* _tmp41_ = NULL;
		gchar* _tmp42_;
		gchar* mime;
		SoupMessage* _tmp43_;
		SoupMessageHeaders* _tmp44_;
		const gchar* _tmp45_ = NULL;
		gchar* _tmp46_;
		gchar* features;
		gboolean _tmp47_ = FALSE;
		const gchar* _tmp48_;
		gboolean _tmp49_ = FALSE;
		gboolean _tmp53_;
		RygelPlayerController* _tmp56_;
		const gchar* _tmp57_;
		RygelPlayerController* _tmp58_;
		const gchar* _tmp59_;
		const gchar* _tmp60_;
		const gchar* _tmp61_;
		gboolean _tmp62_ = FALSE;
#line 275 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_tmp39_ = msg;
#line 275 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_tmp40_ = _tmp39_->response_headers;
#line 275 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_tmp41_ = soup_message_headers_get_one (_tmp40_, "Content-Type");
#line 275 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_tmp42_ = g_strdup (_tmp41_);
#line 275 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		mime = _tmp42_;
#line 276 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_tmp43_ = msg;
#line 276 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_tmp44_ = _tmp43_->response_headers;
#line 276 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_tmp45_ = soup_message_headers_get_one (_tmp44_, "contentFeatures.dlna.org");
#line 276 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_tmp46_ = g_strdup (_tmp45_);
#line 276 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		features = _tmp46_;
#line 279 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_tmp48_ = mime;
#line 279 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_tmp49_ = rygel_av_transport_is_valid_mime_type (self, _tmp48_);
#line 279 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		if (!_tmp49_) {
#line 1534 "rygel-av-transport.c"
			const gchar* _tmp50_;
			const gchar* _tmp51_;
			gboolean _tmp52_ = FALSE;
#line 280 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
			_tmp50_ = mime;
#line 280 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
			_tmp51_ = features;
#line 280 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
			_tmp52_ = rygel_av_transport_is_playlist (self, _tmp50_, _tmp51_);
#line 280 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
			_tmp47_ = !_tmp52_;
#line 1546 "rygel-av-transport.c"
		} else {
#line 279 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
			_tmp47_ = FALSE;
#line 1550 "rygel-av-transport.c"
		}
#line 279 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_tmp53_ = _tmp47_;
#line 279 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		if (_tmp53_) {
#line 1556 "rygel-av-transport.c"
			GUPnPServiceAction* _tmp54_;
			const gchar* _tmp55_ = NULL;
#line 281 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
			_tmp54_ = _data1_->action;
#line 281 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
			_tmp55_ = _ ("Illegal MIME-type");
#line 281 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
			gupnp_service_action_return_error (_tmp54_, (guint) 714, _tmp55_);
#line 283 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
			_g_free0 (features);
#line 283 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
			_g_free0 (mime);
#line 283 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
			return;
#line 1571 "rygel-av-transport.c"
		}
#line 286 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_tmp56_ = self->priv->controller;
#line 286 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_tmp57_ = _data1_->_metadata;
#line 286 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		rygel_player_controller_set_metadata (_tmp56_, _tmp57_);
#line 287 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_tmp58_ = self->priv->controller;
#line 287 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_tmp59_ = _data1_->_uri;
#line 287 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		rygel_player_controller_set_uri (_tmp58_, _tmp59_);
#line 289 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_tmp60_ = mime;
#line 289 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_tmp61_ = features;
#line 289 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_tmp62_ = rygel_av_transport_is_playlist (self, _tmp60_, _tmp61_);
#line 289 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		if (_tmp62_) {
#line 1593 "rygel-av-transport.c"
			GUPnPServiceAction* _tmp63_;
#line 291 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
			_tmp63_ = _data1_->action;
#line 291 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
			rygel_av_transport_handle_playlist (self, _tmp63_, NULL, NULL);
#line 1599 "rygel-av-transport.c"
		} else {
			RygelMediaPlayer* _tmp64_;
			const gchar* _tmp65_;
			const gchar* _tmp66_;
			const gchar* _tmp70_;
			const gchar* _tmp71_;
			RygelPlayerController* _tmp72_;
			RygelPlayerController* _tmp73_;
			GUPnPServiceAction* _tmp74_;
#line 294 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
			_tmp64_ = self->priv->player;
#line 294 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
			_tmp65_ = mime;
#line 294 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
			rygel_media_player_set_mime_type (_tmp64_, _tmp65_);
#line 295 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
			_tmp66_ = features;
#line 295 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
			if (_tmp66_ != NULL) {
#line 1619 "rygel-av-transport.c"
				RygelMediaPlayer* _tmp67_;
				const gchar* _tmp68_;
#line 296 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
				_tmp67_ = self->priv->player;
#line 296 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
				_tmp68_ = features;
#line 296 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
				rygel_media_player_set_content_features (_tmp67_, _tmp68_);
#line 1628 "rygel-av-transport.c"
			} else {
				RygelMediaPlayer* _tmp69_;
#line 298 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
				_tmp69_ = self->priv->player;
#line 298 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
				rygel_media_player_set_content_features (_tmp69_, "*");
#line 1635 "rygel-av-transport.c"
			}
#line 302 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
			_tmp70_ = _data1_->_metadata;
#line 302 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
			rygel_av_transport_set_track_metadata (self, _tmp70_);
#line 303 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
			_tmp71_ = _data1_->_uri;
#line 303 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
			rygel_av_transport_set_track_uri (self, _tmp71_);
#line 304 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
			_tmp72_ = self->priv->controller;
#line 304 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
			rygel_player_controller_set_n_tracks (_tmp72_, (guint) 1);
#line 305 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
			_tmp73_ = self->priv->controller;
#line 305 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
			rygel_player_controller_set_track (_tmp73_, (guint) 1);
#line 307 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
			_tmp74_ = _data1_->action;
#line 307 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
			gupnp_service_action_return (_tmp74_);
#line 1657 "rygel-av-transport.c"
		}
#line 266 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_g_free0 (features);
#line 266 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_g_free0 (mime);
#line 1663 "rygel-av-transport.c"
	}
}


static void ____lambda4__soup_message_finished (SoupMessage* _sender, gpointer self) {
#line 249 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	___lambda4_ (self, _sender);
#line 1671 "rygel-av-transport.c"
}


static void rygel_av_transport_set_av_transport_uri_cb (RygelAVTransport* self, GUPnPService* service, GUPnPServiceAction* action) {
	Block1Data* _data1_;
	GUPnPServiceAction* _tmp0_;
	GUPnPServiceAction* _tmp1_;
	GUPnPServiceAction* _tmp2_;
	gboolean _tmp3_ = FALSE;
	GUPnPServiceAction* _tmp4_;
	RygelPlayerController* _tmp5_;
	gboolean _tmp6_ = FALSE;
	const gchar* _tmp7_;
	gboolean _tmp8_ = FALSE;
	gboolean _tmp11_;
#line 228 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_return_if_fail (self != NULL);
#line 228 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_return_if_fail (service != NULL);
#line 228 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_return_if_fail (action != NULL);
#line 228 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_data1_ = g_slice_new0 (Block1Data);
#line 228 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_data1_->_ref_count_ = 1;
#line 228 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_data1_->self = g_object_ref (self);
#line 228 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp0_ = action;
#line 228 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp1_ = __vala_GUPnPServiceAction_copy0 (_tmp0_);
#line 228 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	__vala_GUPnPServiceAction_free0 (_data1_->action);
#line 228 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_data1_->action = _tmp1_;
#line 230 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp2_ = _data1_->action;
#line 230 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp3_ = rygel_av_transport_check_instance_id (self, _tmp2_);
#line 230 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	if (!_tmp3_) {
#line 231 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		block1_data_unref (_data1_);
#line 231 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_data1_ = NULL;
#line 231 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		return;
#line 1719 "rygel-av-transport.c"
	}
#line 236 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp4_ = _data1_->action;
#line 236 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	gupnp_service_action_get (_tmp4_, "CurrentURI", G_TYPE_STRING, &_data1_->_uri, "CurrentURIMetaData", G_TYPE_STRING, &_data1_->_metadata, NULL);
#line 244 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp5_ = self->priv->controller;
#line 244 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	rygel_player_controller_set_playlist (_tmp5_, NULL);
#line 245 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp7_ = _data1_->_uri;
#line 245 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp8_ = g_str_has_prefix (_tmp7_, "http://");
#line 245 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	if (_tmp8_) {
#line 245 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_tmp6_ = TRUE;
#line 1737 "rygel-av-transport.c"
	} else {
		const gchar* _tmp9_;
		gboolean _tmp10_ = FALSE;
#line 245 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_tmp9_ = _data1_->_uri;
#line 245 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_tmp10_ = g_str_has_prefix (_tmp9_, "https://");
#line 245 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_tmp6_ = _tmp10_;
#line 1747 "rygel-av-transport.c"
	}
#line 245 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp11_ = _tmp6_;
#line 245 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	if (_tmp11_) {
#line 1753 "rygel-av-transport.c"
		const gchar* _tmp12_;
		SoupMessage* _tmp13_;
		SoupMessage* message;
		SoupMessage* _tmp14_;
		SoupMessageHeaders* _tmp15_;
		SoupMessage* _tmp16_;
		SoupSession* _tmp17_;
		SoupMessage* _tmp18_;
		SoupMessage* _tmp19_;
#line 246 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_tmp12_ = _data1_->_uri;
#line 246 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_tmp13_ = soup_message_new ("HEAD", _tmp12_);
#line 246 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		message = _tmp13_;
#line 247 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_tmp14_ = message;
#line 247 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_tmp15_ = _tmp14_->request_headers;
#line 247 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		soup_message_headers_append (_tmp15_, "getContentFeatures.dlna.org", "1");
#line 249 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_tmp16_ = message;
#line 249 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		g_signal_connect_data (_tmp16_, "finished", (GCallback) ____lambda4__soup_message_finished, block1_data_ref (_data1_), (GClosureNotify) block1_data_unref, 0);
#line 311 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_tmp17_ = self->priv->session;
#line 311 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_tmp18_ = message;
#line 311 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_tmp19_ = _g_object_ref0 (_tmp18_);
#line 311 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		soup_session_queue_message (_tmp17_, _tmp19_, NULL, NULL);
#line 245 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_g_object_unref0 (message);
#line 1789 "rygel-av-transport.c"
	} else {
		RygelPlayerController* _tmp20_;
		const gchar* _tmp21_;
		RygelPlayerController* _tmp22_;
		const gchar* _tmp23_;
		const gchar* _tmp24_;
		GUPnPServiceAction* _tmp29_;
#line 313 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_tmp20_ = self->priv->controller;
#line 313 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_tmp21_ = _data1_->_metadata;
#line 313 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		rygel_player_controller_set_metadata (_tmp20_, _tmp21_);
#line 314 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_tmp22_ = self->priv->controller;
#line 314 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_tmp23_ = _data1_->_uri;
#line 314 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		rygel_player_controller_set_uri (_tmp22_, _tmp23_);
#line 315 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_tmp24_ = _data1_->_uri;
#line 315 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		if (g_strcmp0 (_tmp24_, "") == 0) {
#line 1813 "rygel-av-transport.c"
			RygelPlayerController* _tmp25_;
			RygelPlayerController* _tmp26_;
#line 316 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
			_tmp25_ = self->priv->controller;
#line 316 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
			rygel_player_controller_set_n_tracks (_tmp25_, (guint) 0);
#line 317 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
			_tmp26_ = self->priv->controller;
#line 317 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
			rygel_player_controller_set_track (_tmp26_, (guint) 0);
#line 1824 "rygel-av-transport.c"
		} else {
			RygelPlayerController* _tmp27_;
			RygelPlayerController* _tmp28_;
#line 319 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
			_tmp27_ = self->priv->controller;
#line 319 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
			rygel_player_controller_set_n_tracks (_tmp27_, (guint) 1);
#line 320 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
			_tmp28_ = self->priv->controller;
#line 320 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
			rygel_player_controller_set_track (_tmp28_, (guint) 1);
#line 1836 "rygel-av-transport.c"
		}
#line 323 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_tmp29_ = _data1_->action;
#line 323 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		gupnp_service_action_return (_tmp29_);
#line 1842 "rygel-av-transport.c"
	}
#line 228 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	block1_data_unref (_data1_);
#line 228 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_data1_ = NULL;
#line 1848 "rygel-av-transport.c"
}


static gchar* string_replace (const gchar* self, const gchar* old, const gchar* replacement) {
	gchar* result = NULL;
	GError * _inner_error_ = NULL;
#line 1242 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1242 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	g_return_val_if_fail (old != NULL, NULL);
#line 1242 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	g_return_val_if_fail (replacement != NULL, NULL);
#line 1861 "rygel-av-transport.c"
	{
		const gchar* _tmp0_;
		gchar* _tmp1_ = NULL;
		gchar* _tmp2_;
		GRegex* _tmp3_;
		GRegex* _tmp4_;
		GRegex* regex;
		GRegex* _tmp5_;
		const gchar* _tmp6_;
		gchar* _tmp7_ = NULL;
		gchar* _tmp8_;
#line 1244 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		_tmp0_ = old;
#line 1244 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		_tmp1_ = g_regex_escape_string (_tmp0_, -1);
#line 1244 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		_tmp2_ = _tmp1_;
#line 1244 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		_tmp3_ = g_regex_new (_tmp2_, 0, 0, &_inner_error_);
#line 1244 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		_tmp4_ = _tmp3_;
#line 1244 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		_g_free0 (_tmp2_);
#line 1244 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		regex = _tmp4_;
#line 1244 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		if (_inner_error_ != NULL) {
#line 1244 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
			if (_inner_error_->domain == G_REGEX_ERROR) {
#line 1891 "rygel-av-transport.c"
				goto __catch0_g_regex_error;
			}
#line 1244 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1244 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
			g_clear_error (&_inner_error_);
#line 1244 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
			return NULL;
#line 1900 "rygel-av-transport.c"
		}
#line 1245 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		_tmp5_ = regex;
#line 1245 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		_tmp6_ = replacement;
#line 1245 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		_tmp7_ = g_regex_replace_literal (_tmp5_, self, (gssize) (-1), 0, _tmp6_, 0, &_inner_error_);
#line 1245 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		_tmp8_ = _tmp7_;
#line 1245 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		if (_inner_error_ != NULL) {
#line 1245 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
			_g_regex_unref0 (regex);
#line 1245 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
			if (_inner_error_->domain == G_REGEX_ERROR) {
#line 1916 "rygel-av-transport.c"
				goto __catch0_g_regex_error;
			}
#line 1245 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
			_g_regex_unref0 (regex);
#line 1245 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1245 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
			g_clear_error (&_inner_error_);
#line 1245 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
			return NULL;
#line 1927 "rygel-av-transport.c"
		}
#line 1245 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		result = _tmp8_;
#line 1245 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		_g_regex_unref0 (regex);
#line 1245 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		return result;
#line 1935 "rygel-av-transport.c"
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		GError* e = NULL;
#line 1243 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		e = _inner_error_;
#line 1243 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		_inner_error_ = NULL;
#line 1247 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		g_assert_not_reached ();
#line 1243 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		_g_error_free0 (e);
#line 1949 "rygel-av-transport.c"
	}
	__finally0:
#line 1243 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	if (_inner_error_ != NULL) {
#line 1243 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1243 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		g_clear_error (&_inner_error_);
#line 1243 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		return NULL;
#line 1960 "rygel-av-transport.c"
	}
}


static gboolean _vala_string_array_contains (gchar** stack, int stack_length, gchar* needle) {
	int i;
#line 334 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	for (i = 0; i < stack_length; i++) {
#line 334 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		if (g_strcmp0 (stack[i], needle) == 0) {
#line 334 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
			return TRUE;
#line 1973 "rygel-av-transport.c"
		}
	}
#line 334 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	return FALSE;
#line 1978 "rygel-av-transport.c"
}


static gboolean rygel_av_transport_is_valid_mime_type (RygelAVTransport* self, const gchar* mime) {
	gboolean result = FALSE;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_;
	gchar* normalized;
	const gchar* _tmp6_;
	RygelMediaPlayer* _tmp7_;
	gint _tmp8_ = 0;
	gchar** _tmp9_ = NULL;
	gchar** _tmp10_;
	gint _tmp10__length1;
	gboolean _tmp11_;
#line 327 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 328 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp0_ = mime;
#line 328 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	if (_tmp0_ == NULL) {
#line 329 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		result = FALSE;
#line 329 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		return result;
#line 2008 "rygel-av-transport.c"
	}
#line 332 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp1_ = mime;
#line 332 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp2_ = g_utf8_strdown (_tmp1_, (gssize) (-1));
#line 332 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp3_ = _tmp2_;
#line 332 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp4_ = string_replace (_tmp3_, " ", "");
#line 332 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp5_ = _tmp4_;
#line 332 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_g_free0 (_tmp3_);
#line 332 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	normalized = _tmp5_;
#line 334 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp6_ = normalized;
#line 334 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp7_ = self->priv->player;
#line 334 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp9_ = rygel_media_player_get_mime_types (_tmp7_, &_tmp8_);
#line 334 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp10_ = _tmp9_;
#line 334 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp10__length1 = _tmp8_;
#line 334 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp11_ = _vala_string_array_contains (_tmp10_, _tmp8_, _tmp6_);
#line 334 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp10_ = (_vala_array_free (_tmp10_, _tmp10__length1, (GDestroyNotify) g_free), NULL);
#line 334 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	result = _tmp11_;
#line 334 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_g_free0 (normalized);
#line 334 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	return result;
#line 2044 "rygel-av-transport.c"
}


static void rygel_av_transport_get_media_info_cb (RygelAVTransport* self, GUPnPService* service, GUPnPServiceAction* action) {
	GUPnPServiceAction* _tmp0_;
	gboolean _tmp1_ = FALSE;
	gchar* media_duration = NULL;
	RygelPlayerController* _tmp2_;
	guint _tmp3_;
	guint _tmp4_;
	GUPnPServiceAction* _tmp9_;
	RygelPlayerController* _tmp10_;
	guint _tmp11_;
	guint _tmp12_;
	const gchar* _tmp13_;
	RygelPlayerController* _tmp14_;
	const gchar* _tmp15_;
	const gchar* _tmp16_;
	RygelPlayerController* _tmp17_;
	gchar* _tmp18_;
	gchar* _tmp19_;
	gchar* _tmp20_;
	GUPnPServiceAction* _tmp21_;
#line 337 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_return_if_fail (self != NULL);
#line 337 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_return_if_fail (service != NULL);
#line 337 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_return_if_fail (action != NULL);
#line 339 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp0_ = action;
#line 339 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp1_ = rygel_av_transport_check_instance_id (self, _tmp0_);
#line 339 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	if (!_tmp1_) {
#line 340 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		return;
#line 2082 "rygel-av-transport.c"
	}
#line 344 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp2_ = self->priv->controller;
#line 344 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp3_ = rygel_player_controller_get_n_tracks (_tmp2_);
#line 344 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp4_ = _tmp3_;
#line 344 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	if (_tmp4_ > ((guint) 1)) {
#line 2092 "rygel-av-transport.c"
		gchar* _tmp5_;
#line 347 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_tmp5_ = g_strdup ("0:00:00");
#line 347 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_g_free0 (media_duration);
#line 347 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		media_duration = _tmp5_;
#line 2100 "rygel-av-transport.c"
	} else {
		RygelMediaPlayer* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
#line 349 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_tmp6_ = self->priv->player;
#line 349 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_tmp7_ = rygel_media_player_get_duration_as_str (_tmp6_);
#line 349 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_tmp8_ = _tmp7_;
#line 349 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_g_free0 (media_duration);
#line 349 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		media_duration = _tmp8_;
#line 2115 "rygel-av-transport.c"
	}
#line 352 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp9_ = action;
#line 352 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp10_ = self->priv->controller;
#line 352 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp11_ = rygel_player_controller_get_n_tracks (_tmp10_);
#line 352 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp12_ = _tmp11_;
#line 352 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp13_ = media_duration;
#line 352 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp14_ = self->priv->controller;
#line 352 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp15_ = rygel_player_controller_get_uri (_tmp14_);
#line 352 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp16_ = _tmp15_;
#line 352 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp17_ = self->priv->controller;
#line 352 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp18_ = rygel_player_controller_get_metadata (_tmp17_);
#line 352 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp19_ = _tmp18_;
#line 352 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp20_ = _tmp19_;
#line 352 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	gupnp_service_action_set (_tmp9_, "NrTracks", G_TYPE_UINT, _tmp12_, "MediaDuration", G_TYPE_STRING, _tmp13_, "CurrentURI", G_TYPE_STRING, _tmp16_, "CurrentURIMetaData", G_TYPE_STRING, _tmp20_, "NextURI", G_TYPE_STRING, "NOT_IMPLEMENTED", "NextURIMetaData", G_TYPE_STRING, "NOT_IMPLEMENTED", "PlayMedium", G_TYPE_STRING, "NOT_IMPLEMENTED", "RecordMedium", G_TYPE_STRING, "NOT_IMPLEMENTED", "WriteStatus", G_TYPE_STRING, "NOT_IMPLEMENTED", NULL);
#line 352 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_g_free0 (_tmp20_);
#line 380 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp21_ = action;
#line 380 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	gupnp_service_action_return (_tmp21_);
#line 337 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_g_free0 (media_duration);
#line 2151 "rygel-av-transport.c"
}


static void rygel_av_transport_get_media_info_ex_cb (RygelAVTransport* self, GUPnPService* service, GUPnPServiceAction* action) {
	GUPnPServiceAction* _tmp0_;
	gboolean _tmp1_ = FALSE;
	gchar* media_duration = NULL;
	RygelPlayerController* _tmp2_;
	guint _tmp3_;
	guint _tmp4_;
	GUPnPServiceAction* _tmp9_;
	RygelPlayerController* _tmp10_;
	guint _tmp11_;
	guint _tmp12_;
	const gchar* _tmp13_;
	RygelPlayerController* _tmp14_;
	const gchar* _tmp15_;
	const gchar* _tmp16_;
	RygelPlayerController* _tmp17_;
	gchar* _tmp18_;
	gchar* _tmp19_;
	gchar* _tmp20_;
	GUPnPServiceAction* _tmp21_;
#line 383 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_return_if_fail (self != NULL);
#line 383 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_return_if_fail (service != NULL);
#line 383 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_return_if_fail (action != NULL);
#line 385 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp0_ = action;
#line 385 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp1_ = rygel_av_transport_check_instance_id (self, _tmp0_);
#line 385 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	if (!_tmp1_) {
#line 386 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		return;
#line 2189 "rygel-av-transport.c"
	}
#line 390 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp2_ = self->priv->controller;
#line 390 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp3_ = rygel_player_controller_get_n_tracks (_tmp2_);
#line 390 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp4_ = _tmp3_;
#line 390 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	if (_tmp4_ > ((guint) 1)) {
#line 2199 "rygel-av-transport.c"
		gchar* _tmp5_;
#line 393 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_tmp5_ = g_strdup ("0:00:00");
#line 393 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_g_free0 (media_duration);
#line 393 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		media_duration = _tmp5_;
#line 2207 "rygel-av-transport.c"
	} else {
		RygelMediaPlayer* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
#line 395 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_tmp6_ = self->priv->player;
#line 395 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_tmp7_ = rygel_media_player_get_duration_as_str (_tmp6_);
#line 395 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_tmp8_ = _tmp7_;
#line 395 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_g_free0 (media_duration);
#line 395 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		media_duration = _tmp8_;
#line 2222 "rygel-av-transport.c"
	}
#line 398 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp9_ = action;
#line 398 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp10_ = self->priv->controller;
#line 398 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp11_ = rygel_player_controller_get_n_tracks (_tmp10_);
#line 398 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp12_ = _tmp11_;
#line 398 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp13_ = media_duration;
#line 398 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp14_ = self->priv->controller;
#line 398 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp15_ = rygel_player_controller_get_uri (_tmp14_);
#line 398 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp16_ = _tmp15_;
#line 398 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp17_ = self->priv->controller;
#line 398 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp18_ = rygel_player_controller_get_metadata (_tmp17_);
#line 398 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp19_ = _tmp18_;
#line 398 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp20_ = _tmp19_;
#line 398 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	gupnp_service_action_set (_tmp9_, "CurrentType", G_TYPE_STRING, "NO_MEDIA", "NrTracks", G_TYPE_UINT, _tmp12_, "MediaDuration", G_TYPE_STRING, _tmp13_, "CurrentURI", G_TYPE_STRING, _tmp16_, "CurrentURIMetaData", G_TYPE_STRING, _tmp20_, "NextURI", G_TYPE_STRING, "NOT_IMPLEMENTED", "NextURIMetaData", G_TYPE_STRING, "NOT_IMPLEMENTED", "PlayMedium", G_TYPE_STRING, "NOT_IMPLEMENTED", "RecordMedium", G_TYPE_STRING, "NOT_IMPLEMENTED", "WriteStatus", G_TYPE_STRING, "NOT_IMPLEMENTED", NULL);
#line 398 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_g_free0 (_tmp20_);
#line 429 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp21_ = action;
#line 429 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	gupnp_service_action_return (_tmp21_);
#line 383 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_g_free0 (media_duration);
#line 2258 "rygel-av-transport.c"
}


static void rygel_av_transport_get_transport_info_cb (RygelAVTransport* self, GUPnPService* service, GUPnPServiceAction* action) {
	GUPnPServiceAction* _tmp0_;
	gboolean _tmp1_ = FALSE;
	GUPnPServiceAction* _tmp2_;
	RygelMediaPlayer* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	RygelMediaPlayer* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	GUPnPServiceAction* _tmp13_;
#line 433 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_return_if_fail (self != NULL);
#line 433 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_return_if_fail (service != NULL);
#line 433 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_return_if_fail (action != NULL);
#line 435 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp0_ = action;
#line 435 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp1_ = rygel_av_transport_check_instance_id (self, _tmp0_);
#line 435 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	if (!_tmp1_) {
#line 436 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		return;
#line 2291 "rygel-av-transport.c"
	}
#line 439 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp2_ = action;
#line 439 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp3_ = self->priv->player;
#line 439 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp4_ = rygel_media_player_get_playback_state (_tmp3_);
#line 439 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp5_ = _tmp4_;
#line 439 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp6_ = _tmp5_;
#line 439 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp7_ = rygel_av_transport_get_status (self);
#line 439 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp8_ = _tmp7_;
#line 439 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp9_ = self->priv->player;
#line 439 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp10_ = rygel_media_player_get_playback_speed (_tmp9_);
#line 439 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp11_ = _tmp10_;
#line 439 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp12_ = _tmp11_;
#line 439 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	gupnp_service_action_set (_tmp2_, "CurrentTransportState", G_TYPE_STRING, _tmp6_, "CurrentTransportStatus", G_TYPE_STRING, _tmp8_, "CurrentSpeed", G_TYPE_STRING, _tmp12_, NULL);
#line 439 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_g_free0 (_tmp12_);
#line 439 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_g_free0 (_tmp6_);
#line 449 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp13_ = action;
#line 449 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	gupnp_service_action_return (_tmp13_);
#line 2325 "rygel-av-transport.c"
}


static void rygel_av_transport_get_transport_actions_cb (RygelAVTransport* self, GUPnPService* service, GUPnPServiceAction* action) {
	GUPnPServiceAction* _tmp0_;
	gboolean _tmp1_ = FALSE;
	GUPnPServiceAction* _tmp2_;
	RygelPlayerController* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	GUPnPServiceAction* _tmp7_;
#line 452 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_return_if_fail (self != NULL);
#line 452 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_return_if_fail (service != NULL);
#line 452 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_return_if_fail (action != NULL);
#line 454 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp0_ = action;
#line 454 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp1_ = rygel_av_transport_check_instance_id (self, _tmp0_);
#line 454 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	if (!_tmp1_) {
#line 455 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		return;
#line 2352 "rygel-av-transport.c"
	}
#line 458 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp2_ = action;
#line 458 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp3_ = self->priv->controller;
#line 458 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp4_ = rygel_player_controller_get_current_transport_actions (_tmp3_);
#line 458 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp5_ = _tmp4_;
#line 458 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp6_ = _tmp5_;
#line 458 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	gupnp_service_action_set (_tmp2_, "Actions", G_TYPE_STRING, _tmp6_, NULL);
#line 458 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_g_free0 (_tmp6_);
#line 462 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp7_ = action;
#line 462 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	gupnp_service_action_return (_tmp7_);
#line 2372 "rygel-av-transport.c"
}


static void rygel_av_transport_get_position_info_cb (RygelAVTransport* self, GUPnPService* service, GUPnPServiceAction* action) {
	GUPnPServiceAction* _tmp0_;
	gboolean _tmp1_ = FALSE;
	GUPnPServiceAction* _tmp2_;
	RygelPlayerController* _tmp3_;
	guint _tmp4_;
	guint _tmp5_;
	RygelMediaPlayer* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	RygelMediaPlayer* _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
	gchar* _tmp19_;
	RygelMediaPlayer* _tmp20_;
	gchar* _tmp21_;
	gchar* _tmp22_;
	gchar* _tmp23_;
	gint _tmp24_;
	gint _tmp25_;
	GUPnPServiceAction* _tmp26_;
#line 465 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_return_if_fail (self != NULL);
#line 465 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_return_if_fail (service != NULL);
#line 465 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_return_if_fail (action != NULL);
#line 467 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp0_ = action;
#line 467 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp1_ = rygel_av_transport_check_instance_id (self, _tmp0_);
#line 467 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	if (!_tmp1_) {
#line 468 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		return;
#line 2418 "rygel-av-transport.c"
	}
#line 471 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp2_ = action;
#line 471 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp3_ = self->priv->controller;
#line 471 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp4_ = rygel_player_controller_get_track (_tmp3_);
#line 471 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp5_ = _tmp4_;
#line 471 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp6_ = self->priv->player;
#line 471 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp7_ = rygel_media_player_get_duration_as_str (_tmp6_);
#line 471 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp8_ = _tmp7_;
#line 471 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp9_ = _tmp8_;
#line 471 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp10_ = rygel_av_transport_get_track_metadata (self);
#line 471 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp11_ = _tmp10_;
#line 471 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp12_ = _tmp11_;
#line 471 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp13_ = rygel_av_transport_get_track_uri (self);
#line 471 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp14_ = _tmp13_;
#line 471 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp15_ = _tmp14_;
#line 471 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp16_ = self->priv->player;
#line 471 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp17_ = rygel_media_player_get_position_as_str (_tmp16_);
#line 471 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp18_ = _tmp17_;
#line 471 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp19_ = _tmp18_;
#line 471 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp20_ = self->priv->player;
#line 471 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp21_ = rygel_media_player_get_position_as_str (_tmp20_);
#line 471 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp22_ = _tmp21_;
#line 471 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp23_ = _tmp22_;
#line 471 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp24_ = G_MAXINT;
#line 471 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp25_ = G_MAXINT;
#line 471 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	gupnp_service_action_set (_tmp2_, "Track", G_TYPE_UINT, _tmp5_, "TrackDuration", G_TYPE_STRING, _tmp9_, "TrackMetaData", G_TYPE_STRING, _tmp12_, "TrackURI", G_TYPE_STRING, _tmp15_, "RelTime", G_TYPE_STRING, _tmp19_, "AbsTime", G_TYPE_STRING, _tmp23_, "RelCount", G_TYPE_INT, _tmp24_, "AbsCount", G_TYPE_INT, _tmp25_, NULL);
#line 471 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_g_free0 (_tmp23_);
#line 471 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_g_free0 (_tmp19_);
#line 471 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_g_free0 (_tmp15_);
#line 471 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_g_free0 (_tmp12_);
#line 471 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_g_free0 (_tmp9_);
#line 496 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp26_ = action;
#line 496 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	gupnp_service_action_return (_tmp26_);
#line 2484 "rygel-av-transport.c"
}


static void rygel_av_transport_get_device_capabilities_cb (RygelAVTransport* self, GUPnPService* service, GUPnPServiceAction* action) {
	GUPnPServiceAction* _tmp0_;
	gboolean _tmp1_ = FALSE;
	GUPnPServiceAction* _tmp2_;
	GUPnPServiceAction* _tmp3_;
#line 499 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_return_if_fail (self != NULL);
#line 499 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_return_if_fail (service != NULL);
#line 499 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_return_if_fail (action != NULL);
#line 501 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp0_ = action;
#line 501 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp1_ = rygel_av_transport_check_instance_id (self, _tmp0_);
#line 501 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	if (!_tmp1_) {
#line 502 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		return;
#line 2507 "rygel-av-transport.c"
	}
#line 505 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp2_ = action;
#line 505 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	gupnp_service_action_set (_tmp2_, "PlayMedia", G_TYPE_STRING, "NOT_IMPLEMENTED", "RecMedia", G_TYPE_STRING, "NOT_IMPLEMENTED", "RecQualityModes", G_TYPE_STRING, "NOT_IMPLEMENTED", NULL);
#line 515 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp3_ = action;
#line 515 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	gupnp_service_action_return (_tmp3_);
#line 2517 "rygel-av-transport.c"
}


static void rygel_av_transport_get_transport_settings_cb (RygelAVTransport* self, GUPnPService* service, GUPnPServiceAction* action) {
	GUPnPServiceAction* _tmp0_;
	gboolean _tmp1_ = FALSE;
	GUPnPServiceAction* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	GUPnPServiceAction* _tmp5_;
#line 518 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_return_if_fail (self != NULL);
#line 518 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_return_if_fail (service != NULL);
#line 518 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_return_if_fail (action != NULL);
#line 520 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp0_ = action;
#line 520 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp1_ = rygel_av_transport_check_instance_id (self, _tmp0_);
#line 520 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	if (!_tmp1_) {
#line 521 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		return;
#line 2542 "rygel-av-transport.c"
	}
#line 524 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp2_ = action;
#line 524 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp3_ = rygel_av_transport_get_mode (self);
#line 524 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp4_ = _tmp3_;
#line 524 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	gupnp_service_action_set (_tmp2_, "PlayMode", G_TYPE_STRING, _tmp4_, "RecQualityMode", G_TYPE_STRING, "NOT_IMPLEMENTED", NULL);
#line 531 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp5_ = action;
#line 531 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	gupnp_service_action_return (_tmp5_);
#line 2556 "rygel-av-transport.c"
}


static void rygel_av_transport_stop_cb (RygelAVTransport* self, GUPnPService* service, GUPnPServiceAction* action) {
	GUPnPServiceAction* _tmp0_;
	gboolean _tmp1_ = FALSE;
	RygelMediaPlayer* _tmp2_;
	GUPnPServiceAction* _tmp3_;
#line 534 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_return_if_fail (self != NULL);
#line 534 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_return_if_fail (service != NULL);
#line 534 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_return_if_fail (action != NULL);
#line 535 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp0_ = action;
#line 535 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp1_ = rygel_av_transport_check_instance_id (self, _tmp0_);
#line 535 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	if (!_tmp1_) {
#line 536 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		return;
#line 2579 "rygel-av-transport.c"
	}
#line 539 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp2_ = self->priv->player;
#line 539 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	rygel_media_player_set_playback_state (_tmp2_, "STOPPED");
#line 541 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp3_ = action;
#line 541 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	gupnp_service_action_return (_tmp3_);
#line 2589 "rygel-av-transport.c"
}


static void rygel_av_transport_play_cb (RygelAVTransport* self, GUPnPService* service, GUPnPServiceAction* action) {
	GUPnPServiceAction* _tmp0_;
	gboolean _tmp1_ = FALSE;
	gchar* speed = NULL;
	GUPnPServiceAction* _tmp2_;
	const gchar* _tmp3_;
	RygelMediaPlayer* _tmp4_;
	gchar** _tmp5_;
	gint _tmp5__length1;
	gchar** _tmp6_;
	gint _tmp6__length1;
	gchar** _tmp7_;
	gint _tmp7__length1;
	gboolean _tmp8_;
	RygelMediaPlayer* _tmp11_;
	RygelMediaPlayer* _tmp12_;
	const gchar* _tmp13_;
	GUPnPServiceAction* _tmp14_;
#line 544 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_return_if_fail (self != NULL);
#line 544 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_return_if_fail (service != NULL);
#line 544 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_return_if_fail (action != NULL);
#line 545 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp0_ = action;
#line 545 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp1_ = rygel_av_transport_check_instance_id (self, _tmp0_);
#line 545 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	if (!_tmp1_) {
#line 546 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		return;
#line 2625 "rygel-av-transport.c"
	}
#line 551 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp2_ = action;
#line 551 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	gupnp_service_action_get (_tmp2_, "Speed", G_TYPE_STRING, &speed, NULL);
#line 552 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp3_ = speed;
#line 552 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp4_ = self->priv->player;
#line 552 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp5_ = rygel_media_player_get_allowed_playback_speeds (_tmp4_, &_tmp5__length1);
#line 552 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp6_ = _tmp5_;
#line 552 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp6__length1 = _tmp5__length1;
#line 552 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp7_ = _tmp6_;
#line 552 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp7__length1 = _tmp6__length1;
#line 552 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp8_ = !_vala_string_array_contains (_tmp7_, _tmp6__length1, _tmp3_);
#line 552 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp7_ = (_vala_array_free (_tmp7_, _tmp7__length1, (GDestroyNotify) g_free), NULL);
#line 552 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	if (_tmp8_) {
#line 2651 "rygel-av-transport.c"
		GUPnPServiceAction* _tmp9_;
		const gchar* _tmp10_ = NULL;
#line 553 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_tmp9_ = action;
#line 553 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_tmp10_ = _ ("Play speed not supported");
#line 553 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		gupnp_service_action_return_error (_tmp9_, (guint) 717, _tmp10_);
#line 555 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_g_free0 (speed);
#line 555 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		return;
#line 2664 "rygel-av-transport.c"
	}
#line 558 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp11_ = self->priv->player;
#line 558 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	rygel_media_player_set_playback_state (_tmp11_, "PLAYING");
#line 559 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp12_ = self->priv->player;
#line 559 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp13_ = speed;
#line 559 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	rygel_media_player_set_playback_speed (_tmp12_, _tmp13_);
#line 561 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp14_ = action;
#line 561 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	gupnp_service_action_return (_tmp14_);
#line 544 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_g_free0 (speed);
#line 2682 "rygel-av-transport.c"
}


static void rygel_av_transport_pause_cb (RygelAVTransport* self, GUPnPService* service, GUPnPServiceAction* action) {
	GUPnPServiceAction* _tmp0_;
	gboolean _tmp1_ = FALSE;
	RygelMediaPlayer* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gboolean _tmp6_;
	RygelMediaPlayer* _tmp9_;
	GUPnPServiceAction* _tmp10_;
#line 564 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_return_if_fail (self != NULL);
#line 564 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_return_if_fail (service != NULL);
#line 564 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_return_if_fail (action != NULL);
#line 565 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp0_ = action;
#line 565 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp1_ = rygel_av_transport_check_instance_id (self, _tmp0_);
#line 565 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	if (!_tmp1_) {
#line 566 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		return;
#line 2710 "rygel-av-transport.c"
	}
#line 569 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp2_ = self->priv->player;
#line 569 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp3_ = rygel_media_player_get_playback_state (_tmp2_);
#line 569 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp4_ = _tmp3_;
#line 569 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp5_ = _tmp4_;
#line 569 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp6_ = g_strcmp0 (_tmp5_, "PLAYING") != 0;
#line 569 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_g_free0 (_tmp5_);
#line 569 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	if (_tmp6_) {
#line 2726 "rygel-av-transport.c"
		GUPnPServiceAction* _tmp7_;
		const gchar* _tmp8_ = NULL;
#line 570 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_tmp7_ = action;
#line 570 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_tmp8_ = _ ("Transition not available");
#line 570 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		gupnp_service_action_return_error (_tmp7_, (guint) 701, _tmp8_);
#line 572 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		return;
#line 2737 "rygel-av-transport.c"
	}
#line 575 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp9_ = self->priv->player;
#line 575 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	rygel_media_player_set_playback_state (_tmp9_, "PAUSED_PLAYBACK");
#line 577 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp10_ = action;
#line 577 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	gupnp_service_action_return (_tmp10_);
#line 2747 "rygel-av-transport.c"
}


static void rygel_av_transport_seek_cb (RygelAVTransport* self, GUPnPService* service, GUPnPServiceAction* action) {
	GUPnPServiceAction* _tmp0_;
	gboolean _tmp1_ = FALSE;
	gchar* unit = NULL;
	gchar* target = NULL;
	GUPnPServiceAction* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	GQuark _tmp6_ = 0U;
#line 593 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	static GQuark _tmp5_label0 = 0;
#line 593 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	static GQuark _tmp5_label1 = 0;
#line 593 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	static GQuark _tmp5_label2 = 0;
#line 580 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_return_if_fail (self != NULL);
#line 580 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_return_if_fail (service != NULL);
#line 580 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_return_if_fail (action != NULL);
#line 581 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp0_ = action;
#line 581 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp1_ = rygel_av_transport_check_instance_id (self, _tmp0_);
#line 581 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	if (!_tmp1_) {
#line 582 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		return;
#line 2780 "rygel-av-transport.c"
	}
#line 587 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp2_ = action;
#line 587 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	gupnp_service_action_get (_tmp2_, "Unit", G_TYPE_STRING, &unit, "Target", G_TYPE_STRING, &target, NULL);
#line 593 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp3_ = unit;
#line 593 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp4_ = _tmp3_;
#line 593 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp6_ = (NULL == _tmp4_) ? 0 : g_quark_from_string (_tmp4_);
#line 593 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	if ((_tmp6_ == ((0 != _tmp5_label0) ? _tmp5_label0 : (_tmp5_label0 = g_quark_from_static_string ("ABS_TIME")))) || (_tmp6_ == ((0 != _tmp5_label1) ? _tmp5_label1 : (_tmp5_label1 = g_quark_from_static_string ("REL_TIME"))))) {
#line 593 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		switch (0) {
#line 2796 "rygel-av-transport.c"
			default:
			{
				const gchar* _tmp7_;
				RygelMediaPlayer* _tmp8_;
				const gchar* _tmp9_;
				gint64 _tmp10_ = 0LL;
				gboolean _tmp11_ = FALSE;
				GUPnPServiceAction* _tmp14_;
#line 596 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
				_tmp7_ = target;
#line 596 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
				g_debug ("rygel-av-transport.vala:596: Seeking to %s.", _tmp7_);
#line 598 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
				_tmp8_ = self->priv->player;
#line 598 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
				_tmp9_ = target;
#line 598 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
				_tmp10_ = rygel_time_utils_time_from_string (_tmp9_);
#line 598 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
				_tmp11_ = rygel_media_player_seek (_tmp8_, _tmp10_);
#line 598 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
				if (!_tmp11_) {
#line 2819 "rygel-av-transport.c"
					GUPnPServiceAction* _tmp12_;
					const gchar* _tmp13_ = NULL;
#line 599 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
					_tmp12_ = action;
#line 599 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
					_tmp13_ = _ ("Seek mode not supported");
#line 599 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
					gupnp_service_action_return_error (_tmp12_, (guint) 710, _tmp13_);
#line 601 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
					_g_free0 (target);
#line 601 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
					_g_free0 (unit);
#line 601 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
					return;
#line 2834 "rygel-av-transport.c"
				}
#line 604 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
				_tmp14_ = action;
#line 604 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
				gupnp_service_action_return (_tmp14_);
#line 606 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
				_g_free0 (target);
#line 606 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
				_g_free0 (unit);
#line 606 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
				return;
#line 2846 "rygel-av-transport.c"
			}
		}
	} else if (_tmp6_ == ((0 != _tmp5_label2) ? _tmp5_label2 : (_tmp5_label2 = g_quark_from_static_string ("TRACK_NR")))) {
#line 593 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		switch (0) {
#line 2852 "rygel-av-transport.c"
			default:
			{
				const gchar* _tmp15_;
				const gchar* _tmp16_;
				gint _tmp17_ = 0;
				gint track;
				gboolean _tmp18_ = FALSE;
				gint _tmp19_;
				gboolean _tmp24_;
				RygelPlayerController* _tmp27_;
				gint _tmp28_;
				GUPnPServiceAction* _tmp29_;
#line 608 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
				_tmp15_ = target;
#line 608 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
				g_debug ("rygel-av-transport.vala:608: Setting track to %s.", _tmp15_);
#line 609 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
				_tmp16_ = target;
#line 609 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
				_tmp17_ = atoi (_tmp16_);
#line 609 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
				track = _tmp17_;
#line 611 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
				_tmp19_ = track;
#line 611 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
				if (_tmp19_ < 1) {
#line 611 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
					_tmp18_ = TRUE;
#line 2881 "rygel-av-transport.c"
				} else {
					gint _tmp20_;
					RygelPlayerController* _tmp21_;
					guint _tmp22_;
					guint _tmp23_;
#line 611 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
					_tmp20_ = track;
#line 611 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
					_tmp21_ = self->priv->controller;
#line 611 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
					_tmp22_ = rygel_player_controller_get_n_tracks (_tmp21_);
#line 611 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
					_tmp23_ = _tmp22_;
#line 611 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
					_tmp18_ = ((guint) _tmp20_) > _tmp23_;
#line 2897 "rygel-av-transport.c"
				}
#line 611 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
				_tmp24_ = _tmp18_;
#line 611 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
				if (_tmp24_) {
#line 2903 "rygel-av-transport.c"
					GUPnPServiceAction* _tmp25_;
					const gchar* _tmp26_ = NULL;
#line 612 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
					_tmp25_ = action;
#line 612 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
					_tmp26_ = _ ("Illegal seek target");
#line 612 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
					gupnp_service_action_return_error (_tmp25_, (guint) 711, _tmp26_);
#line 614 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
					_g_free0 (target);
#line 614 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
					_g_free0 (unit);
#line 614 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
					return;
#line 2918 "rygel-av-transport.c"
				}
#line 617 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
				_tmp27_ = self->priv->controller;
#line 617 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
				_tmp28_ = track;
#line 617 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
				rygel_player_controller_set_track (_tmp27_, (guint) _tmp28_);
#line 619 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
				_tmp29_ = action;
#line 619 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
				gupnp_service_action_return (_tmp29_);
#line 621 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
				break;
#line 2932 "rygel-av-transport.c"
			}
		}
	} else {
#line 593 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		switch (0) {
#line 2938 "rygel-av-transport.c"
			default:
			{
				GUPnPServiceAction* _tmp30_;
				const gchar* _tmp31_ = NULL;
#line 623 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
				_tmp30_ = action;
#line 623 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
				_tmp31_ = _ ("Seek mode not supported");
#line 623 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
				gupnp_service_action_return_error (_tmp30_, (guint) 710, _tmp31_);
#line 625 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
				_g_free0 (target);
#line 625 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
				_g_free0 (unit);
#line 625 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
				return;
#line 2955 "rygel-av-transport.c"
			}
		}
	}
#line 580 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_g_free0 (target);
#line 580 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_g_free0 (unit);
#line 2963 "rygel-av-transport.c"
}


static void rygel_av_transport_next_cb (RygelAVTransport* self, GUPnPService* service, GUPnPServiceAction* action) {
	RygelPlayerController* _tmp0_;
	gboolean _tmp1_ = FALSE;
#line 629 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_return_if_fail (self != NULL);
#line 629 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_return_if_fail (service != NULL);
#line 629 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_return_if_fail (action != NULL);
#line 630 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp0_ = self->priv->controller;
#line 630 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp1_ = rygel_player_controller_next (_tmp0_);
#line 630 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	if (_tmp1_) {
#line 2982 "rygel-av-transport.c"
		GUPnPServiceAction* _tmp2_;
#line 631 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_tmp2_ = action;
#line 631 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		gupnp_service_action_return (_tmp2_);
#line 2988 "rygel-av-transport.c"
	} else {
		GUPnPServiceAction* _tmp3_;
		const gchar* _tmp4_ = NULL;
#line 633 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_tmp3_ = action;
#line 633 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_tmp4_ = _ ("Illegal seek target");
#line 633 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		gupnp_service_action_return_error (_tmp3_, (guint) 711, _tmp4_);
#line 2998 "rygel-av-transport.c"
	}
}


static void rygel_av_transport_previous_cb (RygelAVTransport* self, GUPnPService* service, GUPnPServiceAction* action) {
	RygelPlayerController* _tmp0_;
	gboolean _tmp1_ = FALSE;
#line 637 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_return_if_fail (self != NULL);
#line 637 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_return_if_fail (service != NULL);
#line 637 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_return_if_fail (action != NULL);
#line 638 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp0_ = self->priv->controller;
#line 638 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp1_ = rygel_player_controller_previous (_tmp0_);
#line 638 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	if (_tmp1_) {
#line 3018 "rygel-av-transport.c"
		GUPnPServiceAction* _tmp2_;
#line 639 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_tmp2_ = action;
#line 639 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		gupnp_service_action_return (_tmp2_);
#line 3024 "rygel-av-transport.c"
	} else {
		GUPnPServiceAction* _tmp3_;
		const gchar* _tmp4_ = NULL;
#line 641 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_tmp3_ = action;
#line 641 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_tmp4_ = _ ("Illegal seek target");
#line 641 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		gupnp_service_action_return_error (_tmp3_, (guint) 711, _tmp4_);
#line 3034 "rygel-av-transport.c"
	}
}


static void rygel_av_transport_notify_state_cb (RygelAVTransport* self, GObject* player, GParamSpec* p) {
	RygelMediaPlayer* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* state;
	RygelChangeLog* _tmp3_;
	RygelChangeLog* _tmp4_;
	RygelPlayerController* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
#line 645 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_return_if_fail (self != NULL);
#line 645 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_return_if_fail (player != NULL);
#line 645 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_return_if_fail (p != NULL);
#line 646 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp0_ = self->priv->player;
#line 646 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp1_ = rygel_media_player_get_playback_state (_tmp0_);
#line 646 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp2_ = _tmp1_;
#line 646 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	state = _tmp2_;
#line 647 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp3_ = self->priv->changelog;
#line 647 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	rygel_change_log_log (_tmp3_, "TransportState", state);
#line 648 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp4_ = self->priv->changelog;
#line 648 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp5_ = self->priv->controller;
#line 648 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp6_ = rygel_player_controller_get_current_transport_actions (_tmp5_);
#line 648 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp7_ = _tmp6_;
#line 648 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp8_ = _tmp7_;
#line 648 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	rygel_change_log_log (_tmp4_, "CurrentTransportActions", _tmp8_);
#line 648 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_g_free0 (_tmp8_);
#line 645 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_g_free0 (state);
#line 3084 "rygel-av-transport.c"
}


static void rygel_av_transport_notify_n_tracks_cb (RygelAVTransport* self, GObject* player, GParamSpec* p) {
	RygelChangeLog* _tmp0_;
	RygelPlayerController* _tmp1_;
	guint _tmp2_;
	guint _tmp3_;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_;
#line 652 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_return_if_fail (self != NULL);
#line 652 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_return_if_fail (player != NULL);
#line 652 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_return_if_fail (p != NULL);
#line 653 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp0_ = self->priv->changelog;
#line 653 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp1_ = self->priv->controller;
#line 653 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp2_ = rygel_player_controller_get_n_tracks (_tmp1_);
#line 653 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp3_ = _tmp2_;
#line 653 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp4_ = g_strdup_printf ("%u", _tmp3_);
#line 653 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp5_ = _tmp4_;
#line 653 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	rygel_change_log_log (_tmp0_, "NumberOfTracks", _tmp5_);
#line 653 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_g_free0 (_tmp5_);
#line 3117 "rygel-av-transport.c"
}


static void rygel_av_transport_notify_track_cb (RygelAVTransport* self, GObject* player, GParamSpec* p) {
	RygelChangeLog* _tmp0_;
	RygelPlayerController* _tmp1_;
	guint _tmp2_;
	guint _tmp3_;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_;
#line 657 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_return_if_fail (self != NULL);
#line 657 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_return_if_fail (player != NULL);
#line 657 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_return_if_fail (p != NULL);
#line 658 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp0_ = self->priv->changelog;
#line 658 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp1_ = self->priv->controller;
#line 658 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp2_ = rygel_player_controller_get_track (_tmp1_);
#line 658 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp3_ = _tmp2_;
#line 658 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp4_ = g_strdup_printf ("%u", _tmp3_);
#line 658 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp5_ = _tmp4_;
#line 658 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	rygel_change_log_log (_tmp0_, "CurrentTrack", _tmp5_);
#line 658 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_g_free0 (_tmp5_);
#line 3150 "rygel-av-transport.c"
}


static void rygel_av_transport_notify_duration_cb (RygelAVTransport* self, GObject* player, GParamSpec* p) {
	RygelChangeLog* _tmp0_;
	RygelMediaPlayer* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	RygelChangeLog* _tmp5_;
	RygelMediaPlayer* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
#line 662 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_return_if_fail (self != NULL);
#line 662 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_return_if_fail (player != NULL);
#line 662 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_return_if_fail (p != NULL);
#line 663 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp0_ = self->priv->changelog;
#line 663 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp1_ = self->priv->player;
#line 663 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp2_ = rygel_media_player_get_duration_as_str (_tmp1_);
#line 663 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp3_ = _tmp2_;
#line 663 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp4_ = _tmp3_;
#line 663 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	rygel_change_log_log (_tmp0_, "CurrentTrackDuration", _tmp4_);
#line 663 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_g_free0 (_tmp4_);
#line 665 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp5_ = self->priv->changelog;
#line 665 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp6_ = self->priv->player;
#line 665 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp7_ = rygel_media_player_get_duration_as_str (_tmp6_);
#line 665 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp8_ = _tmp7_;
#line 665 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp9_ = _tmp8_;
#line 665 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	rygel_change_log_log (_tmp5_, "CurrentMediaDuration", _tmp9_);
#line 665 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_g_free0 (_tmp9_);
#line 3199 "rygel-av-transport.c"
}


static void rygel_av_transport_notify_track_uri_cb (RygelAVTransport* self, GObject* player, GParamSpec* p) {
	RygelChangeLog* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
#line 669 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_return_if_fail (self != NULL);
#line 669 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_return_if_fail (player != NULL);
#line 669 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_return_if_fail (p != NULL);
#line 670 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp0_ = self->priv->changelog;
#line 670 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp1_ = rygel_av_transport_get_track_uri (self);
#line 670 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp2_ = _tmp1_;
#line 670 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp3_ = _tmp2_;
#line 670 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	rygel_change_log_log (_tmp0_, "CurrentTrackURI", _tmp3_);
#line 670 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_g_free0 (_tmp3_);
#line 3226 "rygel-av-transport.c"
}


static void rygel_av_transport_notify_uri_cb (RygelAVTransport* self, GObject* player, GParamSpec* p) {
	RygelChangeLog* _tmp0_;
	RygelPlayerController* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
#line 673 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_return_if_fail (self != NULL);
#line 673 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_return_if_fail (player != NULL);
#line 673 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_return_if_fail (p != NULL);
#line 674 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp0_ = self->priv->changelog;
#line 674 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp1_ = self->priv->controller;
#line 674 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp2_ = rygel_player_controller_get_uri (_tmp1_);
#line 674 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp3_ = _tmp2_;
#line 674 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	rygel_change_log_log (_tmp0_, "AVTransportURI", _tmp3_);
#line 3251 "rygel-av-transport.c"
}


static void rygel_av_transport_notify_track_meta_data_cb (RygelAVTransport* self, GObject* player, GParamSpec* p) {
	RygelChangeLog* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_;
#line 677 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_return_if_fail (self != NULL);
#line 677 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_return_if_fail (player != NULL);
#line 677 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_return_if_fail (p != NULL);
#line 678 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp0_ = self->priv->changelog;
#line 678 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp1_ = rygel_av_transport_get_track_metadata (self);
#line 678 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp2_ = _tmp1_;
#line 678 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp3_ = _tmp2_;
#line 678 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp4_ = g_markup_escape_text (_tmp3_, (gssize) (-1));
#line 678 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp5_ = _tmp4_;
#line 678 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	rygel_change_log_log (_tmp0_, "CurrentTrackMetaData", _tmp5_);
#line 678 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_g_free0 (_tmp5_);
#line 678 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_g_free0 (_tmp3_);
#line 3286 "rygel-av-transport.c"
}


static void rygel_av_transport_notify_meta_data_cb (RygelAVTransport* self, GObject* player, GParamSpec* p) {
	RygelChangeLog* _tmp0_;
	RygelPlayerController* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_;
#line 682 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_return_if_fail (self != NULL);
#line 682 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_return_if_fail (player != NULL);
#line 682 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_return_if_fail (p != NULL);
#line 683 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp0_ = self->priv->changelog;
#line 683 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp1_ = self->priv->controller;
#line 683 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp2_ = rygel_player_controller_get_metadata (_tmp1_);
#line 683 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp3_ = _tmp2_;
#line 683 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp4_ = _tmp3_;
#line 683 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp5_ = g_markup_escape_text (_tmp4_, (gssize) (-1));
#line 683 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp6_ = _tmp5_;
#line 683 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	rygel_change_log_log (_tmp0_, "AVTransportURIMetaData", _tmp6_);
#line 683 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_g_free0 (_tmp6_);
#line 683 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_g_free0 (_tmp4_);
#line 3324 "rygel-av-transport.c"
}


static void rygel_av_transport_handle_playlist_data_free (gpointer _data) {
	RygelAvTransportHandlePlaylistData* _data_;
	_data_ = _data;
#line 29 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	__vala_GUPnPServiceAction_free0 (_data_->action);
#line 29 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_g_object_unref0 (_data_->self);
#line 29 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_slice_free (RygelAvTransportHandlePlaylistData, _data_);
#line 3337 "rygel-av-transport.c"
}


static void rygel_av_transport_handle_playlist (RygelAVTransport* self, GUPnPServiceAction* action, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelAvTransportHandlePlaylistData* _data_;
	RygelAVTransport* _tmp0_;
	GUPnPServiceAction* _tmp1_;
	GUPnPServiceAction* _tmp2_;
#line 29 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_data_ = g_slice_new0 (RygelAvTransportHandlePlaylistData);
#line 29 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_av_transport_handle_playlist);
#line 29 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_av_transport_handle_playlist_data_free);
#line 29 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 29 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_data_->self = _tmp0_;
#line 29 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp1_ = action;
#line 29 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp2_ = __vala_GUPnPServiceAction_copy0 (_tmp1_);
#line 29 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	__vala_GUPnPServiceAction_free0 (_data_->action);
#line 29 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_data_->action = _tmp2_;
#line 29 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	rygel_av_transport_handle_playlist_co (_data_);
#line 3366 "rygel-av-transport.c"
}


static void rygel_av_transport_handle_playlist_finish (RygelAVTransport* self, GAsyncResult* _res_) {
	RygelAvTransportHandlePlaylistData* _data_;
#line 29 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 3374 "rygel-av-transport.c"
}


static Block2Data* block2_data_ref (Block2Data* _data2_) {
#line 687 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_atomic_int_inc (&_data2_->_ref_count_);
#line 687 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	return _data2_;
#line 3383 "rygel-av-transport.c"
}


static void block2_data_unref (void * _userdata_) {
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
#line 687 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
#line 3392 "rygel-av-transport.c"
		RygelAVTransport * self;
#line 687 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		self = _data2_->self;
#line 687 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_g_object_unref0 (self);
#line 687 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		g_slice_free (Block2Data, _data2_);
#line 3400 "rygel-av-transport.c"
	}
}


static void __lambda6_ (Block2Data* _data2_) {
	RygelAVTransport * self;
#line 689 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	self = _data2_->self;
#line 690 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	rygel_av_transport_handle_playlist_co (_data2_->_async_data_);
#line 3411 "rygel-av-transport.c"
}


static void ___lambda6__soup_session_callback (SoupSession* session, SoupMessage* msg, gpointer self) {
#line 689 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	__lambda6_ (self);
#line 3418 "rygel-av-transport.c"
}


static void _g_object_unref0_ (gpointer var) {
#line 703 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
#line 3425 "rygel-av-transport.c"
}


static void _g_list_free__g_object_unref0_ (GList* self) {
#line 703 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_list_foreach (self, (GFunc) _g_object_unref0_, NULL);
#line 703 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_list_free (self);
#line 3434 "rygel-av-transport.c"
}


static gboolean rygel_av_transport_handle_playlist_co (RygelAvTransportHandlePlaylistData* _data_) {
#line 687 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	switch (_data_->_state_) {
#line 687 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		case 0:
#line 3443 "rygel-av-transport.c"
		goto _state_0;
#line 687 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		case 1:
#line 3447 "rygel-av-transport.c"
		goto _state_1;
		default:
#line 687 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		g_assert_not_reached ();
#line 3452 "rygel-av-transport.c"
	}
	_state_0:
#line 687 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_data_->_data2_ = g_slice_new0 (Block2Data);
#line 687 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_data_->_data2_->_ref_count_ = 1;
#line 687 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_data_->_data2_->self = g_object_ref (_data_->self);
#line 687 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_data_->_data2_->_async_data_ = _data_;
#line 688 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_data_->_tmp0_ = _data_->self->priv->controller;
#line 688 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_data_->_tmp1_ = rygel_player_controller_get_uri (_data_->_tmp0_);
#line 688 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_data_->_tmp2_ = _data_->_tmp1_;
#line 688 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_data_->_tmp3_ = soup_message_new ("GET", _data_->_tmp2_);
#line 688 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_data_->message = _data_->_tmp3_;
#line 689 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_data_->_tmp4_ = _data_->self->priv->session;
#line 689 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_data_->_tmp5_ = _data_->message;
#line 689 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_data_->_tmp6_ = _g_object_ref0 (_data_->_tmp5_);
#line 689 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	soup_session_queue_message (_data_->_tmp4_, _data_->_tmp6_, ___lambda6__soup_session_callback, _data_->_data2_);
#line 692 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_data_->_state_ = 1;
#line 692 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	return FALSE;
#line 3485 "rygel-av-transport.c"
	_state_1:
	;
#line 694 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_data_->_tmp7_ = _data_->message;
#line 694 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_data_->_tmp8_ = 0U;
#line 694 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_object_get (_data_->_tmp7_, "status-code", &_data_->_tmp8_, NULL);
#line 694 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_data_->_tmp9_ = _data_->_tmp8_;
#line 694 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	if (_data_->_tmp9_ != ((guint) 200)) {
#line 695 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_data_->_tmp10_ = _data_->action;
#line 695 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_data_->_tmp11_ = NULL;
#line 695 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_data_->_tmp11_ = _ ("Resource not found");
#line 695 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		gupnp_service_action_return_error (_data_->_tmp10_, (guint) 716, _data_->_tmp11_);
#line 697 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_g_object_unref0 (_data_->message);
#line 697 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		block2_data_unref (_data_->_data2_);
#line 697 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_data_->_data2_ = NULL;
#line 697 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		if (_data_->_state_ == 0) {
#line 697 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 3516 "rygel-av-transport.c"
		} else {
#line 697 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 3520 "rygel-av-transport.c"
		}
#line 697 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		g_object_unref (_data_->_async_result);
#line 697 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		return FALSE;
#line 3526 "rygel-av-transport.c"
	}
#line 700 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_data_->_tmp12_ = _data_->message;
#line 700 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_data_->_tmp13_ = _data_->_tmp12_->response_body;
#line 700 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_data_->_tmp14_ = _data_->_tmp13_->data;
#line 700 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_data_->_tmp14__length1 = (gint) _data_->_tmp13_->length;
#line 700 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_data_->xml_string = (const gchar*) _data_->_tmp14_;
#line 702 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_data_->_tmp15_ = _data_->xml_string;
#line 702 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_data_->_tmp16_ = gupnp_media_collection_new_from_string (_data_->_tmp15_);
#line 702 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_data_->collection = _data_->_tmp16_;
#line 703 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_data_->_tmp17_ = _data_->collection;
#line 703 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_data_->_tmp18_ = NULL;
#line 703 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_data_->_tmp18_ = gupnp_media_collection_get_items (_data_->_tmp17_);
#line 703 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_data_->_tmp19_ = _data_->_tmp18_;
#line 703 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_data_->_tmp20_ = 0U;
#line 703 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_data_->_tmp20_ = g_list_length (_data_->_tmp19_);
#line 703 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_data_->_tmp21_ = _data_->_tmp20_ == ((guint) 0);
#line 703 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	__g_list_free__g_object_unref0_0 (_data_->_tmp19_);
#line 703 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	if (_data_->_tmp21_) {
#line 705 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_data_->_tmp22_ = _data_->action;
#line 705 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_data_->_tmp23_ = NULL;
#line 705 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_data_->_tmp23_ = _ ("Resource not found");
#line 705 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		gupnp_service_action_return_error (_data_->_tmp22_, (guint) 716, _data_->_tmp23_);
#line 707 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_g_object_unref0 (_data_->collection);
#line 707 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_g_object_unref0 (_data_->message);
#line 707 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		block2_data_unref (_data_->_data2_);
#line 707 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_data_->_data2_ = NULL;
#line 707 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		if (_data_->_state_ == 0) {
#line 707 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 3582 "rygel-av-transport.c"
		} else {
#line 707 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 3586 "rygel-av-transport.c"
		}
#line 707 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		g_object_unref (_data_->_async_result);
#line 707 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		return FALSE;
#line 3592 "rygel-av-transport.c"
	}
#line 710 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_data_->_tmp24_ = _data_->self->priv->controller;
#line 710 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_data_->_tmp25_ = _data_->collection;
#line 710 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	rygel_player_controller_set_playlist (_data_->_tmp24_, _data_->_tmp25_);
#line 712 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_data_->_tmp26_ = _data_->action;
#line 712 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	gupnp_service_action_return (_data_->_tmp26_);
#line 687 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_g_object_unref0 (_data_->collection);
#line 687 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_g_object_unref0 (_data_->message);
#line 687 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	block2_data_unref (_data_->_data2_);
#line 687 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_data_->_data2_ = NULL;
#line 687 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	if (_data_->_state_ == 0) {
#line 687 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 3616 "rygel-av-transport.c"
	} else {
#line 687 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 3620 "rygel-av-transport.c"
	}
#line 687 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_object_unref (_data_->_async_result);
#line 687 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	return FALSE;
#line 3626 "rygel-av-transport.c"
}


static gchar* rygel_av_transport_unescape (RygelAVTransport* self, const gchar* input) {
	gchar* result = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* _result_;
	const gchar* _tmp2_;
	gchar* _tmp3_ = NULL;
	const gchar* _tmp4_;
	gchar* _tmp5_ = NULL;
	const gchar* _tmp6_;
	gchar* _tmp7_ = NULL;
	const gchar* _tmp8_;
	gchar* _tmp9_ = NULL;
#line 715 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 715 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_return_val_if_fail (input != NULL, NULL);
#line 716 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp0_ = input;
#line 716 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp1_ = string_replace (_tmp0_, "&quot;", "\"");
#line 716 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_result_ = _tmp1_;
#line 717 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp2_ = _result_;
#line 717 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp3_ = string_replace (_tmp2_, "&lt;", "<");
#line 717 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_g_free0 (_result_);
#line 717 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_result_ = _tmp3_;
#line 718 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp4_ = _result_;
#line 718 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp5_ = string_replace (_tmp4_, "&gt;", ">");
#line 718 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_g_free0 (_result_);
#line 718 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_result_ = _tmp5_;
#line 719 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp6_ = _result_;
#line 719 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp7_ = string_replace (_tmp6_, "&apos;", "'");
#line 719 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_g_free0 (_result_);
#line 719 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_result_ = _tmp7_;
#line 720 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp8_ = _result_;
#line 720 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp9_ = string_replace (_tmp8_, "&amp;", "&");
#line 720 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_g_free0 (_result_);
#line 720 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_result_ = _tmp9_;
#line 722 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	result = _result_;
#line 722 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	return result;
#line 3689 "rygel-av-transport.c"
}


static gboolean rygel_av_transport_is_playlist (RygelAVTransport* self, const gchar* mime, const gchar* features) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	const gchar* _tmp2_;
	gboolean _tmp4_;
	gboolean _tmp7_;
#line 725 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 725 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_return_val_if_fail (mime != NULL, FALSE);
#line 726 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp2_ = mime;
#line 726 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	if (g_strcmp0 (_tmp2_, "text/xml") == 0) {
#line 3708 "rygel-av-transport.c"
		const gchar* _tmp3_;
#line 726 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_tmp3_ = features;
#line 726 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_tmp1_ = _tmp3_ != NULL;
#line 3714 "rygel-av-transport.c"
	} else {
#line 726 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_tmp1_ = FALSE;
#line 3718 "rygel-av-transport.c"
	}
#line 726 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp4_ = _tmp1_;
#line 726 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	if (_tmp4_) {
#line 3724 "rygel-av-transport.c"
		const gchar* _tmp5_;
		gboolean _tmp6_ = FALSE;
#line 727 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_tmp5_ = features;
#line 727 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_tmp6_ = g_str_has_prefix (_tmp5_, "DLNA.ORG_PN=DIDL_S");
#line 727 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_tmp0_ = _tmp6_;
#line 3733 "rygel-av-transport.c"
	} else {
#line 726 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_tmp0_ = FALSE;
#line 3737 "rygel-av-transport.c"
	}
#line 726 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp7_ = _tmp0_;
#line 726 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	result = _tmp7_;
#line 726 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	return result;
#line 3745 "rygel-av-transport.c"
}


RygelAVTransport* rygel_av_transport_construct (GType object_type) {
	RygelAVTransport * self = NULL;
#line 29 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	self = (RygelAVTransport*) g_object_new (object_type, NULL);
#line 29 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	return self;
#line 3755 "rygel-av-transport.c"
}


RygelAVTransport* rygel_av_transport_new (void) {
#line 29 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	return rygel_av_transport_construct (RYGEL_TYPE_AV_TRANSPORT);
#line 3762 "rygel-av-transport.c"
}


gchar* rygel_av_transport_get_track_metadata (RygelAVTransport* self) {
	gchar* result;
	RygelMediaPlayer* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
#line 43 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 43 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp0_ = self->priv->player;
#line 43 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp1_ = rygel_media_player_get_metadata (_tmp0_);
#line 43 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp2_ = _tmp1_;
#line 43 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp3_ = _tmp2_;
#line 43 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp4_ = _tmp3_;
#line 43 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	if (_tmp4_ == NULL) {
#line 3787 "rygel-av-transport.c"
		gchar* _tmp5_;
#line 43 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_tmp5_ = g_strdup ("");
#line 43 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_g_free0 (_tmp3_);
#line 43 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_tmp3_ = _tmp5_;
#line 3795 "rygel-av-transport.c"
	}
#line 43 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	result = _tmp3_;
#line 43 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	return result;
#line 3801 "rygel-av-transport.c"
}


void rygel_av_transport_set_track_metadata (RygelAVTransport* self, const gchar* value) {
	const gchar* _tmp0_;
	gboolean _tmp1_ = FALSE;
#line 45 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_return_if_fail (self != NULL);
#line 46 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp0_ = value;
#line 46 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp1_ = g_str_has_prefix (_tmp0_, "&lt;");
#line 46 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	if (_tmp1_) {
#line 3816 "rygel-av-transport.c"
		RygelMediaPlayer* _tmp2_;
		const gchar* _tmp3_;
		gchar* _tmp4_ = NULL;
		gchar* _tmp5_;
#line 47 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_tmp2_ = self->priv->player;
#line 47 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_tmp3_ = value;
#line 47 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_tmp4_ = rygel_av_transport_unescape (self, _tmp3_);
#line 47 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_tmp5_ = _tmp4_;
#line 47 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		rygel_media_player_set_metadata (_tmp2_, _tmp5_);
#line 47 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_g_free0 (_tmp5_);
#line 3833 "rygel-av-transport.c"
	} else {
		RygelMediaPlayer* _tmp6_;
		const gchar* _tmp7_;
#line 49 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_tmp6_ = self->priv->player;
#line 49 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_tmp7_ = value;
#line 49 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		rygel_media_player_set_metadata (_tmp6_, _tmp7_);
#line 3843 "rygel-av-transport.c"
	}
#line 45 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_object_notify ((GObject *) self, "track-metadata");
#line 3847 "rygel-av-transport.c"
}


gchar* rygel_av_transport_get_track_uri (RygelAVTransport* self) {
	gchar* result;
	RygelMediaPlayer* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gboolean _tmp4_;
#line 55 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 56 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp0_ = self->priv->player;
#line 56 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp1_ = rygel_media_player_get_uri (_tmp0_);
#line 56 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp2_ = _tmp1_;
#line 56 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp3_ = _tmp2_;
#line 56 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp4_ = _tmp3_ != NULL;
#line 56 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_g_free0 (_tmp3_);
#line 56 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	if (_tmp4_) {
#line 3874 "rygel-av-transport.c"
		RygelMediaPlayer* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_ = NULL;
		gchar* _tmp10_;
#line 57 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_tmp5_ = self->priv->player;
#line 57 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_tmp6_ = rygel_media_player_get_uri (_tmp5_);
#line 57 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_tmp7_ = _tmp6_;
#line 57 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_tmp8_ = _tmp7_;
#line 57 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_tmp9_ = g_markup_escape_text (_tmp8_, (gssize) (-1));
#line 57 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_tmp10_ = _tmp9_;
#line 57 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_g_free0 (_tmp8_);
#line 57 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		result = _tmp10_;
#line 57 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		return result;
#line 3899 "rygel-av-transport.c"
	} else {
		gchar* _tmp11_;
#line 59 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		_tmp11_ = g_strdup ("");
#line 59 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		result = _tmp11_;
#line 59 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		return result;
#line 3908 "rygel-av-transport.c"
	}
}


void rygel_av_transport_set_track_uri (RygelAVTransport* self, const gchar* value) {
	RygelMediaPlayer* _tmp0_;
	const gchar* _tmp1_;
#line 63 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_return_if_fail (self != NULL);
#line 64 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp0_ = self->priv->player;
#line 64 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp1_ = value;
#line 64 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	rygel_media_player_set_uri (_tmp0_, _tmp1_);
#line 63 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_object_notify ((GObject *) self, "track-uri");
#line 3926 "rygel-av-transport.c"
}


const gchar* rygel_av_transport_get_status (RygelAVTransport* self) {
	const gchar* result;
	const gchar* _tmp0_;
#line 70 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 71 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp0_ = self->priv->_status;
#line 71 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	result = _tmp0_;
#line 71 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	return result;
#line 3941 "rygel-av-transport.c"
}


void rygel_av_transport_set_status (RygelAVTransport* self, const gchar* value) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
	RygelChangeLog* _tmp2_;
	const gchar* _tmp3_;
#line 74 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_return_if_fail (self != NULL);
#line 75 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp0_ = value;
#line 75 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 75 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_g_free0 (self->priv->_status);
#line 75 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	self->priv->_status = _tmp1_;
#line 77 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp2_ = self->priv->changelog;
#line 77 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp3_ = self->priv->_status;
#line 77 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	rygel_change_log_log (_tmp2_, "TransportStatus", _tmp3_);
#line 74 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_object_notify ((GObject *) self, "status");
#line 3968 "rygel-av-transport.c"
}


gchar* rygel_av_transport_get_speed (RygelAVTransport* self) {
	gchar* result;
	RygelMediaPlayer* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
#line 82 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 83 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp0_ = self->priv->player;
#line 83 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp1_ = rygel_media_player_get_playback_speed (_tmp0_);
#line 83 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp2_ = _tmp1_;
#line 83 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	result = _tmp2_;
#line 83 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	return result;
#line 3989 "rygel-av-transport.c"
}


void rygel_av_transport_set_speed (RygelAVTransport* self, const gchar* value) {
	RygelMediaPlayer* _tmp0_;
	const gchar* _tmp1_;
	RygelChangeLog* _tmp2_;
	RygelMediaPlayer* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
#line 86 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_return_if_fail (self != NULL);
#line 87 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp0_ = self->priv->player;
#line 87 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp1_ = value;
#line 87 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	rygel_media_player_set_playback_speed (_tmp0_, _tmp1_);
#line 89 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp2_ = self->priv->changelog;
#line 89 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp3_ = self->priv->player;
#line 89 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp4_ = rygel_media_player_get_playback_speed (_tmp3_);
#line 89 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp5_ = _tmp4_;
#line 89 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp6_ = _tmp5_;
#line 89 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	rygel_change_log_log (_tmp2_, "TransportPlaySpeed", _tmp6_);
#line 89 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_g_free0 (_tmp6_);
#line 86 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_object_notify ((GObject *) self, "speed");
#line 4025 "rygel-av-transport.c"
}


const gchar* rygel_av_transport_get_mode (RygelAVTransport* self) {
	const gchar* result;
	const gchar* _tmp0_;
#line 95 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 96 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp0_ = self->priv->_mode;
#line 96 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	result = _tmp0_;
#line 96 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	return result;
#line 4040 "rygel-av-transport.c"
}


void rygel_av_transport_set_mode (RygelAVTransport* self, const gchar* value) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
	RygelChangeLog* _tmp2_;
	const gchar* _tmp3_;
#line 99 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_return_if_fail (self != NULL);
#line 100 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp0_ = value;
#line 100 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 100 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_g_free0 (self->priv->_mode);
#line 100 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	self->priv->_mode = _tmp1_;
#line 102 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp2_ = self->priv->changelog;
#line 102 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp3_ = self->priv->_mode;
#line 102 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	rygel_change_log_log (_tmp2_, "CurrentPlayMode", _tmp3_);
#line 99 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_object_notify ((GObject *) self, "mode");
#line 4067 "rygel-av-transport.c"
}


static void rygel_av_transport_class_init (RygelAVTransportClass * klass) {
#line 29 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	rygel_av_transport_parent_class = g_type_class_peek_parent (klass);
#line 29 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_type_class_add_private (klass, sizeof (RygelAVTransportPrivate));
#line 29 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	G_OBJECT_CLASS (klass)->constructed = rygel_av_transport_real_constructed;
#line 29 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_rygel_av_transport_get_property;
#line 29 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_rygel_av_transport_set_property;
#line 29 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	G_OBJECT_CLASS (klass)->finalize = rygel_av_transport_finalize;
#line 29 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_AV_TRANSPORT_TRACK_METADATA, g_param_spec_string ("track-metadata", "track-metadata", "track-metadata", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 29 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_AV_TRANSPORT_TRACK_URI, g_param_spec_string ("track-uri", "track-uri", "track-uri", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 29 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_AV_TRANSPORT_STATUS, g_param_spec_string ("status", "status", "status", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 29 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_AV_TRANSPORT_SPEED, g_param_spec_string ("speed", "speed", "speed", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 29 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_AV_TRANSPORT_MODE, g_param_spec_string ("mode", "mode", "mode", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 4094 "rygel-av-transport.c"
}


static void rygel_av_transport_instance_init (RygelAVTransport * self) {
	gchar* _tmp0_;
	gchar* _tmp1_;
#line 29 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	self->priv = RYGEL_AV_TRANSPORT_GET_PRIVATE (self);
#line 68 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp0_ = g_strdup ("OK");
#line 68 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	self->priv->_status = _tmp0_;
#line 93 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_tmp1_ = g_strdup ("NORMAL");
#line 93 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	self->priv->_mode = _tmp1_;
#line 4111 "rygel-av-transport.c"
}


static void rygel_av_transport_finalize (GObject* obj) {
	RygelAVTransport * self;
#line 29 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_AV_TRANSPORT, RygelAVTransport);
#line 39 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_g_object_unref0 (self->priv->session);
#line 40 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_g_free0 (self->priv->protocol_info);
#line 68 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_g_free0 (self->priv->_status);
#line 93 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_g_free0 (self->priv->_mode);
#line 106 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_g_object_unref0 (self->priv->changelog);
#line 107 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_g_object_unref0 (self->priv->player);
#line 108 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	_g_object_unref0 (self->priv->controller);
#line 29 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	G_OBJECT_CLASS (rygel_av_transport_parent_class)->finalize (obj);
#line 4135 "rygel-av-transport.c"
}


GType rygel_av_transport_get_type (void) {
	static volatile gsize rygel_av_transport_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_av_transport_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelAVTransportClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_av_transport_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelAVTransport), 0, (GInstanceInitFunc) rygel_av_transport_instance_init, NULL };
		GType rygel_av_transport_type_id;
		rygel_av_transport_type_id = g_type_register_static (gupnp_service_get_type (), "RygelAVTransport", &g_define_type_info, 0);
		g_once_init_leave (&rygel_av_transport_type_id__volatile, rygel_av_transport_type_id);
	}
	return rygel_av_transport_type_id__volatile;
}


static void _vala_rygel_av_transport_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	RygelAVTransport * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_AV_TRANSPORT, RygelAVTransport);
#line 29 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	switch (property_id) {
#line 29 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		case RYGEL_AV_TRANSPORT_TRACK_METADATA:
#line 29 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		g_value_take_string (value, rygel_av_transport_get_track_metadata (self));
#line 29 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		break;
#line 29 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		case RYGEL_AV_TRANSPORT_TRACK_URI:
#line 29 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		g_value_take_string (value, rygel_av_transport_get_track_uri (self));
#line 29 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		break;
#line 29 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		case RYGEL_AV_TRANSPORT_STATUS:
#line 29 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		g_value_set_string (value, rygel_av_transport_get_status (self));
#line 29 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		break;
#line 29 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		case RYGEL_AV_TRANSPORT_SPEED:
#line 29 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		g_value_take_string (value, rygel_av_transport_get_speed (self));
#line 29 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		break;
#line 29 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		case RYGEL_AV_TRANSPORT_MODE:
#line 29 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		g_value_set_string (value, rygel_av_transport_get_mode (self));
#line 29 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		break;
#line 4186 "rygel-av-transport.c"
		default:
#line 29 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 29 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		break;
#line 4192 "rygel-av-transport.c"
	}
}


static void _vala_rygel_av_transport_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	RygelAVTransport * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_AV_TRANSPORT, RygelAVTransport);
#line 29 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
	switch (property_id) {
#line 29 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		case RYGEL_AV_TRANSPORT_TRACK_METADATA:
#line 29 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		rygel_av_transport_set_track_metadata (self, g_value_get_string (value));
#line 29 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		break;
#line 29 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		case RYGEL_AV_TRANSPORT_TRACK_URI:
#line 29 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		rygel_av_transport_set_track_uri (self, g_value_get_string (value));
#line 29 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		break;
#line 29 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		case RYGEL_AV_TRANSPORT_STATUS:
#line 29 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		rygel_av_transport_set_status (self, g_value_get_string (value));
#line 29 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		break;
#line 29 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		case RYGEL_AV_TRANSPORT_SPEED:
#line 29 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		rygel_av_transport_set_speed (self, g_value_get_string (value));
#line 29 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		break;
#line 29 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		case RYGEL_AV_TRANSPORT_MODE:
#line 29 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		rygel_av_transport_set_mode (self, g_value_get_string (value));
#line 29 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		break;
#line 4232 "rygel-av-transport.c"
		default:
#line 29 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 29 "/home/jens/Source/rygel/src/librygel-renderer/rygel-av-transport.vala"
		break;
#line 4238 "rygel-av-transport.c"
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



