/* rygel-media-container.c generated by valac 0.22.0, the Vala compiler
 * generated from rygel-media-container.vala, do not modify */

/*
 * Copyright (C) 2008 Zeeshan Ali <zeenix@gmail.com>.
 * Copyright (C) 2010 MediaNet Inh.
 * Copyright (C) 2010 Nokia Corporation.
 * Copyright (C) 2012 Intel Corporation.
 *
 * Authors: Zeeshan Ali <zeenix@gmail.com>
 *          Sunil Mohan Adapa <sunil@medhas.org>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <libgupnp-av/gupnp-av.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <gio/gio.h>
#include <rygel-core.h>


#define RYGEL_TYPE_OBJECT_EVENT_TYPE (rygel_object_event_type_get_type ())

#define RYGEL_TYPE_MEDIA_OBJECT (rygel_media_object_get_type ())
#define RYGEL_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObject))
#define RYGEL_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))
#define RYGEL_IS_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_IS_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_MEDIA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))

typedef struct _RygelMediaObject RygelMediaObject;
typedef struct _RygelMediaObjectClass RygelMediaObjectClass;
typedef struct _RygelMediaObjectPrivate RygelMediaObjectPrivate;

#define RYGEL_TYPE_SERIALIZER (rygel_serializer_get_type ())
#define RYGEL_SERIALIZER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_SERIALIZER, RygelSerializer))
#define RYGEL_SERIALIZER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_SERIALIZER, RygelSerializerClass))
#define RYGEL_IS_SERIALIZER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_SERIALIZER))
#define RYGEL_IS_SERIALIZER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_SERIALIZER))
#define RYGEL_SERIALIZER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_SERIALIZER, RygelSerializerClass))

typedef struct _RygelSerializer RygelSerializer;
typedef struct _RygelSerializerClass RygelSerializerClass;

#define RYGEL_TYPE_TRANSCODE_MANAGER (rygel_transcode_manager_get_type ())
#define RYGEL_TRANSCODE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManager))
#define RYGEL_TRANSCODE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManagerClass))
#define RYGEL_IS_TRANSCODE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_TRANSCODE_MANAGER))
#define RYGEL_IS_TRANSCODE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_TRANSCODE_MANAGER))
#define RYGEL_TRANSCODE_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManagerClass))

typedef struct _RygelTranscodeManager RygelTranscodeManager;
typedef struct _RygelTranscodeManagerClass RygelTranscodeManagerClass;

#define RYGEL_TYPE_HTTP_SERVER (rygel_http_server_get_type ())
#define RYGEL_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServer))
#define RYGEL_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))
#define RYGEL_IS_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_IS_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_HTTP_SERVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))

typedef struct _RygelHTTPServer RygelHTTPServer;
typedef struct _RygelHTTPServerClass RygelHTTPServerClass;

#define RYGEL_TYPE_MEDIA_CONTAINER (rygel_media_container_get_type ())
#define RYGEL_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainer))
#define RYGEL_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))
#define RYGEL_IS_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_IS_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_MEDIA_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))

typedef struct _RygelMediaContainer RygelMediaContainer;
typedef struct _RygelMediaContainerClass RygelMediaContainerClass;
typedef struct _RygelMediaContainerPrivate RygelMediaContainerPrivate;

#define RYGEL_TYPE_MEDIA_OBJECTS (rygel_media_objects_get_type ())
#define RYGEL_MEDIA_OBJECTS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_OBJECTS, RygelMediaObjects))
#define RYGEL_MEDIA_OBJECTS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_OBJECTS, RygelMediaObjectsClass))
#define RYGEL_IS_MEDIA_OBJECTS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_OBJECTS))
#define RYGEL_IS_MEDIA_OBJECTS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_OBJECTS))
#define RYGEL_MEDIA_OBJECTS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_OBJECTS, RygelMediaObjectsClass))

typedef struct _RygelMediaObjects RygelMediaObjects;
typedef struct _RygelMediaObjectsClass RygelMediaObjectsClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define RYGEL_TYPE_SEARCHABLE_CONTAINER (rygel_searchable_container_get_type ())
#define RYGEL_SEARCHABLE_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_SEARCHABLE_CONTAINER, RygelSearchableContainer))
#define RYGEL_IS_SEARCHABLE_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_SEARCHABLE_CONTAINER))
#define RYGEL_SEARCHABLE_CONTAINER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_SEARCHABLE_CONTAINER, RygelSearchableContainerIface))

typedef struct _RygelSearchableContainer RygelSearchableContainer;
typedef struct _RygelSearchableContainerIface RygelSearchableContainerIface;

#define RYGEL_TYPE_SEARCH_EXPRESSION (rygel_search_expression_get_type ())
#define RYGEL_SEARCH_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_SEARCH_EXPRESSION, RygelSearchExpression))
#define RYGEL_SEARCH_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_SEARCH_EXPRESSION, RygelSearchExpressionClass))
#define RYGEL_IS_SEARCH_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_SEARCH_EXPRESSION))
#define RYGEL_IS_SEARCH_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_SEARCH_EXPRESSION))
#define RYGEL_SEARCH_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_SEARCH_EXPRESSION, RygelSearchExpressionClass))

typedef struct _RygelSearchExpression RygelSearchExpression;
typedef struct _RygelSearchExpressionClass RygelSearchExpressionClass;

#define RYGEL_TYPE_TRACKABLE_CONTAINER (rygel_trackable_container_get_type ())
#define RYGEL_TRACKABLE_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_TRACKABLE_CONTAINER, RygelTrackableContainer))
#define RYGEL_IS_TRACKABLE_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_TRACKABLE_CONTAINER))
#define RYGEL_TRACKABLE_CONTAINER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_TRACKABLE_CONTAINER, RygelTrackableContainerIface))

typedef struct _RygelTrackableContainer RygelTrackableContainer;
typedef struct _RygelTrackableContainerIface RygelTrackableContainerIface;

#define RYGEL_TYPE_WRITABLE_CONTAINER (rygel_writable_container_get_type ())
#define RYGEL_WRITABLE_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_WRITABLE_CONTAINER, RygelWritableContainer))
#define RYGEL_IS_WRITABLE_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_WRITABLE_CONTAINER))
#define RYGEL_WRITABLE_CONTAINER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_WRITABLE_CONTAINER, RygelWritableContainerIface))

typedef struct _RygelWritableContainer RygelWritableContainer;
typedef struct _RygelWritableContainerIface RygelWritableContainerIface;

#define RYGEL_TYPE_MEDIA_ITEM (rygel_media_item_get_type ())
#define RYGEL_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItem))
#define RYGEL_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))
#define RYGEL_IS_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_IS_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_MEDIA_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))

typedef struct _RygelMediaItem RygelMediaItem;
typedef struct _RygelMediaItemClass RygelMediaItemClass;

#define RYGEL_TYPE_HTTP_ITEM_URI (rygel_http_item_uri_get_type ())
#define RYGEL_HTTP_ITEM_URI(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_ITEM_URI, RygelHTTPItemURI))
#define RYGEL_HTTP_ITEM_URI_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_ITEM_URI, RygelHTTPItemURIClass))
#define RYGEL_IS_HTTP_ITEM_URI(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_ITEM_URI))
#define RYGEL_IS_HTTP_ITEM_URI_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_ITEM_URI))
#define RYGEL_HTTP_ITEM_URI_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_ITEM_URI, RygelHTTPItemURIClass))

typedef struct _RygelHTTPItemURI RygelHTTPItemURI;
typedef struct _RygelHTTPItemURIClass RygelHTTPItemURIClass;

#define RYGEL_TYPE_RELATIONAL_EXPRESSION (rygel_relational_expression_get_type ())
#define RYGEL_RELATIONAL_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_RELATIONAL_EXPRESSION, RygelRelationalExpression))
#define RYGEL_RELATIONAL_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_RELATIONAL_EXPRESSION, RygelRelationalExpressionClass))
#define RYGEL_IS_RELATIONAL_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_RELATIONAL_EXPRESSION))
#define RYGEL_IS_RELATIONAL_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_RELATIONAL_EXPRESSION))
#define RYGEL_RELATIONAL_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_RELATIONAL_EXPRESSION, RygelRelationalExpressionClass))

typedef struct _RygelRelationalExpression RygelRelationalExpression;
typedef struct _RygelRelationalExpressionClass RygelRelationalExpressionClass;
typedef struct _RygelSearchExpressionPrivate RygelSearchExpressionPrivate;
#define _rygel_search_expression_unref0(var) ((var == NULL) ? NULL : (var = (rygel_search_expression_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define RYGEL_TYPE_UPDATABLE_OBJECT (rygel_updatable_object_get_type ())
#define RYGEL_UPDATABLE_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_UPDATABLE_OBJECT, RygelUpdatableObject))
#define RYGEL_IS_UPDATABLE_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_UPDATABLE_OBJECT))
#define RYGEL_UPDATABLE_OBJECT_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_UPDATABLE_OBJECT, RygelUpdatableObjectIface))

typedef struct _RygelUpdatableObject RygelUpdatableObject;
typedef struct _RygelUpdatableObjectIface RygelUpdatableObjectIface;

typedef enum  {
	RYGEL_OBJECT_EVENT_TYPE_ADDED = 0,
	RYGEL_OBJECT_EVENT_TYPE_MODIFIED = 1,
	RYGEL_OBJECT_EVENT_TYPE_DELETED = 2
} RygelObjectEventType;

struct _RygelMediaObject {
	GObject parent_instance;
	RygelMediaObjectPrivate * priv;
	GeeArrayList* uris;
	RygelMediaContainer* parent_ptr;
};

struct _RygelMediaObjectClass {
	GObjectClass parent_class;
	GUPnPDIDLLiteObject* (*serialize) (RygelMediaObject* self, RygelSerializer* serializer, RygelHTTPServer* http_server, GError** error);
	void (*apply_didl_lite) (RygelMediaObject* self, GUPnPDIDLLiteObject* didl_object);
	gint (*compare_by_property) (RygelMediaObject* self, RygelMediaObject* media_object, const gchar* property);
	GUPnPDIDLLiteResource* (*add_resource) (RygelMediaObject* self, GUPnPDIDLLiteObject* object, const gchar* uri, const gchar* protocol, const gchar* import_uri, GError** error);
	GUPnPOCMFlags (*get_ocm_flags) (RygelMediaObject* self);
};

struct _RygelMediaContainer {
	RygelMediaObject parent_instance;
	RygelMediaContainerPrivate * priv;
	guint32 update_id;
	gint64 storage_used;
	gint64 total_deleted_child_count;
};

struct _RygelMediaContainerClass {
	RygelMediaObjectClass parent_class;
	void (*get_children) (RygelMediaContainer* self, guint offset, guint max_count, const gchar* sort_criteria, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	RygelMediaObjects* (*get_children_finish) (RygelMediaContainer* self, GAsyncResult* _res_, GError** error);
	void (*find_object) (RygelMediaContainer* self, const gchar* id, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	RygelMediaObject* (*find_object_finish) (RygelMediaContainer* self, GAsyncResult* _res_, GError** error);
};

struct _RygelMediaContainerPrivate {
	gint _child_count;
	gint _empty_child_count;
	gboolean _create_mode_enabled;
	gchar* _sort_criteria;
};

struct _RygelSearchableContainerIface {
	GTypeInterface parent_iface;
	void (*search) (RygelSearchableContainer* self, RygelSearchExpression* expression, guint offset, guint max_count, const gchar* sort_criteria, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	RygelMediaObjects* (*search_finish) (RygelSearchableContainer* self, GAsyncResult* _res_, guint* total_matches, GError** error);
	GeeArrayList* (*get_search_classes) (RygelSearchableContainer* self);
	void (*set_search_classes) (RygelSearchableContainer* self, GeeArrayList* value);
};

struct _RygelTrackableContainerIface {
	GTypeInterface parent_iface;
	void (*add_child) (RygelTrackableContainer* self, RygelMediaObject* object, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*add_child_finish) (RygelTrackableContainer* self, GAsyncResult* _res_);
	void (*remove_child) (RygelTrackableContainer* self, RygelMediaObject* object, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*remove_child_finish) (RygelTrackableContainer* self, GAsyncResult* _res_);
	gchar* (*get_service_reset_token) (RygelTrackableContainer* self);
	void (*set_service_reset_token) (RygelTrackableContainer* self, const gchar* token);
	guint32 (*get_system_update_id) (RygelTrackableContainer* self);
};

struct _RygelWritableContainerIface {
	GTypeInterface parent_iface;
	void (*add_item) (RygelWritableContainer* self, RygelMediaItem* item, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*add_item_finish) (RygelWritableContainer* self, GAsyncResult* _res_, GError** error);
	void (*add_container) (RygelWritableContainer* self, RygelMediaContainer* container, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*add_container_finish) (RygelWritableContainer* self, GAsyncResult* _res_, GError** error);
	void (*add_reference) (RygelWritableContainer* self, RygelMediaObject* object, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	gchar* (*add_reference_finish) (RygelWritableContainer* self, GAsyncResult* _res_, GError** error);
	void (*remove_item) (RygelWritableContainer* self, const gchar* id, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*remove_item_finish) (RygelWritableContainer* self, GAsyncResult* _res_, GError** error);
	void (*remove_container) (RygelWritableContainer* self, const gchar* id, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*remove_container_finish) (RygelWritableContainer* self, GAsyncResult* _res_, GError** error);
	GeeArrayList* (*get_create_classes) (RygelWritableContainer* self);
	void (*set_create_classes) (RygelWritableContainer* self, GeeArrayList* value);
};

struct _RygelSearchExpression {
	GTypeInstance parent_instance;
	volatile int ref_count;
	RygelSearchExpressionPrivate * priv;
	gpointer op;
	gpointer operand1;
	gpointer operand2;
};

struct _RygelSearchExpressionClass {
	GTypeClass parent_class;
	void (*finalize) (RygelSearchExpression *self);
	gboolean (*satisfied_by) (RygelSearchExpression* self, RygelMediaObject* media_object);
	gchar* (*to_string) (RygelSearchExpression* self);
};

struct _RygelUpdatableObjectIface {
	GTypeInterface parent_iface;
	void (*commit) (RygelUpdatableObject* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*commit_finish) (RygelUpdatableObject* self, GAsyncResult* _res_, GError** error);
};


static gpointer rygel_media_container_parent_class = NULL;

GType rygel_object_event_type_get_type (void) G_GNUC_CONST;
GType rygel_media_object_get_type (void) G_GNUC_CONST;
GType rygel_serializer_get_type (void) G_GNUC_CONST;
GType rygel_transcode_manager_get_type (void) G_GNUC_CONST;
GType rygel_http_server_get_type (void) G_GNUC_CONST;
GType rygel_media_container_get_type (void) G_GNUC_CONST;
GType rygel_media_objects_get_type (void) G_GNUC_CONST;
#define RYGEL_MEDIA_CONTAINER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerPrivate))
enum  {
	RYGEL_MEDIA_CONTAINER_DUMMY_PROPERTY,
	RYGEL_MEDIA_CONTAINER_CHILD_COUNT,
	RYGEL_MEDIA_CONTAINER_EMPTY_CHILD_COUNT,
	RYGEL_MEDIA_CONTAINER_ALL_CHILD_COUNT,
	RYGEL_MEDIA_CONTAINER_CREATE_MODE_ENABLED,
	RYGEL_MEDIA_CONTAINER_SORT_CRITERIA,
	RYGEL_MEDIA_CONTAINER_OCM_FLAGS
};
#define RYGEL_MEDIA_CONTAINER_DEFAULT_SORT_CRITERIA "+upnp:class,+dc:title"
#define RYGEL_MEDIA_CONTAINER_ANY "DLNA.ORG_AnyContainer"
#define RYGEL_MEDIA_CONTAINER_UPNP_CLASS "object.container"
#define RYGEL_MEDIA_CONTAINER_STORAGE_FOLDER RYGEL_MEDIA_CONTAINER_UPNP_CLASS ".storageFolder"
#define RYGEL_MEDIA_CONTAINER_MUSIC_ALBUM RYGEL_MEDIA_CONTAINER_UPNP_CLASS ".album.musicAlbum"
#define RYGEL_MEDIA_CONTAINER_MUSIC_ARTIST RYGEL_MEDIA_CONTAINER_UPNP_CLASS ".person.musicArtist"
#define RYGEL_MEDIA_CONTAINER_MUSIC_GENRE RYGEL_MEDIA_CONTAINER_UPNP_CLASS ".genre.musicGenre"
#define RYGEL_MEDIA_CONTAINER_PLAYLIST RYGEL_MEDIA_CONTAINER_UPNP_CLASS ".playlistContainer"
#define RYGEL_MEDIA_CONTAINER_ALBUM_SORT_CRITERIA "+upnp:class," "+rygel:originalVolumeNumber," "+upnp:originalTrackNumber," "+dc:title"
RygelMediaContainer* rygel_media_container_construct (GType object_type, const gchar* id, RygelMediaContainer* parent, const gchar* title, gint child_count);
RygelMediaContainer* rygel_media_container_construct_root (GType object_type, const gchar* title, gint child_count);
static void rygel_media_container_real_constructed (GObject* base);
void rygel_media_container_set_empty_child_count (RygelMediaContainer* self, gint value);
void rygel_media_object_set_upnp_class (RygelMediaObject* self, const gchar* value);
void rygel_media_container_set_create_mode_enabled (RygelMediaContainer* self, gboolean value);
static void rygel_media_container_on_container_updated (RygelMediaContainer* self, RygelMediaContainer* container, RygelMediaContainer* updated_container, RygelMediaObject* object, RygelObjectEventType event_type, gboolean sub_tree_update);
static void _rygel_media_container_on_container_updated_rygel_media_container_container_updated (RygelMediaContainer* _sender, RygelMediaContainer* container, RygelMediaObject* object, RygelObjectEventType event_type, gboolean sub_tree_update, gpointer self);
static void rygel_media_container_on_sub_tree_updates_finished (RygelMediaContainer* self, RygelMediaContainer* container, RygelMediaObject* sub_tree_root);
static void _rygel_media_container_on_sub_tree_updates_finished_rygel_media_container_sub_tree_updates_finished (RygelMediaContainer* _sender, RygelMediaObject* sub_tree_root, gpointer self);
void rygel_media_container_get_children (RygelMediaContainer* self, guint offset, guint max_count, const gchar* sort_criteria, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
RygelMediaObjects* rygel_media_container_get_children_finish (RygelMediaContainer* self, GAsyncResult* _res_, GError** error);
void rygel_media_container_find_object (RygelMediaContainer* self, const gchar* id, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
RygelMediaObject* rygel_media_container_find_object_finish (RygelMediaContainer* self, GAsyncResult* _res_, GError** error);
void rygel_media_container_updated (RygelMediaContainer* self, RygelMediaObject* object, RygelObjectEventType event_type, gboolean sub_tree_update);
static GUPnPDIDLLiteObject* rygel_media_container_real_serialize (RygelMediaObject* base, RygelSerializer* serializer, RygelHTTPServer* http_server, GError** error);
GUPnPDIDLLiteContainer* rygel_serializer_add_container (RygelSerializer* self);
RygelMediaContainer* rygel_media_object_get_parent (RygelMediaObject* self);
const gchar* rygel_media_object_get_id (RygelMediaObject* self);
const gchar* rygel_media_object_get_title (RygelMediaObject* self);
gint rygel_media_container_get_child_count (RygelMediaContainer* self);
const gchar* rygel_media_object_get_upnp_class (RygelMediaObject* self);
gpointer rygel_search_expression_ref (gpointer instance);
void rygel_search_expression_unref (gpointer instance);
GParamSpec* rygel_param_spec_search_expression (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_value_set_search_expression (GValue* value, gpointer v_object);
void rygel_value_take_search_expression (GValue* value, gpointer v_object);
gpointer rygel_value_get_search_expression (const GValue* value);
GType rygel_search_expression_get_type (void) G_GNUC_CONST;
GType rygel_searchable_container_get_type (void) G_GNUC_CONST;
GType rygel_trackable_container_get_type (void) G_GNUC_CONST;
guint rygel_media_object_get_object_update_id (RygelMediaObject* self);
void rygel_searchable_container_serialize_search_parameters (RygelSearchableContainer* self, GUPnPDIDLLiteContainer* didl_container);
gboolean rygel_media_object_get_restricted (RygelMediaObject* self);
GUPnPOCMFlags rygel_media_object_get_ocm_flags (RygelMediaObject* self);
GType rygel_media_item_get_type (void) G_GNUC_CONST;
GType rygel_writable_container_get_type (void) G_GNUC_CONST;
GeeArrayList* rygel_writable_container_get_create_classes (RygelWritableContainer* self);
void rygel_media_container_add_resources (RygelMediaContainer* self, RygelHTTPServer* http_server, GUPnPDIDLLiteContainer* didl_container, GError** error);
GType rygel_http_item_uri_get_type (void) G_GNUC_CONST;
RygelHTTPItemURI* rygel_http_item_uri_new (RygelMediaObject* object, RygelHTTPServer* http_server, gint thumbnail_index, gint subtitle_index, const gchar* transcode_target, const gchar* playlist_format);
RygelHTTPItemURI* rygel_http_item_uri_construct (GType object_type, RygelMediaObject* object, RygelHTTPServer* http_server, gint thumbnail_index, gint subtitle_index, const gchar* transcode_target, const gchar* playlist_format);
void rygel_http_item_uri_set_extension (RygelHTTPItemURI* self, const gchar* value);
GUPnPDIDLLiteResource* rygel_media_object_add_resource (RygelMediaObject* self, GUPnPDIDLLiteObject* object, const gchar* uri, const gchar* protocol, const gchar* import_uri, GError** error);
gchar* rygel_http_item_uri_to_string (RygelHTTPItemURI* self);
gchar* rygel_transcode_manager_get_protocol (RygelTranscodeManager* self);
static GUPnPDIDLLiteResource* rygel_media_container_real_add_resource (RygelMediaObject* base, GUPnPDIDLLiteObject* didl_object, const gchar* uri, const gchar* protocol, const gchar* import_uri, GError** error);
void rygel_media_container_check_search_expression (RygelMediaContainer* self, RygelSearchExpression* expression);
GType rygel_relational_expression_get_type (void) G_GNUC_CONST;
void rygel_media_container_set_child_count (RygelMediaContainer* self, gint value);
gint rygel_media_container_get_empty_child_count (RygelMediaContainer* self);
gint rygel_media_container_get_all_child_count (RygelMediaContainer* self);
gboolean rygel_media_container_get_create_mode_enabled (RygelMediaContainer* self);
const gchar* rygel_media_container_get_sort_criteria (RygelMediaContainer* self);
void rygel_media_container_set_sort_criteria (RygelMediaContainer* self, const gchar* value);
GType rygel_updatable_object_get_type (void) G_GNUC_CONST;
static void g_cclosure_user_marshal_VOID__OBJECT_OBJECT_ENUM_BOOLEAN (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void rygel_media_container_finalize (GObject* obj);
static void _vala_rygel_media_container_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_rygel_media_container_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


GType rygel_object_event_type_get_type (void) {
	static volatile gsize rygel_object_event_type_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_object_event_type_type_id__volatile)) {
		static const GEnumValue values[] = {{RYGEL_OBJECT_EVENT_TYPE_ADDED, "RYGEL_OBJECT_EVENT_TYPE_ADDED", "added"}, {RYGEL_OBJECT_EVENT_TYPE_MODIFIED, "RYGEL_OBJECT_EVENT_TYPE_MODIFIED", "modified"}, {RYGEL_OBJECT_EVENT_TYPE_DELETED, "RYGEL_OBJECT_EVENT_TYPE_DELETED", "deleted"}, {0, NULL, NULL}};
		GType rygel_object_event_type_type_id;
		rygel_object_event_type_type_id = g_enum_register_static ("RygelObjectEventType", values);
		g_once_init_leave (&rygel_object_event_type_type_id__volatile, rygel_object_event_type_type_id);
	}
	return rygel_object_event_type_type_id__volatile;
}


/**
     * Create a media container with the specified details.
     *
     * @param id See the id property of the #RygelMediaObject class.
     * @param parent The parent container, if any.
     * @param title See the title property of the #RygelMediaObject class.
     * @param child_count The initially-known number of child items.
     */
RygelMediaContainer* rygel_media_container_construct (GType object_type, const gchar* id, RygelMediaContainer* parent, const gchar* title, gint child_count) {
	RygelMediaContainer * self = NULL;
	const gchar* _tmp0_ = NULL;
	RygelMediaContainer* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gint _tmp3_ = 0;
#line 173 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
	g_return_val_if_fail (id != NULL, NULL);
#line 173 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
	g_return_val_if_fail (title != NULL, NULL);
#line 177 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
	_tmp0_ = id;
#line 177 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
	_tmp1_ = parent;
#line 177 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
	_tmp2_ = title;
#line 177 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
	_tmp3_ = child_count;
#line 177 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
	self = (RygelMediaContainer*) g_object_new (object_type, "id", _tmp0_, "parent", _tmp1_, "title", _tmp2_, "child-count", _tmp3_, NULL);
#line 173 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
	return self;
#line 417 "rygel-media-container.c"
}


/**
     * Create a root media container with the specified details,
     * with no parent container, and with an appropriate ID.
     *
     * @param title See the title property of the #RygelMediaObject.
     * @param child_count The initially-known number of child items.
     */
RygelMediaContainer* rygel_media_container_construct_root (GType object_type, const gchar* title, gint child_count) {
	RygelMediaContainer * self = NULL;
	const gchar* _tmp0_ = NULL;
	gint _tmp1_ = 0;
#line 190 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
	g_return_val_if_fail (title != NULL, NULL);
#line 192 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
	_tmp0_ = title;
#line 192 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
	_tmp1_ = child_count;
#line 192 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
	self = (RygelMediaContainer*) g_object_new (object_type, "id", "0", "parent", NULL, "title", _tmp0_, "child-count", _tmp1_, NULL);
#line 190 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
	return self;
#line 442 "rygel-media-container.c"
}


static void _rygel_media_container_on_container_updated_rygel_media_container_container_updated (RygelMediaContainer* _sender, RygelMediaContainer* container, RygelMediaObject* object, RygelObjectEventType event_type, gboolean sub_tree_update, gpointer self) {
#line 208 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
	rygel_media_container_on_container_updated (self, _sender, container, object, event_type, sub_tree_update);
#line 449 "rygel-media-container.c"
}


static void _rygel_media_container_on_sub_tree_updates_finished_rygel_media_container_sub_tree_updates_finished (RygelMediaContainer* _sender, RygelMediaObject* sub_tree_root, gpointer self) {
#line 209 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
	rygel_media_container_on_sub_tree_updates_finished (self, _sender, sub_tree_root);
#line 456 "rygel-media-container.c"
}


static void rygel_media_container_real_constructed (GObject* base) {
	RygelMediaContainer * self;
#line 198 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
	self = (RygelMediaContainer*) base;
#line 199 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
	G_OBJECT_CLASS (rygel_media_container_parent_class)->constructed ((GObject*) G_TYPE_CHECK_INSTANCE_CAST (self, RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObject));
#line 201 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
	rygel_media_container_set_empty_child_count (self, 0);
#line 202 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
	self->update_id = (guint32) 0;
#line 203 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
	self->storage_used = (gint64) (-1);
#line 204 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
	self->total_deleted_child_count = (gint64) 0;
#line 205 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
	rygel_media_object_set_upnp_class ((RygelMediaObject*) self, RYGEL_MEDIA_CONTAINER_UPNP_CLASS);
#line 206 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
	rygel_media_container_set_create_mode_enabled (self, FALSE);
#line 208 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
	g_signal_connect_object (self, "container-updated", (GCallback) _rygel_media_container_on_container_updated_rygel_media_container_container_updated, self, 0);
#line 209 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
	g_signal_connect_object (self, "sub-tree-updates-finished", (GCallback) _rygel_media_container_on_sub_tree_updates_finished_rygel_media_container_sub_tree_updates_finished, self, 0);
#line 482 "rygel-media-container.c"
}


void rygel_media_container_get_children (RygelMediaContainer* self, guint offset, guint max_count, const gchar* sort_criteria, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
#line 62 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
	RYGEL_MEDIA_CONTAINER_GET_CLASS (self)->get_children (self, offset, max_count, sort_criteria, cancellable, _callback_, _user_data_);
#line 489 "rygel-media-container.c"
}


RygelMediaObjects* rygel_media_container_get_children_finish (RygelMediaContainer* self, GAsyncResult* _res_, GError** error) {
#line 62 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
	return RYGEL_MEDIA_CONTAINER_GET_CLASS (self)->get_children_finish (self, _res_, error);
#line 496 "rygel-media-container.c"
}


void rygel_media_container_find_object (RygelMediaContainer* self, const gchar* id, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
#line 62 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
	RYGEL_MEDIA_CONTAINER_GET_CLASS (self)->find_object (self, id, cancellable, _callback_, _user_data_);
#line 503 "rygel-media-container.c"
}


RygelMediaObject* rygel_media_container_find_object_finish (RygelMediaContainer* self, GAsyncResult* _res_, GError** error) {
#line 62 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
	return RYGEL_MEDIA_CONTAINER_GET_CLASS (self)->find_object_finish (self, _res_, error);
#line 510 "rygel-media-container.c"
}


/**
     * This method should be called each time this container is updated.
     *
     * For instance, this should be called if there are metadata changes
     * for this container, if items under it are removed or added, if
     * there are metadata changes to items under it, etc.
     *
     * If sub_tree_update is true then the caller should later emit the 
     * sub_tree_updates_finished signal on the root container of the sub-tree
     * that was updated.
     *
     * It will eventually result in the server emitting a UPnP LastChange event,
     * though that may be for a batch of these calls.
     *
     * See the #RygelMediaContainer::container_updated signal.
     *
     * @param object The object that has changed, or null to mean the container itself.
     * @param event_type This describes what actually happened to the object.
     * @param sub_tree_update Whether the modification is part of a sub-tree update.
     */
void rygel_media_container_updated (RygelMediaContainer* self, RygelMediaObject* object, RygelObjectEventType event_type, gboolean sub_tree_update) {
	RygelMediaObject* _tmp0_ = NULL;
	RygelMediaObject* _tmp1_ = NULL;
	RygelMediaObject* _tmp3_ = NULL;
	RygelObjectEventType _tmp4_ = 0;
	gboolean _tmp5_ = FALSE;
#line 260 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
	g_return_if_fail (self != NULL);
#line 265 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
	_tmp1_ = object;
#line 265 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
	if (_tmp1_ != NULL) {
#line 546 "rygel-media-container.c"
		RygelMediaObject* _tmp2_ = NULL;
#line 265 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
		_tmp2_ = object;
#line 265 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
		_tmp0_ = _tmp2_;
#line 552 "rygel-media-container.c"
	} else {
#line 265 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
		_tmp0_ = (RygelMediaObject*) self;
#line 556 "rygel-media-container.c"
	}
#line 264 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
	_tmp3_ = _tmp0_;
#line 264 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
	_tmp4_ = event_type;
#line 264 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
	_tmp5_ = sub_tree_update;
#line 264 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
	g_signal_emit_by_name (self, "container-updated", self, _tmp3_, _tmp4_, _tmp5_);
#line 566 "rygel-media-container.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 310 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
	return self ? g_object_ref (self) : NULL;
#line 573 "rygel-media-container.c"
}


static GUPnPDIDLLiteObject* rygel_media_container_real_serialize (RygelMediaObject* base, RygelSerializer* serializer, RygelHTTPServer* http_server, GError** error) {
	RygelMediaContainer * self;
	GUPnPDIDLLiteObject* result = NULL;
	GUPnPDIDLLiteContainer* didl_container = NULL;
	RygelSerializer* _tmp0_ = NULL;
	GUPnPDIDLLiteContainer* _tmp1_ = NULL;
	GUPnPDIDLLiteContainer* _tmp2_ = NULL;
	RygelMediaContainer* _tmp3_ = NULL;
	RygelMediaContainer* _tmp4_ = NULL;
	GUPnPDIDLLiteContainer* _tmp11_ = NULL;
	const gchar* _tmp12_ = NULL;
	const gchar* _tmp13_ = NULL;
	GUPnPDIDLLiteContainer* _tmp14_ = NULL;
	const gchar* _tmp15_ = NULL;
	const gchar* _tmp16_ = NULL;
	GUPnPDIDLLiteContainer* _tmp17_ = NULL;
	gint _tmp18_ = 0;
	GUPnPDIDLLiteContainer* _tmp19_ = NULL;
	const gchar* _tmp20_ = NULL;
	const gchar* _tmp21_ = NULL;
	GUPnPDIDLLiteContainer* _tmp22_ = NULL;
	const gchar* _tmp23_ = NULL;
	const gchar* _tmp24_ = NULL;
	gboolean _tmp35_ = FALSE;
	gboolean _tmp36_ = FALSE;
	RygelHTTPServer* _tmp58_ = NULL;
	GUPnPDIDLLiteContainer* _tmp59_ = NULL;
	GError * _inner_error_ = NULL;
#line 270 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
	self = (RygelMediaContainer*) base;
#line 270 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
	g_return_val_if_fail (serializer != NULL, NULL);
#line 270 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
	g_return_val_if_fail (http_server != NULL, NULL);
#line 273 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
	_tmp0_ = serializer;
#line 273 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
	_tmp1_ = rygel_serializer_add_container (_tmp0_);
#line 273 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
	didl_container = _tmp1_;
#line 274 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
	_tmp2_ = didl_container;
#line 274 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
	if (_tmp2_ == NULL) {
#line 275 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
		result = NULL;
#line 275 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
		_g_object_unref0 (didl_container);
#line 275 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
		return result;
#line 627 "rygel-media-container.c"
	}
#line 278 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
	_tmp3_ = rygel_media_object_get_parent ((RygelMediaObject*) self);
#line 278 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
	_tmp4_ = _tmp3_;
#line 278 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
	if (_tmp4_ != NULL) {
#line 635 "rygel-media-container.c"
		GUPnPDIDLLiteContainer* _tmp5_ = NULL;
		RygelMediaContainer* _tmp6_ = NULL;
		RygelMediaContainer* _tmp7_ = NULL;
		const gchar* _tmp8_ = NULL;
		const gchar* _tmp9_ = NULL;
#line 279 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
		_tmp5_ = didl_container;
#line 279 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
		_tmp6_ = rygel_media_object_get_parent ((RygelMediaObject*) self);
#line 279 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
		_tmp7_ = _tmp6_;
#line 279 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
		_tmp8_ = rygel_media_object_get_id ((RygelMediaObject*) _tmp7_);
#line 279 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
		_tmp9_ = _tmp8_;
#line 279 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
		gupnp_didl_lite_object_set_parent_id ((GUPnPDIDLLiteObject*) _tmp5_, _tmp9_);
#line 653 "rygel-media-container.c"
	} else {
		GUPnPDIDLLiteContainer* _tmp10_ = NULL;
#line 281 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
		_tmp10_ = didl_container;
#line 281 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
		gupnp_didl_lite_object_set_parent_id ((GUPnPDIDLLiteObject*) _tmp10_, "-1");
#line 660 "rygel-media-container.c"
	}
#line 284 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
	_tmp11_ = didl_container;
#line 284 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
	_tmp12_ = rygel_media_object_get_id ((RygelMediaObject*) self);
#line 284 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
	_tmp13_ = _tmp12_;
#line 284 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
	gupnp_didl_lite_object_set_id ((GUPnPDIDLLiteObject*) _tmp11_, _tmp13_);
#line 285 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
	_tmp14_ = didl_container;
#line 285 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
	_tmp15_ = rygel_media_object_get_title ((RygelMediaObject*) self);
#line 285 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
	_tmp16_ = _tmp15_;
#line 285 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
	gupnp_didl_lite_object_set_title ((GUPnPDIDLLiteObject*) _tmp14_, _tmp16_);
#line 286 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
	_tmp17_ = didl_container;
#line 286 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
	_tmp18_ = self->priv->_child_count;
#line 286 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
	gupnp_didl_lite_container_set_child_count (_tmp17_, _tmp18_);
#line 287 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
	_tmp19_ = didl_container;
#line 287 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
	_tmp20_ = rygel_media_object_get_upnp_class ((RygelMediaObject*) self);
#line 287 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
	_tmp21_ = _tmp20_;
#line 287 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
	gupnp_didl_lite_object_set_upnp_class ((GUPnPDIDLLiteObject*) _tmp19_, _tmp21_);
#line 288 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
	_tmp22_ = didl_container;
#line 288 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
	gupnp_didl_lite_container_set_searchable (_tmp22_, G_TYPE_CHECK_INSTANCE_TYPE (self, RYGEL_TYPE_SEARCHABLE_CONTAINER));
#line 289 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
	_tmp23_ = rygel_media_object_get_upnp_class ((RygelMediaObject*) self);
#line 289 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
	_tmp24_ = _tmp23_;
#line 289 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
	if (g_strcmp0 (_tmp24_, RYGEL_MEDIA_CONTAINER_STORAGE_FOLDER) == 0) {
#line 702 "rygel-media-container.c"
		GUPnPDIDLLiteContainer* _tmp25_ = NULL;
		gint64 _tmp26_ = 0LL;
#line 290 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
		_tmp25_ = didl_container;
#line 290 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
		_tmp26_ = self->storage_used;
#line 290 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
		gupnp_didl_lite_container_set_storage_used (_tmp25_, _tmp26_);
#line 711 "rygel-media-container.c"
	}
#line 293 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
	if (G_TYPE_CHECK_INSTANCE_TYPE (self, RYGEL_TYPE_TRACKABLE_CONTAINER)) {
#line 715 "rygel-media-container.c"
		GUPnPDIDLLiteContainer* _tmp27_ = NULL;
		guint32 _tmp28_ = 0U;
		GUPnPDIDLLiteContainer* _tmp29_ = NULL;
		guint _tmp30_ = 0U;
		guint _tmp31_ = 0U;
		GUPnPDIDLLiteContainer* _tmp32_ = NULL;
		gint64 _tmp33_ = 0LL;
#line 294 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
		_tmp27_ = didl_container;
#line 294 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
		_tmp28_ = self->update_id;
#line 294 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
		gupnp_didl_lite_container_set_container_update_id (_tmp27_, (guint) _tmp28_);
#line 295 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
		_tmp29_ = didl_container;
#line 295 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
		_tmp30_ = rygel_media_object_get_object_update_id ((RygelMediaObject*) self);
#line 295 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
		_tmp31_ = _tmp30_;
#line 295 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
		gupnp_didl_lite_object_set_update_id ((GUPnPDIDLLiteObject*) _tmp29_, _tmp31_);
#line 296 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
		_tmp32_ = didl_container;
#line 296 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
		_tmp33_ = self->total_deleted_child_count;
#line 296 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
		gupnp_didl_lite_container_set_total_deleted_child_count (_tmp32_, (guint) _tmp33_);
#line 743 "rygel-media-container.c"
	}
#line 301 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
	if (G_TYPE_CHECK_INSTANCE_TYPE (self, RYGEL_TYPE_SEARCHABLE_CONTAINER)) {
#line 747 "rygel-media-container.c"
		GUPnPDIDLLiteContainer* _tmp34_ = NULL;
#line 302 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
		_tmp34_ = didl_container;
#line 302 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
		rygel_searchable_container_serialize_search_parameters (G_TYPE_CHECK_INSTANCE_TYPE (self, RYGEL_TYPE_SEARCHABLE_CONTAINER) ? ((RygelSearchableContainer*) self) : NULL, _tmp34_);
#line 753 "rygel-media-container.c"
	}
#line 306 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
	_tmp35_ = rygel_media_object_get_restricted ((RygelMediaObject*) self);
#line 306 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
	_tmp36_ = _tmp35_;
#line 306 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
	if (!_tmp36_) {
#line 761 "rygel-media-container.c"
		GUPnPDIDLLiteContainer* _tmp37_ = NULL;
		GUPnPDIDLLiteContainer* _tmp38_ = NULL;
		GUPnPOCMFlags _tmp39_ = 0;
		GUPnPOCMFlags _tmp40_ = 0;
		RygelWritableContainer* writable = NULL;
		RygelWritableContainer* _tmp41_ = NULL;
#line 307 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
		_tmp37_ = didl_container;
#line 307 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
		gupnp_didl_lite_object_set_restricted ((GUPnPDIDLLiteObject*) _tmp37_, FALSE);
#line 308 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
		_tmp38_ = didl_container;
#line 308 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
		_tmp39_ = rygel_media_object_get_ocm_flags ((RygelMediaObject*) self);
#line 308 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
		_tmp40_ = _tmp39_;
#line 308 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
		gupnp_didl_lite_object_set_dlna_managed ((GUPnPDIDLLiteObject*) _tmp38_, _tmp40_);
#line 310 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
		_tmp41_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (self, RYGEL_TYPE_WRITABLE_CONTAINER) ? ((RygelWritableContainer*) self) : NULL);
#line 310 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
		writable = _tmp41_;
#line 784 "rygel-media-container.c"
		{
			GeeArrayList* _create_class_list = NULL;
			RygelWritableContainer* _tmp42_ = NULL;
			GeeArrayList* _tmp43_ = NULL;
			GeeArrayList* _tmp44_ = NULL;
			GeeArrayList* _tmp45_ = NULL;
			gint _create_class_size = 0;
			GeeArrayList* _tmp46_ = NULL;
			gint _tmp47_ = 0;
			gint _tmp48_ = 0;
			gint _create_class_index = 0;
#line 311 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
			_tmp42_ = writable;
#line 311 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
			_tmp43_ = rygel_writable_container_get_create_classes (_tmp42_);
#line 311 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
			_tmp44_ = _tmp43_;
#line 311 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
			_tmp45_ = _g_object_ref0 (_tmp44_);
#line 311 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
			_create_class_list = _tmp45_;
#line 311 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
			_tmp46_ = _create_class_list;
#line 311 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
			_tmp47_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp46_);
#line 311 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
			_tmp48_ = _tmp47_;
#line 311 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
			_create_class_size = _tmp48_;
#line 311 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
			_create_class_index = -1;
#line 311 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
			while (TRUE) {
#line 818 "rygel-media-container.c"
				gint _tmp49_ = 0;
				gint _tmp50_ = 0;
				gint _tmp51_ = 0;
				gchar* create_class = NULL;
				GeeArrayList* _tmp52_ = NULL;
				gint _tmp53_ = 0;
				gpointer _tmp54_ = NULL;
				GUPnPDIDLLiteContainer* _tmp55_ = NULL;
				const gchar* _tmp56_ = NULL;
#line 311 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
				_tmp49_ = _create_class_index;
#line 311 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
				_create_class_index = _tmp49_ + 1;
#line 311 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
				_tmp50_ = _create_class_index;
#line 311 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
				_tmp51_ = _create_class_size;
#line 311 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
				if (!(_tmp50_ < _tmp51_)) {
#line 311 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
					break;
#line 840 "rygel-media-container.c"
				}
#line 311 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
				_tmp52_ = _create_class_list;
#line 311 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
				_tmp53_ = _create_class_index;
#line 311 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
				_tmp54_ = gee_abstract_list_get ((GeeAbstractList*) _tmp52_, _tmp53_);
#line 311 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
				create_class = (gchar*) _tmp54_;
#line 312 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
				_tmp55_ = didl_container;
#line 312 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
				_tmp56_ = create_class;
#line 312 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
				gupnp_didl_lite_container_add_create_class (_tmp55_, _tmp56_);
#line 311 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
				_g_free0 (create_class);
#line 858 "rygel-media-container.c"
			}
#line 311 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
			_g_object_unref0 (_create_class_list);
#line 862 "rygel-media-container.c"
		}
#line 306 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
		_g_object_unref0 (writable);
#line 866 "rygel-media-container.c"
	} else {
		GUPnPDIDLLiteContainer* _tmp57_ = NULL;
#line 315 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
		_tmp57_ = didl_container;
#line 315 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
		gupnp_didl_lite_object_set_restricted ((GUPnPDIDLLiteObject*) _tmp57_, TRUE);
#line 873 "rygel-media-container.c"
	}
#line 318 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
	_tmp58_ = http_server;
#line 318 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
	_tmp59_ = didl_container;
#line 318 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
	rygel_media_container_add_resources (self, _tmp58_, _tmp59_, &_inner_error_);
#line 318 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
	if (_inner_error_ != NULL) {
#line 318 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
		g_propagate_error (error, _inner_error_);
#line 318 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
		_g_object_unref0 (didl_container);
#line 318 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
		return NULL;
#line 889 "rygel-media-container.c"
	}
#line 320 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
	result = (GUPnPDIDLLiteObject*) didl_container;
#line 320 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
	return result;
#line 895 "rygel-media-container.c"
}


void rygel_media_container_add_resources (RygelMediaContainer* self, RygelHTTPServer* http_server, GUPnPDIDLLiteContainer* didl_container, GError** error) {
	RygelHTTPItemURI* uri = NULL;
	RygelHTTPServer* _tmp0_ = NULL;
	RygelHTTPItemURI* _tmp1_ = NULL;
	RygelHTTPItemURI* _tmp2_ = NULL;
	GUPnPDIDLLiteResource* res = NULL;
	GUPnPDIDLLiteContainer* _tmp3_ = NULL;
	RygelHTTPItemURI* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	RygelHTTPServer* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	gchar* _tmp9_ = NULL;
	GUPnPDIDLLiteResource* _tmp10_ = NULL;
	GUPnPDIDLLiteResource* _tmp11_ = NULL;
	GUPnPDIDLLiteResource* _tmp12_ = NULL;
	RygelHTTPServer* _tmp19_ = NULL;
	RygelHTTPItemURI* _tmp20_ = NULL;
	RygelHTTPItemURI* _tmp21_ = NULL;
	GUPnPDIDLLiteResource* _tmp22_ = NULL;
	GUPnPDIDLLiteContainer* _tmp23_ = NULL;
	RygelHTTPItemURI* _tmp24_ = NULL;
	gchar* _tmp25_ = NULL;
	gchar* _tmp26_ = NULL;
	RygelHTTPServer* _tmp27_ = NULL;
	gchar* _tmp28_ = NULL;
	gchar* _tmp29_ = NULL;
	GUPnPDIDLLiteResource* _tmp30_ = NULL;
	GUPnPDIDLLiteResource* _tmp31_ = NULL;
	GUPnPDIDLLiteResource* _tmp32_ = NULL;
	GError * _inner_error_ = NULL;
#line 323 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
	g_return_if_fail (self != NULL);
#line 323 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
	g_return_if_fail (http_server != NULL);
#line 323 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
	g_return_if_fail (didl_container != NULL);
#line 327 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
	_tmp0_ = http_server;
#line 327 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
	_tmp1_ = rygel_http_item_uri_new ((RygelMediaObject*) self, _tmp0_, -1, -1, NULL, "DIDL_S");
#line 327 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
	uri = _tmp1_;
#line 333 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
	_tmp2_ = uri;
#line 333 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
	rygel_http_item_uri_set_extension (_tmp2_, "xml");
#line 335 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
	_tmp3_ = didl_container;
#line 335 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
	_tmp4_ = uri;
#line 335 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
	_tmp5_ = rygel_http_item_uri_to_string (_tmp4_);
#line 335 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
	_tmp6_ = _tmp5_;
#line 335 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
	_tmp7_ = http_server;
#line 335 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
	_tmp8_ = rygel_transcode_manager_get_protocol ((RygelTranscodeManager*) _tmp7_);
#line 335 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
	_tmp9_ = _tmp8_;
#line 335 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
	_tmp10_ = rygel_media_object_add_resource ((RygelMediaObject*) self, (GUPnPDIDLLiteObject*) _tmp3_, _tmp6_, _tmp9_, NULL, &_inner_error_);
#line 335 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
	_tmp11_ = _tmp10_;
#line 335 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
	_g_free0 (_tmp9_);
#line 335 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
	_g_free0 (_tmp6_);
#line 335 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
	res = _tmp11_;
#line 335 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
	if (_inner_error_ != NULL) {
#line 335 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
		g_propagate_error (error, _inner_error_);
#line 335 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
		_g_object_unref0 (uri);
#line 335 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
		return;
#line 978 "rygel-media-container.c"
	}
#line 338 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
	_tmp12_ = res;
#line 338 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
	if (_tmp12_ != NULL) {
#line 984 "rygel-media-container.c"
		GUPnPDIDLLiteResource* _tmp13_ = NULL;
		GUPnPProtocolInfo* _tmp14_ = NULL;
		GUPnPProtocolInfo* _tmp15_ = NULL;
		GUPnPDIDLLiteResource* _tmp16_ = NULL;
		GUPnPProtocolInfo* _tmp17_ = NULL;
		GUPnPProtocolInfo* _tmp18_ = NULL;
#line 339 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
		_tmp13_ = res;
#line 339 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
		_tmp14_ = gupnp_didl_lite_resource_get_protocol_info (_tmp13_);
#line 339 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
		_tmp15_ = _tmp14_;
#line 339 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
		gupnp_protocol_info_set_mime_type (_tmp15_, "text/xml");
#line 340 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
		_tmp16_ = res;
#line 340 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
		_tmp17_ = gupnp_didl_lite_resource_get_protocol_info (_tmp16_);
#line 340 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
		_tmp18_ = _tmp17_;
#line 340 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
		gupnp_protocol_info_set_dlna_profile (_tmp18_, "DIDL_S");
#line 1007 "rygel-media-container.c"
	}
#line 344 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
	_tmp19_ = http_server;
#line 344 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
	_tmp20_ = rygel_http_item_uri_new ((RygelMediaObject*) self, _tmp19_, -1, -1, NULL, "M3U");
#line 344 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
	_g_object_unref0 (uri);
#line 344 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
	uri = _tmp20_;
#line 345 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
	_tmp21_ = uri;
#line 345 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
	rygel_http_item_uri_set_extension (_tmp21_, "m3u");
#line 347 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
	_tmp23_ = didl_container;
#line 347 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
	_tmp24_ = uri;
#line 347 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
	_tmp25_ = rygel_http_item_uri_to_string (_tmp24_);
#line 347 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
	_tmp26_ = _tmp25_;
#line 347 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
	_tmp27_ = http_server;
#line 347 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
	_tmp28_ = rygel_transcode_manager_get_protocol ((RygelTranscodeManager*) _tmp27_);
#line 347 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
	_tmp29_ = _tmp28_;
#line 347 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
	_tmp30_ = rygel_media_object_add_resource ((RygelMediaObject*) self, (GUPnPDIDLLiteObject*) _tmp23_, _tmp26_, _tmp29_, NULL, &_inner_error_);
#line 347 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
	_tmp31_ = _tmp30_;
#line 347 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
	_g_free0 (_tmp29_);
#line 347 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
	_g_free0 (_tmp26_);
#line 347 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
	_tmp22_ = _tmp31_;
#line 347 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
	if (_inner_error_ != NULL) {
#line 347 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
		g_propagate_error (error, _inner_error_);
#line 347 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
		_g_object_unref0 (res);
#line 347 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
		_g_object_unref0 (uri);
#line 347 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
		return;
#line 1055 "rygel-media-container.c"
	}
#line 347 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
	_g_object_unref0 (res);
#line 347 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
	res = _tmp22_;
#line 350 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
	_tmp32_ = res;
#line 350 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
	if (_tmp32_ != NULL) {
#line 1065 "rygel-media-container.c"
		GUPnPDIDLLiteResource* _tmp33_ = NULL;
		GUPnPProtocolInfo* _tmp34_ = NULL;
		GUPnPProtocolInfo* _tmp35_ = NULL;
#line 351 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
		_tmp33_ = res;
#line 351 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
		_tmp34_ = gupnp_didl_lite_resource_get_protocol_info (_tmp33_);
#line 351 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
		_tmp35_ = _tmp34_;
#line 351 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
		gupnp_protocol_info_set_mime_type (_tmp35_, "audio/x-mpegurl");
#line 1077 "rygel-media-container.c"
	}
#line 323 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
	_g_object_unref0 (res);
#line 323 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
	_g_object_unref0 (uri);
#line 1083 "rygel-media-container.c"
}


static GUPnPDIDLLiteResource* rygel_media_container_real_add_resource (RygelMediaObject* base, GUPnPDIDLLiteObject* didl_object, const gchar* uri, const gchar* protocol, const gchar* import_uri, GError** error) {
	RygelMediaContainer * self;
	GUPnPDIDLLiteResource* result = NULL;
	gint _tmp0_ = 0;
	GUPnPDIDLLiteResource* res = NULL;
	GUPnPDIDLLiteObject* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	GUPnPDIDLLiteResource* _tmp7_ = NULL;
	const gchar* _tmp8_ = NULL;
	GUPnPProtocolInfo* protocol_info = NULL;
	GUPnPProtocolInfo* _tmp11_ = NULL;
	GUPnPProtocolInfo* _tmp12_ = NULL;
	GUPnPProtocolInfo* _tmp13_ = NULL;
	const gchar* _tmp14_ = NULL;
	GUPnPProtocolInfo* _tmp15_ = NULL;
	GUPnPDIDLLiteResource* _tmp16_ = NULL;
	GUPnPProtocolInfo* _tmp17_ = NULL;
	GError * _inner_error_ = NULL;
#line 355 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
	self = (RygelMediaContainer*) base;
#line 355 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
	g_return_val_if_fail (didl_object != NULL, NULL);
#line 355 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
	g_return_val_if_fail (protocol != NULL, NULL);
#line 361 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
	_tmp0_ = self->priv->_child_count;
#line 361 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
	if (_tmp0_ <= 0) {
#line 1117 "rygel-media-container.c"
		gpointer _tmp1_ = NULL;
		GUPnPDIDLLiteResource* _tmp2_ = NULL;
#line 362 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
		_tmp1_ = NULL;
#line 362 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
		_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, gupnp_didl_lite_resource_get_type ()) ? ((GUPnPDIDLLiteResource*) _tmp1_) : NULL);
#line 362 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
		result = _tmp2_;
#line 362 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
		return result;
#line 1128 "rygel-media-container.c"
	}
#line 365 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
	_tmp3_ = didl_object;
#line 365 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
	_tmp4_ = uri;
#line 365 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
	_tmp5_ = protocol;
#line 365 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
	_tmp6_ = import_uri;
#line 365 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
	_tmp7_ = RYGEL_MEDIA_OBJECT_CLASS (rygel_media_container_parent_class)->add_resource (G_TYPE_CHECK_INSTANCE_CAST (self, RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObject), _tmp3_, _tmp4_, _tmp5_, _tmp6_, &_inner_error_);
#line 365 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
	res = _tmp7_;
#line 365 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
	if (_inner_error_ != NULL) {
#line 365 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
		g_propagate_error (error, _inner_error_);
#line 365 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
		return NULL;
#line 1148 "rygel-media-container.c"
	}
#line 370 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
	_tmp8_ = uri;
#line 370 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
	if (_tmp8_ != NULL) {
#line 1154 "rygel-media-container.c"
		GUPnPDIDLLiteResource* _tmp9_ = NULL;
		const gchar* _tmp10_ = NULL;
#line 371 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
		_tmp9_ = res;
#line 371 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
		_tmp10_ = uri;
#line 371 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
		gupnp_didl_lite_resource_set_uri (_tmp9_, _tmp10_);
#line 1163 "rygel-media-container.c"
	}
#line 374 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
	_tmp11_ = gupnp_protocol_info_new ();
#line 374 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
	protocol_info = _tmp11_;
#line 375 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
	_tmp12_ = protocol_info;
#line 375 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
	gupnp_protocol_info_set_mime_type (_tmp12_, "");
#line 376 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
	_tmp13_ = protocol_info;
#line 376 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
	_tmp14_ = protocol;
#line 376 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
	gupnp_protocol_info_set_protocol (_tmp13_, _tmp14_);
#line 377 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
	_tmp15_ = protocol_info;
#line 377 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
	gupnp_protocol_info_set_dlna_flags (_tmp15_, ((GUPNP_DLNA_FLAGS_DLNA_V15 | GUPNP_DLNA_FLAGS_CONNECTION_STALL) | GUPNP_DLNA_FLAGS_BACKGROUND_TRANSFER_MODE) | GUPNP_DLNA_FLAGS_INTERACTIVE_TRANSFER_MODE);
#line 381 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
	_tmp16_ = res;
#line 381 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
	_tmp17_ = protocol_info;
#line 381 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
	gupnp_didl_lite_resource_set_protocol_info (_tmp16_, _tmp17_);
#line 383 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
	result = res;
#line 383 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
	_g_object_unref0 (protocol_info);
#line 383 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
	return result;
#line 1195 "rygel-media-container.c"
}


/**
     * The handler for the container_updated signal on this container. We only forward
     * it to the parent, hoping someone will get it from the root container
     * and act upon it.
     *
     * @param container The container that emitted the signal
     * @param updated_container The container that just got updated
     */
static void rygel_media_container_on_container_updated (RygelMediaContainer* self, RygelMediaContainer* container, RygelMediaContainer* updated_container, RygelMediaObject* object, RygelObjectEventType event_type, gboolean sub_tree_update) {
	RygelMediaContainer* _tmp0_ = NULL;
	RygelMediaContainer* _tmp1_ = NULL;
#line 394 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
	g_return_if_fail (self != NULL);
#line 394 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
	g_return_if_fail (container != NULL);
#line 394 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
	g_return_if_fail (updated_container != NULL);
#line 394 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
	g_return_if_fail (object != NULL);
#line 399 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
	_tmp0_ = rygel_media_object_get_parent ((RygelMediaObject*) self);
#line 399 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
	_tmp1_ = _tmp0_;
#line 399 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
	if (_tmp1_ != NULL) {
#line 1224 "rygel-media-container.c"
		RygelMediaContainer* _tmp2_ = NULL;
		RygelMediaContainer* _tmp3_ = NULL;
		RygelMediaContainer* _tmp4_ = NULL;
		RygelMediaObject* _tmp5_ = NULL;
		RygelObjectEventType _tmp6_ = 0;
		gboolean _tmp7_ = FALSE;
#line 400 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
		_tmp2_ = rygel_media_object_get_parent ((RygelMediaObject*) self);
#line 400 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
		_tmp3_ = _tmp2_;
#line 400 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
		_tmp4_ = updated_container;
#line 400 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
		_tmp5_ = object;
#line 400 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
		_tmp6_ = event_type;
#line 400 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
		_tmp7_ = sub_tree_update;
#line 400 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
		g_signal_emit_by_name (_tmp3_, "container-updated", _tmp4_, _tmp5_, _tmp6_, _tmp7_);
#line 1245 "rygel-media-container.c"
	}
}


static void rygel_media_container_on_sub_tree_updates_finished (RygelMediaContainer* self, RygelMediaContainer* container, RygelMediaObject* sub_tree_root) {
	RygelMediaContainer* _tmp0_ = NULL;
	RygelMediaContainer* _tmp1_ = NULL;
#line 407 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
	g_return_if_fail (self != NULL);
#line 407 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
	g_return_if_fail (container != NULL);
#line 407 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
	g_return_if_fail (sub_tree_root != NULL);
#line 409 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
	_tmp0_ = rygel_media_object_get_parent ((RygelMediaObject*) self);
#line 409 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
	_tmp1_ = _tmp0_;
#line 409 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
	if (_tmp1_ != NULL) {
#line 1265 "rygel-media-container.c"
		RygelMediaContainer* _tmp2_ = NULL;
		RygelMediaContainer* _tmp3_ = NULL;
		RygelMediaObject* _tmp4_ = NULL;
#line 410 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
		_tmp2_ = rygel_media_object_get_parent ((RygelMediaObject*) self);
#line 410 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
		_tmp3_ = _tmp2_;
#line 410 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
		_tmp4_ = sub_tree_root;
#line 410 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
		g_signal_emit_by_name (_tmp3_, "sub-tree-updates-finished", _tmp4_);
#line 1277 "rygel-media-container.c"
	}
}


static gpointer _rygel_search_expression_ref0 (gpointer self) {
#line 417 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
	return self ? rygel_search_expression_ref (self) : NULL;
#line 1285 "rygel-media-container.c"
}


void rygel_media_container_check_search_expression (RygelMediaContainer* self, RygelSearchExpression* expression) {
	gboolean _tmp0_ = FALSE;
	RygelSearchExpression* _tmp1_ = NULL;
	gboolean _tmp3_ = FALSE;
#line 414 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
	g_return_if_fail (self != NULL);
#line 415 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
	rygel_media_container_set_create_mode_enabled (self, FALSE);
#line 416 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
	_tmp1_ = expression;
#line 416 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
	if (_tmp1_ != NULL) {
#line 1301 "rygel-media-container.c"
		RygelSearchExpression* _tmp2_ = NULL;
#line 416 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
		_tmp2_ = expression;
#line 416 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
		_tmp0_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp2_, RYGEL_TYPE_RELATIONAL_EXPRESSION);
#line 1307 "rygel-media-container.c"
	} else {
#line 416 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
		_tmp0_ = FALSE;
#line 1311 "rygel-media-container.c"
	}
#line 416 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
	_tmp3_ = _tmp0_;
#line 416 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
	if (_tmp3_) {
#line 1317 "rygel-media-container.c"
		RygelRelationalExpression* relational_exp = NULL;
		RygelSearchExpression* _tmp4_ = NULL;
		RygelRelationalExpression* _tmp5_ = NULL;
		gboolean _tmp6_ = FALSE;
		RygelRelationalExpression* _tmp7_ = NULL;
		gconstpointer _tmp8_ = NULL;
		gboolean _tmp11_ = FALSE;
#line 417 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
		_tmp4_ = expression;
#line 417 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
		_tmp5_ = _rygel_search_expression_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp4_, RYGEL_TYPE_RELATIONAL_EXPRESSION) ? ((RygelRelationalExpression*) _tmp4_) : NULL);
#line 417 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
		relational_exp = _tmp5_;
#line 418 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
		_tmp7_ = relational_exp;
#line 418 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
		_tmp8_ = ((RygelSearchExpression*) _tmp7_)->op;
#line 418 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
		if (((GUPnPSearchCriteriaOp) ((gintptr) _tmp8_)) == GUPNP_SEARCH_CRITERIA_OP_DERIVED_FROM) {
#line 1337 "rygel-media-container.c"
			RygelRelationalExpression* _tmp9_ = NULL;
			gconstpointer _tmp10_ = NULL;
#line 419 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
			_tmp9_ = relational_exp;
#line 419 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
			_tmp10_ = ((RygelSearchExpression*) _tmp9_)->operand1;
#line 419 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
			_tmp6_ = g_strcmp0 ((const gchar*) _tmp10_, "upnp:createClass") == 0;
#line 1346 "rygel-media-container.c"
		} else {
#line 418 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
			_tmp6_ = FALSE;
#line 1350 "rygel-media-container.c"
		}
#line 418 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
		_tmp11_ = _tmp6_;
#line 418 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
		if (_tmp11_) {
#line 420 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
			rygel_media_container_set_create_mode_enabled (self, TRUE);
#line 1358 "rygel-media-container.c"
		}
#line 416 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
		_rygel_search_expression_unref0 (relational_exp);
#line 1362 "rygel-media-container.c"
	}
}


gint rygel_media_container_get_child_count (RygelMediaContainer* self) {
	gint result;
	gint _tmp0_ = 0;
#line 110 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 110 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
	_tmp0_ = self->priv->_child_count;
#line 110 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
	result = _tmp0_;
#line 110 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
	return result;
#line 1378 "rygel-media-container.c"
}


void rygel_media_container_set_child_count (RygelMediaContainer* self, gint value) {
	gint _tmp0_ = 0;
#line 110 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
	g_return_if_fail (self != NULL);
#line 110 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
	_tmp0_ = value;
#line 110 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
	self->priv->_child_count = _tmp0_;
#line 110 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
	g_object_notify ((GObject *) self, "child-count");
#line 1392 "rygel-media-container.c"
}


gint rygel_media_container_get_empty_child_count (RygelMediaContainer* self) {
	gint result;
	gint _tmp0_ = 0;
#line 111 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 111 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
	_tmp0_ = self->priv->_empty_child_count;
#line 111 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
	result = _tmp0_;
#line 111 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
	return result;
#line 1407 "rygel-media-container.c"
}


void rygel_media_container_set_empty_child_count (RygelMediaContainer* self, gint value) {
	gint _tmp0_ = 0;
#line 111 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
	g_return_if_fail (self != NULL);
#line 111 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
	_tmp0_ = value;
#line 111 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
	self->priv->_empty_child_count = _tmp0_;
#line 111 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
	g_object_notify ((GObject *) self, "empty-child-count");
#line 1421 "rygel-media-container.c"
}


gint rygel_media_container_get_all_child_count (RygelMediaContainer* self) {
	gint result;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
#line 113 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 114 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
	_tmp0_ = self->priv->_child_count;
#line 114 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
	_tmp1_ = self->priv->_empty_child_count;
#line 114 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
	result = _tmp0_ + _tmp1_;
#line 114 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
	return result;
#line 1439 "rygel-media-container.c"
}


gboolean rygel_media_container_get_create_mode_enabled (RygelMediaContainer* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
#line 120 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 120 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
	_tmp0_ = self->priv->_create_mode_enabled;
#line 120 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
	result = _tmp0_;
#line 120 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
	return result;
#line 1454 "rygel-media-container.c"
}


void rygel_media_container_set_create_mode_enabled (RygelMediaContainer* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
#line 120 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
	g_return_if_fail (self != NULL);
#line 120 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
	_tmp0_ = value;
#line 120 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
	self->priv->_create_mode_enabled = _tmp0_;
#line 120 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
	g_object_notify ((GObject *) self, "create-mode-enabled");
#line 1468 "rygel-media-container.c"
}


const gchar* rygel_media_container_get_sort_criteria (RygelMediaContainer* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
#line 126 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 126 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
	_tmp0_ = self->priv->_sort_criteria;
#line 126 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
	result = _tmp0_;
#line 126 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
	return result;
#line 1483 "rygel-media-container.c"
}


void rygel_media_container_set_sort_criteria (RygelMediaContainer* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
#line 126 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
	g_return_if_fail (self != NULL);
#line 126 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
	_tmp0_ = value;
#line 126 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 126 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
	_g_free0 (self->priv->_sort_criteria);
#line 126 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
	self->priv->_sort_criteria = _tmp1_;
#line 126 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
	g_object_notify ((GObject *) self, "sort-criteria");
#line 1502 "rygel-media-container.c"
}


static GUPnPOCMFlags rygel_media_container_real_get_ocm_flags (RygelMediaObject* base) {
	GUPnPOCMFlags result;
	RygelMediaContainer* self;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp4_ = FALSE;
	GUPnPOCMFlags flags = 0;
	gboolean allow_upload = FALSE;
	RygelMetaConfig* config = NULL;
	RygelMetaConfig* _tmp5_ = NULL;
	gboolean _tmp9_ = FALSE;
	gboolean allow_deletion = FALSE;
	gboolean _tmp14_ = FALSE;
	GUPnPOCMFlags _tmp17_ = 0;
	GError * _inner_error_ = NULL;
#line 129 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
	self = (RygelMediaContainer*) base;
#line 130 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
	if (!G_TYPE_CHECK_INSTANCE_TYPE (self, RYGEL_TYPE_WRITABLE_CONTAINER)) {
#line 130 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
		_tmp0_ = TRUE;
#line 1526 "rygel-media-container.c"
	} else {
		GeeArrayList* _tmp1_ = NULL;
		gint _tmp2_ = 0;
		gint _tmp3_ = 0;
#line 130 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
		_tmp1_ = ((RygelMediaObject*) self)->uris;
#line 130 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
		_tmp2_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp1_);
#line 130 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
		_tmp3_ = _tmp2_;
#line 130 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
		_tmp0_ = _tmp3_ == 0;
#line 1539 "rygel-media-container.c"
	}
#line 130 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
	_tmp4_ = _tmp0_;
#line 130 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
	if (_tmp4_) {
#line 131 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
		result = GUPNP_OCM_FLAGS_NONE;
#line 131 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
		return result;
#line 1549 "rygel-media-container.c"
	}
#line 134 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
	flags = GUPNP_OCM_FLAGS_NONE;
#line 136 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
	allow_upload = TRUE;
#line 137 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
	_tmp5_ = rygel_meta_config_get_default ();
#line 137 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
	config = _tmp5_;
#line 1559 "rygel-media-container.c"
	{
		gboolean _tmp6_ = FALSE;
		RygelMetaConfig* _tmp7_ = NULL;
		gboolean _tmp8_ = FALSE;
#line 139 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
		_tmp7_ = config;
#line 139 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
		_tmp8_ = rygel_configuration_get_allow_upload ((RygelConfiguration*) _tmp7_, &_inner_error_);
#line 139 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
		_tmp6_ = _tmp8_;
#line 139 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
		if (_inner_error_ != NULL) {
#line 1572 "rygel-media-container.c"
			goto __catch5_g_error;
		}
#line 139 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
		allow_upload = _tmp6_;
#line 1577 "rygel-media-container.c"
	}
	goto __finally5;
	__catch5_g_error:
	{
		GError* _error_ = NULL;
#line 138 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
		_error_ = _inner_error_;
#line 138 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
		_inner_error_ = NULL;
#line 138 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
		_g_error_free0 (_error_);
#line 1589 "rygel-media-container.c"
	}
	__finally5:
#line 138 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
	if (_inner_error_ != NULL) {
#line 138 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
		_g_object_unref0 (config);
#line 138 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 138 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
		g_clear_error (&_inner_error_);
#line 138 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
		return 0;
#line 1602 "rygel-media-container.c"
	}
#line 142 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
	_tmp9_ = allow_upload;
#line 142 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
	if (_tmp9_) {
#line 1608 "rygel-media-container.c"
		GUPnPOCMFlags _tmp10_ = 0;
#line 143 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
		_tmp10_ = flags;
#line 143 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
		flags = _tmp10_ | ((GUPNP_OCM_FLAGS_UPLOAD | GUPNP_OCM_FLAGS_UPLOAD_DESTROYABLE) | GUPNP_OCM_FLAGS_CREATE_CONTAINER);
#line 1614 "rygel-media-container.c"
	}
#line 148 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
	allow_deletion = TRUE;
#line 1618 "rygel-media-container.c"
	{
		gboolean _tmp11_ = FALSE;
		RygelMetaConfig* _tmp12_ = NULL;
		gboolean _tmp13_ = FALSE;
#line 150 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
		_tmp12_ = config;
#line 150 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
		_tmp13_ = rygel_configuration_get_allow_deletion ((RygelConfiguration*) _tmp12_, &_inner_error_);
#line 150 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
		_tmp11_ = _tmp13_;
#line 150 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
		if (_inner_error_ != NULL) {
#line 1631 "rygel-media-container.c"
			goto __catch6_g_error;
		}
#line 150 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
		allow_deletion = _tmp11_;
#line 1636 "rygel-media-container.c"
	}
	goto __finally6;
	__catch6_g_error:
	{
		GError* _error_ = NULL;
#line 149 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
		_error_ = _inner_error_;
#line 149 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
		_inner_error_ = NULL;
#line 149 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
		_g_error_free0 (_error_);
#line 1648 "rygel-media-container.c"
	}
	__finally6:
#line 149 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
	if (_inner_error_ != NULL) {
#line 149 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
		_g_object_unref0 (config);
#line 149 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 149 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
		g_clear_error (&_inner_error_);
#line 149 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
		return 0;
#line 1661 "rygel-media-container.c"
	}
#line 153 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
	_tmp14_ = allow_deletion;
#line 153 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
	if (_tmp14_) {
#line 1667 "rygel-media-container.c"
		GUPnPOCMFlags _tmp15_ = 0;
#line 154 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
		_tmp15_ = flags;
#line 154 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
		flags = _tmp15_ | GUPNP_OCM_FLAGS_DESTROYABLE;
#line 1673 "rygel-media-container.c"
	}
#line 157 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
	if (G_TYPE_CHECK_INSTANCE_TYPE (self, RYGEL_TYPE_UPDATABLE_OBJECT)) {
#line 1677 "rygel-media-container.c"
		GUPnPOCMFlags _tmp16_ = 0;
#line 158 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
		_tmp16_ = flags;
#line 158 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
		flags = _tmp16_ | GUPNP_OCM_FLAGS_CHANGE_METADATA;
#line 1683 "rygel-media-container.c"
	}
#line 161 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
	_tmp17_ = flags;
#line 161 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
	result = _tmp17_;
#line 161 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
	_g_object_unref0 (config);
#line 161 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
	return result;
#line 1693 "rygel-media-container.c"
}


static void g_cclosure_user_marshal_VOID__OBJECT_OBJECT_ENUM_BOOLEAN (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__OBJECT_OBJECT_ENUM_BOOLEAN) (gpointer data1, gpointer arg_1, gpointer arg_2, gint arg_3, gboolean arg_4, gpointer data2);
	register GMarshalFunc_VOID__OBJECT_OBJECT_ENUM_BOOLEAN callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
#line 62 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
	g_return_if_fail (n_param_values == 5);
#line 62 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
	if (G_CCLOSURE_SWAP_DATA (closure)) {
#line 62 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
		data1 = closure->data;
#line 62 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
		data2 = param_values->data[0].v_pointer;
#line 1712 "rygel-media-container.c"
	} else {
#line 62 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
		data1 = param_values->data[0].v_pointer;
#line 62 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
		data2 = closure->data;
#line 1718 "rygel-media-container.c"
	}
#line 62 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
	callback = (GMarshalFunc_VOID__OBJECT_OBJECT_ENUM_BOOLEAN) (marshal_data ? marshal_data : cc->callback);
#line 62 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
	callback (data1, g_value_get_object (param_values + 1), g_value_get_object (param_values + 2), g_value_get_enum (param_values + 3), g_value_get_boolean (param_values + 4), data2);
#line 1724 "rygel-media-container.c"
}


static void rygel_media_container_class_init (RygelMediaContainerClass * klass) {
#line 62 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
	rygel_media_container_parent_class = g_type_class_peek_parent (klass);
#line 62 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
	g_type_class_add_private (klass, sizeof (RygelMediaContainerPrivate));
#line 62 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
	G_OBJECT_CLASS (klass)->constructed = rygel_media_container_real_constructed;
#line 62 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
	RYGEL_MEDIA_OBJECT_CLASS (klass)->serialize = rygel_media_container_real_serialize;
#line 62 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
	RYGEL_MEDIA_OBJECT_CLASS (klass)->add_resource = rygel_media_container_real_add_resource;
#line 62 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
	RYGEL_MEDIA_OBJECT_CLASS (klass)->get_ocm_flags = rygel_media_container_real_get_ocm_flags;
#line 62 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_rygel_media_container_get_property;
#line 62 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_rygel_media_container_set_property;
#line 62 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
	G_OBJECT_CLASS (klass)->finalize = rygel_media_container_finalize;
#line 62 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MEDIA_CONTAINER_CHILD_COUNT, g_param_spec_int ("child-count", "child-count", "child-count", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
#line 62 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MEDIA_CONTAINER_EMPTY_CHILD_COUNT, g_param_spec_int ("empty-child-count", "empty-child-count", "empty-child-count", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 62 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MEDIA_CONTAINER_ALL_CHILD_COUNT, g_param_spec_int ("all-child-count", "all-child-count", "all-child-count", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 62 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MEDIA_CONTAINER_CREATE_MODE_ENABLED, g_param_spec_boolean ("create-mode-enabled", "create-mode-enabled", "create-mode-enabled", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 62 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MEDIA_CONTAINER_SORT_CRITERIA, g_param_spec_string ("sort-criteria", "sort-criteria", "sort-criteria", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 62 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MEDIA_CONTAINER_OCM_FLAGS, g_param_spec_flags ("ocm-flags", "ocm-flags", "ocm-flags", gupnp_ocm_flags_get_type (), 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 1759 "rygel-media-container.c"
	/**
	     * The container_updated signal is emitted if a child container under the
	     * tree of this container has been updated. The object parameter is set to
	     * the MediaObject that is the source of the container update. Note that
	     * it may even be set to the container itself.
	     *
	     * @see rygel_media_container_updated().
	     *
	     * @param container The child container that has been updated.
	     * @param object The object that has changed. This may be the container itself, or a child item.
	     * @param event_type This describes what actually happened to the object.
	     * @param sub_tree_update Whether the modification is part of a sub-tree update. See the #RygelMediaContainer::sub_tree_updates_finished signal.
	     */
#line 62 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
	g_signal_new ("container_updated", RYGEL_TYPE_MEDIA_CONTAINER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__OBJECT_OBJECT_ENUM_BOOLEAN, G_TYPE_NONE, 4, RYGEL_TYPE_MEDIA_CONTAINER, RYGEL_TYPE_MEDIA_OBJECT, RYGEL_TYPE_OBJECT_EVENT_TYPE, G_TYPE_BOOLEAN);
#line 1775 "rygel-media-container.c"
	/**
	     * The sub_tree_updates_finished signal is emitted when all of
	     * the sub-tree operations are finished.
	     * See the #RygelMediaContainer::container_updated signal.
	     *
	     * @param sub_tree_root - root of a sub-tree where all operations
	     * were performed.
	     */
#line 62 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
	g_signal_new ("sub_tree_updates_finished", RYGEL_TYPE_MEDIA_CONTAINER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, RYGEL_TYPE_MEDIA_OBJECT);
#line 1786 "rygel-media-container.c"
}


static void rygel_media_container_instance_init (RygelMediaContainer * self) {
	gchar* _tmp0_ = NULL;
#line 62 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
	self->priv = RYGEL_MEDIA_CONTAINER_GET_PRIVATE (self);
#line 126 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
	_tmp0_ = g_strdup (RYGEL_MEDIA_CONTAINER_DEFAULT_SORT_CRITERIA);
#line 126 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
	self->priv->_sort_criteria = _tmp0_;
#line 1798 "rygel-media-container.c"
}


static void rygel_media_container_finalize (GObject* obj) {
	RygelMediaContainer * self;
#line 62 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainer);
#line 126 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
	_g_free0 (self->priv->_sort_criteria);
#line 62 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
	G_OBJECT_CLASS (rygel_media_container_parent_class)->finalize (obj);
#line 1810 "rygel-media-container.c"
}


/**
 * This is a container (folder) for media items and child containers.
 *
 * It provides a basic serialization implementation (to DIDLLiteWriter).
 *
 * A derived class should provide a working implementation of get_children
 * and should emit the container_updated signal.
 *
 * When used as a root container, you may wish to use the variables, such as
 * REALNAME, in in the title. See the title property of the #RygelMediaObject.
 *
 * If the container should support UPnP search operations then you also implement
 * the #RygelSearchableContainer interface.
 *
 * If the container should be writable, meaning that it allows adding (via upload),
 * removal and editing of items then you should also implement the #RygelWritableContainer
 * interface.
 *
 * If the container should support the change tracking profile of the UPnP
 * ContentDirectory:3 specification then you should also implement the 
 * #RygelTrackableContainer interface.
 *
 * The #RygelSimpleContainer class contains a simple memory-based container
 * implementation, but most real-world uses will require custom container
 * implementations.
 */
GType rygel_media_container_get_type (void) {
	static volatile gsize rygel_media_container_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_media_container_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelMediaContainerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_media_container_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelMediaContainer), 0, (GInstanceInitFunc) rygel_media_container_instance_init, NULL };
		GType rygel_media_container_type_id;
		rygel_media_container_type_id = g_type_register_static (RYGEL_TYPE_MEDIA_OBJECT, "RygelMediaContainer", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
		g_once_init_leave (&rygel_media_container_type_id__volatile, rygel_media_container_type_id);
	}
	return rygel_media_container_type_id__volatile;
}


static void _vala_rygel_media_container_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	RygelMediaContainer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainer);
#line 62 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
	switch (property_id) {
#line 62 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
		case RYGEL_MEDIA_CONTAINER_CHILD_COUNT:
#line 62 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
		g_value_set_int (value, rygel_media_container_get_child_count (self));
#line 62 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
		break;
#line 62 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
		case RYGEL_MEDIA_CONTAINER_EMPTY_CHILD_COUNT:
#line 62 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
		g_value_set_int (value, rygel_media_container_get_empty_child_count (self));
#line 62 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
		break;
#line 62 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
		case RYGEL_MEDIA_CONTAINER_ALL_CHILD_COUNT:
#line 62 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
		g_value_set_int (value, rygel_media_container_get_all_child_count (self));
#line 62 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
		break;
#line 62 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
		case RYGEL_MEDIA_CONTAINER_CREATE_MODE_ENABLED:
#line 62 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
		g_value_set_boolean (value, rygel_media_container_get_create_mode_enabled (self));
#line 62 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
		break;
#line 62 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
		case RYGEL_MEDIA_CONTAINER_SORT_CRITERIA:
#line 62 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
		g_value_set_string (value, rygel_media_container_get_sort_criteria (self));
#line 62 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
		break;
#line 62 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
		case RYGEL_MEDIA_CONTAINER_OCM_FLAGS:
#line 62 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
		g_value_set_flags (value, rygel_media_object_get_ocm_flags ((RygelMediaObject*) self));
#line 62 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
		break;
#line 1893 "rygel-media-container.c"
		default:
#line 62 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 62 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
		break;
#line 1899 "rygel-media-container.c"
	}
}


static void _vala_rygel_media_container_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	RygelMediaContainer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainer);
#line 62 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
	switch (property_id) {
#line 62 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
		case RYGEL_MEDIA_CONTAINER_CHILD_COUNT:
#line 62 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
		rygel_media_container_set_child_count (self, g_value_get_int (value));
#line 62 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
		break;
#line 62 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
		case RYGEL_MEDIA_CONTAINER_EMPTY_CHILD_COUNT:
#line 62 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
		rygel_media_container_set_empty_child_count (self, g_value_get_int (value));
#line 62 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
		break;
#line 62 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
		case RYGEL_MEDIA_CONTAINER_CREATE_MODE_ENABLED:
#line 62 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
		rygel_media_container_set_create_mode_enabled (self, g_value_get_boolean (value));
#line 62 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
		break;
#line 62 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
		case RYGEL_MEDIA_CONTAINER_SORT_CRITERIA:
#line 62 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
		rygel_media_container_set_sort_criteria (self, g_value_get_string (value));
#line 62 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
		break;
#line 1933 "rygel-media-container.c"
		default:
#line 62 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 62 "/home/jens/Source/rygel/src/librygel-server/rygel-media-container.vala"
		break;
#line 1939 "rygel-media-container.c"
	}
}



