/* rygel-media-object.c generated by valac 0.22.0, the Vala compiler
 * generated from rygel-media-object.vala, do not modify */

/*
 * Copyright (C) 2008 Zeeshan Ali <zeenix@gmail.com>.
 * Copyright (C) 2012 Intel Corporation.
 *
 * Author: Zeeshan Ali <zeenix@gmail.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <libgupnp-av/gupnp-av.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <gio/gio.h>
#include <libxml/tree.h>


#define RYGEL_TYPE_MEDIA_OBJECT (rygel_media_object_get_type ())
#define RYGEL_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObject))
#define RYGEL_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))
#define RYGEL_IS_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_IS_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_MEDIA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))

typedef struct _RygelMediaObject RygelMediaObject;
typedef struct _RygelMediaObjectClass RygelMediaObjectClass;
typedef struct _RygelMediaObjectPrivate RygelMediaObjectPrivate;

#define RYGEL_TYPE_SERIALIZER (rygel_serializer_get_type ())
#define RYGEL_SERIALIZER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_SERIALIZER, RygelSerializer))
#define RYGEL_SERIALIZER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_SERIALIZER, RygelSerializerClass))
#define RYGEL_IS_SERIALIZER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_SERIALIZER))
#define RYGEL_IS_SERIALIZER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_SERIALIZER))
#define RYGEL_SERIALIZER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_SERIALIZER, RygelSerializerClass))

typedef struct _RygelSerializer RygelSerializer;
typedef struct _RygelSerializerClass RygelSerializerClass;

#define RYGEL_TYPE_TRANSCODE_MANAGER (rygel_transcode_manager_get_type ())
#define RYGEL_TRANSCODE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManager))
#define RYGEL_TRANSCODE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManagerClass))
#define RYGEL_IS_TRANSCODE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_TRANSCODE_MANAGER))
#define RYGEL_IS_TRANSCODE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_TRANSCODE_MANAGER))
#define RYGEL_TRANSCODE_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManagerClass))

typedef struct _RygelTranscodeManager RygelTranscodeManager;
typedef struct _RygelTranscodeManagerClass RygelTranscodeManagerClass;

#define RYGEL_TYPE_HTTP_SERVER (rygel_http_server_get_type ())
#define RYGEL_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServer))
#define RYGEL_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))
#define RYGEL_IS_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_IS_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_HTTP_SERVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))

typedef struct _RygelHTTPServer RygelHTTPServer;
typedef struct _RygelHTTPServerClass RygelHTTPServerClass;

#define RYGEL_TYPE_MEDIA_CONTAINER (rygel_media_container_get_type ())
#define RYGEL_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainer))
#define RYGEL_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))
#define RYGEL_IS_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_IS_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_MEDIA_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))

typedef struct _RygelMediaContainer RygelMediaContainer;
typedef struct _RygelMediaContainerClass RygelMediaContainerClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _RygelMediaObjectGetWritableData RygelMediaObjectGetWritableData;
typedef struct _RygelMediaObjectGetWritablesData RygelMediaObjectGetWritablesData;

#define TYPE_SERIALIZER_TYPE (serializer_type_get_type ())

#define RYGEL_TYPE_UPDATABLE_OBJECT (rygel_updatable_object_get_type ())
#define RYGEL_UPDATABLE_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_UPDATABLE_OBJECT, RygelUpdatableObject))
#define RYGEL_IS_UPDATABLE_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_UPDATABLE_OBJECT))
#define RYGEL_UPDATABLE_OBJECT_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_UPDATABLE_OBJECT, RygelUpdatableObjectIface))

typedef struct _RygelUpdatableObject RygelUpdatableObject;
typedef struct _RygelUpdatableObjectIface RygelUpdatableObjectIface;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _RygelMediaObjectApplyFragmentsData RygelMediaObjectApplyFragmentsData;
typedef struct _RygelMediaObjectCheckWritableData RygelMediaObjectCheckWritableData;
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))

struct _RygelMediaObject {
	GObject parent_instance;
	RygelMediaObjectPrivate * priv;
	GeeArrayList* uris;
	RygelMediaContainer* parent_ptr;
};

struct _RygelMediaObjectClass {
	GObjectClass parent_class;
	GUPnPDIDLLiteObject* (*serialize) (RygelMediaObject* self, RygelSerializer* serializer, RygelHTTPServer* http_server, GError** error);
	void (*apply_didl_lite) (RygelMediaObject* self, GUPnPDIDLLiteObject* didl_object);
	gint (*compare_by_property) (RygelMediaObject* self, RygelMediaObject* media_object, const gchar* property);
	GUPnPDIDLLiteResource* (*add_resource) (RygelMediaObject* self, GUPnPDIDLLiteObject* object, const gchar* uri, const gchar* protocol, const gchar* import_uri, GError** error);
	GUPnPOCMFlags (*get_ocm_flags) (RygelMediaObject* self);
};

struct _RygelMediaObjectPrivate {
	gchar* _id;
	gchar* _ref_id;
	gchar* _upnp_class;
	guint64 _modified;
	guint _object_update_id;
	RygelMediaContainer* _parent_ref;
	gchar* _title;
};

struct _RygelMediaObjectGetWritableData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelMediaObject* self;
	GCancellable* cancellable;
	GFile* result;
	GeeArrayList* _uri_list;
	GeeArrayList* _tmp0_;
	GeeArrayList* _tmp1_;
	gint _uri_size;
	GeeArrayList* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	gint _uri_index;
	gint _tmp5_;
	gint _tmp6_;
	gint _tmp7_;
	gchar* uri;
	GeeArrayList* _tmp8_;
	gint _tmp9_;
	gpointer _tmp10_;
	GFile* file;
	const gchar* _tmp11_;
	GFile* _tmp12_;
	gboolean _tmp13_;
	GFile* _tmp14_;
	GCancellable* _tmp15_;
	gboolean _tmp16_;
	GError * _inner_error_;
};

struct _RygelMediaObjectGetWritablesData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelMediaObject* self;
	GCancellable* cancellable;
	GeeArrayList* result;
	GeeArrayList* writables;
	GeeArrayList* _tmp0_;
	GeeArrayList* _uri_list;
	GeeArrayList* _tmp1_;
	GeeArrayList* _tmp2_;
	gint _uri_size;
	GeeArrayList* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	gint _uri_index;
	gint _tmp6_;
	gint _tmp7_;
	gint _tmp8_;
	gchar* uri;
	GeeArrayList* _tmp9_;
	gint _tmp10_;
	gpointer _tmp11_;
	GFile* file;
	const gchar* _tmp12_;
	GFile* _tmp13_;
	gboolean _tmp14_;
	GFile* _tmp15_;
	GCancellable* _tmp16_;
	gboolean _tmp17_;
	GeeArrayList* _tmp18_;
	GFile* _tmp19_;
	GError * _inner_error_;
};

typedef enum  {
	SERIALIZER_TYPE_GENERIC_DIDL,
	SERIALIZER_TYPE_DIDL_S,
	SERIALIZER_TYPE_M3UEXT
} SerializerType;

struct _RygelUpdatableObjectIface {
	GTypeInterface parent_iface;
	void (*commit) (RygelUpdatableObject* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*commit_finish) (RygelUpdatableObject* self, GAsyncResult* _res_, GError** error);
};

struct _RygelMediaObjectApplyFragmentsData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelMediaObject* self;
	GeeLinkedList* current_fragments;
	GeeLinkedList* new_fragments;
	RygelHTTPServer* http_server;
	GUPnPDIDLLiteFragmentResult result;
	GUPnPDIDLLiteFragmentResult _result_;
	RygelSerializer* writer;
	RygelSerializer* _tmp0_;
	GUPnPDIDLLiteObject* didl_object;
	RygelSerializer* _tmp1_;
	RygelHTTPServer* _tmp2_;
	GUPnPDIDLLiteObject* _tmp3_;
	GUPnPDIDLLiteObject* _tmp4_;
	xmlNode* _tmp5_;
	xmlNode* _tmp6_;
	GUPnPDIDLLiteObject* _tmp7_;
	void* _tmp8_;
	void* _tmp9_;
	GUPnPDIDLLiteObject* _tmp10_;
	GeeLinkedList* _tmp11_;
	gint _tmp12_;
	gpointer* _tmp13_;
	gchar** _tmp14_;
	gint _tmp14__length1;
	GeeLinkedList* _tmp15_;
	gint _tmp16_;
	gpointer* _tmp17_;
	gchar** _tmp18_;
	gint _tmp18__length1;
	GUPnPDIDLLiteFragmentResult _tmp19_;
	GUPnPDIDLLiteFragmentResult _tmp20_;
	GUPnPDIDLLiteObject* _tmp21_;
	GError* e;
	GError * _inner_error_;
};

struct _RygelMediaObjectCheckWritableData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelMediaObject* self;
	GFile* file;
	GCancellable* cancellable;
	gboolean result;
	GFile* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	GFile* _tmp5_;
	gboolean _tmp6_;
	GFileInfo* info;
	GFile* _tmp7_;
	GCancellable* _tmp8_;
	GFileInfo* _tmp9_;
	GFileInfo* _tmp10_;
	gboolean _tmp11_;
	GError* _error_;
	GError * _inner_error_;
};


static gpointer rygel_media_object_parent_class = NULL;
static GRegex* rygel_media_object_real_name_regex;
static GRegex* rygel_media_object_real_name_regex = NULL;
static GRegex* rygel_media_object_user_name_regex;
static GRegex* rygel_media_object_user_name_regex = NULL;
static GRegex* rygel_media_object_host_name_regex;
static GRegex* rygel_media_object_host_name_regex = NULL;

GType rygel_media_object_get_type (void) G_GNUC_CONST;
GType rygel_serializer_get_type (void) G_GNUC_CONST;
GType rygel_transcode_manager_get_type (void) G_GNUC_CONST;
GType rygel_http_server_get_type (void) G_GNUC_CONST;
GType rygel_media_container_get_type (void) G_GNUC_CONST;
#define RYGEL_MEDIA_OBJECT_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectPrivate))
enum  {
	RYGEL_MEDIA_OBJECT_DUMMY_PROPERTY,
	RYGEL_MEDIA_OBJECT_ID,
	RYGEL_MEDIA_OBJECT_REF_ID,
	RYGEL_MEDIA_OBJECT_UPNP_CLASS,
	RYGEL_MEDIA_OBJECT_MODIFIED,
	RYGEL_MEDIA_OBJECT_OBJECT_UPDATE_ID,
	RYGEL_MEDIA_OBJECT_PARENT,
	RYGEL_MEDIA_OBJECT_PARENT_REF,
	RYGEL_MEDIA_OBJECT_TITLE,
	RYGEL_MEDIA_OBJECT_OCM_FLAGS,
	RYGEL_MEDIA_OBJECT_RESTRICTED
};
static void rygel_media_object_real_constructed (GObject* base);
static void rygel_media_object_get_writable_data_free (gpointer _data);
void rygel_media_object_get_writable (RygelMediaObject* self, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
GFile* rygel_media_object_get_writable_finish (RygelMediaObject* self, GAsyncResult* _res_, GError** error);
static gboolean rygel_media_object_get_writable_co (RygelMediaObjectGetWritableData* _data_);
static void rygel_media_object_check_writable (RygelMediaObject* self, GFile* file, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean rygel_media_object_check_writable_finish (RygelMediaObject* self, GAsyncResult* _res_, GError** error);
static void rygel_media_object_get_writable_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void rygel_media_object_get_writables_data_free (gpointer _data);
void rygel_media_object_get_writables (RygelMediaObject* self, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
GeeArrayList* rygel_media_object_get_writables_finish (RygelMediaObject* self, GAsyncResult* _res_, GError** error);
static gboolean rygel_media_object_get_writables_co (RygelMediaObjectGetWritablesData* _data_);
static void rygel_media_object_get_writables_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
GUPnPDIDLLiteObject* rygel_media_object_serialize (RygelMediaObject* self, RygelSerializer* serializer, RygelHTTPServer* http_server, GError** error);
static GUPnPDIDLLiteObject* rygel_media_object_real_serialize (RygelMediaObject* self, RygelSerializer* serializer, RygelHTTPServer* http_server, GError** error);
void rygel_media_object_apply_didl_lite (RygelMediaObject* self, GUPnPDIDLLiteObject* didl_object);
static void rygel_media_object_real_apply_didl_lite (RygelMediaObject* self, GUPnPDIDLLiteObject* didl_object);
void rygel_media_object_set_title (RygelMediaObject* self, const gchar* value);
static void rygel_media_object_clean_node (RygelMediaObject* self, xmlNode* node, xmlNs* ns);
static void rygel_media_object_apply_fragments_data_free (gpointer _data);
void rygel_media_object_apply_fragments (RygelMediaObject* self, GeeLinkedList* current_fragments, GeeLinkedList* new_fragments, RygelHTTPServer* http_server, GAsyncReadyCallback _callback_, gpointer _user_data_);
GUPnPDIDLLiteFragmentResult rygel_media_object_apply_fragments_finish (RygelMediaObject* self, GAsyncResult* _res_);
static gboolean rygel_media_object_apply_fragments_co (RygelMediaObjectApplyFragmentsData* _data_);
GType serializer_type_get_type (void) G_GNUC_CONST;
RygelSerializer* rygel_serializer_new (SerializerType type);
RygelSerializer* rygel_serializer_construct (GType object_type, SerializerType type);
GType rygel_updatable_object_get_type (void) G_GNUC_CONST;
void rygel_updatable_object_commit (RygelUpdatableObject* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void rygel_updatable_object_commit_finish (RygelUpdatableObject* self, GAsyncResult* _res_, GError** error);
static void rygel_media_object_apply_fragments_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
gint rygel_media_object_compare_by_property (RygelMediaObject* self, RygelMediaObject* media_object, const gchar* property);
static gint rygel_media_object_real_compare_by_property (RygelMediaObject* self, RygelMediaObject* media_object, const gchar* property);
gint rygel_media_object_compare_string_props (RygelMediaObject* self, const gchar* prop1, const gchar* prop2);
const gchar* rygel_media_object_get_id (RygelMediaObject* self);
RygelMediaContainer* rygel_media_object_get_parent (RygelMediaObject* self);
const gchar* rygel_media_object_get_title (RygelMediaObject* self);
const gchar* rygel_media_object_get_upnp_class (RygelMediaObject* self);
GUPnPDIDLLiteResource* rygel_media_object_add_resource (RygelMediaObject* self, GUPnPDIDLLiteObject* object, const gchar* uri, const gchar* protocol, const gchar* import_uri, GError** error);
static GUPnPDIDLLiteResource* rygel_media_object_real_add_resource (RygelMediaObject* self, GUPnPDIDLLiteObject* object, const gchar* uri, const gchar* protocol, const gchar* import_uri, GError** error);
gint rygel_media_object_compare_int_props (RygelMediaObject* self, gint prop1, gint prop2);
static void rygel_media_object_check_writable_data_free (gpointer _data);
static gboolean rygel_media_object_check_writable_co (RygelMediaObjectCheckWritableData* _data_);
#define RYGEL_WRITABLE_CONTAINER_WRITABLE_SCHEME "rygel-writable://"
static void rygel_media_object_check_writable_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
RygelMediaObject* rygel_media_object_construct (GType object_type);
void rygel_media_object_set_id (RygelMediaObject* self, const gchar* value);
const gchar* rygel_media_object_get_ref_id (RygelMediaObject* self);
void rygel_media_object_set_ref_id (RygelMediaObject* self, const gchar* value);
void rygel_media_object_set_upnp_class (RygelMediaObject* self, const gchar* value);
guint64 rygel_media_object_get_modified (RygelMediaObject* self);
void rygel_media_object_set_modified (RygelMediaObject* self, guint64 value);
guint rygel_media_object_get_object_update_id (RygelMediaObject* self);
void rygel_media_object_set_object_update_id (RygelMediaObject* self, guint value);
void rygel_media_object_set_parent (RygelMediaObject* self, RygelMediaContainer* value);
RygelMediaContainer* rygel_media_object_get_parent_ref (RygelMediaObject* self);
void rygel_media_object_set_parent_ref (RygelMediaObject* self, RygelMediaContainer* value);
GUPnPOCMFlags rygel_media_object_get_ocm_flags (RygelMediaObject* self);
gboolean rygel_media_object_get_restricted (RygelMediaObject* self);
static void rygel_media_object_finalize (GObject* obj);
static void _vala_rygel_media_object_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_rygel_media_object_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


static void rygel_media_object_real_constructed (GObject* base) {
	RygelMediaObject * self;
	GeeArrayList* _tmp0_ = NULL;
#line 146 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	self = (RygelMediaObject*) base;
#line 147 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	G_OBJECT_CLASS (rygel_media_object_parent_class)->constructed (G_TYPE_CHECK_INSTANCE_CAST (self, G_TYPE_OBJECT, GObject));
#line 149 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_tmp0_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL, NULL);
#line 149 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_g_object_unref0 (self->uris);
#line 149 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	self->uris = _tmp0_;
#line 388 "rygel-media-object.c"
}


static void rygel_media_object_get_writable_data_free (gpointer _data) {
	RygelMediaObjectGetWritableData* _data_;
	_data_ = _data;
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_g_object_unref0 (_data_->cancellable);
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_g_object_unref0 (_data_->result);
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_g_object_unref0 (_data_->self);
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	g_slice_free (RygelMediaObjectGetWritableData, _data_);
#line 403 "rygel-media-object.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	return self ? g_object_ref (self) : NULL;
#line 410 "rygel-media-object.c"
}


void rygel_media_object_get_writable (RygelMediaObject* self, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelMediaObjectGetWritableData* _data_;
	RygelMediaObject* _tmp0_ = NULL;
	GCancellable* _tmp1_ = NULL;
	GCancellable* _tmp2_ = NULL;
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_data_ = g_slice_new0 (RygelMediaObjectGetWritableData);
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_media_object_get_writable);
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_media_object_get_writable_data_free);
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_data_->self = _tmp0_;
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_tmp1_ = cancellable;
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_tmp2_ = _g_object_ref0 (_tmp1_);
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_g_object_unref0 (_data_->cancellable);
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_data_->cancellable = _tmp2_;
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	rygel_media_object_get_writable_co (_data_);
#line 439 "rygel-media-object.c"
}


GFile* rygel_media_object_get_writable_finish (RygelMediaObject* self, GAsyncResult* _res_, GError** error) {
	GFile* result;
	RygelMediaObjectGetWritableData* _data_;
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		return NULL;
#line 450 "rygel-media-object.c"
	}
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	result = _data_->result;
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_data_->result = NULL;
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	return result;
#line 460 "rygel-media-object.c"
}


/**
     * Fetches a File object for any writable URI available for this object.
     *
     * @param cancellable A GLib.Cancellable
     */
static void rygel_media_object_get_writable_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelMediaObjectGetWritableData* _data_;
#line 161 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_data_ = _user_data_;
#line 161 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_data_->_source_object_ = source_object;
#line 161 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_data_->_res_ = _res_;
#line 161 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	rygel_media_object_get_writable_co (_data_);
#line 479 "rygel-media-object.c"
}


static gboolean rygel_media_object_get_writable_co (RygelMediaObjectGetWritableData* _data_) {
#line 157 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	switch (_data_->_state_) {
#line 157 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		case 0:
#line 488 "rygel-media-object.c"
		goto _state_0;
#line 157 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		case 1:
#line 492 "rygel-media-object.c"
		goto _state_1;
		default:
#line 157 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		g_assert_not_reached ();
#line 497 "rygel-media-object.c"
	}
	_state_0:
	{
#line 158 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_data_->_tmp0_ = NULL;
#line 158 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_data_->_tmp0_ = _data_->self->uris;
#line 158 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_data_->_tmp1_ = NULL;
#line 158 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_data_->_tmp1_ = _g_object_ref0 (_data_->_tmp0_);
#line 158 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_data_->_uri_list = _data_->_tmp1_;
#line 158 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_data_->_tmp2_ = NULL;
#line 158 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_data_->_tmp2_ = _data_->_uri_list;
#line 158 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_data_->_tmp3_ = 0;
#line 158 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_data_->_tmp3_ = gee_abstract_collection_get_size ((GeeCollection*) _data_->_tmp2_);
#line 158 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_data_->_tmp4_ = 0;
#line 158 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_data_->_tmp4_ = _data_->_tmp3_;
#line 158 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_data_->_uri_size = _data_->_tmp4_;
#line 158 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_data_->_uri_index = -1;
#line 158 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		while (TRUE) {
#line 158 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			_data_->_tmp5_ = 0;
#line 158 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			_data_->_tmp5_ = _data_->_uri_index;
#line 158 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			_data_->_uri_index = _data_->_tmp5_ + 1;
#line 158 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			_data_->_tmp6_ = 0;
#line 158 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			_data_->_tmp6_ = _data_->_uri_index;
#line 158 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			_data_->_tmp7_ = 0;
#line 158 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			_data_->_tmp7_ = _data_->_uri_size;
#line 158 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			if (!(_data_->_tmp6_ < _data_->_tmp7_)) {
#line 158 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
				break;
#line 547 "rygel-media-object.c"
			}
#line 158 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			_data_->_tmp8_ = NULL;
#line 158 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			_data_->_tmp8_ = _data_->_uri_list;
#line 158 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			_data_->_tmp9_ = 0;
#line 158 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			_data_->_tmp9_ = _data_->_uri_index;
#line 158 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			_data_->_tmp10_ = NULL;
#line 158 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			_data_->_tmp10_ = gee_abstract_list_get ((GeeAbstractList*) _data_->_tmp8_, _data_->_tmp9_);
#line 158 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			_data_->uri = (gchar*) _data_->_tmp10_;
#line 159 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			_data_->_tmp11_ = NULL;
#line 159 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			_data_->_tmp11_ = _data_->uri;
#line 159 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			_data_->_tmp12_ = NULL;
#line 159 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			_data_->_tmp12_ = g_file_new_for_uri (_data_->_tmp11_);
#line 159 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			_data_->file = _data_->_tmp12_;
#line 161 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			_data_->_tmp14_ = NULL;
#line 161 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			_data_->_tmp14_ = _data_->file;
#line 161 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			_data_->_tmp15_ = NULL;
#line 161 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			_data_->_tmp15_ = _data_->cancellable;
#line 161 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			_data_->_state_ = 1;
#line 161 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			rygel_media_object_check_writable (_data_->self, _data_->_tmp14_, _data_->_tmp15_, rygel_media_object_get_writable_ready, _data_);
#line 161 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			return FALSE;
#line 587 "rygel-media-object.c"
			_state_1:
#line 161 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			_data_->_tmp16_ = FALSE;
#line 161 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			_data_->_tmp16_ = rygel_media_object_check_writable_finish (_data_->self, _data_->_res_, &_data_->_inner_error_);
#line 161 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			_data_->_tmp13_ = _data_->_tmp16_;
#line 161 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			if (_data_->_inner_error_ != NULL) {
#line 161 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
				g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 161 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
				g_error_free (_data_->_inner_error_);
#line 161 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
				_g_object_unref0 (_data_->file);
#line 161 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
				_g_free0 (_data_->uri);
#line 161 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
				_g_object_unref0 (_data_->_uri_list);
#line 161 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
				if (_data_->_state_ == 0) {
#line 161 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
					g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 611 "rygel-media-object.c"
				} else {
#line 161 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
					g_simple_async_result_complete (_data_->_async_result);
#line 615 "rygel-media-object.c"
				}
#line 161 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
				g_object_unref (_data_->_async_result);
#line 161 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
				return FALSE;
#line 621 "rygel-media-object.c"
			}
#line 161 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			if (_data_->_tmp13_) {
#line 162 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
				_data_->result = _data_->file;
#line 162 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
				_g_free0 (_data_->uri);
#line 162 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
				_g_object_unref0 (_data_->_uri_list);
#line 162 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
				if (_data_->_state_ == 0) {
#line 162 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
					g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 635 "rygel-media-object.c"
				} else {
#line 162 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
					g_simple_async_result_complete (_data_->_async_result);
#line 639 "rygel-media-object.c"
				}
#line 162 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
				g_object_unref (_data_->_async_result);
#line 162 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
				return FALSE;
#line 645 "rygel-media-object.c"
			}
#line 158 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			_g_object_unref0 (_data_->file);
#line 158 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			_g_free0 (_data_->uri);
#line 651 "rygel-media-object.c"
		}
#line 158 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_g_object_unref0 (_data_->_uri_list);
#line 655 "rygel-media-object.c"
	}
#line 166 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_data_->result = NULL;
#line 166 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	if (_data_->_state_ == 0) {
#line 166 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 663 "rygel-media-object.c"
	} else {
#line 166 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 667 "rygel-media-object.c"
	}
#line 166 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	g_object_unref (_data_->_async_result);
#line 166 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	return FALSE;
#line 157 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	if (_data_->_state_ == 0) {
#line 157 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 677 "rygel-media-object.c"
	} else {
#line 157 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 681 "rygel-media-object.c"
	}
#line 157 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	g_object_unref (_data_->_async_result);
#line 157 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	return FALSE;
#line 687 "rygel-media-object.c"
}


static void rygel_media_object_get_writables_data_free (gpointer _data) {
	RygelMediaObjectGetWritablesData* _data_;
	_data_ = _data;
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_g_object_unref0 (_data_->cancellable);
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_g_object_unref0 (_data_->result);
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_g_object_unref0 (_data_->self);
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	g_slice_free (RygelMediaObjectGetWritablesData, _data_);
#line 702 "rygel-media-object.c"
}


void rygel_media_object_get_writables (RygelMediaObject* self, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelMediaObjectGetWritablesData* _data_;
	RygelMediaObject* _tmp0_ = NULL;
	GCancellable* _tmp1_ = NULL;
	GCancellable* _tmp2_ = NULL;
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_data_ = g_slice_new0 (RygelMediaObjectGetWritablesData);
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_media_object_get_writables);
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_media_object_get_writables_data_free);
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_data_->self = _tmp0_;
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_tmp1_ = cancellable;
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_tmp2_ = _g_object_ref0 (_tmp1_);
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_g_object_unref0 (_data_->cancellable);
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_data_->cancellable = _tmp2_;
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	rygel_media_object_get_writables_co (_data_);
#line 731 "rygel-media-object.c"
}


GeeArrayList* rygel_media_object_get_writables_finish (RygelMediaObject* self, GAsyncResult* _res_, GError** error) {
	GeeArrayList* result;
	RygelMediaObjectGetWritablesData* _data_;
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		return NULL;
#line 742 "rygel-media-object.c"
	}
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	result = _data_->result;
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_data_->result = NULL;
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	return result;
#line 752 "rygel-media-object.c"
}


/**
     * Fetches File objects for all writable URIs available for this object.
     *
     * @param cancellable A GLib.Cancellable
     */
static void rygel_media_object_get_writables_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelMediaObjectGetWritablesData* _data_;
#line 181 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_data_ = _user_data_;
#line 181 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_data_->_source_object_ = source_object;
#line 181 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_data_->_res_ = _res_;
#line 181 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	rygel_media_object_get_writables_co (_data_);
#line 771 "rygel-media-object.c"
}


static gboolean rygel_media_object_get_writables_co (RygelMediaObjectGetWritablesData* _data_) {
#line 174 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	switch (_data_->_state_) {
#line 174 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		case 0:
#line 780 "rygel-media-object.c"
		goto _state_0;
#line 174 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		case 1:
#line 784 "rygel-media-object.c"
		goto _state_1;
		default:
#line 174 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		g_assert_not_reached ();
#line 789 "rygel-media-object.c"
	}
	_state_0:
#line 176 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_data_->_tmp0_ = NULL;
#line 176 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_data_->_tmp0_ = gee_array_list_new (G_TYPE_FILE, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL);
#line 176 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_data_->writables = _data_->_tmp0_;
#line 798 "rygel-media-object.c"
	{
#line 178 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_data_->_tmp1_ = NULL;
#line 178 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_data_->_tmp1_ = _data_->self->uris;
#line 178 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_data_->_tmp2_ = NULL;
#line 178 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_data_->_tmp2_ = _g_object_ref0 (_data_->_tmp1_);
#line 178 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_data_->_uri_list = _data_->_tmp2_;
#line 178 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_data_->_tmp3_ = NULL;
#line 178 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_data_->_tmp3_ = _data_->_uri_list;
#line 178 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_data_->_tmp4_ = 0;
#line 178 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_data_->_tmp4_ = gee_abstract_collection_get_size ((GeeCollection*) _data_->_tmp3_);
#line 178 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_data_->_tmp5_ = 0;
#line 178 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_data_->_tmp5_ = _data_->_tmp4_;
#line 178 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_data_->_uri_size = _data_->_tmp5_;
#line 178 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_data_->_uri_index = -1;
#line 178 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		while (TRUE) {
#line 178 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			_data_->_tmp6_ = 0;
#line 178 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			_data_->_tmp6_ = _data_->_uri_index;
#line 178 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			_data_->_uri_index = _data_->_tmp6_ + 1;
#line 178 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			_data_->_tmp7_ = 0;
#line 178 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			_data_->_tmp7_ = _data_->_uri_index;
#line 178 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			_data_->_tmp8_ = 0;
#line 178 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			_data_->_tmp8_ = _data_->_uri_size;
#line 178 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			if (!(_data_->_tmp7_ < _data_->_tmp8_)) {
#line 178 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
				break;
#line 846 "rygel-media-object.c"
			}
#line 178 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			_data_->_tmp9_ = NULL;
#line 178 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			_data_->_tmp9_ = _data_->_uri_list;
#line 178 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			_data_->_tmp10_ = 0;
#line 178 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			_data_->_tmp10_ = _data_->_uri_index;
#line 178 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			_data_->_tmp11_ = NULL;
#line 178 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			_data_->_tmp11_ = gee_abstract_list_get ((GeeAbstractList*) _data_->_tmp9_, _data_->_tmp10_);
#line 178 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			_data_->uri = (gchar*) _data_->_tmp11_;
#line 179 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			_data_->_tmp12_ = NULL;
#line 179 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			_data_->_tmp12_ = _data_->uri;
#line 179 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			_data_->_tmp13_ = NULL;
#line 179 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			_data_->_tmp13_ = g_file_new_for_uri (_data_->_tmp12_);
#line 179 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			_data_->file = _data_->_tmp13_;
#line 181 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			_data_->_tmp15_ = NULL;
#line 181 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			_data_->_tmp15_ = _data_->file;
#line 181 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			_data_->_tmp16_ = NULL;
#line 181 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			_data_->_tmp16_ = _data_->cancellable;
#line 181 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			_data_->_state_ = 1;
#line 181 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			rygel_media_object_check_writable (_data_->self, _data_->_tmp15_, _data_->_tmp16_, rygel_media_object_get_writables_ready, _data_);
#line 181 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			return FALSE;
#line 886 "rygel-media-object.c"
			_state_1:
#line 181 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			_data_->_tmp17_ = FALSE;
#line 181 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			_data_->_tmp17_ = rygel_media_object_check_writable_finish (_data_->self, _data_->_res_, &_data_->_inner_error_);
#line 181 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			_data_->_tmp14_ = _data_->_tmp17_;
#line 181 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			if (_data_->_inner_error_ != NULL) {
#line 181 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
				g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 181 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
				g_error_free (_data_->_inner_error_);
#line 181 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
				_g_object_unref0 (_data_->file);
#line 181 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
				_g_free0 (_data_->uri);
#line 181 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
				_g_object_unref0 (_data_->_uri_list);
#line 181 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
				_g_object_unref0 (_data_->writables);
#line 181 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
				if (_data_->_state_ == 0) {
#line 181 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
					g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 912 "rygel-media-object.c"
				} else {
#line 181 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
					g_simple_async_result_complete (_data_->_async_result);
#line 916 "rygel-media-object.c"
				}
#line 181 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
				g_object_unref (_data_->_async_result);
#line 181 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
				return FALSE;
#line 922 "rygel-media-object.c"
			}
#line 181 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			if (_data_->_tmp14_) {
#line 182 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
				_data_->_tmp18_ = NULL;
#line 182 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
				_data_->_tmp18_ = _data_->writables;
#line 182 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
				_data_->_tmp19_ = NULL;
#line 182 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
				_data_->_tmp19_ = _data_->file;
#line 182 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
				gee_abstract_collection_add ((GeeAbstractCollection*) _data_->_tmp18_, _data_->_tmp19_);
#line 936 "rygel-media-object.c"
			}
#line 178 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			_g_object_unref0 (_data_->file);
#line 178 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			_g_free0 (_data_->uri);
#line 942 "rygel-media-object.c"
		}
#line 178 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_g_object_unref0 (_data_->_uri_list);
#line 946 "rygel-media-object.c"
	}
#line 186 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_data_->result = _data_->writables;
#line 186 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	if (_data_->_state_ == 0) {
#line 186 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 954 "rygel-media-object.c"
	} else {
#line 186 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 958 "rygel-media-object.c"
	}
#line 186 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	g_object_unref (_data_->_async_result);
#line 186 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	return FALSE;
#line 174 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_g_object_unref0 (_data_->writables);
#line 174 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	if (_data_->_state_ == 0) {
#line 174 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 970 "rygel-media-object.c"
	} else {
#line 174 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 974 "rygel-media-object.c"
	}
#line 174 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	g_object_unref (_data_->_async_result);
#line 174 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	return FALSE;
#line 980 "rygel-media-object.c"
}


static GUPnPDIDLLiteObject* rygel_media_object_real_serialize (RygelMediaObject* self, RygelSerializer* serializer, RygelHTTPServer* http_server, GError** error) {
#line 189 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	g_critical ("Type `%s' does not implement abstract method `rygel_media_object_serialize'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
#line 189 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	return NULL;
#line 989 "rygel-media-object.c"
}


GUPnPDIDLLiteObject* rygel_media_object_serialize (RygelMediaObject* self, RygelSerializer* serializer, RygelHTTPServer* http_server, GError** error) {
#line 189 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 189 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	return RYGEL_MEDIA_OBJECT_GET_CLASS (self)->serialize (self, serializer, http_server, error);
#line 998 "rygel-media-object.c"
}


static void rygel_media_object_real_apply_didl_lite (RygelMediaObject* self, GUPnPDIDLLiteObject* didl_object) {
	GUPnPDIDLLiteObject* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
#line 193 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	g_return_if_fail (didl_object != NULL);
#line 194 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_tmp0_ = didl_object;
#line 194 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_tmp1_ = gupnp_didl_lite_object_get_title (_tmp0_);
#line 194 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_tmp2_ = _tmp1_;
#line 194 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	rygel_media_object_set_title (self, _tmp2_);
#line 1016 "rygel-media-object.c"
}


void rygel_media_object_apply_didl_lite (RygelMediaObject* self, GUPnPDIDLLiteObject* didl_object) {
#line 193 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	g_return_if_fail (self != NULL);
#line 193 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	RYGEL_MEDIA_OBJECT_GET_CLASS (self)->apply_didl_lite (self, didl_object);
#line 1025 "rygel-media-object.c"
}


static void rygel_media_object_clean_node (RygelMediaObject* self, xmlNode* node, xmlNs* ns) {
	GeeArrayList* list = NULL;
	GeeArrayList* _tmp0_ = NULL;
	xmlAttr* attr = NULL;
	xmlNode* _tmp1_ = NULL;
	xmlAttr* _tmp2_ = NULL;
	xmlNode* child = NULL;
	xmlNode* _tmp26_ = NULL;
	xmlNode* _tmp27_ = NULL;
#line 198 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	g_return_if_fail (self != NULL);
#line 199 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_tmp0_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL, NULL);
#line 199 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	list = _tmp0_;
#line 200 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_tmp1_ = node;
#line 200 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_tmp2_ = _tmp1_->properties;
#line 200 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	attr = _tmp2_;
#line 201 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	while (TRUE) {
#line 1052 "rygel-media-object.c"
		xmlAttr* _tmp3_ = NULL;
		xmlAttr* _tmp4_ = NULL;
		xmlNs* _tmp5_ = NULL;
		xmlNs* _tmp6_ = NULL;
		xmlAttr* _tmp10_ = NULL;
		xmlAttr* _tmp11_ = NULL;
#line 201 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_tmp3_ = attr;
#line 201 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		if (!(_tmp3_ != NULL)) {
#line 201 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			break;
#line 1065 "rygel-media-object.c"
		}
#line 202 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_tmp4_ = attr;
#line 202 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_tmp5_ = _tmp4_->ns;
#line 202 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_tmp6_ = ns;
#line 202 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		if (_tmp5_ == _tmp6_) {
#line 1075 "rygel-media-object.c"
			GeeArrayList* _tmp7_ = NULL;
			xmlAttr* _tmp8_ = NULL;
			const gchar* _tmp9_ = NULL;
#line 203 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			_tmp7_ = list;
#line 203 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			_tmp8_ = attr;
#line 203 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			_tmp9_ = _tmp8_->name;
#line 203 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp7_, _tmp9_);
#line 1087 "rygel-media-object.c"
		}
#line 206 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_tmp10_ = attr;
#line 206 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_tmp11_ = _tmp10_->next;
#line 206 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		attr = _tmp11_;
#line 1095 "rygel-media-object.c"
	}
	{
		GeeArrayList* _name_list = NULL;
		GeeArrayList* _tmp12_ = NULL;
		GeeArrayList* _tmp13_ = NULL;
		gint _name_size = 0;
		GeeArrayList* _tmp14_ = NULL;
		gint _tmp15_ = 0;
		gint _tmp16_ = 0;
		gint _name_index = 0;
#line 209 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_tmp12_ = list;
#line 209 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_tmp13_ = _g_object_ref0 (_tmp12_);
#line 209 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_name_list = _tmp13_;
#line 209 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_tmp14_ = _name_list;
#line 209 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_tmp15_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp14_);
#line 209 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_tmp16_ = _tmp15_;
#line 209 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_name_size = _tmp16_;
#line 209 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_name_index = -1;
#line 209 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		while (TRUE) {
#line 1124 "rygel-media-object.c"
			gint _tmp17_ = 0;
			gint _tmp18_ = 0;
			gint _tmp19_ = 0;
			gchar* name = NULL;
			GeeArrayList* _tmp20_ = NULL;
			gint _tmp21_ = 0;
			gpointer _tmp22_ = NULL;
			xmlNode* _tmp23_ = NULL;
			xmlNs* _tmp24_ = NULL;
			const gchar* _tmp25_ = NULL;
#line 209 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			_tmp17_ = _name_index;
#line 209 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			_name_index = _tmp17_ + 1;
#line 209 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			_tmp18_ = _name_index;
#line 209 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			_tmp19_ = _name_size;
#line 209 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			if (!(_tmp18_ < _tmp19_)) {
#line 209 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
				break;
#line 1147 "rygel-media-object.c"
			}
#line 209 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			_tmp20_ = _name_list;
#line 209 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			_tmp21_ = _name_index;
#line 209 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			_tmp22_ = gee_abstract_list_get ((GeeAbstractList*) _tmp20_, _tmp21_);
#line 209 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			name = (gchar*) _tmp22_;
#line 210 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			_tmp23_ = node;
#line 210 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			_tmp24_ = ns;
#line 210 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			_tmp25_ = name;
#line 210 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			xmlUnsetNsProp (_tmp23_, _tmp24_, _tmp25_);
#line 209 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			_g_free0 (name);
#line 1167 "rygel-media-object.c"
		}
#line 209 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_g_object_unref0 (_name_list);
#line 1171 "rygel-media-object.c"
	}
#line 213 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_tmp26_ = node;
#line 213 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_tmp27_ = _tmp26_->children;
#line 213 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	child = _tmp27_;
#line 214 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	while (TRUE) {
#line 1181 "rygel-media-object.c"
		xmlNode* _tmp28_ = NULL;
		xmlNode* _tmp29_ = NULL;
		xmlNs* _tmp30_ = NULL;
		xmlNode* _tmp31_ = NULL;
		xmlNode* _tmp32_ = NULL;
#line 214 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_tmp28_ = child;
#line 214 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		if (!(_tmp28_ != NULL)) {
#line 214 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			break;
#line 1193 "rygel-media-object.c"
		}
#line 215 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_tmp29_ = child;
#line 215 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_tmp30_ = ns;
#line 215 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		rygel_media_object_clean_node (self, _tmp29_, _tmp30_);
#line 216 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_tmp31_ = child;
#line 216 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_tmp32_ = _tmp31_->next;
#line 216 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		child = _tmp32_;
#line 1207 "rygel-media-object.c"
	}
#line 198 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_g_object_unref0 (list);
#line 1211 "rygel-media-object.c"
}


static void rygel_media_object_apply_fragments_data_free (gpointer _data) {
	RygelMediaObjectApplyFragmentsData* _data_;
	_data_ = _data;
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_g_object_unref0 (_data_->current_fragments);
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_g_object_unref0 (_data_->new_fragments);
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_g_object_unref0 (_data_->http_server);
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_g_object_unref0 (_data_->self);
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	g_slice_free (RygelMediaObjectApplyFragmentsData, _data_);
#line 1228 "rygel-media-object.c"
}


void rygel_media_object_apply_fragments (RygelMediaObject* self, GeeLinkedList* current_fragments, GeeLinkedList* new_fragments, RygelHTTPServer* http_server, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelMediaObjectApplyFragmentsData* _data_;
	RygelMediaObject* _tmp0_ = NULL;
	GeeLinkedList* _tmp1_ = NULL;
	GeeLinkedList* _tmp2_ = NULL;
	GeeLinkedList* _tmp3_ = NULL;
	GeeLinkedList* _tmp4_ = NULL;
	RygelHTTPServer* _tmp5_ = NULL;
	RygelHTTPServer* _tmp6_ = NULL;
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_data_ = g_slice_new0 (RygelMediaObjectApplyFragmentsData);
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_media_object_apply_fragments);
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_media_object_apply_fragments_data_free);
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_data_->self = _tmp0_;
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_tmp1_ = current_fragments;
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_tmp2_ = _g_object_ref0 (_tmp1_);
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_g_object_unref0 (_data_->current_fragments);
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_data_->current_fragments = _tmp2_;
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_tmp3_ = new_fragments;
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_tmp4_ = _g_object_ref0 (_tmp3_);
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_g_object_unref0 (_data_->new_fragments);
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_data_->new_fragments = _tmp4_;
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_tmp5_ = http_server;
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_tmp6_ = _g_object_ref0 (_tmp5_);
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_g_object_unref0 (_data_->http_server);
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_data_->http_server = _tmp6_;
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	rygel_media_object_apply_fragments_co (_data_);
#line 1277 "rygel-media-object.c"
}


GUPnPDIDLLiteFragmentResult rygel_media_object_apply_fragments_finish (RygelMediaObject* self, GAsyncResult* _res_) {
	GUPnPDIDLLiteFragmentResult result;
	RygelMediaObjectApplyFragmentsData* _data_;
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	result = _data_->result;
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	return result;
#line 1290 "rygel-media-object.c"
}


static void rygel_media_object_apply_fragments_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelMediaObjectApplyFragmentsData* _data_;
#line 242 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_data_ = _user_data_;
#line 242 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_data_->_source_object_ = source_object;
#line 242 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_data_->_res_ = _res_;
#line 242 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	rygel_media_object_apply_fragments_co (_data_);
#line 1304 "rygel-media-object.c"
}


static gboolean rygel_media_object_apply_fragments_co (RygelMediaObjectApplyFragmentsData* _data_) {
#line 220 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	switch (_data_->_state_) {
#line 220 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		case 0:
#line 1313 "rygel-media-object.c"
		goto _state_0;
#line 220 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		case 1:
#line 1317 "rygel-media-object.c"
		goto _state_1;
		default:
#line 220 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		g_assert_not_reached ();
#line 1322 "rygel-media-object.c"
	}
	_state_0:
#line 224 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_data_->_result_ = GUPNP_DIDL_LITE_FRAGMENT_RESULT_UNKNOWN_ERROR;
#line 1327 "rygel-media-object.c"
	{
#line 227 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_data_->_tmp0_ = NULL;
#line 227 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_data_->_tmp0_ = rygel_serializer_new (SERIALIZER_TYPE_GENERIC_DIDL);
#line 227 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_data_->writer = _data_->_tmp0_;
#line 228 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_data_->_tmp1_ = NULL;
#line 228 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_data_->_tmp1_ = _data_->writer;
#line 228 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_data_->_tmp2_ = NULL;
#line 228 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_data_->_tmp2_ = _data_->http_server;
#line 228 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_data_->_tmp3_ = NULL;
#line 228 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_data_->_tmp3_ = rygel_media_object_serialize (_data_->self, _data_->_tmp1_, _data_->_tmp2_, &_data_->_inner_error_);
#line 228 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_data_->didl_object = _data_->_tmp3_;
#line 228 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		if (_data_->_inner_error_ != NULL) {
#line 228 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			_g_object_unref0 (_data_->writer);
#line 1353 "rygel-media-object.c"
			goto __catch10_g_error;
		}
#line 232 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_data_->_tmp4_ = NULL;
#line 232 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_data_->_tmp4_ = _data_->didl_object;
#line 232 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_data_->_tmp5_ = NULL;
#line 232 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_data_->_tmp5_ = gupnp_didl_lite_object_get_xml_node (_data_->_tmp4_);
#line 232 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_data_->_tmp6_ = NULL;
#line 232 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_data_->_tmp6_ = _data_->_tmp5_;
#line 232 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_data_->_tmp7_ = NULL;
#line 232 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_data_->_tmp7_ = _data_->didl_object;
#line 232 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_data_->_tmp8_ = NULL;
#line 232 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_data_->_tmp8_ = gupnp_didl_lite_object_get_dlna_namespace (_data_->_tmp7_);
#line 232 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_data_->_tmp9_ = NULL;
#line 232 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_data_->_tmp9_ = _data_->_tmp8_;
#line 232 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		rygel_media_object_clean_node (_data_->self, _data_->_tmp6_, _data_->_tmp9_);
#line 235 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_data_->_tmp10_ = NULL;
#line 235 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_data_->_tmp10_ = _data_->didl_object;
#line 235 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_data_->_tmp11_ = NULL;
#line 235 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_data_->_tmp11_ = _data_->current_fragments;
#line 235 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_data_->_tmp12_ = 0;
#line 235 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_data_->_tmp13_ = NULL;
#line 235 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_data_->_tmp13_ = gee_collection_to_array ((GeeCollection*) _data_->_tmp11_, &_data_->_tmp12_);
#line 235 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_data_->_tmp14_ = NULL;
#line 235 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_data_->_tmp14__length1 = 0;
#line 235 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_data_->_tmp14_ = _data_->_tmp13_;
#line 235 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_data_->_tmp14__length1 = _data_->_tmp12_;
#line 235 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_data_->_tmp15_ = NULL;
#line 235 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_data_->_tmp15_ = _data_->new_fragments;
#line 235 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_data_->_tmp16_ = 0;
#line 235 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_data_->_tmp17_ = NULL;
#line 235 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_data_->_tmp17_ = gee_collection_to_array ((GeeCollection*) _data_->_tmp15_, &_data_->_tmp16_);
#line 235 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_data_->_tmp18_ = NULL;
#line 235 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_data_->_tmp18__length1 = 0;
#line 235 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_data_->_tmp18_ = _data_->_tmp17_;
#line 235 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_data_->_tmp18__length1 = _data_->_tmp16_;
#line 235 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_data_->_tmp19_ = 0;
#line 235 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_data_->_tmp19_ = gupnp_didl_lite_object_apply_fragments (_data_->_tmp10_, _data_->_tmp14_, _data_->_tmp12_, _data_->_tmp18_, _data_->_tmp16_);
#line 235 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_data_->_result_ = _data_->_tmp19_;
#line 235 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_data_->_tmp18_ = (_vala_array_free (_data_->_tmp18_, _data_->_tmp18__length1, (GDestroyNotify) g_free), NULL);
#line 235 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_data_->_tmp14_ = (_vala_array_free (_data_->_tmp14_, _data_->_tmp14__length1, (GDestroyNotify) g_free), NULL);
#line 239 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_data_->_tmp20_ = 0;
#line 239 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_data_->_tmp20_ = _data_->_result_;
#line 239 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		if (_data_->_tmp20_ == GUPNP_DIDL_LITE_FRAGMENT_RESULT_OK) {
#line 240 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			_data_->_tmp21_ = NULL;
#line 240 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			_data_->_tmp21_ = _data_->didl_object;
#line 240 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			rygel_media_object_apply_didl_lite (_data_->self, _data_->_tmp21_);
#line 241 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			if (G_TYPE_CHECK_INSTANCE_TYPE (_data_->self, RYGEL_TYPE_UPDATABLE_OBJECT)) {
#line 242 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
				_data_->_state_ = 1;
#line 242 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
				rygel_updatable_object_commit (G_TYPE_CHECK_INSTANCE_TYPE (_data_->self, RYGEL_TYPE_UPDATABLE_OBJECT) ? ((RygelUpdatableObject*) _data_->self) : NULL, rygel_media_object_apply_fragments_ready, _data_);
#line 242 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
				return FALSE;
#line 1452 "rygel-media-object.c"
				_state_1:
#line 242 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
				rygel_updatable_object_commit_finish (G_TYPE_CHECK_INSTANCE_TYPE (_data_->self, RYGEL_TYPE_UPDATABLE_OBJECT) ? ((RygelUpdatableObject*) _data_->self) : NULL, _data_->_res_, &_data_->_inner_error_);
#line 242 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
				if (_data_->_inner_error_ != NULL) {
#line 242 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
					_g_object_unref0 (_data_->didl_object);
#line 242 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
					_g_object_unref0 (_data_->writer);
#line 1462 "rygel-media-object.c"
					goto __catch10_g_error;
				}
			}
		}
#line 226 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_g_object_unref0 (_data_->didl_object);
#line 226 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_g_object_unref0 (_data_->writer);
#line 1471 "rygel-media-object.c"
	}
	goto __finally10;
	__catch10_g_error:
	{
#line 226 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_data_->e = _data_->_inner_error_;
#line 226 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_data_->_inner_error_ = NULL;
#line 226 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_g_error_free0 (_data_->e);
#line 1482 "rygel-media-object.c"
	}
	__finally10:
#line 226 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	if (_data_->_inner_error_ != NULL) {
#line 226 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
#line 226 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		g_clear_error (&_data_->_inner_error_);
#line 226 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		return FALSE;
#line 1493 "rygel-media-object.c"
	}
#line 248 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_data_->result = _data_->_result_;
#line 248 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	if (_data_->_state_ == 0) {
#line 248 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1501 "rygel-media-object.c"
	} else {
#line 248 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 1505 "rygel-media-object.c"
	}
#line 248 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	g_object_unref (_data_->_async_result);
#line 248 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	return FALSE;
#line 220 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	if (_data_->_state_ == 0) {
#line 220 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1515 "rygel-media-object.c"
	} else {
#line 220 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 1519 "rygel-media-object.c"
	}
#line 220 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	g_object_unref (_data_->_async_result);
#line 220 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	return FALSE;
#line 1525 "rygel-media-object.c"
}


static gint rygel_media_object_real_compare_by_property (RygelMediaObject* self, RygelMediaObject* media_object, const gchar* property) {
	gint result = 0;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	GQuark _tmp3_ = 0U;
#line 253 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	static GQuark _tmp2_label0 = 0;
#line 253 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	static GQuark _tmp2_label1 = 0;
#line 253 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	static GQuark _tmp2_label2 = 0;
#line 253 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	static GQuark _tmp2_label3 = 0;
#line 251 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	g_return_val_if_fail (media_object != NULL, 0);
#line 251 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	g_return_val_if_fail (property != NULL, 0);
#line 253 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_tmp0_ = property;
#line 253 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_tmp1_ = _tmp0_;
#line 253 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_tmp3_ = (NULL == _tmp1_) ? 0 : g_quark_from_string (_tmp1_);
#line 253 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	if (_tmp3_ == ((0 != _tmp2_label0) ? _tmp2_label0 : (_tmp2_label0 = g_quark_from_static_string ("@id")))) {
#line 253 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		switch (0) {
#line 1556 "rygel-media-object.c"
			default:
			{
				const gchar* _tmp4_ = NULL;
				RygelMediaObject* _tmp5_ = NULL;
				const gchar* _tmp6_ = NULL;
				gint _tmp7_ = 0;
#line 255 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
				_tmp4_ = self->priv->_id;
#line 255 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
				_tmp5_ = media_object;
#line 255 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
				_tmp6_ = _tmp5_->priv->_id;
#line 255 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
				_tmp7_ = rygel_media_object_compare_string_props (self, _tmp4_, _tmp6_);
#line 255 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
				result = _tmp7_;
#line 255 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
				return result;
#line 1575 "rygel-media-object.c"
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label1) ? _tmp2_label1 : (_tmp2_label1 = g_quark_from_static_string ("@parentID")))) {
#line 253 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		switch (0) {
#line 1581 "rygel-media-object.c"
			default:
			{
				RygelMediaContainer* _tmp8_ = NULL;
				RygelMediaContainer* _tmp9_ = NULL;
				const gchar* _tmp10_ = NULL;
				RygelMediaObject* _tmp11_ = NULL;
				RygelMediaContainer* _tmp12_ = NULL;
				RygelMediaContainer* _tmp13_ = NULL;
				const gchar* _tmp14_ = NULL;
				gint _tmp15_ = 0;
#line 257 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
				_tmp8_ = rygel_media_object_get_parent (self);
#line 257 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
				_tmp9_ = _tmp8_;
#line 257 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
				_tmp10_ = ((RygelMediaObject*) _tmp9_)->priv->_id;
#line 257 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
				_tmp11_ = media_object;
#line 257 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
				_tmp12_ = rygel_media_object_get_parent (_tmp11_);
#line 257 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
				_tmp13_ = _tmp12_;
#line 257 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
				_tmp14_ = ((RygelMediaObject*) _tmp13_)->priv->_id;
#line 257 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
				_tmp15_ = rygel_media_object_compare_string_props (self, _tmp10_, _tmp14_);
#line 257 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
				result = _tmp15_;
#line 257 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
				return result;
#line 1612 "rygel-media-object.c"
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label2) ? _tmp2_label2 : (_tmp2_label2 = g_quark_from_static_string ("dc:title")))) {
#line 253 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		switch (0) {
#line 1618 "rygel-media-object.c"
			default:
			{
				const gchar* _tmp16_ = NULL;
				const gchar* _tmp17_ = NULL;
				RygelMediaObject* _tmp18_ = NULL;
				const gchar* _tmp19_ = NULL;
				const gchar* _tmp20_ = NULL;
				gint _tmp21_ = 0;
#line 260 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
				_tmp16_ = rygel_media_object_get_title (self);
#line 260 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
				_tmp17_ = _tmp16_;
#line 260 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
				_tmp18_ = media_object;
#line 260 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
				_tmp19_ = rygel_media_object_get_title (_tmp18_);
#line 260 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
				_tmp20_ = _tmp19_;
#line 260 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
				_tmp21_ = rygel_media_object_compare_string_props (self, _tmp17_, _tmp20_);
#line 260 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
				result = _tmp21_;
#line 260 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
				return result;
#line 1643 "rygel-media-object.c"
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label3) ? _tmp2_label3 : (_tmp2_label3 = g_quark_from_static_string ("upnp:class")))) {
#line 253 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		switch (0) {
#line 1649 "rygel-media-object.c"
			default:
			{
				const gchar* _tmp22_ = NULL;
				RygelMediaObject* _tmp23_ = NULL;
				const gchar* _tmp24_ = NULL;
				gint _tmp25_ = 0;
#line 262 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
				_tmp22_ = self->priv->_upnp_class;
#line 262 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
				_tmp23_ = media_object;
#line 262 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
				_tmp24_ = _tmp23_->priv->_upnp_class;
#line 262 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
				_tmp25_ = rygel_media_object_compare_string_props (self, _tmp22_, _tmp24_);
#line 262 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
				result = _tmp25_;
#line 262 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
				return result;
#line 1668 "rygel-media-object.c"
			}
		}
	} else {
#line 253 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		switch (0) {
#line 1674 "rygel-media-object.c"
			default:
			{
#line 265 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
				result = 0;
#line 265 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
				return result;
#line 1681 "rygel-media-object.c"
			}
		}
	}
}


gint rygel_media_object_compare_by_property (RygelMediaObject* self, RygelMediaObject* media_object, const gchar* property) {
#line 251 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 251 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	return RYGEL_MEDIA_OBJECT_GET_CLASS (self)->compare_by_property (self, media_object, property);
#line 1693 "rygel-media-object.c"
}


gint rygel_media_object_compare_string_props (RygelMediaObject* self, const gchar* prop1, const gchar* prop2) {
	gint result = 0;
	const gchar* _tmp0_ = NULL;
#line 269 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 269 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	g_return_val_if_fail (prop1 != NULL, 0);
#line 269 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	g_return_val_if_fail (prop2 != NULL, 0);
#line 270 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_tmp0_ = prop1;
#line 270 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	if (_tmp0_ == NULL) {
#line 271 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		result = -1;
#line 271 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		return result;
#line 1714 "rygel-media-object.c"
	} else {
		const gchar* _tmp1_ = NULL;
#line 272 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_tmp1_ = prop2;
#line 272 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		if (_tmp1_ == NULL) {
#line 273 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			result = 1;
#line 273 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			return result;
#line 1725 "rygel-media-object.c"
		} else {
			const gchar* _tmp2_ = NULL;
			const gchar* _tmp3_ = NULL;
			gint _tmp4_ = 0;
#line 275 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			_tmp2_ = prop1;
#line 275 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			_tmp3_ = prop2;
#line 275 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			_tmp4_ = g_utf8_collate (_tmp2_, _tmp3_);
#line 275 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			result = _tmp4_;
#line 275 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			return result;
#line 1740 "rygel-media-object.c"
		}
	}
}


static GUPnPDIDLLiteResource* rygel_media_object_real_add_resource (RygelMediaObject* self, GUPnPDIDLLiteObject* object, const gchar* uri, const gchar* protocol, const gchar* import_uri, GError** error) {
	GUPnPDIDLLiteResource* result = NULL;
	GUPnPDIDLLiteResource* res = NULL;
	GUPnPDIDLLiteObject* _tmp0_ = NULL;
	GUPnPDIDLLiteResource* _tmp1_ = NULL;
#line 279 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	g_return_val_if_fail (object != NULL, NULL);
#line 279 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	g_return_val_if_fail (protocol != NULL, NULL);
#line 285 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_tmp0_ = object;
#line 285 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_tmp1_ = gupnp_didl_lite_object_add_resource (_tmp0_);
#line 285 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	res = _tmp1_;
#line 287 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	result = res;
#line 287 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	return result;
#line 1765 "rygel-media-object.c"
}


GUPnPDIDLLiteResource* rygel_media_object_add_resource (RygelMediaObject* self, GUPnPDIDLLiteObject* object, const gchar* uri, const gchar* protocol, const gchar* import_uri, GError** error) {
#line 279 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 279 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	return RYGEL_MEDIA_OBJECT_GET_CLASS (self)->add_resource (self, object, uri, protocol, import_uri, error);
#line 1774 "rygel-media-object.c"
}


gint rygel_media_object_compare_int_props (RygelMediaObject* self, gint prop1, gint prop2) {
	gint result = 0;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
#line 290 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 291 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_tmp0_ = prop1;
#line 291 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_tmp1_ = prop2;
#line 291 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_tmp2_ = CLAMP (_tmp0_ - _tmp1_, -1, 1);
#line 291 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	result = _tmp2_;
#line 291 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	return result;
#line 1795 "rygel-media-object.c"
}


static void rygel_media_object_check_writable_data_free (gpointer _data) {
	RygelMediaObjectCheckWritableData* _data_;
	_data_ = _data;
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_g_object_unref0 (_data_->file);
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_g_object_unref0 (_data_->cancellable);
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_g_object_unref0 (_data_->self);
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	g_slice_free (RygelMediaObjectCheckWritableData, _data_);
#line 1810 "rygel-media-object.c"
}


static void rygel_media_object_check_writable (RygelMediaObject* self, GFile* file, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelMediaObjectCheckWritableData* _data_;
	RygelMediaObject* _tmp0_ = NULL;
	GFile* _tmp1_ = NULL;
	GFile* _tmp2_ = NULL;
	GCancellable* _tmp3_ = NULL;
	GCancellable* _tmp4_ = NULL;
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_data_ = g_slice_new0 (RygelMediaObjectCheckWritableData);
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_media_object_check_writable);
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_media_object_check_writable_data_free);
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_data_->self = _tmp0_;
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_tmp1_ = file;
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_tmp2_ = _g_object_ref0 (_tmp1_);
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_g_object_unref0 (_data_->file);
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_data_->file = _tmp2_;
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_tmp3_ = cancellable;
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_tmp4_ = _g_object_ref0 (_tmp3_);
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_g_object_unref0 (_data_->cancellable);
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_data_->cancellable = _tmp4_;
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	rygel_media_object_check_writable_co (_data_);
#line 1849 "rygel-media-object.c"
}


static gboolean rygel_media_object_check_writable_finish (RygelMediaObject* self, GAsyncResult* _res_, GError** error) {
	gboolean result;
	RygelMediaObjectCheckWritableData* _data_;
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		return FALSE;
#line 1860 "rygel-media-object.c"
	}
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	result = _data_->result;
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	return result;
#line 1868 "rygel-media-object.c"
}


static void rygel_media_object_check_writable_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelMediaObjectCheckWritableData* _data_;
#line 308 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_data_ = _user_data_;
#line 308 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_data_->_source_object_ = source_object;
#line 308 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_data_->_res_ = _res_;
#line 308 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	rygel_media_object_check_writable_co (_data_);
#line 1882 "rygel-media-object.c"
}


static gboolean rygel_media_object_check_writable_co (RygelMediaObjectCheckWritableData* _data_) {
#line 294 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	switch (_data_->_state_) {
#line 294 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		case 0:
#line 1891 "rygel-media-object.c"
		goto _state_0;
#line 294 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		case 1:
#line 1895 "rygel-media-object.c"
		goto _state_1;
		default:
#line 294 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		g_assert_not_reached ();
#line 1900 "rygel-media-object.c"
	}
	_state_0:
#line 298 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_data_->_tmp0_ = NULL;
#line 298 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_data_->_tmp0_ = _data_->file;
#line 298 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_data_->_tmp1_ = NULL;
#line 298 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_data_->_tmp1_ = g_file_get_uri_scheme (_data_->_tmp0_);
#line 298 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_data_->_tmp2_ = NULL;
#line 298 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_data_->_tmp2_ = _data_->_tmp1_;
#line 298 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_data_->_tmp3_ = FALSE;
#line 298 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_data_->_tmp3_ = g_str_has_prefix (RYGEL_WRITABLE_CONTAINER_WRITABLE_SCHEME, _data_->_tmp2_);
#line 298 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_data_->_tmp4_ = FALSE;
#line 298 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_data_->_tmp4_ = _data_->_tmp3_;
#line 298 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_g_free0 (_data_->_tmp2_);
#line 298 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	if (_data_->_tmp4_) {
#line 300 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_data_->result = TRUE;
#line 300 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		if (_data_->_state_ == 0) {
#line 300 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1933 "rygel-media-object.c"
		} else {
#line 300 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 1937 "rygel-media-object.c"
		}
#line 300 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		g_object_unref (_data_->_async_result);
#line 300 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		return FALSE;
#line 1943 "rygel-media-object.c"
	}
#line 303 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_data_->_tmp5_ = NULL;
#line 303 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_data_->_tmp5_ = _data_->file;
#line 303 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_data_->_tmp6_ = FALSE;
#line 303 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_data_->_tmp6_ = g_file_is_native (_data_->_tmp5_);
#line 303 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	if (!_data_->_tmp6_) {
#line 304 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_data_->result = FALSE;
#line 304 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		if (_data_->_state_ == 0) {
#line 304 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1961 "rygel-media-object.c"
		} else {
#line 304 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 1965 "rygel-media-object.c"
		}
#line 304 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		g_object_unref (_data_->_async_result);
#line 304 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		return FALSE;
#line 1971 "rygel-media-object.c"
	}
	{
#line 308 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_data_->_tmp7_ = NULL;
#line 308 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_data_->_tmp7_ = _data_->file;
#line 308 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_data_->_tmp8_ = NULL;
#line 308 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_data_->_tmp8_ = _data_->cancellable;
#line 308 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_data_->_state_ = 1;
#line 308 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		g_file_query_info_async (_data_->_tmp7_, G_FILE_ATTRIBUTE_ACCESS_CAN_WRITE, G_FILE_QUERY_INFO_NONE, G_PRIORITY_DEFAULT, _data_->_tmp8_, rygel_media_object_check_writable_ready, _data_);
#line 308 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		return FALSE;
#line 1988 "rygel-media-object.c"
		_state_1:
#line 308 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_data_->_tmp9_ = NULL;
#line 308 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_data_->_tmp9_ = g_file_query_info_finish (_data_->_tmp7_, _data_->_res_, &_data_->_inner_error_);
#line 308 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_data_->info = _data_->_tmp9_;
#line 308 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		if (_data_->_inner_error_ != NULL) {
#line 308 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			if (g_error_matches (_data_->_inner_error_, G_IO_ERROR, G_IO_ERROR_NOT_FOUND)) {
#line 2000 "rygel-media-object.c"
				goto __catch11_g_io_error_not_found;
			}
			goto __finally11;
		}
#line 314 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_data_->_tmp10_ = NULL;
#line 314 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_data_->_tmp10_ = _data_->info;
#line 314 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_data_->_tmp11_ = FALSE;
#line 314 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_data_->_tmp11_ = g_file_info_get_attribute_boolean (_data_->_tmp10_, G_FILE_ATTRIBUTE_ACCESS_CAN_WRITE);
#line 314 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_data_->result = _data_->_tmp11_;
#line 314 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_g_object_unref0 (_data_->info);
#line 314 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		if (_data_->_state_ == 0) {
#line 314 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 2021 "rygel-media-object.c"
		} else {
#line 314 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 2025 "rygel-media-object.c"
		}
#line 314 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		g_object_unref (_data_->_async_result);
#line 314 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		return FALSE;
#line 2031 "rygel-media-object.c"
	}
	goto __finally11;
	__catch11_g_io_error_not_found:
	{
#line 307 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_data_->_error_ = _data_->_inner_error_;
#line 307 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_data_->_inner_error_ = NULL;
#line 316 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_data_->result = TRUE;
#line 316 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_g_error_free0 (_data_->_error_);
#line 316 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		if (_data_->_state_ == 0) {
#line 316 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 2048 "rygel-media-object.c"
		} else {
#line 316 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 2052 "rygel-media-object.c"
		}
#line 316 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		g_object_unref (_data_->_async_result);
#line 316 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		return FALSE;
#line 2058 "rygel-media-object.c"
	}
	__finally11:
#line 307 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 307 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	g_error_free (_data_->_inner_error_);
#line 307 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	if (_data_->_state_ == 0) {
#line 307 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 2069 "rygel-media-object.c"
	} else {
#line 307 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 2073 "rygel-media-object.c"
	}
#line 307 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	g_object_unref (_data_->_async_result);
#line 307 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	return FALSE;
#line 294 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	if (_data_->_state_ == 0) {
#line 294 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 2083 "rygel-media-object.c"
	} else {
#line 294 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 2087 "rygel-media-object.c"
	}
#line 294 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	g_object_unref (_data_->_async_result);
#line 294 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	return FALSE;
#line 2093 "rygel-media-object.c"
}


RygelMediaObject* rygel_media_object_construct (GType object_type) {
	RygelMediaObject * self = NULL;
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	self = (RygelMediaObject*) g_object_new (object_type, NULL);
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	return self;
#line 2103 "rygel-media-object.c"
}


const gchar* rygel_media_object_get_id (RygelMediaObject* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
#line 41 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 41 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_tmp0_ = self->priv->_id;
#line 41 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	result = _tmp0_;
#line 41 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	return result;
#line 2118 "rygel-media-object.c"
}


void rygel_media_object_set_id (RygelMediaObject* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
#line 41 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	g_return_if_fail (self != NULL);
#line 41 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_tmp0_ = value;
#line 41 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 41 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_g_free0 (self->priv->_id);
#line 41 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	self->priv->_id = _tmp1_;
#line 41 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	g_object_notify ((GObject *) self, "id");
#line 2137 "rygel-media-object.c"
}


const gchar* rygel_media_object_get_ref_id (RygelMediaObject* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
#line 42 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 42 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_tmp0_ = self->priv->_ref_id;
#line 42 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	result = _tmp0_;
#line 42 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	return result;
#line 2152 "rygel-media-object.c"
}


void rygel_media_object_set_ref_id (RygelMediaObject* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
#line 42 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	g_return_if_fail (self != NULL);
#line 42 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_tmp0_ = value;
#line 42 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 42 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_g_free0 (self->priv->_ref_id);
#line 42 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	self->priv->_ref_id = _tmp1_;
#line 42 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	g_object_notify ((GObject *) self, "ref-id");
#line 2171 "rygel-media-object.c"
}


const gchar* rygel_media_object_get_upnp_class (RygelMediaObject* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
#line 43 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 43 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_tmp0_ = self->priv->_upnp_class;
#line 43 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	result = _tmp0_;
#line 43 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	return result;
#line 2186 "rygel-media-object.c"
}


void rygel_media_object_set_upnp_class (RygelMediaObject* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
#line 43 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	g_return_if_fail (self != NULL);
#line 43 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_tmp0_ = value;
#line 43 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 43 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_g_free0 (self->priv->_upnp_class);
#line 43 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	self->priv->_upnp_class = _tmp1_;
#line 43 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	g_object_notify ((GObject *) self, "upnp-class");
#line 2205 "rygel-media-object.c"
}


guint64 rygel_media_object_get_modified (RygelMediaObject* self) {
	guint64 result;
	guint64 _tmp0_ = 0ULL;
#line 44 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	g_return_val_if_fail (self != NULL, 0ULL);
#line 44 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_tmp0_ = self->priv->_modified;
#line 44 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	result = _tmp0_;
#line 44 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	return result;
#line 2220 "rygel-media-object.c"
}


void rygel_media_object_set_modified (RygelMediaObject* self, guint64 value) {
	guint64 _tmp0_ = 0ULL;
#line 44 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	g_return_if_fail (self != NULL);
#line 44 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_tmp0_ = value;
#line 44 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	self->priv->_modified = _tmp0_;
#line 44 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	g_object_notify ((GObject *) self, "modified");
#line 2234 "rygel-media-object.c"
}


guint rygel_media_object_get_object_update_id (RygelMediaObject* self) {
	guint result;
	guint _tmp0_ = 0U;
#line 45 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	g_return_val_if_fail (self != NULL, 0U);
#line 45 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_tmp0_ = self->priv->_object_update_id;
#line 45 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	result = _tmp0_;
#line 45 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	return result;
#line 2249 "rygel-media-object.c"
}


void rygel_media_object_set_object_update_id (RygelMediaObject* self, guint value) {
	guint _tmp0_ = 0U;
#line 45 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	g_return_if_fail (self != NULL);
#line 45 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_tmp0_ = value;
#line 45 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	self->priv->_object_update_id = _tmp0_;
#line 45 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	g_object_notify ((GObject *) self, "object-update-id");
#line 2263 "rygel-media-object.c"
}


RygelMediaContainer* rygel_media_object_get_parent (RygelMediaObject* self) {
	RygelMediaContainer* result;
	RygelMediaContainer* _tmp0_ = NULL;
#line 61 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 62 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_tmp0_ = self->parent_ptr;
#line 62 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	result = _tmp0_;
#line 62 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	return result;
#line 2278 "rygel-media-object.c"
}


void rygel_media_object_set_parent (RygelMediaObject* self, RygelMediaContainer* value) {
	RygelMediaContainer* _tmp0_ = NULL;
#line 65 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	g_return_if_fail (self != NULL);
#line 66 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_tmp0_ = value;
#line 66 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	self->parent_ptr = _tmp0_;
#line 65 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	g_object_notify ((GObject *) self, "parent");
#line 2292 "rygel-media-object.c"
}


RygelMediaContainer* rygel_media_object_get_parent_ref (RygelMediaObject* self) {
	RygelMediaContainer* result;
	RygelMediaContainer* _tmp0_ = NULL;
#line 74 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 75 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_tmp0_ = self->priv->_parent_ref;
#line 75 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	result = _tmp0_;
#line 75 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	return result;
#line 2307 "rygel-media-object.c"
}


void rygel_media_object_set_parent_ref (RygelMediaObject* self, RygelMediaContainer* value) {
	RygelMediaContainer* _tmp0_ = NULL;
	RygelMediaContainer* _tmp1_ = NULL;
	RygelMediaContainer* _tmp2_ = NULL;
#line 78 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	g_return_if_fail (self != NULL);
#line 79 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_tmp0_ = value;
#line 79 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	rygel_media_object_set_parent (self, _tmp0_);
#line 80 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_tmp1_ = value;
#line 80 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_tmp2_ = _g_object_ref0 (_tmp1_);
#line 80 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_g_object_unref0 (self->priv->_parent_ref);
#line 80 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	self->priv->_parent_ref = _tmp2_;
#line 78 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	g_object_notify ((GObject *) self, "parent-ref");
#line 2331 "rygel-media-object.c"
}


const gchar* rygel_media_object_get_title (RygelMediaObject* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
#line 101 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 102 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_tmp0_ = self->priv->_title;
#line 102 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	result = _tmp0_;
#line 102 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	return result;
#line 2346 "rygel-media-object.c"
}


void rygel_media_object_set_title (RygelMediaObject* self, const gchar* value) {
	GError * _inner_error_ = NULL;
#line 105 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	g_return_if_fail (self != NULL);
#line 2354 "rygel-media-object.c"
	{
		gchar* _tmp0_ = NULL;
		GRegex* _tmp1_ = NULL;
		const gchar* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
		gchar* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
		GRegex* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
		const gchar* _tmp8_ = NULL;
		gchar* _tmp9_ = NULL;
		gchar* _tmp10_ = NULL;
		GRegex* _tmp11_ = NULL;
		const gchar* _tmp12_ = NULL;
		const gchar* _tmp13_ = NULL;
		gchar* _tmp14_ = NULL;
#line 107 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_tmp1_ = rygel_media_object_real_name_regex;
#line 107 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_tmp2_ = value;
#line 107 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_tmp3_ = g_get_real_name ();
#line 107 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_tmp4_ = g_regex_replace_literal (_tmp1_, _tmp2_, (gssize) (-1), 0, _tmp3_, 0, &_inner_error_);
#line 107 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_tmp0_ = _tmp4_;
#line 107 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		if (_inner_error_ != NULL) {
#line 107 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			if (_inner_error_->domain == G_REGEX_ERROR) {
#line 2385 "rygel-media-object.c"
				goto __catch12_g_regex_error;
			}
#line 107 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 107 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			g_clear_error (&_inner_error_);
#line 107 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			return;
#line 2394 "rygel-media-object.c"
		}
#line 107 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_g_free0 (self->priv->_title);
#line 107 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		self->priv->_title = _tmp0_;
#line 112 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_tmp6_ = rygel_media_object_user_name_regex;
#line 112 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_tmp7_ = self->priv->_title;
#line 112 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_tmp8_ = g_get_user_name ();
#line 112 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_tmp9_ = g_regex_replace_literal (_tmp6_, _tmp7_, (gssize) (-1), 0, _tmp8_, 0, &_inner_error_);
#line 112 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_tmp5_ = _tmp9_;
#line 112 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		if (_inner_error_ != NULL) {
#line 112 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			if (_inner_error_->domain == G_REGEX_ERROR) {
#line 2414 "rygel-media-object.c"
				goto __catch12_g_regex_error;
			}
#line 112 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 112 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			g_clear_error (&_inner_error_);
#line 112 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			return;
#line 2423 "rygel-media-object.c"
		}
#line 112 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_g_free0 (self->priv->_title);
#line 112 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		self->priv->_title = _tmp5_;
#line 117 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_tmp11_ = rygel_media_object_host_name_regex;
#line 117 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_tmp12_ = self->priv->_title;
#line 117 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_tmp13_ = g_get_host_name ();
#line 117 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_tmp14_ = g_regex_replace_literal (_tmp11_, _tmp12_, (gssize) (-1), 0, _tmp13_, 0, &_inner_error_);
#line 117 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_tmp10_ = _tmp14_;
#line 117 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		if (_inner_error_ != NULL) {
#line 117 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			if (_inner_error_->domain == G_REGEX_ERROR) {
#line 2443 "rygel-media-object.c"
				goto __catch12_g_regex_error;
			}
#line 117 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 117 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			g_clear_error (&_inner_error_);
#line 117 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			return;
#line 2452 "rygel-media-object.c"
		}
#line 117 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_g_free0 (self->priv->_title);
#line 117 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		self->priv->_title = _tmp10_;
#line 2458 "rygel-media-object.c"
	}
	goto __finally12;
	__catch12_g_regex_error:
	{
		GError* err = NULL;
#line 106 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		err = _inner_error_;
#line 106 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_inner_error_ = NULL;
#line 123 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		g_assert_not_reached ();
#line 106 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_g_error_free0 (err);
#line 2472 "rygel-media-object.c"
	}
	__finally12:
#line 106 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	if (_inner_error_ != NULL) {
#line 106 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 106 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		g_clear_error (&_inner_error_);
#line 106 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		return;
#line 2483 "rygel-media-object.c"
	}
#line 105 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	g_object_notify ((GObject *) self, "title");
#line 2487 "rygel-media-object.c"
}


GUPnPOCMFlags rygel_media_object_get_ocm_flags (RygelMediaObject* self) {
#line 128 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 128 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	return RYGEL_MEDIA_OBJECT_GET_CLASS (self)->get_ocm_flags (self);
#line 2496 "rygel-media-object.c"
}


static GUPnPOCMFlags rygel_media_object_real_get_ocm_flags (RygelMediaObject* base) {
	GUPnPOCMFlags result;
	RygelMediaObject* self;
#line 128 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	self = base;
#line 128 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	result = GUPNP_OCM_FLAGS_NONE;
#line 128 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	return result;
#line 2509 "rygel-media-object.c"
}


gboolean rygel_media_object_get_restricted (RygelMediaObject* self) {
	gboolean result;
	GUPnPOCMFlags _tmp0_ = 0;
	GUPnPOCMFlags _tmp1_ = 0;
#line 131 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 132 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_tmp0_ = rygel_media_object_get_ocm_flags (self);
#line 132 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_tmp1_ = _tmp0_;
#line 132 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	result = _tmp1_ == GUPNP_OCM_FLAGS_NONE;
#line 132 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	return result;
#line 2527 "rygel-media-object.c"
}


static void rygel_media_object_class_init (RygelMediaObjectClass * klass) {
	GError * _inner_error_ = NULL;
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	rygel_media_object_parent_class = g_type_class_peek_parent (klass);
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	g_type_class_add_private (klass, sizeof (RygelMediaObjectPrivate));
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	G_OBJECT_CLASS (klass)->constructed = rygel_media_object_real_constructed;
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	RYGEL_MEDIA_OBJECT_CLASS (klass)->serialize = rygel_media_object_real_serialize;
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	RYGEL_MEDIA_OBJECT_CLASS (klass)->apply_didl_lite = rygel_media_object_real_apply_didl_lite;
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	RYGEL_MEDIA_OBJECT_CLASS (klass)->compare_by_property = rygel_media_object_real_compare_by_property;
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	RYGEL_MEDIA_OBJECT_CLASS (klass)->add_resource = rygel_media_object_real_add_resource;
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	RYGEL_MEDIA_OBJECT_CLASS (klass)->get_ocm_flags = rygel_media_object_real_get_ocm_flags;
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_rygel_media_object_get_property;
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_rygel_media_object_set_property;
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	G_OBJECT_CLASS (klass)->finalize = rygel_media_object_finalize;
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MEDIA_OBJECT_ID, g_param_spec_string ("id", "id", "id", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MEDIA_OBJECT_REF_ID, g_param_spec_string ("ref-id", "ref-id", "ref-id", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MEDIA_OBJECT_UPNP_CLASS, g_param_spec_string ("upnp-class", "upnp-class", "upnp-class", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MEDIA_OBJECT_MODIFIED, g_param_spec_uint64 ("modified", "modified", "modified", 0, G_MAXUINT64, 0U, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MEDIA_OBJECT_OBJECT_UPDATE_ID, g_param_spec_uint ("object-update-id", "object-update-id", "object-update-id", 0, G_MAXUINT, 0U, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MEDIA_OBJECT_PARENT, g_param_spec_object ("parent", "parent", "parent", RYGEL_TYPE_MEDIA_CONTAINER, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MEDIA_OBJECT_PARENT_REF, g_param_spec_object ("parent-ref", "parent-ref", "parent-ref", RYGEL_TYPE_MEDIA_CONTAINER, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 2569 "rygel-media-object.c"
	/**
	     * The human-readable title of this container or item.
	     * These variables will be substituted:
	     *
	     *  - @@REALNAME@ will be substituted by the user's real name.
	     *  - @@USERNAME@ will be substituted by the users's login ID.
	     *  - @@HOSTNAME@ will be substituted by the name of the machine.
	     *  - @@ADDRESS@ will be substituted by the IP address of network interface used for the UpNP communication.
	     */
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MEDIA_OBJECT_TITLE, g_param_spec_string ("title", "title", "title", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MEDIA_OBJECT_OCM_FLAGS, g_param_spec_flags ("ocm-flags", "ocm-flags", "ocm-flags", gupnp_ocm_flags_get_type (), 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MEDIA_OBJECT_RESTRICTED, g_param_spec_boolean ("restricted", "restricted", "restricted", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 2585 "rygel-media-object.c"
	{
		GRegex* _tmp0_ = NULL;
		gchar* _tmp1_ = NULL;
		gchar* _tmp2_ = NULL;
		GRegex* _tmp3_ = NULL;
		GRegex* _tmp4_ = NULL;
		GRegex* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_ = NULL;
		GRegex* _tmp9_ = NULL;
		GRegex* _tmp10_ = NULL;
		gchar* _tmp11_ = NULL;
		gchar* _tmp12_ = NULL;
		GRegex* _tmp13_ = NULL;
		GRegex* _tmp14_ = NULL;
#line 138 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_tmp1_ = g_regex_escape_string ("@REALNAME@", -1);
#line 138 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_tmp2_ = _tmp1_;
#line 138 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_tmp3_ = g_regex_new (_tmp2_, 0, 0, &_inner_error_);
#line 138 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_tmp4_ = _tmp3_;
#line 138 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_g_free0 (_tmp2_);
#line 138 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_tmp0_ = _tmp4_;
#line 138 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		if (_inner_error_ != NULL) {
#line 138 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			if (_inner_error_->domain == G_REGEX_ERROR) {
#line 2618 "rygel-media-object.c"
				goto __catch13_g_regex_error;
			}
#line 138 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 138 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			g_clear_error (&_inner_error_);
#line 2625 "rygel-media-object.c"
		}
#line 138 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_g_regex_unref0 (rygel_media_object_real_name_regex);
#line 138 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		rygel_media_object_real_name_regex = _tmp0_;
#line 139 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_tmp6_ = g_regex_escape_string ("@USERNAME@", -1);
#line 139 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_tmp7_ = _tmp6_;
#line 139 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_tmp8_ = g_regex_new (_tmp7_, 0, 0, &_inner_error_);
#line 139 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_tmp9_ = _tmp8_;
#line 139 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_g_free0 (_tmp7_);
#line 139 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_tmp5_ = _tmp9_;
#line 139 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		if (_inner_error_ != NULL) {
#line 139 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			if (_inner_error_->domain == G_REGEX_ERROR) {
#line 2647 "rygel-media-object.c"
				goto __catch13_g_regex_error;
			}
#line 139 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 139 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			g_clear_error (&_inner_error_);
#line 2654 "rygel-media-object.c"
		}
#line 139 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_g_regex_unref0 (rygel_media_object_user_name_regex);
#line 139 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		rygel_media_object_user_name_regex = _tmp5_;
#line 140 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_tmp11_ = g_regex_escape_string ("@HOSTNAME@", -1);
#line 140 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_tmp12_ = _tmp11_;
#line 140 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_tmp13_ = g_regex_new (_tmp12_, 0, 0, &_inner_error_);
#line 140 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_tmp14_ = _tmp13_;
#line 140 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_g_free0 (_tmp12_);
#line 140 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_tmp10_ = _tmp14_;
#line 140 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		if (_inner_error_ != NULL) {
#line 140 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			if (_inner_error_->domain == G_REGEX_ERROR) {
#line 2676 "rygel-media-object.c"
				goto __catch13_g_regex_error;
			}
#line 140 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 140 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
			g_clear_error (&_inner_error_);
#line 2683 "rygel-media-object.c"
		}
#line 140 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_g_regex_unref0 (rygel_media_object_host_name_regex);
#line 140 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		rygel_media_object_host_name_regex = _tmp10_;
#line 2689 "rygel-media-object.c"
	}
	goto __finally13;
	__catch13_g_regex_error:
	{
		GError* err = NULL;
#line 137 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		err = _inner_error_;
#line 137 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_inner_error_ = NULL;
#line 142 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		g_assert_not_reached ();
#line 137 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		_g_error_free0 (err);
#line 2703 "rygel-media-object.c"
	}
	__finally13:
#line 137 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	if (_inner_error_ != NULL) {
#line 137 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 137 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		g_clear_error (&_inner_error_);
#line 2712 "rygel-media-object.c"
	}
}


static void rygel_media_object_instance_init (RygelMediaObject * self) {
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	self->priv = RYGEL_MEDIA_OBJECT_GET_PRIVATE (self);
#line 2720 "rygel-media-object.c"
}


static void rygel_media_object_finalize (GObject* obj) {
	RygelMediaObject * self;
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObject);
#line 41 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_g_free0 (self->priv->_id);
#line 42 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_g_free0 (self->priv->_ref_id);
#line 43 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_g_free0 (self->priv->_upnp_class);
#line 50 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_g_object_unref0 (self->uris);
#line 72 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_g_object_unref0 (self->priv->_parent_ref);
#line 84 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	_g_free0 (self->priv->_title);
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	G_OBJECT_CLASS (rygel_media_object_parent_class)->finalize (obj);
#line 2742 "rygel-media-object.c"
}


/**
 * Represents a media object (container or item).
 *
 * The derived RygelMediaContainer class represents a container,
 * and the derived RygelMediaItem classes (RygelAudioItem,
 * RygelImageItem and RygelVideoItem) represent media items.
 *
 * These objects correspond to items and containers in the UPnP ContentDirectory's DIDL-Lite XML.
 */
GType rygel_media_object_get_type (void) {
	static volatile gsize rygel_media_object_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_media_object_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelMediaObjectClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_media_object_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelMediaObject), 0, (GInstanceInitFunc) rygel_media_object_instance_init, NULL };
		GType rygel_media_object_type_id;
		rygel_media_object_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelMediaObject", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
		g_once_init_leave (&rygel_media_object_type_id__volatile, rygel_media_object_type_id);
	}
	return rygel_media_object_type_id__volatile;
}


static void _vala_rygel_media_object_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	RygelMediaObject * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObject);
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	switch (property_id) {
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		case RYGEL_MEDIA_OBJECT_ID:
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		g_value_set_string (value, rygel_media_object_get_id (self));
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		break;
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		case RYGEL_MEDIA_OBJECT_REF_ID:
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		g_value_set_string (value, rygel_media_object_get_ref_id (self));
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		break;
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		case RYGEL_MEDIA_OBJECT_UPNP_CLASS:
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		g_value_set_string (value, rygel_media_object_get_upnp_class (self));
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		break;
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		case RYGEL_MEDIA_OBJECT_MODIFIED:
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		g_value_set_uint64 (value, rygel_media_object_get_modified (self));
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		break;
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		case RYGEL_MEDIA_OBJECT_OBJECT_UPDATE_ID:
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		g_value_set_uint (value, rygel_media_object_get_object_update_id (self));
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		break;
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		case RYGEL_MEDIA_OBJECT_PARENT:
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		g_value_set_object (value, rygel_media_object_get_parent (self));
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		break;
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		case RYGEL_MEDIA_OBJECT_PARENT_REF:
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		g_value_set_object (value, rygel_media_object_get_parent_ref (self));
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		break;
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		case RYGEL_MEDIA_OBJECT_TITLE:
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		g_value_set_string (value, rygel_media_object_get_title (self));
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		break;
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		case RYGEL_MEDIA_OBJECT_OCM_FLAGS:
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		g_value_set_flags (value, rygel_media_object_get_ocm_flags (self));
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		break;
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		case RYGEL_MEDIA_OBJECT_RESTRICTED:
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		g_value_set_boolean (value, rygel_media_object_get_restricted (self));
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		break;
#line 2832 "rygel-media-object.c"
		default:
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		break;
#line 2838 "rygel-media-object.c"
	}
}


static void _vala_rygel_media_object_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	RygelMediaObject * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObject);
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
	switch (property_id) {
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		case RYGEL_MEDIA_OBJECT_ID:
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		rygel_media_object_set_id (self, g_value_get_string (value));
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		break;
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		case RYGEL_MEDIA_OBJECT_REF_ID:
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		rygel_media_object_set_ref_id (self, g_value_get_string (value));
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		break;
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		case RYGEL_MEDIA_OBJECT_UPNP_CLASS:
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		rygel_media_object_set_upnp_class (self, g_value_get_string (value));
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		break;
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		case RYGEL_MEDIA_OBJECT_MODIFIED:
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		rygel_media_object_set_modified (self, g_value_get_uint64 (value));
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		break;
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		case RYGEL_MEDIA_OBJECT_OBJECT_UPDATE_ID:
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		rygel_media_object_set_object_update_id (self, g_value_get_uint (value));
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		break;
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		case RYGEL_MEDIA_OBJECT_PARENT:
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		rygel_media_object_set_parent (self, g_value_get_object (value));
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		break;
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		case RYGEL_MEDIA_OBJECT_PARENT_REF:
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		rygel_media_object_set_parent_ref (self, g_value_get_object (value));
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		break;
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		case RYGEL_MEDIA_OBJECT_TITLE:
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		rygel_media_object_set_title (self, g_value_get_string (value));
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		break;
#line 2896 "rygel-media-object.c"
		default:
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-object.vala"
		break;
#line 2902 "rygel-media-object.c"
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



