/* rygel-external-container.c generated by valac 0.22.0, the Vala compiler
 * generated from rygel-external-container.vala, do not modify */

/*
 * Copyright (C) 2009 Zeeshan Ali (Khattak) <zeeshanak@gnome.org>.
 * Copyright (C) 2009,2010 Nokia Corporation.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <rygel-server.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <rygel-core.h>
#include <libgupnp-av/gupnp-av.h>


#define RYGEL_EXTERNAL_TYPE_CONTAINER (rygel_external_container_get_type ())
#define RYGEL_EXTERNAL_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_EXTERNAL_TYPE_CONTAINER, RygelExternalContainer))
#define RYGEL_EXTERNAL_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_EXTERNAL_TYPE_CONTAINER, RygelExternalContainerClass))
#define RYGEL_EXTERNAL_IS_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_EXTERNAL_TYPE_CONTAINER))
#define RYGEL_EXTERNAL_IS_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_EXTERNAL_TYPE_CONTAINER))
#define RYGEL_EXTERNAL_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_EXTERNAL_TYPE_CONTAINER, RygelExternalContainerClass))

typedef struct _RygelExternalContainer RygelExternalContainer;
typedef struct _RygelExternalContainerClass RygelExternalContainerClass;
typedef struct _RygelExternalContainerPrivate RygelExternalContainerPrivate;

#define RYGEL_EXTERNAL_TYPE_MEDIA_OBJECT_PROXY (rygel_external_media_object_proxy_get_type ())
#define RYGEL_EXTERNAL_MEDIA_OBJECT_PROXY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_EXTERNAL_TYPE_MEDIA_OBJECT_PROXY, RygelExternalMediaObjectProxy))
#define RYGEL_EXTERNAL_IS_MEDIA_OBJECT_PROXY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_EXTERNAL_TYPE_MEDIA_OBJECT_PROXY))
#define RYGEL_EXTERNAL_MEDIA_OBJECT_PROXY_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_EXTERNAL_TYPE_MEDIA_OBJECT_PROXY, RygelExternalMediaObjectProxyIface))

typedef struct _RygelExternalMediaObjectProxy RygelExternalMediaObjectProxy;
typedef struct _RygelExternalMediaObjectProxyIface RygelExternalMediaObjectProxyIface;

#define RYGEL_EXTERNAL_TYPE_MEDIA_OBJECT_PROXY_PROXY (rygel_external_media_object_proxy_proxy_get_type ())

#define RYGEL_EXTERNAL_TYPE_MEDIA_CONTAINER_PROXY (rygel_external_media_container_proxy_get_type ())
#define RYGEL_EXTERNAL_MEDIA_CONTAINER_PROXY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_EXTERNAL_TYPE_MEDIA_CONTAINER_PROXY, RygelExternalMediaContainerProxy))
#define RYGEL_EXTERNAL_IS_MEDIA_CONTAINER_PROXY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_EXTERNAL_TYPE_MEDIA_CONTAINER_PROXY))
#define RYGEL_EXTERNAL_MEDIA_CONTAINER_PROXY_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_EXTERNAL_TYPE_MEDIA_CONTAINER_PROXY, RygelExternalMediaContainerProxyIface))

typedef struct _RygelExternalMediaContainerProxy RygelExternalMediaContainerProxy;
typedef struct _RygelExternalMediaContainerProxyIface RygelExternalMediaContainerProxyIface;

#define RYGEL_EXTERNAL_TYPE_MEDIA_CONTAINER_PROXY_PROXY (rygel_external_media_container_proxy_proxy_get_type ())

#define RYGEL_EXTERNAL_TYPE_ITEM_FACTORY (rygel_external_item_factory_get_type ())
#define RYGEL_EXTERNAL_ITEM_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_EXTERNAL_TYPE_ITEM_FACTORY, RygelExternalItemFactory))
#define RYGEL_EXTERNAL_ITEM_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_EXTERNAL_TYPE_ITEM_FACTORY, RygelExternalItemFactoryClass))
#define RYGEL_EXTERNAL_IS_ITEM_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_EXTERNAL_TYPE_ITEM_FACTORY))
#define RYGEL_EXTERNAL_IS_ITEM_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_EXTERNAL_TYPE_ITEM_FACTORY))
#define RYGEL_EXTERNAL_ITEM_FACTORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_EXTERNAL_TYPE_ITEM_FACTORY, RygelExternalItemFactoryClass))

typedef struct _RygelExternalItemFactory RygelExternalItemFactory;
typedef struct _RygelExternalItemFactoryClass RygelExternalItemFactoryClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _rygel_external_item_factory_unref0(var) ((var == NULL) ? NULL : (var = (rygel_external_item_factory_unref (var), NULL)))
typedef struct _RygelExternalContainerGetChildrenData RygelExternalContainerGetChildrenData;
#define _rygel_search_expression_unref0(var) ((var == NULL) ? NULL : (var = (rygel_search_expression_unref (var), NULL)))
typedef struct _RygelExternalContainerSearchData RygelExternalContainerSearchData;
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))

#define RYGEL_EXTERNAL_TYPE_DUMMY_CONTAINER (rygel_external_dummy_container_get_type ())
#define RYGEL_EXTERNAL_DUMMY_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_EXTERNAL_TYPE_DUMMY_CONTAINER, RygelExternalDummyContainer))
#define RYGEL_EXTERNAL_DUMMY_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_EXTERNAL_TYPE_DUMMY_CONTAINER, RygelExternalDummyContainerClass))
#define RYGEL_EXTERNAL_IS_DUMMY_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_EXTERNAL_TYPE_DUMMY_CONTAINER))
#define RYGEL_EXTERNAL_IS_DUMMY_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_EXTERNAL_TYPE_DUMMY_CONTAINER))
#define RYGEL_EXTERNAL_DUMMY_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_EXTERNAL_TYPE_DUMMY_CONTAINER, RygelExternalDummyContainerClass))

typedef struct _RygelExternalDummyContainer RygelExternalDummyContainer;
typedef struct _RygelExternalDummyContainerClass RygelExternalDummyContainerClass;
typedef struct _RygelExternalContainerFindObjectData RygelExternalContainerFindObjectData;
typedef struct _RygelExternalContainerCreateMediaObjectsData RygelExternalContainerCreateMediaObjectsData;
typedef struct _RygelExternalContainerRefreshChildContainersData RygelExternalContainerRefreshChildContainersData;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _RygelExternalContainerUpdateContainerData RygelExternalContainerUpdateContainerData;

struct _RygelExternalMediaObjectProxyIface {
	GTypeInterface parent_iface;
	char* (*get_parent) (RygelExternalMediaObjectProxy* self);
	void (*set_parent) (RygelExternalMediaObjectProxy* self, const char* value);
	gchar* (*get_display_name) (RygelExternalMediaObjectProxy* self);
	void (*set_display_name) (RygelExternalMediaObjectProxy* self, const gchar* value);
	gchar* (*get_object_type) (RygelExternalMediaObjectProxy* self);
	void (*set_object_type) (RygelExternalMediaObjectProxy* self, const gchar* value);
};

struct _RygelExternalMediaContainerProxyIface {
	GTypeInterface parent_iface;
	void (*list_children) (RygelExternalMediaContainerProxy* self, guint offset, guint max_count, gchar** filter, int filter_length1, GAsyncReadyCallback _callback_, gpointer _user_data_);
	GHashTable** (*list_children_finish) (RygelExternalMediaContainerProxy* self, GAsyncResult* _res_, int* result_length1, GError** error);
	void (*list_containers) (RygelExternalMediaContainerProxy* self, guint offset, guint max_count, gchar** filter, int filter_length1, GAsyncReadyCallback _callback_, gpointer _user_data_);
	GHashTable** (*list_containers_finish) (RygelExternalMediaContainerProxy* self, GAsyncResult* _res_, int* result_length1, GError** error);
	void (*list_items) (RygelExternalMediaContainerProxy* self, guint offset, guint max_count, gchar** filter, int filter_length1, GAsyncReadyCallback _callback_, gpointer _user_data_);
	GHashTable** (*list_items_finish) (RygelExternalMediaContainerProxy* self, GAsyncResult* _res_, int* result_length1, GError** error);
	void (*search_objects) (RygelExternalMediaContainerProxy* self, const gchar* query, guint offset, guint max_count, gchar** filter, int filter_length1, GAsyncReadyCallback _callback_, gpointer _user_data_);
	GHashTable** (*search_objects_finish) (RygelExternalMediaContainerProxy* self, GAsyncResult* _res_, int* result_length1, GError** error);
	guint (*get_child_count) (RygelExternalMediaContainerProxy* self);
	void (*set_child_count) (RygelExternalMediaContainerProxy* self, guint value);
	guint (*get_item_count) (RygelExternalMediaContainerProxy* self);
	void (*set_item_count) (RygelExternalMediaContainerProxy* self, guint value);
	guint (*get_container_count) (RygelExternalMediaContainerProxy* self);
	void (*set_container_count) (RygelExternalMediaContainerProxy* self, guint value);
	gboolean (*get_searchable) (RygelExternalMediaContainerProxy* self);
	void (*set_searchable) (RygelExternalMediaContainerProxy* self, gboolean value);
	char* (*get_icon) (RygelExternalMediaContainerProxy* self);
	void (*set_icon) (RygelExternalMediaContainerProxy* self, const char* value);
};

struct _RygelExternalContainer {
	RygelMediaContainer parent_instance;
	RygelExternalContainerPrivate * priv;
	RygelExternalMediaContainerProxy* actual_container;
	gchar* service_name;
};

struct _RygelExternalContainerClass {
	RygelMediaContainerClass parent_class;
};

struct _RygelExternalContainerPrivate {
	RygelExternalItemFactory* item_factory;
	GeeArrayList* containers;
	GeeArrayList* _search_classes;
	gboolean searchable;
};

struct _RygelExternalContainerGetChildrenData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelExternalContainer* self;
	guint offset;
	guint max_count;
	gchar* sort_criteria;
	GCancellable* cancellable;
	RygelMediaObjects* result;
	gchar** filter;
	gchar** _tmp0_;
	gint filter_length1;
	gint _filter_size_;
	const gchar** object_prop_collection;
	gint object_prop_collection_length1;
	gint _object_prop_collection_size_;
	gint object_prop_it;
	const gchar* object_prop;
	gchar** _tmp1_;
	gint _tmp1__length1;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	const gchar** container_prop_collection;
	gint container_prop_collection_length1;
	gint _container_prop_collection_size_;
	gint container_prop_it;
	const gchar* container_prop;
	gchar** _tmp4_;
	gint _tmp4__length1;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	const gchar** item_prop_collection;
	gint item_prop_collection_length1;
	gint _item_prop_collection_size_;
	gint item_prop_it;
	const gchar* item_prop;
	gchar** _tmp7_;
	gint _tmp7__length1;
	const gchar* _tmp8_;
	gchar* _tmp9_;
	GHashTable** children_props;
	RygelExternalMediaContainerProxy* _tmp10_;
	guint _tmp11_;
	guint _tmp12_;
	gchar** _tmp13_;
	gint _tmp13__length1;
	gint _tmp14_;
	GHashTable** _tmp15_;
	gint children_props_length1;
	gint _children_props_size_;
	RygelMediaObjects* _result_;
	GHashTable** _tmp16_;
	gint _tmp16__length1;
	RygelMediaObjects* _tmp17_;
	RygelMediaObjects* _tmp18_;
	const gchar* _tmp19_;
	GError * _inner_error_;
};

struct _RygelExternalContainerSearchData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelExternalContainer* self;
	RygelSearchExpression* expression;
	guint offset;
	guint max_count;
	guint total_matches;
	gchar* sort_criteria;
	GCancellable* cancellable;
	RygelMediaObjects* result;
	gboolean _tmp0_;
	RygelSearchExpression* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	RygelMediaObjects* _tmp4_;
	RygelSearchExpression* _tmp5_;
	guint _tmp6_;
	guint _tmp7_;
	const gchar* _tmp8_;
	GCancellable* _tmp9_;
	guint _tmp10_;
	RygelMediaObjects* _tmp11_;
	gchar** filter;
	gchar** _tmp12_;
	gint filter_length1;
	gint _filter_size_;
	const gchar** object_prop_collection;
	gint object_prop_collection_length1;
	gint _object_prop_collection_size_;
	gint object_prop_it;
	const gchar* object_prop;
	gchar** _tmp13_;
	gint _tmp13__length1;
	const gchar* _tmp14_;
	gchar* _tmp15_;
	const gchar** container_prop_collection;
	gint container_prop_collection_length1;
	gint _container_prop_collection_size_;
	gint container_prop_it;
	const gchar* container_prop;
	gchar** _tmp16_;
	gint _tmp16__length1;
	const gchar* _tmp17_;
	gchar* _tmp18_;
	const gchar** item_prop_collection;
	gint item_prop_collection_length1;
	gint _item_prop_collection_size_;
	gint item_prop_it;
	const gchar* item_prop;
	gchar** _tmp19_;
	gint _tmp19__length1;
	const gchar* _tmp20_;
	gchar* _tmp21_;
	RygelSearchExpression* ext_expression;
	RygelSearchExpression* _tmp22_;
	RygelSearchExpression* _tmp23_;
	GHashTable** _result_;
	RygelExternalMediaContainerProxy* _tmp24_;
	RygelSearchExpression* _tmp25_;
	gchar* _tmp26_;
	gchar* _tmp27_;
	guint _tmp28_;
	guint _tmp29_;
	gchar** _tmp30_;
	gint _tmp30__length1;
	gint _tmp31_;
	GHashTable** _tmp32_;
	GHashTable** _tmp33_;
	gint _tmp33__length1;
	gint _result__length1;
	gint __result__size_;
	GHashTable** _tmp34_;
	gint _tmp34__length1;
	RygelMediaObjects* objects;
	GHashTable** _tmp35_;
	gint _tmp35__length1;
	RygelMediaObjects* _tmp36_;
	RygelMediaObjects* _tmp37_;
	const gchar* _tmp38_;
	GError * _inner_error_;
};

struct _RygelExternalContainerFindObjectData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelExternalContainer* self;
	gchar* id;
	GCancellable* cancellable;
	RygelMediaObject* result;
	RygelMediaObject* media_object;
	RygelExternalMediaObjectProxy* actual_object;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	RygelExternalMediaObjectProxy* _tmp2_;
	RygelExternalMediaObjectProxy* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gboolean _tmp7_;
	const gchar* _tmp8_;
	RygelMediaContainer* _tmp9_;
	RygelMediaObject* _tmp10_;
	GeeArrayList* _container_list;
	GeeArrayList* _tmp11_;
	GeeArrayList* _tmp12_;
	gint _container_size;
	GeeArrayList* _tmp13_;
	gint _tmp14_;
	gint _tmp15_;
	gint _container_index;
	gint _tmp16_;
	gint _tmp17_;
	gint _tmp18_;
	RygelExternalContainer* container;
	GeeArrayList* _tmp19_;
	gint _tmp20_;
	gpointer _tmp21_;
	RygelMediaObject* _tmp22_;
	RygelExternalContainer* _tmp23_;
	const gchar* _tmp24_;
	GCancellable* _tmp25_;
	RygelMediaObject* _tmp26_;
	RygelMediaObject* _tmp27_;
	FreeDesktopProperties* props_iface;
	const gchar* _tmp28_;
	const gchar* _tmp29_;
	FreeDesktopProperties* _tmp30_;
	GHashTable* props;
	FreeDesktopProperties* _tmp31_;
	GHashTable* _tmp32_;
	guint child_count;
	GHashTable* _tmp33_;
	gconstpointer _tmp34_;
	guint _tmp35_;
	gboolean searchable;
	GHashTable* _tmp36_;
	gconstpointer _tmp37_;
	gboolean _tmp38_;
	GHashTable* _tmp39_;
	FreeDesktopProperties* _tmp40_;
	GHashTable* _tmp41_;
	gchar* path;
	GHashTable* _tmp42_;
	gconstpointer _tmp43_;
	gchar* _tmp44_;
	GHashTable* _tmp45_;
	const gchar* _tmp46_;
	const gchar* _tmp47_;
	gchar* _tmp48_;
	gchar* _tmp49_;
	RygelExternalContainer* _tmp50_;
	const gchar* _tmp51_;
	const gchar* _tmp52_;
	const gchar* _tmp53_;
	guint _tmp54_;
	gboolean _tmp55_;
	const gchar* _tmp56_;
	const gchar* _tmp57_;
	RygelExternalContainer* _tmp58_;
	RygelExternalDummyContainer* parent_container;
	RygelExternalMediaObjectProxy* _tmp59_;
	char* _tmp60_;
	char* _tmp61_;
	gchar* _tmp62_;
	RygelExternalDummyContainer* _tmp63_;
	RygelExternalDummyContainer* _tmp64_;
	FreeDesktopProperties* _vala1_props_iface;
	const gchar* _tmp65_;
	const gchar* _tmp66_;
	FreeDesktopProperties* _tmp67_;
	GHashTable* _vala1_props;
	FreeDesktopProperties* _tmp68_;
	GHashTable* _tmp69_;
	RygelMediaItem* _tmp70_;
	RygelExternalItemFactory* _tmp71_;
	const gchar* _tmp72_;
	RygelExternalMediaObjectProxy* _tmp73_;
	gchar* _tmp74_;
	gchar* _tmp75_;
	gchar* _tmp76_;
	RygelExternalMediaObjectProxy* _tmp77_;
	gchar* _tmp78_;
	gchar* _tmp79_;
	gchar* _tmp80_;
	GHashTable* _tmp81_;
	const gchar* _tmp82_;
	RygelExternalDummyContainer* _tmp83_;
	RygelMediaItem* _tmp84_;
	RygelMediaItem* _tmp85_;
	GError * _inner_error_;
};

struct _RygelExternalContainerCreateMediaObjectsData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelExternalContainer* self;
	GHashTable** all_props;
	gint all_props_length1;
	RygelMediaContainer* parent;
	RygelMediaObjects* result;
	RygelMediaObjects* media_objects;
	RygelMediaObjects* _tmp0_;
	GHashTable** _tmp1_;
	gint _tmp1__length1;
	GHashTable** props_collection;
	gint props_collection_length1;
	gint _props_collection_size_;
	gint props_it;
	GHashTable* _tmp2_;
	GHashTable* props;
	gchar* id;
	GHashTable* _tmp3_;
	gconstpointer _tmp4_;
	gchar* _tmp5_;
	gchar* type;
	GHashTable* _tmp6_;
	gconstpointer _tmp7_;
	gchar* _tmp8_;
	RygelMediaContainer* parent_container;
	RygelMediaContainer* _tmp9_;
	RygelMediaContainer* _tmp10_;
	RygelMediaContainer* _tmp11_;
	gchar* parent_id;
	GHashTable* _tmp12_;
	gconstpointer _tmp13_;
	gchar* _tmp14_;
	const gchar* _tmp15_;
	RygelExternalDummyContainer* _tmp16_;
	RygelMediaObject* media_object;
	const gchar* _tmp17_;
	const gchar* _tmp18_;
	RygelMediaContainer* _tmp19_;
	RygelMediaObject* _tmp20_;
	GHashTable* _tmp21_;
	const gchar* _tmp22_;
	const gchar* _tmp23_;
	gchar* _tmp24_;
	gchar* _tmp25_;
	const gchar* _tmp26_;
	guint child_count;
	GHashTable* _tmp27_;
	gconstpointer _tmp28_;
	guint _tmp29_;
	const gchar* _tmp30_;
	const gchar* _tmp31_;
	const gchar* _tmp32_;
	guint _tmp33_;
	RygelMediaContainer* _tmp34_;
	RygelExternalDummyContainer* _tmp35_;
	RygelMediaItem* _tmp36_;
	RygelExternalItemFactory* _tmp37_;
	const gchar* _tmp38_;
	const gchar* _tmp39_;
	const gchar* _tmp40_;
	const gchar* _tmp41_;
	GHashTable* _tmp42_;
	const gchar* _tmp43_;
	RygelMediaContainer* _tmp44_;
	RygelMediaItem* _tmp45_;
	RygelMediaObjects* _tmp46_;
	RygelMediaObject* _tmp47_;
	GError * _inner_error_;
};

struct _RygelExternalContainerRefreshChildContainersData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelExternalContainer* self;
	gchar** filter;
	gchar** _tmp0_;
	gint filter_length1;
	gint _filter_size_;
	const gchar** object_prop_collection;
	gint object_prop_collection_length1;
	gint _object_prop_collection_size_;
	gint object_prop_it;
	const gchar* object_prop;
	gchar** _tmp1_;
	gint _tmp1__length1;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	const gchar** container_prop_collection;
	gint container_prop_collection_length1;
	gint _container_prop_collection_size_;
	gint container_prop_it;
	const gchar* container_prop;
	gchar** _tmp4_;
	gint _tmp4__length1;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	GHashTable** children_props;
	RygelExternalMediaContainerProxy* _tmp7_;
	gchar** _tmp8_;
	gint _tmp8__length1;
	gint _tmp9_;
	GHashTable** _tmp10_;
	gint children_props_length1;
	gint _children_props_size_;
	GeeArrayList* _tmp11_;
	GHashTable** _tmp12_;
	gint _tmp12__length1;
	GHashTable** props_collection;
	gint props_collection_length1;
	gint _props_collection_size_;
	gint props_it;
	GHashTable* _tmp13_;
	GHashTable* props;
	gchar* path;
	GHashTable* _tmp14_;
	gconstpointer _tmp15_;
	gchar* _tmp16_;
	gchar* title;
	GHashTable* _tmp17_;
	gconstpointer _tmp18_;
	gchar* _tmp19_;
	guint child_count;
	GHashTable* _tmp20_;
	gconstpointer _tmp21_;
	guint _tmp22_;
	gboolean searchable;
	GHashTable* _tmp23_;
	gconstpointer _tmp24_;
	gboolean _tmp25_;
	RygelExternalContainer* container;
	const gchar* _tmp26_;
	const gchar* _tmp27_;
	guint _tmp28_;
	gboolean _tmp29_;
	const gchar* _tmp30_;
	const gchar* _tmp31_;
	RygelExternalContainer* _tmp32_;
	GeeArrayList* _tmp33_;
	RygelExternalContainer* _tmp34_;
	GError * _inner_error_;
};

struct _RygelExternalContainerUpdateContainerData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelExternalContainer* self;
	gboolean connect_signal;
	FreeDesktopProperties* props_iface;
	const gchar* _tmp0_;
	RygelExternalMediaContainerProxy* _tmp1_;
	const gchar* _tmp2_;
	FreeDesktopProperties* _tmp3_;
	GHashTable* props;
	FreeDesktopProperties* _tmp4_;
	GHashTable* _tmp5_;
	guint child_count;
	GHashTable* _tmp6_;
	gconstpointer _tmp7_;
	guint _tmp8_;
	guint _tmp9_;
	GHashTable* _tmp10_;
	FreeDesktopProperties* _tmp11_;
	GHashTable* _tmp12_;
	GHashTable* _tmp13_;
	const gchar* _tmp14_;
	const gchar* _tmp15_;
	const gchar* _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
	GError* property_error;
	RygelExternalMediaContainerProxy* _tmp19_;
	const gchar* _tmp20_;
	GError* _tmp21_;
	const gchar* _tmp22_;
	gint _tmp23_;
	gint _tmp24_;
	gint _tmp25_;
	GError* err;
	RygelExternalMediaContainerProxy* _tmp26_;
	const gchar* _tmp27_;
	GError* _tmp28_;
	const gchar* _tmp29_;
	gboolean _tmp30_;
	RygelExternalMediaContainerProxy* _tmp31_;
	GError * _inner_error_;
};


static gpointer rygel_external_container_parent_class = NULL;
static RygelSearchableContainerIface* rygel_external_container_rygel_searchable_container_parent_iface = NULL;

GType rygel_external_container_get_type (void) G_GNUC_CONST;
GType rygel_external_media_object_proxy_get_type (void) G_GNUC_CONST;
GType rygel_external_media_object_proxy_proxy_get_type (void) G_GNUC_CONST;
guint rygel_external_media_object_proxy_register_object (void* object, GDBusConnection* connection, const gchar* path, GError** error);
GType rygel_external_media_container_proxy_proxy_get_type (void) G_GNUC_CONST;
guint rygel_external_media_container_proxy_register_object (void* object, GDBusConnection* connection, const gchar* path, GError** error);
GType rygel_external_media_container_proxy_get_type (void) G_GNUC_CONST;
gpointer rygel_external_item_factory_ref (gpointer instance);
void rygel_external_item_factory_unref (gpointer instance);
GParamSpec* rygel_external_param_spec_item_factory (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_external_value_set_item_factory (GValue* value, gpointer v_object);
void rygel_external_value_take_item_factory (GValue* value, gpointer v_object);
gpointer rygel_external_value_get_item_factory (const GValue* value);
GType rygel_external_item_factory_get_type (void) G_GNUC_CONST;
#define RYGEL_EXTERNAL_CONTAINER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_EXTERNAL_TYPE_CONTAINER, RygelExternalContainerPrivate))
enum  {
	RYGEL_EXTERNAL_CONTAINER_DUMMY_PROPERTY,
	RYGEL_EXTERNAL_CONTAINER_SEARCH_CLASSES
};
RygelExternalContainer* rygel_external_container_new (const gchar* id, const gchar* title, guint child_count, gboolean searchable, const gchar* service_name, const gchar* path, RygelExternalContainer* parent, GError** error);
RygelExternalContainer* rygel_external_container_construct (GType object_type, const gchar* id, const gchar* title, guint child_count, gboolean searchable, const gchar* service_name, const gchar* path, RygelExternalContainer* parent, GError** error);
RygelExternalItemFactory* rygel_external_item_factory_new (void);
RygelExternalItemFactory* rygel_external_item_factory_construct (GType object_type);
static void rygel_external_container_update_container (RygelExternalContainer* self, gboolean connect_signal, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void rygel_external_container_update_container_finish (RygelExternalContainer* self, GAsyncResult* _res_);
static void rygel_external_container_real_get_children_data_free (gpointer _data);
static void rygel_external_container_real_get_children (RygelMediaContainer* base, guint offset, guint max_count, const gchar* sort_criteria, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean rygel_external_container_real_get_children_co (RygelExternalContainerGetChildrenData* _data_);
static void _vala_array_add1 (gchar*** array, int* length, int* size, gchar* value);
static void _vala_array_add2 (gchar*** array, int* length, int* size, gchar* value);
static void _vala_array_add3 (gchar*** array, int* length, int* size, gchar* value);
void rygel_external_media_container_proxy_list_children (RygelExternalMediaContainerProxy* self, guint offset, guint max_count, gchar** filter, int filter_length1, GAsyncReadyCallback _callback_, gpointer _user_data_);
GHashTable** rygel_external_media_container_proxy_list_children_finish (RygelExternalMediaContainerProxy* self, GAsyncResult* _res_, int* result_length1, GError** error);
static void rygel_external_container_get_children_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void rygel_external_container_create_media_objects (RygelExternalContainer* self, GHashTable** all_props, int all_props_length1, RygelMediaContainer* parent, GAsyncReadyCallback _callback_, gpointer _user_data_);
static RygelMediaObjects* rygel_external_container_create_media_objects_finish (RygelExternalContainer* self, GAsyncResult* _res_, GError** error);
static void rygel_external_container_real_search_data_free (gpointer _data);
static void rygel_external_container_real_search (RygelSearchableContainer* base, RygelSearchExpression* expression, guint offset, guint max_count, const gchar* sort_criteria, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean rygel_external_container_real_search_co (RygelExternalContainerSearchData* _data_);
static void rygel_external_container_search_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void _vala_array_add4 (gchar*** array, int* length, int* size, gchar* value);
static void _vala_array_add5 (gchar*** array, int* length, int* size, gchar* value);
static void _vala_array_add6 (gchar*** array, int* length, int* size, gchar* value);
static RygelSearchExpression* rygel_external_container_translate_expression (RygelExternalContainer* self, RygelSearchExpression* upnp_expression);
void rygel_external_media_container_proxy_search_objects (RygelExternalMediaContainerProxy* self, const gchar* query, guint offset, guint max_count, gchar** filter, int filter_length1, GAsyncReadyCallback _callback_, gpointer _user_data_);
GHashTable** rygel_external_media_container_proxy_search_objects_finish (RygelExternalMediaContainerProxy* self, GAsyncResult* _res_, int* result_length1, GError** error);
static void rygel_external_container_real_find_object_data_free (gpointer _data);
static void rygel_external_container_real_find_object (RygelMediaContainer* base, const gchar* id, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean rygel_external_container_real_find_object_co (RygelExternalContainerFindObjectData* _data_);
static void rygel_external_container_find_object_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
gchar* rygel_external_media_object_proxy_get_object_type (RygelExternalMediaObjectProxy* self);
static RygelMediaContainer* rygel_external_container_find_container_by_id (RygelExternalContainer* self, const gchar* id);
#define RYGEL_EXTERNAL_MEDIA_CONTAINER_PROXY_IFACE "org.gnome.UPnP.MediaContainer2"
static guint _variant_get1 (GVariant* value);
static gboolean _variant_get2 (GVariant* value);
#define RYGEL_EXTERNAL_MEDIA_OBJECT_PROXY_IFACE "org.gnome.UPnP.MediaObject2"
static gchar* _variant_get3 (GVariant* value);
gchar* rygel_external_get_mandatory_string_value (GHashTable* props, const gchar* key, const gchar* _default_, const gchar* service_name);
GType rygel_external_dummy_container_get_type (void) G_GNUC_CONST;
char* rygel_external_media_object_proxy_get_parent (RygelExternalMediaObjectProxy* self);
RygelExternalDummyContainer* rygel_external_dummy_container_new (const gchar* id, const gchar* title, guint child_count, RygelMediaContainer* parent);
RygelExternalDummyContainer* rygel_external_dummy_container_construct (GType object_type, const gchar* id, const gchar* title, guint child_count, RygelMediaContainer* parent);
#define RYGEL_EXTERNAL_MEDIA_ITEM_PROXY_IFACE "org.gnome.UPnP.MediaItem2"
void rygel_external_item_factory_create (RygelExternalItemFactory* self, const gchar* id, const gchar* type, const gchar* title, GHashTable* props, const gchar* service_name, RygelMediaContainer* parent, GAsyncReadyCallback _callback_, gpointer _user_data_);
RygelMediaItem* rygel_external_item_factory_create_finish (RygelExternalItemFactory* self, GAsyncResult* _res_, GError** error);
gchar* rygel_external_media_object_proxy_get_display_name (RygelExternalMediaObjectProxy* self);
static void rygel_external_container_create_media_objects_data_free (gpointer _data);
static gboolean rygel_external_container_create_media_objects_co (RygelExternalContainerCreateMediaObjectsData* _data_);
static gchar* _variant_get4 (GVariant* value);
static gchar* _variant_get5 (GVariant* value);
static gchar* _variant_get6 (GVariant* value);
static guint _variant_get7 (GVariant* value);
static void rygel_external_container_create_media_objects_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void rygel_external_container_refresh_child_containers_data_free (gpointer _data);
static void rygel_external_container_refresh_child_containers (RygelExternalContainer* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void rygel_external_container_refresh_child_containers_finish (RygelExternalContainer* self, GAsyncResult* _res_, GError** error);
static gboolean rygel_external_container_refresh_child_containers_co (RygelExternalContainerRefreshChildContainersData* _data_);
static void _vala_array_add7 (gchar*** array, int* length, int* size, gchar* value);
static void _vala_array_add8 (gchar*** array, int* length, int* size, gchar* value);
void rygel_external_media_container_proxy_list_containers (RygelExternalMediaContainerProxy* self, guint offset, guint max_count, gchar** filter, int filter_length1, GAsyncReadyCallback _callback_, gpointer _user_data_);
GHashTable** rygel_external_media_container_proxy_list_containers_finish (RygelExternalMediaContainerProxy* self, GAsyncResult* _res_, int* result_length1, GError** error);
static void rygel_external_container_refresh_child_containers_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static gchar* _variant_get8 (GVariant* value);
static gchar* _variant_get9 (GVariant* value);
static guint _variant_get10 (GVariant* value);
static gboolean _variant_get11 (GVariant* value);
static void rygel_external_container_update_container_data_free (gpointer _data);
static gboolean rygel_external_container_update_container_co (RygelExternalContainerUpdateContainerData* _data_);
static void rygel_external_container_update_container_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static guint _variant_get12 (GVariant* value);
static void rygel_external_container_on_updated (RygelExternalContainer* self, RygelExternalMediaContainerProxy* actual_container);
static void _rygel_external_container_on_updated_rygel_external_media_container_proxy_updated (RygelExternalMediaContainerProxy* _sender, gpointer self);
gchar* rygel_external_container_translate_property (RygelExternalContainer* self, const gchar* property);
static void rygel_external_container_finalize (GObject* obj);
static void _vala_rygel_external_container_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_rygel_external_container_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);

extern const gchar* RYGEL_EXTERNAL_MEDIA_OBJECT_PROXY_PROPERTIES[4];
extern const gchar* RYGEL_EXTERNAL_MEDIA_CONTAINER_PROXY_PROPERTIES[2];
extern const gchar* RYGEL_EXTERNAL_MEDIA_ITEM_PROXY_PROPERTIES[19];

RygelExternalContainer* rygel_external_container_construct (GType object_type, const gchar* id, const gchar* title, guint child_count, gboolean searchable, const gchar* service_name, const gchar* path, RygelExternalContainer* parent, GError** error) {
	RygelExternalContainer * self = NULL;
	const gchar* _tmp0_ = NULL;
	RygelExternalContainer* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	guint _tmp3_ = 0U;
	gint _tmp4_ = 0;
	guint _tmp5_ = 0U;
	const gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	RygelExternalItemFactory* _tmp8_ = NULL;
	GeeArrayList* _tmp9_ = NULL;
	GeeArrayList* _tmp10_ = NULL;
	GeeArrayList* _tmp11_ = NULL;
	RygelExternalMediaContainerProxy* _tmp12_ = NULL;
	const gchar* _tmp13_ = NULL;
	const gchar* _tmp14_ = NULL;
	RygelExternalMediaContainerProxy* _tmp15_ = NULL;
	RygelExternalContainer* _tmp16_ = NULL;
	GError * _inner_error_ = NULL;
#line 44 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	g_return_val_if_fail (id != NULL, NULL);
#line 44 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	g_return_val_if_fail (title != NULL, NULL);
#line 44 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	g_return_val_if_fail (service_name != NULL, NULL);
#line 44 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	g_return_val_if_fail (path != NULL, NULL);
#line 51 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_tmp0_ = id;
#line 51 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_tmp1_ = parent;
#line 51 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_tmp2_ = title;
#line 51 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_tmp3_ = child_count;
#line 51 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_tmp4_ = G_MAXINT;
#line 51 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_tmp5_ = CLAMP (_tmp3_, (guint) 0, (guint) _tmp4_);
#line 51 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	self = (RygelExternalContainer*) rygel_media_container_construct (object_type, _tmp0_, (RygelMediaContainer*) _tmp1_, _tmp2_, (gint) _tmp5_);
#line 53 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_tmp6_ = service_name;
#line 53 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_tmp7_ = g_strdup (_tmp6_);
#line 53 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_g_free0 (self->service_name);
#line 53 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	self->service_name = _tmp7_;
#line 54 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_tmp8_ = rygel_external_item_factory_new ();
#line 54 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_rygel_external_item_factory_unref0 (self->priv->item_factory);
#line 54 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	self->priv->item_factory = _tmp8_;
#line 55 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_tmp9_ = gee_array_list_new (RYGEL_EXTERNAL_TYPE_CONTAINER, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL);
#line 55 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_g_object_unref0 (self->priv->containers);
#line 55 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	self->priv->containers = _tmp9_;
#line 56 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_tmp10_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL, NULL);
#line 56 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_tmp11_ = _tmp10_;
#line 56 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	rygel_searchable_container_set_search_classes ((RygelSearchableContainer*) self, _tmp11_);
#line 56 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_g_object_unref0 (_tmp11_);
#line 59 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_tmp13_ = self->service_name;
#line 59 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_tmp14_ = path;
#line 59 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_tmp15_ = g_initable_new (RYGEL_EXTERNAL_TYPE_MEDIA_CONTAINER_PROXY_PROXY, NULL, &_inner_error_, "g-flags", G_DBUS_PROXY_FLAGS_DO_NOT_LOAD_PROPERTIES, "g-name", _tmp13_, "g-bus-type", G_BUS_TYPE_SESSION, "g-object-path", _tmp14_, "g-interface-name", "org.gnome.UPnP.MediaContainer2", NULL);
#line 59 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_tmp12_ = (RygelExternalMediaContainerProxy*) _tmp15_;
#line 59 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	if (_inner_error_ != NULL) {
#line 59 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		if (_inner_error_->domain == G_IO_ERROR) {
#line 59 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
			g_propagate_error (error, _inner_error_);
#line 59 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
			_g_object_unref0 (self);
#line 59 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
			return NULL;
#line 801 "rygel-external-container.c"
		} else {
#line 59 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 59 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
			g_clear_error (&_inner_error_);
#line 59 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
			return NULL;
#line 809 "rygel-external-container.c"
		}
	}
#line 59 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_g_object_unref0 (self->actual_container);
#line 59 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	self->actual_container = _tmp12_;
#line 65 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	rygel_external_container_update_container (self, TRUE, NULL, NULL);
#line 66 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_tmp16_ = parent;
#line 66 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	if (_tmp16_ != NULL) {
#line 822 "rygel-external-container.c"
		RygelExternalContainer* _tmp17_ = NULL;
#line 67 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_tmp17_ = parent;
#line 67 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		g_object_add_weak_pointer ((GObject*) _tmp17_, &((RygelMediaObject*) self)->parent_ptr);
#line 828 "rygel-external-container.c"
	}
#line 44 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	return self;
#line 832 "rygel-external-container.c"
}


RygelExternalContainer* rygel_external_container_new (const gchar* id, const gchar* title, guint child_count, gboolean searchable, const gchar* service_name, const gchar* path, RygelExternalContainer* parent, GError** error) {
#line 44 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	return rygel_external_container_construct (RYGEL_EXTERNAL_TYPE_CONTAINER, id, title, child_count, searchable, service_name, path, parent, error);
#line 839 "rygel-external-container.c"
}


static void rygel_external_container_real_get_children_data_free (gpointer _data) {
	RygelExternalContainerGetChildrenData* _data_;
	_data_ = _data;
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_g_free0 (_data_->sort_criteria);
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_g_object_unref0 (_data_->cancellable);
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_g_object_unref0 (_data_->result);
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_g_object_unref0 (_data_->self);
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	g_slice_free (RygelExternalContainerGetChildrenData, _data_);
#line 856 "rygel-external-container.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	return self ? g_object_ref (self) : NULL;
#line 863 "rygel-external-container.c"
}


static void rygel_external_container_real_get_children (RygelMediaContainer* base, guint offset, guint max_count, const gchar* sort_criteria, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelExternalContainer * self;
	RygelExternalContainerGetChildrenData* _data_;
	RygelExternalContainer* _tmp0_ = NULL;
	guint _tmp1_ = 0U;
	guint _tmp2_ = 0U;
	const gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	GCancellable* _tmp5_ = NULL;
	GCancellable* _tmp6_ = NULL;
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	self = (RygelExternalContainer*) base;
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_ = g_slice_new0 (RygelExternalContainerGetChildrenData);
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_external_container_real_get_children);
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_external_container_real_get_children_data_free);
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->self = _tmp0_;
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_tmp1_ = offset;
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->offset = _tmp1_;
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_tmp2_ = max_count;
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->max_count = _tmp2_;
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_tmp3_ = sort_criteria;
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_tmp4_ = g_strdup (_tmp3_);
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_g_free0 (_data_->sort_criteria);
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->sort_criteria = _tmp4_;
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_tmp5_ = cancellable;
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_tmp6_ = _g_object_ref0 (_tmp5_);
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_g_object_unref0 (_data_->cancellable);
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->cancellable = _tmp6_;
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	rygel_external_container_real_get_children_co (_data_);
#line 915 "rygel-external-container.c"
}


static RygelMediaObjects* rygel_external_container_real_get_children_finish (RygelMediaContainer* base, GAsyncResult* _res_, GError** error) {
	RygelMediaObjects* result;
	RygelExternalContainerGetChildrenData* _data_;
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		return NULL;
#line 926 "rygel-external-container.c"
	}
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	result = _data_->result;
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->result = NULL;
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	return result;
#line 936 "rygel-external-container.c"
}


static void _vala_array_add1 (gchar*** array, int* length, int* size, gchar* value) {
#line 86 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	if ((*length) == (*size)) {
#line 86 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 86 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		*array = g_renew (gchar*, *array, (*size) + 1);
#line 947 "rygel-external-container.c"
	}
#line 86 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	(*array)[(*length)++] = value;
#line 86 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	(*array)[*length] = NULL;
#line 953 "rygel-external-container.c"
}


static void _vala_array_add2 (gchar*** array, int* length, int* size, gchar* value) {
#line 90 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	if ((*length) == (*size)) {
#line 90 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 90 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		*array = g_renew (gchar*, *array, (*size) + 1);
#line 964 "rygel-external-container.c"
	}
#line 90 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	(*array)[(*length)++] = value;
#line 90 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	(*array)[*length] = NULL;
#line 970 "rygel-external-container.c"
}


static void _vala_array_add3 (gchar*** array, int* length, int* size, gchar* value) {
#line 94 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	if ((*length) == (*size)) {
#line 94 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 94 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		*array = g_renew (gchar*, *array, (*size) + 1);
#line 981 "rygel-external-container.c"
	}
#line 94 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	(*array)[(*length)++] = value;
#line 94 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	(*array)[*length] = NULL;
#line 987 "rygel-external-container.c"
}


static void rygel_external_container_get_children_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelExternalContainerGetChildrenData* _data_;
#line 97 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_ = _user_data_;
#line 97 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->_source_object_ = source_object;
#line 97 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->_res_ = _res_;
#line 97 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	rygel_external_container_real_get_children_co (_data_);
#line 1001 "rygel-external-container.c"
}


static gboolean rygel_external_container_real_get_children_co (RygelExternalContainerGetChildrenData* _data_) {
#line 77 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	switch (_data_->_state_) {
#line 77 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		case 0:
#line 1010 "rygel-external-container.c"
		goto _state_0;
#line 77 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		case 1:
#line 1014 "rygel-external-container.c"
		goto _state_1;
#line 77 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		case 2:
#line 1018 "rygel-external-container.c"
		goto _state_2;
		default:
#line 77 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		g_assert_not_reached ();
#line 1023 "rygel-external-container.c"
	}
	_state_0:
#line 83 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->_tmp0_ = NULL;
#line 83 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->_tmp0_ = g_new0 (gchar*, 0 + 1);
#line 83 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->filter_length1 = 0;
#line 83 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->_filter_size_ = 0;
#line 83 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->filter = _data_->_tmp0_;
#line 83 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->filter_length1 = 0;
#line 83 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->_filter_size_ = _data_->filter_length1;
#line 1040 "rygel-external-container.c"
	{
#line 85 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->object_prop_collection_length1 = 0;
#line 85 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->_object_prop_collection_size_ = 0;
#line 85 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->object_prop_collection = RYGEL_EXTERNAL_MEDIA_OBJECT_PROXY_PROPERTIES;
#line 85 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->object_prop_collection_length1 = G_N_ELEMENTS (RYGEL_EXTERNAL_MEDIA_OBJECT_PROXY_PROPERTIES);
#line 85 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		for (_data_->object_prop_it = 0; _data_->object_prop_it < G_N_ELEMENTS (RYGEL_EXTERNAL_MEDIA_OBJECT_PROXY_PROPERTIES); _data_->object_prop_it = _data_->object_prop_it + 1) {
#line 85 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
			_data_->object_prop = _data_->object_prop_collection[_data_->object_prop_it];
#line 1054 "rygel-external-container.c"
			{
#line 86 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				_data_->_tmp1_ = NULL;
#line 86 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				_data_->_tmp1__length1 = 0;
#line 86 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				_data_->_tmp1_ = _data_->filter;
#line 86 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				_data_->_tmp1__length1 = _data_->filter_length1;
#line 86 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				_data_->_tmp2_ = NULL;
#line 86 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				_data_->_tmp2_ = _data_->object_prop;
#line 86 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				_data_->_tmp3_ = NULL;
#line 86 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				_data_->_tmp3_ = g_strdup (_data_->_tmp2_);
#line 86 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				_vala_array_add1 (&_data_->filter, &_data_->filter_length1, &_data_->_filter_size_, _data_->_tmp3_);
#line 1074 "rygel-external-container.c"
			}
		}
	}
	{
#line 89 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->container_prop_collection_length1 = 0;
#line 89 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->_container_prop_collection_size_ = 0;
#line 89 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->container_prop_collection = RYGEL_EXTERNAL_MEDIA_CONTAINER_PROXY_PROPERTIES;
#line 89 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->container_prop_collection_length1 = G_N_ELEMENTS (RYGEL_EXTERNAL_MEDIA_CONTAINER_PROXY_PROPERTIES);
#line 89 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		for (_data_->container_prop_it = 0; _data_->container_prop_it < G_N_ELEMENTS (RYGEL_EXTERNAL_MEDIA_CONTAINER_PROXY_PROPERTIES); _data_->container_prop_it = _data_->container_prop_it + 1) {
#line 89 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
			_data_->container_prop = _data_->container_prop_collection[_data_->container_prop_it];
#line 1091 "rygel-external-container.c"
			{
#line 90 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				_data_->_tmp4_ = NULL;
#line 90 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				_data_->_tmp4__length1 = 0;
#line 90 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				_data_->_tmp4_ = _data_->filter;
#line 90 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				_data_->_tmp4__length1 = _data_->filter_length1;
#line 90 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				_data_->_tmp5_ = NULL;
#line 90 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				_data_->_tmp5_ = _data_->container_prop;
#line 90 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				_data_->_tmp6_ = NULL;
#line 90 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				_data_->_tmp6_ = g_strdup (_data_->_tmp5_);
#line 90 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				_vala_array_add2 (&_data_->filter, &_data_->filter_length1, &_data_->_filter_size_, _data_->_tmp6_);
#line 1111 "rygel-external-container.c"
			}
		}
	}
	{
#line 93 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->item_prop_collection_length1 = 0;
#line 93 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->_item_prop_collection_size_ = 0;
#line 93 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->item_prop_collection = RYGEL_EXTERNAL_MEDIA_ITEM_PROXY_PROPERTIES;
#line 93 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->item_prop_collection_length1 = G_N_ELEMENTS (RYGEL_EXTERNAL_MEDIA_ITEM_PROXY_PROPERTIES);
#line 93 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		for (_data_->item_prop_it = 0; _data_->item_prop_it < G_N_ELEMENTS (RYGEL_EXTERNAL_MEDIA_ITEM_PROXY_PROPERTIES); _data_->item_prop_it = _data_->item_prop_it + 1) {
#line 93 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
			_data_->item_prop = _data_->item_prop_collection[_data_->item_prop_it];
#line 1128 "rygel-external-container.c"
			{
#line 94 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				_data_->_tmp7_ = NULL;
#line 94 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				_data_->_tmp7__length1 = 0;
#line 94 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				_data_->_tmp7_ = _data_->filter;
#line 94 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				_data_->_tmp7__length1 = _data_->filter_length1;
#line 94 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				_data_->_tmp8_ = NULL;
#line 94 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				_data_->_tmp8_ = _data_->item_prop;
#line 94 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				_data_->_tmp9_ = NULL;
#line 94 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				_data_->_tmp9_ = g_strdup (_data_->_tmp8_);
#line 94 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				_vala_array_add3 (&_data_->filter, &_data_->filter_length1, &_data_->_filter_size_, _data_->_tmp9_);
#line 1148 "rygel-external-container.c"
			}
		}
	}
#line 97 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->_tmp10_ = NULL;
#line 97 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->_tmp10_ = _data_->self->actual_container;
#line 97 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->_tmp11_ = 0U;
#line 97 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->_tmp11_ = _data_->offset;
#line 97 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->_tmp12_ = 0U;
#line 97 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->_tmp12_ = _data_->max_count;
#line 97 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->_tmp13_ = NULL;
#line 97 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->_tmp13__length1 = 0;
#line 97 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->_tmp13_ = _data_->filter;
#line 97 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->_tmp13__length1 = _data_->filter_length1;
#line 97 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->_tmp14_ = 0;
#line 97 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->_state_ = 1;
#line 97 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	rygel_external_media_container_proxy_list_children (_data_->_tmp10_, _data_->_tmp11_, _data_->_tmp12_, _data_->_tmp13_, _data_->_tmp13__length1, rygel_external_container_get_children_ready, _data_);
#line 97 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	return FALSE;
#line 1180 "rygel-external-container.c"
	_state_1:
#line 97 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->_tmp15_ = NULL;
#line 97 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->_tmp15_ = rygel_external_media_container_proxy_list_children_finish (_data_->_tmp10_, _data_->_res_, &_data_->_tmp14_, &_data_->_inner_error_);
#line 97 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->children_props_length1 = 0;
#line 97 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->_children_props_size_ = 0;
#line 97 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->children_props = _data_->_tmp15_;
#line 97 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->children_props_length1 = _data_->_tmp14_;
#line 97 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->_children_props_size_ = _data_->children_props_length1;
#line 97 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	if (_data_->_inner_error_ != NULL) {
#line 97 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 97 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		g_error_free (_data_->_inner_error_);
#line 97 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->filter = (_vala_array_free (_data_->filter, _data_->filter_length1, (GDestroyNotify) g_free), NULL);
#line 97 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		if (_data_->_state_ == 0) {
#line 97 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1208 "rygel-external-container.c"
		} else {
#line 97 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 1212 "rygel-external-container.c"
		}
#line 97 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		g_object_unref (_data_->_async_result);
#line 97 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		return FALSE;
#line 1218 "rygel-external-container.c"
	}
#line 100 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->_tmp16_ = NULL;
#line 100 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->_tmp16__length1 = 0;
#line 100 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->_tmp16_ = _data_->children_props;
#line 100 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->_tmp16__length1 = _data_->children_props_length1;
#line 100 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->_state_ = 2;
#line 100 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	rygel_external_container_create_media_objects (_data_->self, _data_->_tmp16_, _data_->_tmp16__length1, (RygelMediaContainer*) _data_->self, rygel_external_container_get_children_ready, _data_);
#line 100 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	return FALSE;
#line 1234 "rygel-external-container.c"
	_state_2:
#line 100 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->_tmp17_ = NULL;
#line 100 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->_tmp17_ = rygel_external_container_create_media_objects_finish (_data_->self, _data_->_res_, &_data_->_inner_error_);
#line 100 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->_result_ = _data_->_tmp17_;
#line 100 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	if (_data_->_inner_error_ != NULL) {
#line 100 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 100 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		g_error_free (_data_->_inner_error_);
#line 100 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->children_props = (_vala_array_free (_data_->children_props, _data_->children_props_length1, (GDestroyNotify) g_hash_table_unref), NULL);
#line 100 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->filter = (_vala_array_free (_data_->filter, _data_->filter_length1, (GDestroyNotify) g_free), NULL);
#line 100 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		if (_data_->_state_ == 0) {
#line 100 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1256 "rygel-external-container.c"
		} else {
#line 100 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 1260 "rygel-external-container.c"
		}
#line 100 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		g_object_unref (_data_->_async_result);
#line 100 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		return FALSE;
#line 1266 "rygel-external-container.c"
	}
#line 101 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->_tmp18_ = NULL;
#line 101 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->_tmp18_ = _data_->_result_;
#line 101 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->_tmp19_ = NULL;
#line 101 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->_tmp19_ = _data_->sort_criteria;
#line 101 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	rygel_media_objects_sort_by_criteria (_data_->_tmp18_, _data_->_tmp19_);
#line 103 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->result = _data_->_result_;
#line 103 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->children_props = (_vala_array_free (_data_->children_props, _data_->children_props_length1, (GDestroyNotify) g_hash_table_unref), NULL);
#line 103 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->filter = (_vala_array_free (_data_->filter, _data_->filter_length1, (GDestroyNotify) g_free), NULL);
#line 103 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	if (_data_->_state_ == 0) {
#line 103 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1288 "rygel-external-container.c"
	} else {
#line 103 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 1292 "rygel-external-container.c"
	}
#line 103 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	g_object_unref (_data_->_async_result);
#line 103 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	return FALSE;
#line 77 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_g_object_unref0 (_data_->_result_);
#line 77 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->children_props = (_vala_array_free (_data_->children_props, _data_->children_props_length1, (GDestroyNotify) g_hash_table_unref), NULL);
#line 77 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->filter = (_vala_array_free (_data_->filter, _data_->filter_length1, (GDestroyNotify) g_free), NULL);
#line 77 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	if (_data_->_state_ == 0) {
#line 77 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1308 "rygel-external-container.c"
	} else {
#line 77 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 1312 "rygel-external-container.c"
	}
#line 77 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	g_object_unref (_data_->_async_result);
#line 77 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	return FALSE;
#line 1318 "rygel-external-container.c"
}


static void rygel_external_container_real_search_data_free (gpointer _data) {
	RygelExternalContainerSearchData* _data_;
	_data_ = _data;
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_rygel_search_expression_unref0 (_data_->expression);
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_g_free0 (_data_->sort_criteria);
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_g_object_unref0 (_data_->cancellable);
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_g_object_unref0 (_data_->result);
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_g_object_unref0 (_data_->self);
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	g_slice_free (RygelExternalContainerSearchData, _data_);
#line 1337 "rygel-external-container.c"
}


static gpointer _rygel_search_expression_ref0 (gpointer self) {
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	return self ? rygel_search_expression_ref (self) : NULL;
#line 1344 "rygel-external-container.c"
}


static void rygel_external_container_real_search (RygelSearchableContainer* base, RygelSearchExpression* expression, guint offset, guint max_count, const gchar* sort_criteria, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelExternalContainer * self;
	RygelExternalContainerSearchData* _data_;
	RygelExternalContainer* _tmp0_ = NULL;
	RygelSearchExpression* _tmp1_ = NULL;
	RygelSearchExpression* _tmp2_ = NULL;
	guint _tmp3_ = 0U;
	guint _tmp4_ = 0U;
	const gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	GCancellable* _tmp7_ = NULL;
	GCancellable* _tmp8_ = NULL;
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	self = (RygelExternalContainer*) base;
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_ = g_slice_new0 (RygelExternalContainerSearchData);
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_external_container_real_search);
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_external_container_real_search_data_free);
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->self = _tmp0_;
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_tmp1_ = expression;
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_tmp2_ = _rygel_search_expression_ref0 (_tmp1_);
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_rygel_search_expression_unref0 (_data_->expression);
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->expression = _tmp2_;
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_tmp3_ = offset;
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->offset = _tmp3_;
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_tmp4_ = max_count;
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->max_count = _tmp4_;
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_tmp5_ = sort_criteria;
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_tmp6_ = g_strdup (_tmp5_);
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_g_free0 (_data_->sort_criteria);
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->sort_criteria = _tmp6_;
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_tmp7_ = cancellable;
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_tmp8_ = _g_object_ref0 (_tmp7_);
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_g_object_unref0 (_data_->cancellable);
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->cancellable = _tmp8_;
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	rygel_external_container_real_search_co (_data_);
#line 1406 "rygel-external-container.c"
}


static RygelMediaObjects* rygel_external_container_real_search_finish (RygelSearchableContainer* base, GAsyncResult* _res_, guint* total_matches, GError** error) {
	RygelMediaObjects* result;
	RygelExternalContainerSearchData* _data_;
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		return NULL;
#line 1417 "rygel-external-container.c"
	}
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	if (total_matches) {
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		*total_matches = _data_->total_matches;
#line 1425 "rygel-external-container.c"
	}
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	result = _data_->result;
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->result = NULL;
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	return result;
#line 1433 "rygel-external-container.c"
}


static void rygel_external_container_search_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelExternalContainerSearchData* _data_;
#line 115 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_ = _user_data_;
#line 115 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->_source_object_ = source_object;
#line 115 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->_res_ = _res_;
#line 115 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	rygel_external_container_real_search_co (_data_);
#line 1447 "rygel-external-container.c"
}


static void _vala_array_add4 (gchar*** array, int* length, int* size, gchar* value) {
#line 125 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	if ((*length) == (*size)) {
#line 125 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 125 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		*array = g_renew (gchar*, *array, (*size) + 1);
#line 1458 "rygel-external-container.c"
	}
#line 125 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	(*array)[(*length)++] = value;
#line 125 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	(*array)[*length] = NULL;
#line 1464 "rygel-external-container.c"
}


static void _vala_array_add5 (gchar*** array, int* length, int* size, gchar* value) {
#line 129 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	if ((*length) == (*size)) {
#line 129 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 129 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		*array = g_renew (gchar*, *array, (*size) + 1);
#line 1475 "rygel-external-container.c"
	}
#line 129 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	(*array)[(*length)++] = value;
#line 129 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	(*array)[*length] = NULL;
#line 1481 "rygel-external-container.c"
}


static void _vala_array_add6 (gchar*** array, int* length, int* size, gchar* value) {
#line 133 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	if ((*length) == (*size)) {
#line 133 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 133 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		*array = g_renew (gchar*, *array, (*size) + 1);
#line 1492 "rygel-external-container.c"
	}
#line 133 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	(*array)[(*length)++] = value;
#line 133 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	(*array)[*length] = NULL;
#line 1498 "rygel-external-container.c"
}


static gboolean rygel_external_container_real_search_co (RygelExternalContainerSearchData* _data_) {
#line 106 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	switch (_data_->_state_) {
#line 106 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		case 0:
#line 1507 "rygel-external-container.c"
		goto _state_0;
#line 106 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		case 1:
#line 1511 "rygel-external-container.c"
		goto _state_1;
#line 106 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		case 2:
#line 1515 "rygel-external-container.c"
		goto _state_2;
#line 106 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		case 3:
#line 1519 "rygel-external-container.c"
		goto _state_3;
		default:
#line 106 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		g_assert_not_reached ();
#line 1524 "rygel-external-container.c"
	}
	_state_0:
#line 113 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->_tmp1_ = NULL;
#line 113 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->_tmp1_ = _data_->expression;
#line 113 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	if (_data_->_tmp1_ == NULL) {
#line 113 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->_tmp0_ = TRUE;
#line 1535 "rygel-external-container.c"
	} else {
#line 113 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->_tmp2_ = FALSE;
#line 113 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->_tmp2_ = _data_->self->priv->searchable;
#line 113 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->_tmp0_ = !_data_->_tmp2_;
#line 1543 "rygel-external-container.c"
	}
#line 113 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->_tmp3_ = FALSE;
#line 113 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->_tmp3_ = _data_->_tmp0_;
#line 113 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	if (_data_->_tmp3_) {
#line 115 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->_tmp5_ = NULL;
#line 115 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->_tmp5_ = _data_->expression;
#line 115 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->_tmp6_ = 0U;
#line 115 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->_tmp6_ = _data_->offset;
#line 115 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->_tmp7_ = 0U;
#line 115 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->_tmp7_ = _data_->max_count;
#line 115 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->_tmp8_ = NULL;
#line 115 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->_tmp8_ = _data_->sort_criteria;
#line 115 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->_tmp9_ = NULL;
#line 115 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->_tmp9_ = _data_->cancellable;
#line 115 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->_tmp10_ = 0U;
#line 115 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->_state_ = 1;
#line 115 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		rygel_searchable_container_simple_search ((RygelSearchableContainer*) _data_->self, _data_->_tmp5_, _data_->_tmp6_, _data_->_tmp7_, _data_->_tmp8_, _data_->_tmp9_, rygel_external_container_search_ready, _data_);
#line 115 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		return FALSE;
#line 1579 "rygel-external-container.c"
		_state_1:
#line 115 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->_tmp11_ = NULL;
#line 115 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->_tmp11_ = rygel_searchable_container_simple_search_finish ((RygelSearchableContainer*) _data_->self, _data_->_res_, &_data_->_tmp10_, &_data_->_inner_error_);
#line 115 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->total_matches = _data_->_tmp10_;
#line 115 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->_tmp4_ = _data_->_tmp11_;
#line 115 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		if (_data_->_inner_error_ != NULL) {
#line 115 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 115 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
			g_error_free (_data_->_inner_error_);
#line 115 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
			if (_data_->_state_ == 0) {
#line 115 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1599 "rygel-external-container.c"
			} else {
#line 115 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				g_simple_async_result_complete (_data_->_async_result);
#line 1603 "rygel-external-container.c"
			}
#line 115 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
			g_object_unref (_data_->_async_result);
#line 115 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
			return FALSE;
#line 1609 "rygel-external-container.c"
		}
#line 115 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->result = _data_->_tmp4_;
#line 115 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		if (_data_->_state_ == 0) {
#line 115 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1617 "rygel-external-container.c"
		} else {
#line 115 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 1621 "rygel-external-container.c"
		}
#line 115 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		g_object_unref (_data_->_async_result);
#line 115 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		return FALSE;
#line 1627 "rygel-external-container.c"
	}
#line 123 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->_tmp12_ = NULL;
#line 123 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->_tmp12_ = g_new0 (gchar*, 0 + 1);
#line 123 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->filter_length1 = 0;
#line 123 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->_filter_size_ = 0;
#line 123 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->filter = _data_->_tmp12_;
#line 123 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->filter_length1 = 0;
#line 123 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->_filter_size_ = _data_->filter_length1;
#line 1643 "rygel-external-container.c"
	{
#line 124 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->object_prop_collection_length1 = 0;
#line 124 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->_object_prop_collection_size_ = 0;
#line 124 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->object_prop_collection = RYGEL_EXTERNAL_MEDIA_OBJECT_PROXY_PROPERTIES;
#line 124 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->object_prop_collection_length1 = G_N_ELEMENTS (RYGEL_EXTERNAL_MEDIA_OBJECT_PROXY_PROPERTIES);
#line 124 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		for (_data_->object_prop_it = 0; _data_->object_prop_it < G_N_ELEMENTS (RYGEL_EXTERNAL_MEDIA_OBJECT_PROXY_PROPERTIES); _data_->object_prop_it = _data_->object_prop_it + 1) {
#line 124 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
			_data_->object_prop = _data_->object_prop_collection[_data_->object_prop_it];
#line 1657 "rygel-external-container.c"
			{
#line 125 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				_data_->_tmp13_ = NULL;
#line 125 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				_data_->_tmp13__length1 = 0;
#line 125 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				_data_->_tmp13_ = _data_->filter;
#line 125 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				_data_->_tmp13__length1 = _data_->filter_length1;
#line 125 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				_data_->_tmp14_ = NULL;
#line 125 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				_data_->_tmp14_ = _data_->object_prop;
#line 125 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				_data_->_tmp15_ = NULL;
#line 125 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				_data_->_tmp15_ = g_strdup (_data_->_tmp14_);
#line 125 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				_vala_array_add4 (&_data_->filter, &_data_->filter_length1, &_data_->_filter_size_, _data_->_tmp15_);
#line 1677 "rygel-external-container.c"
			}
		}
	}
	{
#line 128 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->container_prop_collection_length1 = 0;
#line 128 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->_container_prop_collection_size_ = 0;
#line 128 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->container_prop_collection = RYGEL_EXTERNAL_MEDIA_CONTAINER_PROXY_PROPERTIES;
#line 128 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->container_prop_collection_length1 = G_N_ELEMENTS (RYGEL_EXTERNAL_MEDIA_CONTAINER_PROXY_PROPERTIES);
#line 128 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		for (_data_->container_prop_it = 0; _data_->container_prop_it < G_N_ELEMENTS (RYGEL_EXTERNAL_MEDIA_CONTAINER_PROXY_PROPERTIES); _data_->container_prop_it = _data_->container_prop_it + 1) {
#line 128 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
			_data_->container_prop = _data_->container_prop_collection[_data_->container_prop_it];
#line 1694 "rygel-external-container.c"
			{
#line 129 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				_data_->_tmp16_ = NULL;
#line 129 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				_data_->_tmp16__length1 = 0;
#line 129 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				_data_->_tmp16_ = _data_->filter;
#line 129 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				_data_->_tmp16__length1 = _data_->filter_length1;
#line 129 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				_data_->_tmp17_ = NULL;
#line 129 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				_data_->_tmp17_ = _data_->container_prop;
#line 129 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				_data_->_tmp18_ = NULL;
#line 129 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				_data_->_tmp18_ = g_strdup (_data_->_tmp17_);
#line 129 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				_vala_array_add5 (&_data_->filter, &_data_->filter_length1, &_data_->_filter_size_, _data_->_tmp18_);
#line 1714 "rygel-external-container.c"
			}
		}
	}
	{
#line 132 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->item_prop_collection_length1 = 0;
#line 132 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->_item_prop_collection_size_ = 0;
#line 132 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->item_prop_collection = RYGEL_EXTERNAL_MEDIA_ITEM_PROXY_PROPERTIES;
#line 132 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->item_prop_collection_length1 = G_N_ELEMENTS (RYGEL_EXTERNAL_MEDIA_ITEM_PROXY_PROPERTIES);
#line 132 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		for (_data_->item_prop_it = 0; _data_->item_prop_it < G_N_ELEMENTS (RYGEL_EXTERNAL_MEDIA_ITEM_PROXY_PROPERTIES); _data_->item_prop_it = _data_->item_prop_it + 1) {
#line 132 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
			_data_->item_prop = _data_->item_prop_collection[_data_->item_prop_it];
#line 1731 "rygel-external-container.c"
			{
#line 133 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				_data_->_tmp19_ = NULL;
#line 133 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				_data_->_tmp19__length1 = 0;
#line 133 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				_data_->_tmp19_ = _data_->filter;
#line 133 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				_data_->_tmp19__length1 = _data_->filter_length1;
#line 133 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				_data_->_tmp20_ = NULL;
#line 133 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				_data_->_tmp20_ = _data_->item_prop;
#line 133 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				_data_->_tmp21_ = NULL;
#line 133 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				_data_->_tmp21_ = g_strdup (_data_->_tmp20_);
#line 133 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				_vala_array_add6 (&_data_->filter, &_data_->filter_length1, &_data_->_filter_size_, _data_->_tmp21_);
#line 1751 "rygel-external-container.c"
			}
		}
	}
#line 136 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->_tmp22_ = NULL;
#line 136 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->_tmp22_ = _data_->expression;
#line 136 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->_tmp23_ = NULL;
#line 136 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->_tmp23_ = rygel_external_container_translate_expression (_data_->self, _data_->_tmp22_);
#line 136 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->ext_expression = _data_->_tmp23_;
#line 137 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->_tmp24_ = NULL;
#line 137 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->_tmp24_ = _data_->self->actual_container;
#line 137 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->_tmp25_ = NULL;
#line 137 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->_tmp25_ = _data_->ext_expression;
#line 137 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->_tmp26_ = NULL;
#line 137 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->_tmp26_ = rygel_search_expression_to_string (_data_->_tmp25_);
#line 137 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->_tmp27_ = NULL;
#line 137 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->_tmp27_ = _data_->_tmp26_;
#line 137 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->_tmp28_ = 0U;
#line 137 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->_tmp28_ = _data_->offset;
#line 137 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->_tmp29_ = 0U;
#line 137 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->_tmp29_ = _data_->max_count;
#line 137 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->_tmp30_ = NULL;
#line 137 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->_tmp30__length1 = 0;
#line 137 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->_tmp30_ = _data_->filter;
#line 137 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->_tmp30__length1 = _data_->filter_length1;
#line 137 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->_tmp31_ = 0;
#line 137 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->_state_ = 2;
#line 137 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	rygel_external_media_container_proxy_search_objects (_data_->_tmp24_, _data_->_tmp27_, _data_->_tmp28_, _data_->_tmp29_, _data_->_tmp30_, _data_->_tmp30__length1, rygel_external_container_search_ready, _data_);
#line 137 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	return FALSE;
#line 1805 "rygel-external-container.c"
	_state_2:
#line 137 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->_tmp32_ = NULL;
#line 137 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->_tmp32_ = rygel_external_media_container_proxy_search_objects_finish (_data_->_tmp24_, _data_->_res_, &_data_->_tmp31_, &_data_->_inner_error_);
#line 137 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->_tmp33_ = NULL;
#line 137 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->_tmp33__length1 = 0;
#line 137 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->_tmp33_ = _data_->_tmp32_;
#line 137 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->_tmp33__length1 = _data_->_tmp31_;
#line 137 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_g_free0 (_data_->_tmp27_);
#line 137 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->_result__length1 = 0;
#line 137 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->__result__size_ = 0;
#line 137 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->_result_ = _data_->_tmp33_;
#line 137 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->_result__length1 = _data_->_tmp33__length1;
#line 137 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->__result__size_ = _data_->_result__length1;
#line 137 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	if (_data_->_inner_error_ != NULL) {
#line 137 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 137 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		g_error_free (_data_->_inner_error_);
#line 137 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_rygel_search_expression_unref0 (_data_->ext_expression);
#line 137 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->filter = (_vala_array_free (_data_->filter, _data_->filter_length1, (GDestroyNotify) g_free), NULL);
#line 137 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		if (_data_->_state_ == 0) {
#line 137 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1845 "rygel-external-container.c"
		} else {
#line 137 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 1849 "rygel-external-container.c"
		}
#line 137 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		g_object_unref (_data_->_async_result);
#line 137 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		return FALSE;
#line 1855 "rygel-external-container.c"
	}
#line 142 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->_tmp34_ = NULL;
#line 142 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->_tmp34__length1 = 0;
#line 142 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->_tmp34_ = _data_->_result_;
#line 142 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->_tmp34__length1 = _data_->_result__length1;
#line 142 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->total_matches = (guint) _data_->_tmp34__length1;
#line 144 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->_tmp35_ = NULL;
#line 144 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->_tmp35__length1 = 0;
#line 144 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->_tmp35_ = _data_->_result_;
#line 144 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->_tmp35__length1 = _data_->_result__length1;
#line 144 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->_state_ = 3;
#line 144 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	rygel_external_container_create_media_objects (_data_->self, _data_->_tmp35_, _data_->_tmp35__length1, NULL, rygel_external_container_search_ready, _data_);
#line 144 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	return FALSE;
#line 1881 "rygel-external-container.c"
	_state_3:
#line 144 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->_tmp36_ = NULL;
#line 144 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->_tmp36_ = rygel_external_container_create_media_objects_finish (_data_->self, _data_->_res_, &_data_->_inner_error_);
#line 144 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->objects = _data_->_tmp36_;
#line 144 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	if (_data_->_inner_error_ != NULL) {
#line 144 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 144 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		g_error_free (_data_->_inner_error_);
#line 144 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->_result_ = (_vala_array_free (_data_->_result_, _data_->_result__length1, (GDestroyNotify) g_hash_table_unref), NULL);
#line 144 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_rygel_search_expression_unref0 (_data_->ext_expression);
#line 144 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->filter = (_vala_array_free (_data_->filter, _data_->filter_length1, (GDestroyNotify) g_free), NULL);
#line 144 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		if (_data_->_state_ == 0) {
#line 144 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1905 "rygel-external-container.c"
		} else {
#line 144 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 1909 "rygel-external-container.c"
		}
#line 144 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		g_object_unref (_data_->_async_result);
#line 144 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		return FALSE;
#line 1915 "rygel-external-container.c"
	}
#line 147 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->_tmp37_ = NULL;
#line 147 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->_tmp37_ = _data_->objects;
#line 147 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->_tmp38_ = NULL;
#line 147 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->_tmp38_ = _data_->sort_criteria;
#line 147 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	rygel_media_objects_sort_by_criteria (_data_->_tmp37_, _data_->_tmp38_);
#line 149 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->result = _data_->objects;
#line 149 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->_result_ = (_vala_array_free (_data_->_result_, _data_->_result__length1, (GDestroyNotify) g_hash_table_unref), NULL);
#line 149 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_rygel_search_expression_unref0 (_data_->ext_expression);
#line 149 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->filter = (_vala_array_free (_data_->filter, _data_->filter_length1, (GDestroyNotify) g_free), NULL);
#line 149 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	if (_data_->_state_ == 0) {
#line 149 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1939 "rygel-external-container.c"
	} else {
#line 149 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 1943 "rygel-external-container.c"
	}
#line 149 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	g_object_unref (_data_->_async_result);
#line 149 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	return FALSE;
#line 106 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_g_object_unref0 (_data_->objects);
#line 106 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->_result_ = (_vala_array_free (_data_->_result_, _data_->_result__length1, (GDestroyNotify) g_hash_table_unref), NULL);
#line 106 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_rygel_search_expression_unref0 (_data_->ext_expression);
#line 106 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->filter = (_vala_array_free (_data_->filter, _data_->filter_length1, (GDestroyNotify) g_free), NULL);
#line 106 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	if (_data_->_state_ == 0) {
#line 106 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1961 "rygel-external-container.c"
	} else {
#line 106 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 1965 "rygel-external-container.c"
	}
#line 106 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	g_object_unref (_data_->_async_result);
#line 106 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	return FALSE;
#line 1971 "rygel-external-container.c"
}


static void rygel_external_container_real_find_object_data_free (gpointer _data) {
	RygelExternalContainerFindObjectData* _data_;
	_data_ = _data;
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_g_free0 (_data_->id);
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_g_object_unref0 (_data_->cancellable);
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_g_object_unref0 (_data_->result);
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_g_object_unref0 (_data_->self);
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	g_slice_free (RygelExternalContainerFindObjectData, _data_);
#line 1988 "rygel-external-container.c"
}


static void rygel_external_container_real_find_object (RygelMediaContainer* base, const gchar* id, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelExternalContainer * self;
	RygelExternalContainerFindObjectData* _data_;
	RygelExternalContainer* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	GCancellable* _tmp3_ = NULL;
	GCancellable* _tmp4_ = NULL;
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	self = (RygelExternalContainer*) base;
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_ = g_slice_new0 (RygelExternalContainerFindObjectData);
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_external_container_real_find_object);
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_external_container_real_find_object_data_free);
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->self = _tmp0_;
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_tmp1_ = id;
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_tmp2_ = g_strdup (_tmp1_);
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_g_free0 (_data_->id);
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->id = _tmp2_;
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_tmp3_ = cancellable;
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_tmp4_ = _g_object_ref0 (_tmp3_);
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_g_object_unref0 (_data_->cancellable);
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->cancellable = _tmp4_;
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	rygel_external_container_real_find_object_co (_data_);
#line 2030 "rygel-external-container.c"
}


static RygelMediaObject* rygel_external_container_real_find_object_finish (RygelMediaContainer* base, GAsyncResult* _res_, GError** error) {
	RygelMediaObject* result;
	RygelExternalContainerFindObjectData* _data_;
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		return NULL;
#line 2041 "rygel-external-container.c"
	}
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	result = _data_->result;
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->result = NULL;
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	return result;
#line 2051 "rygel-external-container.c"
}


static void rygel_external_container_find_object_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelExternalContainerFindObjectData* _data_;
#line 158 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_ = _user_data_;
#line 158 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->_source_object_ = source_object;
#line 158 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->_res_ = _res_;
#line 158 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	rygel_external_container_real_find_object_co (_data_);
#line 2065 "rygel-external-container.c"
}


static guint _variant_get1 (GVariant* value) {
#line 186 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	return g_variant_get_uint32 (value);
#line 2072 "rygel-external-container.c"
}


static gboolean _variant_get2 (GVariant* value) {
#line 187 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	return g_variant_get_boolean (value);
#line 2079 "rygel-external-container.c"
}


static gchar* _variant_get3 (GVariant* value) {
#line 189 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	return g_variant_dup_string (value, NULL);
#line 2086 "rygel-external-container.c"
}


static gboolean rygel_external_container_real_find_object_co (RygelExternalContainerFindObjectData* _data_) {
#line 152 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	switch (_data_->_state_) {
#line 152 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		case 0:
#line 2095 "rygel-external-container.c"
		goto _state_0;
#line 152 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		case 1:
#line 2099 "rygel-external-container.c"
		goto _state_1;
#line 152 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		case 2:
#line 2103 "rygel-external-container.c"
		goto _state_2;
#line 152 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		case 3:
#line 2107 "rygel-external-container.c"
		goto _state_3;
#line 152 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		case 4:
#line 2111 "rygel-external-container.c"
		goto _state_4;
#line 152 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		case 5:
#line 2115 "rygel-external-container.c"
		goto _state_5;
#line 152 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		case 6:
#line 2119 "rygel-external-container.c"
		goto _state_6;
#line 152 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		case 7:
#line 2123 "rygel-external-container.c"
		goto _state_7;
#line 152 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		case 8:
#line 2127 "rygel-external-container.c"
		goto _state_8;
		default:
#line 152 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		g_assert_not_reached ();
#line 2132 "rygel-external-container.c"
	}
	_state_0:
#line 155 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->media_object = NULL;
#line 158 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->_tmp0_ = NULL;
#line 158 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->_tmp0_ = _data_->self->service_name;
#line 158 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->_tmp1_ = NULL;
#line 158 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->_tmp1_ = _data_->id;
#line 158 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->_state_ = 1;
#line 158 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	g_async_initable_new_async (RYGEL_EXTERNAL_TYPE_MEDIA_OBJECT_PROXY_PROXY, 0, NULL, rygel_external_container_find_object_ready, _data_, "g-flags", 0, "g-name", _data_->_tmp0_, "g-bus-type", G_BUS_TYPE_SESSION, "g-object-path", _data_->_tmp1_, "g-interface-name", "org.gnome.UPnP.MediaObject2", NULL);
#line 158 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	return FALSE;
#line 2151 "rygel-external-container.c"
	_state_1:
#line 158 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->_tmp2_ = NULL;
#line 158 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->_tmp2_ = g_async_initable_new_finish (_data_->_source_object_, _data_->_res_, &_data_->_inner_error_);
#line 158 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->actual_object = (RygelExternalMediaObjectProxy*) _data_->_tmp2_;
#line 158 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	if (_data_->_inner_error_ != NULL) {
#line 158 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 158 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		g_error_free (_data_->_inner_error_);
#line 158 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_g_object_unref0 (_data_->media_object);
#line 158 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		if (_data_->_state_ == 0) {
#line 158 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 2171 "rygel-external-container.c"
		} else {
#line 158 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 2175 "rygel-external-container.c"
		}
#line 158 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		g_object_unref (_data_->_async_result);
#line 158 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		return FALSE;
#line 2181 "rygel-external-container.c"
	}
#line 162 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->_tmp3_ = NULL;
#line 162 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->_tmp3_ = _data_->actual_object;
#line 162 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->_tmp4_ = NULL;
#line 162 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->_tmp4_ = rygel_external_media_object_proxy_get_object_type (_data_->_tmp3_);
#line 162 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->_tmp5_ = NULL;
#line 162 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->_tmp5_ = _data_->_tmp4_;
#line 162 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->_tmp6_ = NULL;
#line 162 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->_tmp6_ = _data_->_tmp5_;
#line 162 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->_tmp7_ = FALSE;
#line 162 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->_tmp7_ = g_strcmp0 (_data_->_tmp6_, "container") == 0;
#line 162 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_g_free0 (_data_->_tmp6_);
#line 162 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	if (_data_->_tmp7_) {
#line 163 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->_tmp8_ = NULL;
#line 163 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->_tmp8_ = _data_->id;
#line 163 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->_tmp9_ = NULL;
#line 163 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->_tmp9_ = rygel_external_container_find_container_by_id (_data_->self, _data_->_tmp8_);
#line 163 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_g_object_unref0 (_data_->media_object);
#line 163 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->media_object = (RygelMediaObject*) _data_->_tmp9_;
#line 165 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->_tmp10_ = NULL;
#line 165 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->_tmp10_ = _data_->media_object;
#line 165 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		if (_data_->_tmp10_ == NULL) {
#line 2225 "rygel-external-container.c"
			{
#line 167 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				_data_->_tmp11_ = NULL;
#line 167 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				_data_->_tmp11_ = _data_->self->priv->containers;
#line 167 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				_data_->_tmp12_ = NULL;
#line 167 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				_data_->_tmp12_ = _g_object_ref0 (_data_->_tmp11_);
#line 167 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				_data_->_container_list = _data_->_tmp12_;
#line 167 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				_data_->_tmp13_ = NULL;
#line 167 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				_data_->_tmp13_ = _data_->_container_list;
#line 167 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				_data_->_tmp14_ = 0;
#line 167 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				_data_->_tmp14_ = gee_abstract_collection_get_size ((GeeCollection*) _data_->_tmp13_);
#line 167 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				_data_->_tmp15_ = 0;
#line 167 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				_data_->_tmp15_ = _data_->_tmp14_;
#line 167 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				_data_->_container_size = _data_->_tmp15_;
#line 167 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				_data_->_container_index = -1;
#line 167 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				while (TRUE) {
#line 167 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
					_data_->_tmp16_ = 0;
#line 167 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
					_data_->_tmp16_ = _data_->_container_index;
#line 167 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
					_data_->_container_index = _data_->_tmp16_ + 1;
#line 167 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
					_data_->_tmp17_ = 0;
#line 167 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
					_data_->_tmp17_ = _data_->_container_index;
#line 167 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
					_data_->_tmp18_ = 0;
#line 167 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
					_data_->_tmp18_ = _data_->_container_size;
#line 167 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
					if (!(_data_->_tmp17_ < _data_->_tmp18_)) {
#line 167 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
						break;
#line 2273 "rygel-external-container.c"
					}
#line 167 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
					_data_->_tmp19_ = NULL;
#line 167 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
					_data_->_tmp19_ = _data_->_container_list;
#line 167 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
					_data_->_tmp20_ = 0;
#line 167 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
					_data_->_tmp20_ = _data_->_container_index;
#line 167 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
					_data_->_tmp21_ = NULL;
#line 167 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
					_data_->_tmp21_ = gee_abstract_list_get ((GeeAbstractList*) _data_->_tmp19_, _data_->_tmp20_);
#line 167 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
					_data_->container = (RygelExternalContainer*) _data_->_tmp21_;
#line 168 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
					_data_->_tmp23_ = NULL;
#line 168 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
					_data_->_tmp23_ = _data_->container;
#line 168 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
					_data_->_tmp24_ = NULL;
#line 168 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
					_data_->_tmp24_ = _data_->id;
#line 168 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
					_data_->_tmp25_ = NULL;
#line 168 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
					_data_->_tmp25_ = _data_->cancellable;
#line 168 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
					_data_->_state_ = 2;
#line 168 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
					rygel_media_container_find_object ((RygelMediaContainer*) _data_->_tmp23_, _data_->_tmp24_, _data_->_tmp25_, rygel_external_container_find_object_ready, _data_);
#line 168 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
					return FALSE;
#line 2307 "rygel-external-container.c"
					_state_2:
#line 168 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
					_data_->_tmp26_ = NULL;
#line 168 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
					_data_->_tmp26_ = rygel_media_container_find_object_finish ((RygelMediaContainer*) _data_->_tmp23_, _data_->_res_, &_data_->_inner_error_);
#line 168 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
					_data_->_tmp22_ = _data_->_tmp26_;
#line 168 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
					if (_data_->_inner_error_ != NULL) {
#line 168 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
						g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 168 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
						g_error_free (_data_->_inner_error_);
#line 168 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
						_g_object_unref0 (_data_->container);
#line 168 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
						_g_object_unref0 (_data_->_container_list);
#line 168 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
						_g_object_unref0 (_data_->actual_object);
#line 168 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
						_g_object_unref0 (_data_->media_object);
#line 168 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
						if (_data_->_state_ == 0) {
#line 168 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
							g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 2333 "rygel-external-container.c"
						} else {
#line 168 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
							g_simple_async_result_complete (_data_->_async_result);
#line 2337 "rygel-external-container.c"
						}
#line 168 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
						g_object_unref (_data_->_async_result);
#line 168 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
						return FALSE;
#line 2343 "rygel-external-container.c"
					}
#line 168 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
					_g_object_unref0 (_data_->media_object);
#line 168 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
					_data_->media_object = _data_->_tmp22_;
#line 171 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
					_data_->_tmp27_ = NULL;
#line 171 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
					_data_->_tmp27_ = _data_->media_object;
#line 171 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
					if (_data_->_tmp27_ != NULL) {
#line 172 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
						_g_object_unref0 (_data_->container);
#line 172 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
						break;
#line 2359 "rygel-external-container.c"
					}
#line 167 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
					_g_object_unref0 (_data_->container);
#line 2363 "rygel-external-container.c"
				}
#line 167 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				_g_object_unref0 (_data_->_container_list);
#line 2367 "rygel-external-container.c"
			}
#line 179 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
			_data_->_tmp28_ = NULL;
#line 179 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
			_data_->_tmp28_ = _data_->self->service_name;
#line 179 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
			_data_->_tmp29_ = NULL;
#line 179 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
			_data_->_tmp29_ = _data_->id;
#line 179 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
			_data_->_state_ = 3;
#line 179 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
			g_async_initable_new_async (FREE_DESKTOP_TYPE_PROPERTIES_PROXY, 0, NULL, rygel_external_container_find_object_ready, _data_, "g-flags", G_DBUS_PROXY_FLAGS_DO_NOT_LOAD_PROPERTIES, "g-name", _data_->_tmp28_, "g-bus-type", G_BUS_TYPE_SESSION, "g-object-path", _data_->_tmp29_, "g-interface-name", "org.freedesktop.DBus.Properties", NULL);
#line 179 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
			return FALSE;
#line 2383 "rygel-external-container.c"
			_state_3:
#line 179 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
			_data_->_tmp30_ = NULL;
#line 179 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
			_data_->_tmp30_ = g_async_initable_new_finish (_data_->_source_object_, _data_->_res_, &_data_->_inner_error_);
#line 179 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
			_data_->props_iface = (FreeDesktopProperties*) _data_->_tmp30_;
#line 179 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
			if (_data_->_inner_error_ != NULL) {
#line 179 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 179 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				g_error_free (_data_->_inner_error_);
#line 179 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				_g_object_unref0 (_data_->actual_object);
#line 179 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				_g_object_unref0 (_data_->media_object);
#line 179 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				if (_data_->_state_ == 0) {
#line 179 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
					g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 2405 "rygel-external-container.c"
				} else {
#line 179 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
					g_simple_async_result_complete (_data_->_async_result);
#line 2409 "rygel-external-container.c"
				}
#line 179 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				g_object_unref (_data_->_async_result);
#line 179 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				return FALSE;
#line 2415 "rygel-external-container.c"
			}
#line 185 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
			_data_->_tmp31_ = NULL;
#line 185 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
			_data_->_tmp31_ = _data_->props_iface;
#line 185 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
			_data_->_state_ = 4;
#line 185 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
			free_desktop_properties_get_all (_data_->_tmp31_, RYGEL_EXTERNAL_MEDIA_CONTAINER_PROXY_IFACE, rygel_external_container_find_object_ready, _data_);
#line 185 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
			return FALSE;
#line 2427 "rygel-external-container.c"
			_state_4:
#line 185 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
			_data_->_tmp32_ = NULL;
#line 185 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
			_data_->_tmp32_ = free_desktop_properties_get_all_finish (_data_->_tmp31_, _data_->_res_, &_data_->_inner_error_);
#line 185 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
			_data_->props = _data_->_tmp32_;
#line 185 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
			if (_data_->_inner_error_ != NULL) {
#line 185 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 185 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				g_error_free (_data_->_inner_error_);
#line 185 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				_g_object_unref0 (_data_->props_iface);
#line 185 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				_g_object_unref0 (_data_->actual_object);
#line 185 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				_g_object_unref0 (_data_->media_object);
#line 185 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				if (_data_->_state_ == 0) {
#line 185 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
					g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 2451 "rygel-external-container.c"
				} else {
#line 185 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
					g_simple_async_result_complete (_data_->_async_result);
#line 2455 "rygel-external-container.c"
				}
#line 185 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				g_object_unref (_data_->_async_result);
#line 185 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				return FALSE;
#line 2461 "rygel-external-container.c"
			}
#line 186 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
			_data_->_tmp33_ = NULL;
#line 186 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
			_data_->_tmp33_ = _data_->props;
#line 186 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
			_data_->_tmp34_ = NULL;
#line 186 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
			_data_->_tmp34_ = g_hash_table_lookup (_data_->_tmp33_, "ChildCount");
#line 186 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
			_data_->_tmp35_ = 0U;
#line 186 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
			_data_->_tmp35_ = _variant_get1 ((GVariant*) _data_->_tmp34_);
#line 186 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
			_data_->child_count = _data_->_tmp35_;
#line 187 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
			_data_->_tmp36_ = NULL;
#line 187 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
			_data_->_tmp36_ = _data_->props;
#line 187 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
			_data_->_tmp37_ = NULL;
#line 187 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
			_data_->_tmp37_ = g_hash_table_lookup (_data_->_tmp36_, "Searchable");
#line 187 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
			_data_->_tmp38_ = FALSE;
#line 187 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
			_data_->_tmp38_ = _variant_get2 ((GVariant*) _data_->_tmp37_);
#line 187 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
			_data_->searchable = _data_->_tmp38_;
#line 188 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
			_data_->_tmp40_ = NULL;
#line 188 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
			_data_->_tmp40_ = _data_->props_iface;
#line 188 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
			_data_->_state_ = 5;
#line 188 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
			free_desktop_properties_get_all (_data_->_tmp40_, RYGEL_EXTERNAL_MEDIA_OBJECT_PROXY_IFACE, rygel_external_container_find_object_ready, _data_);
#line 188 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
			return FALSE;
#line 2501 "rygel-external-container.c"
			_state_5:
#line 188 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
			_data_->_tmp41_ = NULL;
#line 188 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
			_data_->_tmp41_ = free_desktop_properties_get_all_finish (_data_->_tmp40_, _data_->_res_, &_data_->_inner_error_);
#line 188 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
			_data_->_tmp39_ = _data_->_tmp41_;
#line 188 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
			if (_data_->_inner_error_ != NULL) {
#line 188 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 188 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				g_error_free (_data_->_inner_error_);
#line 188 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				_g_hash_table_unref0 (_data_->props);
#line 188 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				_g_object_unref0 (_data_->props_iface);
#line 188 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				_g_object_unref0 (_data_->actual_object);
#line 188 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				_g_object_unref0 (_data_->media_object);
#line 188 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				if (_data_->_state_ == 0) {
#line 188 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
					g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 2527 "rygel-external-container.c"
				} else {
#line 188 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
					g_simple_async_result_complete (_data_->_async_result);
#line 2531 "rygel-external-container.c"
				}
#line 188 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				g_object_unref (_data_->_async_result);
#line 188 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				return FALSE;
#line 2537 "rygel-external-container.c"
			}
#line 188 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
			_g_hash_table_unref0 (_data_->props);
#line 188 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
			_data_->props = _data_->_tmp39_;
#line 189 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
			_data_->_tmp42_ = NULL;
#line 189 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
			_data_->_tmp42_ = _data_->props;
#line 189 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
			_data_->_tmp43_ = NULL;
#line 189 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
			_data_->_tmp43_ = g_hash_table_lookup (_data_->_tmp42_, "Path");
#line 189 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
			_data_->_tmp44_ = NULL;
#line 189 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
			_data_->_tmp44_ = _variant_get3 ((GVariant*) _data_->_tmp43_);
#line 189 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
			_data_->path = _data_->_tmp44_;
#line 190 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
			_data_->_tmp45_ = NULL;
#line 190 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
			_data_->_tmp45_ = _data_->props;
#line 190 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
			_data_->_tmp46_ = NULL;
#line 190 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
			_data_->_tmp46_ = _data_->path;
#line 190 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
			_data_->_tmp47_ = NULL;
#line 190 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
			_data_->_tmp47_ = _data_->self->service_name;
#line 190 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
			_data_->_tmp48_ = NULL;
#line 190 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
			_data_->_tmp48_ = rygel_external_get_mandatory_string_value (_data_->_tmp45_, "DisplayName", _data_->_tmp46_, _data_->_tmp47_);
#line 190 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
			_data_->_tmp49_ = NULL;
#line 190 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
			_data_->_tmp49_ = _data_->_tmp48_;
#line 190 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
			rygel_media_object_set_title ((RygelMediaObject*) _data_->self, _data_->_tmp49_);
#line 190 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
			_g_free0 (_data_->_tmp49_);
#line 195 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
			_data_->_tmp51_ = NULL;
#line 195 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
			_data_->_tmp51_ = _data_->path;
#line 195 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
			_data_->_tmp52_ = NULL;
#line 195 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
			_data_->_tmp52_ = rygel_media_object_get_title ((RygelMediaObject*) _data_->self);
#line 195 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
			_data_->_tmp53_ = NULL;
#line 195 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
			_data_->_tmp53_ = _data_->_tmp52_;
#line 195 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
			_data_->_tmp54_ = 0U;
#line 195 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
			_data_->_tmp54_ = _data_->child_count;
#line 195 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
			_data_->_tmp55_ = FALSE;
#line 195 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
			_data_->_tmp55_ = _data_->searchable;
#line 195 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
			_data_->_tmp56_ = NULL;
#line 195 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
			_data_->_tmp56_ = _data_->self->service_name;
#line 195 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
			_data_->_tmp57_ = NULL;
#line 195 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
			_data_->_tmp57_ = _data_->path;
#line 195 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
			_data_->_tmp58_ = NULL;
#line 195 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
			_data_->_tmp58_ = rygel_external_container_new (_data_->_tmp51_, _data_->_tmp53_, _data_->_tmp54_, _data_->_tmp55_, _data_->_tmp56_, _data_->_tmp57_, _data_->self, &_data_->_inner_error_);
#line 195 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
			_data_->_tmp50_ = _data_->_tmp58_;
#line 195 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
			if (_data_->_inner_error_ != NULL) {
#line 195 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 195 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				g_error_free (_data_->_inner_error_);
#line 195 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				_g_free0 (_data_->path);
#line 195 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				_g_hash_table_unref0 (_data_->props);
#line 195 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				_g_object_unref0 (_data_->props_iface);
#line 195 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				_g_object_unref0 (_data_->actual_object);
#line 195 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				_g_object_unref0 (_data_->media_object);
#line 195 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				if (_data_->_state_ == 0) {
#line 195 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
					g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 2635 "rygel-external-container.c"
				} else {
#line 195 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
					g_simple_async_result_complete (_data_->_async_result);
#line 2639 "rygel-external-container.c"
				}
#line 195 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				g_object_unref (_data_->_async_result);
#line 195 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				return FALSE;
#line 2645 "rygel-external-container.c"
			}
#line 195 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
			_g_object_unref0 (_data_->media_object);
#line 195 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
			_data_->media_object = (RygelMediaObject*) _data_->_tmp50_;
#line 165 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
			_g_free0 (_data_->path);
#line 165 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
			_g_hash_table_unref0 (_data_->props);
#line 165 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
			_g_object_unref0 (_data_->props_iface);
#line 2657 "rygel-external-container.c"
		}
	} else {
#line 204 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->_tmp59_ = NULL;
#line 204 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->_tmp59_ = _data_->actual_object;
#line 204 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->_tmp60_ = NULL;
#line 204 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->_tmp60_ = rygel_external_media_object_proxy_get_parent (_data_->_tmp59_);
#line 204 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->_tmp61_ = NULL;
#line 204 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->_tmp61_ = _data_->_tmp60_;
#line 204 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->_tmp62_ = NULL;
#line 204 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->_tmp62_ = (gchar*) _data_->_tmp61_;
#line 204 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->_tmp63_ = NULL;
#line 204 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->_tmp63_ = rygel_external_dummy_container_new (_data_->_tmp62_, "LaLaLa", (guint) 0, NULL);
#line 204 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->_tmp64_ = NULL;
#line 204 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->_tmp64_ = _data_->_tmp63_;
#line 204 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_g_free0 (_data_->_tmp62_);
#line 204 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->parent_container = _data_->_tmp64_;
#line 210 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->_tmp65_ = NULL;
#line 210 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->_tmp65_ = _data_->self->service_name;
#line 210 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->_tmp66_ = NULL;
#line 210 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->_tmp66_ = _data_->id;
#line 210 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->_state_ = 6;
#line 210 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		g_async_initable_new_async (FREE_DESKTOP_TYPE_PROPERTIES_PROXY, 0, NULL, rygel_external_container_find_object_ready, _data_, "g-flags", G_DBUS_PROXY_FLAGS_DO_NOT_LOAD_PROPERTIES, "g-name", _data_->_tmp65_, "g-bus-type", G_BUS_TYPE_SESSION, "g-object-path", _data_->_tmp66_, "g-interface-name", "org.freedesktop.DBus.Properties", NULL);
#line 210 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		return FALSE;
#line 2702 "rygel-external-container.c"
		_state_6:
#line 210 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->_tmp67_ = NULL;
#line 210 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->_tmp67_ = g_async_initable_new_finish (_data_->_source_object_, _data_->_res_, &_data_->_inner_error_);
#line 210 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->_vala1_props_iface = (FreeDesktopProperties*) _data_->_tmp67_;
#line 210 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		if (_data_->_inner_error_ != NULL) {
#line 210 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 210 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
			g_error_free (_data_->_inner_error_);
#line 210 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
			_g_object_unref0 (_data_->parent_container);
#line 210 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
			_g_object_unref0 (_data_->actual_object);
#line 210 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
			_g_object_unref0 (_data_->media_object);
#line 210 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
			if (_data_->_state_ == 0) {
#line 210 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 2726 "rygel-external-container.c"
			} else {
#line 210 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				g_simple_async_result_complete (_data_->_async_result);
#line 2730 "rygel-external-container.c"
			}
#line 210 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
			g_object_unref (_data_->_async_result);
#line 210 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
			return FALSE;
#line 2736 "rygel-external-container.c"
		}
#line 216 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->_tmp68_ = NULL;
#line 216 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->_tmp68_ = _data_->_vala1_props_iface;
#line 216 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->_state_ = 7;
#line 216 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		free_desktop_properties_get_all (_data_->_tmp68_, RYGEL_EXTERNAL_MEDIA_ITEM_PROXY_IFACE, rygel_external_container_find_object_ready, _data_);
#line 216 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		return FALSE;
#line 2748 "rygel-external-container.c"
		_state_7:
#line 216 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->_tmp69_ = NULL;
#line 216 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->_tmp69_ = free_desktop_properties_get_all_finish (_data_->_tmp68_, _data_->_res_, &_data_->_inner_error_);
#line 216 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->_vala1_props = _data_->_tmp69_;
#line 216 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		if (_data_->_inner_error_ != NULL) {
#line 216 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 216 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
			g_error_free (_data_->_inner_error_);
#line 216 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
			_g_object_unref0 (_data_->_vala1_props_iface);
#line 216 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
			_g_object_unref0 (_data_->parent_container);
#line 216 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
			_g_object_unref0 (_data_->actual_object);
#line 216 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
			_g_object_unref0 (_data_->media_object);
#line 216 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
			if (_data_->_state_ == 0) {
#line 216 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 2774 "rygel-external-container.c"
			} else {
#line 216 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				g_simple_async_result_complete (_data_->_async_result);
#line 2778 "rygel-external-container.c"
			}
#line 216 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
			g_object_unref (_data_->_async_result);
#line 216 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
			return FALSE;
#line 2784 "rygel-external-container.c"
		}
#line 219 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->_tmp71_ = NULL;
#line 219 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->_tmp71_ = _data_->self->priv->item_factory;
#line 219 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->_tmp72_ = NULL;
#line 219 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->_tmp72_ = _data_->id;
#line 219 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->_tmp73_ = NULL;
#line 219 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->_tmp73_ = _data_->actual_object;
#line 219 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->_tmp74_ = NULL;
#line 219 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->_tmp74_ = rygel_external_media_object_proxy_get_object_type (_data_->_tmp73_);
#line 219 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->_tmp75_ = NULL;
#line 219 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->_tmp75_ = _data_->_tmp74_;
#line 219 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->_tmp76_ = NULL;
#line 219 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->_tmp76_ = _data_->_tmp75_;
#line 219 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->_tmp77_ = NULL;
#line 219 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->_tmp77_ = _data_->actual_object;
#line 219 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->_tmp78_ = NULL;
#line 219 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->_tmp78_ = rygel_external_media_object_proxy_get_display_name (_data_->_tmp77_);
#line 219 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->_tmp79_ = NULL;
#line 219 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->_tmp79_ = _data_->_tmp78_;
#line 219 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->_tmp80_ = NULL;
#line 219 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->_tmp80_ = _data_->_tmp79_;
#line 219 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->_tmp81_ = NULL;
#line 219 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->_tmp81_ = _data_->_vala1_props;
#line 219 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->_tmp82_ = NULL;
#line 219 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->_tmp82_ = _data_->self->service_name;
#line 219 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->_tmp83_ = NULL;
#line 219 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->_tmp83_ = _data_->parent_container;
#line 219 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->_state_ = 8;
#line 219 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		rygel_external_item_factory_create (_data_->_tmp71_, _data_->_tmp72_, _data_->_tmp76_, _data_->_tmp80_, _data_->_tmp81_, _data_->_tmp82_, (RygelMediaContainer*) _data_->_tmp83_, rygel_external_container_find_object_ready, _data_);
#line 219 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		return FALSE;
#line 2844 "rygel-external-container.c"
		_state_8:
#line 219 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->_tmp84_ = NULL;
#line 219 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->_tmp84_ = rygel_external_item_factory_create_finish (_data_->_tmp71_, _data_->_res_, &_data_->_inner_error_);
#line 219 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->_tmp85_ = NULL;
#line 219 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->_tmp85_ = _data_->_tmp84_;
#line 219 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_g_free0 (_data_->_tmp80_);
#line 219 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_g_free0 (_data_->_tmp76_);
#line 219 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->_tmp70_ = _data_->_tmp85_;
#line 219 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		if (_data_->_inner_error_ != NULL) {
#line 219 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 219 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
			g_error_free (_data_->_inner_error_);
#line 219 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
			_g_hash_table_unref0 (_data_->_vala1_props);
#line 219 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
			_g_object_unref0 (_data_->_vala1_props_iface);
#line 219 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
			_g_object_unref0 (_data_->parent_container);
#line 219 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
			_g_object_unref0 (_data_->actual_object);
#line 219 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
			_g_object_unref0 (_data_->media_object);
#line 219 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
			if (_data_->_state_ == 0) {
#line 219 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 2880 "rygel-external-container.c"
			} else {
#line 219 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				g_simple_async_result_complete (_data_->_async_result);
#line 2884 "rygel-external-container.c"
			}
#line 219 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
			g_object_unref (_data_->_async_result);
#line 219 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
			return FALSE;
#line 2890 "rygel-external-container.c"
		}
#line 219 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_g_object_unref0 (_data_->media_object);
#line 219 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->media_object = (RygelMediaObject*) _data_->_tmp70_;
#line 162 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_g_hash_table_unref0 (_data_->_vala1_props);
#line 162 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_g_object_unref0 (_data_->_vala1_props_iface);
#line 162 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_g_object_unref0 (_data_->parent_container);
#line 2902 "rygel-external-container.c"
	}
#line 228 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->result = _data_->media_object;
#line 228 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_g_object_unref0 (_data_->actual_object);
#line 228 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	if (_data_->_state_ == 0) {
#line 228 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 2912 "rygel-external-container.c"
	} else {
#line 228 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 2916 "rygel-external-container.c"
	}
#line 228 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	g_object_unref (_data_->_async_result);
#line 228 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	return FALSE;
#line 152 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_g_object_unref0 (_data_->actual_object);
#line 152 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_g_object_unref0 (_data_->media_object);
#line 152 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	if (_data_->_state_ == 0) {
#line 152 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 2930 "rygel-external-container.c"
	} else {
#line 152 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 2934 "rygel-external-container.c"
	}
#line 152 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	g_object_unref (_data_->_async_result);
#line 152 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	return FALSE;
#line 2940 "rygel-external-container.c"
}


static void rygel_external_container_create_media_objects_data_free (gpointer _data) {
	RygelExternalContainerCreateMediaObjectsData* _data_;
	_data_ = _data;
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_g_object_unref0 (_data_->parent);
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_g_object_unref0 (_data_->result);
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_g_object_unref0 (_data_->self);
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	g_slice_free (RygelExternalContainerCreateMediaObjectsData, _data_);
#line 2955 "rygel-external-container.c"
}


static void rygel_external_container_create_media_objects (RygelExternalContainer* self, GHashTable** all_props, int all_props_length1, RygelMediaContainer* parent, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelExternalContainerCreateMediaObjectsData* _data_;
	RygelExternalContainer* _tmp0_ = NULL;
	GHashTable** _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	RygelMediaContainer* _tmp2_ = NULL;
	RygelMediaContainer* _tmp3_ = NULL;
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_ = g_slice_new0 (RygelExternalContainerCreateMediaObjectsData);
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_external_container_create_media_objects);
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_external_container_create_media_objects_data_free);
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->self = _tmp0_;
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_tmp1_ = all_props;
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_tmp1__length1 = all_props_length1;
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->all_props = _tmp1_;
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->all_props_length1 = _tmp1__length1;
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_tmp2_ = parent;
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_tmp3_ = _g_object_ref0 (_tmp2_);
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_g_object_unref0 (_data_->parent);
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->parent = _tmp3_;
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	rygel_external_container_create_media_objects_co (_data_);
#line 2994 "rygel-external-container.c"
}


static RygelMediaObjects* rygel_external_container_create_media_objects_finish (RygelExternalContainer* self, GAsyncResult* _res_, GError** error) {
	RygelMediaObjects* result;
	RygelExternalContainerCreateMediaObjectsData* _data_;
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		return NULL;
#line 3005 "rygel-external-container.c"
	}
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	result = _data_->result;
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->result = NULL;
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	return result;
#line 3015 "rygel-external-container.c"
}


static gpointer _g_hash_table_ref0 (gpointer self) {
#line 237 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	return self ? g_hash_table_ref (self) : NULL;
#line 3022 "rygel-external-container.c"
}


static gchar* _variant_get4 (GVariant* value) {
#line 238 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	return g_variant_dup_string (value, NULL);
#line 3029 "rygel-external-container.c"
}


static gchar* _variant_get5 (GVariant* value) {
#line 239 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	return g_variant_dup_string (value, NULL);
#line 3036 "rygel-external-container.c"
}


static gchar* _variant_get6 (GVariant* value) {
#line 245 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	return g_variant_dup_string (value, NULL);
#line 3043 "rygel-external-container.c"
}


static guint _variant_get7 (GVariant* value) {
#line 265 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	return g_variant_get_uint32 (value);
#line 3050 "rygel-external-container.c"
}


static void rygel_external_container_create_media_objects_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelExternalContainerCreateMediaObjectsData* _data_;
#line 273 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_ = _user_data_;
#line 273 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->_source_object_ = source_object;
#line 273 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->_res_ = _res_;
#line 273 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	rygel_external_container_create_media_objects_co (_data_);
#line 3064 "rygel-external-container.c"
}


static gboolean rygel_external_container_create_media_objects_co (RygelExternalContainerCreateMediaObjectsData* _data_) {
#line 231 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	switch (_data_->_state_) {
#line 231 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		case 0:
#line 3073 "rygel-external-container.c"
		goto _state_0;
#line 231 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		case 1:
#line 3077 "rygel-external-container.c"
		goto _state_1;
		default:
#line 231 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		g_assert_not_reached ();
#line 3082 "rygel-external-container.c"
	}
	_state_0:
#line 235 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->_tmp0_ = NULL;
#line 235 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->_tmp0_ = rygel_media_objects_new ();
#line 235 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->media_objects = _data_->_tmp0_;
#line 237 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->_tmp1_ = NULL;
#line 237 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->_tmp1__length1 = 0;
#line 237 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->_tmp1_ = _data_->all_props;
#line 237 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->_tmp1__length1 = _data_->all_props_length1;
#line 3099 "rygel-external-container.c"
	{
#line 237 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->props_collection_length1 = 0;
#line 237 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->_props_collection_size_ = 0;
#line 237 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->props_collection = _data_->_tmp1_;
#line 237 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->props_collection_length1 = _data_->_tmp1__length1;
#line 237 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		for (_data_->props_it = 0; _data_->props_it < _data_->_tmp1__length1; _data_->props_it = _data_->props_it + 1) {
#line 237 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
			_data_->_tmp2_ = NULL;
#line 237 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
			_data_->_tmp2_ = _g_hash_table_ref0 (_data_->props_collection[_data_->props_it]);
#line 237 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
			_data_->props = _data_->_tmp2_;
#line 3117 "rygel-external-container.c"
			{
#line 238 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				_data_->_tmp3_ = NULL;
#line 238 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				_data_->_tmp3_ = _data_->props;
#line 238 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				_data_->_tmp4_ = NULL;
#line 238 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				_data_->_tmp4_ = g_hash_table_lookup (_data_->_tmp3_, "Path");
#line 238 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				_data_->_tmp5_ = NULL;
#line 238 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				_data_->_tmp5_ = _variant_get4 ((GVariant*) _data_->_tmp4_);
#line 238 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				_data_->id = _data_->_tmp5_;
#line 239 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				_data_->_tmp6_ = NULL;
#line 239 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				_data_->_tmp6_ = _data_->props;
#line 239 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				_data_->_tmp7_ = NULL;
#line 239 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				_data_->_tmp7_ = g_hash_table_lookup (_data_->_tmp6_, "Type");
#line 239 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				_data_->_tmp8_ = NULL;
#line 239 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				_data_->_tmp8_ = _variant_get5 ((GVariant*) _data_->_tmp7_);
#line 239 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				_data_->type = _data_->_tmp8_;
#line 242 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				_data_->_tmp9_ = NULL;
#line 242 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				_data_->_tmp9_ = _data_->parent;
#line 242 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				if (_data_->_tmp9_ != NULL) {
#line 243 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
					_data_->_tmp10_ = NULL;
#line 243 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
					_data_->_tmp10_ = _data_->parent;
#line 243 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
					_data_->_tmp11_ = NULL;
#line 243 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
					_data_->_tmp11_ = _g_object_ref0 (_data_->_tmp10_);
#line 243 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
					_g_object_unref0 (_data_->parent_container);
#line 243 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
					_data_->parent_container = _data_->_tmp11_;
#line 3165 "rygel-external-container.c"
				} else {
#line 245 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
					_data_->_tmp12_ = NULL;
#line 245 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
					_data_->_tmp12_ = _data_->props;
#line 245 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
					_data_->_tmp13_ = NULL;
#line 245 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
					_data_->_tmp13_ = g_hash_table_lookup (_data_->_tmp12_, "Parent");
#line 245 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
					_data_->_tmp14_ = NULL;
#line 245 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
					_data_->_tmp14_ = _variant_get6 ((GVariant*) _data_->_tmp13_);
#line 245 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
					_data_->parent_id = _data_->_tmp14_;
#line 247 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
					_data_->_tmp15_ = NULL;
#line 247 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
					_data_->_tmp15_ = _data_->parent_id;
#line 247 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
					_data_->_tmp16_ = NULL;
#line 247 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
					_data_->_tmp16_ = rygel_external_dummy_container_new (_data_->_tmp15_, "LaLaLa", (guint) 0, NULL);
#line 247 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
					_g_object_unref0 (_data_->parent_container);
#line 247 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
					_data_->parent_container = (RygelMediaContainer*) _data_->_tmp16_;
#line 242 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
					_g_free0 (_data_->parent_id);
#line 3195 "rygel-external-container.c"
				}
#line 253 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				_data_->media_object = NULL;
#line 254 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				_data_->_tmp17_ = NULL;
#line 254 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				_data_->_tmp17_ = _data_->type;
#line 254 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				if (g_strcmp0 (_data_->_tmp17_, "container") == 0) {
#line 255 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
					_data_->_tmp18_ = NULL;
#line 255 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
					_data_->_tmp18_ = _data_->id;
#line 255 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
					_data_->_tmp19_ = NULL;
#line 255 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
					_data_->_tmp19_ = rygel_external_container_find_container_by_id (_data_->self, _data_->_tmp18_);
#line 255 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
					_g_object_unref0 (_data_->media_object);
#line 255 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
					_data_->media_object = (RygelMediaObject*) _data_->_tmp19_;
#line 3217 "rygel-external-container.c"
				}
#line 258 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				_data_->_tmp20_ = NULL;
#line 258 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				_data_->_tmp20_ = _data_->media_object;
#line 258 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				if (_data_->_tmp20_ == NULL) {
#line 259 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
					_data_->_tmp21_ = NULL;
#line 259 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
					_data_->_tmp21_ = _data_->props;
#line 259 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
					_data_->_tmp22_ = NULL;
#line 259 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
					_data_->_tmp22_ = _data_->id;
#line 259 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
					_data_->_tmp23_ = NULL;
#line 259 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
					_data_->_tmp23_ = _data_->self->service_name;
#line 259 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
					_data_->_tmp24_ = NULL;
#line 259 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
					_data_->_tmp24_ = rygel_external_get_mandatory_string_value (_data_->_tmp21_, "DisplayName", _data_->_tmp22_, _data_->_tmp23_);
#line 259 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
					_data_->_tmp25_ = NULL;
#line 259 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
					_data_->_tmp25_ = _data_->_tmp24_;
#line 259 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
					rygel_media_object_set_title ((RygelMediaObject*) _data_->self, _data_->_tmp25_);
#line 259 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
					_g_free0 (_data_->_tmp25_);
#line 264 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
					_data_->_tmp26_ = NULL;
#line 264 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
					_data_->_tmp26_ = _data_->type;
#line 264 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
					if (g_strcmp0 (_data_->_tmp26_, "container") == 0) {
#line 265 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
						_data_->_tmp27_ = NULL;
#line 265 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
						_data_->_tmp27_ = _data_->props;
#line 265 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
						_data_->_tmp28_ = NULL;
#line 265 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
						_data_->_tmp28_ = g_hash_table_lookup (_data_->_tmp27_, "ChildCount");
#line 265 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
						_data_->_tmp29_ = 0U;
#line 265 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
						_data_->_tmp29_ = _variant_get7 ((GVariant*) _data_->_tmp28_);
#line 265 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
						_data_->child_count = _data_->_tmp29_;
#line 267 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
						_data_->_tmp30_ = NULL;
#line 267 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
						_data_->_tmp30_ = _data_->id;
#line 267 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
						_data_->_tmp31_ = NULL;
#line 267 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
						_data_->_tmp31_ = rygel_media_object_get_title ((RygelMediaObject*) _data_->self);
#line 267 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
						_data_->_tmp32_ = NULL;
#line 267 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
						_data_->_tmp32_ = _data_->_tmp31_;
#line 267 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
						_data_->_tmp33_ = 0U;
#line 267 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
						_data_->_tmp33_ = _data_->child_count;
#line 267 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
						_data_->_tmp34_ = NULL;
#line 267 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
						_data_->_tmp34_ = _data_->parent_container;
#line 267 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
						_data_->_tmp35_ = NULL;
#line 267 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
						_data_->_tmp35_ = rygel_external_dummy_container_new (_data_->_tmp30_, _data_->_tmp32_, _data_->_tmp33_, _data_->_tmp34_);
#line 267 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
						_g_object_unref0 (_data_->media_object);
#line 267 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
						_data_->media_object = (RygelMediaObject*) _data_->_tmp35_;
#line 3297 "rygel-external-container.c"
					} else {
#line 273 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
						_data_->_tmp37_ = NULL;
#line 273 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
						_data_->_tmp37_ = _data_->self->priv->item_factory;
#line 273 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
						_data_->_tmp38_ = NULL;
#line 273 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
						_data_->_tmp38_ = _data_->id;
#line 273 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
						_data_->_tmp39_ = NULL;
#line 273 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
						_data_->_tmp39_ = _data_->type;
#line 273 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
						_data_->_tmp40_ = NULL;
#line 273 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
						_data_->_tmp40_ = rygel_media_object_get_title ((RygelMediaObject*) _data_->self);
#line 273 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
						_data_->_tmp41_ = NULL;
#line 273 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
						_data_->_tmp41_ = _data_->_tmp40_;
#line 273 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
						_data_->_tmp42_ = NULL;
#line 273 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
						_data_->_tmp42_ = _data_->props;
#line 273 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
						_data_->_tmp43_ = NULL;
#line 273 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
						_data_->_tmp43_ = _data_->self->service_name;
#line 273 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
						_data_->_tmp44_ = NULL;
#line 273 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
						_data_->_tmp44_ = _data_->parent_container;
#line 273 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
						_data_->_state_ = 1;
#line 273 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
						rygel_external_item_factory_create (_data_->_tmp37_, _data_->_tmp38_, _data_->_tmp39_, _data_->_tmp41_, _data_->_tmp42_, _data_->_tmp43_, _data_->_tmp44_, rygel_external_container_create_media_objects_ready, _data_);
#line 273 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
						return FALSE;
#line 3337 "rygel-external-container.c"
						_state_1:
#line 273 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
						_data_->_tmp45_ = NULL;
#line 273 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
						_data_->_tmp45_ = rygel_external_item_factory_create_finish (_data_->_tmp37_, _data_->_res_, &_data_->_inner_error_);
#line 273 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
						_data_->_tmp36_ = _data_->_tmp45_;
#line 273 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
						if (_data_->_inner_error_ != NULL) {
#line 273 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
							g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 273 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
							g_error_free (_data_->_inner_error_);
#line 273 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
							_g_object_unref0 (_data_->media_object);
#line 273 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
							_g_object_unref0 (_data_->parent_container);
#line 273 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
							_g_free0 (_data_->type);
#line 273 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
							_g_free0 (_data_->id);
#line 273 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
							_g_hash_table_unref0 (_data_->props);
#line 273 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
							_g_object_unref0 (_data_->media_objects);
#line 273 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
							if (_data_->_state_ == 0) {
#line 273 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
								g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 3367 "rygel-external-container.c"
							} else {
#line 273 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
								g_simple_async_result_complete (_data_->_async_result);
#line 3371 "rygel-external-container.c"
							}
#line 273 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
							g_object_unref (_data_->_async_result);
#line 273 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
							return FALSE;
#line 3377 "rygel-external-container.c"
						}
#line 273 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
						_g_object_unref0 (_data_->media_object);
#line 273 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
						_data_->media_object = (RygelMediaObject*) _data_->_tmp36_;
#line 3383 "rygel-external-container.c"
					}
				}
#line 283 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				_data_->_tmp46_ = NULL;
#line 283 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				_data_->_tmp46_ = _data_->media_objects;
#line 283 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				_data_->_tmp47_ = NULL;
#line 283 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				_data_->_tmp47_ = _data_->media_object;
#line 283 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				gee_abstract_collection_add ((GeeAbstractCollection*) _data_->_tmp46_, _data_->_tmp47_);
#line 237 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				_g_object_unref0 (_data_->media_object);
#line 237 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				_g_object_unref0 (_data_->parent_container);
#line 237 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				_g_free0 (_data_->type);
#line 237 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				_g_free0 (_data_->id);
#line 237 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				_g_hash_table_unref0 (_data_->props);
#line 3406 "rygel-external-container.c"
			}
		}
	}
#line 286 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->result = _data_->media_objects;
#line 286 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	if (_data_->_state_ == 0) {
#line 286 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 3416 "rygel-external-container.c"
	} else {
#line 286 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 3420 "rygel-external-container.c"
	}
#line 286 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	g_object_unref (_data_->_async_result);
#line 286 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	return FALSE;
#line 231 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_g_object_unref0 (_data_->media_objects);
#line 231 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	if (_data_->_state_ == 0) {
#line 231 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 3432 "rygel-external-container.c"
	} else {
#line 231 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 3436 "rygel-external-container.c"
	}
#line 231 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	g_object_unref (_data_->_async_result);
#line 231 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	return FALSE;
#line 3442 "rygel-external-container.c"
}


static void rygel_external_container_refresh_child_containers_data_free (gpointer _data) {
	RygelExternalContainerRefreshChildContainersData* _data_;
	_data_ = _data;
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_g_object_unref0 (_data_->self);
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	g_slice_free (RygelExternalContainerRefreshChildContainersData, _data_);
#line 3453 "rygel-external-container.c"
}


static void rygel_external_container_refresh_child_containers (RygelExternalContainer* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelExternalContainerRefreshChildContainersData* _data_;
	RygelExternalContainer* _tmp0_ = NULL;
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_ = g_slice_new0 (RygelExternalContainerRefreshChildContainersData);
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_external_container_refresh_child_containers);
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_external_container_refresh_child_containers_data_free);
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->self = _tmp0_;
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	rygel_external_container_refresh_child_containers_co (_data_);
#line 3472 "rygel-external-container.c"
}


static void rygel_external_container_refresh_child_containers_finish (RygelExternalContainer* self, GAsyncResult* _res_, GError** error) {
	RygelExternalContainerRefreshChildContainersData* _data_;
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		return;
#line 3482 "rygel-external-container.c"
	}
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 3486 "rygel-external-container.c"
}


static void _vala_array_add7 (gchar*** array, int* length, int* size, gchar* value) {
#line 293 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	if ((*length) == (*size)) {
#line 293 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 293 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		*array = g_renew (gchar*, *array, (*size) + 1);
#line 3497 "rygel-external-container.c"
	}
#line 293 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	(*array)[(*length)++] = value;
#line 293 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	(*array)[*length] = NULL;
#line 3503 "rygel-external-container.c"
}


static void _vala_array_add8 (gchar*** array, int* length, int* size, gchar* value) {
#line 297 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	if ((*length) == (*size)) {
#line 297 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 297 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		*array = g_renew (gchar*, *array, (*size) + 1);
#line 3514 "rygel-external-container.c"
	}
#line 297 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	(*array)[(*length)++] = value;
#line 297 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	(*array)[*length] = NULL;
#line 3520 "rygel-external-container.c"
}


static void rygel_external_container_refresh_child_containers_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelExternalContainerRefreshChildContainersData* _data_;
#line 300 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_ = _user_data_;
#line 300 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->_source_object_ = source_object;
#line 300 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->_res_ = _res_;
#line 300 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	rygel_external_container_refresh_child_containers_co (_data_);
#line 3534 "rygel-external-container.c"
}


static gchar* _variant_get8 (GVariant* value) {
#line 305 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	return g_variant_dup_string (value, NULL);
#line 3541 "rygel-external-container.c"
}


static gchar* _variant_get9 (GVariant* value) {
#line 306 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	return g_variant_dup_string (value, NULL);
#line 3548 "rygel-external-container.c"
}


static guint _variant_get10 (GVariant* value) {
#line 307 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	return g_variant_get_uint32 (value);
#line 3555 "rygel-external-container.c"
}


static gboolean _variant_get11 (GVariant* value) {
#line 308 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	return g_variant_get_boolean (value);
#line 3562 "rygel-external-container.c"
}


static gboolean rygel_external_container_refresh_child_containers_co (RygelExternalContainerRefreshChildContainersData* _data_) {
#line 289 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	switch (_data_->_state_) {
#line 289 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		case 0:
#line 3571 "rygel-external-container.c"
		goto _state_0;
#line 289 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		case 1:
#line 3575 "rygel-external-container.c"
		goto _state_1;
		default:
#line 289 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		g_assert_not_reached ();
#line 3580 "rygel-external-container.c"
	}
	_state_0:
#line 290 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->_tmp0_ = NULL;
#line 290 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->_tmp0_ = g_new0 (gchar*, 0 + 1);
#line 290 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->filter_length1 = 0;
#line 290 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->_filter_size_ = 0;
#line 290 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->filter = _data_->_tmp0_;
#line 290 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->filter_length1 = 0;
#line 290 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->_filter_size_ = _data_->filter_length1;
#line 3597 "rygel-external-container.c"
	{
#line 292 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->object_prop_collection_length1 = 0;
#line 292 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->_object_prop_collection_size_ = 0;
#line 292 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->object_prop_collection = RYGEL_EXTERNAL_MEDIA_OBJECT_PROXY_PROPERTIES;
#line 292 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->object_prop_collection_length1 = G_N_ELEMENTS (RYGEL_EXTERNAL_MEDIA_OBJECT_PROXY_PROPERTIES);
#line 292 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		for (_data_->object_prop_it = 0; _data_->object_prop_it < G_N_ELEMENTS (RYGEL_EXTERNAL_MEDIA_OBJECT_PROXY_PROPERTIES); _data_->object_prop_it = _data_->object_prop_it + 1) {
#line 292 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
			_data_->object_prop = _data_->object_prop_collection[_data_->object_prop_it];
#line 3611 "rygel-external-container.c"
			{
#line 293 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				_data_->_tmp1_ = NULL;
#line 293 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				_data_->_tmp1__length1 = 0;
#line 293 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				_data_->_tmp1_ = _data_->filter;
#line 293 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				_data_->_tmp1__length1 = _data_->filter_length1;
#line 293 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				_data_->_tmp2_ = NULL;
#line 293 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				_data_->_tmp2_ = _data_->object_prop;
#line 293 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				_data_->_tmp3_ = NULL;
#line 293 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				_data_->_tmp3_ = g_strdup (_data_->_tmp2_);
#line 293 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				_vala_array_add7 (&_data_->filter, &_data_->filter_length1, &_data_->_filter_size_, _data_->_tmp3_);
#line 3631 "rygel-external-container.c"
			}
		}
	}
	{
#line 296 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->container_prop_collection_length1 = 0;
#line 296 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->_container_prop_collection_size_ = 0;
#line 296 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->container_prop_collection = RYGEL_EXTERNAL_MEDIA_CONTAINER_PROXY_PROPERTIES;
#line 296 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->container_prop_collection_length1 = G_N_ELEMENTS (RYGEL_EXTERNAL_MEDIA_CONTAINER_PROXY_PROPERTIES);
#line 296 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		for (_data_->container_prop_it = 0; _data_->container_prop_it < G_N_ELEMENTS (RYGEL_EXTERNAL_MEDIA_CONTAINER_PROXY_PROPERTIES); _data_->container_prop_it = _data_->container_prop_it + 1) {
#line 296 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
			_data_->container_prop = _data_->container_prop_collection[_data_->container_prop_it];
#line 3648 "rygel-external-container.c"
			{
#line 297 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				_data_->_tmp4_ = NULL;
#line 297 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				_data_->_tmp4__length1 = 0;
#line 297 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				_data_->_tmp4_ = _data_->filter;
#line 297 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				_data_->_tmp4__length1 = _data_->filter_length1;
#line 297 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				_data_->_tmp5_ = NULL;
#line 297 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				_data_->_tmp5_ = _data_->container_prop;
#line 297 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				_data_->_tmp6_ = NULL;
#line 297 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				_data_->_tmp6_ = g_strdup (_data_->_tmp5_);
#line 297 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				_vala_array_add8 (&_data_->filter, &_data_->filter_length1, &_data_->_filter_size_, _data_->_tmp6_);
#line 3668 "rygel-external-container.c"
			}
		}
	}
#line 300 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->_tmp7_ = NULL;
#line 300 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->_tmp7_ = _data_->self->actual_container;
#line 300 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->_tmp8_ = NULL;
#line 300 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->_tmp8__length1 = 0;
#line 300 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->_tmp8_ = _data_->filter;
#line 300 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->_tmp8__length1 = _data_->filter_length1;
#line 300 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->_tmp9_ = 0;
#line 300 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->_state_ = 1;
#line 300 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	rygel_external_media_container_proxy_list_containers (_data_->_tmp7_, (guint) 0, (guint) 0, _data_->_tmp8_, _data_->_tmp8__length1, rygel_external_container_refresh_child_containers_ready, _data_);
#line 300 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	return FALSE;
#line 3692 "rygel-external-container.c"
	_state_1:
#line 300 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->_tmp10_ = NULL;
#line 300 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->_tmp10_ = rygel_external_media_container_proxy_list_containers_finish (_data_->_tmp7_, _data_->_res_, &_data_->_tmp9_, &_data_->_inner_error_);
#line 300 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->children_props_length1 = 0;
#line 300 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->_children_props_size_ = 0;
#line 300 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->children_props = _data_->_tmp10_;
#line 300 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->children_props_length1 = _data_->_tmp9_;
#line 300 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->_children_props_size_ = _data_->children_props_length1;
#line 300 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	if (_data_->_inner_error_ != NULL) {
#line 300 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 300 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		g_error_free (_data_->_inner_error_);
#line 300 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->filter = (_vala_array_free (_data_->filter, _data_->filter_length1, (GDestroyNotify) g_free), NULL);
#line 300 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		if (_data_->_state_ == 0) {
#line 300 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 3720 "rygel-external-container.c"
		} else {
#line 300 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 3724 "rygel-external-container.c"
		}
#line 300 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		g_object_unref (_data_->_async_result);
#line 300 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		return FALSE;
#line 3730 "rygel-external-container.c"
	}
#line 302 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->_tmp11_ = NULL;
#line 302 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->_tmp11_ = _data_->self->priv->containers;
#line 302 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	gee_abstract_collection_clear ((GeeAbstractCollection*) _data_->_tmp11_);
#line 304 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->_tmp12_ = NULL;
#line 304 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->_tmp12__length1 = 0;
#line 304 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->_tmp12_ = _data_->children_props;
#line 304 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->_tmp12__length1 = _data_->children_props_length1;
#line 3746 "rygel-external-container.c"
	{
#line 304 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->props_collection_length1 = 0;
#line 304 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->_props_collection_size_ = 0;
#line 304 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->props_collection = _data_->_tmp12_;
#line 304 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->props_collection_length1 = _data_->_tmp12__length1;
#line 304 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		for (_data_->props_it = 0; _data_->props_it < _data_->_tmp12__length1; _data_->props_it = _data_->props_it + 1) {
#line 304 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
			_data_->_tmp13_ = NULL;
#line 304 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
			_data_->_tmp13_ = _g_hash_table_ref0 (_data_->props_collection[_data_->props_it]);
#line 304 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
			_data_->props = _data_->_tmp13_;
#line 3764 "rygel-external-container.c"
			{
#line 305 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				_data_->_tmp14_ = NULL;
#line 305 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				_data_->_tmp14_ = _data_->props;
#line 305 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				_data_->_tmp15_ = NULL;
#line 305 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				_data_->_tmp15_ = g_hash_table_lookup (_data_->_tmp14_, "Path");
#line 305 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				_data_->_tmp16_ = NULL;
#line 305 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				_data_->_tmp16_ = _variant_get8 ((GVariant*) _data_->_tmp15_);
#line 305 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				_data_->path = _data_->_tmp16_;
#line 306 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				_data_->_tmp17_ = NULL;
#line 306 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				_data_->_tmp17_ = _data_->props;
#line 306 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				_data_->_tmp18_ = NULL;
#line 306 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				_data_->_tmp18_ = g_hash_table_lookup (_data_->_tmp17_, "DisplayName");
#line 306 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				_data_->_tmp19_ = NULL;
#line 306 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				_data_->_tmp19_ = _variant_get9 ((GVariant*) _data_->_tmp18_);
#line 306 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				_data_->title = _data_->_tmp19_;
#line 307 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				_data_->_tmp20_ = NULL;
#line 307 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				_data_->_tmp20_ = _data_->props;
#line 307 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				_data_->_tmp21_ = NULL;
#line 307 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				_data_->_tmp21_ = g_hash_table_lookup (_data_->_tmp20_, "ChildCount");
#line 307 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				_data_->_tmp22_ = 0U;
#line 307 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				_data_->_tmp22_ = _variant_get10 ((GVariant*) _data_->_tmp21_);
#line 307 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				_data_->child_count = _data_->_tmp22_;
#line 308 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				_data_->_tmp23_ = NULL;
#line 308 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				_data_->_tmp23_ = _data_->props;
#line 308 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				_data_->_tmp24_ = NULL;
#line 308 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				_data_->_tmp24_ = g_hash_table_lookup (_data_->_tmp23_, "Searchable");
#line 308 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				_data_->_tmp25_ = FALSE;
#line 308 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				_data_->_tmp25_ = _variant_get11 ((GVariant*) _data_->_tmp24_);
#line 308 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				_data_->searchable = _data_->_tmp25_;
#line 310 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				_data_->_tmp26_ = NULL;
#line 310 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				_data_->_tmp26_ = _data_->path;
#line 310 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				_data_->_tmp27_ = NULL;
#line 310 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				_data_->_tmp27_ = _data_->title;
#line 310 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				_data_->_tmp28_ = 0U;
#line 310 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				_data_->_tmp28_ = _data_->child_count;
#line 310 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				_data_->_tmp29_ = FALSE;
#line 310 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				_data_->_tmp29_ = _data_->searchable;
#line 310 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				_data_->_tmp30_ = NULL;
#line 310 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				_data_->_tmp30_ = _data_->self->service_name;
#line 310 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				_data_->_tmp31_ = NULL;
#line 310 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				_data_->_tmp31_ = _data_->path;
#line 310 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				_data_->_tmp32_ = NULL;
#line 310 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				_data_->_tmp32_ = rygel_external_container_new (_data_->_tmp26_, _data_->_tmp27_, _data_->_tmp28_, _data_->_tmp29_, _data_->_tmp30_, _data_->_tmp31_, _data_->self, &_data_->_inner_error_);
#line 310 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				_data_->container = _data_->_tmp32_;
#line 310 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				if (_data_->_inner_error_ != NULL) {
#line 310 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
					g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 310 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
					g_error_free (_data_->_inner_error_);
#line 310 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
					_g_free0 (_data_->title);
#line 310 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
					_g_free0 (_data_->path);
#line 310 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
					_g_hash_table_unref0 (_data_->props);
#line 310 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
					_data_->children_props = (_vala_array_free (_data_->children_props, _data_->children_props_length1, (GDestroyNotify) g_hash_table_unref), NULL);
#line 310 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
					_data_->filter = (_vala_array_free (_data_->filter, _data_->filter_length1, (GDestroyNotify) g_free), NULL);
#line 310 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
					if (_data_->_state_ == 0) {
#line 310 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
						g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 3872 "rygel-external-container.c"
					} else {
#line 310 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
						g_simple_async_result_complete (_data_->_async_result);
#line 3876 "rygel-external-container.c"
					}
#line 310 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
					g_object_unref (_data_->_async_result);
#line 310 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
					return FALSE;
#line 3882 "rygel-external-container.c"
				}
#line 317 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				_data_->_tmp33_ = NULL;
#line 317 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				_data_->_tmp33_ = _data_->self->priv->containers;
#line 317 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				_data_->_tmp34_ = NULL;
#line 317 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				_data_->_tmp34_ = _data_->container;
#line 317 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				gee_abstract_collection_add ((GeeAbstractCollection*) _data_->_tmp33_, _data_->_tmp34_);
#line 304 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				_g_object_unref0 (_data_->container);
#line 304 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				_g_free0 (_data_->title);
#line 304 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				_g_free0 (_data_->path);
#line 304 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				_g_hash_table_unref0 (_data_->props);
#line 3902 "rygel-external-container.c"
			}
		}
	}
#line 289 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->children_props = (_vala_array_free (_data_->children_props, _data_->children_props_length1, (GDestroyNotify) g_hash_table_unref), NULL);
#line 289 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->filter = (_vala_array_free (_data_->filter, _data_->filter_length1, (GDestroyNotify) g_free), NULL);
#line 289 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	if (_data_->_state_ == 0) {
#line 289 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 3914 "rygel-external-container.c"
	} else {
#line 289 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 3918 "rygel-external-container.c"
	}
#line 289 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	g_object_unref (_data_->_async_result);
#line 289 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	return FALSE;
#line 3924 "rygel-external-container.c"
}


static void rygel_external_container_update_container_data_free (gpointer _data) {
	RygelExternalContainerUpdateContainerData* _data_;
	_data_ = _data;
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_g_object_unref0 (_data_->self);
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	g_slice_free (RygelExternalContainerUpdateContainerData, _data_);
#line 3935 "rygel-external-container.c"
}


static void rygel_external_container_update_container (RygelExternalContainer* self, gboolean connect_signal, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelExternalContainerUpdateContainerData* _data_;
	RygelExternalContainer* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_ = g_slice_new0 (RygelExternalContainerUpdateContainerData);
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_external_container_update_container);
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_external_container_update_container_data_free);
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->self = _tmp0_;
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_tmp1_ = connect_signal;
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->connect_signal = _tmp1_;
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	rygel_external_container_update_container_co (_data_);
#line 3959 "rygel-external-container.c"
}


static void rygel_external_container_update_container_finish (RygelExternalContainer* self, GAsyncResult* _res_) {
	RygelExternalContainerUpdateContainerData* _data_;
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 3967 "rygel-external-container.c"
}


static void rygel_external_container_update_container_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelExternalContainerUpdateContainerData* _data_;
#line 323 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_ = _user_data_;
#line 323 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->_source_object_ = source_object;
#line 323 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->_res_ = _res_;
#line 323 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	rygel_external_container_update_container_co (_data_);
#line 3981 "rygel-external-container.c"
}


static guint _variant_get12 (GVariant* value) {
#line 329 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	return g_variant_get_uint32 (value);
#line 3988 "rygel-external-container.c"
}


static void _rygel_external_container_on_updated_rygel_external_media_container_proxy_updated (RygelExternalMediaContainerProxy* _sender, gpointer self) {
#line 358 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	rygel_external_container_on_updated (self, _sender);
#line 3995 "rygel-external-container.c"
}


static gboolean rygel_external_container_update_container_co (RygelExternalContainerUpdateContainerData* _data_) {
#line 321 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	switch (_data_->_state_) {
#line 321 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		case 0:
#line 4004 "rygel-external-container.c"
		goto _state_0;
#line 321 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		case 1:
#line 4008 "rygel-external-container.c"
		goto _state_1;
#line 321 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		case 2:
#line 4012 "rygel-external-container.c"
		goto _state_2;
#line 321 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		case 3:
#line 4016 "rygel-external-container.c"
		goto _state_3;
#line 321 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		case 4:
#line 4020 "rygel-external-container.c"
		goto _state_4;
		default:
#line 321 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		g_assert_not_reached ();
#line 4025 "rygel-external-container.c"
	}
	_state_0:
	{
#line 323 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->_tmp0_ = NULL;
#line 323 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->_tmp0_ = _data_->self->service_name;
#line 323 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->_tmp1_ = NULL;
#line 323 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->_tmp1_ = _data_->self->actual_container;
#line 323 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->_tmp2_ = NULL;
#line 323 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->_tmp2_ = g_dbus_proxy_get_object_path ((GDBusProxy*) _data_->_tmp1_);
#line 323 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->_state_ = 1;
#line 323 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		g_async_initable_new_async (FREE_DESKTOP_TYPE_PROPERTIES_PROXY, 0, NULL, rygel_external_container_update_container_ready, _data_, "g-flags", G_DBUS_PROXY_FLAGS_DO_NOT_LOAD_PROPERTIES, "g-name", _data_->_tmp0_, "g-bus-type", G_BUS_TYPE_SESSION, "g-object-path", _data_->_tmp2_, "g-interface-name", "org.freedesktop.DBus.Properties", NULL);
#line 323 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		return FALSE;
#line 4047 "rygel-external-container.c"
		_state_1:
#line 323 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->_tmp3_ = NULL;
#line 323 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->_tmp3_ = g_async_initable_new_finish (_data_->_source_object_, _data_->_res_, &_data_->_inner_error_);
#line 323 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->props_iface = (FreeDesktopProperties*) _data_->_tmp3_;
#line 323 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		if (_data_->_inner_error_ != NULL) {
#line 4057 "rygel-external-container.c"
			goto __catch0_g_error;
		}
#line 328 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->_tmp4_ = NULL;
#line 328 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->_tmp4_ = _data_->props_iface;
#line 328 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->_state_ = 2;
#line 328 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		free_desktop_properties_get_all (_data_->_tmp4_, RYGEL_EXTERNAL_MEDIA_CONTAINER_PROXY_IFACE, rygel_external_container_update_container_ready, _data_);
#line 328 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		return FALSE;
#line 4070 "rygel-external-container.c"
		_state_2:
#line 328 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->_tmp5_ = NULL;
#line 328 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->_tmp5_ = free_desktop_properties_get_all_finish (_data_->_tmp4_, _data_->_res_, &_data_->_inner_error_);
#line 328 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->props = _data_->_tmp5_;
#line 328 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		if (_data_->_inner_error_ != NULL) {
#line 328 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
			_g_object_unref0 (_data_->props_iface);
#line 4082 "rygel-external-container.c"
			goto __catch0_g_error;
		}
#line 329 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->_tmp6_ = NULL;
#line 329 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->_tmp6_ = _data_->props;
#line 329 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->_tmp7_ = NULL;
#line 329 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->_tmp7_ = g_hash_table_lookup (_data_->_tmp6_, "ChildCount");
#line 329 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->_tmp8_ = 0U;
#line 329 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->_tmp8_ = _variant_get12 ((GVariant*) _data_->_tmp7_);
#line 329 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->child_count = _data_->_tmp8_;
#line 330 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->_tmp9_ = 0U;
#line 330 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->_tmp9_ = _data_->child_count;
#line 330 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		rygel_media_container_set_child_count ((RygelMediaContainer*) _data_->self, (gint) _data_->_tmp9_);
#line 331 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->_tmp11_ = NULL;
#line 331 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->_tmp11_ = _data_->props_iface;
#line 331 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->_state_ = 3;
#line 331 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		free_desktop_properties_get_all (_data_->_tmp11_, RYGEL_EXTERNAL_MEDIA_OBJECT_PROXY_IFACE, rygel_external_container_update_container_ready, _data_);
#line 331 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		return FALSE;
#line 4115 "rygel-external-container.c"
		_state_3:
#line 331 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->_tmp12_ = NULL;
#line 331 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->_tmp12_ = free_desktop_properties_get_all_finish (_data_->_tmp11_, _data_->_res_, &_data_->_inner_error_);
#line 331 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->_tmp10_ = _data_->_tmp12_;
#line 331 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		if (_data_->_inner_error_ != NULL) {
#line 331 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
			_g_hash_table_unref0 (_data_->props);
#line 331 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
			_g_object_unref0 (_data_->props_iface);
#line 4129 "rygel-external-container.c"
			goto __catch0_g_error;
		}
#line 331 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_g_hash_table_unref0 (_data_->props);
#line 331 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->props = _data_->_tmp10_;
#line 333 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->_tmp13_ = NULL;
#line 333 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->_tmp13_ = _data_->props;
#line 333 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->_tmp14_ = NULL;
#line 333 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->_tmp14_ = rygel_media_object_get_id ((RygelMediaObject*) _data_->self);
#line 333 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->_tmp15_ = NULL;
#line 333 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->_tmp15_ = _data_->_tmp14_;
#line 333 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->_tmp16_ = NULL;
#line 333 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->_tmp16_ = _data_->self->service_name;
#line 333 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->_tmp17_ = NULL;
#line 333 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->_tmp17_ = rygel_external_get_mandatory_string_value (_data_->_tmp13_, "DisplayName", _data_->_tmp15_, _data_->_tmp16_);
#line 333 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->_tmp18_ = NULL;
#line 333 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->_tmp18_ = _data_->_tmp17_;
#line 333 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		rygel_media_object_set_title ((RygelMediaObject*) _data_->self, _data_->_tmp18_);
#line 333 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_g_free0 (_data_->_tmp18_);
#line 322 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_g_hash_table_unref0 (_data_->props);
#line 322 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_g_object_unref0 (_data_->props_iface);
#line 4168 "rygel-external-container.c"
	}
	goto __finally0;
	__catch0_g_error:
	{
#line 322 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->property_error = _data_->_inner_error_;
#line 322 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->_inner_error_ = NULL;
#line 338 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->_tmp19_ = NULL;
#line 338 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->_tmp19_ = _data_->self->actual_container;
#line 338 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->_tmp20_ = NULL;
#line 338 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->_tmp20_ = g_dbus_proxy_get_object_path ((GDBusProxy*) _data_->_tmp19_);
#line 338 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->_tmp21_ = NULL;
#line 338 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->_tmp21_ = _data_->property_error;
#line 338 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->_tmp22_ = NULL;
#line 338 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->_tmp22_ = _data_->_tmp21_->message;
#line 338 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		g_warning ("rygel-external-container.vala:338: Failed to update information about " \
"container '%s': %s", _data_->_tmp20_, _data_->_tmp22_);
#line 322 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_g_error_free0 (_data_->property_error);
#line 4197 "rygel-external-container.c"
	}
	__finally0:
#line 322 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	if (_data_->_inner_error_ != NULL) {
#line 322 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
#line 322 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		g_clear_error (&_data_->_inner_error_);
#line 322 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		return FALSE;
#line 4208 "rygel-external-container.c"
	}
	{
#line 344 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->_tmp23_ = 0;
#line 344 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->_tmp23_ = rygel_media_container_get_child_count ((RygelMediaContainer*) _data_->self);
#line 344 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->_tmp24_ = 0;
#line 344 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->_tmp24_ = _data_->_tmp23_;
#line 344 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->_tmp25_ = 0;
#line 344 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->_tmp25_ = G_MAXINT;
#line 344 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		if (_data_->_tmp24_ < _data_->_tmp25_) {
#line 346 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
			_data_->_state_ = 4;
#line 346 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
			rygel_external_container_refresh_child_containers (_data_->self, rygel_external_container_update_container_ready, _data_);
#line 346 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
			return FALSE;
#line 4231 "rygel-external-container.c"
			_state_4:
#line 346 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
			rygel_external_container_refresh_child_containers_finish (_data_->self, _data_->_res_, &_data_->_inner_error_);
#line 346 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
			if (_data_->_inner_error_ != NULL) {
#line 4237 "rygel-external-container.c"
				goto __catch1_g_error;
			}
		}
	}
	goto __finally1;
	__catch1_g_error:
	{
#line 343 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->err = _data_->_inner_error_;
#line 343 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->_inner_error_ = NULL;
#line 349 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->_tmp26_ = NULL;
#line 349 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->_tmp26_ = _data_->self->actual_container;
#line 349 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->_tmp27_ = NULL;
#line 349 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->_tmp27_ = g_dbus_proxy_get_object_path ((GDBusProxy*) _data_->_tmp26_);
#line 349 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->_tmp28_ = NULL;
#line 349 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->_tmp28_ = _data_->err;
#line 349 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->_tmp29_ = NULL;
#line 349 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->_tmp29_ = _data_->_tmp28_->message;
#line 349 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		g_warning ("rygel-external-container.vala:349: Failed to update information about " \
"container '%s': %s", _data_->_tmp27_, _data_->_tmp29_);
#line 343 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_g_error_free0 (_data_->err);
#line 4269 "rygel-external-container.c"
	}
	__finally1:
#line 343 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	if (_data_->_inner_error_ != NULL) {
#line 343 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
#line 343 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		g_clear_error (&_data_->_inner_error_);
#line 343 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		return FALSE;
#line 4280 "rygel-external-container.c"
	}
#line 355 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	rygel_media_container_updated ((RygelMediaContainer*) _data_->self, NULL, RYGEL_OBJECT_EVENT_TYPE_MODIFIED, FALSE);
#line 357 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->_tmp30_ = FALSE;
#line 357 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->_tmp30_ = _data_->connect_signal;
#line 357 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	if (_data_->_tmp30_) {
#line 358 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->_tmp31_ = NULL;
#line 358 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->_tmp31_ = _data_->self->actual_container;
#line 358 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		g_signal_connect_object (_data_->_tmp31_, "updated", (GCallback) _rygel_external_container_on_updated_rygel_external_media_container_proxy_updated, _data_->self, 0);
#line 4296 "rygel-external-container.c"
	}
#line 321 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	if (_data_->_state_ == 0) {
#line 321 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 4302 "rygel-external-container.c"
	} else {
#line 321 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 4306 "rygel-external-container.c"
	}
#line 321 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	g_object_unref (_data_->_async_result);
#line 321 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	return FALSE;
#line 4312 "rygel-external-container.c"
}


static void rygel_external_container_on_updated (RygelExternalContainer* self, RygelExternalMediaContainerProxy* actual_container) {
#line 362 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	g_return_if_fail (self != NULL);
#line 362 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	g_return_if_fail (actual_container != NULL);
#line 363 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	rygel_external_container_update_container (self, FALSE, NULL, NULL);
#line 4323 "rygel-external-container.c"
}


static RygelMediaContainer* rygel_external_container_find_container_by_id (RygelExternalContainer* self, const gchar* id) {
	RygelMediaContainer* result = NULL;
	RygelMediaContainer* target = NULL;
#line 366 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 366 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	g_return_val_if_fail (id != NULL, NULL);
#line 367 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	target = NULL;
#line 4336 "rygel-external-container.c"
	{
		GeeArrayList* _container_list = NULL;
		GeeArrayList* _tmp0_ = NULL;
		GeeArrayList* _tmp1_ = NULL;
		gint _container_size = 0;
		GeeArrayList* _tmp2_ = NULL;
		gint _tmp3_ = 0;
		gint _tmp4_ = 0;
		gint _container_index = 0;
#line 369 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_tmp0_ = self->priv->containers;
#line 369 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_tmp1_ = _g_object_ref0 (_tmp0_);
#line 369 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_container_list = _tmp1_;
#line 369 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_tmp2_ = _container_list;
#line 369 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_tmp3_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp2_);
#line 369 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_tmp4_ = _tmp3_;
#line 369 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_container_size = _tmp4_;
#line 369 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_container_index = -1;
#line 369 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		while (TRUE) {
#line 4364 "rygel-external-container.c"
			gint _tmp5_ = 0;
			gint _tmp6_ = 0;
			gint _tmp7_ = 0;
			RygelExternalContainer* container = NULL;
			GeeArrayList* _tmp8_ = NULL;
			gint _tmp9_ = 0;
			gpointer _tmp10_ = NULL;
			RygelExternalContainer* _tmp11_ = NULL;
			const gchar* _tmp12_ = NULL;
			const gchar* _tmp13_ = NULL;
			const gchar* _tmp14_ = NULL;
#line 369 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
			_tmp5_ = _container_index;
#line 369 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
			_container_index = _tmp5_ + 1;
#line 369 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
			_tmp6_ = _container_index;
#line 369 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
			_tmp7_ = _container_size;
#line 369 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
			if (!(_tmp6_ < _tmp7_)) {
#line 369 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				break;
#line 4388 "rygel-external-container.c"
			}
#line 369 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
			_tmp8_ = _container_list;
#line 369 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
			_tmp9_ = _container_index;
#line 369 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
			_tmp10_ = gee_abstract_list_get ((GeeAbstractList*) _tmp8_, _tmp9_);
#line 369 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
			container = (RygelExternalContainer*) _tmp10_;
#line 370 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
			_tmp11_ = container;
#line 370 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
			_tmp12_ = rygel_media_object_get_id ((RygelMediaObject*) _tmp11_);
#line 370 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
			_tmp13_ = _tmp12_;
#line 370 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
			_tmp14_ = id;
#line 370 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
			if (g_strcmp0 (_tmp13_, _tmp14_) == 0) {
#line 4408 "rygel-external-container.c"
				RygelExternalContainer* _tmp15_ = NULL;
				RygelMediaContainer* _tmp16_ = NULL;
#line 371 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				_tmp15_ = container;
#line 371 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				_tmp16_ = _g_object_ref0 ((RygelMediaContainer*) _tmp15_);
#line 371 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				_g_object_unref0 (target);
#line 371 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				target = _tmp16_;
#line 373 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				_g_object_unref0 (container);
#line 373 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				break;
#line 4423 "rygel-external-container.c"
			}
#line 369 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
			_g_object_unref0 (container);
#line 4427 "rygel-external-container.c"
		}
#line 369 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_g_object_unref0 (_container_list);
#line 4431 "rygel-external-container.c"
	}
#line 377 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	result = target;
#line 377 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	return result;
#line 4437 "rygel-external-container.c"
}


static RygelSearchExpression* rygel_external_container_translate_expression (RygelExternalContainer* self, RygelSearchExpression* upnp_expression) {
	RygelSearchExpression* result = NULL;
	RygelSearchExpression* _tmp0_ = NULL;
#line 380 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 380 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	g_return_val_if_fail (upnp_expression != NULL, NULL);
#line 382 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_tmp0_ = upnp_expression;
#line 382 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, RYGEL_TYPE_RELATIONAL_EXPRESSION)) {
#line 4452 "rygel-external-container.c"
		RygelRelationalExpression* expression = NULL;
		RygelSearchExpression* _tmp1_ = NULL;
		RygelRelationalExpression* _tmp2_ = NULL;
		RygelRelationalExpression* ext_expression = NULL;
		RygelRelationalExpression* _tmp3_ = NULL;
		RygelRelationalExpression* _tmp4_ = NULL;
		RygelRelationalExpression* _tmp5_ = NULL;
		gconstpointer _tmp6_ = NULL;
		RygelRelationalExpression* _tmp7_ = NULL;
		RygelRelationalExpression* _tmp8_ = NULL;
		gconstpointer _tmp9_ = NULL;
		gchar* _tmp10_ = NULL;
		RygelRelationalExpression* _tmp11_ = NULL;
		RygelRelationalExpression* _tmp12_ = NULL;
		gconstpointer _tmp13_ = NULL;
		gchar* _tmp14_ = NULL;
#line 383 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_tmp1_ = upnp_expression;
#line 383 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_tmp2_ = _rygel_search_expression_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, RYGEL_TYPE_RELATIONAL_EXPRESSION) ? ((RygelRelationalExpression*) _tmp1_) : NULL);
#line 383 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		expression = _tmp2_;
#line 384 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_tmp3_ = rygel_relational_expression_new ();
#line 384 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		ext_expression = _tmp3_;
#line 385 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_tmp4_ = ext_expression;
#line 385 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_tmp5_ = expression;
#line 385 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_tmp6_ = ((RygelSearchExpression*) _tmp5_)->op;
#line 385 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		((RygelSearchExpression*) _tmp4_)->op = (gpointer) ((gintptr) ((GUPnPSearchCriteriaOp) ((gintptr) _tmp6_)));
#line 386 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_tmp7_ = ext_expression;
#line 386 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_tmp8_ = expression;
#line 386 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_tmp9_ = ((RygelSearchExpression*) _tmp8_)->operand1;
#line 386 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_tmp10_ = rygel_external_container_translate_property (self, (const gchar*) _tmp9_);
#line 386 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_g_free0 (((RygelSearchExpression*) _tmp7_)->operand1);
#line 386 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		((RygelSearchExpression*) _tmp7_)->operand1 = _tmp10_;
#line 388 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_tmp11_ = ext_expression;
#line 388 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_tmp12_ = expression;
#line 388 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_tmp13_ = ((RygelSearchExpression*) _tmp12_)->operand2;
#line 388 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_tmp14_ = g_strdup ((const gchar*) _tmp13_);
#line 388 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_g_free0 (((RygelSearchExpression*) _tmp11_)->operand2);
#line 388 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		((RygelSearchExpression*) _tmp11_)->operand2 = _tmp14_;
#line 390 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		result = (RygelSearchExpression*) ext_expression;
#line 390 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_rygel_search_expression_unref0 (expression);
#line 390 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		return result;
#line 4517 "rygel-external-container.c"
	} else {
		RygelLogicalExpression* expression = NULL;
		RygelSearchExpression* _tmp15_ = NULL;
		RygelLogicalExpression* _tmp16_ = NULL;
		RygelLogicalExpression* ext_expression = NULL;
		RygelLogicalExpression* _tmp17_ = NULL;
		RygelLogicalExpression* _tmp18_ = NULL;
		RygelLogicalExpression* _tmp19_ = NULL;
		gconstpointer _tmp20_ = NULL;
		RygelLogicalExpression* _tmp21_ = NULL;
		RygelLogicalExpression* _tmp22_ = NULL;
		gconstpointer _tmp23_ = NULL;
		RygelSearchExpression* _tmp24_ = NULL;
		RygelLogicalExpression* _tmp25_ = NULL;
		RygelLogicalExpression* _tmp26_ = NULL;
		gconstpointer _tmp27_ = NULL;
		RygelSearchExpression* _tmp28_ = NULL;
#line 392 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_tmp15_ = upnp_expression;
#line 392 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_tmp16_ = _rygel_search_expression_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp15_, RYGEL_TYPE_LOGICAL_EXPRESSION) ? ((RygelLogicalExpression*) _tmp15_) : NULL);
#line 392 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		expression = _tmp16_;
#line 393 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_tmp17_ = rygel_logical_expression_new ();
#line 393 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		ext_expression = _tmp17_;
#line 395 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_tmp18_ = ext_expression;
#line 395 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_tmp19_ = expression;
#line 395 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_tmp20_ = ((RygelSearchExpression*) _tmp19_)->op;
#line 395 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		((RygelSearchExpression*) _tmp18_)->op = (gpointer) ((gintptr) ((RygelLogicalOperator) ((gintptr) _tmp20_)));
#line 396 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_tmp21_ = ext_expression;
#line 396 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_tmp22_ = expression;
#line 396 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_tmp23_ = ((RygelSearchExpression*) _tmp22_)->operand1;
#line 396 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_tmp24_ = rygel_external_container_translate_expression (self, (RygelSearchExpression*) _tmp23_);
#line 396 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_rygel_search_expression_unref0 (((RygelSearchExpression*) _tmp21_)->operand1);
#line 396 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		((RygelSearchExpression*) _tmp21_)->operand1 = _tmp24_;
#line 398 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_tmp25_ = ext_expression;
#line 398 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_tmp26_ = expression;
#line 398 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_tmp27_ = ((RygelSearchExpression*) _tmp26_)->operand2;
#line 398 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_tmp28_ = rygel_external_container_translate_expression (self, (RygelSearchExpression*) _tmp27_);
#line 398 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_rygel_search_expression_unref0 (((RygelSearchExpression*) _tmp25_)->operand2);
#line 398 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		((RygelSearchExpression*) _tmp25_)->operand2 = _tmp28_;
#line 401 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		result = (RygelSearchExpression*) ext_expression;
#line 401 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_rygel_search_expression_unref0 (expression);
#line 401 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		return result;
#line 4583 "rygel-external-container.c"
	}
}


gchar* rygel_external_container_translate_property (RygelExternalContainer* self, const gchar* property) {
	gchar* result = NULL;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	GQuark _tmp3_ = 0U;
#line 406 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	static GQuark _tmp2_label0 = 0;
#line 406 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	static GQuark _tmp2_label1 = 0;
#line 406 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	static GQuark _tmp2_label2 = 0;
#line 406 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	static GQuark _tmp2_label3 = 0;
#line 406 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	static GQuark _tmp2_label4 = 0;
#line 406 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	static GQuark _tmp2_label5 = 0;
#line 406 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	static GQuark _tmp2_label6 = 0;
#line 405 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 405 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	g_return_val_if_fail (property != NULL, NULL);
#line 406 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_tmp0_ = property;
#line 406 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_tmp1_ = _tmp0_;
#line 406 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_tmp3_ = (NULL == _tmp1_) ? 0 : g_quark_from_string (_tmp1_);
#line 406 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	if (_tmp3_ == ((0 != _tmp2_label0) ? _tmp2_label0 : (_tmp2_label0 = g_quark_from_static_string ("@id")))) {
#line 406 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		switch (0) {
#line 4621 "rygel-external-container.c"
			default:
			{
				gchar* _tmp4_ = NULL;
#line 408 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				_tmp4_ = g_strdup ("Path");
#line 408 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				result = _tmp4_;
#line 408 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				return result;
#line 4631 "rygel-external-container.c"
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label1) ? _tmp2_label1 : (_tmp2_label1 = g_quark_from_static_string ("@parentID")))) {
#line 406 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		switch (0) {
#line 4637 "rygel-external-container.c"
			default:
			{
				gchar* _tmp5_ = NULL;
#line 410 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				_tmp5_ = g_strdup ("Parent");
#line 410 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				result = _tmp5_;
#line 410 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				return result;
#line 4647 "rygel-external-container.c"
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label2) ? _tmp2_label2 : (_tmp2_label2 = g_quark_from_static_string ("dc:title")))) {
#line 406 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		switch (0) {
#line 4653 "rygel-external-container.c"
			default:
			{
				gchar* _tmp6_ = NULL;
#line 412 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				_tmp6_ = g_strdup ("DisplayName");
#line 412 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				result = _tmp6_;
#line 412 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				return result;
#line 4663 "rygel-external-container.c"
			}
		}
	} else if (((_tmp3_ == ((0 != _tmp2_label3) ? _tmp2_label3 : (_tmp2_label3 = g_quark_from_static_string ("dc:creator")))) || (_tmp3_ == ((0 != _tmp2_label4) ? _tmp2_label4 : (_tmp2_label4 = g_quark_from_static_string ("upnp:artist"))))) || (_tmp3_ == ((0 != _tmp2_label5) ? _tmp2_label5 : (_tmp2_label5 = g_quark_from_static_string ("upnp:author"))))) {
#line 406 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		switch (0) {
#line 4669 "rygel-external-container.c"
			default:
			{
				gchar* _tmp7_ = NULL;
#line 416 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				_tmp7_ = g_strdup ("Artist");
#line 416 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				result = _tmp7_;
#line 416 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				return result;
#line 4679 "rygel-external-container.c"
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label6) ? _tmp2_label6 : (_tmp2_label6 = g_quark_from_static_string ("upnp:album")))) {
#line 406 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		switch (0) {
#line 4685 "rygel-external-container.c"
			default:
			{
				gchar* _tmp8_ = NULL;
#line 418 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				_tmp8_ = g_strdup ("Album");
#line 418 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				result = _tmp8_;
#line 418 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				return result;
#line 4695 "rygel-external-container.c"
			}
		}
	} else {
#line 406 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		switch (0) {
#line 4701 "rygel-external-container.c"
			default:
			{
				const gchar* _tmp9_ = NULL;
				gchar* _tmp10_ = NULL;
#line 420 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				_tmp9_ = property;
#line 420 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				_tmp10_ = g_strdup (_tmp9_);
#line 420 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				result = _tmp10_;
#line 420 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				return result;
#line 4714 "rygel-external-container.c"
			}
		}
	}
}


static GeeArrayList* rygel_external_container_real_get_search_classes (RygelSearchableContainer* base) {
	GeeArrayList* result;
	RygelExternalContainer* self;
	GeeArrayList* _tmp0_ = NULL;
#line 40 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	self = (RygelExternalContainer*) base;
#line 40 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_tmp0_ = self->priv->_search_classes;
#line 40 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	result = _tmp0_;
#line 40 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	return result;
#line 4733 "rygel-external-container.c"
}


static void rygel_external_container_real_set_search_classes (RygelSearchableContainer* base, GeeArrayList* value) {
	RygelExternalContainer* self;
	GeeArrayList* _tmp0_ = NULL;
	GeeArrayList* _tmp1_ = NULL;
#line 40 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	self = (RygelExternalContainer*) base;
#line 40 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_tmp0_ = value;
#line 40 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 40 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_g_object_unref0 (self->priv->_search_classes);
#line 40 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	self->priv->_search_classes = _tmp1_;
#line 40 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	g_object_notify ((GObject *) self, "search-classes");
#line 4753 "rygel-external-container.c"
}


static void rygel_external_container_class_init (RygelExternalContainerClass * klass) {
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	rygel_external_container_parent_class = g_type_class_peek_parent (klass);
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	g_type_class_add_private (klass, sizeof (RygelExternalContainerPrivate));
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	RYGEL_MEDIA_CONTAINER_CLASS (klass)->get_children = rygel_external_container_real_get_children;
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	RYGEL_MEDIA_CONTAINER_CLASS (klass)->get_children_finish = rygel_external_container_real_get_children_finish;
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	RYGEL_MEDIA_CONTAINER_CLASS (klass)->find_object = rygel_external_container_real_find_object;
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	RYGEL_MEDIA_CONTAINER_CLASS (klass)->find_object_finish = rygel_external_container_real_find_object_finish;
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_rygel_external_container_get_property;
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_rygel_external_container_set_property;
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	G_OBJECT_CLASS (klass)->finalize = rygel_external_container_finalize;
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_EXTERNAL_CONTAINER_SEARCH_CLASSES, g_param_spec_object ("search-classes", "search-classes", "search-classes", GEE_TYPE_ARRAY_LIST, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 4778 "rygel-external-container.c"
}


static void rygel_external_container_rygel_searchable_container_interface_init (RygelSearchableContainerIface * iface) {
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	rygel_external_container_rygel_searchable_container_parent_iface = g_type_interface_peek_parent (iface);
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	iface->search = (RygelMediaObjects* (*)(RygelSearchableContainer*, RygelSearchExpression*, guint, guint, guint*, const gchar*, GCancellable*, GError**)) rygel_external_container_real_search;
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	iface->search_finish = rygel_external_container_real_search_finish;
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	iface->get_search_classes = rygel_external_container_real_get_search_classes;
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	iface->set_search_classes = rygel_external_container_real_set_search_classes;
#line 4793 "rygel-external-container.c"
}


static void rygel_external_container_instance_init (RygelExternalContainer * self) {
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	self->priv = RYGEL_EXTERNAL_CONTAINER_GET_PRIVATE (self);
#line 4800 "rygel-external-container.c"
}


static void rygel_external_container_finalize (GObject* obj) {
	RygelExternalContainer * self;
	RygelMediaContainer* _tmp0_ = NULL;
	RygelMediaContainer* _tmp1_ = NULL;
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_EXTERNAL_TYPE_CONTAINER, RygelExternalContainer);
#line 72 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_tmp0_ = rygel_media_object_get_parent ((RygelMediaObject*) self);
#line 72 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_tmp1_ = _tmp0_;
#line 72 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	if (_tmp1_ != NULL) {
#line 4816 "rygel-external-container.c"
		RygelMediaContainer* _tmp2_ = NULL;
		RygelMediaContainer* _tmp3_ = NULL;
#line 73 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_tmp2_ = rygel_media_object_get_parent ((RygelMediaObject*) self);
#line 73 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_tmp3_ = _tmp2_;
#line 73 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		g_object_remove_weak_pointer ((GObject*) _tmp3_, &((RygelMediaObject*) self)->parent_ptr);
#line 4825 "rygel-external-container.c"
	}
#line 34 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_g_object_unref0 (self->actual_container);
#line 36 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_g_free0 (self->service_name);
#line 38 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_rygel_external_item_factory_unref0 (self->priv->item_factory);
#line 39 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_g_object_unref0 (self->priv->containers);
#line 40 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_g_object_unref0 (self->priv->_search_classes);
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	G_OBJECT_CLASS (rygel_external_container_parent_class)->finalize (obj);
#line 4839 "rygel-external-container.c"
}


/**
 * Represents an external container.
 */
GType rygel_external_container_get_type (void) {
	static volatile gsize rygel_external_container_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_external_container_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelExternalContainerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_external_container_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelExternalContainer), 0, (GInstanceInitFunc) rygel_external_container_instance_init, NULL };
		static const GInterfaceInfo rygel_searchable_container_info = { (GInterfaceInitFunc) rygel_external_container_rygel_searchable_container_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType rygel_external_container_type_id;
		rygel_external_container_type_id = g_type_register_static (RYGEL_TYPE_MEDIA_CONTAINER, "RygelExternalContainer", &g_define_type_info, 0);
		g_type_add_interface_static (rygel_external_container_type_id, RYGEL_TYPE_SEARCHABLE_CONTAINER, &rygel_searchable_container_info);
		g_once_init_leave (&rygel_external_container_type_id__volatile, rygel_external_container_type_id);
	}
	return rygel_external_container_type_id__volatile;
}


static void _vala_rygel_external_container_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	RygelExternalContainer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_EXTERNAL_TYPE_CONTAINER, RygelExternalContainer);
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	switch (property_id) {
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		case RYGEL_EXTERNAL_CONTAINER_SEARCH_CLASSES:
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		g_value_set_object (value, rygel_searchable_container_get_search_classes ((RygelSearchableContainer*) self));
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		break;
#line 4871 "rygel-external-container.c"
		default:
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		break;
#line 4877 "rygel-external-container.c"
	}
}


static void _vala_rygel_external_container_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	RygelExternalContainer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_EXTERNAL_TYPE_CONTAINER, RygelExternalContainer);
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	switch (property_id) {
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		case RYGEL_EXTERNAL_CONTAINER_SEARCH_CLASSES:
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		rygel_searchable_container_set_search_classes ((RygelSearchableContainer*) self, g_value_get_object (value));
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		break;
#line 4893 "rygel-external-container.c"
		default:
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		break;
#line 4899 "rygel-external-container.c"
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



