/* rygel-tracker-search-container.c generated by valac 0.22.0, the Vala compiler
 * generated from rygel-tracker-search-container.vala, do not modify */

/*
 * Copyright (C) 2008 Zeeshan Ali <zeenix@gmail.com>.
 * Copyright (C) 2008-2012 Nokia Corporation.
 * Copyright (C) 2010 MediaNet Inh.
 *
 * Authors: Zeeshan Ali <zeenix@gmail.com>
 *          Sunil Mohan Adapa <sunil@medhas.org>
 *         Jens Georg <jensg@openismus.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <rygel-server.h>
#include <libtracker-sparql/tracker-sparql.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>
#include <libgupnp-av/gupnp-av.h>


#define RYGEL_TRACKER_TYPE_SEARCH_CONTAINER (rygel_tracker_search_container_get_type ())
#define RYGEL_TRACKER_SEARCH_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TRACKER_TYPE_SEARCH_CONTAINER, RygelTrackerSearchContainer))
#define RYGEL_TRACKER_SEARCH_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TRACKER_TYPE_SEARCH_CONTAINER, RygelTrackerSearchContainerClass))
#define RYGEL_TRACKER_IS_SEARCH_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TRACKER_TYPE_SEARCH_CONTAINER))
#define RYGEL_TRACKER_IS_SEARCH_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TRACKER_TYPE_SEARCH_CONTAINER))
#define RYGEL_TRACKER_SEARCH_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TRACKER_TYPE_SEARCH_CONTAINER, RygelTrackerSearchContainerClass))

typedef struct _RygelTrackerSearchContainer RygelTrackerSearchContainer;
typedef struct _RygelTrackerSearchContainerClass RygelTrackerSearchContainerClass;
typedef struct _RygelTrackerSearchContainerPrivate RygelTrackerSearchContainerPrivate;

#define RYGEL_TRACKER_TYPE_QUERY (rygel_tracker_query_get_type ())
#define RYGEL_TRACKER_QUERY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TRACKER_TYPE_QUERY, RygelTrackerQuery))
#define RYGEL_TRACKER_QUERY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TRACKER_TYPE_QUERY, RygelTrackerQueryClass))
#define RYGEL_TRACKER_IS_QUERY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TRACKER_TYPE_QUERY))
#define RYGEL_TRACKER_IS_QUERY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TRACKER_TYPE_QUERY))
#define RYGEL_TRACKER_QUERY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TRACKER_TYPE_QUERY, RygelTrackerQueryClass))

typedef struct _RygelTrackerQuery RygelTrackerQuery;
typedef struct _RygelTrackerQueryClass RygelTrackerQueryClass;

#define RYGEL_TRACKER_TYPE_SELECTION_QUERY (rygel_tracker_selection_query_get_type ())
#define RYGEL_TRACKER_SELECTION_QUERY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TRACKER_TYPE_SELECTION_QUERY, RygelTrackerSelectionQuery))
#define RYGEL_TRACKER_SELECTION_QUERY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TRACKER_TYPE_SELECTION_QUERY, RygelTrackerSelectionQueryClass))
#define RYGEL_TRACKER_IS_SELECTION_QUERY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TRACKER_TYPE_SELECTION_QUERY))
#define RYGEL_TRACKER_IS_SELECTION_QUERY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TRACKER_TYPE_SELECTION_QUERY))
#define RYGEL_TRACKER_SELECTION_QUERY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TRACKER_TYPE_SELECTION_QUERY, RygelTrackerSelectionQueryClass))

typedef struct _RygelTrackerSelectionQuery RygelTrackerSelectionQuery;
typedef struct _RygelTrackerSelectionQueryClass RygelTrackerSelectionQueryClass;

#define RYGEL_TRACKER_TYPE_ITEM_FACTORY (rygel_tracker_item_factory_get_type ())
#define RYGEL_TRACKER_ITEM_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TRACKER_TYPE_ITEM_FACTORY, RygelTrackerItemFactory))
#define RYGEL_TRACKER_ITEM_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TRACKER_TYPE_ITEM_FACTORY, RygelTrackerItemFactoryClass))
#define RYGEL_TRACKER_IS_ITEM_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TRACKER_TYPE_ITEM_FACTORY))
#define RYGEL_TRACKER_IS_ITEM_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TRACKER_TYPE_ITEM_FACTORY))
#define RYGEL_TRACKER_ITEM_FACTORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TRACKER_TYPE_ITEM_FACTORY, RygelTrackerItemFactoryClass))

typedef struct _RygelTrackerItemFactory RygelTrackerItemFactory;
typedef struct _RygelTrackerItemFactoryClass RygelTrackerItemFactoryClass;
#define _rygel_tracker_query_unref0(var) ((var == NULL) ? NULL : (var = (rygel_tracker_query_unref (var), NULL)))
#define _rygel_tracker_item_factory_unref0(var) ((var == NULL) ? NULL : (var = (rygel_tracker_item_factory_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define RYGEL_TRACKER_TYPE_QUERY_TRIPLETS (rygel_tracker_query_triplets_get_type ())
#define RYGEL_TRACKER_QUERY_TRIPLETS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TRACKER_TYPE_QUERY_TRIPLETS, RygelTrackerQueryTriplets))
#define RYGEL_TRACKER_QUERY_TRIPLETS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TRACKER_TYPE_QUERY_TRIPLETS, RygelTrackerQueryTripletsClass))
#define RYGEL_TRACKER_IS_QUERY_TRIPLETS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TRACKER_TYPE_QUERY_TRIPLETS))
#define RYGEL_TRACKER_IS_QUERY_TRIPLETS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TRACKER_TYPE_QUERY_TRIPLETS))
#define RYGEL_TRACKER_QUERY_TRIPLETS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TRACKER_TYPE_QUERY_TRIPLETS, RygelTrackerQueryTripletsClass))

typedef struct _RygelTrackerQueryTriplets RygelTrackerQueryTriplets;
typedef struct _RygelTrackerQueryTripletsClass RygelTrackerQueryTripletsClass;
typedef struct _RygelTrackerItemFactoryPrivate RygelTrackerItemFactoryPrivate;

#define RYGEL_TRACKER_TYPE_QUERY_TRIPLET (rygel_tracker_query_triplet_get_type ())
#define RYGEL_TRACKER_QUERY_TRIPLET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TRACKER_TYPE_QUERY_TRIPLET, RygelTrackerQueryTriplet))
#define RYGEL_TRACKER_QUERY_TRIPLET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TRACKER_TYPE_QUERY_TRIPLET, RygelTrackerQueryTripletClass))
#define RYGEL_TRACKER_IS_QUERY_TRIPLET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TRACKER_TYPE_QUERY_TRIPLET))
#define RYGEL_TRACKER_IS_QUERY_TRIPLET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TRACKER_TYPE_QUERY_TRIPLET))
#define RYGEL_TRACKER_QUERY_TRIPLET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TRACKER_TYPE_QUERY_TRIPLET, RygelTrackerQueryTripletClass))

typedef struct _RygelTrackerQueryTriplet RygelTrackerQueryTriplet;
typedef struct _RygelTrackerQueryTripletClass RygelTrackerQueryTripletClass;
#define _rygel_tracker_query_triplet_unref0(var) ((var == NULL) ? NULL : (var = (rygel_tracker_query_triplet_unref (var), NULL)))

#define RYGEL_TRACKER_TYPE_UPN_PPROPERTY_MAP (rygel_tracker_upn_pproperty_map_get_type ())
#define RYGEL_TRACKER_UPN_PPROPERTY_MAP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TRACKER_TYPE_UPN_PPROPERTY_MAP, RygelTrackerUPnPPropertyMap))
#define RYGEL_TRACKER_UPN_PPROPERTY_MAP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TRACKER_TYPE_UPN_PPROPERTY_MAP, RygelTrackerUPnPPropertyMapClass))
#define RYGEL_TRACKER_IS_UPN_PPROPERTY_MAP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TRACKER_TYPE_UPN_PPROPERTY_MAP))
#define RYGEL_TRACKER_IS_UPN_PPROPERTY_MAP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TRACKER_TYPE_UPN_PPROPERTY_MAP))
#define RYGEL_TRACKER_UPN_PPROPERTY_MAP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TRACKER_TYPE_UPN_PPROPERTY_MAP, RygelTrackerUPnPPropertyMapClass))

typedef struct _RygelTrackerUPnPPropertyMap RygelTrackerUPnPPropertyMap;
typedef struct _RygelTrackerUPnPPropertyMapClass RygelTrackerUPnPPropertyMapClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _rygel_search_expression_unref0(var) ((var == NULL) ? NULL : (var = (rygel_search_expression_unref (var), NULL)))
typedef struct _RygelTrackerSearchContainerGetChildrenData RygelTrackerSearchContainerGetChildrenData;
typedef struct _RygelTrackerQueryPrivate RygelTrackerQueryPrivate;
typedef struct _RygelTrackerSelectionQueryPrivate RygelTrackerSelectionQueryPrivate;
typedef struct _RygelTrackerSearchContainerExecuteQueryData RygelTrackerSearchContainerExecuteQueryData;
typedef struct _RygelTrackerSearchContainerFindObjectData RygelTrackerSearchContainerFindObjectData;
typedef struct _RygelTrackerSearchContainerGetChildrenCountData RygelTrackerSearchContainerGetChildrenCountData;
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))

struct _RygelTrackerSearchContainer {
	RygelSimpleContainer parent_instance;
	RygelTrackerSearchContainerPrivate * priv;
	RygelTrackerSelectionQuery* query;
	RygelTrackerItemFactory* item_factory;
};

struct _RygelTrackerSearchContainerClass {
	RygelSimpleContainerClass parent_class;
};

struct _RygelTrackerSearchContainerPrivate {
	TrackerSparqlConnection* resources;
};

struct _RygelTrackerItemFactory {
	GTypeInstance parent_instance;
	volatile int ref_count;
	RygelTrackerItemFactoryPrivate * priv;
	gchar* category;
	gchar* category_iri;
	gchar* upnp_class;
	gchar* upload_dir;
	GeeArrayList* properties;
};

struct _RygelTrackerItemFactoryClass {
	GTypeClass parent_class;
	void (*finalize) (RygelTrackerItemFactory *self);
	RygelMediaItem* (*create) (RygelTrackerItemFactory* self, const gchar* id, const gchar* uri, RygelTrackerSearchContainer* parent, TrackerSparqlCursor* metadata, GError** error);
	void (*set_metadata) (RygelTrackerItemFactory* self, RygelMediaItem* item, const gchar* uri, TrackerSparqlCursor* metadata, GError** error);
};

struct _RygelTrackerSearchContainerGetChildrenData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelTrackerSearchContainer* self;
	guint offset;
	guint max_count;
	gchar* sort_criteria;
	GCancellable* cancellable;
	RygelMediaObjects* result;
	RygelRelationalExpression* expression;
	RygelRelationalExpression* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	guint total_matches;
	RygelMediaObjects* _tmp5_;
	const gchar* _tmp6_;
	guint _tmp7_;
	guint _tmp8_;
	GCancellable* _tmp9_;
	guint _tmp10_;
	RygelMediaObjects* _tmp11_;
	GError * _inner_error_;
};

struct _RygelTrackerQuery {
	GTypeInstance parent_instance;
	volatile int ref_count;
	RygelTrackerQueryPrivate * priv;
	RygelTrackerQueryTriplets* triplets;
};

struct _RygelTrackerQueryClass {
	GTypeClass parent_class;
	void (*finalize) (RygelTrackerQuery *self);
	void (*execute) (RygelTrackerQuery* self, TrackerSparqlConnection* resources, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*execute_finish) (RygelTrackerQuery* self, GAsyncResult* _res_, GError** error);
	gchar* (*to_string) (RygelTrackerQuery* self);
};

struct _RygelTrackerSelectionQuery {
	RygelTrackerQuery parent_instance;
	RygelTrackerSelectionQueryPrivate * priv;
	GeeArrayList* variables;
	GeeArrayList* filters;
	gchar* order_by;
	gint offset;
	gint max_count;
	TrackerSparqlCursor* result;
};

struct _RygelTrackerSelectionQueryClass {
	RygelTrackerQueryClass parent_class;
};

struct _RygelTrackerSearchContainerExecuteQueryData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelTrackerSearchContainer* self;
	RygelSearchExpression* expression;
	gchar* sort_criteria;
	guint offset;
	guint max_count;
	guint total_matches;
	GCancellable* cancellable;
	RygelMediaObjects* result;
	RygelMediaObjects* results;
	RygelMediaObjects* _tmp0_;
	RygelTrackerSelectionQuery* query;
	RygelSearchExpression* _tmp1_;
	guint _tmp2_;
	guint _tmp3_;
	const gchar* _tmp4_;
	RygelTrackerSelectionQuery* _tmp5_;
	RygelTrackerSelectionQuery* _tmp6_;
	RygelTrackerSelectionQuery* _tmp7_;
	TrackerSparqlConnection* _tmp8_;
	gboolean _tmp9_;
	RygelTrackerSelectionQuery* _tmp10_;
	TrackerSparqlCursor* _tmp11_;
	gboolean _tmp12_;
	gchar* id;
	RygelTrackerSelectionQuery* _tmp13_;
	TrackerSparqlCursor* _tmp14_;
	const gchar* _tmp15_;
	gchar* _tmp16_;
	const gchar* _tmp17_;
	gchar* _tmp18_;
	gchar* uri;
	RygelTrackerSelectionQuery* _tmp19_;
	TrackerSparqlCursor* _tmp20_;
	const gchar* _tmp21_;
	gchar* _tmp22_;
	RygelMediaItem* item;
	RygelTrackerItemFactory* _tmp23_;
	const gchar* _tmp24_;
	const gchar* _tmp25_;
	RygelTrackerSelectionQuery* _tmp26_;
	TrackerSparqlCursor* _tmp27_;
	RygelMediaItem* _tmp28_;
	RygelMediaObjects* _tmp29_;
	RygelMediaItem* _tmp30_;
	RygelMediaObjects* _tmp31_;
	gint _tmp32_;
	gint _tmp33_;
	GError * _inner_error_;
};

struct _RygelTrackerSearchContainerFindObjectData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelTrackerSearchContainer* self;
	gchar* id;
	GCancellable* cancellable;
	RygelMediaObject* result;
	const gchar* _tmp0_;
	gboolean _tmp1_;
	RygelRelationalExpression* expression;
	RygelRelationalExpression* _tmp2_;
	RygelRelationalExpression* _tmp3_;
	RygelRelationalExpression* _tmp4_;
	gchar* _tmp5_;
	RygelRelationalExpression* _tmp6_;
	const gchar* _tmp7_;
	gchar* _tmp8_;
	guint total_matches;
	RygelMediaObjects* results;
	RygelRelationalExpression* _tmp9_;
	GCancellable* _tmp10_;
	guint _tmp11_;
	RygelMediaObjects* _tmp12_;
	RygelMediaObjects* _tmp13_;
	gint _tmp14_;
	gint _tmp15_;
	RygelMediaObjects* _tmp16_;
	gpointer _tmp17_;
	GError * _inner_error_;
};

struct _RygelTrackerSearchContainerGetChildrenCountData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelTrackerSearchContainer* self;
	RygelTrackerSelectionQuery* query;
	RygelTrackerSelectionQuery* _tmp0_;
	RygelTrackerSelectionQuery* _tmp1_;
	RygelTrackerSelectionQuery* _tmp2_;
	GeeArrayList* _tmp3_;
	RygelTrackerSelectionQuery* _tmp4_;
	GeeArrayList* _tmp5_;
	RygelTrackerSelectionQuery* _tmp6_;
	TrackerSparqlConnection* _tmp7_;
	gboolean _tmp8_;
	RygelTrackerSelectionQuery* _tmp9_;
	TrackerSparqlCursor* _tmp10_;
	gboolean _tmp11_;
	RygelTrackerSelectionQuery* _tmp12_;
	TrackerSparqlCursor* _tmp13_;
	const gchar* _tmp14_;
	gint _tmp15_;
	GError* _error_;
	const gchar* _tmp16_;
	RygelTrackerItemFactory* _tmp17_;
	const gchar* _tmp18_;
	GError* _tmp19_;
	const gchar* _tmp20_;
	GError * _inner_error_;
};


static gpointer rygel_tracker_search_container_parent_class = NULL;
static GeeHashMap* rygel_tracker_search_container_update_id_hash;
static GeeHashMap* rygel_tracker_search_container_update_id_hash = NULL;

GType rygel_tracker_search_container_get_type (void) G_GNUC_CONST;
gpointer rygel_tracker_query_ref (gpointer instance);
void rygel_tracker_query_unref (gpointer instance);
GParamSpec* rygel_tracker_param_spec_query (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_tracker_value_set_query (GValue* value, gpointer v_object);
void rygel_tracker_value_take_query (GValue* value, gpointer v_object);
gpointer rygel_tracker_value_get_query (const GValue* value);
GType rygel_tracker_query_get_type (void) G_GNUC_CONST;
GType rygel_tracker_selection_query_get_type (void) G_GNUC_CONST;
gpointer rygel_tracker_item_factory_ref (gpointer instance);
void rygel_tracker_item_factory_unref (gpointer instance);
GParamSpec* rygel_tracker_param_spec_item_factory (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_tracker_value_set_item_factory (GValue* value, gpointer v_object);
void rygel_tracker_value_take_item_factory (GValue* value, gpointer v_object);
gpointer rygel_tracker_value_get_item_factory (const GValue* value);
GType rygel_tracker_item_factory_get_type (void) G_GNUC_CONST;
#define RYGEL_TRACKER_SEARCH_CONTAINER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TRACKER_TYPE_SEARCH_CONTAINER, RygelTrackerSearchContainerPrivate))
enum  {
	RYGEL_TRACKER_SEARCH_CONTAINER_DUMMY_PROPERTY
};
#define RYGEL_TRACKER_SEARCH_CONTAINER_MODIFIED_PROPERTY "nfo:fileLastModified"
GType rygel_tracker_query_triplets_get_type (void) G_GNUC_CONST;
RygelTrackerSearchContainer* rygel_tracker_search_container_new (const gchar* id, RygelMediaContainer* parent, const gchar* title, RygelTrackerItemFactory* item_factory, RygelTrackerQueryTriplets* triplets, GeeArrayList* filters);
RygelTrackerSearchContainer* rygel_tracker_search_container_construct (GType object_type, const gchar* id, RygelMediaContainer* parent, const gchar* title, RygelTrackerItemFactory* item_factory, RygelTrackerQueryTriplets* triplets, GeeArrayList* filters);
static void __lambda2_ (RygelTrackerSearchContainer* self, RygelMediaContainer* container, RygelMediaObject* origin);
static void ___lambda2__rygel_media_container_container_updated (RygelMediaContainer* _sender, RygelMediaContainer* container, RygelMediaObject* object, RygelObjectEventType event_type, gboolean sub_tree_update, gpointer self);
#define RYGEL_TRACKER_SELECTION_QUERY_ITEM_VARIABLE "?item"
RygelTrackerQueryTriplets* rygel_tracker_query_triplets_new (void);
RygelTrackerQueryTriplets* rygel_tracker_query_triplets_construct (GType object_type);
RygelTrackerQueryTriplet* rygel_tracker_query_triplet_new (const gchar* subject, const gchar* predicate, const gchar* obj);
RygelTrackerQueryTriplet* rygel_tracker_query_triplet_construct (GType object_type, const gchar* subject, const gchar* predicate, const gchar* obj);
gpointer rygel_tracker_query_triplet_ref (gpointer instance);
void rygel_tracker_query_triplet_unref (gpointer instance);
GParamSpec* rygel_tracker_param_spec_query_triplet (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_tracker_value_set_query_triplet (GValue* value, gpointer v_object);
void rygel_tracker_value_take_query_triplet (GValue* value, gpointer v_object);
gpointer rygel_tracker_value_get_query_triplet (const GValue* value);
GType rygel_tracker_query_triplet_get_type (void) G_GNUC_CONST;
GType rygel_tracker_upn_pproperty_map_get_type (void) G_GNUC_CONST;
RygelTrackerUPnPPropertyMap* rygel_tracker_upn_pproperty_map_get_property_map (void);
gchar* rygel_tracker_upn_pproperty_map_get (RygelTrackerUPnPPropertyMap* self, const gchar* property);
RygelTrackerSelectionQuery* rygel_tracker_selection_query_new (GeeArrayList* variables, RygelTrackerQueryTriplets* triplets, GeeArrayList* filters, const gchar* order_by, gint offset, gint max_count);
RygelTrackerSelectionQuery* rygel_tracker_selection_query_construct (GType object_type, GeeArrayList* variables, RygelTrackerQueryTriplets* triplets, GeeArrayList* filters, const gchar* order_by, gint offset, gint max_count);
void rygel_tracker_search_container_get_children_count (RygelTrackerSearchContainer* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void rygel_tracker_search_container_get_children_count_finish (RygelTrackerSearchContainer* self, GAsyncResult* _res_);
static void rygel_tracker_search_container_real_get_children_data_free (gpointer _data);
static void rygel_tracker_search_container_real_get_children (RygelMediaContainer* base, guint offset, guint max_count, const gchar* sort_criteria, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean rygel_tracker_search_container_real_get_children_co (RygelTrackerSearchContainerGetChildrenData* _data_);
void rygel_tracker_search_container_execute_query (RygelTrackerSearchContainer* self, RygelSearchExpression* expression, const gchar* sort_criteria, guint offset, guint max_count, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
RygelMediaObjects* rygel_tracker_search_container_execute_query_finish (RygelTrackerSearchContainer* self, GAsyncResult* _res_, guint* total_matches, GError** error);
static void rygel_tracker_search_container_get_children_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void rygel_tracker_search_container_execute_query_data_free (gpointer _data);
static gboolean rygel_tracker_search_container_execute_query_co (RygelTrackerSearchContainerExecuteQueryData* _data_);
static RygelTrackerSelectionQuery* rygel_tracker_search_container_create_query (RygelTrackerSearchContainer* self, RygelRelationalExpression* expression, gint offset, gint max_count, const gchar* sort_criteria);
void rygel_tracker_query_execute (RygelTrackerQuery* self, TrackerSparqlConnection* resources, GAsyncReadyCallback _callback_, gpointer _user_data_);
void rygel_tracker_query_execute_finish (RygelTrackerQuery* self, GAsyncResult* _res_, GError** error);
static void rygel_tracker_search_container_execute_query_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
gchar* rygel_tracker_search_container_create_child_id_for_urn (RygelTrackerSearchContainer* self, const gchar* urn);
RygelMediaItem* rygel_tracker_item_factory_create (RygelTrackerItemFactory* self, const gchar* id, const gchar* uri, RygelTrackerSearchContainer* parent, TrackerSparqlCursor* metadata, GError** error);
static void rygel_tracker_search_container_real_find_object_data_free (gpointer _data);
static void rygel_tracker_search_container_real_find_object (RygelMediaContainer* base, const gchar* id, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean rygel_tracker_search_container_real_find_object_co (RygelTrackerSearchContainerFindObjectData* _data_);
static gboolean rygel_tracker_search_container_is_our_child (RygelTrackerSearchContainer* self, const gchar* id);
static void rygel_tracker_search_container_find_object_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
gchar* rygel_tracker_search_container_get_item_info (RygelTrackerSearchContainer* self, const gchar* item_id, gchar** parent_id);
static void rygel_tracker_search_container_get_children_count_data_free (gpointer _data);
static gboolean rygel_tracker_search_container_get_children_count_co (RygelTrackerSearchContainerGetChildrenCountData* _data_);
RygelTrackerSelectionQuery* rygel_tracker_selection_query_new_clone (RygelTrackerSelectionQuery* query);
RygelTrackerSelectionQuery* rygel_tracker_selection_query_construct_clone (GType object_type, RygelTrackerSelectionQuery* query);
static void rygel_tracker_search_container_get_children_count_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static RygelTrackerSelectionQuery* rygel_tracker_search_container_create_sorted_query (RygelTrackerSearchContainer* self, const gchar* sort_criteria);
static gchar* rygel_tracker_search_container_create_filter_for_child (RygelTrackerSearchContainer* self, RygelRelationalExpression* expression);
RygelTrackerQueryTriplets* rygel_tracker_query_triplets_new_clone (RygelTrackerQueryTriplets* triplets);
RygelTrackerQueryTriplets* rygel_tracker_query_triplets_construct_clone (GType object_type, RygelTrackerQueryTriplets* triplets);
static gchar* rygel_tracker_search_container_urn_to_utf8 (RygelTrackerSearchContainer* self, const gchar* urn);
gchar* rygel_tracker_query_escape_string (const gchar* literal);
gchar* rygel_tracker_query_escape_regex (const gchar* literal);
static void rygel_tracker_search_container_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


static void __lambda2_ (RygelTrackerSearchContainer* self, RygelMediaContainer* container, RygelMediaObject* origin) {
	RygelMediaObject* _tmp0_ = NULL;
#line 61 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	g_return_if_fail (container != NULL);
#line 61 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	g_return_if_fail (origin != NULL);
#line 62 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_tmp0_ = origin;
#line 62 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	if (_tmp0_ == G_TYPE_CHECK_INSTANCE_CAST (self, RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObject)) {
#line 438 "rygel-tracker-search-container.c"
		GeeHashMap* _tmp1_ = NULL;
		const gchar* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
		guint32 _tmp4_ = 0U;
#line 63 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_tmp1_ = rygel_tracker_search_container_update_id_hash;
#line 63 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_tmp2_ = rygel_media_object_get_id ((RygelMediaObject*) self);
#line 63 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_tmp3_ = _tmp2_;
#line 63 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_tmp4_ = ((RygelMediaContainer*) self)->update_id;
#line 63 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		gee_abstract_map_set ((GeeAbstractMap*) _tmp1_, _tmp3_, (gpointer) ((guintptr) ((guint) _tmp4_)));
#line 453 "rygel-tracker-search-container.c"
	}
}


static void ___lambda2__rygel_media_container_container_updated (RygelMediaContainer* _sender, RygelMediaContainer* container, RygelMediaObject* object, RygelObjectEventType event_type, gboolean sub_tree_update, gpointer self) {
#line 61 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	__lambda2_ (self, container, object);
#line 461 "rygel-tracker-search-container.c"
}


static gpointer _rygel_tracker_item_factory_ref0 (gpointer self) {
#line 67 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	return self ? rygel_tracker_item_factory_ref (self) : NULL;
#line 468 "rygel-tracker-search-container.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 74 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	return self ? g_object_ref (self) : NULL;
#line 475 "rygel-tracker-search-container.c"
}


RygelTrackerSearchContainer* rygel_tracker_search_container_construct (GType object_type, const gchar* id, RygelMediaContainer* parent, const gchar* title, RygelTrackerItemFactory* item_factory, RygelTrackerQueryTriplets* triplets, GeeArrayList* filters) {
	RygelTrackerSearchContainer * self = NULL;
	const gchar* _tmp0_ = NULL;
	RygelMediaContainer* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	GeeHashMap* _tmp3_ = NULL;
	gboolean _tmp4_ = FALSE;
	GeeHashMap* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	const gchar* _tmp8_ = NULL;
	gboolean _tmp9_ = FALSE;
	RygelTrackerItemFactory* _tmp14_ = NULL;
	RygelTrackerItemFactory* _tmp15_ = NULL;
	GeeArrayList* variables = NULL;
	GeeArrayList* _tmp16_ = NULL;
	GeeArrayList* _tmp17_ = NULL;
	RygelTrackerQueryTriplets* our_triplets = NULL;
	RygelTrackerQueryTriplets* _tmp18_ = NULL;
	RygelTrackerQueryTriplets* _tmp22_ = NULL;
	RygelTrackerItemFactory* _tmp23_ = NULL;
	const gchar* _tmp24_ = NULL;
	RygelTrackerQueryTriplet* _tmp25_ = NULL;
	RygelTrackerQueryTriplet* _tmp26_ = NULL;
	RygelTrackerUPnPPropertyMap* property_map = NULL;
	RygelTrackerUPnPPropertyMap* _tmp27_ = NULL;
	gchar* order_by = NULL;
	gchar* _tmp45_ = NULL;
	GeeArrayList* _tmp46_ = NULL;
	RygelTrackerQueryTriplets* _tmp47_ = NULL;
	GeeArrayList* _tmp48_ = NULL;
	RygelTrackerSelectionQuery* _tmp49_ = NULL;
	GError * _inner_error_ = NULL;
#line 45 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	g_return_val_if_fail (id != NULL, NULL);
#line 45 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	g_return_val_if_fail (parent != NULL, NULL);
#line 45 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	g_return_val_if_fail (title != NULL, NULL);
#line 45 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	g_return_val_if_fail (item_factory != NULL, NULL);
#line 51 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_tmp0_ = id;
#line 51 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_tmp1_ = parent;
#line 51 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_tmp2_ = title;
#line 51 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	self = (RygelTrackerSearchContainer*) rygel_simple_container_construct (object_type, _tmp0_, _tmp1_, _tmp2_);
#line 53 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_tmp3_ = rygel_tracker_search_container_update_id_hash;
#line 53 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_tmp4_ = G_UNLIKELY (_tmp3_ == NULL);
#line 53 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	if (_tmp4_) {
#line 533 "rygel-tracker-search-container.c"
		GeeHashMap* _tmp5_ = NULL;
#line 54 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_tmp5_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, G_TYPE_UINT, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
#line 54 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_g_object_unref0 (rygel_tracker_search_container_update_id_hash);
#line 54 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		rygel_tracker_search_container_update_id_hash = _tmp5_;
#line 541 "rygel-tracker-search-container.c"
	}
#line 57 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_tmp6_ = rygel_tracker_search_container_update_id_hash;
#line 57 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_tmp7_ = rygel_media_object_get_id ((RygelMediaObject*) self);
#line 57 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_tmp8_ = _tmp7_;
#line 57 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_tmp9_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp6_, _tmp8_);
#line 57 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	if (_tmp9_) {
#line 553 "rygel-tracker-search-container.c"
		GeeHashMap* _tmp10_ = NULL;
		const gchar* _tmp11_ = NULL;
		const gchar* _tmp12_ = NULL;
		gpointer _tmp13_ = NULL;
#line 58 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_tmp10_ = rygel_tracker_search_container_update_id_hash;
#line 58 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_tmp11_ = rygel_media_object_get_id ((RygelMediaObject*) self);
#line 58 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_tmp12_ = _tmp11_;
#line 58 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_tmp13_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp10_, _tmp12_);
#line 58 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		((RygelMediaContainer*) self)->update_id = (guint32) ((guint) ((guintptr) _tmp13_));
#line 568 "rygel-tracker-search-container.c"
	}
#line 61 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	g_signal_connect_object ((RygelMediaContainer*) self, "container-updated", (GCallback) ___lambda2__rygel_media_container_container_updated, self, 0);
#line 67 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_tmp14_ = item_factory;
#line 67 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_tmp15_ = _rygel_tracker_item_factory_ref0 (_tmp14_);
#line 67 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_rygel_tracker_item_factory_unref0 (self->item_factory);
#line 67 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	self->item_factory = _tmp15_;
#line 69 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_tmp16_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL, NULL);
#line 69 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	variables = _tmp16_;
#line 70 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_tmp17_ = variables;
#line 70 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp17_, RYGEL_TRACKER_SELECTION_QUERY_ITEM_VARIABLE);
#line 73 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_tmp18_ = triplets;
#line 73 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	if (_tmp18_ != NULL) {
#line 592 "rygel-tracker-search-container.c"
		RygelTrackerQueryTriplets* _tmp19_ = NULL;
		RygelTrackerQueryTriplets* _tmp20_ = NULL;
#line 74 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_tmp19_ = triplets;
#line 74 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_tmp20_ = _g_object_ref0 (_tmp19_);
#line 74 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_g_object_unref0 (our_triplets);
#line 74 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		our_triplets = _tmp20_;
#line 603 "rygel-tracker-search-container.c"
	} else {
		RygelTrackerQueryTriplets* _tmp21_ = NULL;
#line 76 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_tmp21_ = rygel_tracker_query_triplets_new ();
#line 76 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_g_object_unref0 (our_triplets);
#line 76 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		our_triplets = _tmp21_;
#line 612 "rygel-tracker-search-container.c"
	}
#line 79 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_tmp22_ = our_triplets;
#line 79 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_tmp23_ = item_factory;
#line 79 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_tmp24_ = _tmp23_->category;
#line 79 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_tmp25_ = rygel_tracker_query_triplet_new (RYGEL_TRACKER_SELECTION_QUERY_ITEM_VARIABLE, "a", _tmp24_);
#line 79 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_tmp26_ = _tmp25_;
#line 79 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp22_, _tmp26_);
#line 79 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_rygel_tracker_query_triplet_unref0 (_tmp26_);
#line 84 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_tmp27_ = rygel_tracker_upn_pproperty_map_get_property_map ();
#line 84 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	property_map = _tmp27_;
#line 632 "rygel-tracker-search-container.c"
	{
		GeeArrayList* _property_list = NULL;
		RygelTrackerItemFactory* _tmp28_ = NULL;
		GeeArrayList* _tmp29_ = NULL;
		GeeArrayList* _tmp30_ = NULL;
		gint _property_size = 0;
		GeeArrayList* _tmp31_ = NULL;
		gint _tmp32_ = 0;
		gint _tmp33_ = 0;
		gint _property_index = 0;
#line 85 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_tmp28_ = self->item_factory;
#line 85 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_tmp29_ = _tmp28_->properties;
#line 85 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_tmp30_ = _g_object_ref0 (_tmp29_);
#line 85 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_property_list = _tmp30_;
#line 85 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_tmp31_ = _property_list;
#line 85 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_tmp32_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp31_);
#line 85 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_tmp33_ = _tmp32_;
#line 85 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_property_size = _tmp33_;
#line 85 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_property_index = -1;
#line 85 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		while (TRUE) {
#line 663 "rygel-tracker-search-container.c"
			gint _tmp34_ = 0;
			gint _tmp35_ = 0;
			gint _tmp36_ = 0;
			gchar* property = NULL;
			GeeArrayList* _tmp37_ = NULL;
			gint _tmp38_ = 0;
			gpointer _tmp39_ = NULL;
			GeeArrayList* _tmp40_ = NULL;
			RygelTrackerUPnPPropertyMap* _tmp41_ = NULL;
			const gchar* _tmp42_ = NULL;
			gchar* _tmp43_ = NULL;
			gchar* _tmp44_ = NULL;
#line 85 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			_tmp34_ = _property_index;
#line 85 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			_property_index = _tmp34_ + 1;
#line 85 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			_tmp35_ = _property_index;
#line 85 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			_tmp36_ = _property_size;
#line 85 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			if (!(_tmp35_ < _tmp36_)) {
#line 85 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
				break;
#line 688 "rygel-tracker-search-container.c"
			}
#line 85 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			_tmp37_ = _property_list;
#line 85 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			_tmp38_ = _property_index;
#line 85 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			_tmp39_ = gee_abstract_list_get ((GeeAbstractList*) _tmp37_, _tmp38_);
#line 85 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			property = (gchar*) _tmp39_;
#line 86 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			_tmp40_ = variables;
#line 86 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			_tmp41_ = property_map;
#line 86 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			_tmp42_ = property;
#line 86 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			_tmp43_ = rygel_tracker_upn_pproperty_map_get (_tmp41_, _tmp42_);
#line 86 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			_tmp44_ = _tmp43_;
#line 86 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp40_, _tmp44_);
#line 86 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			_g_free0 (_tmp44_);
#line 85 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			_g_free0 (property);
#line 714 "rygel-tracker-search-container.c"
		}
#line 85 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_g_object_unref0 (_property_list);
#line 718 "rygel-tracker-search-container.c"
	}
#line 89 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_tmp45_ = g_strdup (RYGEL_TRACKER_SEARCH_CONTAINER_MODIFIED_PROPERTY "(" RYGEL_TRACKER_SELECTION_QUERY_ITEM_VARIABLE ")");
#line 89 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	order_by = _tmp45_;
#line 94 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_tmp46_ = variables;
#line 94 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_tmp47_ = our_triplets;
#line 94 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_tmp48_ = filters;
#line 94 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_tmp49_ = rygel_tracker_selection_query_new (_tmp46_, _tmp47_, _tmp48_, order_by, 0, -1);
#line 94 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_rygel_tracker_query_unref0 (self->query);
#line 94 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	self->query = _tmp49_;
#line 736 "rygel-tracker-search-container.c"
	{
		TrackerSparqlConnection* _tmp50_ = NULL;
		TrackerSparqlConnection* _tmp51_ = NULL;
#line 100 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_tmp51_ = tracker_sparql_connection_get (NULL, &_inner_error_);
#line 100 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_tmp50_ = _tmp51_;
#line 100 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		if (_inner_error_ != NULL) {
#line 746 "rygel-tracker-search-container.c"
			goto __catch4_g_error;
		}
#line 100 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_g_object_unref0 (self->priv->resources);
#line 100 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		self->priv->resources = _tmp50_;
#line 102 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		rygel_tracker_search_container_get_children_count (self, NULL, NULL);
#line 755 "rygel-tracker-search-container.c"
	}
	goto __finally4;
	__catch4_g_error:
	{
		GError* _error_ = NULL;
		const gchar* _tmp52_ = NULL;
		GError* _tmp53_ = NULL;
		const gchar* _tmp54_ = NULL;
#line 99 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_error_ = _inner_error_;
#line 99 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_inner_error_ = NULL;
#line 104 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_tmp52_ = _ ("Failed to get Tracker connection: %s");
#line 104 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_tmp53_ = _error_;
#line 104 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_tmp54_ = _tmp53_->message;
#line 104 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		g_critical (_tmp52_, _tmp54_);
#line 99 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_g_error_free0 (_error_);
#line 778 "rygel-tracker-search-container.c"
	}
	__finally4:
#line 99 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	if (_inner_error_ != NULL) {
#line 99 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_g_free0 (order_by);
#line 99 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_g_object_unref0 (property_map);
#line 99 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_g_object_unref0 (our_triplets);
#line 99 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_g_object_unref0 (variables);
#line 99 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 99 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		g_clear_error (&_inner_error_);
#line 99 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		return NULL;
#line 797 "rygel-tracker-search-container.c"
	}
#line 45 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_g_free0 (order_by);
#line 45 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_g_object_unref0 (property_map);
#line 45 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_g_object_unref0 (our_triplets);
#line 45 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_g_object_unref0 (variables);
#line 45 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	return self;
#line 809 "rygel-tracker-search-container.c"
}


RygelTrackerSearchContainer* rygel_tracker_search_container_new (const gchar* id, RygelMediaContainer* parent, const gchar* title, RygelTrackerItemFactory* item_factory, RygelTrackerQueryTriplets* triplets, GeeArrayList* filters) {
#line 45 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	return rygel_tracker_search_container_construct (RYGEL_TRACKER_TYPE_SEARCH_CONTAINER, id, parent, title, item_factory, triplets, filters);
#line 816 "rygel-tracker-search-container.c"
}


static void rygel_tracker_search_container_real_get_children_data_free (gpointer _data) {
	RygelTrackerSearchContainerGetChildrenData* _data_;
	_data_ = _data;
#line 34 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_g_free0 (_data_->sort_criteria);
#line 34 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_g_object_unref0 (_data_->cancellable);
#line 34 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_g_object_unref0 (_data_->result);
#line 34 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_g_object_unref0 (_data_->self);
#line 34 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	g_slice_free (RygelTrackerSearchContainerGetChildrenData, _data_);
#line 833 "rygel-tracker-search-container.c"
}


static void rygel_tracker_search_container_real_get_children (RygelMediaContainer* base, guint offset, guint max_count, const gchar* sort_criteria, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelTrackerSearchContainer * self;
	RygelTrackerSearchContainerGetChildrenData* _data_;
	RygelTrackerSearchContainer* _tmp0_ = NULL;
	guint _tmp1_ = 0U;
	guint _tmp2_ = 0U;
	const gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	GCancellable* _tmp5_ = NULL;
	GCancellable* _tmp6_ = NULL;
#line 34 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	self = (RygelTrackerSearchContainer*) base;
#line 34 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_data_ = g_slice_new0 (RygelTrackerSearchContainerGetChildrenData);
#line 34 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_tracker_search_container_real_get_children);
#line 34 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_tracker_search_container_real_get_children_data_free);
#line 34 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 34 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_data_->self = _tmp0_;
#line 34 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_tmp1_ = offset;
#line 34 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_data_->offset = _tmp1_;
#line 34 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_tmp2_ = max_count;
#line 34 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_data_->max_count = _tmp2_;
#line 34 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_tmp3_ = sort_criteria;
#line 34 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_tmp4_ = g_strdup (_tmp3_);
#line 34 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_g_free0 (_data_->sort_criteria);
#line 34 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_data_->sort_criteria = _tmp4_;
#line 34 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_tmp5_ = cancellable;
#line 34 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_tmp6_ = _g_object_ref0 (_tmp5_);
#line 34 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_g_object_unref0 (_data_->cancellable);
#line 34 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_data_->cancellable = _tmp6_;
#line 34 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	rygel_tracker_search_container_real_get_children_co (_data_);
#line 885 "rygel-tracker-search-container.c"
}


static RygelMediaObjects* rygel_tracker_search_container_real_get_children_finish (RygelMediaContainer* base, GAsyncResult* _res_, GError** error) {
	RygelMediaObjects* result;
	RygelTrackerSearchContainerGetChildrenData* _data_;
#line 34 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
#line 34 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		return NULL;
#line 896 "rygel-tracker-search-container.c"
	}
#line 34 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 34 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	result = _data_->result;
#line 34 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_data_->result = NULL;
#line 34 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	return result;
#line 906 "rygel-tracker-search-container.c"
}


static void rygel_tracker_search_container_get_children_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelTrackerSearchContainerGetChildrenData* _data_;
#line 120 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_data_ = _user_data_;
#line 120 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_data_->_source_object_ = source_object;
#line 120 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_data_->_res_ = _res_;
#line 120 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	rygel_tracker_search_container_real_get_children_co (_data_);
#line 920 "rygel-tracker-search-container.c"
}


static gboolean rygel_tracker_search_container_real_get_children_co (RygelTrackerSearchContainerGetChildrenData* _data_) {
#line 108 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	switch (_data_->_state_) {
#line 108 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		case 0:
#line 929 "rygel-tracker-search-container.c"
		goto _state_0;
#line 108 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		case 1:
#line 933 "rygel-tracker-search-container.c"
		goto _state_1;
		default:
#line 108 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		g_assert_not_reached ();
#line 938 "rygel-tracker-search-container.c"
	}
	_state_0:
#line 113 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_data_->_tmp0_ = NULL;
#line 113 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_data_->_tmp0_ = rygel_relational_expression_new ();
#line 113 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_data_->expression = _data_->_tmp0_;
#line 114 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	((RygelSearchExpression*) _data_->expression)->op = (gpointer) ((gintptr) GUPNP_SEARCH_CRITERIA_OP_EQ);
#line 115 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_data_->_tmp1_ = NULL;
#line 115 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_data_->_tmp1_ = g_strdup ("@parentID");
#line 115 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_g_free0 (((RygelSearchExpression*) _data_->expression)->operand1);
#line 115 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	((RygelSearchExpression*) _data_->expression)->operand1 = _data_->_tmp1_;
#line 116 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_data_->_tmp2_ = NULL;
#line 116 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_data_->_tmp2_ = rygel_media_object_get_id ((RygelMediaObject*) _data_->self);
#line 116 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_data_->_tmp3_ = NULL;
#line 116 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_data_->_tmp3_ = _data_->_tmp2_;
#line 116 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_data_->_tmp4_ = NULL;
#line 116 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_data_->_tmp4_ = g_strdup (_data_->_tmp3_);
#line 116 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_g_free0 (((RygelSearchExpression*) _data_->expression)->operand2);
#line 116 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	((RygelSearchExpression*) _data_->expression)->operand2 = _data_->_tmp4_;
#line 120 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_data_->_tmp6_ = NULL;
#line 120 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_data_->_tmp6_ = _data_->sort_criteria;
#line 120 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_data_->_tmp7_ = 0U;
#line 120 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_data_->_tmp7_ = _data_->offset;
#line 120 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_data_->_tmp8_ = 0U;
#line 120 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_data_->_tmp8_ = _data_->max_count;
#line 120 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_data_->_tmp9_ = NULL;
#line 120 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_data_->_tmp9_ = _data_->cancellable;
#line 120 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_data_->_tmp10_ = 0U;
#line 120 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_data_->_state_ = 1;
#line 120 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	rygel_tracker_search_container_execute_query (_data_->self, (RygelSearchExpression*) _data_->expression, _data_->_tmp6_, _data_->_tmp7_, _data_->_tmp8_, _data_->_tmp9_, rygel_tracker_search_container_get_children_ready, _data_);
#line 120 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	return FALSE;
#line 997 "rygel-tracker-search-container.c"
	_state_1:
#line 120 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_data_->_tmp11_ = NULL;
#line 120 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_data_->_tmp11_ = rygel_tracker_search_container_execute_query_finish (_data_->self, _data_->_res_, &_data_->_tmp10_, &_data_->_inner_error_);
#line 120 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_data_->total_matches = _data_->_tmp10_;
#line 120 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_data_->_tmp5_ = _data_->_tmp11_;
#line 120 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	if (_data_->_inner_error_ != NULL) {
#line 120 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 120 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		g_error_free (_data_->_inner_error_);
#line 120 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_rygel_search_expression_unref0 (_data_->expression);
#line 120 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		if (_data_->_state_ == 0) {
#line 120 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1019 "rygel-tracker-search-container.c"
		} else {
#line 120 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 1023 "rygel-tracker-search-container.c"
		}
#line 120 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		g_object_unref (_data_->_async_result);
#line 120 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		return FALSE;
#line 1029 "rygel-tracker-search-container.c"
	}
#line 120 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_data_->result = _data_->_tmp5_;
#line 120 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_rygel_search_expression_unref0 (_data_->expression);
#line 120 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	if (_data_->_state_ == 0) {
#line 120 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1039 "rygel-tracker-search-container.c"
	} else {
#line 120 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 1043 "rygel-tracker-search-container.c"
	}
#line 120 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	g_object_unref (_data_->_async_result);
#line 120 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	return FALSE;
#line 108 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_rygel_search_expression_unref0 (_data_->expression);
#line 108 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	if (_data_->_state_ == 0) {
#line 108 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1055 "rygel-tracker-search-container.c"
	} else {
#line 108 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 1059 "rygel-tracker-search-container.c"
	}
#line 108 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	g_object_unref (_data_->_async_result);
#line 108 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	return FALSE;
#line 1065 "rygel-tracker-search-container.c"
}


static void rygel_tracker_search_container_execute_query_data_free (gpointer _data) {
	RygelTrackerSearchContainerExecuteQueryData* _data_;
	_data_ = _data;
#line 34 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_rygel_search_expression_unref0 (_data_->expression);
#line 34 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_g_free0 (_data_->sort_criteria);
#line 34 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_g_object_unref0 (_data_->cancellable);
#line 34 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_g_object_unref0 (_data_->result);
#line 34 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_g_object_unref0 (_data_->self);
#line 34 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	g_slice_free (RygelTrackerSearchContainerExecuteQueryData, _data_);
#line 1084 "rygel-tracker-search-container.c"
}


static gpointer _rygel_search_expression_ref0 (gpointer self) {
#line 34 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	return self ? rygel_search_expression_ref (self) : NULL;
#line 1091 "rygel-tracker-search-container.c"
}


void rygel_tracker_search_container_execute_query (RygelTrackerSearchContainer* self, RygelSearchExpression* expression, const gchar* sort_criteria, guint offset, guint max_count, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelTrackerSearchContainerExecuteQueryData* _data_;
	RygelTrackerSearchContainer* _tmp0_ = NULL;
	RygelSearchExpression* _tmp1_ = NULL;
	RygelSearchExpression* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	guint _tmp5_ = 0U;
	guint _tmp6_ = 0U;
	GCancellable* _tmp7_ = NULL;
	GCancellable* _tmp8_ = NULL;
#line 34 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_data_ = g_slice_new0 (RygelTrackerSearchContainerExecuteQueryData);
#line 34 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_tracker_search_container_execute_query);
#line 34 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_tracker_search_container_execute_query_data_free);
#line 34 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 34 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_data_->self = _tmp0_;
#line 34 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_tmp1_ = expression;
#line 34 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_tmp2_ = _rygel_search_expression_ref0 (_tmp1_);
#line 34 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_rygel_search_expression_unref0 (_data_->expression);
#line 34 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_data_->expression = _tmp2_;
#line 34 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_tmp3_ = sort_criteria;
#line 34 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_tmp4_ = g_strdup (_tmp3_);
#line 34 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_g_free0 (_data_->sort_criteria);
#line 34 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_data_->sort_criteria = _tmp4_;
#line 34 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_tmp5_ = offset;
#line 34 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_data_->offset = _tmp5_;
#line 34 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_tmp6_ = max_count;
#line 34 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_data_->max_count = _tmp6_;
#line 34 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_tmp7_ = cancellable;
#line 34 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_tmp8_ = _g_object_ref0 (_tmp7_);
#line 34 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_g_object_unref0 (_data_->cancellable);
#line 34 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_data_->cancellable = _tmp8_;
#line 34 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	rygel_tracker_search_container_execute_query_co (_data_);
#line 1150 "rygel-tracker-search-container.c"
}


RygelMediaObjects* rygel_tracker_search_container_execute_query_finish (RygelTrackerSearchContainer* self, GAsyncResult* _res_, guint* total_matches, GError** error) {
	RygelMediaObjects* result;
	RygelTrackerSearchContainerExecuteQueryData* _data_;
#line 34 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
#line 34 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		return NULL;
#line 1161 "rygel-tracker-search-container.c"
	}
#line 34 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 34 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	if (total_matches) {
#line 34 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		*total_matches = _data_->total_matches;
#line 1169 "rygel-tracker-search-container.c"
	}
#line 34 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	result = _data_->result;
#line 34 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_data_->result = NULL;
#line 34 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	return result;
#line 1177 "rygel-tracker-search-container.c"
}


static void rygel_tracker_search_container_execute_query_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelTrackerSearchContainerExecuteQueryData* _data_;
#line 143 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_data_ = _user_data_;
#line 143 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_data_->_source_object_ = source_object;
#line 143 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_data_->_res_ = _res_;
#line 143 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	rygel_tracker_search_container_execute_query_co (_data_);
#line 1191 "rygel-tracker-search-container.c"
}


static gboolean rygel_tracker_search_container_execute_query_co (RygelTrackerSearchContainerExecuteQueryData* _data_) {
#line 128 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	switch (_data_->_state_) {
#line 128 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		case 0:
#line 1200 "rygel-tracker-search-container.c"
		goto _state_0;
#line 128 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		case 1:
#line 1204 "rygel-tracker-search-container.c"
		goto _state_1;
#line 128 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		case 2:
#line 1208 "rygel-tracker-search-container.c"
		goto _state_2;
		default:
#line 128 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		g_assert_not_reached ();
#line 1213 "rygel-tracker-search-container.c"
	}
	_state_0:
#line 135 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_data_->_tmp0_ = NULL;
#line 135 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_data_->_tmp0_ = rygel_media_objects_new ();
#line 135 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_data_->results = _data_->_tmp0_;
#line 137 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_data_->_tmp1_ = NULL;
#line 137 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_data_->_tmp1_ = _data_->expression;
#line 137 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_data_->_tmp2_ = 0U;
#line 137 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_data_->_tmp2_ = _data_->offset;
#line 137 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_data_->_tmp3_ = 0U;
#line 137 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_data_->_tmp3_ = _data_->max_count;
#line 137 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_data_->_tmp4_ = NULL;
#line 137 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_data_->_tmp4_ = _data_->sort_criteria;
#line 137 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_data_->_tmp5_ = NULL;
#line 137 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_data_->_tmp5_ = rygel_tracker_search_container_create_query (_data_->self, G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp1_, RYGEL_TYPE_RELATIONAL_EXPRESSION) ? ((RygelRelationalExpression*) _data_->_tmp1_) : NULL, (gint) _data_->_tmp2_, (gint) _data_->_tmp3_, _data_->_tmp4_);
#line 137 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_data_->query = _data_->_tmp5_;
#line 142 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_data_->_tmp6_ = NULL;
#line 142 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_data_->_tmp6_ = _data_->query;
#line 142 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	if (_data_->_tmp6_ != NULL) {
#line 143 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_data_->_tmp7_ = NULL;
#line 143 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_data_->_tmp7_ = _data_->query;
#line 143 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_data_->_tmp8_ = NULL;
#line 143 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_data_->_tmp8_ = _data_->self->priv->resources;
#line 143 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_data_->_state_ = 1;
#line 143 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		rygel_tracker_query_execute ((RygelTrackerQuery*) _data_->_tmp7_, _data_->_tmp8_, rygel_tracker_search_container_execute_query_ready, _data_);
#line 143 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		return FALSE;
#line 1264 "rygel-tracker-search-container.c"
		_state_1:
#line 143 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		rygel_tracker_query_execute_finish ((RygelTrackerQuery*) _data_->_tmp7_, _data_->_res_, &_data_->_inner_error_);
#line 143 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		if (_data_->_inner_error_ != NULL) {
#line 143 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 143 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			g_error_free (_data_->_inner_error_);
#line 143 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			_rygel_tracker_query_unref0 (_data_->query);
#line 143 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			_g_object_unref0 (_data_->results);
#line 143 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			if (_data_->_state_ == 0) {
#line 143 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
				g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1282 "rygel-tracker-search-container.c"
			} else {
#line 143 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
				g_simple_async_result_complete (_data_->_async_result);
#line 1286 "rygel-tracker-search-container.c"
			}
#line 143 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			g_object_unref (_data_->_async_result);
#line 143 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			return FALSE;
#line 1292 "rygel-tracker-search-container.c"
		}
#line 146 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		while (TRUE) {
#line 146 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			_data_->_tmp10_ = NULL;
#line 146 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			_data_->_tmp10_ = _data_->query;
#line 146 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			_data_->_tmp11_ = NULL;
#line 146 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			_data_->_tmp11_ = _data_->_tmp10_->result;
#line 146 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			_data_->_state_ = 2;
#line 146 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			tracker_sparql_cursor_next_async (_data_->_tmp11_, NULL, rygel_tracker_search_container_execute_query_ready, _data_);
#line 146 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			return FALSE;
#line 1310 "rygel-tracker-search-container.c"
			_state_2:
#line 146 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			_data_->_tmp12_ = FALSE;
#line 146 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			_data_->_tmp12_ = tracker_sparql_cursor_next_finish (_data_->_tmp11_, _data_->_res_, &_data_->_inner_error_);
#line 146 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			_data_->_tmp9_ = _data_->_tmp12_;
#line 146 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			if (_data_->_inner_error_ != NULL) {
#line 146 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
				g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 146 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
				g_error_free (_data_->_inner_error_);
#line 146 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
				_rygel_tracker_query_unref0 (_data_->query);
#line 146 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
				_g_object_unref0 (_data_->results);
#line 146 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
				if (_data_->_state_ == 0) {
#line 146 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
					g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1332 "rygel-tracker-search-container.c"
				} else {
#line 146 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
					g_simple_async_result_complete (_data_->_async_result);
#line 1336 "rygel-tracker-search-container.c"
				}
#line 146 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
				g_object_unref (_data_->_async_result);
#line 146 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
				return FALSE;
#line 1342 "rygel-tracker-search-container.c"
			}
#line 146 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			if (!_data_->_tmp9_) {
#line 146 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
				break;
#line 1348 "rygel-tracker-search-container.c"
			}
#line 147 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			_data_->_tmp13_ = NULL;
#line 147 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			_data_->_tmp13_ = _data_->query;
#line 147 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			_data_->_tmp14_ = NULL;
#line 147 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			_data_->_tmp14_ = _data_->_tmp13_->result;
#line 147 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			_data_->_tmp15_ = NULL;
#line 147 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			_data_->_tmp15_ = tracker_sparql_cursor_get_string (_data_->_tmp14_, 0, NULL);
#line 147 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			_data_->_tmp16_ = NULL;
#line 147 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			_data_->_tmp16_ = g_strdup (_data_->_tmp15_);
#line 147 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			_data_->id = _data_->_tmp16_;
#line 148 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			_data_->_tmp17_ = NULL;
#line 148 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			_data_->_tmp17_ = _data_->id;
#line 148 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			_data_->_tmp18_ = NULL;
#line 148 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			_data_->_tmp18_ = rygel_tracker_search_container_create_child_id_for_urn (_data_->self, _data_->_tmp17_);
#line 148 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			_g_free0 (_data_->id);
#line 148 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			_data_->id = _data_->_tmp18_;
#line 149 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			_data_->_tmp19_ = NULL;
#line 149 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			_data_->_tmp19_ = _data_->query;
#line 149 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			_data_->_tmp20_ = NULL;
#line 149 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			_data_->_tmp20_ = _data_->_tmp19_->result;
#line 149 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			_data_->_tmp21_ = NULL;
#line 149 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			_data_->_tmp21_ = tracker_sparql_cursor_get_string (_data_->_tmp20_, 1, NULL);
#line 149 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			_data_->_tmp22_ = NULL;
#line 149 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			_data_->_tmp22_ = g_strdup (_data_->_tmp21_);
#line 149 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			_data_->uri = _data_->_tmp22_;
#line 151 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			_data_->_tmp23_ = NULL;
#line 151 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			_data_->_tmp23_ = _data_->self->item_factory;
#line 151 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			_data_->_tmp24_ = NULL;
#line 151 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			_data_->_tmp24_ = _data_->id;
#line 151 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			_data_->_tmp25_ = NULL;
#line 151 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			_data_->_tmp25_ = _data_->uri;
#line 151 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			_data_->_tmp26_ = NULL;
#line 151 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			_data_->_tmp26_ = _data_->query;
#line 151 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			_data_->_tmp27_ = NULL;
#line 151 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			_data_->_tmp27_ = _data_->_tmp26_->result;
#line 151 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			_data_->_tmp28_ = NULL;
#line 151 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			_data_->_tmp28_ = rygel_tracker_item_factory_create (_data_->_tmp23_, _data_->_tmp24_, _data_->_tmp25_, _data_->self, _data_->_tmp27_, &_data_->_inner_error_);
#line 151 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			_data_->item = _data_->_tmp28_;
#line 151 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			if (_data_->_inner_error_ != NULL) {
#line 151 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
				g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 151 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
				g_error_free (_data_->_inner_error_);
#line 151 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
				_g_free0 (_data_->uri);
#line 151 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
				_g_free0 (_data_->id);
#line 151 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
				_rygel_tracker_query_unref0 (_data_->query);
#line 151 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
				_g_object_unref0 (_data_->results);
#line 151 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
				if (_data_->_state_ == 0) {
#line 151 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
					g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1442 "rygel-tracker-search-container.c"
				} else {
#line 151 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
					g_simple_async_result_complete (_data_->_async_result);
#line 1446 "rygel-tracker-search-container.c"
				}
#line 151 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
				g_object_unref (_data_->_async_result);
#line 151 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
				return FALSE;
#line 1452 "rygel-tracker-search-container.c"
			}
#line 155 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			_data_->_tmp29_ = NULL;
#line 155 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			_data_->_tmp29_ = _data_->results;
#line 155 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			_data_->_tmp30_ = NULL;
#line 155 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			_data_->_tmp30_ = _data_->item;
#line 155 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			gee_abstract_collection_add ((GeeAbstractCollection*) _data_->_tmp29_, (RygelMediaObject*) _data_->_tmp30_);
#line 146 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			_g_object_unref0 (_data_->item);
#line 146 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			_g_free0 (_data_->uri);
#line 146 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			_g_free0 (_data_->id);
#line 1470 "rygel-tracker-search-container.c"
		}
	}
#line 159 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_data_->_tmp31_ = NULL;
#line 159 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_data_->_tmp31_ = _data_->results;
#line 159 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_data_->_tmp32_ = 0;
#line 159 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_data_->_tmp32_ = gee_abstract_collection_get_size ((GeeCollection*) _data_->_tmp31_);
#line 159 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_data_->_tmp33_ = 0;
#line 159 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_data_->_tmp33_ = _data_->_tmp32_;
#line 159 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_data_->total_matches = (guint) _data_->_tmp33_;
#line 161 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_data_->result = _data_->results;
#line 161 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_rygel_tracker_query_unref0 (_data_->query);
#line 161 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	if (_data_->_state_ == 0) {
#line 161 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1495 "rygel-tracker-search-container.c"
	} else {
#line 161 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 1499 "rygel-tracker-search-container.c"
	}
#line 161 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	g_object_unref (_data_->_async_result);
#line 161 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	return FALSE;
#line 128 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_rygel_tracker_query_unref0 (_data_->query);
#line 128 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_g_object_unref0 (_data_->results);
#line 128 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	if (_data_->_state_ == 0) {
#line 128 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1513 "rygel-tracker-search-container.c"
	} else {
#line 128 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 1517 "rygel-tracker-search-container.c"
	}
#line 128 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	g_object_unref (_data_->_async_result);
#line 128 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	return FALSE;
#line 1523 "rygel-tracker-search-container.c"
}


static void rygel_tracker_search_container_real_find_object_data_free (gpointer _data) {
	RygelTrackerSearchContainerFindObjectData* _data_;
	_data_ = _data;
#line 34 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_g_free0 (_data_->id);
#line 34 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_g_object_unref0 (_data_->cancellable);
#line 34 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_g_object_unref0 (_data_->result);
#line 34 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_g_object_unref0 (_data_->self);
#line 34 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	g_slice_free (RygelTrackerSearchContainerFindObjectData, _data_);
#line 1540 "rygel-tracker-search-container.c"
}


static void rygel_tracker_search_container_real_find_object (RygelMediaContainer* base, const gchar* id, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelTrackerSearchContainer * self;
	RygelTrackerSearchContainerFindObjectData* _data_;
	RygelTrackerSearchContainer* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	GCancellable* _tmp3_ = NULL;
	GCancellable* _tmp4_ = NULL;
#line 34 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	self = (RygelTrackerSearchContainer*) base;
#line 34 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_data_ = g_slice_new0 (RygelTrackerSearchContainerFindObjectData);
#line 34 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_tracker_search_container_real_find_object);
#line 34 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_tracker_search_container_real_find_object_data_free);
#line 34 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 34 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_data_->self = _tmp0_;
#line 34 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_tmp1_ = id;
#line 34 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_tmp2_ = g_strdup (_tmp1_);
#line 34 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_g_free0 (_data_->id);
#line 34 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_data_->id = _tmp2_;
#line 34 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_tmp3_ = cancellable;
#line 34 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_tmp4_ = _g_object_ref0 (_tmp3_);
#line 34 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_g_object_unref0 (_data_->cancellable);
#line 34 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_data_->cancellable = _tmp4_;
#line 34 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	rygel_tracker_search_container_real_find_object_co (_data_);
#line 1582 "rygel-tracker-search-container.c"
}


static RygelMediaObject* rygel_tracker_search_container_real_find_object_finish (RygelMediaContainer* base, GAsyncResult* _res_, GError** error) {
	RygelMediaObject* result;
	RygelTrackerSearchContainerFindObjectData* _data_;
#line 34 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
#line 34 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		return NULL;
#line 1593 "rygel-tracker-search-container.c"
	}
#line 34 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 34 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	result = _data_->result;
#line 34 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_data_->result = NULL;
#line 34 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	return result;
#line 1603 "rygel-tracker-search-container.c"
}


static void rygel_tracker_search_container_find_object_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelTrackerSearchContainerFindObjectData* _data_;
#line 177 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_data_ = _user_data_;
#line 177 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_data_->_source_object_ = source_object;
#line 177 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_data_->_res_ = _res_;
#line 177 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	rygel_tracker_search_container_real_find_object_co (_data_);
#line 1617 "rygel-tracker-search-container.c"
}


static gboolean rygel_tracker_search_container_real_find_object_co (RygelTrackerSearchContainerFindObjectData* _data_) {
#line 164 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	switch (_data_->_state_) {
#line 164 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		case 0:
#line 1626 "rygel-tracker-search-container.c"
		goto _state_0;
#line 164 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		case 1:
#line 1630 "rygel-tracker-search-container.c"
		goto _state_1;
		default:
#line 164 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		g_assert_not_reached ();
#line 1635 "rygel-tracker-search-container.c"
	}
	_state_0:
#line 167 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_data_->_tmp0_ = NULL;
#line 167 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_data_->_tmp0_ = _data_->id;
#line 167 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_data_->_tmp1_ = FALSE;
#line 167 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_data_->_tmp1_ = rygel_tracker_search_container_is_our_child (_data_->self, _data_->_tmp0_);
#line 167 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	if (!_data_->_tmp1_) {
#line 168 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_data_->result = NULL;
#line 168 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		if (_data_->_state_ == 0) {
#line 168 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1654 "rygel-tracker-search-container.c"
		} else {
#line 168 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 1658 "rygel-tracker-search-container.c"
		}
#line 168 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		g_object_unref (_data_->_async_result);
#line 168 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		return FALSE;
#line 1664 "rygel-tracker-search-container.c"
	}
#line 171 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_data_->_tmp2_ = NULL;
#line 171 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_data_->_tmp2_ = rygel_relational_expression_new ();
#line 171 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_data_->expression = _data_->_tmp2_;
#line 172 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_data_->_tmp3_ = NULL;
#line 172 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_data_->_tmp3_ = _data_->expression;
#line 172 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	((RygelSearchExpression*) _data_->_tmp3_)->op = (gpointer) ((gintptr) GUPNP_SEARCH_CRITERIA_OP_EQ);
#line 173 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_data_->_tmp4_ = NULL;
#line 173 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_data_->_tmp4_ = _data_->expression;
#line 173 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_data_->_tmp5_ = NULL;
#line 173 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_data_->_tmp5_ = g_strdup ("@id");
#line 173 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_g_free0 (((RygelSearchExpression*) _data_->_tmp4_)->operand1);
#line 173 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	((RygelSearchExpression*) _data_->_tmp4_)->operand1 = _data_->_tmp5_;
#line 174 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_data_->_tmp6_ = NULL;
#line 174 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_data_->_tmp6_ = _data_->expression;
#line 174 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_data_->_tmp7_ = NULL;
#line 174 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_data_->_tmp7_ = _data_->id;
#line 174 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_data_->_tmp8_ = NULL;
#line 174 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_data_->_tmp8_ = g_strdup (_data_->_tmp7_);
#line 174 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_g_free0 (((RygelSearchExpression*) _data_->_tmp6_)->operand2);
#line 174 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	((RygelSearchExpression*) _data_->_tmp6_)->operand2 = _data_->_tmp8_;
#line 177 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_data_->_tmp9_ = NULL;
#line 177 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_data_->_tmp9_ = _data_->expression;
#line 177 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_data_->_tmp10_ = NULL;
#line 177 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_data_->_tmp10_ = _data_->cancellable;
#line 177 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_data_->_tmp11_ = 0U;
#line 177 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_data_->_state_ = 1;
#line 177 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	rygel_tracker_search_container_execute_query (_data_->self, (RygelSearchExpression*) _data_->_tmp9_, "", (guint) 0, (guint) 1, _data_->_tmp10_, rygel_tracker_search_container_find_object_ready, _data_);
#line 177 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	return FALSE;
#line 1722 "rygel-tracker-search-container.c"
	_state_1:
#line 177 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_data_->_tmp12_ = NULL;
#line 177 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_data_->_tmp12_ = rygel_tracker_search_container_execute_query_finish (_data_->self, _data_->_res_, &_data_->_tmp11_, &_data_->_inner_error_);
#line 177 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_data_->total_matches = _data_->_tmp11_;
#line 177 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_data_->results = _data_->_tmp12_;
#line 177 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	if (_data_->_inner_error_ != NULL) {
#line 177 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 177 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		g_error_free (_data_->_inner_error_);
#line 177 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_rygel_search_expression_unref0 (_data_->expression);
#line 177 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		if (_data_->_state_ == 0) {
#line 177 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1744 "rygel-tracker-search-container.c"
		} else {
#line 177 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 1748 "rygel-tracker-search-container.c"
		}
#line 177 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		g_object_unref (_data_->_async_result);
#line 177 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		return FALSE;
#line 1754 "rygel-tracker-search-container.c"
	}
#line 183 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_data_->_tmp13_ = NULL;
#line 183 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_data_->_tmp13_ = _data_->results;
#line 183 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_data_->_tmp14_ = 0;
#line 183 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_data_->_tmp14_ = gee_abstract_collection_get_size ((GeeCollection*) _data_->_tmp13_);
#line 183 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_data_->_tmp15_ = 0;
#line 183 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_data_->_tmp15_ = _data_->_tmp14_;
#line 183 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	if (_data_->_tmp15_ > 0) {
#line 184 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_data_->_tmp16_ = NULL;
#line 184 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_data_->_tmp16_ = _data_->results;
#line 184 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_data_->_tmp17_ = NULL;
#line 184 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_data_->_tmp17_ = gee_abstract_list_get ((GeeAbstractList*) _data_->_tmp16_, 0);
#line 184 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_data_->result = (RygelMediaObject*) _data_->_tmp17_;
#line 184 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_g_object_unref0 (_data_->results);
#line 184 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_rygel_search_expression_unref0 (_data_->expression);
#line 184 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		if (_data_->_state_ == 0) {
#line 184 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1788 "rygel-tracker-search-container.c"
		} else {
#line 184 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 1792 "rygel-tracker-search-container.c"
		}
#line 184 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		g_object_unref (_data_->_async_result);
#line 184 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		return FALSE;
#line 1798 "rygel-tracker-search-container.c"
	} else {
#line 186 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_data_->result = NULL;
#line 186 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_g_object_unref0 (_data_->results);
#line 186 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_rygel_search_expression_unref0 (_data_->expression);
#line 186 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		if (_data_->_state_ == 0) {
#line 186 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1810 "rygel-tracker-search-container.c"
		} else {
#line 186 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 1814 "rygel-tracker-search-container.c"
		}
#line 186 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		g_object_unref (_data_->_async_result);
#line 186 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		return FALSE;
#line 1820 "rygel-tracker-search-container.c"
	}
#line 164 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_g_object_unref0 (_data_->results);
#line 164 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_rygel_search_expression_unref0 (_data_->expression);
#line 164 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	if (_data_->_state_ == 0) {
#line 164 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1830 "rygel-tracker-search-container.c"
	} else {
#line 164 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 1834 "rygel-tracker-search-container.c"
	}
#line 164 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	g_object_unref (_data_->_async_result);
#line 164 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	return FALSE;
#line 1840 "rygel-tracker-search-container.c"
}


gchar* rygel_tracker_search_container_create_child_id_for_urn (RygelTrackerSearchContainer* self, const gchar* urn) {
	gchar* result = NULL;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
#line 190 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 190 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	g_return_val_if_fail (urn != NULL, NULL);
#line 191 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_tmp0_ = rygel_media_object_get_id ((RygelMediaObject*) self);
#line 191 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_tmp1_ = _tmp0_;
#line 191 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_tmp2_ = g_strconcat (_tmp1_, ",", NULL);
#line 191 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_tmp3_ = _tmp2_;
#line 191 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_tmp4_ = urn;
#line 191 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_tmp5_ = g_strconcat (_tmp3_, _tmp4_, NULL);
#line 191 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_tmp6_ = _tmp5_;
#line 191 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_g_free0 (_tmp3_);
#line 191 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	result = _tmp6_;
#line 191 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	return result;
#line 1877 "rygel-tracker-search-container.c"
}


gchar* rygel_tracker_search_container_get_item_info (RygelTrackerSearchContainer* self, const gchar* item_id, gchar** parent_id) {
	gchar* _vala_parent_id = NULL;
	gchar* result = NULL;
	gchar** tokens = NULL;
	const gchar* _tmp0_ = NULL;
	gchar** _tmp1_ = NULL;
	gchar** _tmp2_ = NULL;
	gint tokens_length1 = 0;
	gint _tokens_size_ = 0;
	gboolean _tmp3_ = FALSE;
	gchar** _tmp4_ = NULL;
	gint _tmp4__length1 = 0;
	const gchar* _tmp5_ = NULL;
	gboolean _tmp8_ = FALSE;
#line 196 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 196 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	g_return_val_if_fail (item_id != NULL, NULL);
#line 198 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_tmp0_ = item_id;
#line 198 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_tmp2_ = _tmp1_ = g_strsplit (_tmp0_, ",", 2);
#line 198 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	tokens = _tmp2_;
#line 198 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	tokens_length1 = _vala_array_length (_tmp1_);
#line 198 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_tokens_size_ = tokens_length1;
#line 200 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_tmp4_ = tokens;
#line 200 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_tmp4__length1 = tokens_length1;
#line 200 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_tmp5_ = _tmp4_[0];
#line 200 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	if (_tmp5_ != NULL) {
#line 1917 "rygel-tracker-search-container.c"
		gchar** _tmp6_ = NULL;
		gint _tmp6__length1 = 0;
		const gchar* _tmp7_ = NULL;
#line 200 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_tmp6_ = tokens;
#line 200 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_tmp6__length1 = tokens_length1;
#line 200 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_tmp7_ = _tmp6_[1];
#line 200 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_tmp3_ = _tmp7_ != NULL;
#line 1929 "rygel-tracker-search-container.c"
	} else {
#line 200 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_tmp3_ = FALSE;
#line 1933 "rygel-tracker-search-container.c"
	}
#line 200 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_tmp8_ = _tmp3_;
#line 200 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	if (_tmp8_) {
#line 1939 "rygel-tracker-search-container.c"
		gchar** _tmp9_ = NULL;
		gint _tmp9__length1 = 0;
		const gchar* _tmp10_ = NULL;
		gchar* _tmp11_ = NULL;
		gchar** _tmp12_ = NULL;
		gint _tmp12__length1 = 0;
		const gchar* _tmp13_ = NULL;
		gchar* _tmp14_ = NULL;
#line 201 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_tmp9_ = tokens;
#line 201 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_tmp9__length1 = tokens_length1;
#line 201 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_tmp10_ = _tmp9_[0];
#line 201 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_tmp11_ = g_strdup (_tmp10_);
#line 201 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_g_free0 (_vala_parent_id);
#line 201 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_vala_parent_id = _tmp11_;
#line 203 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_tmp12_ = tokens;
#line 203 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_tmp12__length1 = tokens_length1;
#line 203 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_tmp13_ = _tmp12_[1];
#line 203 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_tmp14_ = g_strdup (_tmp13_);
#line 203 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		result = _tmp14_;
#line 203 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
#line 203 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		if (parent_id) {
#line 203 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			*parent_id = _vala_parent_id;
#line 1976 "rygel-tracker-search-container.c"
		} else {
#line 203 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			_g_free0 (_vala_parent_id);
#line 1980 "rygel-tracker-search-container.c"
		}
#line 203 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		return result;
#line 1984 "rygel-tracker-search-container.c"
	} else {
#line 205 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_g_free0 (_vala_parent_id);
#line 205 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_vala_parent_id = NULL;
#line 207 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		result = NULL;
#line 207 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
#line 207 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		if (parent_id) {
#line 207 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			*parent_id = _vala_parent_id;
#line 1998 "rygel-tracker-search-container.c"
		} else {
#line 207 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			_g_free0 (_vala_parent_id);
#line 2002 "rygel-tracker-search-container.c"
		}
#line 207 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		return result;
#line 2006 "rygel-tracker-search-container.c"
	}
#line 196 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
#line 196 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	if (parent_id) {
#line 196 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		*parent_id = _vala_parent_id;
#line 2014 "rygel-tracker-search-container.c"
	} else {
#line 196 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_g_free0 (_vala_parent_id);
#line 2018 "rygel-tracker-search-container.c"
	}
}


static void rygel_tracker_search_container_get_children_count_data_free (gpointer _data) {
	RygelTrackerSearchContainerGetChildrenCountData* _data_;
	_data_ = _data;
#line 34 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_g_object_unref0 (_data_->self);
#line 34 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	g_slice_free (RygelTrackerSearchContainerGetChildrenCountData, _data_);
#line 2030 "rygel-tracker-search-container.c"
}


void rygel_tracker_search_container_get_children_count (RygelTrackerSearchContainer* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelTrackerSearchContainerGetChildrenCountData* _data_;
	RygelTrackerSearchContainer* _tmp0_ = NULL;
#line 34 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_data_ = g_slice_new0 (RygelTrackerSearchContainerGetChildrenCountData);
#line 34 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_tracker_search_container_get_children_count);
#line 34 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_tracker_search_container_get_children_count_data_free);
#line 34 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 34 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_data_->self = _tmp0_;
#line 34 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	rygel_tracker_search_container_get_children_count_co (_data_);
#line 2049 "rygel-tracker-search-container.c"
}


void rygel_tracker_search_container_get_children_count_finish (RygelTrackerSearchContainer* self, GAsyncResult* _res_) {
	RygelTrackerSearchContainerGetChildrenCountData* _data_;
#line 34 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 2057 "rygel-tracker-search-container.c"
}


static void rygel_tracker_search_container_get_children_count_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelTrackerSearchContainerGetChildrenCountData* _data_;
#line 220 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_data_ = _user_data_;
#line 220 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_data_->_source_object_ = source_object;
#line 220 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_data_->_res_ = _res_;
#line 220 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	rygel_tracker_search_container_get_children_count_co (_data_);
#line 2071 "rygel-tracker-search-container.c"
}


static gboolean rygel_tracker_search_container_get_children_count_co (RygelTrackerSearchContainerGetChildrenCountData* _data_) {
#line 211 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	switch (_data_->_state_) {
#line 211 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		case 0:
#line 2080 "rygel-tracker-search-container.c"
		goto _state_0;
#line 211 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		case 1:
#line 2084 "rygel-tracker-search-container.c"
		goto _state_1;
		default:
#line 211 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		g_assert_not_reached ();
#line 2089 "rygel-tracker-search-container.c"
	}
	_state_0:
	{
#line 213 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_data_->_tmp0_ = NULL;
#line 213 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_data_->_tmp0_ = _data_->self->query;
#line 213 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_data_->_tmp1_ = NULL;
#line 213 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_data_->_tmp1_ = rygel_tracker_selection_query_new_clone (_data_->_tmp0_);
#line 213 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_data_->query = _data_->_tmp1_;
#line 215 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_data_->_tmp2_ = NULL;
#line 215 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_data_->_tmp2_ = _data_->query;
#line 215 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_data_->_tmp3_ = NULL;
#line 215 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_data_->_tmp3_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL, NULL);
#line 215 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_g_object_unref0 (_data_->_tmp2_->variables);
#line 215 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_data_->_tmp2_->variables = _data_->_tmp3_;
#line 216 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_data_->_tmp4_ = NULL;
#line 216 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_data_->_tmp4_ = _data_->query;
#line 216 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_data_->_tmp5_ = NULL;
#line 216 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_data_->_tmp5_ = _data_->_tmp4_->variables;
#line 216 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		gee_abstract_collection_add ((GeeAbstractCollection*) _data_->_tmp5_, "COUNT(" RYGEL_TRACKER_SELECTION_QUERY_ITEM_VARIABLE ") AS x");
#line 220 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_data_->_tmp6_ = NULL;
#line 220 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_data_->_tmp6_ = _data_->query;
#line 220 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_data_->_tmp7_ = NULL;
#line 220 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_data_->_tmp7_ = _data_->self->priv->resources;
#line 220 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_data_->_state_ = 1;
#line 220 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		rygel_tracker_query_execute ((RygelTrackerQuery*) _data_->_tmp6_, _data_->_tmp7_, rygel_tracker_search_container_get_children_count_ready, _data_);
#line 220 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		return FALSE;
#line 2139 "rygel-tracker-search-container.c"
		_state_1:
#line 220 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		rygel_tracker_query_execute_finish ((RygelTrackerQuery*) _data_->_tmp6_, _data_->_res_, &_data_->_inner_error_);
#line 220 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		if (_data_->_inner_error_ != NULL) {
#line 220 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			_rygel_tracker_query_unref0 (_data_->query);
#line 2147 "rygel-tracker-search-container.c"
			goto __catch5_g_error;
		}
#line 222 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_data_->_tmp9_ = NULL;
#line 222 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_data_->_tmp9_ = _data_->query;
#line 222 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_data_->_tmp10_ = NULL;
#line 222 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_data_->_tmp10_ = _data_->_tmp9_->result;
#line 222 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_data_->_tmp11_ = FALSE;
#line 222 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_data_->_tmp11_ = tracker_sparql_cursor_next (_data_->_tmp10_, NULL, &_data_->_inner_error_);
#line 222 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_data_->_tmp8_ = _data_->_tmp11_;
#line 222 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		if (_data_->_inner_error_ != NULL) {
#line 222 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			_rygel_tracker_query_unref0 (_data_->query);
#line 2168 "rygel-tracker-search-container.c"
			goto __catch5_g_error;
		}
#line 222 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		if (_data_->_tmp8_) {
#line 223 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			_data_->_tmp12_ = NULL;
#line 223 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			_data_->_tmp12_ = _data_->query;
#line 223 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			_data_->_tmp13_ = NULL;
#line 223 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			_data_->_tmp13_ = _data_->_tmp12_->result;
#line 223 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			_data_->_tmp14_ = NULL;
#line 223 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			_data_->_tmp14_ = tracker_sparql_cursor_get_string (_data_->_tmp13_, 0, NULL);
#line 223 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			_data_->_tmp15_ = 0;
#line 223 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			_data_->_tmp15_ = atoi (_data_->_tmp14_);
#line 223 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			rygel_media_container_set_child_count ((RygelMediaContainer*) _data_->self, _data_->_tmp15_);
#line 224 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			rygel_media_container_updated ((RygelMediaContainer*) _data_->self, NULL, RYGEL_OBJECT_EVENT_TYPE_MODIFIED, FALSE);
#line 2193 "rygel-tracker-search-container.c"
		}
#line 212 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_rygel_tracker_query_unref0 (_data_->query);
#line 2197 "rygel-tracker-search-container.c"
	}
	goto __finally5;
	__catch5_g_error:
	{
#line 212 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_data_->_error_ = _data_->_inner_error_;
#line 212 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_data_->_inner_error_ = NULL;
#line 228 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_data_->_tmp16_ = NULL;
#line 228 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_data_->_tmp16_ = _ ("Error getting item count under category '%s': %s");
#line 228 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_data_->_tmp17_ = NULL;
#line 228 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_data_->_tmp17_ = _data_->self->item_factory;
#line 228 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_data_->_tmp18_ = NULL;
#line 228 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_data_->_tmp18_ = _data_->_tmp17_->category;
#line 228 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_data_->_tmp19_ = NULL;
#line 228 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_data_->_tmp19_ = _data_->_error_;
#line 228 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_data_->_tmp20_ = NULL;
#line 228 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_data_->_tmp20_ = _data_->_tmp19_->message;
#line 228 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		g_critical (_data_->_tmp16_, _data_->_tmp18_, _data_->_tmp20_);
#line 232 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_g_error_free0 (_data_->_error_);
#line 232 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		if (_data_->_state_ == 0) {
#line 232 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 2234 "rygel-tracker-search-container.c"
		} else {
#line 232 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 2238 "rygel-tracker-search-container.c"
		}
#line 232 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		g_object_unref (_data_->_async_result);
#line 232 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		return FALSE;
#line 2244 "rygel-tracker-search-container.c"
	}
	__finally5:
#line 212 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	if (_data_->_inner_error_ != NULL) {
#line 212 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
#line 212 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		g_clear_error (&_data_->_inner_error_);
#line 212 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		return FALSE;
#line 2255 "rygel-tracker-search-container.c"
	}
#line 211 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	if (_data_->_state_ == 0) {
#line 211 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 2261 "rygel-tracker-search-container.c"
	} else {
#line 211 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 2265 "rygel-tracker-search-container.c"
	}
#line 211 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	g_object_unref (_data_->_async_result);
#line 211 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	return FALSE;
#line 2271 "rygel-tracker-search-container.c"
}


static gboolean rygel_tracker_search_container_is_our_child (RygelTrackerSearchContainer* self, const gchar* id) {
	gboolean result = FALSE;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gboolean _tmp5_ = FALSE;
	gboolean _tmp6_ = FALSE;
#line 236 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 236 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	g_return_val_if_fail (id != NULL, FALSE);
#line 237 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_tmp0_ = id;
#line 237 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_tmp1_ = rygel_media_object_get_id ((RygelMediaObject*) self);
#line 237 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_tmp2_ = _tmp1_;
#line 237 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_tmp3_ = g_strconcat (_tmp2_, ",", NULL);
#line 237 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_tmp4_ = _tmp3_;
#line 237 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_tmp5_ = g_str_has_prefix (_tmp0_, _tmp4_);
#line 237 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_tmp6_ = _tmp5_;
#line 237 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_g_free0 (_tmp4_);
#line 237 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	result = _tmp6_;
#line 237 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	return result;
#line 2308 "rygel-tracker-search-container.c"
}


static RygelTrackerSelectionQuery* rygel_tracker_search_container_create_query (RygelTrackerSearchContainer* self, RygelRelationalExpression* expression, gint offset, gint max_count, const gchar* sort_criteria) {
	RygelTrackerSelectionQuery* result = NULL;
	gboolean _tmp0_ = FALSE;
	RygelRelationalExpression* _tmp1_ = NULL;
	gconstpointer _tmp2_ = NULL;
	gboolean _tmp8_ = FALSE;
	RygelTrackerSelectionQuery* query = NULL;
	gboolean _tmp9_ = FALSE;
	const gchar* _tmp10_ = NULL;
	gboolean _tmp12_ = FALSE;
	RygelRelationalExpression* _tmp17_ = NULL;
	gconstpointer _tmp18_ = NULL;
	RygelTrackerSelectionQuery* _tmp31_ = NULL;
	gint _tmp32_ = 0;
	RygelTrackerSelectionQuery* _tmp33_ = NULL;
	gint _tmp34_ = 0;
#line 240 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 240 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	g_return_val_if_fail (sort_criteria != NULL, NULL);
#line 244 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_tmp1_ = expression;
#line 244 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_tmp2_ = ((RygelSearchExpression*) _tmp1_)->operand1;
#line 244 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	if (g_strcmp0 ((const gchar*) _tmp2_, "upnp:class") == 0) {
#line 2338 "rygel-tracker-search-container.c"
		RygelTrackerItemFactory* _tmp3_ = NULL;
		const gchar* _tmp4_ = NULL;
		RygelRelationalExpression* _tmp5_ = NULL;
		gconstpointer _tmp6_ = NULL;
		gboolean _tmp7_ = FALSE;
#line 245 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_tmp3_ = self->item_factory;
#line 245 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_tmp4_ = _tmp3_->upnp_class;
#line 245 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_tmp5_ = expression;
#line 245 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_tmp6_ = ((RygelSearchExpression*) _tmp5_)->operand2;
#line 245 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_tmp7_ = g_str_has_prefix (_tmp4_, (const gchar*) _tmp6_);
#line 245 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_tmp0_ = !_tmp7_;
#line 2356 "rygel-tracker-search-container.c"
	} else {
#line 244 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_tmp0_ = FALSE;
#line 2360 "rygel-tracker-search-container.c"
	}
#line 244 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_tmp8_ = _tmp0_;
#line 244 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	if (_tmp8_) {
#line 246 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		result = NULL;
#line 246 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		return result;
#line 2370 "rygel-tracker-search-container.c"
	}
#line 250 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_tmp10_ = sort_criteria;
#line 250 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	if (_tmp10_ == NULL) {
#line 250 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_tmp9_ = TRUE;
#line 2378 "rygel-tracker-search-container.c"
	} else {
		const gchar* _tmp11_ = NULL;
#line 250 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_tmp11_ = sort_criteria;
#line 250 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_tmp9_ = g_strcmp0 (_tmp11_, "") == 0;
#line 2385 "rygel-tracker-search-container.c"
	}
#line 250 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_tmp12_ = _tmp9_;
#line 250 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	if (_tmp12_) {
#line 2391 "rygel-tracker-search-container.c"
		RygelTrackerSelectionQuery* _tmp13_ = NULL;
		RygelTrackerSelectionQuery* _tmp14_ = NULL;
#line 251 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_tmp13_ = self->query;
#line 251 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_tmp14_ = rygel_tracker_selection_query_new_clone (_tmp13_);
#line 251 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_rygel_tracker_query_unref0 (query);
#line 251 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		query = _tmp14_;
#line 2402 "rygel-tracker-search-container.c"
	} else {
		const gchar* _tmp15_ = NULL;
		RygelTrackerSelectionQuery* _tmp16_ = NULL;
#line 253 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_tmp15_ = sort_criteria;
#line 253 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_tmp16_ = rygel_tracker_search_container_create_sorted_query (self, _tmp15_);
#line 253 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_rygel_tracker_query_unref0 (query);
#line 253 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		query = _tmp16_;
#line 2414 "rygel-tracker-search-container.c"
	}
#line 256 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_tmp17_ = expression;
#line 256 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_tmp18_ = ((RygelSearchExpression*) _tmp17_)->operand1;
#line 256 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	if (g_strcmp0 ((const gchar*) _tmp18_, "@parentID") == 0) {
#line 2422 "rygel-tracker-search-container.c"
		RygelRelationalExpression* _tmp19_ = NULL;
		const gchar* _tmp20_ = NULL;
		const gchar* _tmp21_ = NULL;
		gboolean _tmp22_ = FALSE;
#line 257 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_tmp19_ = expression;
#line 257 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_tmp20_ = rygel_media_object_get_id ((RygelMediaObject*) self);
#line 257 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_tmp21_ = _tmp20_;
#line 257 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_tmp22_ = rygel_relational_expression_compare_string (_tmp19_, _tmp21_);
#line 257 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		if (!_tmp22_) {
#line 258 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			result = NULL;
#line 258 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			_rygel_tracker_query_unref0 (query);
#line 258 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			return result;
#line 2443 "rygel-tracker-search-container.c"
		}
	} else {
		RygelRelationalExpression* _tmp23_ = NULL;
		gconstpointer _tmp24_ = NULL;
#line 260 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_tmp23_ = expression;
#line 260 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_tmp24_ = ((RygelSearchExpression*) _tmp23_)->operand1;
#line 260 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		if (g_strcmp0 ((const gchar*) _tmp24_, "upnp:class") != 0) {
#line 2454 "rygel-tracker-search-container.c"
			gchar* filter = NULL;
			RygelRelationalExpression* _tmp25_ = NULL;
			gchar* _tmp26_ = NULL;
			const gchar* _tmp27_ = NULL;
#line 261 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			_tmp25_ = expression;
#line 261 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			_tmp26_ = rygel_tracker_search_container_create_filter_for_child (self, _tmp25_);
#line 261 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			filter = _tmp26_;
#line 262 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			_tmp27_ = filter;
#line 262 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			if (_tmp27_ != NULL) {
#line 2469 "rygel-tracker-search-container.c"
				RygelTrackerSelectionQuery* _tmp28_ = NULL;
				GeeArrayList* _tmp29_ = NULL;
				const gchar* _tmp30_ = NULL;
#line 263 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
				_tmp28_ = query;
#line 263 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
				_tmp29_ = _tmp28_->filters;
#line 263 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
				_tmp30_ = filter;
#line 263 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
				gee_abstract_list_insert ((GeeAbstractList*) _tmp29_, 0, _tmp30_);
#line 2481 "rygel-tracker-search-container.c"
			} else {
#line 265 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
				result = NULL;
#line 265 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
				_g_free0 (filter);
#line 265 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
				_rygel_tracker_query_unref0 (query);
#line 265 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
				return result;
#line 2491 "rygel-tracker-search-container.c"
			}
#line 260 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			_g_free0 (filter);
#line 2495 "rygel-tracker-search-container.c"
		}
	}
#line 269 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_tmp31_ = query;
#line 269 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_tmp32_ = offset;
#line 269 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_tmp31_->offset = _tmp32_;
#line 270 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_tmp33_ = query;
#line 270 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_tmp34_ = max_count;
#line 270 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_tmp33_->max_count = _tmp34_;
#line 272 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	result = query;
#line 272 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	return result;
#line 2514 "rygel-tracker-search-container.c"
}


static glong string_strnlen (gchar* str, glong maxlen) {
	glong result = 0L;
	gchar* end = NULL;
	gchar* _tmp0_ = NULL;
	glong _tmp1_ = 0L;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
#line 1156 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	_tmp0_ = str;
#line 1156 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	_tmp1_ = maxlen;
#line 1156 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	_tmp2_ = memchr (_tmp0_, 0, (gsize) _tmp1_);
#line 1156 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	end = _tmp2_;
#line 1157 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	_tmp3_ = end;
#line 1157 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	if (_tmp3_ == NULL) {
#line 2537 "rygel-tracker-search-container.c"
		glong _tmp4_ = 0L;
#line 1158 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		_tmp4_ = maxlen;
#line 1158 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		result = _tmp4_;
#line 1158 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		return result;
#line 2545 "rygel-tracker-search-container.c"
	} else {
		gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
#line 1160 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		_tmp5_ = end;
#line 1160 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		_tmp6_ = str;
#line 1160 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		result = (glong) (_tmp5_ - _tmp6_);
#line 1160 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		return result;
#line 2557 "rygel-tracker-search-container.c"
	}
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp1_ = 0L;
	gboolean _tmp3_ = FALSE;
	glong _tmp9_ = 0L;
	glong _tmp15_ = 0L;
	glong _tmp18_ = 0L;
	glong _tmp19_ = 0L;
	glong _tmp20_ = 0L;
	glong _tmp21_ = 0L;
	glong _tmp22_ = 0L;
	gchar* _tmp23_ = NULL;
#line 1167 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1169 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	_tmp1_ = offset;
#line 1169 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	if (_tmp1_ >= ((glong) 0)) {
#line 2582 "rygel-tracker-search-container.c"
		glong _tmp2_ = 0L;
#line 1169 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		_tmp2_ = len;
#line 1169 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		_tmp0_ = _tmp2_ >= ((glong) 0);
#line 2588 "rygel-tracker-search-container.c"
	} else {
#line 1169 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		_tmp0_ = FALSE;
#line 2592 "rygel-tracker-search-container.c"
	}
#line 1169 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	_tmp3_ = _tmp0_;
#line 1169 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	if (_tmp3_) {
#line 2598 "rygel-tracker-search-container.c"
		glong _tmp4_ = 0L;
		glong _tmp5_ = 0L;
		glong _tmp6_ = 0L;
#line 1171 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		_tmp4_ = offset;
#line 1171 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		_tmp5_ = len;
#line 1171 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		_tmp6_ = string_strnlen ((gchar*) self, _tmp4_ + _tmp5_);
#line 1171 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		string_length = _tmp6_;
#line 2610 "rygel-tracker-search-container.c"
	} else {
		gint _tmp7_ = 0;
		gint _tmp8_ = 0;
#line 1173 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		_tmp7_ = strlen (self);
#line 1173 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		_tmp8_ = _tmp7_;
#line 1173 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		string_length = (glong) _tmp8_;
#line 2620 "rygel-tracker-search-container.c"
	}
#line 1176 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	_tmp9_ = offset;
#line 1176 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	if (_tmp9_ < ((glong) 0)) {
#line 2626 "rygel-tracker-search-container.c"
		glong _tmp10_ = 0L;
		glong _tmp11_ = 0L;
		glong _tmp12_ = 0L;
#line 1177 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		_tmp10_ = string_length;
#line 1177 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		_tmp11_ = offset;
#line 1177 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		offset = _tmp10_ + _tmp11_;
#line 1178 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		_tmp12_ = offset;
#line 1178 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		g_return_val_if_fail (_tmp12_ >= ((glong) 0), NULL);
#line 2640 "rygel-tracker-search-container.c"
	} else {
		glong _tmp13_ = 0L;
		glong _tmp14_ = 0L;
#line 1180 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		_tmp13_ = offset;
#line 1180 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		_tmp14_ = string_length;
#line 1180 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		g_return_val_if_fail (_tmp13_ <= _tmp14_, NULL);
#line 2650 "rygel-tracker-search-container.c"
	}
#line 1182 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	_tmp15_ = len;
#line 1182 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	if (_tmp15_ < ((glong) 0)) {
#line 2656 "rygel-tracker-search-container.c"
		glong _tmp16_ = 0L;
		glong _tmp17_ = 0L;
#line 1183 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		_tmp16_ = string_length;
#line 1183 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		_tmp17_ = offset;
#line 1183 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		len = _tmp16_ - _tmp17_;
#line 2665 "rygel-tracker-search-container.c"
	}
#line 1185 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	_tmp18_ = offset;
#line 1185 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	_tmp19_ = len;
#line 1185 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	_tmp20_ = string_length;
#line 1185 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	g_return_val_if_fail ((_tmp18_ + _tmp19_) <= _tmp20_, NULL);
#line 1186 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	_tmp21_ = offset;
#line 1186 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	_tmp22_ = len;
#line 1186 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	_tmp23_ = g_strndup (((gchar*) self) + _tmp21_, (gsize) _tmp22_);
#line 1186 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	result = _tmp23_;
#line 1186 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	return result;
#line 2685 "rygel-tracker-search-container.c"
}


static gint string_index_of (const gchar* self, const gchar* needle, gint start_index) {
	gint result = 0;
	gchar* _result_ = NULL;
	gint _tmp0_ = 0;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
#line 898 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, 0);
#line 898 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	g_return_val_if_fail (needle != NULL, 0);
#line 899 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	_tmp0_ = start_index;
#line 899 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	_tmp1_ = needle;
#line 899 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	_tmp2_ = strstr (((gchar*) self) + _tmp0_, (gchar*) _tmp1_);
#line 899 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	_result_ = _tmp2_;
#line 901 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	_tmp3_ = _result_;
#line 901 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	if (_tmp3_ != NULL) {
#line 2712 "rygel-tracker-search-container.c"
		gchar* _tmp4_ = NULL;
#line 902 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		_tmp4_ = _result_;
#line 902 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		result = (gint) (_tmp4_ - ((gchar*) self));
#line 902 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		return result;
#line 2720 "rygel-tracker-search-container.c"
	} else {
#line 904 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		result = -1;
#line 904 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		return result;
#line 2726 "rygel-tracker-search-container.c"
	}
}


static RygelTrackerSelectionQuery* rygel_tracker_search_container_create_sorted_query (RygelTrackerSearchContainer* self, const gchar* sort_criteria) {
	RygelTrackerSelectionQuery* result = NULL;
	RygelTrackerUPnPPropertyMap* key_chain_map = NULL;
	RygelTrackerUPnPPropertyMap* _tmp0_ = NULL;
	gchar** sort_props = NULL;
	const gchar* _tmp1_ = NULL;
	gchar** _tmp2_ = NULL;
	gchar** _tmp3_ = NULL;
	gint sort_props_length1 = 0;
	gint _sort_props_size_ = 0;
	gchar* order = NULL;
	gchar* _tmp4_ = NULL;
	GeeArrayList* variables = NULL;
	GeeArrayList* _tmp5_ = NULL;
	GeeArrayList* filters = NULL;
	GeeArrayList* _tmp6_ = NULL;
	GeeArrayList* _tmp7_ = NULL;
	RygelTrackerSelectionQuery* _tmp8_ = NULL;
	GeeArrayList* _tmp9_ = NULL;
	GeeArrayList* _tmp10_ = NULL;
	RygelTrackerSelectionQuery* _tmp11_ = NULL;
	GeeArrayList* _tmp12_ = NULL;
	gchar** _tmp13_ = NULL;
	gint _tmp13__length1 = 0;
	const gchar* _tmp37_ = NULL;
	GeeArrayList* _tmp41_ = NULL;
	RygelTrackerSelectionQuery* _tmp42_ = NULL;
	RygelTrackerQueryTriplets* _tmp43_ = NULL;
	RygelTrackerQueryTriplets* _tmp44_ = NULL;
	RygelTrackerQueryTriplets* _tmp45_ = NULL;
	GeeArrayList* _tmp46_ = NULL;
	const gchar* _tmp47_ = NULL;
	RygelTrackerSelectionQuery* _tmp48_ = NULL;
	RygelTrackerSelectionQuery* _tmp49_ = NULL;
#line 275 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 275 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	g_return_val_if_fail (sort_criteria != NULL, NULL);
#line 276 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_tmp0_ = rygel_tracker_upn_pproperty_map_get_property_map ();
#line 276 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	key_chain_map = _tmp0_;
#line 277 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_tmp1_ = sort_criteria;
#line 277 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_tmp3_ = _tmp2_ = g_strsplit (_tmp1_, ",", 0);
#line 277 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	sort_props = _tmp3_;
#line 277 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	sort_props_length1 = _vala_array_length (_tmp2_);
#line 277 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_sort_props_size_ = sort_props_length1;
#line 278 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_tmp4_ = g_strdup ("");
#line 278 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	order = _tmp4_;
#line 279 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_tmp5_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL, NULL);
#line 279 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	variables = _tmp5_;
#line 280 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_tmp6_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL, NULL);
#line 280 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	filters = _tmp6_;
#line 282 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_tmp7_ = variables;
#line 282 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_tmp8_ = self->query;
#line 282 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_tmp9_ = _tmp8_->variables;
#line 282 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	gee_array_list_add_all (_tmp7_, (GeeCollection*) _tmp9_);
#line 283 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_tmp10_ = filters;
#line 283 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_tmp11_ = self->query;
#line 283 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_tmp12_ = _tmp11_->filters;
#line 283 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	gee_array_list_add_all (_tmp10_, (GeeCollection*) _tmp12_);
#line 285 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_tmp13_ = sort_props;
#line 285 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_tmp13__length1 = sort_props_length1;
#line 2815 "rygel-tracker-search-container.c"
	{
		gchar** s_collection = NULL;
		gint s_collection_length1 = 0;
		gint _s_collection_size_ = 0;
		gint s_it = 0;
#line 285 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		s_collection = _tmp13_;
#line 285 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		s_collection_length1 = _tmp13__length1;
#line 285 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		for (s_it = 0; s_it < _tmp13__length1; s_it = s_it + 1) {
#line 2827 "rygel-tracker-search-container.c"
			gchar* _tmp14_ = NULL;
			gchar* s = NULL;
#line 285 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			_tmp14_ = g_strdup (s_collection[s_it]);
#line 285 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			s = _tmp14_;
#line 2834 "rygel-tracker-search-container.c"
			{
				gchar* key = NULL;
				RygelTrackerUPnPPropertyMap* _tmp15_ = NULL;
				const gchar* _tmp16_ = NULL;
				gchar* _tmp17_ = NULL;
				gchar* _tmp18_ = NULL;
				gchar* _tmp19_ = NULL;
				gchar* _tmp20_ = NULL;
				const gchar* _tmp21_ = NULL;
				gint _tmp22_ = 0;
				const gchar* _tmp23_ = NULL;
				gboolean _tmp24_ = FALSE;
#line 286 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
				_tmp15_ = key_chain_map;
#line 286 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
				_tmp16_ = s;
#line 286 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
				_tmp17_ = string_substring (_tmp16_, (glong) 1, (glong) (-1));
#line 286 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
				_tmp18_ = _tmp17_;
#line 286 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
				_tmp19_ = rygel_tracker_upn_pproperty_map_get (_tmp15_, _tmp18_);
#line 286 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
				_tmp20_ = _tmp19_;
#line 286 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
				_g_free0 (_tmp18_);
#line 286 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
				key = _tmp20_;
#line 287 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
				_tmp21_ = key;
#line 287 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
				_tmp22_ = string_index_of (_tmp21_, RYGEL_TRACKER_SELECTION_QUERY_ITEM_VARIABLE, 0);
#line 287 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
				if (_tmp22_ == 0) {
#line 288 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
					_g_free0 (key);
#line 288 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
					_g_free0 (s);
#line 288 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
					continue;
#line 2875 "rygel-tracker-search-container.c"
				}
#line 291 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
				_tmp23_ = s;
#line 291 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
				_tmp24_ = g_str_has_prefix (_tmp23_, "-");
#line 291 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
				if (_tmp24_) {
#line 2883 "rygel-tracker-search-container.c"
					const gchar* _tmp25_ = NULL;
					const gchar* _tmp26_ = NULL;
					gchar* _tmp27_ = NULL;
					gchar* _tmp28_ = NULL;
					gchar* _tmp29_ = NULL;
					gchar* _tmp30_ = NULL;
					gchar* _tmp31_ = NULL;
#line 292 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
					_tmp25_ = order;
#line 292 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
					_tmp26_ = key;
#line 292 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
					_tmp27_ = g_strconcat ("DESC (", _tmp26_, NULL);
#line 292 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
					_tmp28_ = _tmp27_;
#line 292 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
					_tmp29_ = g_strconcat (_tmp28_, ") ", NULL);
#line 292 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
					_tmp30_ = _tmp29_;
#line 292 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
					_tmp31_ = g_strconcat (_tmp25_, _tmp30_, NULL);
#line 292 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
					_g_free0 (order);
#line 292 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
					order = _tmp31_;
#line 292 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
					_g_free0 (_tmp30_);
#line 292 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
					_g_free0 (_tmp28_);
#line 2913 "rygel-tracker-search-container.c"
				} else {
					const gchar* _tmp32_ = NULL;
					const gchar* _tmp33_ = NULL;
					gchar* _tmp34_ = NULL;
					gchar* _tmp35_ = NULL;
					gchar* _tmp36_ = NULL;
#line 295 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
					_tmp32_ = order;
#line 295 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
					_tmp33_ = key;
#line 295 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
					_tmp34_ = g_strconcat (_tmp33_, " ", NULL);
#line 295 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
					_tmp35_ = _tmp34_;
#line 295 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
					_tmp36_ = g_strconcat (_tmp32_, _tmp35_, NULL);
#line 295 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
					_g_free0 (order);
#line 295 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
					order = _tmp36_;
#line 295 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
					_g_free0 (_tmp35_);
#line 2936 "rygel-tracker-search-container.c"
				}
#line 285 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
				_g_free0 (key);
#line 285 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
				_g_free0 (s);
#line 2942 "rygel-tracker-search-container.c"
			}
		}
	}
#line 299 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_tmp37_ = order;
#line 299 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	if (g_strcmp0 (_tmp37_, "") == 0) {
#line 2950 "rygel-tracker-search-container.c"
		RygelTrackerSelectionQuery* _tmp38_ = NULL;
		const gchar* _tmp39_ = NULL;
		gchar* _tmp40_ = NULL;
#line 300 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_tmp38_ = self->query;
#line 300 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_tmp39_ = _tmp38_->order_by;
#line 300 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_tmp40_ = g_strdup (_tmp39_);
#line 300 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_g_free0 (order);
#line 300 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		order = _tmp40_;
#line 2964 "rygel-tracker-search-container.c"
	}
#line 303 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_tmp41_ = variables;
#line 303 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_tmp42_ = self->query;
#line 303 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_tmp43_ = ((RygelTrackerQuery*) _tmp42_)->triplets;
#line 303 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_tmp44_ = rygel_tracker_query_triplets_new_clone (_tmp43_);
#line 303 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_tmp45_ = _tmp44_;
#line 303 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_tmp46_ = filters;
#line 303 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_tmp47_ = order;
#line 303 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_tmp48_ = rygel_tracker_selection_query_new (_tmp41_, _tmp45_, _tmp46_, _tmp47_, 0, -1);
#line 303 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_tmp49_ = _tmp48_;
#line 303 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_g_object_unref0 (_tmp45_);
#line 303 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	result = _tmp49_;
#line 303 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_g_object_unref0 (filters);
#line 303 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_g_object_unref0 (variables);
#line 303 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_g_free0 (order);
#line 303 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	sort_props = (_vala_array_free (sort_props, sort_props_length1, (GDestroyNotify) g_free), NULL);
#line 303 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_g_object_unref0 (key_chain_map);
#line 303 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	return result;
#line 3000 "rygel-tracker-search-container.c"
}


static gunichar string_get_char (const gchar* self, glong index) {
	gunichar result = 0U;
	glong _tmp0_ = 0L;
	gunichar _tmp1_ = 0U;
#line 995 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, 0U);
#line 996 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	_tmp0_ = index;
#line 996 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	_tmp1_ = g_utf8_get_char (((gchar*) self) + _tmp0_);
#line 996 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	result = _tmp1_;
#line 996 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	return result;
#line 3018 "rygel-tracker-search-container.c"
}


static gchar* rygel_tracker_search_container_urn_to_utf8 (RygelTrackerSearchContainer* self, const gchar* urn) {
	gchar* result = NULL;
	GString* urn_builder = NULL;
	GString* _tmp0_ = NULL;
	const gchar* s = NULL;
	const gchar* _tmp1_ = NULL;
	GString* _tmp18_ = NULL;
	const gchar* _tmp19_ = NULL;
	gchar* _tmp20_ = NULL;
#line 310 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 310 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	g_return_val_if_fail (urn != NULL, NULL);
#line 311 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_tmp0_ = g_string_new ("");
#line 311 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	urn_builder = _tmp0_;
#line 312 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_tmp1_ = urn;
#line 312 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	s = _tmp1_;
#line 3043 "rygel-tracker-search-container.c"
	{
		gboolean _tmp2_ = FALSE;
#line 314 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_tmp2_ = TRUE;
#line 314 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		while (TRUE) {
#line 3050 "rygel-tracker-search-container.c"
			gboolean _tmp3_ = FALSE;
			const gchar* _tmp6_ = NULL;
			gunichar _tmp7_ = 0U;
			gunichar character = 0U;
			const gchar* _tmp8_ = NULL;
			gunichar _tmp9_ = 0U;
			gboolean _tmp10_ = FALSE;
			gunichar _tmp11_ = 0U;
			gboolean _tmp12_ = FALSE;
			gboolean _tmp15_ = FALSE;
#line 314 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			_tmp3_ = _tmp2_;
#line 314 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			if (!_tmp3_) {
#line 3065 "rygel-tracker-search-container.c"
				const gchar* _tmp4_ = NULL;
				const gchar* _tmp5_ = NULL;
#line 314 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
				_tmp4_ = s;
#line 314 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
				_tmp5_ = g_utf8_next_char (_tmp4_);
#line 314 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
				s = _tmp5_;
#line 3074 "rygel-tracker-search-container.c"
			}
#line 314 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			_tmp2_ = FALSE;
#line 314 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			_tmp6_ = s;
#line 314 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			_tmp7_ = string_get_char (_tmp6_, (glong) 0);
#line 314 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			if (!(_tmp7_ != ((gunichar) 0))) {
#line 314 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
				break;
#line 3086 "rygel-tracker-search-container.c"
			}
#line 315 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			_tmp8_ = s;
#line 315 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			_tmp9_ = string_get_char (_tmp8_, (glong) 0);
#line 315 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			character = _tmp9_;
#line 316 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			_tmp11_ = character;
#line 316 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			_tmp12_ = g_unichar_iscntrl (_tmp11_);
#line 316 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			if (_tmp12_) {
#line 316 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
				_tmp10_ = TRUE;
#line 3102 "rygel-tracker-search-container.c"
			} else {
				gunichar _tmp13_ = 0U;
				gboolean _tmp14_ = FALSE;
#line 316 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
				_tmp13_ = character;
#line 316 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
				_tmp14_ = g_unichar_validate (_tmp13_);
#line 316 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
				_tmp10_ = !_tmp14_;
#line 3112 "rygel-tracker-search-container.c"
			}
#line 316 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			_tmp15_ = _tmp10_;
#line 316 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			if (!_tmp15_) {
#line 3118 "rygel-tracker-search-container.c"
				GString* _tmp16_ = NULL;
				gunichar _tmp17_ = 0U;
#line 317 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
				_tmp16_ = urn_builder;
#line 317 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
				_tmp17_ = character;
#line 317 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
				g_string_append_unichar (_tmp16_, _tmp17_);
#line 3127 "rygel-tracker-search-container.c"
			}
		}
	}
#line 321 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_tmp18_ = urn_builder;
#line 321 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_tmp19_ = _tmp18_->str;
#line 321 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_tmp20_ = g_strdup (_tmp19_);
#line 321 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	result = _tmp20_;
#line 321 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_g_string_free0 (urn_builder);
#line 321 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	return result;
#line 3143 "rygel-tracker-search-container.c"
}


static gchar* rygel_tracker_search_container_create_filter_for_child (RygelTrackerSearchContainer* self, RygelRelationalExpression* expression) {
	gchar* result = NULL;
	gchar* filter = NULL;
	gchar* variable = NULL;
	gchar* value = NULL;
	RygelRelationalExpression* _tmp0_ = NULL;
	gconstpointer _tmp1_ = NULL;
	gboolean _tmp31_ = FALSE;
	const gchar* _tmp32_ = NULL;
	gboolean _tmp34_ = FALSE;
	RygelRelationalExpression* _tmp35_ = NULL;
	gconstpointer _tmp36_ = NULL;
#line 324 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 324 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	g_return_val_if_fail (expression != NULL, NULL);
#line 325 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	filter = NULL;
#line 326 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	variable = NULL;
#line 327 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	value = NULL;
#line 329 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_tmp0_ = expression;
#line 329 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_tmp1_ = ((RygelSearchExpression*) _tmp0_)->operand1;
#line 329 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	if (g_strcmp0 ((const gchar*) _tmp1_, "@id") == 0) {
#line 3175 "rygel-tracker-search-container.c"
		gchar* _tmp2_ = NULL;
		gchar* parent_id = NULL;
		gchar* urn = NULL;
		RygelRelationalExpression* _tmp3_ = NULL;
		gconstpointer _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
		gboolean _tmp8_ = FALSE;
		gboolean _tmp11_ = FALSE;
		gboolean _tmp12_ = FALSE;
		const gchar* _tmp13_ = NULL;
		gboolean _tmp15_ = FALSE;
		gboolean _tmp19_ = FALSE;
		const gchar* _tmp20_ = NULL;
		gchar* _tmp21_ = NULL;
		RygelRelationalExpression* _tmp22_ = NULL;
		gconstpointer _tmp23_ = NULL;
#line 330 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_tmp2_ = g_strdup (RYGEL_TRACKER_SELECTION_QUERY_ITEM_VARIABLE);
#line 330 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_g_free0 (variable);
#line 330 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		variable = _tmp2_;
#line 334 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_tmp3_ = expression;
#line 334 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_tmp4_ = ((RygelSearchExpression*) _tmp3_)->operand2;
#line 334 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_tmp6_ = rygel_tracker_search_container_get_item_info (self, (const gchar*) _tmp4_, &_tmp5_);
#line 334 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_g_free0 (parent_id);
#line 334 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		parent_id = _tmp5_;
#line 334 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		urn = _tmp6_;
#line 336 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_tmp7_ = urn;
#line 336 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_tmp8_ = g_utf8_validate (_tmp7_, (gssize) (-1), NULL);
#line 336 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		if (!_tmp8_) {
#line 3218 "rygel-tracker-search-container.c"
			const gchar* _tmp9_ = NULL;
			gchar* _tmp10_ = NULL;
#line 337 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			_tmp9_ = urn;
#line 337 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			_tmp10_ = rygel_tracker_search_container_urn_to_utf8 (self, _tmp9_);
#line 337 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			_g_free0 (urn);
#line 337 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			urn = _tmp10_;
#line 3229 "rygel-tracker-search-container.c"
		}
#line 340 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_tmp13_ = urn;
#line 340 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		if (_tmp13_ == NULL) {
#line 340 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			_tmp12_ = TRUE;
#line 3237 "rygel-tracker-search-container.c"
		} else {
			const gchar* _tmp14_ = NULL;
#line 340 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			_tmp14_ = parent_id;
#line 340 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			_tmp12_ = _tmp14_ == NULL;
#line 3244 "rygel-tracker-search-container.c"
		}
#line 340 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_tmp15_ = _tmp12_;
#line 340 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		if (_tmp15_) {
#line 340 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			_tmp11_ = TRUE;
#line 3252 "rygel-tracker-search-container.c"
		} else {
			const gchar* _tmp16_ = NULL;
			const gchar* _tmp17_ = NULL;
			const gchar* _tmp18_ = NULL;
#line 340 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			_tmp16_ = parent_id;
#line 340 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			_tmp17_ = rygel_media_object_get_id ((RygelMediaObject*) self);
#line 340 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			_tmp18_ = _tmp17_;
#line 340 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			_tmp11_ = g_strcmp0 (_tmp16_, _tmp18_) != 0;
#line 3265 "rygel-tracker-search-container.c"
		}
#line 340 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_tmp19_ = _tmp11_;
#line 340 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		if (_tmp19_) {
#line 341 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			result = NULL;
#line 341 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			_g_free0 (urn);
#line 341 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			_g_free0 (parent_id);
#line 341 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			_g_free0 (value);
#line 341 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			_g_free0 (variable);
#line 341 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			_g_free0 (filter);
#line 341 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			return result;
#line 3285 "rygel-tracker-search-container.c"
		}
#line 344 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_tmp20_ = urn;
#line 344 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_tmp21_ = rygel_tracker_query_escape_string (_tmp20_);
#line 344 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_g_free0 (urn);
#line 344 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		urn = _tmp21_;
#line 346 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_tmp22_ = expression;
#line 346 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_tmp23_ = ((RygelSearchExpression*) _tmp22_)->op;
#line 346 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		switch ((GUPnPSearchCriteriaOp) ((gintptr) _tmp23_)) {
#line 346 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			case GUPNP_SEARCH_CRITERIA_OP_EQ:
#line 3303 "rygel-tracker-search-container.c"
			{
				const gchar* _tmp24_ = NULL;
				gchar* _tmp25_ = NULL;
				gchar* _tmp26_ = NULL;
				gchar* _tmp27_ = NULL;
#line 348 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
				_tmp24_ = urn;
#line 348 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
				_tmp25_ = g_strconcat ("<", _tmp24_, NULL);
#line 348 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
				_tmp26_ = _tmp25_;
#line 348 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
				_tmp27_ = g_strconcat (_tmp26_, ">", NULL);
#line 348 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
				_g_free0 (value);
#line 348 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
				value = _tmp27_;
#line 348 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
				_g_free0 (_tmp26_);
#line 349 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
				break;
#line 3325 "rygel-tracker-search-container.c"
			}
#line 346 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			case GUPNP_SEARCH_CRITERIA_OP_CONTAINS:
#line 3329 "rygel-tracker-search-container.c"
			{
				RygelRelationalExpression* _tmp28_ = NULL;
				gconstpointer _tmp29_ = NULL;
				gchar* _tmp30_ = NULL;
#line 351 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
				_tmp28_ = expression;
#line 351 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
				_tmp29_ = ((RygelSearchExpression*) _tmp28_)->operand2;
#line 351 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
				_tmp30_ = g_strdup ((const gchar*) _tmp29_);
#line 351 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
				_g_free0 (value);
#line 351 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
				value = _tmp30_;
#line 352 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
				break;
#line 3346 "rygel-tracker-search-container.c"
			}
			default:
#line 346 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			break;
#line 3351 "rygel-tracker-search-container.c"
		}
#line 329 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_g_free0 (urn);
#line 329 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_g_free0 (parent_id);
#line 3357 "rygel-tracker-search-container.c"
	}
#line 356 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_tmp32_ = variable;
#line 356 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	if (_tmp32_ == NULL) {
#line 356 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_tmp31_ = TRUE;
#line 3365 "rygel-tracker-search-container.c"
	} else {
		const gchar* _tmp33_ = NULL;
#line 356 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_tmp33_ = value;
#line 356 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_tmp31_ = _tmp33_ == NULL;
#line 3372 "rygel-tracker-search-container.c"
	}
#line 356 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_tmp34_ = _tmp31_;
#line 356 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	if (_tmp34_) {
#line 357 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		result = NULL;
#line 357 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_g_free0 (value);
#line 357 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_g_free0 (variable);
#line 357 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		_g_free0 (filter);
#line 357 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		return result;
#line 3388 "rygel-tracker-search-container.c"
	}
#line 360 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_tmp35_ = expression;
#line 360 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_tmp36_ = ((RygelSearchExpression*) _tmp35_)->op;
#line 360 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	switch ((GUPnPSearchCriteriaOp) ((gintptr) _tmp36_)) {
#line 360 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		case GUPNP_SEARCH_CRITERIA_OP_EQ:
#line 3398 "rygel-tracker-search-container.c"
		{
			const gchar* _tmp37_ = NULL;
			gchar* _tmp38_ = NULL;
			gchar* _tmp39_ = NULL;
			const gchar* _tmp40_ = NULL;
			gchar* _tmp41_ = NULL;
#line 362 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			_tmp37_ = variable;
#line 362 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			_tmp38_ = g_strconcat (_tmp37_, " = ", NULL);
#line 362 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			_tmp39_ = _tmp38_;
#line 362 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			_tmp40_ = value;
#line 362 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			_tmp41_ = g_strconcat (_tmp39_, _tmp40_, NULL);
#line 362 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			_g_free0 (filter);
#line 362 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			filter = _tmp41_;
#line 362 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			_g_free0 (_tmp39_);
#line 363 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			break;
#line 3423 "rygel-tracker-search-container.c"
		}
#line 360 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		case GUPNP_SEARCH_CRITERIA_OP_CONTAINS:
#line 3427 "rygel-tracker-search-container.c"
		{
			gchar* regex = NULL;
			const gchar* _tmp42_ = NULL;
			gchar* _tmp43_ = NULL;
			const gchar* _tmp44_ = NULL;
			gchar* _tmp45_ = NULL;
			gchar* _tmp46_ = NULL;
			gchar* _tmp47_ = NULL;
			gchar* _tmp48_ = NULL;
			const gchar* _tmp49_ = NULL;
			gchar* _tmp50_ = NULL;
			gchar* _tmp51_ = NULL;
			gchar* _tmp52_ = NULL;
#line 366 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			_tmp42_ = value;
#line 366 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			_tmp43_ = rygel_tracker_query_escape_regex (_tmp42_);
#line 366 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			regex = _tmp43_;
#line 368 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			_tmp44_ = variable;
#line 368 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			_tmp45_ = g_strconcat ("regex(", _tmp44_, NULL);
#line 368 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			_tmp46_ = _tmp45_;
#line 368 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			_tmp47_ = g_strconcat (_tmp46_, ", \"", NULL);
#line 368 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			_tmp48_ = _tmp47_;
#line 368 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			_tmp49_ = regex;
#line 368 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			_tmp50_ = g_strconcat (_tmp48_, _tmp49_, NULL);
#line 368 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			_tmp51_ = _tmp50_;
#line 368 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			_tmp52_ = g_strconcat (_tmp51_, "\", \"i\")", NULL);
#line 368 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			_g_free0 (filter);
#line 368 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			filter = _tmp52_;
#line 368 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			_g_free0 (_tmp51_);
#line 368 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			_g_free0 (_tmp48_);
#line 368 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			_g_free0 (_tmp46_);
#line 369 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			_g_free0 (regex);
#line 369 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
			break;
#line 3479 "rygel-tracker-search-container.c"
		}
		default:
#line 360 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
		break;
#line 3484 "rygel-tracker-search-container.c"
	}
#line 372 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	result = filter;
#line 372 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_g_free0 (value);
#line 372 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_g_free0 (variable);
#line 372 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	return result;
#line 3494 "rygel-tracker-search-container.c"
}


static void rygel_tracker_search_container_class_init (RygelTrackerSearchContainerClass * klass) {
#line 34 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	rygel_tracker_search_container_parent_class = g_type_class_peek_parent (klass);
#line 34 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	g_type_class_add_private (klass, sizeof (RygelTrackerSearchContainerPrivate));
#line 34 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	RYGEL_MEDIA_CONTAINER_CLASS (klass)->get_children = rygel_tracker_search_container_real_get_children;
#line 34 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	RYGEL_MEDIA_CONTAINER_CLASS (klass)->get_children_finish = rygel_tracker_search_container_real_get_children_finish;
#line 34 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	RYGEL_MEDIA_CONTAINER_CLASS (klass)->find_object = rygel_tracker_search_container_real_find_object;
#line 34 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	RYGEL_MEDIA_CONTAINER_CLASS (klass)->find_object_finish = rygel_tracker_search_container_real_find_object_finish;
#line 34 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	G_OBJECT_CLASS (klass)->finalize = rygel_tracker_search_container_finalize;
#line 3513 "rygel-tracker-search-container.c"
}


static void rygel_tracker_search_container_instance_init (RygelTrackerSearchContainer * self) {
#line 34 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	self->priv = RYGEL_TRACKER_SEARCH_CONTAINER_GET_PRIVATE (self);
#line 3520 "rygel-tracker-search-container.c"
}


static void rygel_tracker_search_container_finalize (GObject* obj) {
	RygelTrackerSearchContainer * self;
#line 34 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TRACKER_TYPE_SEARCH_CONTAINER, RygelTrackerSearchContainer);
#line 38 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_rygel_tracker_query_unref0 (self->query);
#line 39 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_rygel_tracker_item_factory_unref0 (self->item_factory);
#line 41 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	_g_object_unref0 (self->priv->resources);
#line 34 "/home/jens/Source/rygel/src/plugins/tracker/rygel-tracker-search-container.vala"
	G_OBJECT_CLASS (rygel_tracker_search_container_parent_class)->finalize (obj);
#line 3536 "rygel-tracker-search-container.c"
}


/**
 * A container listing a Tracker search result.
 */
GType rygel_tracker_search_container_get_type (void) {
	static volatile gsize rygel_tracker_search_container_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_tracker_search_container_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelTrackerSearchContainerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_tracker_search_container_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelTrackerSearchContainer), 0, (GInstanceInitFunc) rygel_tracker_search_container_instance_init, NULL };
		GType rygel_tracker_search_container_type_id;
		rygel_tracker_search_container_type_id = g_type_register_static (RYGEL_TYPE_SIMPLE_CONTAINER, "RygelTrackerSearchContainer", &g_define_type_info, 0);
		g_once_init_leave (&rygel_tracker_search_container_type_id__volatile, rygel_tracker_search_container_type_id);
	}
	return rygel_tracker_search_container_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



