/* regression.c generated by valac 0.22.0, the Vala compiler
 * generated from regression.vala, do not modify */

/*
 * Copyright (C) 2013 Intel Corporation.
 *
 * Author: Jens Georg <jensg@openismus.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include "rygel-media-export-internal.h"
#include "rygel-server.h"
#include <sqlite3.h>
#include "rygel-core.h"
#include <stdlib.h>
#include <string.h>

#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _rygel_media_export_database_cursor_iterator_unref0(var) ((var == NULL) ? NULL : (var = (rygel_media_export_database_cursor_iterator_unref (var), NULL)))

#define TYPE_TEST_CONFIG (test_config_get_type ())
#define TEST_CONFIG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TEST_CONFIG, TestConfig))
#define TEST_CONFIG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TEST_CONFIG, TestConfigClass))
#define IS_TEST_CONFIG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TEST_CONFIG))
#define IS_TEST_CONFIG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TEST_CONFIG))
#define TEST_CONFIG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TEST_CONFIG, TestConfigClass))

typedef struct _TestConfig TestConfig;
typedef struct _TestConfigClass TestConfigClass;
typedef struct _TestConfigPrivate TestConfigPrivate;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _TestConfig {
	RygelBaseConfiguration parent_instance;
	TestConfigPrivate * priv;
};

struct _TestConfigClass {
	RygelBaseConfigurationClass parent_class;
};


static gpointer test_config_parent_class = NULL;

void test_bgo683926_1 (void);
static void _vala_GValue_array_free (GValue* array, gint array_length);
void test_bgo683926_2 (void);
void test_silence_vala (void);
GType test_config_get_type (void) G_GNUC_CONST;
enum  {
	TEST_CONFIG_DUMMY_PROPERTY
};
static gboolean test_config_real_get_bool (RygelBaseConfiguration* base, const gchar* section, const gchar* key, GError** error);
TestConfig* test_config_new (void);
TestConfig* test_config_construct (GType object_type);
gint _vala_main (gchar** args, int args_length1);
static void _test_bgo683926_1_gtest_func (void);
static void _test_bgo683926_2_gtest_func (void);


/**
 * Test that database errors are reported correctly. This is a side-bug
 * discovered during fixing this bug.
 */
static void _vala_GValue_array_free (GValue* array, gint array_length) {
#line 40 "/home/jens/Source/rygel/tests/plugins/media-export/regression.vala"
	if (array != NULL) {
#line 87 "regression.c"
		int i;
#line 40 "/home/jens/Source/rygel/tests/plugins/media-export/regression.vala"
		for (i = 0; i < array_length; i = i + 1) {
#line 40 "/home/jens/Source/rygel/tests/plugins/media-export/regression.vala"
			g_value_unset (&array[i]);
#line 93 "regression.c"
		}
	}
#line 40 "/home/jens/Source/rygel/tests/plugins/media-export/regression.vala"
	g_free (array);
#line 98 "regression.c"
}


void test_bgo683926_1 (void) {
	RygelMediaExportDatabase* db = NULL;
	GError * _inner_error_ = NULL;
#line 28 "/home/jens/Source/rygel/tests/plugins/media-export/regression.vala"
	db = NULL;
#line 107 "regression.c"
	{
		RygelMediaExportDatabase* _tmp0_ = NULL;
		RygelMediaExportDatabase* _tmp1_ = NULL;
		RygelMediaExportDatabase* _tmp2_ = NULL;
		RygelMediaExportDatabase* _tmp3_ = NULL;
#line 31 "/home/jens/Source/rygel/tests/plugins/media-export/regression.vala"
		_tmp1_ = rygel_media_export_database_new (":memory:", &_inner_error_);
#line 31 "/home/jens/Source/rygel/tests/plugins/media-export/regression.vala"
		_tmp0_ = _tmp1_;
#line 31 "/home/jens/Source/rygel/tests/plugins/media-export/regression.vala"
		if (_inner_error_ != NULL) {
#line 119 "regression.c"
			goto __catch0_g_error;
		}
#line 31 "/home/jens/Source/rygel/tests/plugins/media-export/regression.vala"
		_g_object_unref0 (db);
#line 31 "/home/jens/Source/rygel/tests/plugins/media-export/regression.vala"
		db = _tmp0_;
#line 32 "/home/jens/Source/rygel/tests/plugins/media-export/regression.vala"
		_tmp2_ = db;
#line 32 "/home/jens/Source/rygel/tests/plugins/media-export/regression.vala"
		rygel_media_export_database_exec (_tmp2_, "create table object (id text not null, title text not null);", NULL, 0, &_inner_error_);
#line 32 "/home/jens/Source/rygel/tests/plugins/media-export/regression.vala"
		if (_inner_error_ != NULL) {
#line 132 "regression.c"
			goto __catch0_g_error;
		}
#line 33 "/home/jens/Source/rygel/tests/plugins/media-export/regression.vala"
		_tmp3_ = db;
#line 33 "/home/jens/Source/rygel/tests/plugins/media-export/regression.vala"
		rygel_media_export_database_exec (_tmp3_, "insert into object (id, title) VALUES ('a', 'b');", NULL, 0, &_inner_error_);
#line 33 "/home/jens/Source/rygel/tests/plugins/media-export/regression.vala"
		if (_inner_error_ != NULL) {
#line 141 "regression.c"
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp4_ = NULL;
#line 30 "/home/jens/Source/rygel/tests/plugins/media-export/regression.vala"
		e = _inner_error_;
#line 30 "/home/jens/Source/rygel/tests/plugins/media-export/regression.vala"
		_inner_error_ = NULL;
#line 35 "/home/jens/Source/rygel/tests/plugins/media-export/regression.vala"
		_tmp4_ = e->message;
#line 35 "/home/jens/Source/rygel/tests/plugins/media-export/regression.vala"
		g_error ("regression.vala:35: => Database preparation failed: %s", _tmp4_);
#line 30 "/home/jens/Source/rygel/tests/plugins/media-export/regression.vala"
		_g_error_free0 (e);
#line 160 "regression.c"
	}
	__finally0:
#line 30 "/home/jens/Source/rygel/tests/plugins/media-export/regression.vala"
	if (_inner_error_ != NULL) {
#line 30 "/home/jens/Source/rygel/tests/plugins/media-export/regression.vala"
		_g_object_unref0 (db);
#line 30 "/home/jens/Source/rygel/tests/plugins/media-export/regression.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 30 "/home/jens/Source/rygel/tests/plugins/media-export/regression.vala"
		g_clear_error (&_inner_error_);
#line 30 "/home/jens/Source/rygel/tests/plugins/media-export/regression.vala"
		return;
#line 173 "regression.c"
	}
	{
		GValue* val = NULL;
		GValue _tmp5_ = {0};
		GValue* _tmp6_ = NULL;
		gint val_length1 = 0;
		gint _val_size_ = 0;
		RygelMediaExportDatabase* _tmp7_ = NULL;
#line 39 "/home/jens/Source/rygel/tests/plugins/media-export/regression.vala"
		g_value_init (&_tmp5_, G_TYPE_STRING);
#line 39 "/home/jens/Source/rygel/tests/plugins/media-export/regression.vala"
		g_value_set_string (&_tmp5_, "c");
#line 39 "/home/jens/Source/rygel/tests/plugins/media-export/regression.vala"
		_tmp6_ = g_new0 (GValue, 1);
#line 39 "/home/jens/Source/rygel/tests/plugins/media-export/regression.vala"
		_tmp6_[0] = _tmp5_;
#line 39 "/home/jens/Source/rygel/tests/plugins/media-export/regression.vala"
		val = _tmp6_;
#line 39 "/home/jens/Source/rygel/tests/plugins/media-export/regression.vala"
		val_length1 = 1;
#line 39 "/home/jens/Source/rygel/tests/plugins/media-export/regression.vala"
		_val_size_ = val_length1;
#line 40 "/home/jens/Source/rygel/tests/plugins/media-export/regression.vala"
		_tmp7_ = db;
#line 40 "/home/jens/Source/rygel/tests/plugins/media-export/regression.vala"
		rygel_media_export_database_exec (_tmp7_, "replace into object (title) VALUES (?);", val, val_length1, &_inner_error_);
#line 40 "/home/jens/Source/rygel/tests/plugins/media-export/regression.vala"
		if (_inner_error_ != NULL) {
#line 40 "/home/jens/Source/rygel/tests/plugins/media-export/regression.vala"
			val = (_vala_GValue_array_free (val, val_length1), NULL);
#line 204 "regression.c"
			goto __catch1_g_error;
		}
#line 41 "/home/jens/Source/rygel/tests/plugins/media-export/regression.vala"
		g_assert_not_reached ();
#line 38 "/home/jens/Source/rygel/tests/plugins/media-export/regression.vala"
		val = (_vala_GValue_array_free (val, val_length1), NULL);
#line 211 "regression.c"
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError* e = NULL;
#line 38 "/home/jens/Source/rygel/tests/plugins/media-export/regression.vala"
		e = _inner_error_;
#line 38 "/home/jens/Source/rygel/tests/plugins/media-export/regression.vala"
		_inner_error_ = NULL;
#line 38 "/home/jens/Source/rygel/tests/plugins/media-export/regression.vala"
		_g_error_free0 (e);
#line 223 "regression.c"
	}
	__finally1:
#line 38 "/home/jens/Source/rygel/tests/plugins/media-export/regression.vala"
	if (_inner_error_ != NULL) {
#line 38 "/home/jens/Source/rygel/tests/plugins/media-export/regression.vala"
		_g_object_unref0 (db);
#line 38 "/home/jens/Source/rygel/tests/plugins/media-export/regression.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 38 "/home/jens/Source/rygel/tests/plugins/media-export/regression.vala"
		g_clear_error (&_inner_error_);
#line 38 "/home/jens/Source/rygel/tests/plugins/media-export/regression.vala"
		return;
#line 236 "regression.c"
	}
#line 27 "/home/jens/Source/rygel/tests/plugins/media-export/regression.vala"
	_g_object_unref0 (db);
#line 240 "regression.c"
}


void test_bgo683926_2 (void) {
	GError * _inner_error_ = NULL;
	{
		RygelMediaExportMediaCache* cache = NULL;
		RygelMediaExportMediaCache* _tmp0_ = NULL;
		RygelSimpleContainer* container = NULL;
		RygelSimpleContainer* _tmp1_ = NULL;
		RygelSimpleContainer* _tmp2_ = NULL;
		RygelMediaExportMediaCache* _tmp3_ = NULL;
		RygelSimpleContainer* _tmp4_ = NULL;
		RygelMusicItem* item = NULL;
		RygelSimpleContainer* _tmp5_ = NULL;
		RygelMusicItem* _tmp6_ = NULL;
		RygelMusicItem* _tmp7_ = NULL;
		RygelMediaExportMediaCache* _tmp8_ = NULL;
		RygelMusicItem* _tmp9_ = NULL;
		RygelMusicItem* _tmp10_ = NULL;
		RygelMediaExportMediaCache* _tmp11_ = NULL;
		RygelMusicItem* _tmp12_ = NULL;
		RygelMediaObject* _tmp13_ = NULL;
		RygelMediaExportMediaCache* _tmp14_ = NULL;
		RygelMediaObject* _tmp15_ = NULL;
		RygelMusicItem* _tmp16_ = NULL;
		RygelMusicItem* _tmp17_ = NULL;
		const gchar* _tmp18_ = NULL;
		const gchar* _tmp19_ = NULL;
#line 49 "/home/jens/Source/rygel/tests/plugins/media-export/regression.vala"
		rygel_media_export_media_cache_ensure_exists (&_inner_error_);
#line 49 "/home/jens/Source/rygel/tests/plugins/media-export/regression.vala"
		if (_inner_error_ != NULL) {
#line 274 "regression.c"
			goto __catch2_g_error;
		}
#line 50 "/home/jens/Source/rygel/tests/plugins/media-export/regression.vala"
		_tmp0_ = rygel_media_export_media_cache_get_default ();
#line 50 "/home/jens/Source/rygel/tests/plugins/media-export/regression.vala"
		cache = _tmp0_;
#line 51 "/home/jens/Source/rygel/tests/plugins/media-export/regression.vala"
		_tmp1_ = rygel_simple_container_new_root ("foo");
#line 51 "/home/jens/Source/rygel/tests/plugins/media-export/regression.vala"
		container = _tmp1_;
#line 52 "/home/jens/Source/rygel/tests/plugins/media-export/regression.vala"
		_tmp2_ = container;
#line 52 "/home/jens/Source/rygel/tests/plugins/media-export/regression.vala"
		rygel_media_object_set_id ((RygelMediaObject*) _tmp2_, "foo");
#line 53 "/home/jens/Source/rygel/tests/plugins/media-export/regression.vala"
		_tmp3_ = cache;
#line 53 "/home/jens/Source/rygel/tests/plugins/media-export/regression.vala"
		_tmp4_ = container;
#line 53 "/home/jens/Source/rygel/tests/plugins/media-export/regression.vala"
		rygel_media_export_media_cache_save_container (_tmp3_, (RygelMediaContainer*) _tmp4_, &_inner_error_);
#line 53 "/home/jens/Source/rygel/tests/plugins/media-export/regression.vala"
		if (_inner_error_ != NULL) {
#line 53 "/home/jens/Source/rygel/tests/plugins/media-export/regression.vala"
			_g_object_unref0 (container);
#line 53 "/home/jens/Source/rygel/tests/plugins/media-export/regression.vala"
			_g_object_unref0 (cache);
#line 301 "regression.c"
			goto __catch2_g_error;
		}
#line 55 "/home/jens/Source/rygel/tests/plugins/media-export/regression.vala"
		_tmp5_ = container;
#line 55 "/home/jens/Source/rygel/tests/plugins/media-export/regression.vala"
		_tmp6_ = rygel_music_item_new ("1", (RygelMediaContainer*) _tmp5_, "Static Title", RYGEL_MUSIC_ITEM_UPNP_CLASS);
#line 55 "/home/jens/Source/rygel/tests/plugins/media-export/regression.vala"
		item = _tmp6_;
#line 58 "/home/jens/Source/rygel/tests/plugins/media-export/regression.vala"
		_tmp7_ = item;
#line 58 "/home/jens/Source/rygel/tests/plugins/media-export/regression.vala"
		rygel_media_item_set_mime_type ((RygelMediaItem*) _tmp7_, "audio/mpeg");
#line 59 "/home/jens/Source/rygel/tests/plugins/media-export/regression.vala"
		_tmp8_ = cache;
#line 59 "/home/jens/Source/rygel/tests/plugins/media-export/regression.vala"
		_tmp9_ = item;
#line 59 "/home/jens/Source/rygel/tests/plugins/media-export/regression.vala"
		rygel_media_export_media_cache_save_item (_tmp8_, (RygelMediaItem*) _tmp9_, TRUE, &_inner_error_);
#line 59 "/home/jens/Source/rygel/tests/plugins/media-export/regression.vala"
		if (_inner_error_ != NULL) {
#line 59 "/home/jens/Source/rygel/tests/plugins/media-export/regression.vala"
			_g_object_unref0 (item);
#line 59 "/home/jens/Source/rygel/tests/plugins/media-export/regression.vala"
			_g_object_unref0 (container);
#line 59 "/home/jens/Source/rygel/tests/plugins/media-export/regression.vala"
			_g_object_unref0 (cache);
#line 328 "regression.c"
			goto __catch2_g_error;
		}
#line 60 "/home/jens/Source/rygel/tests/plugins/media-export/regression.vala"
		_tmp10_ = item;
#line 60 "/home/jens/Source/rygel/tests/plugins/media-export/regression.vala"
		rygel_media_object_set_title ((RygelMediaObject*) _tmp10_, "Changed title");
#line 61 "/home/jens/Source/rygel/tests/plugins/media-export/regression.vala"
		_tmp11_ = cache;
#line 61 "/home/jens/Source/rygel/tests/plugins/media-export/regression.vala"
		_tmp12_ = item;
#line 61 "/home/jens/Source/rygel/tests/plugins/media-export/regression.vala"
		rygel_media_export_media_cache_save_item (_tmp11_, (RygelMediaItem*) _tmp12_, FALSE, &_inner_error_);
#line 61 "/home/jens/Source/rygel/tests/plugins/media-export/regression.vala"
		if (_inner_error_ != NULL) {
#line 61 "/home/jens/Source/rygel/tests/plugins/media-export/regression.vala"
			_g_object_unref0 (item);
#line 61 "/home/jens/Source/rygel/tests/plugins/media-export/regression.vala"
			_g_object_unref0 (container);
#line 61 "/home/jens/Source/rygel/tests/plugins/media-export/regression.vala"
			_g_object_unref0 (cache);
#line 349 "regression.c"
			goto __catch2_g_error;
		}
#line 62 "/home/jens/Source/rygel/tests/plugins/media-export/regression.vala"
		_tmp14_ = cache;
#line 62 "/home/jens/Source/rygel/tests/plugins/media-export/regression.vala"
		_tmp15_ = rygel_media_export_media_cache_get_object (_tmp14_, "1", &_inner_error_);
#line 62 "/home/jens/Source/rygel/tests/plugins/media-export/regression.vala"
		_tmp13_ = _tmp15_;
#line 62 "/home/jens/Source/rygel/tests/plugins/media-export/regression.vala"
		if (_inner_error_ != NULL) {
#line 62 "/home/jens/Source/rygel/tests/plugins/media-export/regression.vala"
			_g_object_unref0 (item);
#line 62 "/home/jens/Source/rygel/tests/plugins/media-export/regression.vala"
			_g_object_unref0 (container);
#line 62 "/home/jens/Source/rygel/tests/plugins/media-export/regression.vala"
			_g_object_unref0 (cache);
#line 366 "regression.c"
			goto __catch2_g_error;
		}
#line 62 "/home/jens/Source/rygel/tests/plugins/media-export/regression.vala"
		_tmp16_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp13_, RYGEL_TYPE_MUSIC_ITEM) ? ((RygelMusicItem*) _tmp13_) : NULL;
#line 62 "/home/jens/Source/rygel/tests/plugins/media-export/regression.vala"
		if (_tmp16_ == NULL) {
#line 62 "/home/jens/Source/rygel/tests/plugins/media-export/regression.vala"
			_g_object_unref0 (_tmp13_);
#line 375 "regression.c"
		}
#line 62 "/home/jens/Source/rygel/tests/plugins/media-export/regression.vala"
		_g_object_unref0 (item);
#line 62 "/home/jens/Source/rygel/tests/plugins/media-export/regression.vala"
		item = _tmp16_;
#line 63 "/home/jens/Source/rygel/tests/plugins/media-export/regression.vala"
		_tmp17_ = item;
#line 63 "/home/jens/Source/rygel/tests/plugins/media-export/regression.vala"
		_tmp18_ = rygel_media_object_get_title ((RygelMediaObject*) _tmp17_);
#line 63 "/home/jens/Source/rygel/tests/plugins/media-export/regression.vala"
		_tmp19_ = _tmp18_;
#line 63 "/home/jens/Source/rygel/tests/plugins/media-export/regression.vala"
		_vala_assert (g_strcmp0 (_tmp19_, "Static Title") == 0, "item.title == \"Static Title\"");
#line 48 "/home/jens/Source/rygel/tests/plugins/media-export/regression.vala"
		_g_object_unref0 (item);
#line 48 "/home/jens/Source/rygel/tests/plugins/media-export/regression.vala"
		_g_object_unref0 (container);
#line 48 "/home/jens/Source/rygel/tests/plugins/media-export/regression.vala"
		_g_object_unref0 (cache);
#line 395 "regression.c"
	}
	goto __finally2;
	__catch2_g_error:
	{
		GError* _error_ = NULL;
#line 48 "/home/jens/Source/rygel/tests/plugins/media-export/regression.vala"
		_error_ = _inner_error_;
#line 48 "/home/jens/Source/rygel/tests/plugins/media-export/regression.vala"
		_inner_error_ = NULL;
#line 65 "/home/jens/Source/rygel/tests/plugins/media-export/regression.vala"
		g_assert_not_reached ();
#line 48 "/home/jens/Source/rygel/tests/plugins/media-export/regression.vala"
		_g_error_free0 (_error_);
#line 409 "regression.c"
	}
	__finally2:
#line 48 "/home/jens/Source/rygel/tests/plugins/media-export/regression.vala"
	if (_inner_error_ != NULL) {
#line 48 "/home/jens/Source/rygel/tests/plugins/media-export/regression.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 48 "/home/jens/Source/rygel/tests/plugins/media-export/regression.vala"
		g_clear_error (&_inner_error_);
#line 48 "/home/jens/Source/rygel/tests/plugins/media-export/regression.vala"
		return;
#line 420 "regression.c"
	}
}


/**
 * Dummy function to silence the vala warnings
 */
void test_silence_vala (void) {
	GError * _inner_error_ = NULL;
	{
		GValue _tmp0_ = {0};
		GValue _tmp1_ = {0};
		RygelMediaExportDatabase* db = NULL;
		RygelMediaExportDatabase* _tmp2_ = NULL;
		RygelMediaExportDatabase* _tmp3_ = NULL;
		RygelMediaExportDatabase* _tmp4_ = NULL;
		RygelMediaExportDatabase* _tmp5_ = NULL;
		RygelMediaExportDatabase* _tmp6_ = NULL;
		RygelMediaExportDatabase* _tmp7_ = NULL;
		RygelMediaExportDatabaseCursor* _tmp8_ = NULL;
		RygelMediaExportDatabase* _tmp9_ = NULL;
		RygelMediaExportDatabaseCursor* _tmp10_ = NULL;
#line 75 "/home/jens/Source/rygel/tests/plugins/media-export/regression.vala"
		rygel_media_export_database_null (&_tmp0_);
#line 75 "/home/jens/Source/rygel/tests/plugins/media-export/regression.vala"
		_tmp1_ = _tmp0_;
#line 75 "/home/jens/Source/rygel/tests/plugins/media-export/regression.vala"
		G_IS_VALUE (&_tmp1_) ? (g_value_unset (&_tmp1_), NULL) : NULL;
#line 76 "/home/jens/Source/rygel/tests/plugins/media-export/regression.vala"
		_tmp2_ = rygel_media_export_database_new (":memory:", &_inner_error_);
#line 76 "/home/jens/Source/rygel/tests/plugins/media-export/regression.vala"
		db = _tmp2_;
#line 76 "/home/jens/Source/rygel/tests/plugins/media-export/regression.vala"
		if (_inner_error_ != NULL) {
#line 455 "regression.c"
			goto __catch3_g_error;
		}
#line 77 "/home/jens/Source/rygel/tests/plugins/media-export/regression.vala"
		_tmp3_ = db;
#line 77 "/home/jens/Source/rygel/tests/plugins/media-export/regression.vala"
		rygel_media_export_database_analyze (_tmp3_);
#line 78 "/home/jens/Source/rygel/tests/plugins/media-export/regression.vala"
		_tmp4_ = db;
#line 78 "/home/jens/Source/rygel/tests/plugins/media-export/regression.vala"
		rygel_media_export_database_begin (_tmp4_, &_inner_error_);
#line 78 "/home/jens/Source/rygel/tests/plugins/media-export/regression.vala"
		if (_inner_error_ != NULL) {
#line 78 "/home/jens/Source/rygel/tests/plugins/media-export/regression.vala"
			_g_object_unref0 (db);
#line 470 "regression.c"
			goto __catch3_g_error;
		}
#line 79 "/home/jens/Source/rygel/tests/plugins/media-export/regression.vala"
		_tmp5_ = db;
#line 79 "/home/jens/Source/rygel/tests/plugins/media-export/regression.vala"
		rygel_media_export_database_commit (_tmp5_, &_inner_error_);
#line 79 "/home/jens/Source/rygel/tests/plugins/media-export/regression.vala"
		if (_inner_error_ != NULL) {
#line 79 "/home/jens/Source/rygel/tests/plugins/media-export/regression.vala"
			_g_object_unref0 (db);
#line 481 "regression.c"
			goto __catch3_g_error;
		}
#line 80 "/home/jens/Source/rygel/tests/plugins/media-export/regression.vala"
		_tmp6_ = db;
#line 80 "/home/jens/Source/rygel/tests/plugins/media-export/regression.vala"
		rygel_media_export_database_rollback (_tmp6_);
#line 81 "/home/jens/Source/rygel/tests/plugins/media-export/regression.vala"
		_tmp7_ = db;
#line 81 "/home/jens/Source/rygel/tests/plugins/media-export/regression.vala"
		rygel_media_export_database_query_value (_tmp7_, "SELECT 1;", NULL, 0, &_inner_error_);
#line 81 "/home/jens/Source/rygel/tests/plugins/media-export/regression.vala"
		if (_inner_error_ != NULL) {
#line 81 "/home/jens/Source/rygel/tests/plugins/media-export/regression.vala"
			_g_object_unref0 (db);
#line 496 "regression.c"
			goto __catch3_g_error;
		}
#line 82 "/home/jens/Source/rygel/tests/plugins/media-export/regression.vala"
		_tmp9_ = db;
#line 82 "/home/jens/Source/rygel/tests/plugins/media-export/regression.vala"
		_tmp10_ = rygel_media_export_database_exec_cursor (_tmp9_, "SELECT 1;", NULL, 0, &_inner_error_);
#line 82 "/home/jens/Source/rygel/tests/plugins/media-export/regression.vala"
		_tmp8_ = _tmp10_;
#line 82 "/home/jens/Source/rygel/tests/plugins/media-export/regression.vala"
		if (_inner_error_ != NULL) {
#line 82 "/home/jens/Source/rygel/tests/plugins/media-export/regression.vala"
			_g_object_unref0 (db);
#line 509 "regression.c"
			goto __catch3_g_error;
		}
		{
			RygelMediaExportDatabaseCursorIterator* _c_it = NULL;
			RygelMediaExportDatabaseCursor* _tmp11_ = NULL;
			RygelMediaExportDatabaseCursorIterator* _tmp12_ = NULL;
			RygelMediaExportDatabaseCursorIterator* _tmp13_ = NULL;
#line 82 "/home/jens/Source/rygel/tests/plugins/media-export/regression.vala"
			_tmp11_ = _tmp8_;
#line 82 "/home/jens/Source/rygel/tests/plugins/media-export/regression.vala"
			_tmp12_ = rygel_media_export_database_cursor_iterator (_tmp11_);
#line 82 "/home/jens/Source/rygel/tests/plugins/media-export/regression.vala"
			_tmp13_ = _tmp12_;
#line 82 "/home/jens/Source/rygel/tests/plugins/media-export/regression.vala"
			_g_object_unref0 (_tmp11_);
#line 82 "/home/jens/Source/rygel/tests/plugins/media-export/regression.vala"
			_c_it = _tmp13_;
#line 82 "/home/jens/Source/rygel/tests/plugins/media-export/regression.vala"
			while (TRUE) {
#line 529 "regression.c"
				gboolean _tmp14_ = FALSE;
				RygelMediaExportDatabaseCursorIterator* _tmp15_ = NULL;
				gboolean _tmp16_ = FALSE;
				sqlite3_stmt* c = NULL;
				RygelMediaExportDatabaseCursorIterator* _tmp17_ = NULL;
				sqlite3_stmt* _tmp18_ = NULL;
				sqlite3_stmt* _tmp19_ = NULL;
#line 82 "/home/jens/Source/rygel/tests/plugins/media-export/regression.vala"
				_tmp15_ = _c_it;
#line 82 "/home/jens/Source/rygel/tests/plugins/media-export/regression.vala"
				_tmp16_ = rygel_media_export_database_cursor_iterator_next (_tmp15_, &_inner_error_);
#line 82 "/home/jens/Source/rygel/tests/plugins/media-export/regression.vala"
				_tmp14_ = _tmp16_;
#line 82 "/home/jens/Source/rygel/tests/plugins/media-export/regression.vala"
				if (_inner_error_ != NULL) {
#line 82 "/home/jens/Source/rygel/tests/plugins/media-export/regression.vala"
					_rygel_media_export_database_cursor_iterator_unref0 (_c_it);
#line 82 "/home/jens/Source/rygel/tests/plugins/media-export/regression.vala"
					_g_object_unref0 (db);
#line 549 "regression.c"
					goto __catch3_g_error;
				}
#line 82 "/home/jens/Source/rygel/tests/plugins/media-export/regression.vala"
				if (!_tmp14_) {
#line 82 "/home/jens/Source/rygel/tests/plugins/media-export/regression.vala"
					break;
#line 556 "regression.c"
				}
#line 82 "/home/jens/Source/rygel/tests/plugins/media-export/regression.vala"
				_tmp17_ = _c_it;
#line 82 "/home/jens/Source/rygel/tests/plugins/media-export/regression.vala"
				_tmp18_ = rygel_media_export_database_cursor_iterator_get (_tmp17_, &_inner_error_);
#line 82 "/home/jens/Source/rygel/tests/plugins/media-export/regression.vala"
				c = _tmp18_;
#line 82 "/home/jens/Source/rygel/tests/plugins/media-export/regression.vala"
				if (_inner_error_ != NULL) {
#line 82 "/home/jens/Source/rygel/tests/plugins/media-export/regression.vala"
					_rygel_media_export_database_cursor_iterator_unref0 (_c_it);
#line 82 "/home/jens/Source/rygel/tests/plugins/media-export/regression.vala"
					_g_object_unref0 (db);
#line 570 "regression.c"
					goto __catch3_g_error;
				}
#line 83 "/home/jens/Source/rygel/tests/plugins/media-export/regression.vala"
				_tmp19_ = c;
#line 83 "/home/jens/Source/rygel/tests/plugins/media-export/regression.vala"
				sqlite3_data_count (_tmp19_);
#line 577 "regression.c"
			}
#line 82 "/home/jens/Source/rygel/tests/plugins/media-export/regression.vala"
			_rygel_media_export_database_cursor_iterator_unref0 (_c_it);
#line 581 "regression.c"
		}
#line 74 "/home/jens/Source/rygel/tests/plugins/media-export/regression.vala"
		_g_object_unref0 (db);
#line 585 "regression.c"
	}
	goto __finally3;
	__catch3_g_error:
	{
		GError* _error_ = NULL;
#line 74 "/home/jens/Source/rygel/tests/plugins/media-export/regression.vala"
		_error_ = _inner_error_;
#line 74 "/home/jens/Source/rygel/tests/plugins/media-export/regression.vala"
		_inner_error_ = NULL;
#line 74 "/home/jens/Source/rygel/tests/plugins/media-export/regression.vala"
		_g_error_free0 (_error_);
#line 597 "regression.c"
	}
	__finally3:
#line 74 "/home/jens/Source/rygel/tests/plugins/media-export/regression.vala"
	if (_inner_error_ != NULL) {
#line 74 "/home/jens/Source/rygel/tests/plugins/media-export/regression.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 74 "/home/jens/Source/rygel/tests/plugins/media-export/regression.vala"
		g_clear_error (&_inner_error_);
#line 74 "/home/jens/Source/rygel/tests/plugins/media-export/regression.vala"
		return;
#line 608 "regression.c"
	}
}


static gboolean test_config_real_get_bool (RygelBaseConfiguration* base, const gchar* section, const gchar* key, GError** error) {
	TestConfig * self;
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_ = NULL;
	gboolean _tmp3_ = FALSE;
	GError* _tmp4_ = NULL;
	GError * _inner_error_ = NULL;
#line 89 "/home/jens/Source/rygel/tests/plugins/media-export/regression.vala"
	self = (TestConfig*) base;
#line 89 "/home/jens/Source/rygel/tests/plugins/media-export/regression.vala"
	g_return_val_if_fail (section != NULL, FALSE);
#line 89 "/home/jens/Source/rygel/tests/plugins/media-export/regression.vala"
	g_return_val_if_fail (key != NULL, FALSE);
#line 90 "/home/jens/Source/rygel/tests/plugins/media-export/regression.vala"
	_tmp1_ = section;
#line 90 "/home/jens/Source/rygel/tests/plugins/media-export/regression.vala"
	if (g_strcmp0 (_tmp1_, "MediaExport") == 0) {
#line 631 "regression.c"
		const gchar* _tmp2_ = NULL;
#line 90 "/home/jens/Source/rygel/tests/plugins/media-export/regression.vala"
		_tmp2_ = key;
#line 90 "/home/jens/Source/rygel/tests/plugins/media-export/regression.vala"
		_tmp0_ = g_strcmp0 (_tmp2_, "use-temp-db") == 0;
#line 637 "regression.c"
	} else {
#line 90 "/home/jens/Source/rygel/tests/plugins/media-export/regression.vala"
		_tmp0_ = FALSE;
#line 641 "regression.c"
	}
#line 90 "/home/jens/Source/rygel/tests/plugins/media-export/regression.vala"
	_tmp3_ = _tmp0_;
#line 90 "/home/jens/Source/rygel/tests/plugins/media-export/regression.vala"
	if (_tmp3_) {
#line 91 "/home/jens/Source/rygel/tests/plugins/media-export/regression.vala"
		result = TRUE;
#line 91 "/home/jens/Source/rygel/tests/plugins/media-export/regression.vala"
		return result;
#line 651 "regression.c"
	}
#line 94 "/home/jens/Source/rygel/tests/plugins/media-export/regression.vala"
	_tmp4_ = g_error_new_literal (RYGEL_CONFIGURATION_ERROR, RYGEL_CONFIGURATION_ERROR_NO_VALUE_SET, "No value available");
#line 94 "/home/jens/Source/rygel/tests/plugins/media-export/regression.vala"
	_inner_error_ = _tmp4_;
#line 94 "/home/jens/Source/rygel/tests/plugins/media-export/regression.vala"
	g_propagate_error (error, _inner_error_);
#line 94 "/home/jens/Source/rygel/tests/plugins/media-export/regression.vala"
	return FALSE;
#line 661 "regression.c"
}


TestConfig* test_config_construct (GType object_type) {
	TestConfig * self = NULL;
#line 88 "/home/jens/Source/rygel/tests/plugins/media-export/regression.vala"
	self = (TestConfig*) rygel_base_configuration_construct (object_type);
#line 88 "/home/jens/Source/rygel/tests/plugins/media-export/regression.vala"
	return self;
#line 671 "regression.c"
}


TestConfig* test_config_new (void) {
#line 88 "/home/jens/Source/rygel/tests/plugins/media-export/regression.vala"
	return test_config_construct (TYPE_TEST_CONFIG);
#line 678 "regression.c"
}


static void test_config_class_init (TestConfigClass * klass) {
#line 88 "/home/jens/Source/rygel/tests/plugins/media-export/regression.vala"
	test_config_parent_class = g_type_class_peek_parent (klass);
#line 88 "/home/jens/Source/rygel/tests/plugins/media-export/regression.vala"
	RYGEL_BASE_CONFIGURATION_CLASS (klass)->get_bool = test_config_real_get_bool;
#line 687 "regression.c"
}


static void test_config_instance_init (TestConfig * self) {
}


GType test_config_get_type (void) {
	static volatile gsize test_config_type_id__volatile = 0;
	if (g_once_init_enter (&test_config_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (TestConfigClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) test_config_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TestConfig), 0, (GInstanceInitFunc) test_config_instance_init, NULL };
		GType test_config_type_id;
		test_config_type_id = g_type_register_static (RYGEL_TYPE_BASE_CONFIGURATION, "TestConfig", &g_define_type_info, 0);
		g_once_init_leave (&test_config_type_id__volatile, test_config_type_id);
	}
	return test_config_type_id__volatile;
}


static void _test_bgo683926_1_gtest_func (void) {
#line 107 "/home/jens/Source/rygel/tests/plugins/media-export/regression.vala"
	test_bgo683926_1 ();
#line 710 "regression.c"
}


static void _test_bgo683926_2_gtest_func (void) {
#line 109 "/home/jens/Source/rygel/tests/plugins/media-export/regression.vala"
	test_bgo683926_2 ();
#line 717 "regression.c"
}


gint _vala_main (gchar** args, int args_length1) {
	gint result = 0;
	TestConfig* _tmp0_ = NULL;
	TestConfig* _tmp1_ = NULL;
	gint _tmp2_ = 0;
#line 99 "/home/jens/Source/rygel/tests/plugins/media-export/regression.vala"
	g_test_init (&args_length1, &args, NULL);
#line 101 "/home/jens/Source/rygel/tests/plugins/media-export/regression.vala"
	if (FALSE != FALSE) {
#line 102 "/home/jens/Source/rygel/tests/plugins/media-export/regression.vala"
		test_silence_vala ();
#line 732 "regression.c"
	}
#line 105 "/home/jens/Source/rygel/tests/plugins/media-export/regression.vala"
	_tmp0_ = test_config_new ();
#line 105 "/home/jens/Source/rygel/tests/plugins/media-export/regression.vala"
	_tmp1_ = _tmp0_;
#line 105 "/home/jens/Source/rygel/tests/plugins/media-export/regression.vala"
	rygel_meta_config_register_configuration ((RygelConfiguration*) _tmp1_);
#line 105 "/home/jens/Source/rygel/tests/plugins/media-export/regression.vala"
	_g_object_unref0 (_tmp1_);
#line 107 "/home/jens/Source/rygel/tests/plugins/media-export/regression.vala"
	g_test_add_func ("/plugins/media-export/regression/bgo689326_1", _test_bgo683926_1_gtest_func);
#line 109 "/home/jens/Source/rygel/tests/plugins/media-export/regression.vala"
	g_test_add_func ("/plugins/media-export/regression/bgo689326_2", _test_bgo683926_2_gtest_func);
#line 111 "/home/jens/Source/rygel/tests/plugins/media-export/regression.vala"
	_tmp2_ = g_test_run ();
#line 111 "/home/jens/Source/rygel/tests/plugins/media-export/regression.vala"
	result = _tmp2_;
#line 111 "/home/jens/Source/rygel/tests/plugins/media-export/regression.vala"
	return result;
#line 752 "regression.c"
}


int main (int argc, char ** argv) {
#line 98 "/home/jens/Source/rygel/tests/plugins/media-export/regression.vala"
	g_type_init ();
#line 98 "/home/jens/Source/rygel/tests/plugins/media-export/regression.vala"
	return _vala_main (argv, argc);
#line 761 "regression.c"
}



