/* rygel-description-file.c generated by valac 0.22.0.18-aa6c, the Vala compiler
 * generated from rygel-description-file.vala, do not modify */

/*
 * Copyright (C) 2011 Jens Georg
 *
 * Author: Jens Georg <mail@jensge.org>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <libgupnp/gupnp.h>
#include <libxml/tree.h>
#include <gee.h>
#include <libxml/xpath.h>
#include <libxml/parser.h>
#include <stdio.h>
#include <glib/gstdio.h>
#include <glib/gi18n-lib.h>
#include <gio/gio.h>


#define RYGEL_TYPE_DESCRIPTION_FILE (rygel_description_file_get_type ())
#define RYGEL_DESCRIPTION_FILE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_DESCRIPTION_FILE, RygelDescriptionFile))
#define RYGEL_DESCRIPTION_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_DESCRIPTION_FILE, RygelDescriptionFileClass))
#define RYGEL_IS_DESCRIPTION_FILE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_DESCRIPTION_FILE))
#define RYGEL_IS_DESCRIPTION_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_DESCRIPTION_FILE))
#define RYGEL_DESCRIPTION_FILE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_DESCRIPTION_FILE, RygelDescriptionFileClass))

typedef struct _RygelDescriptionFile RygelDescriptionFile;
typedef struct _RygelDescriptionFileClass RygelDescriptionFileClass;
typedef struct _RygelDescriptionFilePrivate RygelDescriptionFilePrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define RYGEL_TYPE_PLUGIN_CAPABILITIES (rygel_plugin_capabilities_get_type ())

#define RYGEL_TYPE_META_CONFIG (rygel_meta_config_get_type ())
#define RYGEL_META_CONFIG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_META_CONFIG, RygelMetaConfig))
#define RYGEL_META_CONFIG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_META_CONFIG, RygelMetaConfigClass))
#define RYGEL_IS_META_CONFIG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_META_CONFIG))
#define RYGEL_IS_META_CONFIG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_META_CONFIG))
#define RYGEL_META_CONFIG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_META_CONFIG, RygelMetaConfigClass))

typedef struct _RygelMetaConfig RygelMetaConfig;
typedef struct _RygelMetaConfigClass RygelMetaConfigClass;

#define RYGEL_TYPE_CONFIGURATION (rygel_configuration_get_type ())
#define RYGEL_CONFIGURATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_CONFIGURATION, RygelConfiguration))
#define RYGEL_IS_CONFIGURATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_CONFIGURATION))
#define RYGEL_CONFIGURATION_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_CONFIGURATION, RygelConfigurationIface))

typedef struct _RygelConfiguration RygelConfiguration;
typedef struct _RygelConfigurationIface RygelConfigurationIface;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define RYGEL_TYPE_RESOURCE_INFO (rygel_resource_info_get_type ())
#define RYGEL_RESOURCE_INFO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_RESOURCE_INFO, RygelResourceInfo))
#define RYGEL_RESOURCE_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_RESOURCE_INFO, RygelResourceInfoClass))
#define RYGEL_IS_RESOURCE_INFO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_RESOURCE_INFO))
#define RYGEL_IS_RESOURCE_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_RESOURCE_INFO))
#define RYGEL_RESOURCE_INFO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_RESOURCE_INFO, RygelResourceInfoClass))

typedef struct _RygelResourceInfo RygelResourceInfo;
typedef struct _RygelResourceInfoClass RygelResourceInfoClass;
typedef struct _RygelResourceInfoPrivate RygelResourceInfoPrivate;

#define RYGEL_TYPE_ICON_INFO (rygel_icon_info_get_type ())
#define RYGEL_ICON_INFO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_ICON_INFO, RygelIconInfo))
#define RYGEL_ICON_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_ICON_INFO, RygelIconInfoClass))
#define RYGEL_IS_ICON_INFO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_ICON_INFO))
#define RYGEL_IS_ICON_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_ICON_INFO))
#define RYGEL_ICON_INFO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_ICON_INFO, RygelIconInfoClass))

typedef struct _RygelIconInfo RygelIconInfo;
typedef struct _RygelIconInfoClass RygelIconInfoClass;
typedef struct _RygelIconInfoPrivate RygelIconInfoPrivate;
#define _xmlXPathFreeContext0(var) ((var == NULL) ? NULL : (var = (xmlXPathFreeContext (var), NULL)))
#define _fclose0(var) ((var == NULL) ? NULL : (var = (fclose (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _RygelDescriptionFile {
	GObject parent_instance;
	RygelDescriptionFilePrivate * priv;
};

struct _RygelDescriptionFileClass {
	GObjectClass parent_class;
};

struct _RygelDescriptionFilePrivate {
	gchar** device_elements;
	gint device_elements_length1;
	gint _device_elements_size_;
	GUPnPXMLDoc* doc;
};

typedef enum  {
	RYGEL_PLUGIN_CAPABILITIES_NONE = 0,
	RYGEL_PLUGIN_CAPABILITIES_IMAGE_UPLOAD = 1 << 0,
	RYGEL_PLUGIN_CAPABILITIES_VIDEO_UPLOAD = 1 << 1,
	RYGEL_PLUGIN_CAPABILITIES_AUDIO_UPLOAD = 1 << 2,
	RYGEL_PLUGIN_CAPABILITIES_UPLOAD = (RYGEL_PLUGIN_CAPABILITIES_IMAGE_UPLOAD | RYGEL_PLUGIN_CAPABILITIES_VIDEO_UPLOAD) | RYGEL_PLUGIN_CAPABILITIES_AUDIO_UPLOAD,
	RYGEL_PLUGIN_CAPABILITIES_TRACK_CHANGES = 1 << 3,
	RYGEL_PLUGIN_CAPABILITIES_CREATE_CONTAINERS = 1 << 4
} RygelPluginCapabilities;

struct _RygelConfigurationIface {
	GTypeInterface parent_iface;
	gboolean (*get_upnp_enabled) (RygelConfiguration* self, GError** error);
	gchar* (*get_interface) (RygelConfiguration* self, GError** error);
	gchar** (*get_interfaces) (RygelConfiguration* self, GError** error);
	gint (*get_port) (RygelConfiguration* self, GError** error);
	gboolean (*get_transcoding) (RygelConfiguration* self, GError** error);
	gboolean (*get_allow_upload) (RygelConfiguration* self, GError** error);
	gboolean (*get_allow_deletion) (RygelConfiguration* self, GError** error);
	gchar* (*get_log_levels) (RygelConfiguration* self, GError** error);
	gchar* (*get_plugin_path) (RygelConfiguration* self, GError** error);
	gchar* (*get_engine_path) (RygelConfiguration* self, GError** error);
	gchar* (*get_media_engine) (RygelConfiguration* self, GError** error);
	gchar* (*get_video_upload_folder) (RygelConfiguration* self, GError** error);
	gchar* (*get_music_upload_folder) (RygelConfiguration* self, GError** error);
	gchar* (*get_picture_upload_folder) (RygelConfiguration* self, GError** error);
	gboolean (*get_enabled) (RygelConfiguration* self, const gchar* section, GError** error);
	gchar* (*get_title) (RygelConfiguration* self, const gchar* section, GError** error);
	gchar* (*get_string) (RygelConfiguration* self, const gchar* section, const gchar* key, GError** error);
	GeeArrayList* (*get_string_list) (RygelConfiguration* self, const gchar* section, const gchar* key, GError** error);
	gint (*get_int) (RygelConfiguration* self, const gchar* section, const gchar* key, gint min, gint max, GError** error);
	GeeArrayList* (*get_int_list) (RygelConfiguration* self, const gchar* section, const gchar* key, GError** error);
	gboolean (*get_bool) (RygelConfiguration* self, const gchar* section, const gchar* key, GError** error);
};

struct _RygelResourceInfo {
	GTypeInstance parent_instance;
	volatile int ref_count;
	RygelResourceInfoPrivate * priv;
	gchar* upnp_type;
	gchar* upnp_id;
	gchar* description_path;
	GType type;
};

struct _RygelResourceInfoClass {
	GTypeClass parent_class;
	void (*finalize) (RygelResourceInfo *self);
};

struct _RygelIconInfo {
	GTypeInstance parent_instance;
	volatile int ref_count;
	RygelIconInfoPrivate * priv;
	gchar* mime_type;
	gchar* uri;
	gchar* file_extension;
	gint64 size;
	gint width;
	gint height;
	gint depth;
};

struct _RygelIconInfoClass {
	GTypeClass parent_class;
	void (*finalize) (RygelIconInfo *self);
};


static gpointer rygel_description_file_parent_class = NULL;

GType rygel_description_file_get_type (void) G_GNUC_CONST;
#define RYGEL_DESCRIPTION_FILE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_DESCRIPTION_FILE, RygelDescriptionFilePrivate))
enum  {
	RYGEL_DESCRIPTION_FILE_DUMMY_PROPERTY
};
#define RYGEL_DESCRIPTION_FILE_SERVICE_TYPE_TEMPLATE "//*[.='%s']"
RygelDescriptionFile* rygel_description_file_new (const gchar* template_file, GError** error);
RygelDescriptionFile* rygel_description_file_construct (GType object_type, const gchar* template_file, GError** error);
RygelDescriptionFile* rygel_description_file_new_from_xml_document (GUPnPXMLDoc* doc);
RygelDescriptionFile* rygel_description_file_construct_from_xml_document (GType object_type, GUPnPXMLDoc* doc);
void rygel_description_file_set_device_type (RygelDescriptionFile* self, const gchar* device_type);
static xmlNode* rygel_description_file_set_device_element (RygelDescriptionFile* self, const gchar* element, const gchar* new_value, const gchar* ns);
void rygel_description_file_set_model_description (RygelDescriptionFile* self, const gchar* model_description);
void rygel_description_file_set_model_name (RygelDescriptionFile* self, const gchar* model_name);
void rygel_description_file_set_model_number (RygelDescriptionFile* self, const gchar* model_number);
void rygel_description_file_set_friendly_name (RygelDescriptionFile* self, const gchar* friendly_name);
gchar* rygel_description_file_get_friendly_name (RygelDescriptionFile* self);
xmlNode* rygel_xml_utils_get_element (xmlNode* node, ...);
void rygel_description_file_set_udn (RygelDescriptionFile* self, const gchar* udn);
gchar* rygel_description_file_get_udn (RygelDescriptionFile* self);
GType rygel_plugin_capabilities_get_type (void) G_GNUC_CONST;
void rygel_description_file_set_dlna_caps (RygelDescriptionFile* self, RygelPluginCapabilities capabilities);
GType rygel_meta_config_get_type (void) G_GNUC_CONST;
RygelMetaConfig* rygel_meta_config_get_default (void);
GType rygel_configuration_get_type (void) G_GNUC_CONST;
gboolean rygel_configuration_get_allow_upload (RygelConfiguration* self, GError** error);
gboolean rygel_configuration_get_allow_deletion (RygelConfiguration* self, GError** error);
static void _vala_array_add1 (gchar*** array, int* length, int* size, gchar* value);
static void _vala_array_add2 (gchar*** array, int* length, int* size, gchar* value);
static void _vala_array_add3 (gchar*** array, int* length, int* size, gchar* value);
static void _vala_array_add4 (gchar*** array, int* length, int* size, gchar* value);
static void _vala_array_add5 (gchar*** array, int* length, int* size, gchar* value);
static void _vala_array_add6 (gchar*** array, int* length, int* size, gchar* value);
static void _vala_array_add7 (gchar*** array, int* length, int* size, gchar* value);
static void rygel_description_file_remove_device_element (RygelDescriptionFile* self, const gchar* element);
void rygel_description_file_clear_service_list (RygelDescriptionFile* self);
gpointer rygel_resource_info_ref (gpointer instance);
void rygel_resource_info_unref (gpointer instance);
GParamSpec* rygel_param_spec_resource_info (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_value_set_resource_info (GValue* value, gpointer v_object);
void rygel_value_take_resource_info (GValue* value, gpointer v_object);
gpointer rygel_value_get_resource_info (const GValue* value);
GType rygel_resource_info_get_type (void) G_GNUC_CONST;
void rygel_description_file_add_service (RygelDescriptionFile* self, const gchar* device_name, RygelResourceInfo* resource_info);
void rygel_description_file_clear_icon_list (RygelDescriptionFile* self);
gpointer rygel_icon_info_ref (gpointer instance);
void rygel_icon_info_unref (gpointer instance);
GParamSpec* rygel_param_spec_icon_info (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_value_set_icon_info (GValue* value, gpointer v_object);
void rygel_value_take_icon_info (GValue* value, gpointer v_object);
gpointer rygel_value_get_icon_info (const GValue* value);
GType rygel_icon_info_get_type (void) G_GNUC_CONST;
void rygel_description_file_add_icon (RygelDescriptionFile* self, const gchar* device_name, RygelIconInfo* icon_info, const gchar* url);
void rygel_description_file_modify_service_type (RygelDescriptionFile* self, const gchar* old_type, const gchar* new_type);
void rygel_description_file_save (RygelDescriptionFile* self, const gchar* path, GError** error);
static gint rygel_description_file_index_of_device_element (RygelDescriptionFile* self, const gchar* element);
static void rygel_description_file_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


/**
     * Constructor to load a description file from disk
     *
     * @param template_file the path to the description file.
     * @throws GUPnP.XMLError.PARSE if there was an error reading or parsing
     * the file.
     */
RygelDescriptionFile* rygel_description_file_construct (GType object_type, const gchar* template_file, GError** error) {
	RygelDescriptionFile * self = NULL;
	GUPnPXMLDoc* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	GUPnPXMLDoc* _tmp2_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (template_file != NULL, NULL);
	self = (RygelDescriptionFile*) g_object_new (object_type, NULL);
	_tmp1_ = template_file;
	_tmp2_ = gupnp_xml_doc_new_from_path (_tmp1_, &_inner_error_);
	_tmp0_ = _tmp2_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (self);
		return NULL;
	}
	_g_object_unref0 (self->priv->doc);
	self->priv->doc = _tmp0_;
	return self;
}


RygelDescriptionFile* rygel_description_file_new (const gchar* template_file, GError** error) {
	return rygel_description_file_construct (RYGEL_TYPE_DESCRIPTION_FILE, template_file, error);
}


/**
     * Constructor which wraps an existing GUPnP.XMLDoc as a description file.
     *
     * @param doc is the GUPnP.XMLDoc to wrap.
     */
static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


RygelDescriptionFile* rygel_description_file_construct_from_xml_document (GType object_type, GUPnPXMLDoc* doc) {
	RygelDescriptionFile * self = NULL;
	GUPnPXMLDoc* _tmp0_ = NULL;
	GUPnPXMLDoc* _tmp1_ = NULL;
	g_return_val_if_fail (doc != NULL, NULL);
	self = (RygelDescriptionFile*) g_object_new (object_type, NULL);
	_tmp0_ = doc;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->doc);
	self->priv->doc = _tmp1_;
	return self;
}


RygelDescriptionFile* rygel_description_file_new_from_xml_document (GUPnPXMLDoc* doc) {
	return rygel_description_file_construct_from_xml_document (RYGEL_TYPE_DESCRIPTION_FILE, doc);
}


/**
     * Change the type of a service.
     *
     * Usually used to modify the device version, e.g. default device type is
     * "MediaServer:2" and device_type = "MediaServer:1".
     *
     * @param device_type is the current content of serviceType.
     */
void rygel_description_file_set_device_type (RygelDescriptionFile* self, const gchar* device_type) {
	const gchar* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (device_type != NULL);
	_tmp0_ = device_type;
	rygel_description_file_set_device_element (self, "deviceType", _tmp0_, NULL);
}


/**
     * Modify the model description.
     *
     * A longer user friendly description of the device.
     *
     * @param model_description is the new model description.
     */
void rygel_description_file_set_model_description (RygelDescriptionFile* self, const gchar* model_description) {
	const gchar* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (model_description != NULL);
	_tmp0_ = model_description;
	rygel_description_file_set_device_element (self, "modelDescription", _tmp0_, NULL);
}


/**
     * Modify the model name.
     *
     * Usually the name of the software implementing this device.
     *
     * @param model_name is the new model name.
     */
void rygel_description_file_set_model_name (RygelDescriptionFile* self, const gchar* model_name) {
	const gchar* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (model_name != NULL);
	_tmp0_ = model_name;
	rygel_description_file_set_device_element (self, "modelName", _tmp0_, NULL);
}


/**
     * Modify the model number.
     *
     * Usually the version of the software implementing this device.
     *
     * @param model_number is the new model number.
     */
void rygel_description_file_set_model_number (RygelDescriptionFile* self, const gchar* model_number) {
	const gchar* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (model_number != NULL);
	_tmp0_ = model_number;
	rygel_description_file_set_device_element (self, "modelNumber", _tmp0_, NULL);
}


/**
     * Set the friendly name of the device.
     *
     * The friendly name is the one usually presented to the user in control
     * points or DMPs
     *
     * @param friendly_name is the new friendly name of the device.
     */
void rygel_description_file_set_friendly_name (RygelDescriptionFile* self, const gchar* friendly_name) {
	const gchar* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (friendly_name != NULL);
	_tmp0_ = friendly_name;
	rygel_description_file_set_device_element (self, "friendlyName", _tmp0_, NULL);
}


/**
     * Get the current friendly name of the device.
     *
     * @return The currenly set friendly name.
     */
gchar* rygel_description_file_get_friendly_name (RygelDescriptionFile* self) {
	gchar* result = NULL;
	xmlNode* element = NULL;
	GUPnPXMLDoc* _tmp0_ = NULL;
	xmlDoc* _tmp1_ = NULL;
	xmlNode* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->doc;
	_tmp1_ = _tmp0_->doc;
	_tmp2_ = rygel_xml_utils_get_element ((xmlNode*) _tmp1_, "root", "device", "friendlyName", NULL);
	element = _tmp2_;
	_vala_assert (element != NULL, "element != null");
	_tmp3_ = xmlNodeGetContent (element);
	result = _tmp3_;
	return result;
}


/**
     * Set the Unique Device Name of the device.
     *
     * Unique Device Name is the UUID of this particular device instance.
     *
     * @param udn is the Unique Device Name of the device.
     */
void rygel_description_file_set_udn (RygelDescriptionFile* self, const gchar* udn) {
	const gchar* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (udn != NULL);
	_tmp0_ = udn;
	rygel_description_file_set_device_element (self, "UDN", _tmp0_, NULL);
}


/**
     * Get the current UDN of the device.
     *
     * @return The currenly set UDN.
     */
gchar* rygel_description_file_get_udn (RygelDescriptionFile* self) {
	gchar* result = NULL;
	xmlNode* element = NULL;
	GUPnPXMLDoc* _tmp0_ = NULL;
	xmlDoc* _tmp1_ = NULL;
	xmlNode* _tmp2_ = NULL;
	xmlNode* _tmp3_ = NULL;
	xmlNode* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->doc;
	_tmp1_ = _tmp0_->doc;
	_tmp2_ = rygel_xml_utils_get_element ((xmlNode*) _tmp1_, "root", "device", "UDN", NULL);
	element = _tmp2_;
	_tmp3_ = element;
	if (_tmp3_ == NULL) {
		result = NULL;
		return result;
	}
	_tmp4_ = element;
	_tmp5_ = xmlNodeGetContent (_tmp4_);
	result = _tmp5_;
	return result;
}


/**
     * Set the DLNA caps of this root device and while taking the
     * capabilities of the plugin into account.
     *
     * @param capabilities RygelPluginCapabilities flags
     */
static void _vala_array_add1 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _vala_array_add2 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _vala_array_add3 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _vala_array_add4 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _vala_array_add5 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _vala_array_add6 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _vala_array_add7 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


void rygel_description_file_set_dlna_caps (RygelDescriptionFile* self, RygelPluginCapabilities capabilities) {
	gchar** flags = NULL;
	gchar** _tmp0_ = NULL;
	gint flags_length1 = 0;
	gint _flags_size_ = 0;
	RygelPluginCapabilities _tmp1_ = 0;
	RygelPluginCapabilities _tmp22_ = 0;
	gboolean _tmp27_ = FALSE;
	RygelPluginCapabilities _tmp28_ = 0;
	gboolean _tmp30_ = FALSE;
	gchar** _tmp33_ = NULL;
	gint _tmp33__length1 = 0;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_new0 (gchar*, 0 + 1);
	flags = _tmp0_;
	flags_length1 = 0;
	_flags_size_ = flags_length1;
	_tmp1_ = capabilities;
	if ((RYGEL_PLUGIN_CAPABILITIES_UPLOAD & _tmp1_) != 0) {
		gboolean allow_upload = FALSE;
		gboolean allow_delete = FALSE;
		gboolean _tmp9_ = FALSE;
		gboolean _tmp19_ = FALSE;
		allow_upload = TRUE;
		allow_delete = FALSE;
		{
			RygelMetaConfig* config = NULL;
			RygelMetaConfig* _tmp2_ = NULL;
			gboolean _tmp3_ = FALSE;
			RygelMetaConfig* _tmp4_ = NULL;
			gboolean _tmp5_ = FALSE;
			gboolean _tmp6_ = FALSE;
			RygelMetaConfig* _tmp7_ = NULL;
			gboolean _tmp8_ = FALSE;
			_tmp2_ = rygel_meta_config_get_default ();
			config = _tmp2_;
			_tmp4_ = config;
			_tmp5_ = rygel_configuration_get_allow_upload ((RygelConfiguration*) _tmp4_, &_inner_error_);
			_tmp3_ = _tmp5_;
			if (_inner_error_ != NULL) {
				_g_object_unref0 (config);
				goto __catch0_g_error;
			}
			allow_upload = _tmp3_;
			_tmp7_ = config;
			_tmp8_ = rygel_configuration_get_allow_deletion ((RygelConfiguration*) _tmp7_, &_inner_error_);
			_tmp6_ = _tmp8_;
			if (_inner_error_ != NULL) {
				_g_object_unref0 (config);
				goto __catch0_g_error;
			}
			allow_delete = _tmp6_;
			_g_object_unref0 (config);
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* _error_ = NULL;
			_error_ = _inner_error_;
			_inner_error_ = NULL;
			_g_error_free0 (_error_);
		}
		__finally0:
		if (_inner_error_ != NULL) {
			flags = (_vala_array_free (flags, flags_length1, (GDestroyNotify) g_free), NULL);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp9_ = allow_upload;
		if (_tmp9_) {
			RygelPluginCapabilities _tmp10_ = 0;
			RygelPluginCapabilities _tmp13_ = 0;
			RygelPluginCapabilities _tmp16_ = 0;
			_tmp10_ = capabilities;
			if ((_tmp10_ & RYGEL_PLUGIN_CAPABILITIES_IMAGE_UPLOAD) == RYGEL_PLUGIN_CAPABILITIES_IMAGE_UPLOAD) {
				gchar** _tmp11_ = NULL;
				gint _tmp11__length1 = 0;
				gchar* _tmp12_ = NULL;
				_tmp11_ = flags;
				_tmp11__length1 = flags_length1;
				_tmp12_ = g_strdup ("image-upload");
				_vala_array_add1 (&flags, &flags_length1, &_flags_size_, _tmp12_);
			}
			_tmp13_ = capabilities;
			if ((_tmp13_ & RYGEL_PLUGIN_CAPABILITIES_VIDEO_UPLOAD) == RYGEL_PLUGIN_CAPABILITIES_VIDEO_UPLOAD) {
				gchar** _tmp14_ = NULL;
				gint _tmp14__length1 = 0;
				gchar* _tmp15_ = NULL;
				_tmp14_ = flags;
				_tmp14__length1 = flags_length1;
				_tmp15_ = g_strdup ("av-upload");
				_vala_array_add2 (&flags, &flags_length1, &_flags_size_, _tmp15_);
			}
			_tmp16_ = capabilities;
			if ((_tmp16_ & RYGEL_PLUGIN_CAPABILITIES_AUDIO_UPLOAD) == RYGEL_PLUGIN_CAPABILITIES_AUDIO_UPLOAD) {
				gchar** _tmp17_ = NULL;
				gint _tmp17__length1 = 0;
				gchar* _tmp18_ = NULL;
				_tmp17_ = flags;
				_tmp17__length1 = flags_length1;
				_tmp18_ = g_strdup ("audio-upload");
				_vala_array_add3 (&flags, &flags_length1, &_flags_size_, _tmp18_);
			}
		}
		_tmp19_ = allow_delete;
		if (_tmp19_) {
			gchar** _tmp20_ = NULL;
			gint _tmp20__length1 = 0;
			gchar* _tmp21_ = NULL;
			_tmp20_ = flags;
			_tmp20__length1 = flags_length1;
			_tmp21_ = g_strdup ("create-item-with-OCM-destroy-item");
			_vala_array_add4 (&flags, &flags_length1, &_flags_size_, _tmp21_);
		}
	}
	_tmp22_ = capabilities;
	if ((_tmp22_ & RYGEL_PLUGIN_CAPABILITIES_TRACK_CHANGES) == RYGEL_PLUGIN_CAPABILITIES_TRACK_CHANGES) {
		gchar** _tmp23_ = NULL;
		gint _tmp23__length1 = 0;
		gchar* _tmp24_ = NULL;
		gchar** _tmp25_ = NULL;
		gint _tmp25__length1 = 0;
		gchar* _tmp26_ = NULL;
		_tmp23_ = flags;
		_tmp23__length1 = flags_length1;
		_tmp24_ = g_strdup ("content-synchronization");
		_vala_array_add5 (&flags, &flags_length1, &_flags_size_, _tmp24_);
		_tmp25_ = flags;
		_tmp25__length1 = flags_length1;
		_tmp26_ = g_strdup ("create-child-container");
		_vala_array_add6 (&flags, &flags_length1, &_flags_size_, _tmp26_);
	}
	_tmp28_ = capabilities;
	if ((_tmp28_ & RYGEL_PLUGIN_CAPABILITIES_CREATE_CONTAINERS) == RYGEL_PLUGIN_CAPABILITIES_CREATE_CONTAINERS) {
		RygelPluginCapabilities _tmp29_ = 0;
		_tmp29_ = capabilities;
		_tmp27_ = !((_tmp29_ & RYGEL_PLUGIN_CAPABILITIES_TRACK_CHANGES) == RYGEL_PLUGIN_CAPABILITIES_TRACK_CHANGES);
	} else {
		_tmp27_ = FALSE;
	}
	_tmp30_ = _tmp27_;
	if (_tmp30_) {
		gchar** _tmp31_ = NULL;
		gint _tmp31__length1 = 0;
		gchar* _tmp32_ = NULL;
		_tmp31_ = flags;
		_tmp31__length1 = flags_length1;
		_tmp32_ = g_strdup ("create-child-container");
		_vala_array_add7 (&flags, &flags_length1, &_flags_size_, _tmp32_);
	}
	_tmp33_ = flags;
	_tmp33__length1 = flags_length1;
	if (_tmp33__length1 > 0) {
		gchar* content = NULL;
		gchar** _tmp34_ = NULL;
		gint _tmp34__length1 = 0;
		gchar* _tmp35_ = NULL;
		const gchar* _tmp36_ = NULL;
		_tmp34_ = flags;
		_tmp34__length1 = flags_length1;
		_tmp35_ = g_strjoinv (",", _tmp34_);
		content = _tmp35_;
		_tmp36_ = content;
		rygel_description_file_set_device_element (self, "X_DLNACAP", _tmp36_, "dlna");
		_g_free0 (content);
	} else {
		rygel_description_file_remove_device_element (self, "X_DLNACAP");
	}
	flags = (_vala_array_free (flags, flags_length1, (GDestroyNotify) g_free), NULL);
}


void rygel_description_file_clear_service_list (RygelDescriptionFile* self) {
	g_return_if_fail (self != NULL);
	rygel_description_file_remove_device_element (self, "serviceList");
}


void rygel_description_file_add_service (RygelDescriptionFile* self, const gchar* device_name, RygelResourceInfo* resource_info) {
	xmlNode* list = NULL;
	GUPnPXMLDoc* _tmp0_ = NULL;
	xmlDoc* _tmp1_ = NULL;
	xmlNode* _tmp2_ = NULL;
	xmlNode* _tmp3_ = NULL;
	xmlNode* service_node = NULL;
	xmlNode* _tmp5_ = NULL;
	xmlNode* _tmp6_ = NULL;
	RygelResourceInfo* _tmp7_ = NULL;
	const gchar* _tmp8_ = NULL;
	RygelResourceInfo* _tmp9_ = NULL;
	const gchar* _tmp10_ = NULL;
	gchar* url = NULL;
	RygelResourceInfo* _tmp11_ = NULL;
	const gchar* _tmp12_ = NULL;
	gchar* _tmp13_ = NULL;
	const gchar* _tmp14_ = NULL;
	const gchar* _tmp15_ = NULL;
	gchar* _tmp16_ = NULL;
	gchar* _tmp17_ = NULL;
	gchar* _tmp18_ = NULL;
	gchar* _tmp19_ = NULL;
	RygelResourceInfo* _tmp20_ = NULL;
	GType _tmp21_ = 0UL;
	const gchar* _tmp22_ = NULL;
	gchar* _tmp23_ = NULL;
	const gchar* _tmp24_ = NULL;
	const gchar* _tmp25_ = NULL;
	gchar* _tmp26_ = NULL;
	gchar* _tmp27_ = NULL;
	gchar* _tmp28_ = NULL;
	gchar* _tmp29_ = NULL;
	RygelResourceInfo* _tmp30_ = NULL;
	GType _tmp31_ = 0UL;
	const gchar* _tmp32_ = NULL;
	gchar* _tmp33_ = NULL;
	const gchar* _tmp34_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (device_name != NULL);
	g_return_if_fail (resource_info != NULL);
	_tmp0_ = self->priv->doc;
	_tmp1_ = _tmp0_->doc;
	_tmp2_ = rygel_xml_utils_get_element ((xmlNode*) _tmp1_, "root", "device", "serviceList", NULL);
	list = _tmp2_;
	_tmp3_ = list;
	if (_tmp3_ == NULL) {
		xmlNode* _tmp4_ = NULL;
		_tmp4_ = rygel_description_file_set_device_element (self, "serviceList", NULL, NULL);
		list = _tmp4_;
	}
	_tmp5_ = list;
	_tmp6_ = xmlNewChild (_tmp5_, NULL, "service", NULL);
	service_node = _tmp6_;
	_tmp7_ = resource_info;
	_tmp8_ = _tmp7_->upnp_type;
	xmlNewChild (service_node, NULL, "serviceType", _tmp8_);
	_tmp9_ = resource_info;
	_tmp10_ = _tmp9_->upnp_id;
	xmlNewChild (service_node, NULL, "serviceId", _tmp10_);
	_tmp11_ = resource_info;
	_tmp12_ = _tmp11_->description_path;
	_tmp13_ = g_strconcat ("/", _tmp12_, NULL);
	url = _tmp13_;
	_tmp14_ = url;
	xmlNewChild (service_node, NULL, "SCPDURL", _tmp14_);
	_tmp15_ = device_name;
	_tmp16_ = g_strconcat ("/Control/", _tmp15_, NULL);
	_tmp17_ = _tmp16_;
	_tmp18_ = g_strconcat (_tmp17_, "/", NULL);
	_tmp19_ = _tmp18_;
	_tmp20_ = resource_info;
	_tmp21_ = _tmp20_->type;
	_tmp22_ = g_type_name (_tmp21_);
	_tmp23_ = g_strconcat (_tmp19_, _tmp22_, NULL);
	_g_free0 (url);
	url = _tmp23_;
	_g_free0 (_tmp19_);
	_g_free0 (_tmp17_);
	_tmp24_ = url;
	xmlNewChild (service_node, NULL, "controlURL", _tmp24_);
	_tmp25_ = device_name;
	_tmp26_ = g_strconcat ("/Event/", _tmp25_, NULL);
	_tmp27_ = _tmp26_;
	_tmp28_ = g_strconcat (_tmp27_, "/", NULL);
	_tmp29_ = _tmp28_;
	_tmp30_ = resource_info;
	_tmp31_ = _tmp30_->type;
	_tmp32_ = g_type_name (_tmp31_);
	_tmp33_ = g_strconcat (_tmp29_, _tmp32_, NULL);
	_g_free0 (url);
	url = _tmp33_;
	_g_free0 (_tmp29_);
	_g_free0 (_tmp27_);
	_tmp34_ = url;
	xmlNewChild (service_node, NULL, "eventSubURL", _tmp34_);
	_g_free0 (url);
}


void rygel_description_file_clear_icon_list (RygelDescriptionFile* self) {
	g_return_if_fail (self != NULL);
	rygel_description_file_remove_device_element (self, "iconList");
}


void rygel_description_file_add_icon (RygelDescriptionFile* self, const gchar* device_name, RygelIconInfo* icon_info, const gchar* url) {
	xmlNode* list = NULL;
	GUPnPXMLDoc* _tmp0_ = NULL;
	xmlDoc* _tmp1_ = NULL;
	xmlNode* _tmp2_ = NULL;
	xmlNode* _tmp3_ = NULL;
	xmlNode* icon_node = NULL;
	xmlNode* _tmp5_ = NULL;
	xmlNode* _tmp6_ = NULL;
	gchar* width = NULL;
	RygelIconInfo* _tmp7_ = NULL;
	gint _tmp8_ = 0;
	gchar* _tmp9_ = NULL;
	gchar* height = NULL;
	RygelIconInfo* _tmp10_ = NULL;
	gint _tmp11_ = 0;
	gchar* _tmp12_ = NULL;
	gchar* depth = NULL;
	RygelIconInfo* _tmp13_ = NULL;
	gint _tmp14_ = 0;
	gchar* _tmp15_ = NULL;
	RygelIconInfo* _tmp16_ = NULL;
	const gchar* _tmp17_ = NULL;
	const gchar* _tmp18_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (device_name != NULL);
	g_return_if_fail (icon_info != NULL);
	g_return_if_fail (url != NULL);
	_tmp0_ = self->priv->doc;
	_tmp1_ = _tmp0_->doc;
	_tmp2_ = rygel_xml_utils_get_element ((xmlNode*) _tmp1_, "root", "device", "iconList", NULL);
	list = _tmp2_;
	_tmp3_ = list;
	if (_tmp3_ == NULL) {
		xmlNode* _tmp4_ = NULL;
		_tmp4_ = rygel_description_file_set_device_element (self, "iconList", NULL, NULL);
		list = _tmp4_;
	}
	_tmp5_ = list;
	_tmp6_ = xmlNewChild (_tmp5_, NULL, "icon", NULL);
	icon_node = _tmp6_;
	_tmp7_ = icon_info;
	_tmp8_ = _tmp7_->width;
	_tmp9_ = g_strdup_printf ("%i", _tmp8_);
	width = _tmp9_;
	_tmp10_ = icon_info;
	_tmp11_ = _tmp10_->height;
	_tmp12_ = g_strdup_printf ("%i", _tmp11_);
	height = _tmp12_;
	_tmp13_ = icon_info;
	_tmp14_ = _tmp13_->depth;
	_tmp15_ = g_strdup_printf ("%i", _tmp14_);
	depth = _tmp15_;
	_tmp16_ = icon_info;
	_tmp17_ = _tmp16_->mime_type;
	xmlNewChild (icon_node, NULL, "mimetype", _tmp17_);
	xmlNewChild (icon_node, NULL, "width", width);
	xmlNewChild (icon_node, NULL, "height", height);
	xmlNewChild (icon_node, NULL, "depth", depth);
	_tmp18_ = url;
	xmlNewChild (icon_node, NULL, "url", _tmp18_);
	_g_free0 (depth);
	_g_free0 (height);
	_g_free0 (width);
}


/**
     * Change the type of a service.
     *
     * Usually used to modify the service version, e.g. old_type =
     * "ContentDirectory:2" and new_type = "ContentDirectory:1".
     *
     * @param old_type is the current content of serviceType.
     * @param new_type is the content serviceType will be set to.
     */
void rygel_description_file_modify_service_type (RygelDescriptionFile* self, const gchar* old_type, const gchar* new_type) {
	xmlXPathContext* context = NULL;
	GUPnPXMLDoc* _tmp0_ = NULL;
	xmlDoc* _tmp1_ = NULL;
	xmlXPathContext* _tmp2_ = NULL;
	gchar* xpath = NULL;
	const gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	xmlXPathObject* xpath_object = NULL;
	xmlXPathObject* _tmp5_ = NULL;
	xmlXPathObjectType _tmp6_ = 0;
	xmlNodeSet* _tmp7_ = NULL;
	gboolean _tmp8_ = FALSE;
	xmlNodeSet* _tmp9_ = NULL;
	xmlNode* _tmp10_ = NULL;
	const gchar* _tmp11_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (old_type != NULL);
	g_return_if_fail (new_type != NULL);
	_tmp0_ = self->priv->doc;
	_tmp1_ = _tmp0_->doc;
	_tmp2_ = xmlXPathNewContext (_tmp1_);
	context = _tmp2_;
	_tmp3_ = old_type;
	_tmp4_ = g_strdup_printf (RYGEL_DESCRIPTION_FILE_SERVICE_TYPE_TEMPLATE, _tmp3_);
	xpath = _tmp4_;
	_tmp5_ = xmlXPathEvalExpression (xpath, context);
	xpath_object = _tmp5_;
	_vala_assert (xpath_object != NULL, "xpath_object != null");
	_tmp6_ = xpath_object->type;
	_vala_assert (_tmp6_ == XPATH_NODESET, "xpath_object->type == XPath.ObjectType.NODESET");
	_tmp7_ = xpath_object->nodesetval;
	_tmp8_ = xmlXPathNodeSetIsEmpty (_tmp7_);
	_vala_assert (!_tmp8_, "!xpath_object->nodesetval->is_empty ()");
	_tmp9_ = xpath_object->nodesetval;
	_tmp10_ = xmlXPathNodeSetItem (_tmp9_, 0);
	_tmp11_ = new_type;
	xmlNodeSetContent (_tmp10_, _tmp11_);
	xmlXPathFreeObject (xpath_object);
	_g_free0 (xpath);
	_xmlXPathFreeContext0 (context);
}


/**
     * Writes the current document to a file.
     *
     * It makes sure that the resulting file has the correct UTF-8 encoding
     * and does not have any kind of newlines. This is necessary as some
     * devices with broken XML parsers can't cope with UNIX newlines.
     * If a file with the same name exists it will be overwritten.
     *
     * @param path is a path to a file.
     * @throws GLib.Error if anything fails while creating the XML dump.
     */
static gchar* string_replace (const gchar* self, const gchar* old, const gchar* replacement) {
	gchar* result = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	{
		GRegex* regex = NULL;
		const gchar* _tmp0_ = NULL;
		gchar* _tmp1_ = NULL;
		gchar* _tmp2_ = NULL;
		GRegex* _tmp3_ = NULL;
		GRegex* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
		GRegex* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
		_tmp0_ = old;
		_tmp1_ = g_regex_escape_string (_tmp0_, -1);
		_tmp2_ = _tmp1_;
		_tmp3_ = g_regex_new (_tmp2_, 0, 0, &_inner_error_);
		_tmp4_ = _tmp3_;
		_g_free0 (_tmp2_);
		regex = _tmp4_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch1_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp6_ = regex;
		_tmp7_ = replacement;
		_tmp8_ = g_regex_replace_literal (_tmp6_, self, (gssize) (-1), 0, _tmp7_, 0, &_inner_error_);
		_tmp5_ = _tmp8_;
		if (_inner_error_ != NULL) {
			_g_regex_unref0 (regex);
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch1_g_regex_error;
			}
			_g_regex_unref0 (regex);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		result = _tmp5_;
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally1;
	__catch1_g_regex_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (e);
	}
	__finally1:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
}


void rygel_description_file_save (RygelDescriptionFile* self, const gchar* path, GError** error) {
	FILE* file = NULL;
	const gchar* _tmp0_ = NULL;
	FILE* _tmp1_ = NULL;
	gchar* message = NULL;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	FILE* _tmp4_ = NULL;
	gboolean _tmp5_ = FALSE;
	gchar* mem = NULL;
	gint len = 0;
	GUPnPXMLDoc* _tmp9_ = NULL;
	xmlDoc* _tmp10_ = NULL;
	gchar* _tmp11_ = NULL;
	gint _tmp12_ = 0;
	gint _tmp13_ = 0;
	gboolean _tmp14_ = FALSE;
	FILE* _tmp18_ = NULL;
	const gchar* _tmp19_ = NULL;
	gchar* _tmp20_ = NULL;
	gchar* _tmp21_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (path != NULL);
	_tmp0_ = path;
	_tmp1_ = g_fopen (_tmp0_, "w+");
	file = _tmp1_;
	_tmp2_ = _ ("Failed to write modified description to %s");
	_tmp3_ = g_strdup (_tmp2_);
	message = _tmp3_;
	_tmp4_ = file;
	_tmp5_ = G_UNLIKELY (_tmp4_ == NULL);
	if (_tmp5_) {
		const gchar* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
		GError* _tmp8_ = NULL;
		_tmp6_ = message;
		_tmp7_ = path;
		_tmp8_ = g_error_new (G_IO_ERROR, G_IO_ERROR_FAILED, _tmp6_, _tmp7_);
		_inner_error_ = _tmp8_;
		g_propagate_error (error, _inner_error_);
		_g_free0 (message);
		_fclose0 (file);
		return;
	}
	mem = NULL;
	len = -1;
	_tmp9_ = self->priv->doc;
	_tmp10_ = _tmp9_->doc;
	xmlDocDumpMemoryEnc (_tmp10_, &_tmp11_, &_tmp12_, "UTF-8");
	_g_free0 (mem);
	mem = _tmp11_;
	len = _tmp12_;
	_tmp13_ = len;
	_tmp14_ = G_UNLIKELY (_tmp13_ <= 0);
	if (_tmp14_) {
		const gchar* _tmp15_ = NULL;
		const gchar* _tmp16_ = NULL;
		GError* _tmp17_ = NULL;
		_tmp15_ = message;
		_tmp16_ = path;
		_tmp17_ = g_error_new (G_IO_ERROR, G_IO_ERROR_FAILED, _tmp15_, _tmp16_);
		_inner_error_ = _tmp17_;
		g_propagate_error (error, _inner_error_);
		_g_free0 (mem);
		_g_free0 (message);
		_fclose0 (file);
		return;
	}
	_tmp18_ = file;
	_tmp19_ = mem;
	_tmp20_ = string_replace (_tmp19_, "\n", "");
	_tmp21_ = _tmp20_;
	fputs (_tmp21_, _tmp18_);
	_g_free0 (_tmp21_);
	_g_free0 (mem);
	_g_free0 (message);
	_fclose0 (file);
}


static gint rygel_description_file_index_of_device_element (RygelDescriptionFile* self, const gchar* element) {
	gint result = 0;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (element != NULL, 0);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gboolean _tmp1_ = FALSE;
				gint _tmp3_ = 0;
				gchar** _tmp4_ = NULL;
				gint _tmp4__length1 = 0;
				gchar** _tmp5_ = NULL;
				gint _tmp5__length1 = 0;
				gint _tmp6_ = 0;
				const gchar* _tmp7_ = NULL;
				const gchar* _tmp8_ = NULL;
				_tmp1_ = _tmp0_;
				if (!_tmp1_) {
					gint _tmp2_ = 0;
					_tmp2_ = i;
					i = _tmp2_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp3_ = i;
				_tmp4_ = self->priv->device_elements;
				_tmp4__length1 = self->priv->device_elements_length1;
				if (!(_tmp3_ < _tmp4__length1)) {
					break;
				}
				_tmp5_ = self->priv->device_elements;
				_tmp5__length1 = self->priv->device_elements_length1;
				_tmp6_ = i;
				_tmp7_ = _tmp5_[_tmp6_];
				_tmp8_ = element;
				if (g_strcmp0 (_tmp7_, _tmp8_) == 0) {
					result = i;
					return result;
				}
			}
		}
	}
	result = -1;
	return result;
}


/**
     * Internal helper function to set an element to a new value,
     * creating it if needed.
     *
     * @param element below /root/device to be set.
     * @param new_value is the new content of that element.
     *
     * @returns the element that was modified (or created) or null
     */
static xmlNode* rygel_description_file_set_device_element (RygelDescriptionFile* self, const gchar* element, const gchar* new_value, const gchar* ns) {
	xmlNode* result = NULL;
	xmlNode* xml_element = NULL;
	GUPnPXMLDoc* _tmp0_ = NULL;
	xmlDoc* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	xmlNode* _tmp3_ = NULL;
	xmlNode* _tmp4_ = NULL;
	xmlNode* device_element = NULL;
	GUPnPXMLDoc* _tmp8_ = NULL;
	xmlDoc* _tmp9_ = NULL;
	xmlNode* _tmp10_ = NULL;
	xmlNs* xml_ns = NULL;
	const gchar* _tmp11_ = NULL;
	xmlNode* _tmp17_ = NULL;
	xmlNs* _tmp18_ = NULL;
	const gchar* _tmp19_ = NULL;
	const gchar* _tmp20_ = NULL;
	xmlNode* _tmp21_ = NULL;
	gint index = 0;
	const gchar* _tmp22_ = NULL;
	gint _tmp23_ = 0;
	gint _tmp24_ = 0;
	xmlNode* _tmp47_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (element != NULL, NULL);
	_tmp0_ = self->priv->doc;
	_tmp1_ = _tmp0_->doc;
	_tmp2_ = element;
	_tmp3_ = rygel_xml_utils_get_element ((xmlNode*) _tmp1_, "root", "device", _tmp2_, NULL);
	xml_element = _tmp3_;
	_tmp4_ = xml_element;
	if (_tmp4_ != NULL) {
		xmlNode* _tmp5_ = NULL;
		const gchar* _tmp6_ = NULL;
		xmlNode* _tmp7_ = NULL;
		_tmp5_ = xml_element;
		_tmp6_ = new_value;
		xmlNodeSetContent (_tmp5_, _tmp6_);
		_tmp7_ = xml_element;
		result = _tmp7_;
		return result;
	}
	_tmp8_ = self->priv->doc;
	_tmp9_ = _tmp8_->doc;
	_tmp10_ = rygel_xml_utils_get_element ((xmlNode*) _tmp9_, "root", "device", NULL);
	device_element = _tmp10_;
	xml_ns = NULL;
	_tmp11_ = ns;
	if (_tmp11_ != NULL) {
		GUPnPXMLDoc* _tmp12_ = NULL;
		xmlDoc* _tmp13_ = NULL;
		xmlNode* _tmp14_ = NULL;
		const gchar* _tmp15_ = NULL;
		xmlNs* _tmp16_ = NULL;
		_tmp12_ = self->priv->doc;
		_tmp13_ = _tmp12_->doc;
		_tmp14_ = device_element;
		_tmp15_ = ns;
		_tmp16_ = xmlSearchNs (_tmp13_, _tmp14_, _tmp15_);
		xml_ns = _tmp16_;
	}
	_tmp17_ = device_element;
	_tmp18_ = xml_ns;
	_tmp19_ = element;
	_tmp20_ = new_value;
	_tmp21_ = xmlNewChild (_tmp17_, _tmp18_, _tmp19_, _tmp20_);
	xml_element = _tmp21_;
	_tmp22_ = element;
	_tmp23_ = rygel_description_file_index_of_device_element (self, _tmp22_);
	index = _tmp23_;
	_tmp24_ = index;
	if (_tmp24_ > (-1)) {
		xmlNode* sibling = NULL;
		xmlNode* _tmp40_ = NULL;
		sibling = NULL;
		{
			gint _tmp25_ = 0;
			gboolean _tmp26_ = FALSE;
			_tmp25_ = index;
			index = _tmp25_ - 1;
			_tmp26_ = TRUE;
			while (TRUE) {
				gboolean _tmp27_ = FALSE;
				gint _tmp29_ = 0;
				GUPnPXMLDoc* _tmp30_ = NULL;
				xmlDoc* _tmp31_ = NULL;
				gchar** _tmp32_ = NULL;
				gint _tmp32__length1 = 0;
				gint _tmp33_ = 0;
				const gchar* _tmp34_ = NULL;
				xmlNode* _tmp35_ = NULL;
				xmlNode* _tmp36_ = NULL;
				_tmp27_ = _tmp26_;
				if (!_tmp27_) {
					gint _tmp28_ = 0;
					_tmp28_ = index;
					index = _tmp28_ - 1;
				}
				_tmp26_ = FALSE;
				_tmp29_ = index;
				if (!(_tmp29_ > 0)) {
					break;
				}
				_tmp30_ = self->priv->doc;
				_tmp31_ = _tmp30_->doc;
				_tmp32_ = self->priv->device_elements;
				_tmp32__length1 = self->priv->device_elements_length1;
				_tmp33_ = index;
				_tmp34_ = _tmp32_[_tmp33_];
				_tmp35_ = rygel_xml_utils_get_element ((xmlNode*) _tmp31_, "root", "device", _tmp34_, NULL);
				sibling = _tmp35_;
				_tmp36_ = sibling;
				if (_tmp36_ != NULL) {
					xmlNode* _tmp37_ = NULL;
					xmlNode* _tmp38_ = NULL;
					xmlNode* _tmp39_ = NULL;
					_tmp37_ = sibling;
					_tmp38_ = xml_element;
					_tmp39_ = xmlAddNextSibling (_tmp37_, _tmp38_);
					xml_element = _tmp39_;
					break;
				}
			}
		}
		_tmp40_ = sibling;
		if (_tmp40_ == NULL) {
			xmlNode* _tmp41_ = NULL;
			xmlNode* _tmp42_ = NULL;
			xmlNode* _tmp43_ = NULL;
			_tmp41_ = device_element;
			_tmp42_ = xmlFirstElementChild (_tmp41_);
			sibling = _tmp42_;
			_tmp43_ = sibling;
			if (_tmp43_ != NULL) {
				xmlNode* _tmp44_ = NULL;
				xmlNode* _tmp45_ = NULL;
				xmlNode* _tmp46_ = NULL;
				_tmp44_ = sibling;
				_tmp45_ = xml_element;
				_tmp46_ = xmlAddPrevSibling (_tmp44_, _tmp45_);
				xml_element = _tmp46_;
			}
		}
	}
	_tmp47_ = xml_element;
	result = _tmp47_;
	return result;
}


/**
     * Internal helper function to remove an element (if it exists).
     *
     * @param element below /root/device to be removed.
     */
static void rygel_description_file_remove_device_element (RygelDescriptionFile* self, const gchar* element) {
	xmlNode* xml_element = NULL;
	GUPnPXMLDoc* _tmp0_ = NULL;
	xmlDoc* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	xmlNode* _tmp3_ = NULL;
	xmlNode* _tmp4_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (element != NULL);
	_tmp0_ = self->priv->doc;
	_tmp1_ = _tmp0_->doc;
	_tmp2_ = element;
	_tmp3_ = rygel_xml_utils_get_element ((xmlNode*) _tmp1_, "root", "device", _tmp2_, NULL);
	xml_element = _tmp3_;
	_tmp4_ = xml_element;
	if (_tmp4_ != NULL) {
		xmlNode* _tmp5_ = NULL;
		xmlNode* _tmp6_ = NULL;
		_tmp5_ = xml_element;
		xmlUnlinkNode (_tmp5_);
		_tmp6_ = xml_element;
		xmlFreeNode (_tmp6_);
	}
}


static void rygel_description_file_class_init (RygelDescriptionFileClass * klass) {
	rygel_description_file_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RygelDescriptionFilePrivate));
	G_OBJECT_CLASS (klass)->finalize = rygel_description_file_finalize;
}


static void rygel_description_file_instance_init (RygelDescriptionFile * self) {
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	gchar* _tmp9_ = NULL;
	gchar* _tmp10_ = NULL;
	gchar* _tmp11_ = NULL;
	gchar* _tmp12_ = NULL;
	gchar* _tmp13_ = NULL;
	gchar* _tmp14_ = NULL;
	gchar** _tmp15_ = NULL;
	self->priv = RYGEL_DESCRIPTION_FILE_GET_PRIVATE (self);
	_tmp0_ = g_strdup ("deviceType");
	_tmp1_ = g_strdup ("friendlyName");
	_tmp2_ = g_strdup ("manufacturer");
	_tmp3_ = g_strdup ("manufacturerURL");
	_tmp4_ = g_strdup ("modelDescription");
	_tmp5_ = g_strdup ("modelName");
	_tmp6_ = g_strdup ("modelNumber");
	_tmp7_ = g_strdup ("modelURL");
	_tmp8_ = g_strdup ("serialNumber");
	_tmp9_ = g_strdup ("UDN");
	_tmp10_ = g_strdup ("UPC");
	_tmp11_ = g_strdup ("iconList");
	_tmp12_ = g_strdup ("serviceList");
	_tmp13_ = g_strdup ("deviceList");
	_tmp14_ = g_strdup ("presentationURL");
	_tmp15_ = g_new0 (gchar*, 15 + 1);
	_tmp15_[0] = _tmp0_;
	_tmp15_[1] = _tmp1_;
	_tmp15_[2] = _tmp2_;
	_tmp15_[3] = _tmp3_;
	_tmp15_[4] = _tmp4_;
	_tmp15_[5] = _tmp5_;
	_tmp15_[6] = _tmp6_;
	_tmp15_[7] = _tmp7_;
	_tmp15_[8] = _tmp8_;
	_tmp15_[9] = _tmp9_;
	_tmp15_[10] = _tmp10_;
	_tmp15_[11] = _tmp11_;
	_tmp15_[12] = _tmp12_;
	_tmp15_[13] = _tmp13_;
	_tmp15_[14] = _tmp14_;
	self->priv->device_elements = _tmp15_;
	self->priv->device_elements_length1 = 15;
	self->priv->_device_elements_size_ = self->priv->device_elements_length1;
}


static void rygel_description_file_finalize (GObject* obj) {
	RygelDescriptionFile * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_DESCRIPTION_FILE, RygelDescriptionFile);
	self->priv->device_elements = (_vala_array_free (self->priv->device_elements, self->priv->device_elements_length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 (self->priv->doc);
	G_OBJECT_CLASS (rygel_description_file_parent_class)->finalize (obj);
}


/**
 * Represents a device description document and offers methods for easy
 * manipulation of those.
 */
GType rygel_description_file_get_type (void) {
	static volatile gsize rygel_description_file_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_description_file_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelDescriptionFileClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_description_file_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelDescriptionFile), 0, (GInstanceInitFunc) rygel_description_file_instance_init, NULL };
		GType rygel_description_file_type_id;
		rygel_description_file_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelDescriptionFile", &g_define_type_info, 0);
		g_once_init_leave (&rygel_description_file_type_id__volatile, rygel_description_file_type_id);
	}
	return rygel_description_file_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



